# -*- coding: utf-8 -*-
from parser import *

class PersonalRecord:
    def __init__(self, soup):
        self._type = soup.type.text
        self._workout_type = parse_soup_by_tagname(soup, 'workouttype')
        self._value = float(soup.value.text)
    
    @property
    def type(self):
        return self._type
    @property
    def value(self):
        return self._value
    @property
    def workout_type(self):
        return self._workout_type
            