import xmlrpclib
import urllib2
import time

import crypt

class AuthenticationError(Exception):
	"""Raised when an operation encountered authentication issues."""
	pass

class PandoraConnection(object):
	rid = ""
	lid = ""
	authInfo = {}
	authToken = ""

	PROTOCOL_VERSION = 33
	BASE_URL_SECURE = "https://www.pandora.com/radio/xmlrpc/v%d?" % PROTOCOL_VERSION
	BASE_URL_RID_SECURE = BASE_URL_SECURE + "rid=%sP&method=%s"
	BASE_URL_LID_SECURE = BASE_URL_SECURE + "rid=%sP&lid=%s&method=%s"

	def __init__(self):
		self.rid = "%07i" % (time.time() % 1e7)
		self.timedelta = 0
		
	def sync(self):
		reqUrl = self.BASE_URL_RID_SECURE % (self.rid, "sync")

		req = xmlrpclib.dumps((), "misc.sync").replace("\n", "")
		enc = crypt.encryptString(req)
		
		u = urllib2.urlopen(reqUrl, enc)
		resp = u.read()
		u.close()
		
		try:
				parsed = xmlrpclib.loads(resp)
				cryptedTimestamp = parsed[0][0]
				decryptedTimestamp = crypt.decryptString(cryptedTimestamp)
				self.timedelta = int(time.time()) - int(decryptedTimestamp[4:-2])
		except xmlrpclib.Fault, fault:
				raise ValueError(str(fault))

	def authListener(self, user, pwd):
		# sync to server time
		self.sync()
		
		# now do real auth
		reqUrl = self.BASE_URL_RID_SECURE % (self.rid, "authenticateListener")
		
		try:
			result = self.doRequest(reqUrl, "listener.authenticateListener", user, pwd, "html5tuner", "", "", "HTML5", True)
		except:
			return False
		
		self.authInfo	= result
		self.authToken	= self.authInfo["authToken"]
		self.lid	= self.authInfo["listenerId"]
		return True
	
	def getStations(self):
		reqUrl = self.BASE_URL_LID_SECURE % (self.rid, self.lid, "getStations")
		return self.doRequest(reqUrl, "station.getStations", self.authToken)

	def getFragment(self, stationId=None, format="mp3"):
		reqUrl = self.BASE_URL_LID_SECURE % (self.rid, self.lid, "getFragment")
		songlist = self.doRequest(reqUrl, "playlist.getFragment", self.authToken, stationId, "0", "", "", format, "0", "0")
		
		# last 48 chars of URL encrypted, padded w/ 8 * '\x08'
		for i in range(len(songlist)):
			url = songlist[i]["audioURL"]
			url = url[:-48] + crypt.decryptString(url[-48:])[:-8]
			songlist[i]["audioURL"] = url
		
		self.curStation = stationId
		self.curFormat = format
		
		return songlist
	
	def doRequest(self, reqUrl, method, *args):
		args = (int(time.time()) - self.timedelta, ) + args
		req = xmlrpclib.dumps(args, method).replace("\n", "")
		enc = crypt.encryptString(req)
		
		u = urllib2.urlopen(reqUrl, enc)
		resp = u.read()
		u.close()
		
		try:
			parsed = xmlrpclib.loads(resp)
		except xmlrpclib.Fault, fault:
			print "Error:", fault.faultString
			print "Code:", fault.faultCode
			
			parts = fault.faultString.split("|")
			if len(parts) > 2:
				code = parts[-2]
				if code == "AUTH_INVALID_TOKEN":
					raise AuthenticationError()
				else:
					raise ValueError(code)
			else:
				raise ValueError(fault.faultString)
		
		return parsed[0][0]
	

if __name__ == "__main__":
	pandora = PandoraConnection()
	# pandora.sync()
	
	# read username
	print "Username: "
	username = raw_input()
	
	# read password
	print "Password: "
	password = raw_input()
	
	# authenticate
	# authenticate
	print "Authenthicated: " + str(pandora.authListener(username, password))
	
	# output stations (without QuickMix)
	print "users stations:"
	for station in pandora.getStations():
		if station['isQuickMix']: 
			quickmix = station
			continue
		print "\t" + station['stationName']
	
	# get one song from quickmix
	print "next song from quickmix:"
	next =  pandora.getFragment(quickmix)[0]['stationId']
	print next['artistSummary'] + ': ' + next['songTitle']
	print next['audioURL']
	
	# download it
	#u = urllib2.urlopen(next['audioURL'])
	#f = open('test.mp3', 'wb')
	#f.write(u.read())
	#f.close()
	#u.close()