from smtplib import SMTPResponseException, SMTP
import getpass
import socket
import sys
import time
from simplecommand import CommandException


def send_email(subject, message, sender_email='', sender_name='', rcpts=('root',), relay='localhost'):
    if not sender_email:
        sender_email = '%s@%s' % (getpass.getuser(), socket.getfqdn())

    if not sender_name:
        sender_name = 'Email Notifier @ %s' % sys.argv[0]

    sender = '%s <%s>' % (sender_name, sender_email)
    text = "\n%s\n\n  --\n  %s - %s - %s" % (message, sender_name, sender_email, time.ctime(time.time()))
    message = "From: %s\nTo: %s\nSubject: %s\n%s" % (sender, ", ".join(rcpts), subject, text)

    try:
        server = SMTP(relay)
        server.sendmail(sender, rcpts, message)
        server.quit()
        return True
    except SMTPResponseException as e:
        raise CommandException(e)
