import subprocess
import time
from simplecommand import CommandException
from simplecommand.log import logger
from simplecommand.ssh import get_ssh_command


def rsync(source, dest, user, host, port, keyfile):
    log = logger(name='rsync', logfile='/tmp/rsync_output.%s' % time.strftime("%Y%m%d%H%M%S"))
    ssh_cmd = get_ssh_command(
        user=user,
        host=host,
        port=port,
        keyfile=keyfile)

    rsync_cmd = "/usr/bin/rsync --recursive -av -e '%s' %s root@%s:%s 2>&1" % (ssh_cmd, source, host, dest)
    output = []

    try:
        process = subprocess.Popen(rsync_cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)

        while True:
            next_line = process.stdout.readline()
            is_done = process.poll()
            if next_line == '' and is_done is not None:
                break
            elif next_line == '\n' or next_line == '':
                continue
            output.append(next_line.strip())
            log.info('%s - %s' % (host, next_line.strip()))

        exitcode = process.returncode
        log.info('Exitcode for rsync was %s' % exitcode)
        return output, exitcode
    except OSError as e:
        raise CommandException(e)
