from subprocess import Popen, PIPE
import time
from simplecommand import CommandException
from simplecommand.log import logger


def run_command_over_ssh(username, host, port, keyfile, command):
    log = logger(name='ssh', logfile='/tmp/ssh_output.%s' % time.strftime("%Y%m%d%H%M%S"))
    ssh_cmd = get_ssh_command(user=username, host=host, port=port, keyfile=keyfile, command=command)
    output = []

    try:
        process = Popen(ssh_cmd, shell=True, stdout=PIPE)
        while True:
            next_line = process.stdout.readline()
            is_done = process.poll()
            if next_line == '' and is_done is not None:
                break
            elif next_line == '\n' or next_line == '':
                continue
            output.append(next_line.strip())
            log.info('%s - %s' % (host, next_line.strip()))
        exitcode = process.returncode
        log.info('Exitcode for %s was %s' % (command, exitcode))
        return output, exitcode
    except OSError as e:
        raise CommandException(e)


def get_ssh_command(user, host, port, keyfile='', command=''):
    ssh_options = ''
    ssh_options += ' -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no'
    ssh_options += ' -o ConnectTimeout=1             -o PasswordAuthentication=no'
    ssh_options += ' -A -x'
    ssh_options += ' -p %s' % port

    if keyfile:
        ssh_options += ' -i %s' % keyfile

    ssh_command = "/usr/bin/ssh %s %s@%s" % (ssh_options, user, host)
    if command:
        ssh_command += ' "%s"' % command
    return ssh_command
