import socket
from subprocess import check_call, CalledProcessError, PIPE


def confirm(msg='Are you sure? '):
    accept = ['Yes', 'yes', 'y', 'YES', 'jup', 'j', 'ju', 'please', 'yesman']
    user_input = raw_input('%s [y/N] > ' % msg)

    if user_input in accept:
        return True
    return False


def ping_host(host):
    command = "ping -c 1 -n -W 2 %s 2>&1" % host
    try:
        check_call(command, stdout=PIPE, shell=True)
    except (CalledProcessError, OSError):
        return False
    return True


def ping_port(host, port):
    try:
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.connect((host, port))
        s.shutdown(2)
    except socket.error:
        return False
    return True
