import logging


def logger(name, logfile, verbosity):
    level = {
        0: logging.ERROR,
        1: logging.WARNING,
        2: logging.INFO,
        3: logging.DEBUG
    }.get(verbosity, logging.DEBUG)

    log = logging.Logger(name=name)
    formatter = logging.Formatter("%(asctime)s %(name)s %(levelname)-7s %(message)s")

    ch = logging.StreamHandler()
    ch.setLevel(level=level)
    ch.setFormatter(formatter)
    log.addHandler(ch)

    fh = logging.FileHandler(logfile)
    fh.setLevel(level=level)
    fh.setFormatter(formatter)
    log.addHandler(fh)
    return log
