"""
# -*- coding: utf-8 -*-
#===============================================================================
#
# Copyright (C) 2013/2014 Laurent Champagnac
#
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#===============================================================================
"""

from distutils.core import setup
import re

from setuptools import find_packages


#===========================
# TOOLS
#===========================

def requirementRead(req_file):
    """
    Doc
    :param req_file: Doc
    :return: Doc
    """
    reqList = list()
    for rowBuffer in open(req_file).readlines():
        # Skip empty
        if len(rowBuffer.strip()) == 0:
            continue
            # Skip "- ..."
        if re.match("^-", rowBuffer):
            continue
            # Skip "# ..."
        if re.match("^#", rowBuffer):
            continue

        # Ok
        reqList.append(rowBuffer)
    return reqList

#===========================
# SETUP
#===========================

p_name = "python-sol"
p_author = "Laurent Champagnac"
p_email = "champagnac.laurent@gmail.com"
p_url = "https://github.com/Champax/python-sol"
p_version = "0.0.1"

setup(

    # Project details
    name=p_name,
    author=p_author,
    author_email=p_email,
    url=p_url,
    description=p_name + " APIs",

    # Version, format : Major.Minor.Revision
    version=p_version,

    # Packages
    packages=find_packages(exclude=["*_test*", "_*"]),
    include_package_data=True,

    # License & read me
    license=open("LICENSE.txt").read(),
    long_description=open("README.txt").read(),

    # Data files
    data_files=
    [
        ("", ["requirements_test.txt", "requirements.txt", "README.txt", "LICENSE.txt"]),
    ],

    # Classifiers
    classifiers=
    [
        "Development Status :: 3 - Alpha",
        "Environment :: Other Environment",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU General Public License v2 (GPLv2)",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python :: 2.7",
        "Topic :: Software Development :: Libraries",
    ],

    # Dependencies
    install_requires=requirementRead("requirements.txt"),

    # Dependencies : test
    tests_require=requirementRead("requirements_test.txt"),
)
