# packet types
TDS_QUERY = 1
TDS_LOGIN = 2
TDS_RPC = 3
TDS_REPLY = 4
TDS_CANCEL = 6
TDS_BULK = 7
TDS7_TRANS = 14 # transaction management
TDS_NORMAL = 15
TDS7_LOGIN = 16
TDS7_AUTH = 17
TDS71_PRELOGIN = 18
TDS71_SMP = 0x53


# mssql login options flags
# option_flag1_values
TDS_BYTE_ORDER_X86		= 0
TDS_CHARSET_ASCII		= 0
TDS_DUMPLOAD_ON 		= 0
TDS_FLOAT_IEEE_754		= 0
TDS_INIT_DB_WARN		= 0
TDS_SET_LANG_OFF		= 0
TDS_USE_DB_SILENT		= 0
TDS_BYTE_ORDER_68000	= 0x01
TDS_CHARSET_EBDDIC		= 0x02
TDS_FLOAT_VAX		= 0x04
TDS_FLOAT_ND5000		= 0x08
TDS_DUMPLOAD_OFF		= 0x10 #prevent BCP
TDS_USE_DB_NOTIFY		= 0x20
TDS_INIT_DB_FATAL		= 0x40
TDS_SET_LANG_ON		= 0x80

#enum option_flag2_values {
TDS_INIT_LANG_WARN		= 0
TDS_INTEGRATED_SECURTY_OFF	= 0
TDS_ODBC_OFF		= 0
TDS_USER_NORMAL		= 0 # SQL Server login
TDS_INIT_LANG_REQUIRED	= 0x01
TDS_ODBC_ON			= 0x02
TDS_TRANSACTION_BOUNDARY71	= 0x04 # removed in TDS 7.2
TDS_CACHE_CONNECT71		= 0x08 # removed in TDS 7.2
TDS_USER_SERVER		= 0x10 # reserved
TDS_USER_REMUSER		= 0x20 # DQ login
TDS_USER_SQLREPL		= 0x40 # replication login
TDS_INTEGRATED_SECURITY_ON	= 0x80

#enum option_flag3_values TDS 7.3+
TDS_RESTRICTED_COLLATION	= 0
TDS_CHANGE_PASSWORD		= 0x01
TDS_SEND_YUKON_BINARY_XML	= 0x02
TDS_REQUEST_USER_INSTANCE	= 0x04
TDS_UNKNOWN_COLLATION_HANDLING	= 0x08
TDS_ANY_COLLATION		= 0x10


TDS5_PARAMFMT2_TOKEN     =  32	# 0x20
TDS_LANGUAGE_TOKEN       =  33	# 0x21    TDS 5.0 only              */
TDS_ORDERBY2_TOKEN       =  34	# 0x22
TDS_ROWFMT2_TOKEN        =  97	# 0x61    TDS 5.0 only              */
TDS_LOGOUT_TOKEN         = 113	# 0x71    TDS 5.0 only? ct_close()  */
TDS_RETURNSTATUS_TOKEN   = 121	# 0x79
TDS_PROCID_TOKEN         = 124	# 0x7C    TDS 4.2 only - TDS_PROCID */
TDS7_RESULT_TOKEN        = 129	# 0x81    TDS 7.0 only              */
TDS7_COMPUTE_RESULT_TOKEN= 136	# 0x88    TDS 7.0 only              */
TDS_COLNAME_TOKEN        = 160	# 0xA0    TDS 4.2 only              */
TDS_COLFMT_TOKEN         = 161	# 0xA1    TDS 4.2 only - TDS_COLFMT */
TDS_DYNAMIC2_TOKEN       = 163	# 0xA3
TDS_TABNAME_TOKEN        = 164	# 0xA4
TDS_COLINFO_TOKEN        = 165	# 0xA5
TDS_OPTIONCMD_TOKEN   	 = 166	# 0xA6
TDS_COMPUTE_NAMES_TOKEN  = 167	# 0xA7
TDS_COMPUTE_RESULT_TOKEN = 168	# 0xA8
TDS_ORDERBY_TOKEN        = 169	# 0xA9    TDS_ORDER                 */
TDS_ERROR_TOKEN          = 170	# 0xAA
TDS_INFO_TOKEN           = 171	# 0xAB
TDS_PARAM_TOKEN          = 172	# 0xAC    RETURNVALUE?              */
TDS_LOGINACK_TOKEN       = 173	# 0xAD
TDS_CONTROL_TOKEN        = 174	# 0xAE    TDS_CONTROL               */
TDS_ROW_TOKEN            = 209	# 0xD1
TDS_NBC_ROW_TOKEN        = 210	# 0xD2    as of TDS 7.3.B           */ # not implemented */
TDS_CMP_ROW_TOKEN        = 211	# 0xD3
TDS5_PARAMS_TOKEN        = 215	# 0xD7    TDS 5.0 only              */
TDS_CAPABILITY_TOKEN     = 226	# 0xE2
TDS_ENVCHANGE_TOKEN      = 227	# 0xE3
TDS_EED_TOKEN            = 229	# 0xE5
TDS_DBRPC_TOKEN          = 230	# 0xE6
TDS5_DYNAMIC_TOKEN       = 231	# 0xE7    TDS 5.0 only              */
TDS5_PARAMFMT_TOKEN      = 236	# 0xEC    TDS 5.0 only              */
TDS_AUTH_TOKEN           = 237	# 0xED    TDS 7.0 only              */
TDS_RESULT_TOKEN         = 238	# 0xEE
TDS_DONE_TOKEN           = 253	# 0xFD    TDS_DONE                  */
TDS_DONEPROC_TOKEN       = 254	# 0xFE    TDS_DONEPROC              */
TDS_DONEINPROC_TOKEN     = 255	# 0xFF    TDS_DONEINPROC            */

# CURSOR support: TDS 5.0 only
TDS_CURCLOSE_TOKEN       = 128  # 0x80    TDS 5.0 only
TDS_CURDELETE_TOKEN      = 129  # 0x81    TDS 5.0 only
TDS_CURFETCH_TOKEN       = 130  # 0x82    TDS 5.0 only
TDS_CURINFO_TOKEN        = 131  # 0x83    TDS 5.0 only
TDS_CUROPEN_TOKEN        = 132  # 0x84    TDS 5.0 only
TDS_CURDECLARE_TOKEN     = 134  # 0x86    TDS 5.0 only


# environment type field
TDS_ENV_DATABASE  	= 1
TDS_ENV_LANG      	= 2
TDS_ENV_CHARSET   	= 3
TDS_ENV_PACKSIZE  	= 4
TDS_ENV_LCID        	= 5
TDS_ENV_SQLCOLLATION	= 7
TDS_ENV_BEGINTRANS	= 8
TDS_ENV_COMMITTRANS	= 9
TDS_ENV_ROLLBACKTRANS	= 10
TDS_ENV_ENLIST_DTC_TRANS = 11
TDS_ENV_DEFECT_TRANS    = 12
TDS_ENV_DB_MIRRORING_PARTNER = 13
TDS_ENV_PROMOTE_TRANS   = 15
TDS_ENV_TRANS_MANAGER_ADDR = 16
TDS_ENV_TRANS_ENDED     = 17
TDS_ENV_RESET_COMPLETION_ACK = 18
TDS_ENV_INSTANCE_INFO   = 19
TDS_ENV_ROUTING         = 20

# Microsoft internal stored procedure id's */
TDS_SP_CURSOR           =  1
TDS_SP_CURSOROPEN       =  2
TDS_SP_CURSORPREPARE    =  3
TDS_SP_CURSOREXECUTE    =  4
TDS_SP_CURSORPREPEXEC   =  5
TDS_SP_CURSORUNPREPARE  =  6
TDS_SP_CURSORFETCH      =  7
TDS_SP_CURSOROPTION     =  8
TDS_SP_CURSORCLOSE      =  9
TDS_SP_EXECUTESQL       = 10
TDS_SP_PREPARE          = 11
TDS_SP_EXECUTE          = 12
TDS_SP_PREPEXEC         = 13
TDS_SP_PREPEXECRPC      = 14
TDS_SP_UNPREPARE        = 15

# Flags returned in TDS_DONE token
TDS_DONE_FINAL 	= 0x00	#*< final result set, command completed successfully. */
TDS_DONE_MORE_RESULTS = 0x01	#*< more results follow */
TDS_DONE_ERROR 	= 0x02	#*< error occurred */
TDS_DONE_INXACT 	= 0x04	#*< transaction in progress */
TDS_DONE_PROC 	= 0x08	#*< results are from a stored procedure */
TDS_DONE_COUNT 	= 0x10	#*< count field in packet is valid */
TDS_DONE_CANCELLED 	= 0x20	#*< acknowledging an attention command (usually a cancel) */
TDS_DONE_EVENT 	= 0x40	#   part of an event notification. */
TDS_DONE_SRVERROR 	= 0x100	#*< SQL server server error */

# after the above flags, a TDS_DONE packet has a field describing the state of the transaction */
TDS_DONE_NO_TRAN 	= 0	# No transaction in effect */
TDS_DONE_TRAN_SUCCEED = 1	# Transaction completed successfully */
TDS_DONE_TRAN_PROGRESS= 2	# Transaction in progress */
TDS_DONE_STMT_ABORT 	= 3	# A statement aborted */
TDS_DONE_TRAN_ABORT 	= 4	# Transaction aborted */

#/* 
# * <rant> Sybase does an awful job of this stuff, non null ints of size 1 2 
# * and 4 have there own codes but nullable ints are lumped into INTN
# * sheesh! </rant>
# */
SYBCHAR = 47		#/* 0x2F */
SYBVARCHAR = 39         #/* 0x27 */
SYBINTN = 38		#/* 0x26 */
SYBINT1 = 48		#/* 0x30 */
SYBINT2 = 52		#/* 0x34 */
SYBINT4 = 56		#/* 0x38 */
SYBFLT8 = 62		#/* 0x3E */
SYBDATETIME = 61	#/* 0x3D */
SYBBIT = 50		#/* 0x32 */
SYBTEXT = 35		#/* 0x23 */
SYBNTEXT = 99		#/* 0x63 */
SYBIMAGE = 34		#/* 0x22 */
SYBMONEY4 = 122	        #/* 0x7A */
SYBMONEY = 60		#/* 0x3C */
SYBDATETIME4 = 58	#/* 0x3A */
SYBREAL = 59		#/* 0x3B */
SYBBINARY = 45		#/* 0x2D */
SYBVOID = 31		#/* 0x1F */
SYBVARBINARY = 37	#/* 0x25 */
SYBBITN = 104		#/* 0x68 */
SYBNUMERIC = 108	#/* 0x6C */
SYBDECIMAL = 106	#/* 0x6A */
SYBFLTN = 109		#/* 0x6D */
SYBMONEYN = 110	        #/* 0x6E */
SYBDATETIMN = 111	#/* 0x6F */

#/*
#* MS only types
#*/
SYBNVARCHAR = 103	#/* 0x67 */
SYBINT8 = 127		#/* 0x7F */
XSYBCHAR = 175		#/* 0xAF */
XSYBVARCHAR = 167	#/* 0xA7 */
XSYBNVARCHAR = 231	#/* 0xE7 */
XSYBNCHAR = 239	        #/* 0xEF */
XSYBVARBINARY = 165	#/* 0xA5 */
XSYBBINARY = 173	#/* 0xAD */
SYBUNIQUE = 36		#/* 0x24 */
SYBVARIANT = 98 	#/* 0x62 */
SYBMSUDT = 240		#/* 0xF0 */
SYBMSXML = 241		#/* 0xF1 */
SYBMSDATE = 40  	#/* 0x28 */
SYBMSTIME = 41  	#/* 0x29 */
SYBMSDATETIME2 = 42  	#/* 0x2a */
SYBMSDATETIMEOFFSET = 43#/* 0x2b */

#/*
#* Sybase only types
#*/
SYBLONGBINARY = 225	#/* 0xE1 */
SYBUINT1 = 64		#/* 0x40 */
SYBUINT2 = 65		#/* 0x41 */
SYBUINT4 = 66		#/* 0x42 */
SYBUINT8 = 67		#/* 0x43 */
SYBBLOB = 36		#/* 0x24 */
SYBBOUNDARY = 104	#/* 0x68 */
SYBDATE = 49		#/* 0x31 */
SYBDATEN = 123		#/* 0x7B */
SYB5INT8 = 191		#/* 0xBF */
SYBINTERVAL = 46	#/* 0x2E */
SYBLONGCHAR = 175	#/* 0xAF */
SYBSENSITIVITY = 103	#/* 0x67 */
SYBSINT1 = 176		#/* 0xB0 */
SYBTIME = 51		#/* 0x33 */
SYBTIMEN = 147		#/* 0x93 */
SYBUINTN = 68		#/* 0x44 */
SYBUNITEXT = 174	#/* 0xAE */
SYBXML = 163		#/* 0xA3 */

TDS_UT_TIMESTAMP = 80

# compute operator
SYBAOPCNT  = 0x4b
SYBAOPCNTU = 0x4c
SYBAOPSUM  = 0x4d
SYBAOPSUMU = 0x4e
SYBAOPAVG  = 0x4f
SYBAOPAVGU = 0x50
SYBAOPMIN  = 0x51
SYBAOPMAX  = 0x52

# mssql2k compute operator
SYBAOPCNT_BIG		= 0x09
SYBAOPSTDEV		= 0x30
SYBAOPSTDEVP		= 0x31
SYBAOPVAR		= 0x32
SYBAOPVARP		= 0x33
SYBAOPCHECKSUM_AGG	= 0x72

# param flags
fByRefValue = 1
fDefaultValue = 2
