/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.SMOreg;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.trees.J48;
import weka.core.Utils;

public class KernelHelper {
    public static PropertyDescriptor getKernelProperty(Object object) {
        PropertyDescriptor propertyDescriptor = null;
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor propertyDescriptor2 : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                Class<?> clazz;
                if (propertyDescriptor2.getWriteMethod() == null || propertyDescriptor2.getReadMethod() == null || (clazz = propertyDescriptor2.getReadMethod().getReturnType()) != Kernel.class) continue;
                propertyDescriptor = propertyDescriptor2;
                break;
            }
        }
        catch (Exception exception) {
            propertyDescriptor = null;
            System.err.println("Failed to process property descriptors:");
            exception.printStackTrace();
        }
        return propertyDescriptor;
    }

    public static boolean hasKernelProperty(Object object) {
        return KernelHelper.getKernelProperty(object) != null;
    }

    public static boolean setKernel(Object object, Kernel kernel) {
        boolean bl = false;
        PropertyDescriptor propertyDescriptor = KernelHelper.getKernelProperty(object);
        if (propertyDescriptor != null) {
            try {
                Method method = propertyDescriptor.getWriteMethod();
                method.invoke(object, kernel);
                bl = true;
            }
            catch (Exception exception) {
                System.err.println("Failed to set kernel:");
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static Kernel getKernel(Object object) {
        Kernel kernel = null;
        PropertyDescriptor propertyDescriptor = KernelHelper.getKernelProperty(object);
        if (propertyDescriptor != null) {
            try {
                Method method = propertyDescriptor.getReadMethod();
                kernel = (Kernel)method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                System.err.println("Failed to get kernel:");
                exception.printStackTrace();
            }
        }
        return kernel;
    }

    public static void main(String[] stringArray) throws Exception {
        RBFKernel rBFKernel = new RBFKernel();
        SMO sMO = new SMO();
        System.out.println("\n--> " + sMO.getClass().getName());
        System.out.println("has kernel? " + KernelHelper.hasKernelProperty(sMO));
        System.out.println("kernel: " + Utils.toCommandLine((Object)KernelHelper.getKernel(sMO)));
        System.out.println("set kernel? " + KernelHelper.setKernel(sMO, (Kernel)rBFKernel));
        System.out.println("kernel: " + Utils.toCommandLine((Object)KernelHelper.getKernel(sMO)));
        sMO = new SMOreg();
        System.out.println("\n--> " + sMO.getClass().getName());
        System.out.println("has kernel? " + KernelHelper.hasKernelProperty(sMO));
        System.out.println("kernel: " + Utils.toCommandLine((Object)KernelHelper.getKernel(sMO)));
        System.out.println("set kernel? " + KernelHelper.setKernel(sMO, (Kernel)rBFKernel));
        System.out.println("kernel: " + Utils.toCommandLine((Object)KernelHelper.getKernel(sMO)));
        sMO = new J48();
        System.out.println("\n--> " + sMO.getClass().getName());
        System.out.println("has kernel? " + KernelHelper.hasKernelProperty(sMO));
        System.out.println("kernel: " + Utils.toCommandLine((Object)KernelHelper.getKernel(sMO)));
        System.out.println("set kernel? " + KernelHelper.setKernel(sMO, (Kernel)rBFKernel));
        System.out.println("kernel: " + Utils.toCommandLine((Object)KernelHelper.getKernel(sMO)));
    }
}

