import os
import sys
from PyQt4 import pyqtconfig

if len(sys.argv) != 8:
    print 'usage: %s build-dir sip-file output_dir include_dirs libs lib_dirs ldflags' % (sys.argv[0])
    exit(1)

# The SIP build folder, the SIP file, the output directory, the include directories, the libraries, the library directories and the linker flags.
build_dir, sip_file, output_dir, include_dirs, libs, lib_dirs, ldflags = sys.argv[1:]

# The name of the SIP build file generated by SIP and used by the build system.
build_file = 'pyqtscripting.sbf'

# Get the PyQt configuration information.
config = pyqtconfig.Configuration()

# Get the extra SIP flags needed by the imported qt module.  Note that
# this normally only includes those flags (-x and -t) that relate to SIP's
# versioning system.
qt_sip_flags = config.pyqt_sip_flags

try:
    os.makedirs(build_dir)
except OSError:
    pass

# Run SIP to generate the code.  Note that we tell SIP where to find the qt
# module's specification files using the -I flag.
os.system(' '.join([
  config.sip_bin,
  '-c', build_dir,
  '-b', os.path.join(build_dir, build_file),
  '-I', config.pyqt_sip_dir,
  '-w',
  qt_sip_flags,
  sip_file
]))

# Create the Makefile.  The QtModuleMakefile class provided by the
# pyqtconfig module takes care of all the extra preprocessor, compiler and
# linker flags needed by the Qt library.
makefile = pyqtconfig.QtGuiModuleMakefile(
  dir=build_dir,
  configuration=config,
  build_file=build_file
)

# hack to override makefile behavior which always prepend -l to libraries which is wrong for absolute paths
default_platform_lib_function = pyqtconfig.QtGuiModuleMakefile.platform_lib


def custom_platform_lib_function(self, clib, framework=0):
    if os.path.isabs(clib):
        return clib
    return default_platform_lib_function(self, clib, framework)
pyqtconfig.QtGuiModuleMakefile.platform_lib = custom_platform_lib_function

for include_dir in include_dirs.split(' '):
    makefile.extra_include_dirs.append(include_dir)
for lib in libs.split(' '):
    makefile.extra_libs.append(lib)
for lib_dir in lib_dirs.split(' '):
    makefile.extra_lib_dirs.append(lib_dir)
for ldflag in ldflags.split('\\ '):
    makefile.LFLAGS.append(ldflag)

# redirect location of generated library
makefile._target = os.path.join(output_dir, makefile._target)

# Generate the Makefile itself
makefile.generate()
