"""
# -*- coding: utf-8 -*-
#====================================================================================================================
#
# Copyright (C) 2013/2014 Laurent Champagnac
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#====================================================================================================================
"""

# Logger
import logging
from pythonsol.SolBase import SolBase
from pythonsol.TcpServer.BaseFactory.TcpServerClientContextAbstractFactory import TcpServerClientContextAbstractFactory
from pythonsol.TcpServer.QueuedClientContext.TcpServerQueuedClientContext import TcpServerQueuedClientContext

SolBase.loggingInit()
logger = logging.getLogger("TcpServerQueuedClientContextFactory")


class TcpServerQueuedClientContextFactory(TcpServerClientContextAbstractFactory):
    """
    Default factory.
    """

    def getNewClientContext(self, tcpServer, clientId, clientSocket, clientAddr):
        """
        Return a new client context instance.
        :param tcpServer: The TcpServer instance.
        :param  clientId: an integer, which is the unique id of this client.
        :param  clientSocket: The server socket.
        :param  clientAddr: The remote addr information.
        :return Returned object MUST be a subclass of TcpServerClientContext.
        """
        return TcpServerQueuedClientContext(tcpServer, clientId, clientSocket, clientAddr)
