"""
# -*- coding: utf-8 -*-
#====================================================================================================================
#
# Copyright (C) 2013 Laurent Champagnac
#
# This program is free software: you can redistribute it and/or  modify
# it under the terms of the GNU Affero General Public License, version 3,
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#====================================================================================================================
"""

from distutils.core import setup
import re

from setuptools import find_packages


#===========================
# TOOLS
#===========================

def requirementRead(req_file):
    """
    Doc
    :param req_file: Doc
    :return: Doc
    """
    reqList = list()
    for rowBuffer in open(req_file).readlines():
        # Skip empty
        if len(rowBuffer.strip()) == 0:
            continue
            # Skip "- ..."
        if re.match("^-", rowBuffer):
            continue
            # Skip "# ..."
        if re.match("^#", rowBuffer):
            continue

        # Ok
        reqList.append(rowBuffer)
    return reqList

#===========================
# SETUP
#===========================

p_name = "pythonsol"
p_author = "Laurent Champagnac"
p_email = "champagnac.laurent@gmail.com"
p_url = "http://knock.center"
p_version = "0.0.6"

setup(

    # Project details
    name=p_name,
    author=p_author,
    author_email=p_email,
    url=p_url,
    description=p_name + " APIs",

    # Version, format : Major.Minor.Revision
    version=p_version,

    # Packages
    packages=find_packages(exclude=["*_test*", "_*"]),
    include_package_data=True,

    # License & read me
    license=open("LICENSE.txt").read(),
    long_description=open("README.txt").read(),

    # Data files
    data_files=
    [
        ("", ["requirements_test.txt", "requirements.txt", "README.txt", "LICENSE.txt"]),
    ],

    # Classifiers
    classifiers=
    [
        "Development Status :: 3 - Alpha",
        "Environment :: Other Environment",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU General Public License v2 (GPLv2)",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python :: 2.7",
        "Topic :: Software Development :: Libraries",
    ],

    # Dependencies
    install_requires=requirementRead("requirements.txt"),

    # Dependencies : test
    tests_require=requirementRead("requirements_test.txt"),
)
