"""
# -*- coding: utf-8 -*-
#===============================================================================
#
# Copyright (C) 2013/2014 Laurent Champagnac
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#===============================================================================
"""

from gevent.event import Event


class SignaledBuffer(object):
    """
    Send class for tcp, with signal upon send completion.
    """

    def __init__(self):
        """
        Constructor.
        """
        self.__buffer = None
        self.__sendEvent = Event()

    def __setBuffer(self, localBuffer):
        """
        Set the binary localBuffer.
        :param localBuffer: The binary localBuffer.
        :type localBuffer: str
        """
        self.__buffer = localBuffer

    def __getBuffer(self):
        """
        Getter
        :return: The binary localBuffer
        :rtype: str
        """
        return self.__buffer

    def __getEvent(self):
        """
        Get the event.
        :return: Event
        :rtype: Event
        """
        return self.__sendEvent

    binaryBuffer = property(__getBuffer, __setBuffer)
    sendEvent = property(__getEvent)

