#ifndef PYTHONIC_PP_H
#define PYTHONIC_PP_H

/* core */
#include "core/utils.h"
#include "core/functional.h"
#include "core/none.h"
#include "core/list.h"
#include "core/tuple.h"
#include "core/string.h"
#include "core/exceptions.h"
#include "core/iterator.h"
#include "core/set.h"
#include "core/dict.h"
#include "core/tuple.h"
#include "core/ndarray.h"
#include "core/finfo.h"
#include "core/io.h"
#include "core/file.h"
#include "core/intrinsics.h"
#include "core/assert.h"


/* additional modules */
#include "modules/dispatch.h"
#include "modules/float.h"
#include "modules/list.h"
#include "modules/set.h"
#include "modules/dict.h"
#include "modules/complex.h"
#include "modules/math.h"
#include "modules/cmath.h"
#include "modules/random.h"
#include "modules/iterator.h"
#include "modules/string.h"
#include "modules/file.h"
#include "modules/time.h"
#include "modules/omp.h"
#include "modules/itertools.h"
#include "modules/bisect.h"
#include "modules/operator.h"

/* numpy's expression template */
#include "core/numpy_expr.h"
#include "modules/numpy.h"
#include "modules/ndarray.h"
#include "modules/finfo.h"

/* extensions */
#include "core/parallel.h"

#endif
