//==============================================================================
//         Copyright 2003 - 2011   LASMEA UMR 6602 CNRS/Univ. Clermont II
//         Copyright 2009 - 2011   LRI    UMR 8623 CNRS/Univ Paris Sud XI
//
//          Distributed under the Boost Software License, Version 1.0.
//                 See accompanying file LICENSE.txt or copy at
//                     http://www.boost.org/LICENSE_1_0.txt
//==============================================================================
#ifndef NT2_CORE_FUNCTIONS_EXPR_TSXFUN_HPP_INCLUDED
#define NT2_CORE_FUNCTIONS_EXPR_TSXFUN_HPP_INCLUDED

#include <nt2/core/functions/tsxfun.hpp>
#include <nt2/core/container/dsl.hpp>

namespace nt2 { namespace ext
{
  //============================================================================
  // Generates  from a 2ary thing and 3 expressions
  //============================================================================
  NT2_FUNCTOR_IMPLEMENTATION( nt2::tag::tsxfun_, tag::cpu_,
                              (A0)(A1)(A2)(A3),
                              (unspecified_<A0>)
                              ((ast_<A1, nt2::container::domain>))
                              ((ast_<A2, nt2::container::domain>))
                              ((ast_<A3, nt2::container::domain>))
                            )
  {
    typedef typename  boost::proto::
                      result_of::make_expr< nt2::tag::tsxfun_
                                          , container::domain
                                          , A1 const&
                                          , A2 const&
                                          , A3 const&
                                          , box<A0>
                                          >::type             result_type;

    BOOST_FORCEINLINE result_type operator()(A0 const& a0,
                                             A1 const& a1,
                                             A2 const& a2,
                                             A3 const& a3) const
    {
      return  boost::proto::
              make_expr<nt2::tag::tsxfun_, container::domain>
              ( boost::cref(a1)
              , boost::cref(a2)
              , boost::cref(a3)
              , boxify(a0)
              );
    }
  };

  //============================================================================
  // Generates from a 3ary thing, 2 expression and a scalar
  //============================================================================
  NT2_FUNCTOR_IMPLEMENTATION( nt2::tag::tsxfun_, tag::cpu_,
                              (A0)(A1)(A2)(A3),
                              (unspecified_<A0>)
                              ((ast_<A1, nt2::container::domain>))
                              (scalar_< unspecified_<A2> >)
                              ((ast_<A3, nt2::container::domain>))
                            )
  {
    typedef typename  boost::proto::
                      result_of::make_expr< nt2::tag::tsxfun_
                                          , container::domain
                                          , A1 const&
                                          , A2
                                          , A3 const&
                                          , box<A0>
                                          >::type             result_type;

    BOOST_FORCEINLINE result_type operator()(A0 const& a0,
                                             A1 const& a1,
                                             A2 const& a2,
                                             A3 const& a3) const
    {
      return  boost::proto::
              make_expr<nt2::tag::tsxfun_, container::domain>
              ( boost::cref(a1)
              , a2
              , boost::cref(a3)
              , boxify(a0)
              );
    }
  };

  NT2_FUNCTOR_IMPLEMENTATION( nt2::tag::tsxfun_, tag::cpu_,
                              (A0)(A1)(A2)(A3),
                              (unspecified_<A0>)
                              ((ast_<A1, nt2::container::domain>))
                              ((ast_<A2, nt2::container::domain>))
                              (scalar_< unspecified_<A3> >)
                            )
  {
    typedef typename  boost::proto::
                      result_of::make_expr< nt2::tag::tsxfun_
                                          , container::domain
                                          , A1 const&
                                          , A2 const&
                                          , A3
                                          , box<A0>
                                          >::type             result_type;

    BOOST_FORCEINLINE result_type operator()(A0 const& a0,
                                             A1 const& a1,
                                             A2 const& a2,
                                             A3 const& a3) const
    {
      return  boost::proto::
              make_expr<nt2::tag::tsxfun_, container::domain>
              ( boost::cref(a1)
              , boost::cref(a2)
              , a3
              , boxify(a0)
              );
    }
  };

  NT2_FUNCTOR_IMPLEMENTATION( nt2::tag::tsxfun_, tag::cpu_,
                              (A0)(A1)(A2)(A3),
                              (unspecified_<A0>)
                              (scalar_< unspecified_<A1> >)
                              ((ast_<A2, nt2::container::domain>))
                              ((ast_<A3, nt2::container::domain>))
                            )
  {
    typedef typename  boost::proto::
                      result_of::make_expr< nt2::tag::tsxfun_
                                          , container::domain
                                          , A1
                                          , A2 const&
                                          , A3 const&
                                          , box<A0>
                                          >::type             result_type;

    BOOST_FORCEINLINE result_type operator()(A0 const& a0,
                                             A1 const& a1,
                                             A2 const& a2,
                                             A3 const& a3) const
    {
      return  boost::proto::
              make_expr<nt2::tag::tsxfun_, container::domain>
              ( a1
              , boost::cref(a2)
              , boost::cref(a3)
              , boxify(a0)
              );
    }
  };


  NT2_FUNCTOR_IMPLEMENTATION( nt2::tag::tsxfun_, tag::cpu_,
                              (A0)(A1)(A2)(A3),
                              (unspecified_<A0>)
                              (scalar_< unspecified_<A1> >)
                              (scalar_< unspecified_<A2> >)
                              ((ast_<A3, nt2::container::domain>))
                            )
  {
    typedef typename  boost::proto::
                      result_of::make_expr< nt2::tag::tsxfun_
                                          , container::domain
                                          , A1
                                          , A2
                                          , A3 const&
                                          , box<A0>
                                          >::type             result_type;

    BOOST_FORCEINLINE result_type operator()(A0 const& a0,
                                             A1 const& a1,
                                             A2 const& a2,
                                             A3 const& a3) const
    {
      return  boost::proto::
        make_expr<nt2::tag::tsxfun_, container::domain>
        ( a1
        , a2
        , boost::cref(a3)
        , boxify(a0)
        );
    }
  };

  NT2_FUNCTOR_IMPLEMENTATION( nt2::tag::tsxfun_, tag::cpu_,
                              (A0)(A1)(A2)(A3),
                              (unspecified_<A0>)
                              (scalar_< unspecified_<A1> >)
                              ((ast_<A2, nt2::container::domain>))
                              (scalar_< unspecified_<A3> >)
                            )
  {
    typedef typename  boost::proto::
                      result_of::make_expr< nt2::tag::tsxfun_
                                          , container::domain
                                          , A1
                                          , A2 const&
                                          , A3
                                          , box<A0>
                                          >::type             result_type;

    BOOST_FORCEINLINE result_type operator()(A0 const& a0,
                                             A1 const& a1,
                                             A2 const& a2,
                                             A3 const& a3) const
    {
      return  boost::proto::
        make_expr<nt2::tag::tsxfun_, container::domain>
        ( a1
          , boost::cref(a2)
          , a3
          , boxify(a0)
          );
    }
  };

  NT2_FUNCTOR_IMPLEMENTATION( nt2::tag::tsxfun_, tag::cpu_,
                              (A0)(A1)(A2)(A3),
                              (unspecified_<A0>)
                              ((ast_<A1, nt2::container::domain>))
                              (scalar_< unspecified_<A2> >)
                              (scalar_< unspecified_<A3> >)
                            )
  {
    typedef typename  boost::proto::
                      result_of::make_expr< nt2::tag::tsxfun_
                                          , container::domain
                                          , A1 const&
                                          , A2
                                          , A3
                                          , box<A0>
                                          >::type             result_type;

    BOOST_FORCEINLINE result_type operator()(A0 const& a0,
                                             A1 const& a1,
                                             A2 const& a2,
                                             A3 const& a3) const
    {
      return  boost::proto::
        make_expr<nt2::tag::tsxfun_, container::domain>
        ( boost::cref(a1)
        , a2
        , a3
        , boxify(a0)
        );
    }
  };
} }

#endif
