//==============================================================================
//         Copyright 2003 - 2011   LASMEA UMR 6602 CNRS/Univ. Clermont II
//         Copyright 2009 - 2011   LRI    UMR 8623 CNRS/Univ Paris Sud XI
//
//          Distributed under the Boost Software License, Version 1.0.
//                 See accompanying file LICENSE.txt or copy at
//                     http://www.boost.org/LICENSE_1_0.txt
//==============================================================================
#ifndef NT2_CONSTANT_CONSTANTS_MNINE_HPP_INCLUDED
#define NT2_CONSTANT_CONSTANTS_MNINE_HPP_INCLUDED

#include <boost/simd/constant/include/constants/mnine.hpp>
#include <nt2/include/functor.hpp>

namespace nt2
{
  namespace tag
  {
    #ifdef DOXYGEN_ONLY
    /*! \brief Same as \classref{boost::simd::tag::Mnine_} **/
    struct mnine_ {};
    #endif
    using boost::simd::tag::Mnine;
  }

  #ifdef DOXYGEN_ONLY
  /*! \brief Same as \funcref{boost::simd::Mnine} **/
  template<class... Args>
  details::unspecified mnine(Args&&... args);
  #endif
  using boost::simd::Mnine;
}

#include <nt2/constant/common.hpp>

#endif
