#ifndef PYTHONIC_NUMPY_LOGADDEXP_HPP
#define PYTHONIC_NUMPY_LOGADDEXP_HPP

#include "pythonic/utils/proxy.hpp"
#include"pythonic/types/ndarray.hpp"
#include "pythonic/utils/numpy_traits.hpp"
#include "pythonic/types/numpy_broadcast.hpp"

#include <nt2/include/functions/log.hpp>
#include <nt2/include/functions/exp.hpp>

namespace pythonic {

    namespace numpy {
        namespace wrapper {
        template<class T0, class T1>
            auto logaddexp(T0 const& t0, T1 const& t1) -> decltype(nt2::log(nt2::exp(t0) + nt2::exp(t1))) {
                return nt2::log(nt2::exp(t0) + nt2::exp(t1));
            }

        }
#define NUMPY_BINARY_FUNC_NAME logaddexp
#define NUMPY_BINARY_FUNC_SYM wrapper::logaddexp
#include "pythonic/types/numpy_binary_expr.hpp"

    }

}

#endif

