# Copyright (C) 2010 Tim Diels <limyreth@users.sourceforge.net>
# 
# This file is part of pytilities.
# 
# pytilities is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# pytilities is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with pytilities.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Delegation utilities

Classes:

    `Dispatcher`
        Utility class for dispatching events to handlers.

    `DispatcherSwitch`
        Provides a single interface to multiple event dispatchers.

    `RestrictedDispatcher`
        `Dispatcher` wrapper that filters the list of supported events.

Decorators:

    `dispatcher`
        Installs a `Dispatcher` on an `AttributeCollectionBase`.

    `dispatcher_switch`
        Installs a `DispatcherSwitch` on an `AttributeCollectionBase`.
"""

__docformat__ = 'reStructuredText'

from .dispatcher_ import Dispatcher, UnsupportedEventError
from .dispatcherswitch import DispatcherSwitch
from .restricteddispatcher import RestrictedDispatcher
from .decorators import dispatcher, dispatcher_switch

