from distutils.core import setup

setup(
    name = 'pytilities',
    packages = ['pytilities', 'pytilities.event', 'pytilities.types', 'pytilities.descriptors', 'pytilities.overloading', 'pytilities.delegation', 'pytilities.aop', 'pytilities.aop.aspects', 'pytilities.test', 'pytilities.test.event', 'pytilities.test.types', 'pytilities.test.infinity', 'pytilities.test.tests', 'pytilities.test.descriptors', 'pytilities.test.overloading', 'pytilities.test.delegation', 'pytilities.test.delegation.delegationaspect', 'pytilities.test.delegation.mapped', 'pytilities.test.aop', 'pytilities.test.aop.aspects', 'pytilities.test.dictionary', 'pytilities.test.functions', 'pytilities.test.geometry', 'pytilities.dictionary', 'pytilities.geometry'],
    provides = ['pytilities', 'pytilities.event', 'pytilities.types', 'pytilities.descriptors', 'pytilities.overloading', 'pytilities.delegation', 'pytilities.aop', 'pytilities.aop.aspects', 'pytilities.test', 'pytilities.test.event', 'pytilities.test.types', 'pytilities.test.infinity', 'pytilities.test.tests', 'pytilities.test.descriptors', 'pytilities.test.overloading', 'pytilities.test.delegation', 'pytilities.test.delegation.delegationaspect', 'pytilities.test.delegation.mapped', 'pytilities.test.aop', 'pytilities.test.aop.aspects', 'pytilities.test.dictionary', 'pytilities.test.functions', 'pytilities.test.geometry', 'pytilities.dictionary', 'pytilities.geometry'],
    version = '1.2.0',
    description = 'A collection of python coding utilities',
    author = 'Tim Diels',
    author_email = 'limyreth@users.sourceforge.net',
    url = 'http://pytilities.sourceforge.net',
    keywords = ['utility', 'library', 'aop', 'aspect', 'oriented', 'event', 'overloading'],
    classifiers = ['Development Status :: 5 - Production/Stable', 'Intended Audience :: Developers', 'License :: OSI Approved :: GNU General Public License (GPL)', 'Operating System :: OS Independent', 'Programming Language :: Python', 'Programming Language :: Python :: 3', 'Programming Language :: Python :: 3.0', 'Programming Language :: Python :: 3.1', 'Programming Language :: Python :: 3.2', 'Topic :: Software Development :: Libraries', 'Topic :: Software Development :: Libraries :: Python Modules'],
    long_description = "Pytilities is a python3 utility library.\n\nLinks\n=====\n\n- `Pytilities homepage`_\n- `Documentation`_\n\n\nFeatures\n========\n\n- Aspect oriented programming: \n\n  - Create Aspects to bundle advice\n  - Apply advice to any attribute of an instance or all instances of a class.\n    Can even be applied to attributes that don't exist on the instance (i.e.\n    create it). Can also be applied to any attribute of an object.\n\n- Event dispatching: Observer/Subject like event dispatching with wrappers\n  for hiding events on dispatchers and combining dispatchers\n- Function overloading\n- Basic geometry: Vector, Rectangle classes\n- Various: cross platform infinity number, ...\n\n\n.. _Pytilities homepage: http://pytilities.sourceforge.net/\n.. _Documentation: http://pytilities.sourceforge.net/doc/1.2.0/\n\n\nChangelog\n=========\n\n1.2.0\n-----\n\npytilities.aop\n''''''''''''''\nAdvising is more KISS now. You map your advice in a plain dictionary, instead \nof using _advise. '*' advice is now gone, instead you can use a special \ndictionary like object: pytilities.dictionary.FunctionMap. It allows for '*' \nadvice and more.\n\n:Changed:\n  - `Aspect`:\n\n    - Added:\n\n      - `_advice_mappings`: Mapping of (access, attribute_name) to advice. Note\n        that '*' is not a valid attribute_name, use `FunctionMap` instead of\n        the old '*' advice. If you use `FunctionMap` you should set\n        `_undefined_keys` to True.\n      - `_undefined_keys`: set to True if _advice_mappings provides infinite\n        mappings\n\n    - Removed:\n\n      - `_advise`: use `_advice_mappings` instead\n\n:Fixed:\n  - fixed a special case of invalid call advising, see \n    pytilities.test.aop.calladvisespecialcase\n\n\npytilities.aop.aspects\n''''''''''''''''''''''\n:Fixed:\n  - `View`: the aspect did not correctly enable its aspect upon calling \n    callables through the view\n\n\npytilities.delegation\n'''''''''''''''''''''\nDelegation is more KISS now. The complex Profile class was removed in favor\nof plain dictionaries (and those of pytilities.dictionary). `in_profile` is\nreplaced by the more flexible and KISS `mapped`.\n\n:Added:\n  - `mapped`: adds an attribute to a mapping in a format that can be used\n    as argument to DelegationAspect. You could also use it as a base for the\n    _advice_mappings of your Aspect, ...\n  - `mapped_class`: required on a class for `mapped` to work\n\n:Changed:\n  - `DelegationAspect`:\n\n    - no longer expects a Profile parameter, instead it expects a mapping of \n      (access, source_attribute_name) to target_attribute_name; where \n      access is 'get', 'set',  or 'delete', as opposed to 'r', 'w', or\n      'd'.\n\n:Removed:\n  - `profile_carrier`: use `mapped_class` instead\n  - `in_profile`: use `mapped` instead\n  - `Profile`: replaced by plain dictionaries (This is more flexible and KISS \n    than the vague Profile interface)\n\n\npytilities.dictionary (new)\n'''''''''''''''''''''''''''\n:Added:\n  - `FunctionMap`: A Mapping that uses a function to generate its values\n\n\npytilities.event\n''''''''''''''''\n:Changed:\n  - `DispatcherSwitch`: now has its 'delegation profile' stored in\n    public_mapping\n  - `Dispatcher`: now has its 'delegation profile' stored in\n    public_mapping and default_mapping\n\n\npytilities.tests\n''''''''''''''''\n:Changed:\n  - `is_private`: now only returns True for names matching __name or\n    _SomeClass_name.\n\n:Fixed:\n  - `is_special`: returned False on special attributes\n\n\n1.1.0\n-----\n\npytilities.aop\n''''''''''''''\nMade aop more KISS so it's easier to understand, use (and maintain):\n\n- Distinction between class and instance advice may now be forgotten, there's\n  only advice. Classes act as wildcards now, e.g. aspect.apply(Class) means\n  apply to all instances of Class and Class itself.\n- You can now apply an aspect to all instances from a class and then exclude an\n  instance from that advice by unapplying it afterwards.\n\nImproved test coverage (less bugs now).\n\n:Added:\n  - `advisor.get_applied_aspects(obj)`\n  - `AOPException`\n  - `yield suppress_aspect`: context manager that prevents the current aspect\n    from having its advice executed till the end of the context\n  - `yield advised_attribute`: replaces (yield name, yield advised).\n  - `yield advised_instance`: returns the instance to which the aspect was applied \n    (or the class in case the advised is a static/class method)\n\n:Changed:\n  - `Aspect`:\n\n    - `_advise`: You can no longer advise a member more than once. This \n      includes trying to advise '*' and some regular member at the same time.\n      (this makes Aspect more KISS, you can workaround this limitation \n      using multiple aspects)\n    - `is_enabled`: now returns False for objects to which it is not applied\n    - `apply`: now applies the aspect to all instances of cls and cls \n      itself when supplied a class\n    - `unapply`: now unapplies the aspect on all instances of cls and cls\n      itself when supplied a class\n    - `unapply_all`: now unapplies all aspects on all instances of cls \n      and cls itself when supplied a class\n    - `is_applied`: returns True, if given object is in\n      advisor.get_applied_aspects(obj)\n\n:Removed:\n  - `yield name`: Removed in favor of the clearer `yield advised_attribute`\n  - `yield advised`: Removed in favor of the clearer `yield advised_attribute`\n  - `yield obj`: Removed in favor of the clearer `yield advised_instance`\n  - Support for advising modules: It has become too hard too maintain this\n    feature while there are decent workarounds for this lack:\n\n    - Put your functions in a class with staticmethods or classmethods\n    - Or use the singleton pattern.\n\n    And then apply the aspect to that class.\n\n:Fixes:\n  - `advisor.unapply_all`: forgot to implement it\n  - `yield advised` returned the wrong callable on call access\n  - When trying to get an unexisting attribute after having had advice \n    applied and unapplied to it, the object would no longer throw \n    AttributeError on get access\n  - `Aspect.enable` and `Aspect.disable` had no effect\n\n\npytilities.aop.aspects\n''''''''''''''''''''''\n\n:Added:\n  - `ImmutableAttributeException`\n\n:Changed:\n  - `ImmutableAspect`: as required by the fix (see below):\n    - it can now only be applied on objects with AOPMeta as metaclass\n    - it now raises ImmutableAttributeException on attempts to mutate\n\n:Fixes:\n  - `create_view`: did not enable its aspect on access\n  - `ImmutableAspect`: it only worked for detecting change on setters, it now \n    detects every change. \n\npytilities.descriptors\n''''''''''''''''''''''\nAdded and refactored tests\n\n:Added:\n  - `DereferencedBoundDescriptor`: like BoundDescriptor but takes 2 descriptors\n    as args that are dereferenced(/read/getted) on each call.\n\n:Changed:\n  - `BoundDescriptor`:\n    \n    - `special_dereference` parameter was removed\n    - instance arg will no longer be dereferenced when a descriptor arg is\n      passed\n\n    If you need any of the two above, use DereferencedBoundDescriptor.\n    (splitting the class in two like this would make it more intuitive to use)\n\n\n1.0.1\n-----\nIncluded project.py in release so that unit tests can be run\n\n\n1.0.0\n-----\nThe library moved to python3, older python versions are no longer supported.\nThere a lot of changes, breaking quite a bit of the previous interface. All\nchanges are listed below.\n\n\npytilities \n''''''''''\n\n:Added:\n  - get_annotations: gets annotations of an object, allows to add new ones,\n    ...\n  - get_attr_name, get_attr_value, has_attr_name, has_attr_value: gets an\n    attribute, bypassing regular lookup (no descriptor.__get__, ..., does\n    support inheritance though)\n\n:Removed: \n  - AttributeCollection, AttributeCollectionBase: use aop instead (see User\n    Guide)\n\n:Changed:\n  - mangle: \n\n    - You can now pass an instance as well.\n    - Small fix involving class names that start with a '_'\n\npytilities.aop \n''''''''''''''\n\nThis package brings aspect oriented language features to python (in a handy\nformat). You can apply advice on classes and instances, using aspects that can\nbe applied and unapplied, enabled, disabled, ...\n\n:Added:\n  - advisor: singleton that aspects use to give advice (you shouldn't use\n    this directly, derive from Aspect and use its methods instead)\n  - proceed, return_close, return\\_, arguments, advised, obj, name yields for\n    advice functions\n  - Aspect: base class to write your own aspects with (you are not required\n    to use this, but it is greatly recommended)\n  - AOPMeta: classes that are given * advice require to have AOPMeta as\n    metaclass, other advised classes may benefit from this metaclass as it\n    reduces memory usage\n\npytilities.delegation \n'''''''''''''''''''''\n\n:Added:\n  - DelegationAspect: delegate attributes from a source instance/cls to a\n    target. Only supports direct mappings (mappings with the same source and\n    target attributes).\n  - in_profile, profile_carrier: used to more easily place some profiles on a\n    class\n\n:Changed:\n  - Profile\n\n:Removed:\n  - Delegator, DelegatorFactory: use delegate or any of the other\n    possibilities listed in the User Guide instead\n  - delegator_factory: use profile_carrier instead.\n  - delegated: use in_profile instead.\n  - delegate: use DelegationAspect instead. You may want to read about AOP in\n    the user guide first\n\npytilities.descriptors (new) \n''''''''''''''''''''''''''''\n\n:Added:\n  - AttributeDescriptor: turns a regular attribute into a descriptor\n  - DereferencedDescriptor: returns inner_desc.get.get, sets\n    inner_desc.get.set, ...\n  - BoundDescriptor: binds an instance to a descriptor, much like bound\n    methods\n  - RestrictedDescriptor: strip of the get, set or del of a descriptor\n\npytilities.event \n''''''''''''''''\n\n:Removed:\n  - dispatcher, dispatcherswitch (decorators): normally you'd send events\n    from an aspect as it's a crosscutting concern, so these no longer have to\n    be supported. Use a custom Aspect + DelegationAspect instead.\n\npytilities.geometry \n'''''''''''''''''''\n\n:Added:\n  - DiscreteVector, DiscreteRectangle: A Vector/Rectangle with a discrete\n    coordinate space. All aspects and views for Vector/Rectangle work on\n    these as well.\n  - verbose_rectangle_aspect, verbose_vector_aspect: Aspects to make a\n    Rectangle/Vector send out (change) events.\n  - ImmutableRectangle, ImmutableVector: immutable views of a\n    Rectangle/Vector\n  - immutable_rectangle_aspect, immutable_vector_aspect: makes a\n    Rectangle/Vector immutable\n\n:Changed:\n  - Vector, Rectangle: Due to a change in int division mechanisms in python3,\n    these classes will always operate with a continuous coordinate space. I.e\n    if your vector has coords (3, 1), then when divided by 2 they become\n    (1.5, 0.5) and not (1, 0) as they used to be in previous versions. Use\n    DiscreteVector and DiscreteRectangle instead, to get similar behaviour\n    back.\n  - Vector, DiscreteVector: have an extra overload for assign that accepts\n    (x,y) as args\n\n:Removed:\n  - BoundVector: use Vector directly instead (use its bound properties\n    overload)\n  - VerboseVector: make a Vector and do verbose_vector_aspect.apply(v)\n    instead. This works for DiscreteVectors as well.\n  - VerboseRectangle: make a Rectangle and do\n    verbose_rectangle_aspect.apply(v) instead. This works for DiscreteVectors\n    as well.\n\npytilities.overloading \n''''''''''''''''''''''\n\n:Changed:\n  - overloaded: its returned function now has a process_args method as well\n  - Parameter: its ctor was incorrectly overloaded (ironically). This has\n    been fixed, its overloads changed slightly because of this.\n\npytilities.infinity (new) \n'''''''''''''''''''''''''\n\nProvides a cross-platform alternative to float('inf').\n\n:Added:\n  - infinity, negative_infinity, nan\n  - is_infinity\n\npytilities.tests \n''''''''''''''''\n\n:Added:\n  - is_public, is_protected, is_private, is_special: attribute name checks\n\n\n0.1.4\n-----\n\n- Mangle, mangling and event.dispatcher: fixed a slight name clash\n- Overhauled testing, it is now easier to use\n- Removed inheritance feature of DelegatorFactory, it was too vague\n- Removed __init_delegation_profiles, there are other ways to achieve the same\n  thing\n- Changed the DelegatorFactory interface so that it is hopefully more intuitive\n  to use\n- Added all set operators to delegation.Profile\n- Added more tests and fixed some docstrings\n- RestrictedDispatcher: Made allow and disallow mutually exclusive. It made no\n  sense to specify both\n\n\n0.1.3\n-----\n\n- Added html reference documentation\n\n\n0.1.2\n-----\n\n- Added runtests.py, which allows running unit tests\n- Added the types package (forgot this in last release)\n\n\n0.1.1\n-----\n\n- Fixed: the last release wouldn't parse\n\n\n0.1.0\n-----\n\n- Initial release: delegation tools, events, overloading, ...\n\n"
)
    