#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" icons for additional tkinter widgets """

# pytkapp.tkw: icons for additional tkinter widgets
#
# Copyright (c) 2012 Paul "Mid.Tier"
# Author e-mail: mid.tier@gmail.com

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

###################################
## import
###################################
import sys
if    sys.hexversion >= 0x03000000:
    from tkinter import Tk, PhotoImage
else:
    from Tkinter import Tk, PhotoImage
from pytkapp.tkw.tkw_tooltippedbtn import ToolTippedBtn    
    
############################################################
## xscrolledtext
############################################################
gv_xscrolledtext_unload='''\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'''

# clear log
gv_xscrolledtext_clear='''\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'''

gv_xscrolledtext_print='''\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'''

############################################################
## alistbox
############################################################
gv_alistbox_add='''\
R0lGODlhEAAQALMMAJy4ZLjyctX2p8L6e8numMj/gbLtba3pZ6PhXqjlY8X9fr32dv///wAAAAAA
AAAAACH5BAEAAAwALAAAAAAQABAAAAQ6kMlJq714ApApKAXXMYCiiB0wDKi1bcvytmRg33gLCLxg
GD0BbXY4zDKARIJ2ASAQTBeBEHVVR1hMBAA7
'''

gv_alistbox_remove='''\
R0lGODlhEAAQAJEDALhkZPanp/+Bgf///yH5BAEAAAMALAAAAAAQABAAAAIbnI+py+0PIwO02gSE
3hwgEITi6H3WKaXqyrYFADs=
'''

############################################################
## mlistbox
############################################################
gv_mlistbox_selectall='''\
R0lGODlhEAAQAPcAAF2UunC48nfA97TY9n3G/Gmw7WKp6Ljc+bHU9IHL/6/S8v///wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAsALAAAAAAQABAA
h12UunC48nfA97TY9n3G/Gmw7WKp6Ljc+bHU9IHL/6/S8v///wAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAhYABcIHEiwoMGCAAAcNAggQACFCwU2DDAA4sKJ
FRlCnHhAYcKBExM6zBhS4gCHIz2mBKlAoAKVFC2C3OiwI0OHImMeBHASZcaLCgwYeBlRogKiRSXK
TBoxIAA7
'''

gv_mlistbox_moveup='''\
R0lGODlhEAAQALMAAF2UunrD+rrf+37I/Wqy7mWs6nW+9nC48rDT84HL/////wAAAAAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAg12UunrD+rrf+37I/Wqy7mWs6nW+9nC48rDT84HL/////wAA
AAAAAAAAAAAAAAAAAAQwUMlJq704a6ApSFwHDGSIAUGamhUgCEb8shNgH7hNe0S/t4Xgz4MoDmu6
Y2fJzEQAADs=
'''

gv_mlistbox_movedown='''\
R0lGODlhEAAQALMAAF2UunC48n7I/XW+9nrD+mqy7oHL/6nZ+KDR9KTV9mWs6p3O8////wAAAAAA
AAAAACH5BAEAAAwALAAAAAAQABAAg12UunC48n7I/XW+9nrD+mqy7oHL/6nZ+KDR9KTV9mWs6p3O
8////wAAAAAAAAAAAAQxkMlJq704Y8C5ZoAhAh8gnKQGEGx6dUPcvUdg24dbAUnhJzoLAKFABF+L
4+bDbDotEQA7
'''

gv_mlistbox_reset='''\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'''

############################################################
## xtablelist
############################################################
gv_xtablelist_resizebydata='''\
R0lGODlhEAAQAPcAAP///wBmzICNmigzPyczPgBiz9ri6tPb4vX4+8DK1MHL1PL2+fP3+fj5/IeU
oGJrdnV/i4KPm+zy9vf5+0pTXdTc43iEj8bQ2m96hWp1gfr7/cDJ09Pb42FrdOju9Onv9GhyfH2J
lsTN1s7W3sjQ2ufu9L3I0rvFzyo1QIGOm9rh6dbd5f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAEAAQAAAIiQABCBxI
sODAAAIRHkx4MIDDhxAfLgSgkCFFgxgxOtjIseNGgg5UqAgpcqRIByAjCFiZYqUAjgQtCFRBkCYA
mQMhGDiwosIKDjwNGIBAMEOLFiSOHk3aIgNBEBc2iFAgIoHUCxdAEHwAwIMJCRI+eDghkOvADgJN
EFQLAO1ACgPiyp1LIaNdAAEBADs=
'''

gv_xtablelist_resizebyheaders='''\
R0lGODlhEAAQAPcAAP///wBmzICNmigzPyczPgBiz9ri6tPb4vX4+8DK1MHL1PL2+fP3+fj5/IeU
oGJrdnV/i4KPm+zy9vf5+0pTXdTc43iEj8bQ2m96hWp1gfr7/cDJ09Pb42FrdOju9Onv9GhyfH2J
lsTN1s7W3sjQ2ufu9L3I0rvFzyo1QIGOm9rh6dbd5f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAEAAQAAAIigABCBxI
sODAAAIRHkx4MIDDhxAfLgSgkCFFgxgxOtjIseNGgg5atAgpcqRIByAjCFiZYqUAjgQtCFRBkCYA
mQMhGDiwosIKDjwNGIBAMAOABSQQaGCAVKDRgSAubBChQESCqRcugCD4AIAHExIkfPBwQmDXgR0E
miC4FkDagRQGyJ1Ll0LGuwACAgA7
'''

gv_xtablelist_export='''\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'''

gv_icon_tree_collapseall='''\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'''

gv_icon_tree_expandall='''\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'''

def run_demo():
    """ some demo """
    
    def name2clipboard(wroot, pv_name=''):
        wroot.clipboard_clear()
        wroot.clipboard_append(pv_name)
    
    root = Tk()
    root.title(__file__)
    
    ll_imgs = [x for x in globals() if isinstance(x, str) and not x.startswith('__') and x not in ('PhotoImage', 'run_demo', 'Tk', 'ToolTippedBtn') and x not in sys.modules]
    ll_imgs.sort()
    lv_lenimgs = len(ll_imgs)
    
    lv_pos = 0
    lv_x = int(len(ll_imgs) ** 0.6)
    
    lv_r = 0
    while lv_pos < lv_lenimgs:       
        lv_c = 0
        for i in range(lv_x):
            if lv_pos >= lv_lenimgs:
                break
            try:
                img = PhotoImage(data=globals()[ll_imgs[lv_pos]])
                b = ToolTippedBtn(root, 
                                  tooltip=ll_imgs[lv_pos], 
                                  image=img,
                                  command=lambda ev=None, wr=root, wt=ll_imgs[lv_pos]: name2clipboard(wr, wt))
                b.grid(row=lv_r, column=lv_c)
                lv_c += 1
                lv_pos += 1
            except StandardError as err:
                print(err.message)
        lv_r += 1
        
    root.resizable(width=False, height=False)
    root.mainloop()
        
if __name__ == '__main__':    
    run_demo()
