
/**********************************************************************
     Autogenerated module pytsk

This module was autogenerated from the following files:
/usr/local/include/tsk/libtsk.h
/usr/local/include/tsk/base/tsk_base.h
/usr/local/include/tsk/fs/tsk_fs.h
/usr/local/include/tsk/img/tsk_img.h
/usr/local/include/tsk/vs/tsk_vs.h
tsk3.h

This module implements the following classes:
Module pytsk
    Enum TSK_RETVAL_ENUM:

    Enum TSK_WALK_RET_ENUM:
    TSK_WALK_CONT
    TSK_WALK_STOP
    TSK_WALK_ERROR

    Enum TSK_FS_BLOCK_FLAG_ENUM:
    TSK_FS_BLOCK_FLAG_UNUSED
    TSK_FS_BLOCK_FLAG_ALLOC
    TSK_FS_BLOCK_FLAG_UNALLOC
    TSK_FS_BLOCK_FLAG_CONT
    TSK_FS_BLOCK_FLAG_META
    TSK_FS_BLOCK_FLAG_BAD
    TSK_FS_BLOCK_FLAG_RAW
    TSK_FS_BLOCK_FLAG_SPARSE
    TSK_FS_BLOCK_FLAG_COMP
    TSK_FS_BLOCK_FLAG_RES
    TSK_FS_BLOCK_FLAG_AONLY

    Enum TSK_FS_ATTR_RUN_FLAG_ENUM:
    TSK_FS_ATTR_RUN_FLAG_NONE
    TSK_FS_ATTR_RUN_FLAG_FILLER
    TSK_FS_ATTR_RUN_FLAG_SPARSE

    Enum TSK_FS_ATTR_FLAG_ENUM:
    TSK_FS_ATTR_FLAG_NONE
    TSK_FS_ATTR_INUSE
    TSK_FS_ATTR_NONRES
    TSK_FS_ATTR_RES
    TSK_FS_ATTR_ENC
    TSK_FS_ATTR_COMP
    TSK_FS_ATTR_SPARSE
    TSK_FS_ATTR_RECOVERY

    Enum TSK_FS_META_FLAG_ENUM:
    TSK_FS_META_FLAG_ALLOC
    TSK_FS_META_FLAG_UNALLOC
    TSK_FS_META_FLAG_USED
    TSK_FS_META_FLAG_UNUSED
    TSK_FS_META_FLAG_COMP
    TSK_FS_META_FLAG_ORPHAN

    Enum TSK_FS_NAME_FLAG_ENUM:
    TSK_FS_NAME_FLAG_ALLOC
    TSK_FS_NAME_FLAG_UNALLOC

    #
    * A handle to a directory so that its files can be individually accessed.
    
Struct TSK_FS_DIR:
    int : tag
    TSK_FS_FILE * : fs_file
    TSK_FS_NAME * : names
    uint64_t  : names_used
    uint64_t  : names_alloc
    uint64_t  : addr
    uint32_t  : seq
    TSK_FS_INFO * : fs_info


    Enum TSK_FS_DIR_WALK_FLAG_ENUM:
    TSK_FS_DIR_WALK_FLAG_NONE
    TSK_FS_DIR_WALK_FLAG_ALLOC
    TSK_FS_DIR_WALK_FLAG_UNALLOC
    TSK_FS_DIR_WALK_FLAG_RECURSE
    TSK_FS_DIR_WALK_FLAG_NOORPHAN

    Enum TSK_FS_FILE_READ_FLAG_ENUM:
    TSK_FS_FILE_READ_FLAG_NONE
    TSK_FS_FILE_READ_FLAG_SLACK
    TSK_FS_FILE_READ_FLAG_NOID

    Enum TSK_FS_BLKCALC_FLAG_ENUM:
    TSK_FS_BLKCALC_DD
    TSK_FS_BLKCALC_BLKLS
    TSK_FS_BLKCALC_SLACK

    Enum TSK_IMG_TYPE_ENUM:
    TSK_IMG_TYPE_DETECT
    TSK_IMG_TYPE_RAW
    TSK_IMG_TYPE_RAW_SING
    TSK_IMG_TYPE_RAW_SPLIT
    TSK_IMG_TYPE_AFF_AFF
    TSK_IMG_TYPE_AFF_AFD
    TSK_IMG_TYPE_AFF_AFM
    TSK_IMG_TYPE_AFF_ANY
    TSK_IMG_TYPE_EWF_EWF
    TSK_IMG_TYPE_UNSUPP

    Enum TSK_VS_TYPE_ENUM:
    TSK_VS_TYPE_DETECT
    TSK_VS_TYPE_DOS
    TSK_VS_TYPE_BSD
    TSK_VS_TYPE_SUN
    TSK_VS_TYPE_MAC
    TSK_VS_TYPE_GPT
    TSK_VS_TYPE_DBFILLER
    TSK_VS_TYPE_UNSUPP

    Enum TSK_VS_PART_FLAG_ENUM:
    TSK_VS_PART_FLAG_ALLOC
    TSK_VS_PART_FLAG_UNALLOC
    TSK_VS_PART_FLAG_META
    TSK_VS_PART_FLAG_ALL

    #
Struct Extended_TSK_IMG_INFO:


    # This is a normal IMG_INFO which takes a filename and passes it
    to TSK. It just uses the standard TSK image handling code to
    support EWF, AFF etc.

    This is usually the first object you would instantiate in order to
    use the TSK library:

    img = Img_Info(filename)

    you would then pass it to an FS_Info object:

    fs = FS_Info(img)

    Then open an inode or path

    f = fs.open_dir(inode = 2)

Class Img_Info(Object):
 Constructor:def Img_Info Con(ZString : url , TSK_IMG_TYPE_ENUM : type):
 Attributes:

 Methods:
    def uint64_t  read(int64_t  : off , OUT char * : buf):
    def uint64_t  get_size():
    def void close():

    # This object handles volumes.
 
Class Volume_Info(Object):
 Constructor:def Volume_Info Con(Img_Info : img , TSK_VS_TYPE_ENUM : type , int64_t  : offset):
 Attributes:
    TSK_VS_INFO * : info
    int : current

 Methods:
    Iterator returning void.
    Iterator returning TSK_VS_PART_INFO *.

    # An attribute is associated with a file. In some filesystem
    (e.g. NTFS) a file may contain many attributes.

    Attributes can be iterated over to obtain the attribute runs
    (e.g. to recover block allocation information).


Class Attribute(Object):
 Constructor:def Attribute Con(TSK_FS_ATTR * : info):
 Attributes:
    TSK_FS_ATTR * : info
    TSK_FS_ATTR_RUN * : current

 Methods:
    Iterator returning void.
    Iterator returning TSK_FS_ATTR_RUN *.

    # This represents a file object. A file has both metadata and
    data streams.

    Its usually not useful to instantiate this class by itself -
    you need to call FS_Info.open() or iterate over a Directory()
    object.

    This object may be used to read the content of the file using
    read_random().

    Iterating over this object will return all the attributes for
    this file.

Class File(Object):
 Constructor:def File Con(FS_Info : fs , TSK_FS_FILE * : info):
 Attributes:
    TSK_FS_FILE * : info
    int : max_attr
    int : current_attr

 Methods:
    def uint64_t  read_random(int64_t  : offset , OUT char * : buff , TSK_FS_ATTR_TYPE_ENUM : type , int : id , TSK_FS_FILE_READ_FLAG_ENUM : flags):
    def Directory as_directory():
    Iterator returning void.
    Iterator returning Attribute.

    # This represents a Directory within the filesystem. You can
    iterate over this object to obtain all the File objects
    contained within this directory:

    for f in d:
        print f.info.name.name

Class Directory(Object):
 Constructor:def Directory Con(FS_Info : fs , ZString : path , uint64_t  : inode):
 Attributes:
    TSK_FS_DIR * : info
    uint64_t  : size
    int : current

 Methods:
    Iterator returning void.
    Iterator returning File.

    # This is used to obtain a filesystem object from an Img_Info object.

    From this FS_Info we can open files or directories by inode, or
    path.
 
Class FS_Info(Object):
 Constructor:def FS_Info Con(Img_Info : img , int64_t  : offset , TSK_FS_TYPE_ENUM : type):
 Attributes:
    TSK_FS_INFO * : info

 Methods:
    def Directory open_dir(ZString : path , uint64_t  : inode):
    def File open(ZString : path):
    def File open_meta(uint64_t  : inode):
    def void exit():

    #
    * Holds information about a single data run, which has a starting address and length.
    * A run describes a consecutive list of blocks that have been allocated to a file. 
    * A file may have many such runs and they are stringed together in a linked list.
    * The entries in the list must be stored in sequential order (based on offset in file).
    
Struct TSK_FS_ATTR_RUN:
    TSK_FS_ATTR_RUN * : next
    uint64_t  : offset
    uint64_t  : addr
    uint64_t  : len
    TSK_FS_ATTR_RUN_FLAG_ENUM : flags


    Enum TSK_FS_FILE_WALK_FLAG_ENUM:
    TSK_FS_FILE_WALK_FLAG_NONE
    TSK_FS_FILE_WALK_FLAG_SLACK
    TSK_FS_FILE_WALK_FLAG_NOID
    TSK_FS_FILE_WALK_FLAG_AONLY
    TSK_FS_FILE_WALK_FLAG_NOSPARSE

    Enum TSK_FS_ATTR_TYPE_ENUM:
    TSK_FS_ATTR_TYPE_NOT_FOUND
    TSK_FS_ATTR_TYPE_DEFAULT
    TSK_FS_ATTR_TYPE_NTFS_SI
    TSK_FS_ATTR_TYPE_NTFS_ATTRLIST
    TSK_FS_ATTR_TYPE_NTFS_FNAME
    TSK_FS_ATTR_TYPE_NTFS_VVER
    TSK_FS_ATTR_TYPE_NTFS_OBJID
    TSK_FS_ATTR_TYPE_NTFS_SEC
    TSK_FS_ATTR_TYPE_NTFS_VNAME
    TSK_FS_ATTR_TYPE_NTFS_VINFO
    TSK_FS_ATTR_TYPE_NTFS_DATA
    TSK_FS_ATTR_TYPE_NTFS_IDXROOT
    TSK_FS_ATTR_TYPE_NTFS_IDXALLOC
    TSK_FS_ATTR_TYPE_NTFS_BITMAP
    TSK_FS_ATTR_TYPE_NTFS_SYMLNK
    TSK_FS_ATTR_TYPE_NTFS_REPARSE
    TSK_FS_ATTR_TYPE_NTFS_EAINFO
    TSK_FS_ATTR_TYPE_NTFS_EA
    TSK_FS_ATTR_TYPE_NTFS_PROP
    TSK_FS_ATTR_TYPE_NTFS_LOG
    TSK_FS_ATTR_TYPE_UNIX_INDIR
    TSK_FS_ATTR_TYPE_UNIX_EXTENT
    TSK_FS_ATTR_TYPE_HFS_DEFAULT
    TSK_FS_ATTR_TYPE_HFS_DATA
    TSK_FS_ATTR_TYPE_HFS_RSRC
    TSK_FS_ATTR_TYPE_HFS_EXT_ATTR
    TSK_FS_ATTR_TYPE_HFS_COMP_REC

    #
    * Holds information about the location of file content (or a file attribute). For most file systems, a file
    * has only a single attribute that stores the file content. 
    * Other file systems, such as NTFS, have multiple
    * attributes.  If multiple attributes exist, they are stored in a linked list.
    * Attributes can be "resident", which means the data is stored
    * in a small buffer instead of being stored in a full file system block.
    * "Non-resident" attributes store data in blocks and they are stored in 
    * the data structure as a series of runs.  
    * This structure is used to represent both of these cases.
    *
    * The non-resident data has several size values. 
    * \verbatim
    * |--------------------------------------------------------------------|
    * |skiplen|---------------allocsize------------------------------------|
    * |skiplen|---------------size-----------------------------------|
    * |skiplen|---------------initsize------------|
    * \endverbatim
    
Struct TSK_FS_ATTR:
    TSK_FS_ATTR * : next
    TSK_FS_FILE * : fs_file
    TSK_FS_ATTR_FLAG_ENUM : flags
    char * : name
    uint64_t  : name_size
    TSK_FS_ATTR_TYPE_ENUM : type
    uint16_t  : id
    int64_t  : size


    Enum TSK_FS_META_ATTR_FLAG_ENUM:

    Enum TSK_FS_META_TYPE_ENUM:
    TSK_FS_META_TYPE_UNDEF
    TSK_FS_META_TYPE_REG
    TSK_FS_META_TYPE_DIR
    TSK_FS_META_TYPE_FIFO
    TSK_FS_META_TYPE_CHR
    TSK_FS_META_TYPE_BLK
    TSK_FS_META_TYPE_LNK
    TSK_FS_META_TYPE_SHAD
    TSK_FS_META_TYPE_SOCK
    TSK_FS_META_TYPE_WHT
    TSK_FS_META_TYPE_VIRT

    Enum TSK_FS_META_MODE_ENUM:
    TSK_FS_META_MODE_ISUID
    TSK_FS_META_MODE_ISGID
    TSK_FS_META_MODE_ISVTX
    TSK_FS_META_MODE_IRUSR
    TSK_FS_META_MODE_IWUSR
    TSK_FS_META_MODE_IXUSR
    TSK_FS_META_MODE_IRGRP
    TSK_FS_META_MODE_IWGRP
    TSK_FS_META_MODE_IXGRP
    TSK_FS_META_MODE_IROTH
    TSK_FS_META_MODE_IWOTH
    TSK_FS_META_MODE_IXOTH

    # 
    * TSK data structure to store general file and directory metadata. 
    * Note that the file in the file
    * system may have more metadata than is stored here.  
    * For performance reasons, the run list of the file content is not always known
    * when the file is loaded.  It may be loaded only when needed by the internal code. 
    * The TSK_FS_META::content_ptr pointer contains file system-specific data that will be
    * used to determine the full run. After it has been loaded, the TSK_FS_META::attr field
    * will contain that info.  
    
Struct TSK_FS_META:
    int : tag
    TSK_FS_META_FLAG_ENUM : flags
    uint64_t  : addr
    TSK_FS_META_TYPE_ENUM : type
    TSK_FS_META_MODE_ENUM : mode
    int : nlink
    int64_t  : size
    uint32_t  : uid
    uint32_t  : gid
    int64_t  : mtime
    uint32_t  : mtime_nano
    int64_t  : atime
    uint32_t  : atime_nano
    int64_t  : ctime
    uint32_t  : ctime_nano
    int64_t  : crtime
    uint32_t  : crtime_nano
    
    uint64_t  : content_len
    uint32_t  : seq
    TSK_FS_META_ATTR_FLAG_ENUM : attr_state
    char * : link


    Enum TSK_FS_NAME_TYPE_ENUM:
    TSK_FS_NAME_TYPE_UNDEF
    TSK_FS_NAME_TYPE_FIFO
    TSK_FS_NAME_TYPE_CHR
    TSK_FS_NAME_TYPE_DIR
    TSK_FS_NAME_TYPE_BLK
    TSK_FS_NAME_TYPE_REG
    TSK_FS_NAME_TYPE_LNK
    TSK_FS_NAME_TYPE_SOCK
    TSK_FS_NAME_TYPE_SHAD
    TSK_FS_NAME_TYPE_WHT
    TSK_FS_NAME_TYPE_VIRT

    #
    * Generic structure to store the file name information that is stored in
    * a directory. Most file systems seperate the file name from the metadata, but
    * some do not (such as FAT). This structure contains the name and address of the 
    * metadata.
    
Struct TSK_FS_NAME:
    int : tag
    char * : name
    uint64_t  : name_size
    char * : shrt_name
    uint64_t  : shrt_name_size
    uint64_t  : meta_addr
    uint32_t  : meta_seq
    uint64_t  : par_addr
    uint32_t  : par_seq
    TSK_FS_NAME_TYPE_ENUM : type
    TSK_FS_NAME_FLAG_ENUM : flags


    #
    * Generic structure used to refer to files in the file system.  A file will
    * typically have a name and metadata.  This structure holds that type of information.
    * When deleted files are being processed, this structure may have the name defined
    * but not metadata because it no longer exists. Or, if you are calling meta_walk
    * and are not processing at the name level, then the name will not be defined.  
    * always check these to make sure they are not null before they are read. 
Struct TSK_FS_FILE:
    int : tag
    TSK_FS_NAME * : name
    TSK_FS_META * : meta
    TSK_FS_INFO * : fs_info


    Enum TSK_FS_INFO_FLAG_ENUM:
    TSK_FS_INFO_FLAG_NONE
    TSK_FS_INFO_FLAG_HAVE_SEQ
    TSK_FS_INFO_FLAG_HAVE_NANOSEC

    #
    * Stores state information for an open file system. 
    * One of these are generated for each open files system and it contains
    * file system-type specific data.  These values are all filled in by
    * the file system code and not the caller functions.  This struct
    * (and its subclasses) should be allocated only by tsk_fs_malloc
    * and deallocated only by tsk_fs_free, which handle init/deinit
    * of the locks.
    
Struct TSK_FS_INFO:
    int : tag
    int64_t  : offset
    uint64_t  : inum_count
    uint64_t  : root_inum
    uint64_t  : first_inum
    uint64_t  : last_inum
    uint64_t  : block_count
    uint64_t  : first_block
    uint64_t  : last_block
    uint64_t  : last_block_act
    int : block_size
    int : dev_bsize
    int : block_pre_size
    int : block_post_size
    uint64_t  : journ_inum
    TSK_FS_TYPE_ENUM : ftype
    TSK_FS_INFO_FLAG_ENUM : flags
    uint64_t  : fs_id_used
    TSK_ENDIAN_ENUM : endian
    TSK_FS_DIR * : orphan_dir


    Enum TSK_FS_BLKCAT_FLAG_ENUM:
    TSK_FS_BLKCAT_NONE
    TSK_FS_BLKCAT_HEX
    TSK_FS_BLKCAT_ASCII
    TSK_FS_BLKCAT_HTML
    TSK_FS_BLKCAT_STAT

    Enum TSK_FS_BLKLS_FLAG_ENUM:
    TSK_FS_BLKLS_NONE
    TSK_FS_BLKLS_CAT
    TSK_FS_BLKLS_LIST
    TSK_FS_BLKLS_SLACK

    Enum TSK_FS_FFIND_FLAG_ENUM:
    TSK_FS_FFIND_ALL

    Enum TSK_FS_FLS_FLAG_ENUM:
    TSK_FS_FLS_NONE
    TSK_FS_FLS_DOT
    TSK_FS_FLS_LONG
    TSK_FS_FLS_FILE
    TSK_FS_FLS_DIR
    TSK_FS_FLS_FULL
    TSK_FS_FLS_MAC
    TSK_FS_FLS_HASH

    Enum TSK_FS_IFIND_FLAG_ENUM:
    TSK_FS_IFIND_NONE
    TSK_FS_IFIND_ALL
    TSK_FS_IFIND_PAR_LONG

    Enum TSK_FS_ILS_FLAG_ENUM:
    TSK_FS_ILS_NONE
    TSK_FS_ILS_OPEN
    TSK_FS_ILS_MAC
    TSK_FS_ILS_LINK
    TSK_FS_ILS_UNLINK

    #
    * Data structure used to store state and basic information
    * for open volume systems.
    
Struct TSK_VS_INFO:
    int : tag
    TSK_VS_TYPE_ENUM : vstype
    uint64_t  : offset
    int : block_size
    TSK_ENDIAN_ENUM : endian
    TSK_VS_PART_INFO * : part_list
    uint32_t  : part_count


    #
    * Linked list entry that describes a volume in a generic way. 
    
Struct TSK_VS_PART_INFO:
    int : tag
    TSK_VS_PART_INFO * : prev
    TSK_VS_PART_INFO * : next
    TSK_VS_INFO * : vs
    uint64_t  : start
    uint64_t  : len
    char * : desc
    int8_t  : table_num
    int8_t  : slot_num
    uint32_t  : addr
    TSK_VS_PART_FLAG_ENUM : flags


    Enum TSK_FS_TYPE_ENUM:
    TSK_FS_TYPE_DETECT
    TSK_FS_TYPE_NTFS
    TSK_FS_TYPE_NTFS_DETECT
    TSK_FS_TYPE_FAT12
    TSK_FS_TYPE_FAT16
    TSK_FS_TYPE_FAT32
    TSK_FS_TYPE_FAT_DETECT
    TSK_FS_TYPE_FFS1
    TSK_FS_TYPE_FFS1B
    TSK_FS_TYPE_FFS2
    TSK_FS_TYPE_FFS_DETECT
    TSK_FS_TYPE_EXT2
    TSK_FS_TYPE_EXT3
    TSK_FS_TYPE_EXT_DETECT
    TSK_FS_TYPE_SWAP
    TSK_FS_TYPE_SWAP_DETECT
    TSK_FS_TYPE_RAW
    TSK_FS_TYPE_RAW_DETECT
    TSK_FS_TYPE_ISO9660
    TSK_FS_TYPE_ISO9660_DETECT
    TSK_FS_TYPE_HFS
    TSK_FS_TYPE_HFS_DETECT
    TSK_FS_TYPE_EXT4
    TSK_FS_TYPE_YAFFS2
    TSK_FS_TYPE_YAFFS2_DETECT
    TSK_FS_TYPE_UNSUPP

    # Base object

Class Object(Obj):
 Constructor:def void * Con():
 Attributes:

 Methods:

    Enum TSK_ENDIAN_ENUM:
    TSK_LIT_ENDIAN
    TSK_BIG_ENDIAN

    Enum TSK_FS_BLOCK_WALK_FLAG_ENUM:
    TSK_FS_BLOCK_WALK_FLAG_NONE
    TSK_FS_BLOCK_WALK_FLAG_ALLOC
    TSK_FS_BLOCK_WALK_FLAG_UNALLOC
    TSK_FS_BLOCK_WALK_FLAG_CONT
    TSK_FS_BLOCK_WALK_FLAG_META
    TSK_FS_BLOCK_WALK_FLAG_AONLY

    # 
    * Generic data structure to hold block data with metadata
    
Struct TSK_FS_BLOCK:
    int : tag
    TSK_FS_INFO * : fs_info
    char * : buf
    uint64_t  : addr
    TSK_FS_BLOCK_FLAG_ENUM : flags


Constants:
 FALSE
 PRIX16
 PRIX32
 PRIX64
 TRUE
 TSK_BIG_ENDIAN
 TSK_ERROR_STRING_MAX_LENGTH
 TSK_ERR_AUTO
 TSK_ERR_AUTO_CORRUPT
 TSK_ERR_AUTO_DB
 TSK_ERR_AUTO_MAX
 TSK_ERR_AUTO_NOTOPEN
 TSK_ERR_AUTO_UNICODE
 TSK_ERR_AUX
 TSK_ERR_AUX_GENERIC
 TSK_ERR_AUX_MALLOC
 TSK_ERR_AUX_MAX
 TSK_ERR_FS
 TSK_ERR_FS_ARG
 TSK_ERR_FS_ATTR_NOTFOUND
 TSK_ERR_FS_BLK_NUM
 TSK_ERR_FS_CORRUPT
 TSK_ERR_FS_FWALK
 TSK_ERR_FS_GENFS
 TSK_ERR_FS_INODE_COR
 TSK_ERR_FS_INODE_NUM
 TSK_ERR_FS_MAGIC
 TSK_ERR_FS_MAX
 TSK_ERR_FS_READ
 TSK_ERR_FS_READ_OFF
 TSK_ERR_FS_RECOVER
 TSK_ERR_FS_UNICODE
 TSK_ERR_FS_UNKTYPE
 TSK_ERR_FS_UNSUPFUNC
 TSK_ERR_FS_UNSUPTYPE
 TSK_ERR_FS_WALK_RNG
 TSK_ERR_FS_WRITE
 TSK_ERR_HDB
 TSK_ERR_HDB_ARG
 TSK_ERR_HDB_CORRUPT
 TSK_ERR_HDB_CREATE
 TSK_ERR_HDB_DELETE
 TSK_ERR_HDB_MAX
 TSK_ERR_HDB_MISSING
 TSK_ERR_HDB_OPEN
 TSK_ERR_HDB_PROC
 TSK_ERR_HDB_READDB
 TSK_ERR_HDB_READIDX
 TSK_ERR_HDB_UNKTYPE
 TSK_ERR_HDB_UNSUPTYPE
 TSK_ERR_HDB_WRITE
 TSK_ERR_IMG
 TSK_ERR_IMG_ARG
 TSK_ERR_IMG_CONVERT
 TSK_ERR_IMG_MAGIC
 TSK_ERR_IMG_MAX
 TSK_ERR_IMG_NOFILE
 TSK_ERR_IMG_OFFSET
 TSK_ERR_IMG_OPEN
 TSK_ERR_IMG_PASSWD
 TSK_ERR_IMG_READ
 TSK_ERR_IMG_READ_OFF
 TSK_ERR_IMG_SEEK
 TSK_ERR_IMG_STAT
 TSK_ERR_IMG_UNKTYPE
 TSK_ERR_IMG_UNSUPTYPE
 TSK_ERR_IMG_WRITE
 TSK_ERR_MASK
 TSK_ERR_VS
 TSK_ERR_VS_ARG
 TSK_ERR_VS_BLK_NUM
 TSK_ERR_VS_BUF
 TSK_ERR_VS_MAGIC
 TSK_ERR_VS_MAX
 TSK_ERR_VS_READ
 TSK_ERR_VS_UNKTYPE
 TSK_ERR_VS_UNSUPTYPE
 TSK_ERR_VS_WALK_RNG
 TSK_FS_ATTR_COMP
 TSK_FS_ATTR_ENC
 TSK_FS_ATTR_FLAG_NONE
 TSK_FS_ATTR_ID_DEFAULT
 TSK_FS_ATTR_INUSE
 TSK_FS_ATTR_NONRES
 TSK_FS_ATTR_RECOVERY
 TSK_FS_ATTR_RES
 TSK_FS_ATTR_RUN_FLAG_FILLER
 TSK_FS_ATTR_RUN_FLAG_NONE
 TSK_FS_ATTR_RUN_FLAG_SPARSE
 TSK_FS_ATTR_SPARSE
 TSK_FS_ATTR_TYPE_DEFAULT
 TSK_FS_ATTR_TYPE_HFS_COMP_REC
 TSK_FS_ATTR_TYPE_HFS_DATA
 TSK_FS_ATTR_TYPE_HFS_DEFAULT
 TSK_FS_ATTR_TYPE_HFS_EXT_ATTR
 TSK_FS_ATTR_TYPE_HFS_RSRC
 TSK_FS_ATTR_TYPE_NOT_FOUND
 TSK_FS_ATTR_TYPE_NTFS_ATTRLIST
 TSK_FS_ATTR_TYPE_NTFS_BITMAP
 TSK_FS_ATTR_TYPE_NTFS_DATA
 TSK_FS_ATTR_TYPE_NTFS_EA
 TSK_FS_ATTR_TYPE_NTFS_EAINFO
 TSK_FS_ATTR_TYPE_NTFS_FNAME
 TSK_FS_ATTR_TYPE_NTFS_IDXALLOC
 TSK_FS_ATTR_TYPE_NTFS_IDXROOT
 TSK_FS_ATTR_TYPE_NTFS_LOG
 TSK_FS_ATTR_TYPE_NTFS_OBJID
 TSK_FS_ATTR_TYPE_NTFS_PROP
 TSK_FS_ATTR_TYPE_NTFS_REPARSE
 TSK_FS_ATTR_TYPE_NTFS_SEC
 TSK_FS_ATTR_TYPE_NTFS_SI
 TSK_FS_ATTR_TYPE_NTFS_SYMLNK
 TSK_FS_ATTR_TYPE_NTFS_VINFO
 TSK_FS_ATTR_TYPE_NTFS_VNAME
 TSK_FS_ATTR_TYPE_NTFS_VVER
 TSK_FS_ATTR_TYPE_UNIX_EXTENT
 TSK_FS_ATTR_TYPE_UNIX_INDIR
 TSK_FS_BLKCALC_BLKLS
 TSK_FS_BLKCALC_DD
 TSK_FS_BLKCALC_SLACK
 TSK_FS_BLKCAT_ASCII
 TSK_FS_BLKCAT_HEX
 TSK_FS_BLKCAT_HTML
 TSK_FS_BLKCAT_NONE
 TSK_FS_BLKCAT_STAT
 TSK_FS_BLKLS_CAT
 TSK_FS_BLKLS_LIST
 TSK_FS_BLKLS_NONE
 TSK_FS_BLKLS_SLACK
 TSK_FS_BLOCK_FLAG_ALLOC
 TSK_FS_BLOCK_FLAG_AONLY
 TSK_FS_BLOCK_FLAG_BAD
 TSK_FS_BLOCK_FLAG_COMP
 TSK_FS_BLOCK_FLAG_CONT
 TSK_FS_BLOCK_FLAG_META
 TSK_FS_BLOCK_FLAG_RAW
 TSK_FS_BLOCK_FLAG_RES
 TSK_FS_BLOCK_FLAG_SPARSE
 TSK_FS_BLOCK_FLAG_UNALLOC
 TSK_FS_BLOCK_FLAG_UNUSED
 TSK_FS_BLOCK_TAG
 TSK_FS_BLOCK_WALK_FLAG_ALLOC
 TSK_FS_BLOCK_WALK_FLAG_AONLY
 TSK_FS_BLOCK_WALK_FLAG_CONT
 TSK_FS_BLOCK_WALK_FLAG_META
 TSK_FS_BLOCK_WALK_FLAG_NONE
 TSK_FS_BLOCK_WALK_FLAG_UNALLOC
 TSK_FS_DIR_TAG
 TSK_FS_DIR_WALK_FLAG_ALLOC
 TSK_FS_DIR_WALK_FLAG_NONE
 TSK_FS_DIR_WALK_FLAG_NOORPHAN
 TSK_FS_DIR_WALK_FLAG_RECURSE
 TSK_FS_DIR_WALK_FLAG_UNALLOC
 TSK_FS_FFIND_ALL
 TSK_FS_FILE_READ_FLAG_NOID
 TSK_FS_FILE_READ_FLAG_NONE
 TSK_FS_FILE_READ_FLAG_SLACK
 TSK_FS_FILE_TAG
 TSK_FS_FILE_WALK_FLAG_AONLY
 TSK_FS_FILE_WALK_FLAG_NOID
 TSK_FS_FILE_WALK_FLAG_NONE
 TSK_FS_FILE_WALK_FLAG_NOSPARSE
 TSK_FS_FILE_WALK_FLAG_SLACK
 TSK_FS_FLS_DIR
 TSK_FS_FLS_DOT
 TSK_FS_FLS_FILE
 TSK_FS_FLS_FULL
 TSK_FS_FLS_HASH
 TSK_FS_FLS_LONG
 TSK_FS_FLS_MAC
 TSK_FS_FLS_NONE
 TSK_FS_IFIND_ALL
 TSK_FS_IFIND_NONE
 TSK_FS_IFIND_PAR_LONG
 TSK_FS_ILS_LINK
 TSK_FS_ILS_MAC
 TSK_FS_ILS_NONE
 TSK_FS_ILS_OPEN
 TSK_FS_ILS_UNLINK
 TSK_FS_INFO_FLAG_HAVE_NANOSEC
 TSK_FS_INFO_FLAG_HAVE_SEQ
 TSK_FS_INFO_FLAG_NONE
 TSK_FS_INFO_FS_ID_LEN
 TSK_FS_INFO_TAG
 TSK_FS_META_FLAG_ALLOC
 TSK_FS_META_FLAG_COMP
 TSK_FS_META_FLAG_ORPHAN
 TSK_FS_META_FLAG_UNALLOC
 TSK_FS_META_FLAG_UNUSED
 TSK_FS_META_FLAG_USED
 TSK_FS_META_MODE_IRGRP
 TSK_FS_META_MODE_IROTH
 TSK_FS_META_MODE_IRUSR
 TSK_FS_META_MODE_ISGID
 TSK_FS_META_MODE_ISUID
 TSK_FS_META_MODE_ISVTX
 TSK_FS_META_MODE_IWGRP
 TSK_FS_META_MODE_IWOTH
 TSK_FS_META_MODE_IWUSR
 TSK_FS_META_MODE_IXGRP
 TSK_FS_META_MODE_IXOTH
 TSK_FS_META_MODE_IXUSR
 TSK_FS_META_NAME_LIST_NSIZE
 TSK_FS_META_TAG
 TSK_FS_META_TYPE_BLK
 TSK_FS_META_TYPE_CHR
 TSK_FS_META_TYPE_DIR
 TSK_FS_META_TYPE_FIFO
 TSK_FS_META_TYPE_LNK
 TSK_FS_META_TYPE_REG
 TSK_FS_META_TYPE_SHAD
 TSK_FS_META_TYPE_SOCK
 TSK_FS_META_TYPE_STR_MAX
 TSK_FS_META_TYPE_UNDEF
 TSK_FS_META_TYPE_VIRT
 TSK_FS_META_TYPE_WHT
 TSK_FS_NAME_FLAG_ALLOC
 TSK_FS_NAME_FLAG_UNALLOC
 TSK_FS_NAME_TAG
 TSK_FS_NAME_TYPE_BLK
 TSK_FS_NAME_TYPE_CHR
 TSK_FS_NAME_TYPE_DIR
 TSK_FS_NAME_TYPE_FIFO
 TSK_FS_NAME_TYPE_LNK
 TSK_FS_NAME_TYPE_REG
 TSK_FS_NAME_TYPE_SHAD
 TSK_FS_NAME_TYPE_SOCK
 TSK_FS_NAME_TYPE_STR_MAX
 TSK_FS_NAME_TYPE_UNDEF
 TSK_FS_NAME_TYPE_VIRT
 TSK_FS_NAME_TYPE_WHT
 TSK_FS_ORPHAN_STR
 TSK_FS_TYPE_DETECT
 TSK_FS_TYPE_EXT2
 TSK_FS_TYPE_EXT3
 TSK_FS_TYPE_EXT4
 TSK_FS_TYPE_EXT_DETECT
 TSK_FS_TYPE_FAT12
 TSK_FS_TYPE_FAT16
 TSK_FS_TYPE_FAT32
 TSK_FS_TYPE_FAT_DETECT
 TSK_FS_TYPE_FFS1
 TSK_FS_TYPE_FFS1B
 TSK_FS_TYPE_FFS2
 TSK_FS_TYPE_FFS_DETECT
 TSK_FS_TYPE_HFS
 TSK_FS_TYPE_HFS_DETECT
 TSK_FS_TYPE_ISO9660
 TSK_FS_TYPE_ISO9660_DETECT
 TSK_FS_TYPE_NTFS
 TSK_FS_TYPE_NTFS_DETECT
 TSK_FS_TYPE_RAW
 TSK_FS_TYPE_RAW_DETECT
 TSK_FS_TYPE_SWAP
 TSK_FS_TYPE_SWAP_DETECT
 TSK_FS_TYPE_UNSUPP
 TSK_FS_TYPE_YAFFS2
 TSK_FS_TYPE_YAFFS2_DETECT
 TSK_IMG_INFO_CACHE_LEN
 TSK_IMG_INFO_CACHE_NUM
 TSK_IMG_INFO_TAG
 TSK_IMG_TYPE_AFF_AFD
 TSK_IMG_TYPE_AFF_AFF
 TSK_IMG_TYPE_AFF_AFM
 TSK_IMG_TYPE_AFF_ANY
 TSK_IMG_TYPE_DETECT
 TSK_IMG_TYPE_EWF_EWF
 TSK_IMG_TYPE_RAW
 TSK_IMG_TYPE_RAW_SING
 TSK_IMG_TYPE_RAW_SPLIT
 TSK_IMG_TYPE_UNSUPP
 TSK_LIT_ENDIAN
 TSK_MD5_DIGEST_LENGTH
 TSK_SHA_DIGEST_LENGTH
 TSK_VERSION_NUM
 TSK_VERSION_STR
 TSK_VS_INFO_TAG
 TSK_VS_PART_FLAG_ALL
 TSK_VS_PART_FLAG_ALLOC
 TSK_VS_PART_FLAG_META
 TSK_VS_PART_FLAG_UNALLOC
 TSK_VS_PART_INFO_TAG
 TSK_VS_TYPE_BSD
 TSK_VS_TYPE_DBFILLER
 TSK_VS_TYPE_DETECT
 TSK_VS_TYPE_DOS
 TSK_VS_TYPE_GPT
 TSK_VS_TYPE_MAC
 TSK_VS_TYPE_SUN
 TSK_VS_TYPE_UNSUPP
 TSK_WALK_CONT
 TSK_WALK_ERROR
 TSK_WALK_STOP
***********************************************************************/
#include <Python.h>
#include "/usr/local/include/tsk/libtsk.h"
#include "/usr/local/include/tsk/base/tsk_base.h"
#include "/usr/local/include/tsk/fs/tsk_fs.h"
#include "/usr/local/include/tsk/img/tsk_img.h"
#include "/usr/local/include/tsk/vs/tsk_vs.h"
#include "tsk3.h"

/* The following is a static array mapping CLASS() pointers to their
python wrappers. This is used to allow the correct wrapper to be
chosen depending on the object type found - regardless of the
prototype.

This is basically a safer way for us to cast the correct python type
depending on context rather than assuming a type based on the .h
definition. For example consider the function

AFFObject Resolver.open(uri, mode)

The .h file implies that an AFFObject object is returned, but this is
not true as most of the time an object of a derived class will be
returned. In C we cast the returned value to the correct type. In the
python wrapper we just instantiate the correct python object wrapper
at runtime depending on the actual returned type. We use this lookup
table to do so.
*/
static int TOTAL_CLASSES=0;

/* This is a global reference to this module so classes can call each
   other.
*/
static PyObject *g_module = NULL;

#define CONSTRUCT_INITIALIZE(class, virt_class, constructor, object, ...) \
    (class)(((virt_class) (&__ ## class))->constructor(object, ## __VA_ARGS__))

#undef BUFF_SIZE
#define BUFF_SIZE 10240

/** This is a generic wrapper type */
typedef struct Gen_wrapper_t *Gen_wrapper;
struct Gen_wrapper_t {
    PyObject_HEAD

    void *base;

    /* Value to indicate the base is a Python object.
     */
    int base_is_python_object;

    /* Value to indicate the base is managed internal.
     */
    int base_is_internal;

    PyObject *python_object1;
    PyObject *python_object2;
};

static struct python_wrapper_map_t {
    Object class_ref;
    PyTypeObject *python_type;
    void (*initialize_proxies)(Gen_wrapper self, void *item);
} python_wrappers[66];

/* Create the relevant wrapper from the item based on the lookup table.
*/
Gen_wrapper new_class_wrapper(Object item, int item_is_python_object) {
    Gen_wrapper result = NULL;
    Object cls = NULL;
    struct python_wrapper_map_t *python_wrapper = NULL;
    int cls_index = 0;

    // Return a Py_None object for a NULL pointer
    if(item == NULL) {
        Py_IncRef((PyObject *) Py_None);
        return (Gen_wrapper) Py_None;
    }
    // Search for subclasses
    for(cls = (Object) item->__class__; cls != cls->__super__; cls = cls->__super__) {
        for(cls_index = 0; cls_index < TOTAL_CLASSES; cls_index++) {
            python_wrapper = &(python_wrappers[cls_index]);

            if(python_wrapper->class_ref == cls) {
                PyErr_Clear();

                result = (Gen_wrapper) _PyObject_New(python_wrapper->python_type);
                result->base = item;
                result->base_is_python_object = item_is_python_object;
                result->base_is_internal = 1;
                result->python_object1 = NULL;
                result->python_object2 = NULL;

                python_wrapper->initialize_proxies(result, (void *) item);

                return result;
            }
        }
    }
    PyErr_Format(PyExc_RuntimeError, "Unable to find a wrapper for object %s", NAMEOF(item));

    return NULL;
}

static PyObject *resolve_exception(char **error_buff) {
  int *type = (int *)aff4_get_current_error(error_buff);
  switch(*type) {
case EProgrammingError:
    return PyExc_SystemError;
case EKeyError:
    return PyExc_KeyError;
case ERuntimeError:
    return PyExc_RuntimeError;
case EInvalidParameter:
    return PyExc_TypeError;
case EWarning:
    return PyExc_AssertionError;
case EIOError:
    return PyExc_IOError;
default:
    return PyExc_RuntimeError;
};
};

static int type_check(PyObject *obj, PyTypeObject *type) {
   PyTypeObject *tmp;

   // Recurse through the inheritance tree and check if the types are expected
   if(obj)
     for(tmp = obj->ob_type; tmp && tmp != &PyBaseObject_Type; tmp = tmp->tp_base) {
       if(tmp == type) return 1;
     };

  return 0;
};

static int check_error() {
   char *buffer = NULL;
   int *error_type = (int *)aff4_get_current_error(&buffer);

   if(*error_type != EZero) {
         PyObject *exception = resolve_exception(&buffer);

         if(buffer != NULL) {
           PyErr_Format(exception, "%s", buffer);
         } else {
           PyErr_Format(exception, "Unable to retrieve exception reason.");
         }
         ClearError();
         return 1;
   };
   return 0;
};

/** This function checks if a method was overridden in self over a
method defined in type. This is used to determine if a python class is
extending this C type. If not, a proxy function is not written and C
calls are made directly.

This is an optimization to eliminate the need for a call into python
in the case where python objects do not actually extend any methods.

We basically just iterate over the MRO and determine if a method is
defined in each level until we reach the base class.

*/
static int check_method_override(PyObject *self, PyTypeObject *type, char *method) {
    PyObject *mro = NULL;
    PyObject *py_method = NULL;
    PyObject *item_object = NULL;
    PyObject *dict = NULL;
    Py_ssize_t item_index = 0;
    Py_ssize_t number_of_items = 0;
    int found = 0;

    mro = self->ob_type->tp_mro;
    py_method = PyString_FromString(method);
    number_of_items = PySequence_Size(mro);

    for(item_index = 0; item_index < number_of_items; item_index++) {
        item_object = PySequence_GetItem(mro, item_index);

        // Ok - we got to the base class - finish up
        if(item_object == (PyObject *) type) {
            Py_DecRef(item_object);
            break;
        }
        /* Extract the dict and check if it contains the method (the
         * dict is not a real dictionary so we can not use
         * PyDict_Contains).
         */
        dict = PyObject_GetAttrString(item_object, "__dict__");
        if(dict != NULL && PySequence_Contains(dict, py_method)) {
            found = 1;
        }
        Py_DecRef(dict);
        Py_DecRef(item_object);

        if(found != 0) {
            break;
        }
    }
    Py_DecRef(py_method);
    PyErr_Clear();

    return found;
}

/******************** TSK_FS_BLOCK_WALK_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_BLOCK_WALK_FLAG_ENUM;



static PyObject *TSK_FS_BLOCK_WALK_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_BLOCK_WALK_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_BLOCK_WALK_FLAG_ENUM_Type;
static int pyTSK_FS_BLOCK_WALK_FLAG_ENUM_init(pyTSK_FS_BLOCK_WALK_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_FILE_READ_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_FILE_READ_FLAG_ENUM;



static PyObject *TSK_FS_FILE_READ_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_FILE_READ_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_FILE_READ_FLAG_ENUM_Type;
static int pyTSK_FS_FILE_READ_FLAG_ENUM_init(pyTSK_FS_FILE_READ_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_BLKLS_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_BLKLS_FLAG_ENUM;



static PyObject *TSK_FS_BLKLS_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_BLKLS_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_BLKLS_FLAG_ENUM_Type;
static int pyTSK_FS_BLKLS_FLAG_ENUM_init(pyTSK_FS_BLKLS_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_RETVAL_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_RETVAL_ENUM;



static PyObject *TSK_RETVAL_ENUM_Dict_lookup;
static PyObject *TSK_RETVAL_ENUM_rev_lookup;
staticforward PyTypeObject TSK_RETVAL_ENUM_Type;
static int pyTSK_RETVAL_ENUM_init(pyTSK_RETVAL_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_BLKCAT_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_BLKCAT_FLAG_ENUM;



static PyObject *TSK_FS_BLKCAT_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_BLKCAT_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_BLKCAT_FLAG_ENUM_Type;
static int pyTSK_FS_BLKCAT_FLAG_ENUM_init(pyTSK_FS_BLKCAT_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** Attribute ***********************/
typedef struct {
    PyObject_HEAD
    Attribute base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;

    void (*initialise)(Gen_wrapper self, void *item);
} pyAttribute;
staticforward PyTypeObject Attribute_Type;
static int pyAttribute_init(pyAttribute *self, PyObject *args, PyObject *kwds)
;
static void pyAttribute_initialize_proxies(pyAttribute *self, void *item);
static PyObject *pyAttribute_getattr(pyAttribute *self, PyObject *name);

static PyObject *pyAttribute___iter__(pyAttribute *self);
static void ProxiedAttribute___iter__(Attribute self);

static PyObject *pyAttribute_iternext(pyAttribute *self);
static TSK_FS_ATTR_RUN * ProxiedAttribute_iternext(Attribute self);
/******************** TSK_FS_META_TYPE_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_META_TYPE_ENUM;



static PyObject *TSK_FS_META_TYPE_ENUM_Dict_lookup;
static PyObject *TSK_FS_META_TYPE_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_META_TYPE_ENUM_Type;
static int pyTSK_FS_META_TYPE_ENUM_init(pyTSK_FS_META_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_NAME ***********************/
typedef struct {
    PyObject_HEAD
    TSK_FS_NAME *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_FS_NAME *cbase;
} pyTSK_FS_NAME;
staticforward PyTypeObject TSK_FS_NAME_Type;
static int pyTSK_FS_NAME_init(pyTSK_FS_NAME *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_FS_NAME_getattr(pyTSK_FS_NAME *self, PyObject *name);
/******************** TSK_FS_META_ATTR_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_META_ATTR_FLAG_ENUM;



static PyObject *TSK_FS_META_ATTR_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_META_ATTR_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_META_ATTR_FLAG_ENUM_Type;
static int pyTSK_FS_META_ATTR_FLAG_ENUM_init(pyTSK_FS_META_ATTR_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_TYPE_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_TYPE_ENUM;



static PyObject *TSK_FS_TYPE_ENUM_Dict_lookup;
static PyObject *TSK_FS_TYPE_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_TYPE_ENUM_Type;
static int pyTSK_FS_TYPE_ENUM_init(pyTSK_FS_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_ILS_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_ILS_FLAG_ENUM;



static PyObject *TSK_FS_ILS_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_ILS_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_ILS_FLAG_ENUM_Type;
static int pyTSK_FS_ILS_FLAG_ENUM_init(pyTSK_FS_ILS_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_META_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_META_FLAG_ENUM;



static PyObject *TSK_FS_META_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_META_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_META_FLAG_ENUM_Type;
static int pyTSK_FS_META_FLAG_ENUM_init(pyTSK_FS_META_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_FFIND_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_FFIND_FLAG_ENUM;



static PyObject *TSK_FS_FFIND_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_FFIND_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_FFIND_FLAG_ENUM_Type;
static int pyTSK_FS_FFIND_FLAG_ENUM_init(pyTSK_FS_FFIND_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_ATTR_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_ATTR_FLAG_ENUM;



static PyObject *TSK_FS_ATTR_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_ATTR_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_ATTR_FLAG_ENUM_Type;
static int pyTSK_FS_ATTR_FLAG_ENUM_init(pyTSK_FS_ATTR_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_BLOCK_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_BLOCK_FLAG_ENUM;



static PyObject *TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_BLOCK_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_BLOCK_FLAG_ENUM_Type;
static int pyTSK_FS_BLOCK_FLAG_ENUM_init(pyTSK_FS_BLOCK_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_ATTR_TYPE_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_ATTR_TYPE_ENUM;



static PyObject *TSK_FS_ATTR_TYPE_ENUM_Dict_lookup;
static PyObject *TSK_FS_ATTR_TYPE_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_ATTR_TYPE_ENUM_Type;
static int pyTSK_FS_ATTR_TYPE_ENUM_init(pyTSK_FS_ATTR_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_VS_PART_INFO ***********************/
typedef struct {
    PyObject_HEAD
    TSK_VS_PART_INFO *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_VS_PART_INFO *cbase;
} pyTSK_VS_PART_INFO;
staticforward PyTypeObject TSK_VS_PART_INFO_Type;
static int pyTSK_VS_PART_INFO_init(pyTSK_VS_PART_INFO *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_VS_PART_INFO_getattr(pyTSK_VS_PART_INFO *self, PyObject *name);
/******************** TSK_FS_NAME_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_NAME_FLAG_ENUM;



static PyObject *TSK_FS_NAME_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_NAME_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_NAME_FLAG_ENUM_Type;
static int pyTSK_FS_NAME_FLAG_ENUM_init(pyTSK_FS_NAME_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** Object ***********************/
typedef struct {
    PyObject_HEAD
    Object base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;

    void (*initialise)(Gen_wrapper self, void *item);
} pyObject;
staticforward PyTypeObject Object_Type;
static int pyObject_init(pyObject *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyObject_getattr(pyObject *self, PyObject *name);
/******************** TSK_FS_ATTR_RUN_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_ATTR_RUN_FLAG_ENUM;



static PyObject *TSK_FS_ATTR_RUN_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_ATTR_RUN_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_ATTR_RUN_FLAG_ENUM_Type;
static int pyTSK_FS_ATTR_RUN_FLAG_ENUM_init(pyTSK_FS_ATTR_RUN_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_VS_INFO ***********************/
typedef struct {
    PyObject_HEAD
    TSK_VS_INFO *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_VS_INFO *cbase;
} pyTSK_VS_INFO;
staticforward PyTypeObject TSK_VS_INFO_Type;
static int pyTSK_VS_INFO_init(pyTSK_VS_INFO *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_VS_INFO_getattr(pyTSK_VS_INFO *self, PyObject *name);
/******************** Extended_TSK_IMG_INFO ***********************/
typedef struct {
    PyObject_HEAD
    Extended_TSK_IMG_INFO *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    Extended_TSK_IMG_INFO *cbase;
} pyExtended_TSK_IMG_INFO;
staticforward PyTypeObject Extended_TSK_IMG_INFO_Type;
static int pyExtended_TSK_IMG_INFO_init(pyExtended_TSK_IMG_INFO *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyExtended_TSK_IMG_INFO_getattr(pyExtended_TSK_IMG_INFO *self, PyObject *name);
/******************** TSK_FS_META_MODE_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_META_MODE_ENUM;



static PyObject *TSK_FS_META_MODE_ENUM_Dict_lookup;
static PyObject *TSK_FS_META_MODE_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_META_MODE_ENUM_Type;
static int pyTSK_FS_META_MODE_ENUM_init(pyTSK_FS_META_MODE_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_IMG_TYPE_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_IMG_TYPE_ENUM;



static PyObject *TSK_IMG_TYPE_ENUM_Dict_lookup;
static PyObject *TSK_IMG_TYPE_ENUM_rev_lookup;
staticforward PyTypeObject TSK_IMG_TYPE_ENUM_Type;
static int pyTSK_IMG_TYPE_ENUM_init(pyTSK_IMG_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_META ***********************/
typedef struct {
    PyObject_HEAD
    TSK_FS_META *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_FS_META *cbase;
} pyTSK_FS_META;
staticforward PyTypeObject TSK_FS_META_Type;
static int pyTSK_FS_META_init(pyTSK_FS_META *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_FS_META_getattr(pyTSK_FS_META *self, PyObject *name);
/******************** Img_Info ***********************/
typedef struct {
    PyObject_HEAD
    Img_Info base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;

    void (*initialise)(Gen_wrapper self, void *item);
} pyImg_Info;
staticforward PyTypeObject Img_Info_Type;
static int pyImg_Info_init(pyImg_Info *self, PyObject *args, PyObject *kwds)
;
static void pyImg_Info_initialize_proxies(pyImg_Info *self, void *item);
static PyObject *pyImg_Info_getattr(pyImg_Info *self, PyObject *name);
static PyObject *pyImg_Info_read(pyImg_Info *self, PyObject *args, PyObject *kwds);
static uint64_t ProxiedImg_Info_read(Img_Info self, TSK_OFF_T off, OUT char * buf, size_t len);
static PyObject *pyImg_Info_get_size(pyImg_Info *self, PyObject *args, PyObject *kwds);
static uint64_t ProxiedImg_Info_get_size(Img_Info self);
static PyObject *pyImg_Info_close(pyImg_Info *self, PyObject *args, PyObject *kwds);
/******************** TSK_FS_DIR_WALK_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_DIR_WALK_FLAG_ENUM;



static PyObject *TSK_FS_DIR_WALK_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_DIR_WALK_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_DIR_WALK_FLAG_ENUM_Type;
static int pyTSK_FS_DIR_WALK_FLAG_ENUM_init(pyTSK_FS_DIR_WALK_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_ENDIAN_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_ENDIAN_ENUM;



static PyObject *TSK_ENDIAN_ENUM_Dict_lookup;
static PyObject *TSK_ENDIAN_ENUM_rev_lookup;
staticforward PyTypeObject TSK_ENDIAN_ENUM_Type;
static int pyTSK_ENDIAN_ENUM_init(pyTSK_ENDIAN_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_DIR ***********************/
typedef struct {
    PyObject_HEAD
    TSK_FS_DIR *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_FS_DIR *cbase;
} pyTSK_FS_DIR;
staticforward PyTypeObject TSK_FS_DIR_Type;
static int pyTSK_FS_DIR_init(pyTSK_FS_DIR *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_FS_DIR_getattr(pyTSK_FS_DIR *self, PyObject *name);
/******************** FS_Info ***********************/
typedef struct {
    PyObject_HEAD
    FS_Info base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;

    void (*initialise)(Gen_wrapper self, void *item);
} pyFS_Info;
staticforward PyTypeObject FS_Info_Type;
static int pyFS_Info_init(pyFS_Info *self, PyObject *args, PyObject *kwds)
;
static void pyFS_Info_initialize_proxies(pyFS_Info *self, void *item);
static PyObject *pyFS_Info_getattr(pyFS_Info *self, PyObject *name);
static PyObject *pyFS_Info_open_dir(pyFS_Info *self, PyObject *args, PyObject *kwds);
static Directory ProxiedFS_Info_open_dir(FS_Info self, ZString path, TSK_INUM_T inode);
static PyObject *pyFS_Info_open(pyFS_Info *self, PyObject *args, PyObject *kwds);
static File ProxiedFS_Info_open(FS_Info self, ZString path);
static PyObject *pyFS_Info_open_meta(pyFS_Info *self, PyObject *args, PyObject *kwds);
static File ProxiedFS_Info_open_meta(FS_Info self, TSK_INUM_T inode);
static PyObject *pyFS_Info_exit(pyFS_Info *self, PyObject *args, PyObject *kwds);
static void ProxiedFS_Info_exit(FS_Info self);
/******************** TSK_FS_BLKCALC_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_BLKCALC_FLAG_ENUM;



static PyObject *TSK_FS_BLKCALC_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_BLKCALC_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_BLKCALC_FLAG_ENUM_Type;
static int pyTSK_FS_BLKCALC_FLAG_ENUM_init(pyTSK_FS_BLKCALC_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_NAME_TYPE_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_NAME_TYPE_ENUM;



static PyObject *TSK_FS_NAME_TYPE_ENUM_Dict_lookup;
static PyObject *TSK_FS_NAME_TYPE_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_NAME_TYPE_ENUM_Type;
static int pyTSK_FS_NAME_TYPE_ENUM_init(pyTSK_FS_NAME_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_VS_TYPE_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_VS_TYPE_ENUM;



static PyObject *TSK_VS_TYPE_ENUM_Dict_lookup;
static PyObject *TSK_VS_TYPE_ENUM_rev_lookup;
staticforward PyTypeObject TSK_VS_TYPE_ENUM_Type;
static int pyTSK_VS_TYPE_ENUM_init(pyTSK_VS_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** Directory ***********************/
typedef struct {
    PyObject_HEAD
    Directory base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;

    void (*initialise)(Gen_wrapper self, void *item);
} pyDirectory;
staticforward PyTypeObject Directory_Type;
static int pyDirectory_init(pyDirectory *self, PyObject *args, PyObject *kwds)
;
static void pyDirectory_initialize_proxies(pyDirectory *self, void *item);
static PyObject *pyDirectory_getattr(pyDirectory *self, PyObject *name);

static PyObject *pyDirectory___iter__(pyDirectory *self);
static void ProxiedDirectory___iter__(Directory self);

static PyObject *pyDirectory_iternext(pyDirectory *self);
static File ProxiedDirectory_iternext(Directory self);
/******************** TSK_VS_PART_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_VS_PART_FLAG_ENUM;



static PyObject *TSK_VS_PART_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_VS_PART_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_VS_PART_FLAG_ENUM_Type;
static int pyTSK_VS_PART_FLAG_ENUM_init(pyTSK_VS_PART_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_FLS_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_FLS_FLAG_ENUM;



static PyObject *TSK_FS_FLS_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_FLS_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_FLS_FLAG_ENUM_Type;
static int pyTSK_FS_FLS_FLAG_ENUM_init(pyTSK_FS_FLS_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_INFO_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_INFO_FLAG_ENUM;



static PyObject *TSK_FS_INFO_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_INFO_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_INFO_FLAG_ENUM_Type;
static int pyTSK_FS_INFO_FLAG_ENUM_init(pyTSK_FS_INFO_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_INFO ***********************/
typedef struct {
    PyObject_HEAD
    TSK_FS_INFO *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_FS_INFO *cbase;
} pyTSK_FS_INFO;
staticforward PyTypeObject TSK_FS_INFO_Type;
static int pyTSK_FS_INFO_init(pyTSK_FS_INFO *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_FS_INFO_getattr(pyTSK_FS_INFO *self, PyObject *name);
/******************** TSK_FS_ATTR_RUN ***********************/
typedef struct {
    PyObject_HEAD
    TSK_FS_ATTR_RUN *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_FS_ATTR_RUN *cbase;
} pyTSK_FS_ATTR_RUN;
staticforward PyTypeObject TSK_FS_ATTR_RUN_Type;
static int pyTSK_FS_ATTR_RUN_init(pyTSK_FS_ATTR_RUN *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_FS_ATTR_RUN_getattr(pyTSK_FS_ATTR_RUN *self, PyObject *name);
/******************** TSK_FS_IFIND_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_IFIND_FLAG_ENUM;



static PyObject *TSK_FS_IFIND_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_IFIND_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_IFIND_FLAG_ENUM_Type;
static int pyTSK_FS_IFIND_FLAG_ENUM_init(pyTSK_FS_IFIND_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_FILE_WALK_FLAG_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_FS_FILE_WALK_FLAG_ENUM;



static PyObject *TSK_FS_FILE_WALK_FLAG_ENUM_Dict_lookup;
static PyObject *TSK_FS_FILE_WALK_FLAG_ENUM_rev_lookup;
staticforward PyTypeObject TSK_FS_FILE_WALK_FLAG_ENUM_Type;
static int pyTSK_FS_FILE_WALK_FLAG_ENUM_init(pyTSK_FS_FILE_WALK_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
;
/******************** TSK_FS_BLOCK ***********************/
typedef struct {
    PyObject_HEAD
    TSK_FS_BLOCK *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_FS_BLOCK *cbase;
} pyTSK_FS_BLOCK;
staticforward PyTypeObject TSK_FS_BLOCK_Type;
static int pyTSK_FS_BLOCK_init(pyTSK_FS_BLOCK *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_FS_BLOCK_getattr(pyTSK_FS_BLOCK *self, PyObject *name);
/******************** TSK_FS_ATTR ***********************/
typedef struct {
    PyObject_HEAD
    TSK_FS_ATTR *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_FS_ATTR *cbase;
} pyTSK_FS_ATTR;
staticforward PyTypeObject TSK_FS_ATTR_Type;
static int pyTSK_FS_ATTR_init(pyTSK_FS_ATTR *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_FS_ATTR_getattr(pyTSK_FS_ATTR *self, PyObject *name);
/******************** File ***********************/
typedef struct {
    PyObject_HEAD
    File base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;

    void (*initialise)(Gen_wrapper self, void *item);
} pyFile;
staticforward PyTypeObject File_Type;
static int pyFile_init(pyFile *self, PyObject *args, PyObject *kwds)
;
static void pyFile_initialize_proxies(pyFile *self, void *item);
static PyObject *pyFile_getattr(pyFile *self, PyObject *name);
static PyObject *pyFile_read_random(pyFile *self, PyObject *args, PyObject *kwds);
static uint64_t ProxiedFile_read_random(File self, TSK_OFF_T offset, OUT char * buff, int len, TSK_FS_ATTR_TYPE_ENUM type, int id, TSK_FS_FILE_READ_FLAG_ENUM flags);
static PyObject *pyFile_as_directory(pyFile *self, PyObject *args, PyObject *kwds);
static Directory ProxiedFile_as_directory(File self);

static PyObject *pyFile___iter__(pyFile *self);
static void ProxiedFile___iter__(File self);

static PyObject *pyFile_iternext(pyFile *self);
static Attribute ProxiedFile_iternext(File self);
/******************** TSK_FS_FILE ***********************/
typedef struct {
    PyObject_HEAD
    TSK_FS_FILE *base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;
    TSK_FS_FILE *cbase;
} pyTSK_FS_FILE;
staticforward PyTypeObject TSK_FS_FILE_Type;
static int pyTSK_FS_FILE_init(pyTSK_FS_FILE *self, PyObject *args, PyObject *kwds)
;
static PyObject *pyTSK_FS_FILE_getattr(pyTSK_FS_FILE *self, PyObject *name);
/******************** Volume_Info ***********************/
typedef struct {
    PyObject_HEAD
    Volume_Info base;
    int base_is_python_object;
    int base_is_internal;
    PyObject *python_object1;
    PyObject *python_object2;
    int object_is_proxied;

    void (*initialise)(Gen_wrapper self, void *item);
} pyVolume_Info;
staticforward PyTypeObject Volume_Info_Type;
static int pyVolume_Info_init(pyVolume_Info *self, PyObject *args, PyObject *kwds)
;
static void pyVolume_Info_initialize_proxies(pyVolume_Info *self, void *item);
static PyObject *pyVolume_Info_getattr(pyVolume_Info *self, PyObject *name);

static PyObject *pyVolume_Info___iter__(pyVolume_Info *self);
static void ProxiedVolume_Info___iter__(Volume_Info self);

static PyObject *pyVolume_Info_iternext(pyVolume_Info *self);
static TSK_VS_PART_INFO * ProxiedVolume_Info_iternext(Volume_Info self);
/******************** TSK_WALK_RET_ENUM ***********************/
typedef struct {
  PyObject_HEAD
  PyObject *value;
} pyTSK_WALK_RET_ENUM;



static PyObject *TSK_WALK_RET_ENUM_Dict_lookup;
static PyObject *TSK_WALK_RET_ENUM_rev_lookup;
staticforward PyTypeObject TSK_WALK_RET_ENUM_Type;
static int pyTSK_WALK_RET_ENUM_init(pyTSK_WALK_RET_ENUM *self, PyObject *args, PyObject *kwds)
;
/*****************************************************
             Implementation
******************************************************/

static PyMethodDef TSK_FS_BLOCK_WALK_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_BLOCK_WALK_FLAG_ENUM_dealloc(pyTSK_FS_BLOCK_WALK_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_BLOCK_WALK_FLAG_ENUM_init(pyTSK_FS_BLOCK_WALK_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_BLOCK_WALK_FLAG_ENUM___str__(pyTSK_FS_BLOCK_WALK_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_BLOCK_WALK_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_BLOCK_WALK_FLAG_ENUM *self = (pyTSK_FS_BLOCK_WALK_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_BLOCK_WALK_FLAG_ENUM_int(pyTSK_FS_BLOCK_WALK_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_BLOCK_WALK_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_BLOCK_WALK_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_BLOCK_WALK_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_BLOCK_WALK_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_BLOCK_WALK_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_BLOCK_WALK_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_BLOCK_WALK_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_BLOCK_WALK_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_BLOCK_WALK_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_BLOCK_WALK_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_BLOCK_WALK_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_BLOCK_WALK_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_FILE_READ_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_FILE_READ_FLAG_ENUM_dealloc(pyTSK_FS_FILE_READ_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_FILE_READ_FLAG_ENUM_init(pyTSK_FS_FILE_READ_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_FILE_READ_FLAG_ENUM___str__(pyTSK_FS_FILE_READ_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_FILE_READ_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_FILE_READ_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_FILE_READ_FLAG_ENUM *self = (pyTSK_FS_FILE_READ_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_FILE_READ_FLAG_ENUM_int(pyTSK_FS_FILE_READ_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_FILE_READ_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_FILE_READ_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_FILE_READ_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_FILE_READ_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_FILE_READ_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_FILE_READ_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_FILE_READ_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_FILE_READ_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_FILE_READ_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_FILE_READ_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_FILE_READ_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_FILE_READ_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_BLKLS_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_BLKLS_FLAG_ENUM_dealloc(pyTSK_FS_BLKLS_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_BLKLS_FLAG_ENUM_init(pyTSK_FS_BLKLS_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_BLKLS_FLAG_ENUM___str__(pyTSK_FS_BLKLS_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_BLKLS_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_BLKLS_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_BLKLS_FLAG_ENUM *self = (pyTSK_FS_BLKLS_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_BLKLS_FLAG_ENUM_int(pyTSK_FS_BLKLS_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_BLKLS_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_BLKLS_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_BLKLS_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_BLKLS_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_BLKLS_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_BLKLS_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_BLKLS_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_BLKLS_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_BLKLS_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_BLKLS_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_BLKLS_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_BLKLS_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_RETVAL_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_RETVAL_ENUM_dealloc(pyTSK_RETVAL_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_RETVAL_ENUM_init(pyTSK_RETVAL_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_RETVAL_ENUM___str__(pyTSK_RETVAL_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_RETVAL_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_RETVAL_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_RETVAL_ENUM *self = (pyTSK_RETVAL_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_RETVAL_ENUM_int(pyTSK_RETVAL_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_RETVAL_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_RETVAL_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_RETVAL_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_RETVAL_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_RETVAL_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_RETVAL_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_RETVAL_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_RETVAL_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_RETVAL_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_RETVAL_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_RETVAL_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_RETVAL_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_BLKCAT_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_BLKCAT_FLAG_ENUM_dealloc(pyTSK_FS_BLKCAT_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_BLKCAT_FLAG_ENUM_init(pyTSK_FS_BLKCAT_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_BLKCAT_FLAG_ENUM___str__(pyTSK_FS_BLKCAT_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_BLKCAT_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_BLKCAT_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_BLKCAT_FLAG_ENUM *self = (pyTSK_FS_BLKCAT_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_BLKCAT_FLAG_ENUM_int(pyTSK_FS_BLKCAT_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_BLKCAT_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_BLKCAT_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_BLKCAT_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_BLKCAT_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_BLKCAT_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_BLKCAT_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_BLKCAT_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_BLKCAT_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_BLKCAT_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_BLKCAT_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_BLKCAT_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_BLKCAT_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef Attribute_methods[] = {
    {NULL}  /* Sentinel */
};

static void Attribute_dealloc(pyAttribute *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            if(self->base_is_python_object != 0) {
                Py_DecRef((PyObject*) self->base);
            } else if(self->base_is_internal != 0) {
                talloc_free(self->base);
            }
            self->base = NULL;
        }
        if(self->python_object2 != NULL) {
            Py_DecRef(self->python_object2);
            self->python_object2 = NULL;
        }
        if(self->python_object1 != NULL) {
            Py_DecRef(self->python_object1);
            self->python_object1 = NULL;
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static void pyAttribute_initialize_proxies(pyAttribute *self, void *item) {
    Attribute target = (Attribute) item;

    // Maintain a reference to the python object in the C object extension
    ((Object) item)->extension = self;

    if(check_method_override((PyObject *) self, &Attribute_Type, "iternext")) {
        // Proxy the iternext method
        ((Attribute) target)->iternext = ProxiedAttribute_iternext;
    }
}

static int pyAttribute_init(pyAttribute *self, PyObject *args, PyObject *kwds)
{
    Attribute result_constructor = NULL;
    // DEBUG: local arg type: PointerStructWrapper
Gen_wrapper wrapped_info = NULL; TSK_FS_ATTR *info=NULL;

    static char *kwlist[] = {"info", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist,&wrapped_info)) {
        goto on_error;
    }
    self->python_object1 = NULL;
    self->python_object2 = NULL;
    // Initialise is used to keep a reference on the object?
    // If not called no longer valid warnings have been seen on Windows.
    self->initialise = (void *) pyAttribute_initialize_proxies;

    if(wrapped_info == NULL || (PyObject *)wrapped_info == Py_None) {
        info = NULL;
    } else if(!type_check((PyObject *)wrapped_info,&TSK_FS_ATTR_Type)) {
        PyErr_Format(PyExc_RuntimeError, "info must be derived from type TSK_FS_ATTR");
        goto on_error;
    } else if(wrapped_info->base == NULL) {
        PyErr_Format(PyExc_RuntimeError, "TSK_FS_ATTR instance is no longer valid (was it gc'ed?)");
        goto on_error;
    } else {
        info = wrapped_info->base;
        if(self->python_object1 == NULL) {
            self->python_object1 = (PyObject *) wrapped_info;
            Py_IncRef(self->python_object1);
        }
    }
    ClearError();

    // Allocate a new instance
    self->base = (Attribute) alloc_Attribute();
    self->base_is_python_object = 0;
    self->base_is_internal = 1;
    self->object_is_proxied = 0;

    // Update the target by replacing its methods with proxies to call back into Python
    pyAttribute_initialize_proxies(self, self->base);

    // Now call the constructor
    Py_BEGIN_ALLOW_THREADS
    result_constructor = CONSTRUCT_INITIALIZE(Attribute, Attribute, Con, self->base, info);
    Py_END_ALLOW_THREADS

    if(!CheckError(EZero)) {
        char *buffer = NULL;
        PyObject *exception = resolve_exception(&buffer);

        PyErr_Format(exception, "%s", buffer);
        ClearError();
        goto on_error;
    }
    if(result_constructor == NULL) {
        PyErr_Format(PyExc_IOError, "Unable to construct class Attribute");
        goto on_error;
    }

    return 0;

on_error:
    if(self->python_object2 != NULL) {
        Py_DecRef(self->python_object2);
        self->python_object2 = NULL;
    }
    if(self->python_object1 != NULL) {
        Py_DecRef(self->python_object1);
        self->python_object1 = NULL;
    }
    if(self->base != NULL) {
        talloc_free(self->base);
        self->base = NULL;
    }
    return -1;
}

static PyObject *pyAttribute_getattr(pyAttribute *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (Attribute.pyAttribute_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("info");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("current");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=Attribute_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "info") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_info = NULL;


        PyErr_Clear();

        wrapped_info = (Gen_wrapper) PyObject_New(pyTSK_FS_ATTR, &TSK_FS_ATTR_Type);

        // Base is borrowed from another object.
        wrapped_info->base = (((Attribute) self->base)->info);
        wrapped_info->base_is_python_object = 0;
        wrapped_info->base_is_internal = 0;
        wrapped_info->python_object1 = NULL;
        wrapped_info->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_info->base == NULL) {
            Py_DecRef((PyObject *) wrapped_info);
            Py_IncRef(Py_None);
            wrapped_info = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_info;


        return Py_result;
    }
    if(strcmp(name, "current") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_current = NULL;


        PyErr_Clear();

        wrapped_current = (Gen_wrapper) PyObject_New(pyTSK_FS_ATTR_RUN, &TSK_FS_ATTR_RUN_Type);

        // Base is borrowed from another object.
        wrapped_current->base = (((Attribute) self->base)->current);
        wrapped_current->base_is_python_object = 0;
        wrapped_current->base_is_internal = 0;
        wrapped_current->python_object1 = NULL;
        wrapped_current->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_current->base == NULL) {
            Py_DecRef((PyObject *) wrapped_current);
            Py_IncRef(Py_None);
            wrapped_current = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_current;


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
void Attribute.__iter__();
********************************************************/

static PyObject *pyAttribute___iter__(pyAttribute *self){
          ((Attribute)self->base)->__iter__((Attribute)self->base);
          return PyObject_SelfIter((PyObject *)self);
};
static void ProxiedAttribute___iter__(Attribute self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("__iter__");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in Attribute");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;
}


/********************************************************
Autogenerated wrapper for function:
TSK_FS_ATTR_RUN * Attribute.iternext();
********************************************************/

static PyObject *pyAttribute_iternext(pyAttribute *self){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: PointerStructWrapper
    Gen_wrapper wrapped_func_return = NULL;
    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "Attribute object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((Attribute)self->base)->iternext;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "Attribute.iternext is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();

        PyErr_Clear();

        wrapped_func_return = (Gen_wrapper) PyObject_New(pyTSK_FS_ATTR_RUN, &TSK_FS_ATTR_RUN_Type);

        wrapped_func_return->base = ((Attribute) self->base)->iternext(((Attribute) self->base));
        wrapped_func_return->base_is_python_object = 0;
        wrapped_func_return->base_is_internal = 1;
        wrapped_func_return->python_object1 = NULL;
        wrapped_func_return->python_object2 = NULL;

        if(wrapped_func_return->base == NULL) {
             Py_DecRef((PyObject *) wrapped_func_return);
             return NULL;
        }
        // A NULL object gets translated to a None
        if(wrapped_func_return->base == NULL) {
            Py_DecRef((PyObject *) wrapped_func_return);
            Py_IncRef(Py_None);
            wrapped_func_return = (Gen_wrapper) Py_None;
        }
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_result = (PyObject *)wrapped_func_return;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static TSK_FS_ATTR_RUN * ProxiedAttribute_iternext(Attribute self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
TSK_FS_ATTR_RUN * func_return = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("iternext");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in Attribute");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

func_return = ((Gen_wrapper) Py_result)->base;
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return NULL;
}


static int
Attribute_nonzero(pyAttribute *v)
{
        return v->base != 0;
};
static PyNumberMethods Attribute_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       Attribute_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject Attribute_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.Attribute",
    /* tp_basicsize */
    sizeof(pyAttribute),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) Attribute_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &Attribute_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyAttribute_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "Attribute:  An attribute is associated with a file. In some filesystem\n    (e.g. NTFS) a file may contain many attributes.\n\n    Attributes can be iterated over to obtain the attribute runs\n    (e.g. to recover block allocation information).\n\n",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) pyAttribute___iter__,
    /* tp_iternext */
    (iternextfunc) pyAttribute_iternext,
    /* tp_methods */
    Attribute_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyAttribute_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_META_TYPE_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_META_TYPE_ENUM_dealloc(pyTSK_FS_META_TYPE_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_META_TYPE_ENUM_init(pyTSK_FS_META_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_META_TYPE_ENUM___str__(pyTSK_FS_META_TYPE_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_META_TYPE_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_META_TYPE_ENUM *self = (pyTSK_FS_META_TYPE_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_META_TYPE_ENUM_int(pyTSK_FS_META_TYPE_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_META_TYPE_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_META_TYPE_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_META_TYPE_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_META_TYPE_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_META_TYPE_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_META_TYPE_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_META_TYPE_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_META_TYPE_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_META_TYPE_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_META_TYPE_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_META_TYPE_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_META_TYPE_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_NAME_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_NAME_dealloc(pyTSK_FS_NAME *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_FS_NAME_init(pyTSK_FS_NAME *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_FS_NAME);
    // self->base = (TSK_FS_NAME *) PyMem_Malloc(sizeof(TSK_FS_NAME));
    return 0;
}

static PyObject *pyTSK_FS_NAME_getattr(pyTSK_FS_NAME *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_FS_NAME.pyTSK_FS_NAME_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("tag");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("name");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("name_size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("shrt_name");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("shrt_name_size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("meta_addr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("meta_seq");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("par_addr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("par_seq");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("type");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("flags");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_FS_NAME_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "tag") == 0) {
        PyObject *Py_result = NULL;
int UNUSED tag;


Py_BEGIN_ALLOW_THREADS
tag = (self->base->tag);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(tag);


        return Py_result;
    }
    if(strcmp(name, "name") == 0) {
        PyObject *Py_result = NULL;
char * UNUSED name;


Py_BEGIN_ALLOW_THREADS
name = (self->base->name);
Py_END_ALLOW_THREADS

    PyErr_Clear();

    if(!name) {
        Py_IncRef(Py_None);
        Py_result = Py_None;
    } else {
        Py_result = PyString_FromStringAndSize((char *)name, strlen(name));
        if(!Py_result) goto on_error;
    };


        return Py_result;
    }
    if(strcmp(name, "name_size") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED name_size;


Py_BEGIN_ALLOW_THREADS
name_size = (self->base->name_size);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(name_size);
#else
    Py_result = PyLong_FromUnsignedLong(name_size);
#endif


        return Py_result;
    }
    if(strcmp(name, "shrt_name") == 0) {
        PyObject *Py_result = NULL;
char * UNUSED shrt_name;


Py_BEGIN_ALLOW_THREADS
shrt_name = (self->base->shrt_name);
Py_END_ALLOW_THREADS

    PyErr_Clear();

    if(!shrt_name) {
        Py_IncRef(Py_None);
        Py_result = Py_None;
    } else {
        Py_result = PyString_FromStringAndSize((char *)shrt_name, strlen(shrt_name));
        if(!Py_result) goto on_error;
    };


        return Py_result;
    }
    if(strcmp(name, "shrt_name_size") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED shrt_name_size;


Py_BEGIN_ALLOW_THREADS
shrt_name_size = (self->base->shrt_name_size);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(shrt_name_size);
#else
    Py_result = PyLong_FromUnsignedLong(shrt_name_size);
#endif


        return Py_result;
    }
    if(strcmp(name, "meta_addr") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED meta_addr;


Py_BEGIN_ALLOW_THREADS
meta_addr = (self->base->meta_addr);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(meta_addr);
#else
    Py_result = PyLong_FromUnsignedLong(meta_addr);
#endif


        return Py_result;
    }
    if(strcmp(name, "meta_seq") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED meta_seq;


Py_BEGIN_ALLOW_THREADS
meta_seq = (self->base->meta_seq);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) meta_seq);


        return Py_result;
    }
    if(strcmp(name, "par_addr") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED par_addr;


Py_BEGIN_ALLOW_THREADS
par_addr = (self->base->par_addr);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(par_addr);
#else
    Py_result = PyLong_FromUnsignedLong(par_addr);
#endif


        return Py_result;
    }
    if(strcmp(name, "par_seq") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED par_seq;


Py_BEGIN_ALLOW_THREADS
par_seq = (self->base->par_seq);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) par_seq);


        return Py_result;
    }
    if(strcmp(name, "type") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED type = 0;


Py_BEGIN_ALLOW_THREADS
type = (self->base->type);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_NAME_TYPE_ENUM", "K", (uint64_t)type);


        return Py_result;
    }
    if(strcmp(name, "flags") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED flags = 0;


Py_BEGIN_ALLOW_THREADS
flags = (self->base->flags);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_NAME_FLAG_ENUM", "K", (uint64_t)flags);


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_FS_NAME_nonzero(pyTSK_FS_NAME *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_FS_NAME_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_FS_NAME_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_NAME_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_NAME",
    /* tp_basicsize */
    sizeof(pyTSK_FS_NAME),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_NAME_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_NAME_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_FS_NAME_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_NAME: \n    * Generic structure to store the file name information that is stored in\n    * a directory. Most file systems seperate the file name from the metadata, but\n    * some do not (such as FAT). This structure contains the name and address of the \n    * metadata.\n    ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_NAME_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_NAME_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_META_ATTR_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_META_ATTR_FLAG_ENUM_dealloc(pyTSK_FS_META_ATTR_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_META_ATTR_FLAG_ENUM_init(pyTSK_FS_META_ATTR_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_META_ATTR_FLAG_ENUM___str__(pyTSK_FS_META_ATTR_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_META_ATTR_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_META_ATTR_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_META_ATTR_FLAG_ENUM *self = (pyTSK_FS_META_ATTR_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_META_ATTR_FLAG_ENUM_int(pyTSK_FS_META_ATTR_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_META_ATTR_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_META_ATTR_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_META_ATTR_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_META_ATTR_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_META_ATTR_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_META_ATTR_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_META_ATTR_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_META_ATTR_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_META_ATTR_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_META_ATTR_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_META_ATTR_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_META_ATTR_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_TYPE_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_TYPE_ENUM_dealloc(pyTSK_FS_TYPE_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_TYPE_ENUM_init(pyTSK_FS_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_TYPE_ENUM___str__(pyTSK_FS_TYPE_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_TYPE_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_TYPE_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_TYPE_ENUM *self = (pyTSK_FS_TYPE_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_TYPE_ENUM_int(pyTSK_FS_TYPE_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_TYPE_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_TYPE_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_TYPE_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_TYPE_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_TYPE_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_TYPE_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_TYPE_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_TYPE_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_TYPE_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_TYPE_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_TYPE_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_TYPE_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_ILS_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_ILS_FLAG_ENUM_dealloc(pyTSK_FS_ILS_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_ILS_FLAG_ENUM_init(pyTSK_FS_ILS_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_ILS_FLAG_ENUM___str__(pyTSK_FS_ILS_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_ILS_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_ILS_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_ILS_FLAG_ENUM *self = (pyTSK_FS_ILS_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_ILS_FLAG_ENUM_int(pyTSK_FS_ILS_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_ILS_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_ILS_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_ILS_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_ILS_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_ILS_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_ILS_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_ILS_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_ILS_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_ILS_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_ILS_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_ILS_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_ILS_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_META_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_META_FLAG_ENUM_dealloc(pyTSK_FS_META_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_META_FLAG_ENUM_init(pyTSK_FS_META_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_META_FLAG_ENUM___str__(pyTSK_FS_META_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_META_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_META_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_META_FLAG_ENUM *self = (pyTSK_FS_META_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_META_FLAG_ENUM_int(pyTSK_FS_META_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_META_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_META_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_META_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_META_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_META_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_META_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_META_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_META_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_META_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_META_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_META_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_META_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_FFIND_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_FFIND_FLAG_ENUM_dealloc(pyTSK_FS_FFIND_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_FFIND_FLAG_ENUM_init(pyTSK_FS_FFIND_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_FFIND_FLAG_ENUM___str__(pyTSK_FS_FFIND_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_FFIND_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_FFIND_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_FFIND_FLAG_ENUM *self = (pyTSK_FS_FFIND_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_FFIND_FLAG_ENUM_int(pyTSK_FS_FFIND_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_FFIND_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_FFIND_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_FFIND_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_FFIND_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_FFIND_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_FFIND_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_FFIND_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_FFIND_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_FFIND_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_FFIND_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_FFIND_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_FFIND_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_ATTR_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_ATTR_FLAG_ENUM_dealloc(pyTSK_FS_ATTR_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_ATTR_FLAG_ENUM_init(pyTSK_FS_ATTR_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_ATTR_FLAG_ENUM___str__(pyTSK_FS_ATTR_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_ATTR_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_ATTR_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_ATTR_FLAG_ENUM *self = (pyTSK_FS_ATTR_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_ATTR_FLAG_ENUM_int(pyTSK_FS_ATTR_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_ATTR_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_ATTR_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_ATTR_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_ATTR_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_ATTR_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_ATTR_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_ATTR_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_ATTR_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_ATTR_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_ATTR_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_ATTR_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_ATTR_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_BLOCK_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_BLOCK_FLAG_ENUM_dealloc(pyTSK_FS_BLOCK_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_BLOCK_FLAG_ENUM_init(pyTSK_FS_BLOCK_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_BLOCK_FLAG_ENUM___str__(pyTSK_FS_BLOCK_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_BLOCK_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_BLOCK_FLAG_ENUM *self = (pyTSK_FS_BLOCK_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_BLOCK_FLAG_ENUM_int(pyTSK_FS_BLOCK_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_BLOCK_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_BLOCK_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_BLOCK_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_BLOCK_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_BLOCK_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_BLOCK_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_BLOCK_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_BLOCK_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_BLOCK_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_BLOCK_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_BLOCK_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_BLOCK_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_ATTR_TYPE_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_ATTR_TYPE_ENUM_dealloc(pyTSK_FS_ATTR_TYPE_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_ATTR_TYPE_ENUM_init(pyTSK_FS_ATTR_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_ATTR_TYPE_ENUM___str__(pyTSK_FS_ATTR_TYPE_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_ATTR_TYPE_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_ATTR_TYPE_ENUM *self = (pyTSK_FS_ATTR_TYPE_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_ATTR_TYPE_ENUM_int(pyTSK_FS_ATTR_TYPE_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_ATTR_TYPE_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_ATTR_TYPE_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_ATTR_TYPE_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_ATTR_TYPE_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_ATTR_TYPE_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_ATTR_TYPE_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_ATTR_TYPE_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_ATTR_TYPE_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_ATTR_TYPE_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_ATTR_TYPE_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_ATTR_TYPE_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_ATTR_TYPE_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_VS_PART_INFO_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_VS_PART_INFO_dealloc(pyTSK_VS_PART_INFO *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_VS_PART_INFO_init(pyTSK_VS_PART_INFO *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_VS_PART_INFO);
    // self->base = (TSK_VS_PART_INFO *) PyMem_Malloc(sizeof(TSK_VS_PART_INFO));
    return 0;
}

static PyObject *pyTSK_VS_PART_INFO_getattr(pyTSK_VS_PART_INFO *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_VS_PART_INFO.pyTSK_VS_PART_INFO_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("tag");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("prev");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("next");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("vs");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("start");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("len");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("desc");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("table_num");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("slot_num");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("addr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("flags");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_VS_PART_INFO_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "tag") == 0) {
        PyObject *Py_result = NULL;
int UNUSED tag;


Py_BEGIN_ALLOW_THREADS
tag = (self->base->tag);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(tag);


        return Py_result;
    }
    if(strcmp(name, "prev") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_prev = NULL;


        PyErr_Clear();

        wrapped_prev = (Gen_wrapper) PyObject_New(pyTSK_VS_PART_INFO, &TSK_VS_PART_INFO_Type);

        // Base is borrowed from another object.
        wrapped_prev->base = (self->base->prev);
        wrapped_prev->base_is_python_object = 0;
        wrapped_prev->base_is_internal = 0;
        wrapped_prev->python_object1 = NULL;
        wrapped_prev->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_prev->base == NULL) {
            Py_DecRef((PyObject *) wrapped_prev);
            Py_IncRef(Py_None);
            wrapped_prev = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_prev;


        return Py_result;
    }
    if(strcmp(name, "next") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_next = NULL;


        PyErr_Clear();

        wrapped_next = (Gen_wrapper) PyObject_New(pyTSK_VS_PART_INFO, &TSK_VS_PART_INFO_Type);

        // Base is borrowed from another object.
        wrapped_next->base = (self->base->next);
        wrapped_next->base_is_python_object = 0;
        wrapped_next->base_is_internal = 0;
        wrapped_next->python_object1 = NULL;
        wrapped_next->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_next->base == NULL) {
            Py_DecRef((PyObject *) wrapped_next);
            Py_IncRef(Py_None);
            wrapped_next = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_next;


        return Py_result;
    }
    if(strcmp(name, "vs") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_vs = NULL;


        PyErr_Clear();

        wrapped_vs = (Gen_wrapper) PyObject_New(pyTSK_VS_INFO, &TSK_VS_INFO_Type);

        // Base is borrowed from another object.
        wrapped_vs->base = (self->base->vs);
        wrapped_vs->base_is_python_object = 0;
        wrapped_vs->base_is_internal = 0;
        wrapped_vs->python_object1 = NULL;
        wrapped_vs->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_vs->base == NULL) {
            Py_DecRef((PyObject *) wrapped_vs);
            Py_IncRef(Py_None);
            wrapped_vs = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_vs;


        return Py_result;
    }
    if(strcmp(name, "start") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED start;


Py_BEGIN_ALLOW_THREADS
start = (self->base->start);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(start);
#else
    Py_result = PyLong_FromUnsignedLong(start);
#endif


        return Py_result;
    }
    if(strcmp(name, "len") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED len;


Py_BEGIN_ALLOW_THREADS
len = (self->base->len);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(len);
#else
    Py_result = PyLong_FromUnsignedLong(len);
#endif


        return Py_result;
    }
    if(strcmp(name, "desc") == 0) {
        PyObject *Py_result = NULL;
char * UNUSED desc;


Py_BEGIN_ALLOW_THREADS
desc = (self->base->desc);
Py_END_ALLOW_THREADS

    PyErr_Clear();

    if(!desc) {
        Py_IncRef(Py_None);
        Py_result = Py_None;
    } else {
        Py_result = PyString_FromStringAndSize((char *)desc, strlen(desc));
        if(!Py_result) goto on_error;
    };


        return Py_result;
    }
    if(strcmp(name, "table_num") == 0) {
        PyObject *Py_result = NULL;
int8_t  UNUSED table_num;


Py_BEGIN_ALLOW_THREADS
table_num = (self->base->table_num);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(table_num);


        return Py_result;
    }
    if(strcmp(name, "slot_num") == 0) {
        PyObject *Py_result = NULL;
int8_t  UNUSED slot_num;


Py_BEGIN_ALLOW_THREADS
slot_num = (self->base->slot_num);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(slot_num);


        return Py_result;
    }
    if(strcmp(name, "addr") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED addr;


Py_BEGIN_ALLOW_THREADS
addr = (self->base->addr);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) addr);


        return Py_result;
    }
    if(strcmp(name, "flags") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED flags = 0;


Py_BEGIN_ALLOW_THREADS
flags = (self->base->flags);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_VS_PART_FLAG_ENUM", "K", (uint64_t)flags);


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_VS_PART_INFO_nonzero(pyTSK_VS_PART_INFO *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_VS_PART_INFO_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_VS_PART_INFO_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_VS_PART_INFO_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_VS_PART_INFO",
    /* tp_basicsize */
    sizeof(pyTSK_VS_PART_INFO),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_VS_PART_INFO_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_VS_PART_INFO_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_VS_PART_INFO_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_VS_PART_INFO: \n    * Linked list entry that describes a volume in a generic way. \n    ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_VS_PART_INFO_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_VS_PART_INFO_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_NAME_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_NAME_FLAG_ENUM_dealloc(pyTSK_FS_NAME_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_NAME_FLAG_ENUM_init(pyTSK_FS_NAME_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_NAME_FLAG_ENUM___str__(pyTSK_FS_NAME_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_NAME_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_NAME_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_NAME_FLAG_ENUM *self = (pyTSK_FS_NAME_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_NAME_FLAG_ENUM_int(pyTSK_FS_NAME_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_NAME_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_NAME_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_NAME_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_NAME_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_NAME_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_NAME_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_NAME_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_NAME_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_NAME_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_NAME_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_NAME_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_NAME_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef Object_methods[] = {
    {NULL}  /* Sentinel */
};

static void Object_dealloc(pyObject *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            if(self->base_is_python_object != 0) {
                Py_DecRef((PyObject*) self->base);
            } else if(self->base_is_internal != 0) {
                talloc_free(self->base);
            }
            self->base = NULL;
        }
        if(self->python_object2 != NULL) {
            Py_DecRef(self->python_object2);
            self->python_object2 = NULL;
        }
        if(self->python_object1 != NULL) {
            Py_DecRef(self->python_object1);
            self->python_object1 = NULL;
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyObject_init(pyObject *self, PyObject *args, PyObject *kwds) {
    return 0;
}

static PyObject *pyObject_getattr(pyObject *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (Object.pyObject_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;


        for(i=Object_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
Object_nonzero(pyObject *v)
{
        return v->base != 0;
};
static PyNumberMethods Object_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       Object_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject Object_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.Object",
    /* tp_basicsize */
    sizeof(pyObject),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) Object_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &Object_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyObject_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "Object:  Base object\n",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    Object_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyObject_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_ATTR_RUN_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_ATTR_RUN_FLAG_ENUM_dealloc(pyTSK_FS_ATTR_RUN_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_ATTR_RUN_FLAG_ENUM_init(pyTSK_FS_ATTR_RUN_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_ATTR_RUN_FLAG_ENUM___str__(pyTSK_FS_ATTR_RUN_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_ATTR_RUN_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_ATTR_RUN_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_ATTR_RUN_FLAG_ENUM *self = (pyTSK_FS_ATTR_RUN_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_ATTR_RUN_FLAG_ENUM_int(pyTSK_FS_ATTR_RUN_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_ATTR_RUN_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_ATTR_RUN_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_ATTR_RUN_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_ATTR_RUN_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_ATTR_RUN_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_ATTR_RUN_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_ATTR_RUN_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_ATTR_RUN_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_ATTR_RUN_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_ATTR_RUN_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_ATTR_RUN_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_ATTR_RUN_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_VS_INFO_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_VS_INFO_dealloc(pyTSK_VS_INFO *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_VS_INFO_init(pyTSK_VS_INFO *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_VS_INFO);
    // self->base = (TSK_VS_INFO *) PyMem_Malloc(sizeof(TSK_VS_INFO));
    return 0;
}

static PyObject *pyTSK_VS_INFO_getattr(pyTSK_VS_INFO *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_VS_INFO.pyTSK_VS_INFO_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("tag");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("vstype");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("offset");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("block_size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("endian");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("part_list");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("part_count");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_VS_INFO_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "tag") == 0) {
        PyObject *Py_result = NULL;
int UNUSED tag;


Py_BEGIN_ALLOW_THREADS
tag = (self->base->tag);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(tag);


        return Py_result;
    }
    if(strcmp(name, "vstype") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED vstype = 0;


Py_BEGIN_ALLOW_THREADS
vstype = (self->base->vstype);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_VS_TYPE_ENUM", "K", (uint64_t)vstype);


        return Py_result;
    }
    if(strcmp(name, "offset") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED offset;


Py_BEGIN_ALLOW_THREADS
offset = (self->base->offset);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(offset);
#else
    Py_result = PyLong_FromUnsignedLong(offset);
#endif


        return Py_result;
    }
    if(strcmp(name, "block_size") == 0) {
        PyObject *Py_result = NULL;
int UNUSED block_size;


Py_BEGIN_ALLOW_THREADS
block_size = (self->base->block_size);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(block_size);


        return Py_result;
    }
    if(strcmp(name, "endian") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED endian = 0;


Py_BEGIN_ALLOW_THREADS
endian = (self->base->endian);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_ENDIAN_ENUM", "K", (uint64_t)endian);


        return Py_result;
    }
    if(strcmp(name, "part_list") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_part_list = NULL;


        PyErr_Clear();

        wrapped_part_list = (Gen_wrapper) PyObject_New(pyTSK_VS_PART_INFO, &TSK_VS_PART_INFO_Type);

        // Base is borrowed from another object.
        wrapped_part_list->base = (self->base->part_list);
        wrapped_part_list->base_is_python_object = 0;
        wrapped_part_list->base_is_internal = 0;
        wrapped_part_list->python_object1 = NULL;
        wrapped_part_list->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_part_list->base == NULL) {
            Py_DecRef((PyObject *) wrapped_part_list);
            Py_IncRef(Py_None);
            wrapped_part_list = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_part_list;


        return Py_result;
    }
    if(strcmp(name, "part_count") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED part_count;


Py_BEGIN_ALLOW_THREADS
part_count = (self->base->part_count);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) part_count);


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_VS_INFO_nonzero(pyTSK_VS_INFO *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_VS_INFO_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_VS_INFO_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_VS_INFO_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_VS_INFO",
    /* tp_basicsize */
    sizeof(pyTSK_VS_INFO),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_VS_INFO_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_VS_INFO_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_VS_INFO_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_VS_INFO: \n    * Data structure used to store state and basic information\n    * for open volume systems.\n    ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_VS_INFO_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_VS_INFO_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef Extended_TSK_IMG_INFO_methods[] = {
    {NULL}  /* Sentinel */
};

static void Extended_TSK_IMG_INFO_dealloc(pyExtended_TSK_IMG_INFO *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyExtended_TSK_IMG_INFO_init(pyExtended_TSK_IMG_INFO *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, Extended_TSK_IMG_INFO);
    // self->base = (Extended_TSK_IMG_INFO *) PyMem_Malloc(sizeof(Extended_TSK_IMG_INFO));
    return 0;
}

static PyObject *pyExtended_TSK_IMG_INFO_getattr(pyExtended_TSK_IMG_INFO *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (Extended_TSK_IMG_INFO.pyExtended_TSK_IMG_INFO_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;


        for(i=Extended_TSK_IMG_INFO_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
Extended_TSK_IMG_INFO_nonzero(pyExtended_TSK_IMG_INFO *v)
{
        return v->base != 0;
};
static PyNumberMethods Extended_TSK_IMG_INFO_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       Extended_TSK_IMG_INFO_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject Extended_TSK_IMG_INFO_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.Extended_TSK_IMG_INFO",
    /* tp_basicsize */
    sizeof(pyExtended_TSK_IMG_INFO),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) Extended_TSK_IMG_INFO_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &Extended_TSK_IMG_INFO_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyExtended_TSK_IMG_INFO_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "Extended_TSK_IMG_INFO: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    Extended_TSK_IMG_INFO_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyExtended_TSK_IMG_INFO_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_META_MODE_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_META_MODE_ENUM_dealloc(pyTSK_FS_META_MODE_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_META_MODE_ENUM_init(pyTSK_FS_META_MODE_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_META_MODE_ENUM___str__(pyTSK_FS_META_MODE_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_META_MODE_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_META_MODE_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_META_MODE_ENUM *self = (pyTSK_FS_META_MODE_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_META_MODE_ENUM_int(pyTSK_FS_META_MODE_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_META_MODE_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_META_MODE_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_META_MODE_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_META_MODE_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_META_MODE_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_META_MODE_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_META_MODE_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_META_MODE_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_META_MODE_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_META_MODE_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_META_MODE_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_META_MODE_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_IMG_TYPE_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_IMG_TYPE_ENUM_dealloc(pyTSK_IMG_TYPE_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_IMG_TYPE_ENUM_init(pyTSK_IMG_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_IMG_TYPE_ENUM___str__(pyTSK_IMG_TYPE_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_IMG_TYPE_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_IMG_TYPE_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_IMG_TYPE_ENUM *self = (pyTSK_IMG_TYPE_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_IMG_TYPE_ENUM_int(pyTSK_IMG_TYPE_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_IMG_TYPE_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_IMG_TYPE_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_IMG_TYPE_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_IMG_TYPE_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_IMG_TYPE_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_IMG_TYPE_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_IMG_TYPE_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_IMG_TYPE_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_IMG_TYPE_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_IMG_TYPE_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_IMG_TYPE_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_IMG_TYPE_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_META_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_META_dealloc(pyTSK_FS_META *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_FS_META_init(pyTSK_FS_META *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_FS_META);
    // self->base = (TSK_FS_META *) PyMem_Malloc(sizeof(TSK_FS_META));
    return 0;
}

static PyObject *pyTSK_FS_META_getattr(pyTSK_FS_META *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_FS_META.pyTSK_FS_META_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("tag");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("flags");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("addr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("type");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("mode");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("nlink");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("uid");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("gid");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("mtime");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("mtime_nano");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("atime");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("atime_nano");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("ctime");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("ctime_nano");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("crtime");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("crtime_nano");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("content_ptr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("content_len");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("seq");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("attr_state");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("link");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_FS_META_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "tag") == 0) {
        PyObject *Py_result = NULL;
int UNUSED tag;


Py_BEGIN_ALLOW_THREADS
tag = (self->base->tag);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(tag);


        return Py_result;
    }
    if(strcmp(name, "flags") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED flags = 0;


Py_BEGIN_ALLOW_THREADS
flags = (self->base->flags);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_META_FLAG_ENUM", "K", (uint64_t)flags);


        return Py_result;
    }
    if(strcmp(name, "addr") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED addr;


Py_BEGIN_ALLOW_THREADS
addr = (self->base->addr);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(addr);
#else
    Py_result = PyLong_FromUnsignedLong(addr);
#endif


        return Py_result;
    }
    if(strcmp(name, "type") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED type = 0;


Py_BEGIN_ALLOW_THREADS
type = (self->base->type);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_META_TYPE_ENUM", "K", (uint64_t)type);


        return Py_result;
    }
    if(strcmp(name, "mode") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED mode = 0;


Py_BEGIN_ALLOW_THREADS
mode = (self->base->mode);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_META_MODE_ENUM", "K", (uint64_t)mode);


        return Py_result;
    }
    if(strcmp(name, "nlink") == 0) {
        PyObject *Py_result = NULL;
int UNUSED nlink;


Py_BEGIN_ALLOW_THREADS
nlink = (self->base->nlink);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(nlink);


        return Py_result;
    }
    if(strcmp(name, "size") == 0) {
        PyObject *Py_result = NULL;
int64_t  UNUSED size;


Py_BEGIN_ALLOW_THREADS
size = (self->base->size);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromLongLong(size);
#else
    Py_result = PyLong_FromLong(size);
#endif


        return Py_result;
    }
    if(strcmp(name, "uid") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED uid;


Py_BEGIN_ALLOW_THREADS
uid = (self->base->uid);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) uid);


        return Py_result;
    }
    if(strcmp(name, "gid") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED gid;


Py_BEGIN_ALLOW_THREADS
gid = (self->base->gid);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) gid);


        return Py_result;
    }
    if(strcmp(name, "mtime") == 0) {
        PyObject *Py_result = NULL;
int64_t  UNUSED mtime;


Py_BEGIN_ALLOW_THREADS
mtime = (self->base->mtime);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromLongLong(mtime);
#else
    Py_result = PyLong_FromLong(mtime);
#endif


        return Py_result;
    }
    if(strcmp(name, "mtime_nano") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED mtime_nano;


Py_BEGIN_ALLOW_THREADS
mtime_nano = (self->base->mtime_nano);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) mtime_nano);


        return Py_result;
    }
    if(strcmp(name, "atime") == 0) {
        PyObject *Py_result = NULL;
int64_t  UNUSED atime;


Py_BEGIN_ALLOW_THREADS
atime = (self->base->atime);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromLongLong(atime);
#else
    Py_result = PyLong_FromLong(atime);
#endif


        return Py_result;
    }
    if(strcmp(name, "atime_nano") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED atime_nano;


Py_BEGIN_ALLOW_THREADS
atime_nano = (self->base->atime_nano);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) atime_nano);


        return Py_result;
    }
    if(strcmp(name, "ctime") == 0) {
        PyObject *Py_result = NULL;
int64_t  UNUSED ctime;


Py_BEGIN_ALLOW_THREADS
ctime = (self->base->ctime);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromLongLong(ctime);
#else
    Py_result = PyLong_FromLong(ctime);
#endif


        return Py_result;
    }
    if(strcmp(name, "ctime_nano") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED ctime_nano;


Py_BEGIN_ALLOW_THREADS
ctime_nano = (self->base->ctime_nano);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) ctime_nano);


        return Py_result;
    }
    if(strcmp(name, "crtime") == 0) {
        PyObject *Py_result = NULL;
int64_t  UNUSED crtime;


Py_BEGIN_ALLOW_THREADS
crtime = (self->base->crtime);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromLongLong(crtime);
#else
    Py_result = PyLong_FromLong(crtime);
#endif


        return Py_result;
    }
    if(strcmp(name, "crtime_nano") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED crtime_nano;


Py_BEGIN_ALLOW_THREADS
crtime_nano = (self->base->crtime_nano);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) crtime_nano);


        return Py_result;
    }
    if(strcmp(name, "content_ptr") == 0) {
        PyObject *Py_result = NULL;


    Py_BEGIN_ALLOW_THREADS
    (void) (self->base->content_ptr);
    Py_END_ALLOW_THREADS

Py_IncRef(Py_None);
Py_result = Py_None;


        return Py_result;
    }
    if(strcmp(name, "content_len") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED content_len;


Py_BEGIN_ALLOW_THREADS
content_len = (self->base->content_len);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(content_len);
#else
    Py_result = PyLong_FromUnsignedLong(content_len);
#endif


        return Py_result;
    }
    if(strcmp(name, "seq") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED seq;


Py_BEGIN_ALLOW_THREADS
seq = (self->base->seq);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) seq);


        return Py_result;
    }
    if(strcmp(name, "attr_state") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED attr_state = 0;


Py_BEGIN_ALLOW_THREADS
attr_state = (self->base->attr_state);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_META_ATTR_FLAG_ENUM", "K", (uint64_t)attr_state);


        return Py_result;
    }
    if(strcmp(name, "link") == 0) {
        PyObject *Py_result = NULL;
char * UNUSED link;


Py_BEGIN_ALLOW_THREADS
link = (self->base->link);
Py_END_ALLOW_THREADS

    PyErr_Clear();

    if(!link) {
        Py_IncRef(Py_None);
        Py_result = Py_None;
    } else {
        Py_result = PyString_FromStringAndSize((char *)link, strlen(link));
        if(!Py_result) goto on_error;
    };


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_FS_META_nonzero(pyTSK_FS_META *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_FS_META_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_FS_META_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_META_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_META",
    /* tp_basicsize */
    sizeof(pyTSK_FS_META),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_META_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_META_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_FS_META_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_META:  \n    * TSK data structure to store general file and directory metadata. \n    * Note that the file in the file\n    * system may have more metadata than is stored here.  \n    * For performance reasons, the run list of the file content is not always known\n    * when the file is loaded.  It may be loaded only when needed by the internal code. \n    * The TSK_FS_META::content_ptr pointer contains file system-specific data that will be\n    * used to determine the full run. After it has been loaded, the TSK_FS_META::attr field\n    * will contain that info.  \n    ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_META_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_META_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef Img_Info_methods[] = {
    { "read",
      (PyCFunction) pyImg_Info_read,
      METH_VARARGS|METH_KEYWORDS,
      "uint64_t Img_Info.read(TSK_OFF_T off ,OUT char * buf, size_t len);\n\n\nRead a random buffer from the image"},

    { "get_size",
      (PyCFunction) pyImg_Info_get_size,
      METH_VARARGS|METH_KEYWORDS,
      "uint64_t Img_Info.get_size();\n\n\nRetrieve the size of the image"},

    { "close",
      (PyCFunction) pyImg_Info_close,
      METH_VARARGS|METH_KEYWORDS,
      "void Img_Info.close();\n\n\nCloses the image"},

    {NULL}  /* Sentinel */
};

static void Img_Info_dealloc(pyImg_Info *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            if(self->base_is_python_object != 0) {
                Py_DecRef((PyObject*) self->base);
            } else if(self->base_is_internal != 0) {
                talloc_free(self->base);
            }
            self->base = NULL;
        }
        if(self->python_object2 != NULL) {
            Py_DecRef(self->python_object2);
            self->python_object2 = NULL;
        }
        if(self->python_object1 != NULL) {
            Py_DecRef(self->python_object1);
            self->python_object1 = NULL;
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static void pyImg_Info_initialize_proxies(pyImg_Info *self, void *item) {
    Img_Info target = (Img_Info) item;

    // Maintain a reference to the python object in the C object extension
    ((Object) item)->extension = self;

    if(check_method_override((PyObject *) self, &Img_Info_Type, "read")) {
        // Proxy the read method
        ((Img_Info) target)->read = ProxiedImg_Info_read;
    }
    if(check_method_override((PyObject *) self, &Img_Info_Type, "get_size")) {
        // Proxy the get_size method
        ((Img_Info) target)->get_size = ProxiedImg_Info_get_size;
    }
}

static int pyImg_Info_init(pyImg_Info *self, PyObject *args, PyObject *kwds)
{
    Img_Info result_constructor = NULL;
    // DEBUG: local arg type: ZString
ZString url= "";
    // DEBUG: local arg type: EnumType
    int type =  TSK_IMG_TYPE_DETECT;

    static char *kwlist[] = {"url","type", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "|si", kwlist,&url,&type)) {
        goto on_error;
    }
    self->python_object1 = NULL;
    self->python_object2 = NULL;
    // Initialise is used to keep a reference on the object?
    // If not called no longer valid warnings have been seen on Windows.
    self->initialise = (void *) pyImg_Info_initialize_proxies;


// Check if the integer passed is actually a valid member of the enum
// Enum value of 0 is always allowed
if(type) { PyObject *py_type = PyLong_FromLong(type);
  PyObject *tmp = PyDict_GetItem(TSK_IMG_TYPE_ENUM_rev_lookup, py_type);

  Py_DecRef(py_type);
  if(!tmp) {
    PyErr_Format(PyExc_RuntimeError, "value %lu is not valid for Enum TSK_IMG_TYPE_ENUM of arg 'type'", (unsigned long)type);
    goto on_error;
  };
};
    ClearError();

    // Allocate a new instance
    self->base = (Img_Info) alloc_Img_Info();
    self->base_is_python_object = 0;
    self->base_is_internal = 1;
    self->object_is_proxied = 0;

    // Update the target by replacing its methods with proxies to call back into Python
    pyImg_Info_initialize_proxies(self, self->base);

    // Now call the constructor
    Py_BEGIN_ALLOW_THREADS
    result_constructor = CONSTRUCT_INITIALIZE(Img_Info, Img_Info, Con, self->base, url, type);
    Py_END_ALLOW_THREADS

    if(!CheckError(EZero)) {
        char *buffer = NULL;
        PyObject *exception = resolve_exception(&buffer);

        PyErr_Format(exception, "%s", buffer);
        ClearError();
        goto on_error;
    }
    if(result_constructor == NULL) {
        PyErr_Format(PyExc_IOError, "Unable to construct class Img_Info");
        goto on_error;
    }

    return 0;

on_error:
    if(self->python_object2 != NULL) {
        Py_DecRef(self->python_object2);
        self->python_object2 = NULL;
    }
    if(self->python_object1 != NULL) {
        Py_DecRef(self->python_object1);
        self->python_object1 = NULL;
    }
    if(self->base != NULL) {
        talloc_free(self->base);
        self->base = NULL;
    }
    return -1;
}

static PyObject *pyImg_Info_getattr(pyImg_Info *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (Img_Info.pyImg_Info_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;


        for(i=Img_Info_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
uint64_t Img_Info.read(TSK_OFF_T off ,OUT char * buf, size_t len);
********************************************************/
static PyObject *pyImg_Info_read(pyImg_Info *self, PyObject *args, PyObject *kwds){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Integer64Unsigned
    uint64_t  UNUSED func_return;
    // DEBUG: local arg type: Integer64
int64_t  UNUSED off;
    // DEBUG: local arg type: Char_and_Length_OUT
    char *buf = NULL;
    Py_ssize_t len = 0;
    PyObject *tmp_buf = NULL;

    static char *kwlist[] = {"off","len", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "Ll", kwlist,&off,&len)) {
        goto on_error;
    }

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "Img_Info object no longer valid");
    }

    // Precall preparations
    PyErr_Clear();

    tmp_buf = PyString_FromStringAndSize(NULL, len);
    if(!tmp_buf) goto on_error;

    PyString_AsStringAndSize(tmp_buf, &buf, (Py_ssize_t *)&len);
    // Check the function is implemented
    {
        void *method = ((Img_Info)self->base)->read;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "Img_Info.read is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
Py_BEGIN_ALLOW_THREADS
func_return =         ((Img_Info) self->base)->read(((Img_Info) self->base), off, (OUT char *)buf, (size_t)len);
Py_END_ALLOW_THREADS
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results

    // NOTE - this should never happen - it might indicate an overflow condition.
    if(func_return > len) {
        printf("Programming Error - possible overflow!!\n");
        abort();

    // Do we need to truncate the buffer for a short read?
    } else if(func_return < len) {
        _PyString_Resize(&tmp_buf, (Py_ssize_t)func_return);
    }

    Py_result = tmp_buf;
    returned_result = Py_result;
    return returned_result;

on_error:
    if(tmp_buf != NULL) {
        Py_DecRef(tmp_buf);
    }
    return NULL;
};

static uint64_t ProxiedImg_Info_read(Img_Info self, TSK_OFF_T off, OUT char * buf, size_t len) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
uint64_t  UNUSED func_return;
PyObject *py_off = NULL;
PyObject *py_buf = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("read");

// Obtain python objects for all the args:
PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    py_off = PyLong_FromLongLong(off);
#else
    py_off = PyLong_FromLong(off);
#endif
py_buf = PyLong_FromLong(len);
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in Img_Info");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, py_off,py_buf,NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }


{
    char *tmp_buff; Py_ssize_t tmp_len;
    if(-1==PyString_AsStringAndSize(Py_result, &tmp_buff, &tmp_len)) goto on_error;

    memcpy(buf,tmp_buff, tmp_len);
    Py_DecRef(Py_result);
    Py_result = PyLong_FromLong(tmp_len);
}
PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    func_return = PyInt_AsUnsignedLongLongMask(Py_result);
#else
    func_return = PyInt_AsUnsignedLongMask(Py_result);
#endif
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_off != NULL) {
        Py_DecRef(py_off);
    }
    if(py_buf != NULL) {
        Py_DecRef(py_buf);
    }
    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_off != NULL) {
        Py_DecRef(py_off);
    }
    if(py_buf != NULL) {
        Py_DecRef(py_buf);
    }
    PyGILState_Release(gstate);

    return 0;
}


/********************************************************
Autogenerated wrapper for function:
uint64_t Img_Info.get_size();
********************************************************/
static PyObject *pyImg_Info_get_size(pyImg_Info *self, PyObject *args, PyObject *kwds){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Integer64Unsigned
    uint64_t  UNUSED func_return;

    static char *kwlist[] = { NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "", kwlist)) {
        goto on_error;
    }

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "Img_Info object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((Img_Info)self->base)->get_size;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "Img_Info.get_size is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
Py_BEGIN_ALLOW_THREADS
func_return =         ((Img_Info) self->base)->get_size(((Img_Info) self->base));
Py_END_ALLOW_THREADS
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(func_return);
#else
    Py_result = PyLong_FromUnsignedLong(func_return);
#endif
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static uint64_t ProxiedImg_Info_get_size(Img_Info self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
uint64_t  UNUSED func_return;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("get_size");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in Img_Info");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    func_return = PyInt_AsUnsignedLongLongMask(Py_result);
#else
    func_return = PyInt_AsUnsignedLongMask(Py_result);
#endif
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return 0;
}


/********************************************************
Autogenerated wrapper for function:
void Img_Info.close();
********************************************************/
static PyObject *pyImg_Info_close(pyImg_Info *self, PyObject *args, PyObject *kwds){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Void
    
    static char *kwlist[] = { NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "", kwlist)) {
        goto on_error;
    }

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "Img_Info object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((Img_Info)self->base)->close;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "Img_Info.close is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
    Py_BEGIN_ALLOW_THREADS
    (void)         ((Img_Info) self->base)->close(((Img_Info) self->base));
    Py_END_ALLOW_THREADS
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_IncRef(Py_None);
Py_result = Py_None;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};


static int
Img_Info_nonzero(pyImg_Info *v)
{
        return v->base != 0;
};
static PyNumberMethods Img_Info_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       Img_Info_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject Img_Info_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.Img_Info",
    /* tp_basicsize */
    sizeof(pyImg_Info),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) Img_Info_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &Img_Info_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyImg_Info_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "Img_Info:  This is a normal IMG_INFO which takes a filename and passes it\n    to TSK. It just uses the standard TSK image handling code to\n    support EWF, AFF etc.\n\n    This is usually the first object you would instantiate in order to\n    use the TSK library:\n\n    img = Img_Info(filename)\n\n    you would then pass it to an FS_Info object:\n\n    fs = FS_Info(img)\n\n    Then open an inode or path\n\n    f = fs.open_dir(inode = 2)\n",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    Img_Info_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyImg_Info_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_DIR_WALK_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_DIR_WALK_FLAG_ENUM_dealloc(pyTSK_FS_DIR_WALK_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_DIR_WALK_FLAG_ENUM_init(pyTSK_FS_DIR_WALK_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_DIR_WALK_FLAG_ENUM___str__(pyTSK_FS_DIR_WALK_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_DIR_WALK_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_DIR_WALK_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_DIR_WALK_FLAG_ENUM *self = (pyTSK_FS_DIR_WALK_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_DIR_WALK_FLAG_ENUM_int(pyTSK_FS_DIR_WALK_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_DIR_WALK_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_DIR_WALK_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_DIR_WALK_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_DIR_WALK_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_DIR_WALK_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_DIR_WALK_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_DIR_WALK_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_DIR_WALK_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_DIR_WALK_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_DIR_WALK_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_DIR_WALK_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_DIR_WALK_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_ENDIAN_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_ENDIAN_ENUM_dealloc(pyTSK_ENDIAN_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_ENDIAN_ENUM_init(pyTSK_ENDIAN_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_ENDIAN_ENUM___str__(pyTSK_ENDIAN_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_ENDIAN_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_ENDIAN_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_ENDIAN_ENUM *self = (pyTSK_ENDIAN_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_ENDIAN_ENUM_int(pyTSK_ENDIAN_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_ENDIAN_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_ENDIAN_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_ENDIAN_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_ENDIAN_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_ENDIAN_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_ENDIAN_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_ENDIAN_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_ENDIAN_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_ENDIAN_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_ENDIAN_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_ENDIAN_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_ENDIAN_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_DIR_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_DIR_dealloc(pyTSK_FS_DIR *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_FS_DIR_init(pyTSK_FS_DIR *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_FS_DIR);
    // self->base = (TSK_FS_DIR *) PyMem_Malloc(sizeof(TSK_FS_DIR));
    return 0;
}

static PyObject *pyTSK_FS_DIR_getattr(pyTSK_FS_DIR *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_FS_DIR.pyTSK_FS_DIR_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("tag");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("fs_file");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("names");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("names_used");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("names_alloc");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("addr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("seq");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("fs_info");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_FS_DIR_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "tag") == 0) {
        PyObject *Py_result = NULL;
int UNUSED tag;


Py_BEGIN_ALLOW_THREADS
tag = (self->base->tag);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(tag);


        return Py_result;
    }
    if(strcmp(name, "fs_file") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_fs_file = NULL;


        PyErr_Clear();

        wrapped_fs_file = (Gen_wrapper) PyObject_New(pyTSK_FS_FILE, &TSK_FS_FILE_Type);

        // Base is borrowed from another object.
        wrapped_fs_file->base = (self->base->fs_file);
        wrapped_fs_file->base_is_python_object = 0;
        wrapped_fs_file->base_is_internal = 0;
        wrapped_fs_file->python_object1 = NULL;
        wrapped_fs_file->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_fs_file->base == NULL) {
            Py_DecRef((PyObject *) wrapped_fs_file);
            Py_IncRef(Py_None);
            wrapped_fs_file = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_fs_file;


        return Py_result;
    }
    if(strcmp(name, "names") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_names = NULL;


        PyErr_Clear();

        wrapped_names = (Gen_wrapper) PyObject_New(pyTSK_FS_NAME, &TSK_FS_NAME_Type);

        // Base is borrowed from another object.
        wrapped_names->base = (self->base->names);
        wrapped_names->base_is_python_object = 0;
        wrapped_names->base_is_internal = 0;
        wrapped_names->python_object1 = NULL;
        wrapped_names->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_names->base == NULL) {
            Py_DecRef((PyObject *) wrapped_names);
            Py_IncRef(Py_None);
            wrapped_names = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_names;


        return Py_result;
    }
    if(strcmp(name, "names_used") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED names_used;


Py_BEGIN_ALLOW_THREADS
names_used = (self->base->names_used);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(names_used);
#else
    Py_result = PyLong_FromUnsignedLong(names_used);
#endif


        return Py_result;
    }
    if(strcmp(name, "names_alloc") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED names_alloc;


Py_BEGIN_ALLOW_THREADS
names_alloc = (self->base->names_alloc);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(names_alloc);
#else
    Py_result = PyLong_FromUnsignedLong(names_alloc);
#endif


        return Py_result;
    }
    if(strcmp(name, "addr") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED addr;


Py_BEGIN_ALLOW_THREADS
addr = (self->base->addr);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(addr);
#else
    Py_result = PyLong_FromUnsignedLong(addr);
#endif


        return Py_result;
    }
    if(strcmp(name, "seq") == 0) {
        PyObject *Py_result = NULL;
uint32_t  UNUSED seq;


Py_BEGIN_ALLOW_THREADS
seq = (self->base->seq);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) seq);


        return Py_result;
    }
    if(strcmp(name, "fs_info") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_fs_info = NULL;


        PyErr_Clear();

        wrapped_fs_info = (Gen_wrapper) PyObject_New(pyTSK_FS_INFO, &TSK_FS_INFO_Type);

        // Base is borrowed from another object.
        wrapped_fs_info->base = (self->base->fs_info);
        wrapped_fs_info->base_is_python_object = 0;
        wrapped_fs_info->base_is_internal = 0;
        wrapped_fs_info->python_object1 = NULL;
        wrapped_fs_info->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_fs_info->base == NULL) {
            Py_DecRef((PyObject *) wrapped_fs_info);
            Py_IncRef(Py_None);
            wrapped_fs_info = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_fs_info;


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_FS_DIR_nonzero(pyTSK_FS_DIR *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_FS_DIR_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_FS_DIR_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_DIR_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_DIR",
    /* tp_basicsize */
    sizeof(pyTSK_FS_DIR),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_DIR_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_DIR_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_FS_DIR_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_DIR: \n    * A handle to a directory so that its files can be individually accessed.\n    ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_DIR_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_DIR_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef FS_Info_methods[] = {
    { "open_dir",
      (PyCFunction) pyFS_Info_open_dir,
      METH_VARARGS|METH_KEYWORDS,
      "Directory FS_Info.open_dir(ZString path ,TSK_INUM_T inode );\n\n\nA convenience function to open a directory in this image.\n\n         DEFAULT(path) = NULL;\n         DEFAULT(inode) = 2;"},

    { "open",
      (PyCFunction) pyFS_Info_open,
      METH_VARARGS|METH_KEYWORDS,
      "File FS_Info.open(ZString path );\n\n\nA convenience function to open a file in this image."},

    { "open_meta",
      (PyCFunction) pyFS_Info_open_meta,
      METH_VARARGS|METH_KEYWORDS,
      "File FS_Info.open_meta(TSK_INUM_T inode );\n\n\nOpen a file by inode number"},

    { "exit",
      (PyCFunction) pyFS_Info_exit,
      METH_VARARGS|METH_KEYWORDS,
      "void FS_Info.exit();\n\n\n"},

    {NULL}  /* Sentinel */
};

static void FS_Info_dealloc(pyFS_Info *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            if(self->base_is_python_object != 0) {
                Py_DecRef((PyObject*) self->base);
            } else if(self->base_is_internal != 0) {
                talloc_free(self->base);
            }
            self->base = NULL;
        }
        if(self->python_object2 != NULL) {
            Py_DecRef(self->python_object2);
            self->python_object2 = NULL;
        }
        if(self->python_object1 != NULL) {
            Py_DecRef(self->python_object1);
            self->python_object1 = NULL;
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static void pyFS_Info_initialize_proxies(pyFS_Info *self, void *item) {
    FS_Info target = (FS_Info) item;

    // Maintain a reference to the python object in the C object extension
    ((Object) item)->extension = self;

    if(check_method_override((PyObject *) self, &FS_Info_Type, "open_dir")) {
        // Proxy the open_dir method
        ((FS_Info) target)->open_dir = ProxiedFS_Info_open_dir;
    }
    if(check_method_override((PyObject *) self, &FS_Info_Type, "open")) {
        // Proxy the open method
        ((FS_Info) target)->open = ProxiedFS_Info_open;
    }
    if(check_method_override((PyObject *) self, &FS_Info_Type, "open_meta")) {
        // Proxy the open_meta method
        ((FS_Info) target)->open_meta = ProxiedFS_Info_open_meta;
    }
    if(check_method_override((PyObject *) self, &FS_Info_Type, "exit")) {
        // Proxy the exit method
        ((FS_Info) target)->exit = ProxiedFS_Info_exit;
    }
}

static int pyFS_Info_init(pyFS_Info *self, PyObject *args, PyObject *kwds)
{
    FS_Info result_constructor = NULL;
    // DEBUG: local arg type: Wrapper
    Gen_wrapper wrapped_img UNUSED = NULL;
    Img_Info UNUSED img;
    // DEBUG: local arg type: Integer64
int64_t  offset= 0;
    // DEBUG: local arg type: EnumType
    int type =  TSK_FS_TYPE_DETECT;

    static char *kwlist[] = {"img","offset","type", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "O|Li", kwlist,&wrapped_img,&offset,&type)) {
        goto on_error;
    }
    self->python_object1 = NULL;
    self->python_object2 = NULL;
    // Initialise is used to keep a reference on the object?
    // If not called no longer valid warnings have been seen on Windows.
    self->initialise = (void *) pyFS_Info_initialize_proxies;

    if(wrapped_img == NULL || (PyObject *)wrapped_img == Py_None) {
        img = NULL;
    } else if(!type_check((PyObject *)wrapped_img,&Img_Info_Type)) {
        PyErr_Format(PyExc_RuntimeError, "img must be derived from type Img_Info");
        goto on_error;
    } else if(wrapped_img->base == NULL) {
        PyErr_Format(PyExc_RuntimeError, "Img_Info instance is no longer valid (was it gc'ed?)");
        goto on_error;
    } else {
        img = wrapped_img->base;
        if(self->python_object1 == NULL) {
            self->python_object1 = (PyObject *) wrapped_img;
            Py_IncRef(self->python_object1);
        }
    }

// Check if the integer passed is actually a valid member of the enum
// Enum value of 0 is always allowed
if(type) { PyObject *py_type = PyLong_FromLong(type);
  PyObject *tmp = PyDict_GetItem(TSK_FS_TYPE_ENUM_rev_lookup, py_type);

  Py_DecRef(py_type);
  if(!tmp) {
    PyErr_Format(PyExc_RuntimeError, "value %lu is not valid for Enum TSK_FS_TYPE_ENUM of arg 'type'", (unsigned long)type);
    goto on_error;
  };
};
    ClearError();

    // Allocate a new instance
    self->base = (FS_Info) alloc_FS_Info();
    self->base_is_python_object = 0;
    self->base_is_internal = 1;
    self->object_is_proxied = 0;

    // Update the target by replacing its methods with proxies to call back into Python
    pyFS_Info_initialize_proxies(self, self->base);

    // Now call the constructor
    Py_BEGIN_ALLOW_THREADS
    result_constructor = CONSTRUCT_INITIALIZE(FS_Info, FS_Info, Con, self->base, img, offset, type);
    Py_END_ALLOW_THREADS

    if(!CheckError(EZero)) {
        char *buffer = NULL;
        PyObject *exception = resolve_exception(&buffer);

        PyErr_Format(exception, "%s", buffer);
        ClearError();
        goto on_error;
    }
    if(result_constructor == NULL) {
        PyErr_Format(PyExc_IOError, "Unable to construct class FS_Info");
        goto on_error;
    }

    return 0;

on_error:
    if(self->python_object2 != NULL) {
        Py_DecRef(self->python_object2);
        self->python_object2 = NULL;
    }
    if(self->python_object1 != NULL) {
        Py_DecRef(self->python_object1);
        self->python_object1 = NULL;
    }
    if(self->base != NULL) {
        talloc_free(self->base);
        self->base = NULL;
    }
    return -1;
}

static PyObject *pyFS_Info_getattr(pyFS_Info *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (FS_Info.pyFS_Info_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("info");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=FS_Info_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "info") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_info = NULL;


        PyErr_Clear();

        wrapped_info = (Gen_wrapper) PyObject_New(pyTSK_FS_INFO, &TSK_FS_INFO_Type);

        // Base is borrowed from another object.
        wrapped_info->base = (((FS_Info) self->base)->info);
        wrapped_info->base_is_python_object = 0;
        wrapped_info->base_is_internal = 0;
        wrapped_info->python_object1 = NULL;
        wrapped_info->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_info->base == NULL) {
            Py_DecRef((PyObject *) wrapped_info);
            Py_IncRef(Py_None);
            wrapped_info = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_info;


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
Directory FS_Info.open_dir(ZString path ,TSK_INUM_T inode );
********************************************************/
static PyObject *pyFS_Info_open_dir(pyFS_Info *self, PyObject *args, PyObject *kwds){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Wrapper
        Gen_wrapper wrapped_func_return UNUSED = NULL;
    // DEBUG: local arg type: ZString
ZString path= NULL;
    // DEBUG: local arg type: Integer64Unsigned
uint64_t  inode= 2;

    static char *kwlist[] = {"path","inode", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "|sK", kwlist,&path,&inode)) {
        goto on_error;
    }

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "FS_Info object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((FS_Info)self->base)->open_dir;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "FS_Info.open_dir is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
    {
        Object returned_object = NULL;

        ClearError();

        Py_BEGIN_ALLOW_THREADS
        // This call will return a Python object if the base is a proxied Python object
        // or a talloc managed object otherwise.
        returned_object = (Object) ((FS_Info) self->base)->open_dir(((FS_Info) self->base), path, inode);
        Py_END_ALLOW_THREADS

        if(check_error()) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
        wrapped_func_return = new_class_wrapper(returned_object, self->base_is_python_object);

        if(wrapped_func_return == NULL) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
    }
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_result = (PyObject *)wrapped_func_return;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static Directory ProxiedFS_Info_open_dir(FS_Info self, ZString path, TSK_INUM_T inode) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
Directory func_return = NULL;
PyObject *py_path = NULL;
PyObject *py_inode = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("open_dir");

// Obtain python objects for all the args:
    PyErr_Clear();

    if(!path) {
        Py_IncRef(Py_None);
        py_path = Py_None;
    } else {
        py_path = PyString_FromStringAndSize((char *)path, strlen(path));
        if(!py_path) goto on_error;
    };
PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    py_inode = PyLong_FromUnsignedLongLong(inode);
#else
    py_inode = PyLong_FromUnsignedLong(inode);
#endif
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in FS_Info");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, py_path,py_inode,NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

     /* First check that the returned value is in fact a Wrapper */
     if(!type_check(Py_result, &Directory_Type)) {
          PyErr_Format(PyExc_RuntimeError, "function must return an Directory instance");
          goto on_error;
     }

     func_return = ((Gen_wrapper) Py_result)->base;

     if(!func_return) {
          PyErr_Format(PyExc_RuntimeError, "Directory instance is no longer valid (was it gc'ed?)");
          goto on_error;
}

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_path != NULL) {
        Py_DecRef(py_path);
    }
    if(py_inode != NULL) {
        Py_DecRef(py_inode);
    }
    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_path != NULL) {
        Py_DecRef(py_path);
    }
    if(py_inode != NULL) {
        Py_DecRef(py_inode);
    }
    PyGILState_Release(gstate);

    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
File FS_Info.open(ZString path );
********************************************************/
static PyObject *pyFS_Info_open(pyFS_Info *self, PyObject *args, PyObject *kwds){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Wrapper
        Gen_wrapper wrapped_func_return UNUSED = NULL;
    // DEBUG: local arg type: ZString
ZString UNUSED path;

    static char *kwlist[] = {"path", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "s", kwlist,&path)) {
        goto on_error;
    }

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "FS_Info object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((FS_Info)self->base)->open;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "FS_Info.open is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
    {
        Object returned_object = NULL;

        ClearError();

        Py_BEGIN_ALLOW_THREADS
        // This call will return a Python object if the base is a proxied Python object
        // or a talloc managed object otherwise.
        returned_object = (Object) ((FS_Info) self->base)->open(((FS_Info) self->base), path);
        Py_END_ALLOW_THREADS

        if(check_error()) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
        wrapped_func_return = new_class_wrapper(returned_object, self->base_is_python_object);

        if(wrapped_func_return == NULL) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
    }
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_result = (PyObject *)wrapped_func_return;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static File ProxiedFS_Info_open(FS_Info self, ZString path) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
File func_return = NULL;
PyObject *py_path = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("open");

// Obtain python objects for all the args:
    PyErr_Clear();

    if(!path) {
        Py_IncRef(Py_None);
        py_path = Py_None;
    } else {
        py_path = PyString_FromStringAndSize((char *)path, strlen(path));
        if(!py_path) goto on_error;
    };
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in FS_Info");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, py_path,NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

     /* First check that the returned value is in fact a Wrapper */
     if(!type_check(Py_result, &File_Type)) {
          PyErr_Format(PyExc_RuntimeError, "function must return an File instance");
          goto on_error;
     }

     func_return = ((Gen_wrapper) Py_result)->base;

     if(!func_return) {
          PyErr_Format(PyExc_RuntimeError, "File instance is no longer valid (was it gc'ed?)");
          goto on_error;
}

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_path != NULL) {
        Py_DecRef(py_path);
    }
    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_path != NULL) {
        Py_DecRef(py_path);
    }
    PyGILState_Release(gstate);

    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
File FS_Info.open_meta(TSK_INUM_T inode );
********************************************************/
static PyObject *pyFS_Info_open_meta(pyFS_Info *self, PyObject *args, PyObject *kwds){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Wrapper
        Gen_wrapper wrapped_func_return UNUSED = NULL;
    // DEBUG: local arg type: Integer64Unsigned
uint64_t  UNUSED inode;

    static char *kwlist[] = {"inode", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "K", kwlist,&inode)) {
        goto on_error;
    }

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "FS_Info object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((FS_Info)self->base)->open_meta;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "FS_Info.open_meta is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
    {
        Object returned_object = NULL;

        ClearError();

        Py_BEGIN_ALLOW_THREADS
        // This call will return a Python object if the base is a proxied Python object
        // or a talloc managed object otherwise.
        returned_object = (Object) ((FS_Info) self->base)->open_meta(((FS_Info) self->base), inode);
        Py_END_ALLOW_THREADS

        if(check_error()) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
        wrapped_func_return = new_class_wrapper(returned_object, self->base_is_python_object);

        if(wrapped_func_return == NULL) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
    }
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_result = (PyObject *)wrapped_func_return;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static File ProxiedFS_Info_open_meta(FS_Info self, TSK_INUM_T inode) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
File func_return = NULL;
PyObject *py_inode = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("open_meta");

// Obtain python objects for all the args:
PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    py_inode = PyLong_FromUnsignedLongLong(inode);
#else
    py_inode = PyLong_FromUnsignedLong(inode);
#endif
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in FS_Info");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, py_inode,NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

     /* First check that the returned value is in fact a Wrapper */
     if(!type_check(Py_result, &File_Type)) {
          PyErr_Format(PyExc_RuntimeError, "function must return an File instance");
          goto on_error;
     }

     func_return = ((Gen_wrapper) Py_result)->base;

     if(!func_return) {
          PyErr_Format(PyExc_RuntimeError, "File instance is no longer valid (was it gc'ed?)");
          goto on_error;
}

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_inode != NULL) {
        Py_DecRef(py_inode);
    }
    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_inode != NULL) {
        Py_DecRef(py_inode);
    }
    PyGILState_Release(gstate);

    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
void FS_Info.exit();
********************************************************/
static PyObject *pyFS_Info_exit(pyFS_Info *self, PyObject *args, PyObject *kwds){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Void
    
    static char *kwlist[] = { NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "", kwlist)) {
        goto on_error;
    }

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "FS_Info object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((FS_Info)self->base)->exit;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "FS_Info.exit is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
    Py_BEGIN_ALLOW_THREADS
    (void)         ((FS_Info) self->base)->exit(((FS_Info) self->base));
    Py_END_ALLOW_THREADS
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_IncRef(Py_None);
Py_result = Py_None;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static void ProxiedFS_Info_exit(FS_Info self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("exit");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in FS_Info");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;
}


static int
FS_Info_nonzero(pyFS_Info *v)
{
        return v->base != 0;
};
static PyNumberMethods FS_Info_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       FS_Info_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject FS_Info_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.FS_Info",
    /* tp_basicsize */
    sizeof(pyFS_Info),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) FS_Info_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &FS_Info_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyFS_Info_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "FS_Info:  This is used to obtain a filesystem object from an Img_Info object.\n\n    From this FS_Info we can open files or directories by inode, or\n    path.\n ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    FS_Info_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyFS_Info_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_BLKCALC_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_BLKCALC_FLAG_ENUM_dealloc(pyTSK_FS_BLKCALC_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_BLKCALC_FLAG_ENUM_init(pyTSK_FS_BLKCALC_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_BLKCALC_FLAG_ENUM___str__(pyTSK_FS_BLKCALC_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_BLKCALC_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_BLKCALC_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_BLKCALC_FLAG_ENUM *self = (pyTSK_FS_BLKCALC_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_BLKCALC_FLAG_ENUM_int(pyTSK_FS_BLKCALC_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_BLKCALC_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_BLKCALC_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_BLKCALC_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_BLKCALC_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_BLKCALC_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_BLKCALC_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_BLKCALC_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_BLKCALC_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_BLKCALC_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_BLKCALC_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_BLKCALC_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_BLKCALC_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_NAME_TYPE_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_NAME_TYPE_ENUM_dealloc(pyTSK_FS_NAME_TYPE_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_NAME_TYPE_ENUM_init(pyTSK_FS_NAME_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_NAME_TYPE_ENUM___str__(pyTSK_FS_NAME_TYPE_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_NAME_TYPE_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_NAME_TYPE_ENUM *self = (pyTSK_FS_NAME_TYPE_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_NAME_TYPE_ENUM_int(pyTSK_FS_NAME_TYPE_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_NAME_TYPE_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_NAME_TYPE_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_NAME_TYPE_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_NAME_TYPE_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_NAME_TYPE_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_NAME_TYPE_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_NAME_TYPE_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_NAME_TYPE_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_NAME_TYPE_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_NAME_TYPE_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_NAME_TYPE_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_NAME_TYPE_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_VS_TYPE_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_VS_TYPE_ENUM_dealloc(pyTSK_VS_TYPE_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_VS_TYPE_ENUM_init(pyTSK_VS_TYPE_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_VS_TYPE_ENUM___str__(pyTSK_VS_TYPE_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_VS_TYPE_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_VS_TYPE_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_VS_TYPE_ENUM *self = (pyTSK_VS_TYPE_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_VS_TYPE_ENUM_int(pyTSK_VS_TYPE_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_VS_TYPE_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_VS_TYPE_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_VS_TYPE_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_VS_TYPE_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_VS_TYPE_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_VS_TYPE_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_VS_TYPE_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_VS_TYPE_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_VS_TYPE_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_VS_TYPE_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_VS_TYPE_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_VS_TYPE_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef Directory_methods[] = {
    {NULL}  /* Sentinel */
};

static void Directory_dealloc(pyDirectory *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            if(self->base_is_python_object != 0) {
                Py_DecRef((PyObject*) self->base);
            } else if(self->base_is_internal != 0) {
                talloc_free(self->base);
            }
            self->base = NULL;
        }
        if(self->python_object2 != NULL) {
            Py_DecRef(self->python_object2);
            self->python_object2 = NULL;
        }
        if(self->python_object1 != NULL) {
            Py_DecRef(self->python_object1);
            self->python_object1 = NULL;
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static void pyDirectory_initialize_proxies(pyDirectory *self, void *item) {
    Directory target = (Directory) item;

    // Maintain a reference to the python object in the C object extension
    ((Object) item)->extension = self;

    if(check_method_override((PyObject *) self, &Directory_Type, "iternext")) {
        // Proxy the iternext method
        ((Directory) target)->iternext = ProxiedDirectory_iternext;
    }
}

static int pyDirectory_init(pyDirectory *self, PyObject *args, PyObject *kwds)
{
    Directory result_constructor = NULL;
    // DEBUG: local arg type: Wrapper
    Gen_wrapper wrapped_fs UNUSED = NULL;
    FS_Info UNUSED fs;
    // DEBUG: local arg type: ZString
ZString path= NULL;
    // DEBUG: local arg type: Integer64Unsigned
uint64_t  inode= 0;

    static char *kwlist[] = {"fs","path","inode", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "O|sK", kwlist,&wrapped_fs,&path,&inode)) {
        goto on_error;
    }
    self->python_object1 = NULL;
    self->python_object2 = NULL;
    // Initialise is used to keep a reference on the object?
    // If not called no longer valid warnings have been seen on Windows.
    self->initialise = (void *) pyDirectory_initialize_proxies;

    if(wrapped_fs == NULL || (PyObject *)wrapped_fs == Py_None) {
        fs = NULL;
    } else if(!type_check((PyObject *)wrapped_fs,&FS_Info_Type)) {
        PyErr_Format(PyExc_RuntimeError, "fs must be derived from type FS_Info");
        goto on_error;
    } else if(wrapped_fs->base == NULL) {
        PyErr_Format(PyExc_RuntimeError, "FS_Info instance is no longer valid (was it gc'ed?)");
        goto on_error;
    } else {
        fs = wrapped_fs->base;
        if(self->python_object1 == NULL) {
            self->python_object1 = (PyObject *) wrapped_fs;
            Py_IncRef(self->python_object1);
        }
    }
    ClearError();

    // Allocate a new instance
    self->base = (Directory) alloc_Directory();
    self->base_is_python_object = 0;
    self->base_is_internal = 1;
    self->object_is_proxied = 0;

    // Update the target by replacing its methods with proxies to call back into Python
    pyDirectory_initialize_proxies(self, self->base);

    // Now call the constructor
    Py_BEGIN_ALLOW_THREADS
    result_constructor = CONSTRUCT_INITIALIZE(Directory, Directory, Con, self->base, fs, path, inode);
    Py_END_ALLOW_THREADS

    if(!CheckError(EZero)) {
        char *buffer = NULL;
        PyObject *exception = resolve_exception(&buffer);

        PyErr_Format(exception, "%s", buffer);
        ClearError();
        goto on_error;
    }
    if(result_constructor == NULL) {
        PyErr_Format(PyExc_IOError, "Unable to construct class Directory");
        goto on_error;
    }

    return 0;

on_error:
    if(self->python_object2 != NULL) {
        Py_DecRef(self->python_object2);
        self->python_object2 = NULL;
    }
    if(self->python_object1 != NULL) {
        Py_DecRef(self->python_object1);
        self->python_object1 = NULL;
    }
    if(self->base != NULL) {
        talloc_free(self->base);
        self->base = NULL;
    }
    return -1;
}

static PyObject *pyDirectory_getattr(pyDirectory *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (Directory.pyDirectory_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("info");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("current");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=Directory_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "info") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_info = NULL;


        PyErr_Clear();

        wrapped_info = (Gen_wrapper) PyObject_New(pyTSK_FS_DIR, &TSK_FS_DIR_Type);

        // Base is borrowed from another object.
        wrapped_info->base = (((Directory) self->base)->info);
        wrapped_info->base_is_python_object = 0;
        wrapped_info->base_is_internal = 0;
        wrapped_info->python_object1 = NULL;
        wrapped_info->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_info->base == NULL) {
            Py_DecRef((PyObject *) wrapped_info);
            Py_IncRef(Py_None);
            wrapped_info = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_info;


        return Py_result;
    }
    if(strcmp(name, "size") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED size;


Py_BEGIN_ALLOW_THREADS
size = (((Directory) self->base)->size);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(size);
#else
    Py_result = PyLong_FromUnsignedLong(size);
#endif


        return Py_result;
    }
    if(strcmp(name, "current") == 0) {
        PyObject *Py_result = NULL;
int UNUSED current;


Py_BEGIN_ALLOW_THREADS
current = (((Directory) self->base)->current);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(current);


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
void Directory.__iter__();
********************************************************/

static PyObject *pyDirectory___iter__(pyDirectory *self){
          ((Directory)self->base)->__iter__((Directory)self->base);
          return PyObject_SelfIter((PyObject *)self);
};
static void ProxiedDirectory___iter__(Directory self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("__iter__");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in Directory");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;
}


/********************************************************
Autogenerated wrapper for function:
File Directory.iternext();
********************************************************/

static PyObject *pyDirectory_iternext(pyDirectory *self){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Wrapper
        Gen_wrapper wrapped_func_return UNUSED = NULL;

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "Directory object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((Directory)self->base)->iternext;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "Directory.iternext is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
    {
        Object returned_object = NULL;

        ClearError();

        Py_BEGIN_ALLOW_THREADS
        // This call will return a Python object if the base is a proxied Python object
        // or a talloc managed object otherwise.
        returned_object = (Object) ((Directory) self->base)->iternext(((Directory) self->base));
        Py_END_ALLOW_THREADS

        if(check_error()) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
        if(returned_object == NULL) {
            goto on_error;
        }
        wrapped_func_return = new_class_wrapper(returned_object, self->base_is_python_object);

        if(wrapped_func_return == NULL) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
    }
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_result = (PyObject *)wrapped_func_return;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static File ProxiedDirectory_iternext(Directory self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
File func_return = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("iternext");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in Directory");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

     /* First check that the returned value is in fact a Wrapper */
     if(!type_check(Py_result, &File_Type)) {
          PyErr_Format(PyExc_RuntimeError, "function must return an File instance");
          goto on_error;
     }

     func_return = ((Gen_wrapper) Py_result)->base;

     if(!func_return) {
          PyErr_Format(PyExc_RuntimeError, "File instance is no longer valid (was it gc'ed?)");
          goto on_error;
}

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return NULL;
}


static int
Directory_nonzero(pyDirectory *v)
{
        return v->base != 0;
};
static PyNumberMethods Directory_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       Directory_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject Directory_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.Directory",
    /* tp_basicsize */
    sizeof(pyDirectory),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) Directory_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &Directory_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyDirectory_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "Directory:  This represents a Directory within the filesystem. You can\n    iterate over this object to obtain all the File objects\n    contained within this directory:\n\n    for f in d:\n        print f.info.name.name\n",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) pyDirectory___iter__,
    /* tp_iternext */
    (iternextfunc) pyDirectory_iternext,
    /* tp_methods */
    Directory_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyDirectory_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_VS_PART_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_VS_PART_FLAG_ENUM_dealloc(pyTSK_VS_PART_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_VS_PART_FLAG_ENUM_init(pyTSK_VS_PART_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_VS_PART_FLAG_ENUM___str__(pyTSK_VS_PART_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_VS_PART_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_VS_PART_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_VS_PART_FLAG_ENUM *self = (pyTSK_VS_PART_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_VS_PART_FLAG_ENUM_int(pyTSK_VS_PART_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_VS_PART_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_VS_PART_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_VS_PART_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_VS_PART_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_VS_PART_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_VS_PART_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_VS_PART_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_VS_PART_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_VS_PART_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_VS_PART_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_VS_PART_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_VS_PART_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_FLS_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_FLS_FLAG_ENUM_dealloc(pyTSK_FS_FLS_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_FLS_FLAG_ENUM_init(pyTSK_FS_FLS_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_FLS_FLAG_ENUM___str__(pyTSK_FS_FLS_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_FLS_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_FLS_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_FLS_FLAG_ENUM *self = (pyTSK_FS_FLS_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_FLS_FLAG_ENUM_int(pyTSK_FS_FLS_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_FLS_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_FLS_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_FLS_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_FLS_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_FLS_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_FLS_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_FLS_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_FLS_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_FLS_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_FLS_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_FLS_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_FLS_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_INFO_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_INFO_FLAG_ENUM_dealloc(pyTSK_FS_INFO_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_INFO_FLAG_ENUM_init(pyTSK_FS_INFO_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_INFO_FLAG_ENUM___str__(pyTSK_FS_INFO_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_INFO_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_INFO_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_INFO_FLAG_ENUM *self = (pyTSK_FS_INFO_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_INFO_FLAG_ENUM_int(pyTSK_FS_INFO_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_INFO_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_INFO_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_INFO_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_INFO_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_INFO_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_INFO_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_INFO_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_INFO_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_INFO_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_INFO_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_INFO_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_INFO_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_INFO_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_INFO_dealloc(pyTSK_FS_INFO *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_FS_INFO_init(pyTSK_FS_INFO *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_FS_INFO);
    // self->base = (TSK_FS_INFO *) PyMem_Malloc(sizeof(TSK_FS_INFO));
    return 0;
}

static PyObject *pyTSK_FS_INFO_getattr(pyTSK_FS_INFO *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_FS_INFO.pyTSK_FS_INFO_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("tag");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("offset");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("inum_count");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("root_inum");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("first_inum");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("last_inum");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("block_count");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("first_block");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("last_block");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("last_block_act");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("block_size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("dev_bsize");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("block_pre_size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("block_post_size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("journ_inum");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("ftype");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("flags");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("fs_id_used");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("endian");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("orphan_dir");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_FS_INFO_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "tag") == 0) {
        PyObject *Py_result = NULL;
int UNUSED tag;


Py_BEGIN_ALLOW_THREADS
tag = (self->base->tag);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(tag);


        return Py_result;
    }
    if(strcmp(name, "offset") == 0) {
        PyObject *Py_result = NULL;
int64_t  UNUSED offset;


Py_BEGIN_ALLOW_THREADS
offset = (self->base->offset);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromLongLong(offset);
#else
    Py_result = PyLong_FromLong(offset);
#endif


        return Py_result;
    }
    if(strcmp(name, "inum_count") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED inum_count;


Py_BEGIN_ALLOW_THREADS
inum_count = (self->base->inum_count);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(inum_count);
#else
    Py_result = PyLong_FromUnsignedLong(inum_count);
#endif


        return Py_result;
    }
    if(strcmp(name, "root_inum") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED root_inum;


Py_BEGIN_ALLOW_THREADS
root_inum = (self->base->root_inum);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(root_inum);
#else
    Py_result = PyLong_FromUnsignedLong(root_inum);
#endif


        return Py_result;
    }
    if(strcmp(name, "first_inum") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED first_inum;


Py_BEGIN_ALLOW_THREADS
first_inum = (self->base->first_inum);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(first_inum);
#else
    Py_result = PyLong_FromUnsignedLong(first_inum);
#endif


        return Py_result;
    }
    if(strcmp(name, "last_inum") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED last_inum;


Py_BEGIN_ALLOW_THREADS
last_inum = (self->base->last_inum);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(last_inum);
#else
    Py_result = PyLong_FromUnsignedLong(last_inum);
#endif


        return Py_result;
    }
    if(strcmp(name, "block_count") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED block_count;


Py_BEGIN_ALLOW_THREADS
block_count = (self->base->block_count);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(block_count);
#else
    Py_result = PyLong_FromUnsignedLong(block_count);
#endif


        return Py_result;
    }
    if(strcmp(name, "first_block") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED first_block;


Py_BEGIN_ALLOW_THREADS
first_block = (self->base->first_block);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(first_block);
#else
    Py_result = PyLong_FromUnsignedLong(first_block);
#endif


        return Py_result;
    }
    if(strcmp(name, "last_block") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED last_block;


Py_BEGIN_ALLOW_THREADS
last_block = (self->base->last_block);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(last_block);
#else
    Py_result = PyLong_FromUnsignedLong(last_block);
#endif


        return Py_result;
    }
    if(strcmp(name, "last_block_act") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED last_block_act;


Py_BEGIN_ALLOW_THREADS
last_block_act = (self->base->last_block_act);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(last_block_act);
#else
    Py_result = PyLong_FromUnsignedLong(last_block_act);
#endif


        return Py_result;
    }
    if(strcmp(name, "block_size") == 0) {
        PyObject *Py_result = NULL;
int UNUSED block_size;


Py_BEGIN_ALLOW_THREADS
block_size = (self->base->block_size);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(block_size);


        return Py_result;
    }
    if(strcmp(name, "dev_bsize") == 0) {
        PyObject *Py_result = NULL;
int UNUSED dev_bsize;


Py_BEGIN_ALLOW_THREADS
dev_bsize = (self->base->dev_bsize);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(dev_bsize);


        return Py_result;
    }
    if(strcmp(name, "block_pre_size") == 0) {
        PyObject *Py_result = NULL;
int UNUSED block_pre_size;


Py_BEGIN_ALLOW_THREADS
block_pre_size = (self->base->block_pre_size);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(block_pre_size);


        return Py_result;
    }
    if(strcmp(name, "block_post_size") == 0) {
        PyObject *Py_result = NULL;
int UNUSED block_post_size;


Py_BEGIN_ALLOW_THREADS
block_post_size = (self->base->block_post_size);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(block_post_size);


        return Py_result;
    }
    if(strcmp(name, "journ_inum") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED journ_inum;


Py_BEGIN_ALLOW_THREADS
journ_inum = (self->base->journ_inum);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(journ_inum);
#else
    Py_result = PyLong_FromUnsignedLong(journ_inum);
#endif


        return Py_result;
    }
    if(strcmp(name, "ftype") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED ftype = 0;


Py_BEGIN_ALLOW_THREADS
ftype = (self->base->ftype);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_TYPE_ENUM", "K", (uint64_t)ftype);


        return Py_result;
    }
    if(strcmp(name, "flags") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED flags = 0;


Py_BEGIN_ALLOW_THREADS
flags = (self->base->flags);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_INFO_FLAG_ENUM", "K", (uint64_t)flags);


        return Py_result;
    }
    if(strcmp(name, "fs_id_used") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED fs_id_used;


Py_BEGIN_ALLOW_THREADS
fs_id_used = (self->base->fs_id_used);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(fs_id_used);
#else
    Py_result = PyLong_FromUnsignedLong(fs_id_used);
#endif


        return Py_result;
    }
    if(strcmp(name, "endian") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED endian = 0;


Py_BEGIN_ALLOW_THREADS
endian = (self->base->endian);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_ENDIAN_ENUM", "K", (uint64_t)endian);


        return Py_result;
    }
    if(strcmp(name, "orphan_dir") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_orphan_dir = NULL;


        PyErr_Clear();

        wrapped_orphan_dir = (Gen_wrapper) PyObject_New(pyTSK_FS_DIR, &TSK_FS_DIR_Type);

        // Base is borrowed from another object.
        wrapped_orphan_dir->base = (self->base->orphan_dir);
        wrapped_orphan_dir->base_is_python_object = 0;
        wrapped_orphan_dir->base_is_internal = 0;
        wrapped_orphan_dir->python_object1 = NULL;
        wrapped_orphan_dir->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_orphan_dir->base == NULL) {
            Py_DecRef((PyObject *) wrapped_orphan_dir);
            Py_IncRef(Py_None);
            wrapped_orphan_dir = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_orphan_dir;


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_FS_INFO_nonzero(pyTSK_FS_INFO *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_FS_INFO_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_FS_INFO_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_INFO_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_INFO",
    /* tp_basicsize */
    sizeof(pyTSK_FS_INFO),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_INFO_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_INFO_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_FS_INFO_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_INFO: \n    * Stores state information for an open file system. \n    * One of these are generated for each open files system and it contains\n    * file system-type specific data.  These values are all filled in by\n    * the file system code and not the caller functions.  This struct\n    * (and its subclasses) should be allocated only by tsk_fs_malloc\n    * and deallocated only by tsk_fs_free, which handle init/deinit\n    * of the locks.\n    ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_INFO_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_INFO_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_ATTR_RUN_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_ATTR_RUN_dealloc(pyTSK_FS_ATTR_RUN *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_FS_ATTR_RUN_init(pyTSK_FS_ATTR_RUN *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_FS_ATTR_RUN);
    // self->base = (TSK_FS_ATTR_RUN *) PyMem_Malloc(sizeof(TSK_FS_ATTR_RUN));
    return 0;
}

static PyObject *pyTSK_FS_ATTR_RUN_getattr(pyTSK_FS_ATTR_RUN *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_FS_ATTR_RUN.pyTSK_FS_ATTR_RUN_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("next");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("offset");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("addr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("len");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("flags");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_FS_ATTR_RUN_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "next") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_next = NULL;


        PyErr_Clear();

        wrapped_next = (Gen_wrapper) PyObject_New(pyTSK_FS_ATTR_RUN, &TSK_FS_ATTR_RUN_Type);

        // Base is borrowed from another object.
        wrapped_next->base = (self->base->next);
        wrapped_next->base_is_python_object = 0;
        wrapped_next->base_is_internal = 0;
        wrapped_next->python_object1 = NULL;
        wrapped_next->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_next->base == NULL) {
            Py_DecRef((PyObject *) wrapped_next);
            Py_IncRef(Py_None);
            wrapped_next = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_next;


        return Py_result;
    }
    if(strcmp(name, "offset") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED offset;


Py_BEGIN_ALLOW_THREADS
offset = (self->base->offset);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(offset);
#else
    Py_result = PyLong_FromUnsignedLong(offset);
#endif


        return Py_result;
    }
    if(strcmp(name, "addr") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED addr;


Py_BEGIN_ALLOW_THREADS
addr = (self->base->addr);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(addr);
#else
    Py_result = PyLong_FromUnsignedLong(addr);
#endif


        return Py_result;
    }
    if(strcmp(name, "len") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED len;


Py_BEGIN_ALLOW_THREADS
len = (self->base->len);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(len);
#else
    Py_result = PyLong_FromUnsignedLong(len);
#endif


        return Py_result;
    }
    if(strcmp(name, "flags") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED flags = 0;


Py_BEGIN_ALLOW_THREADS
flags = (self->base->flags);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_ATTR_RUN_FLAG_ENUM", "K", (uint64_t)flags);


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_FS_ATTR_RUN_nonzero(pyTSK_FS_ATTR_RUN *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_FS_ATTR_RUN_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_FS_ATTR_RUN_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_ATTR_RUN_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_ATTR_RUN",
    /* tp_basicsize */
    sizeof(pyTSK_FS_ATTR_RUN),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_ATTR_RUN_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_ATTR_RUN_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_FS_ATTR_RUN_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_ATTR_RUN: \n    * Holds information about a single data run, which has a starting address and length.\n    * A run describes a consecutive list of blocks that have been allocated to a file. \n    * A file may have many such runs and they are stringed together in a linked list.\n    * The entries in the list must be stored in sequential order (based on offset in file).\n    ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_ATTR_RUN_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_ATTR_RUN_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_IFIND_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_IFIND_FLAG_ENUM_dealloc(pyTSK_FS_IFIND_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_IFIND_FLAG_ENUM_init(pyTSK_FS_IFIND_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_IFIND_FLAG_ENUM___str__(pyTSK_FS_IFIND_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_IFIND_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_IFIND_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_IFIND_FLAG_ENUM *self = (pyTSK_FS_IFIND_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_IFIND_FLAG_ENUM_int(pyTSK_FS_IFIND_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_IFIND_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_IFIND_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_IFIND_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_IFIND_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_IFIND_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_IFIND_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_IFIND_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_IFIND_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_IFIND_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_IFIND_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_IFIND_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_IFIND_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_FILE_WALK_FLAG_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_FILE_WALK_FLAG_ENUM_dealloc(pyTSK_FS_FILE_WALK_FLAG_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_FS_FILE_WALK_FLAG_ENUM_init(pyTSK_FS_FILE_WALK_FLAG_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_FS_FILE_WALK_FLAG_ENUM___str__(pyTSK_FS_FILE_WALK_FLAG_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_FS_FILE_WALK_FLAG_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_FS_FILE_WALK_FLAG_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_FS_FILE_WALK_FLAG_ENUM *self = (pyTSK_FS_FILE_WALK_FLAG_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_FS_FILE_WALK_FLAG_ENUM_int(pyTSK_FS_FILE_WALK_FLAG_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_FS_FILE_WALK_FLAG_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_FS_FILE_WALK_FLAG_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_FILE_WALK_FLAG_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_FILE_WALK_FLAG_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_FS_FILE_WALK_FLAG_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_FILE_WALK_FLAG_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_FILE_WALK_FLAG_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_FS_FILE_WALK_FLAG_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_FILE_WALK_FLAG_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_FS_FILE_WALK_FLAG_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_FILE_WALK_FLAG_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_FILE_WALK_FLAG_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_BLOCK_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_BLOCK_dealloc(pyTSK_FS_BLOCK *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_FS_BLOCK_init(pyTSK_FS_BLOCK *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_FS_BLOCK);
    // self->base = (TSK_FS_BLOCK *) PyMem_Malloc(sizeof(TSK_FS_BLOCK));
    return 0;
}

static PyObject *pyTSK_FS_BLOCK_getattr(pyTSK_FS_BLOCK *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_FS_BLOCK.pyTSK_FS_BLOCK_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("tag");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("fs_info");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("buf");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("addr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("flags");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_FS_BLOCK_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "tag") == 0) {
        PyObject *Py_result = NULL;
int UNUSED tag;


Py_BEGIN_ALLOW_THREADS
tag = (self->base->tag);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(tag);


        return Py_result;
    }
    if(strcmp(name, "fs_info") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_fs_info = NULL;


        PyErr_Clear();

        wrapped_fs_info = (Gen_wrapper) PyObject_New(pyTSK_FS_INFO, &TSK_FS_INFO_Type);

        // Base is borrowed from another object.
        wrapped_fs_info->base = (self->base->fs_info);
        wrapped_fs_info->base_is_python_object = 0;
        wrapped_fs_info->base_is_internal = 0;
        wrapped_fs_info->python_object1 = NULL;
        wrapped_fs_info->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_fs_info->base == NULL) {
            Py_DecRef((PyObject *) wrapped_fs_info);
            Py_IncRef(Py_None);
            wrapped_fs_info = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_fs_info;


        return Py_result;
    }
    if(strcmp(name, "buf") == 0) {
        PyObject *Py_result = NULL;
char * UNUSED buf;


Py_BEGIN_ALLOW_THREADS
buf = (self->base->buf);
Py_END_ALLOW_THREADS

    PyErr_Clear();

    if(!buf) {
        Py_IncRef(Py_None);
        Py_result = Py_None;
    } else {
        Py_result = PyString_FromStringAndSize((char *)buf, strlen(buf));
        if(!Py_result) goto on_error;
    };


        return Py_result;
    }
    if(strcmp(name, "addr") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED addr;


Py_BEGIN_ALLOW_THREADS
addr = (self->base->addr);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(addr);
#else
    Py_result = PyLong_FromUnsignedLong(addr);
#endif


        return Py_result;
    }
    if(strcmp(name, "flags") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED flags = 0;


Py_BEGIN_ALLOW_THREADS
flags = (self->base->flags);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_BLOCK_FLAG_ENUM", "K", (uint64_t)flags);


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_FS_BLOCK_nonzero(pyTSK_FS_BLOCK *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_FS_BLOCK_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_FS_BLOCK_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_BLOCK_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_BLOCK",
    /* tp_basicsize */
    sizeof(pyTSK_FS_BLOCK),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_BLOCK_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_BLOCK_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_FS_BLOCK_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_BLOCK:  \n    * Generic data structure to hold block data with metadata\n    ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_BLOCK_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_BLOCK_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_ATTR_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_ATTR_dealloc(pyTSK_FS_ATTR *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_FS_ATTR_init(pyTSK_FS_ATTR *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_FS_ATTR);
    // self->base = (TSK_FS_ATTR *) PyMem_Malloc(sizeof(TSK_FS_ATTR));
    return 0;
}

static PyObject *pyTSK_FS_ATTR_getattr(pyTSK_FS_ATTR *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_FS_ATTR.pyTSK_FS_ATTR_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("next");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("fs_file");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("flags");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("name");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("name_size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("type");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("id");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("size");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_FS_ATTR_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "next") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_next = NULL;


        PyErr_Clear();

        wrapped_next = (Gen_wrapper) PyObject_New(pyTSK_FS_ATTR, &TSK_FS_ATTR_Type);

        // Base is borrowed from another object.
        wrapped_next->base = (self->base->next);
        wrapped_next->base_is_python_object = 0;
        wrapped_next->base_is_internal = 0;
        wrapped_next->python_object1 = NULL;
        wrapped_next->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_next->base == NULL) {
            Py_DecRef((PyObject *) wrapped_next);
            Py_IncRef(Py_None);
            wrapped_next = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_next;


        return Py_result;
    }
    if(strcmp(name, "fs_file") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_fs_file = NULL;


        PyErr_Clear();

        wrapped_fs_file = (Gen_wrapper) PyObject_New(pyTSK_FS_FILE, &TSK_FS_FILE_Type);

        // Base is borrowed from another object.
        wrapped_fs_file->base = (self->base->fs_file);
        wrapped_fs_file->base_is_python_object = 0;
        wrapped_fs_file->base_is_internal = 0;
        wrapped_fs_file->python_object1 = NULL;
        wrapped_fs_file->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_fs_file->base == NULL) {
            Py_DecRef((PyObject *) wrapped_fs_file);
            Py_IncRef(Py_None);
            wrapped_fs_file = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_fs_file;


        return Py_result;
    }
    if(strcmp(name, "flags") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED flags = 0;


Py_BEGIN_ALLOW_THREADS
flags = (self->base->flags);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_ATTR_FLAG_ENUM", "K", (uint64_t)flags);


        return Py_result;
    }
    if(strcmp(name, "name") == 0) {
        PyObject *Py_result = NULL;
char * UNUSED name;


Py_BEGIN_ALLOW_THREADS
name = (self->base->name);
Py_END_ALLOW_THREADS

    PyErr_Clear();

    if(!name) {
        Py_IncRef(Py_None);
        Py_result = Py_None;
    } else {
        Py_result = PyString_FromStringAndSize((char *)name, strlen(name));
        if(!Py_result) goto on_error;
    };


        return Py_result;
    }
    if(strcmp(name, "name_size") == 0) {
        PyObject *Py_result = NULL;
uint64_t  UNUSED name_size;


Py_BEGIN_ALLOW_THREADS
name_size = (self->base->name_size);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromUnsignedLongLong(name_size);
#else
    Py_result = PyLong_FromUnsignedLong(name_size);
#endif


        return Py_result;
    }
    if(strcmp(name, "type") == 0) {
        PyObject *Py_result = NULL;
    int UNUSED type = 0;


Py_BEGIN_ALLOW_THREADS
type = (self->base->type);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyObject_CallMethod(g_module, "TSK_FS_ATTR_TYPE_ENUM", "K", (uint64_t)type);


        return Py_result;
    }
    if(strcmp(name, "id") == 0) {
        PyObject *Py_result = NULL;
uint16_t  UNUSED id;


Py_BEGIN_ALLOW_THREADS
id = (self->base->id);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong((long) id);


        return Py_result;
    }
    if(strcmp(name, "size") == 0) {
        PyObject *Py_result = NULL;
int64_t  UNUSED size;


Py_BEGIN_ALLOW_THREADS
size = (self->base->size);
Py_END_ALLOW_THREADS

PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    Py_result = PyLong_FromLongLong(size);
#else
    Py_result = PyLong_FromLong(size);
#endif


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_FS_ATTR_nonzero(pyTSK_FS_ATTR *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_FS_ATTR_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_FS_ATTR_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_ATTR_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_ATTR",
    /* tp_basicsize */
    sizeof(pyTSK_FS_ATTR),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_ATTR_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_ATTR_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_FS_ATTR_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_ATTR: \n    * Holds information about the location of file content (or a file attribute). For most file systems, a file\n    * has only a single attribute that stores the file content. \n    * Other file systems, such as NTFS, have multiple\n    * attributes.  If multiple attributes exist, they are stored in a linked list.\n    * Attributes can be \"resident\", which means the data is stored\n    * in a small buffer instead of being stored in a full file system block.\n    * \"Non-resident\" attributes store data in blocks and they are stored in \n    * the data structure as a series of runs.  \n    * This structure is used to represent both of these cases.\n    *\n    * The non-resident data has several size values. \n    * \\verbatim\n    * |--------------------------------------------------------------------|\n    * |skiplen|---------------allocsize------------------------------------|\n    * |skiplen|---------------size-----------------------------------|\n    * |skiplen|---------------initsize------------|\n    * \\endverbatim\n    ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_ATTR_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_ATTR_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef File_methods[] = {
    { "read_random",
      (PyCFunction) pyFile_read_random,
      METH_VARARGS|METH_KEYWORDS,
      "uint64_t File.read_random(TSK_OFF_T offset ,OUT char * buff, int len,TSK_FS_ATTR_TYPE_ENUM type ,int id ,TSK_FS_FILE_READ_FLAG_ENUM flags );\n\n\nRead a buffer from a random location in the file.\n\n         DEFAULT(flags) = 0;\n         DEFAULT(type) = TSK_FS_ATTR_TYPE_DEFAULT;\n         DEFAULT(id) = -1;"},

    { "as_directory",
      (PyCFunction) pyFile_as_directory,
      METH_VARARGS|METH_KEYWORDS,
      "struct Directory_t * File.as_directory();\n\n\nObtain a directory object that represents this inode. This may\n        be useful if the file is actually a directory and we want to\n        iterate over its contents."},

    {NULL}  /* Sentinel */
};

static void File_dealloc(pyFile *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            if(self->base_is_python_object != 0) {
                Py_DecRef((PyObject*) self->base);
            } else if(self->base_is_internal != 0) {
                talloc_free(self->base);
            }
            self->base = NULL;
        }
        if(self->python_object2 != NULL) {
            Py_DecRef(self->python_object2);
            self->python_object2 = NULL;
        }
        if(self->python_object1 != NULL) {
            Py_DecRef(self->python_object1);
            self->python_object1 = NULL;
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static void pyFile_initialize_proxies(pyFile *self, void *item) {
    File target = (File) item;

    // Maintain a reference to the python object in the C object extension
    ((Object) item)->extension = self;

    if(check_method_override((PyObject *) self, &File_Type, "read_random")) {
        // Proxy the read_random method
        ((File) target)->read_random = ProxiedFile_read_random;
    }
    if(check_method_override((PyObject *) self, &File_Type, "as_directory")) {
        // Proxy the as_directory method
        ((File) target)->as_directory = ProxiedFile_as_directory;
    }
    if(check_method_override((PyObject *) self, &File_Type, "iternext")) {
        // Proxy the iternext method
        ((File) target)->iternext = ProxiedFile_iternext;
    }
}

static int pyFile_init(pyFile *self, PyObject *args, PyObject *kwds)
{
    File result_constructor = NULL;
    // DEBUG: local arg type: Wrapper
    Gen_wrapper wrapped_fs UNUSED = NULL;
    FS_Info UNUSED fs;
    // DEBUG: local arg type: PointerStructWrapper
Gen_wrapper wrapped_info = NULL; TSK_FS_FILE *info=NULL;

    static char *kwlist[] = {"fs","info", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "OO", kwlist,&wrapped_fs,&wrapped_info)) {
        goto on_error;
    }
    self->python_object1 = NULL;
    self->python_object2 = NULL;
    // Initialise is used to keep a reference on the object?
    // If not called no longer valid warnings have been seen on Windows.
    self->initialise = (void *) pyFile_initialize_proxies;

    if(wrapped_fs == NULL || (PyObject *)wrapped_fs == Py_None) {
        fs = NULL;
    } else if(!type_check((PyObject *)wrapped_fs,&FS_Info_Type)) {
        PyErr_Format(PyExc_RuntimeError, "fs must be derived from type FS_Info");
        goto on_error;
    } else if(wrapped_fs->base == NULL) {
        PyErr_Format(PyExc_RuntimeError, "FS_Info instance is no longer valid (was it gc'ed?)");
        goto on_error;
    } else {
        fs = wrapped_fs->base;
        if(self->python_object1 == NULL) {
            self->python_object1 = (PyObject *) wrapped_fs;
            Py_IncRef(self->python_object1);
        }
    }
    if(wrapped_info == NULL || (PyObject *)wrapped_info == Py_None) {
        info = NULL;
    } else if(!type_check((PyObject *)wrapped_info,&TSK_FS_FILE_Type)) {
        PyErr_Format(PyExc_RuntimeError, "info must be derived from type TSK_FS_FILE");
        goto on_error;
    } else if(wrapped_info->base == NULL) {
        PyErr_Format(PyExc_RuntimeError, "TSK_FS_FILE instance is no longer valid (was it gc'ed?)");
        goto on_error;
    } else {
        info = wrapped_info->base;
        if(self->python_object2 == NULL) {
            self->python_object2 = (PyObject *) wrapped_info;
            Py_IncRef(self->python_object2);
        }
    }
    ClearError();

    // Allocate a new instance
    self->base = (File) alloc_File();
    self->base_is_python_object = 0;
    self->base_is_internal = 1;
    self->object_is_proxied = 0;

    // Update the target by replacing its methods with proxies to call back into Python
    pyFile_initialize_proxies(self, self->base);

    // Now call the constructor
    Py_BEGIN_ALLOW_THREADS
    result_constructor = CONSTRUCT_INITIALIZE(File, File, Con, self->base, fs, info);
    Py_END_ALLOW_THREADS

    if(!CheckError(EZero)) {
        char *buffer = NULL;
        PyObject *exception = resolve_exception(&buffer);

        PyErr_Format(exception, "%s", buffer);
        ClearError();
        goto on_error;
    }
    if(result_constructor == NULL) {
        PyErr_Format(PyExc_IOError, "Unable to construct class File");
        goto on_error;
    }

    return 0;

on_error:
    if(self->python_object2 != NULL) {
        Py_DecRef(self->python_object2);
        self->python_object2 = NULL;
    }
    if(self->python_object1 != NULL) {
        Py_DecRef(self->python_object1);
        self->python_object1 = NULL;
    }
    if(self->base != NULL) {
        talloc_free(self->base);
        self->base = NULL;
    }
    return -1;
}

static PyObject *pyFile_getattr(pyFile *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (File.pyFile_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("info");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("max_attr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("current_attr");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=File_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "info") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_info = NULL;


        PyErr_Clear();

        wrapped_info = (Gen_wrapper) PyObject_New(pyTSK_FS_FILE, &TSK_FS_FILE_Type);

        // Base is borrowed from another object.
        wrapped_info->base = (((File) self->base)->info);
        wrapped_info->base_is_python_object = 0;
        wrapped_info->base_is_internal = 0;
        wrapped_info->python_object1 = NULL;
        wrapped_info->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_info->base == NULL) {
            Py_DecRef((PyObject *) wrapped_info);
            Py_IncRef(Py_None);
            wrapped_info = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_info;


        return Py_result;
    }
    if(strcmp(name, "max_attr") == 0) {
        PyObject *Py_result = NULL;
int UNUSED max_attr;


Py_BEGIN_ALLOW_THREADS
max_attr = (((File) self->base)->max_attr);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(max_attr);


        return Py_result;
    }
    if(strcmp(name, "current_attr") == 0) {
        PyObject *Py_result = NULL;
int UNUSED current_attr;


Py_BEGIN_ALLOW_THREADS
current_attr = (((File) self->base)->current_attr);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(current_attr);


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
uint64_t File.read_random(TSK_OFF_T offset ,OUT char * buff, int len,TSK_FS_ATTR_TYPE_ENUM type ,int id ,TSK_FS_FILE_READ_FLAG_ENUM flags );
********************************************************/
static PyObject *pyFile_read_random(pyFile *self, PyObject *args, PyObject *kwds){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Integer64Unsigned
    uint64_t  UNUSED func_return;
    // DEBUG: local arg type: Integer64
int64_t  UNUSED offset;
    // DEBUG: local arg type: Char_and_Length_OUT
    char *buff = NULL;
    Py_ssize_t len = 0;
    PyObject *tmp_buff = NULL;
    // DEBUG: local arg type: EnumType
    int type =  TSK_FS_ATTR_TYPE_DEFAULT;
    // DEBUG: local arg type: Integer
int id= -1;
    // DEBUG: local arg type: EnumType
    int flags =  0;

    static char *kwlist[] = {"offset","len","type","id","flags", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "Ll|iii", kwlist,&offset,&len,&type,&id,&flags)) {
        goto on_error;
    }

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "File object no longer valid");
    }

    // Precall preparations
    PyErr_Clear();

    tmp_buff = PyString_FromStringAndSize(NULL, len);
    if(!tmp_buff) goto on_error;

    PyString_AsStringAndSize(tmp_buff, &buff, (Py_ssize_t *)&len);

// Check if the integer passed is actually a valid member of the enum
// Enum value of 0 is always allowed
if(type) { PyObject *py_type = PyLong_FromLong(type);
  PyObject *tmp = PyDict_GetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, py_type);

  Py_DecRef(py_type);
  if(!tmp) {
    PyErr_Format(PyExc_RuntimeError, "value %lu is not valid for Enum TSK_FS_ATTR_TYPE_ENUM of arg 'type'", (unsigned long)type);
    goto on_error;
  };
};

// Check if the integer passed is actually a valid member of the enum
// Enum value of 0 is always allowed
if(flags) { PyObject *py_flags = PyLong_FromLong(flags);
  PyObject *tmp = PyDict_GetItem(TSK_FS_FILE_READ_FLAG_ENUM_rev_lookup, py_flags);

  Py_DecRef(py_flags);
  if(!tmp) {
    PyErr_Format(PyExc_RuntimeError, "value %lu is not valid for Enum TSK_FS_FILE_READ_FLAG_ENUM of arg 'flags'", (unsigned long)flags);
    goto on_error;
  };
};
    // Check the function is implemented
    {
        void *method = ((File)self->base)->read_random;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "File.read_random is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
Py_BEGIN_ALLOW_THREADS
func_return =         ((File) self->base)->read_random(((File) self->base), offset, (OUT char *)buff, (int)len, type, id, flags);
Py_END_ALLOW_THREADS
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results

    // NOTE - this should never happen - it might indicate an overflow condition.
    if(func_return > len) {
        printf("Programming Error - possible overflow!!\n");
        abort();

    // Do we need to truncate the buffer for a short read?
    } else if(func_return < len) {
        _PyString_Resize(&tmp_buff, (Py_ssize_t)func_return);
    }

    Py_result = tmp_buff;
    returned_result = Py_result;
    return returned_result;

on_error:
    if(tmp_buff != NULL) {
        Py_DecRef(tmp_buff);
    }
    return NULL;
};

static uint64_t ProxiedFile_read_random(File self, TSK_OFF_T offset, OUT char * buff, int len, TSK_FS_ATTR_TYPE_ENUM type, int id, TSK_FS_FILE_READ_FLAG_ENUM flags) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
uint64_t  UNUSED func_return;
PyObject *py_offset = NULL;
PyObject *py_buff = NULL;
PyObject *py_type = NULL;
PyObject *py_id = NULL;
PyObject *py_flags = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("read_random");

// Obtain python objects for all the args:
PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    py_offset = PyLong_FromLongLong(offset);
#else
    py_offset = PyLong_FromLong(offset);
#endif
py_buff = PyLong_FromLong(len);
PyErr_Clear();
py_type = PyObject_CallMethod(g_module, "TSK_FS_ATTR_TYPE_ENUM", "K", (uint64_t)type);
PyErr_Clear();
py_id = PyInt_FromLong(id);
PyErr_Clear();
py_flags = PyObject_CallMethod(g_module, "TSK_FS_FILE_READ_FLAG_ENUM", "K", (uint64_t)flags);
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in File");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, py_offset,py_buff,py_type,py_id,py_flags,NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }


{
    char *tmp_buff; Py_ssize_t tmp_len;
    if(-1==PyString_AsStringAndSize(Py_result, &tmp_buff, &tmp_len)) goto on_error;

    memcpy(buff,tmp_buff, tmp_len);
    Py_DecRef(Py_result);
    Py_result = PyLong_FromLong(tmp_len);
}
PyErr_Clear();
#if defined( HAVE_LONG_LONG )
    func_return = PyInt_AsUnsignedLongLongMask(Py_result);
#else
    func_return = PyInt_AsUnsignedLongMask(Py_result);
#endif
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_offset != NULL) {
        Py_DecRef(py_offset);
    }
    if(py_buff != NULL) {
        Py_DecRef(py_buff);
    }
    if(py_type != NULL) {
        Py_DecRef(py_type);
    }
    if(py_id != NULL) {
        Py_DecRef(py_id);
    }
    if(py_flags != NULL) {
        Py_DecRef(py_flags);
    }
    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    if(py_offset != NULL) {
        Py_DecRef(py_offset);
    }
    if(py_buff != NULL) {
        Py_DecRef(py_buff);
    }
    if(py_type != NULL) {
        Py_DecRef(py_type);
    }
    if(py_id != NULL) {
        Py_DecRef(py_id);
    }
    if(py_flags != NULL) {
        Py_DecRef(py_flags);
    }
    PyGILState_Release(gstate);

    return 0;
}


/********************************************************
Autogenerated wrapper for function:
struct Directory_t * File.as_directory();
********************************************************/
static PyObject *pyFile_as_directory(pyFile *self, PyObject *args, PyObject *kwds){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Wrapper
        Gen_wrapper wrapped_func_return UNUSED = NULL;

    static char *kwlist[] = { NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "", kwlist)) {
        goto on_error;
    }

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "File object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((File)self->base)->as_directory;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "File.as_directory is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
    {
        Object returned_object = NULL;

        ClearError();

        Py_BEGIN_ALLOW_THREADS
        // This call will return a Python object if the base is a proxied Python object
        // or a talloc managed object otherwise.
        returned_object = (Object) ((File) self->base)->as_directory(((File) self->base));
        Py_END_ALLOW_THREADS

        if(check_error()) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
        wrapped_func_return = new_class_wrapper(returned_object, self->base_is_python_object);

        if(wrapped_func_return == NULL) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
    }
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_result = (PyObject *)wrapped_func_return;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static Directory ProxiedFile_as_directory(File self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
Directory func_return = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("as_directory");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in File");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

     /* First check that the returned value is in fact a Wrapper */
     if(!type_check(Py_result, &Directory_Type)) {
          PyErr_Format(PyExc_RuntimeError, "function must return an Directory instance");
          goto on_error;
     }

     func_return = ((Gen_wrapper) Py_result)->base;

     if(!func_return) {
          PyErr_Format(PyExc_RuntimeError, "Directory instance is no longer valid (was it gc'ed?)");
          goto on_error;
}

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
void File.__iter__();
********************************************************/

static PyObject *pyFile___iter__(pyFile *self){
          ((File)self->base)->__iter__((File)self->base);
          return PyObject_SelfIter((PyObject *)self);
};
static void ProxiedFile___iter__(File self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("__iter__");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in File");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;
}


/********************************************************
Autogenerated wrapper for function:
Attribute File.iternext();
********************************************************/

static PyObject *pyFile_iternext(pyFile *self){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: Wrapper
        Gen_wrapper wrapped_func_return UNUSED = NULL;

    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "File object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((File)self->base)->iternext;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "File.iternext is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();
    {
        Object returned_object = NULL;

        ClearError();

        Py_BEGIN_ALLOW_THREADS
        // This call will return a Python object if the base is a proxied Python object
        // or a talloc managed object otherwise.
        returned_object = (Object) ((File) self->base)->iternext(((File) self->base));
        Py_END_ALLOW_THREADS

        if(check_error()) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
        if(returned_object == NULL) {
            goto on_error;
        }
        wrapped_func_return = new_class_wrapper(returned_object, self->base_is_python_object);

        if(wrapped_func_return == NULL) {
            if(returned_object != NULL) {
                if(self->base_is_python_object != 0) {
                    Py_DecRef((PyObject *) returned_object);
                } else if(self->base_is_internal != 0) {
                    talloc_free(returned_object);
                }
            }
            goto on_error;
        }
    }
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_result = (PyObject *)wrapped_func_return;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static Attribute ProxiedFile_iternext(File self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
Attribute func_return = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("iternext");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in File");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

     /* First check that the returned value is in fact a Wrapper */
     if(!type_check(Py_result, &Attribute_Type)) {
          PyErr_Format(PyExc_RuntimeError, "function must return an Attribute instance");
          goto on_error;
     }

     func_return = ((Gen_wrapper) Py_result)->base;

     if(!func_return) {
          PyErr_Format(PyExc_RuntimeError, "Attribute instance is no longer valid (was it gc'ed?)");
          goto on_error;
}

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return NULL;
}


static int
File_nonzero(pyFile *v)
{
        return v->base != 0;
};
static PyNumberMethods File_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       File_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject File_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.File",
    /* tp_basicsize */
    sizeof(pyFile),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) File_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &File_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyFile_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "File:  This represents a file object. A file has both metadata and\n    data streams.\n\n    Its usually not useful to instantiate this class by itself -\n    you need to call FS_Info.open() or iterate over a Directory()\n    object.\n\n    This object may be used to read the content of the file using\n    read_random().\n\n    Iterating over this object will return all the attributes for\n    this file.\n",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) pyFile___iter__,
    /* tp_iternext */
    (iternextfunc) pyFile_iternext,
    /* tp_methods */
    File_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyFile_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_FS_FILE_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_FS_FILE_dealloc(pyTSK_FS_FILE *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            self->base = NULL;
            // talloc_free(self->base);
            // PyMem_Free(self->base);
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static int pyTSK_FS_FILE_init(pyTSK_FS_FILE *self, PyObject *args, PyObject *kwds) {
    // Base is borrowed from another object.
    self->base = NULL;
    // self->base = talloc_zero(NULL, TSK_FS_FILE);
    // self->base = (TSK_FS_FILE *) PyMem_Malloc(sizeof(TSK_FS_FILE));
    return 0;
}

static PyObject *pyTSK_FS_FILE_getattr(pyTSK_FS_FILE *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (TSK_FS_FILE.pyTSK_FS_FILE_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("tag");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("name");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("meta");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("fs_info");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=TSK_FS_FILE_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "tag") == 0) {
        PyObject *Py_result = NULL;
int UNUSED tag;


Py_BEGIN_ALLOW_THREADS
tag = (self->base->tag);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(tag);


        return Py_result;
    }
    if(strcmp(name, "name") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_name = NULL;


        PyErr_Clear();

        wrapped_name = (Gen_wrapper) PyObject_New(pyTSK_FS_NAME, &TSK_FS_NAME_Type);

        // Base is borrowed from another object.
        wrapped_name->base = (self->base->name);
        wrapped_name->base_is_python_object = 0;
        wrapped_name->base_is_internal = 0;
        wrapped_name->python_object1 = NULL;
        wrapped_name->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_name->base == NULL) {
            Py_DecRef((PyObject *) wrapped_name);
            Py_IncRef(Py_None);
            wrapped_name = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_name;


        return Py_result;
    }
    if(strcmp(name, "meta") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_meta = NULL;


        PyErr_Clear();

        wrapped_meta = (Gen_wrapper) PyObject_New(pyTSK_FS_META, &TSK_FS_META_Type);

        // Base is borrowed from another object.
        wrapped_meta->base = (self->base->meta);
        wrapped_meta->base_is_python_object = 0;
        wrapped_meta->base_is_internal = 0;
        wrapped_meta->python_object1 = NULL;
        wrapped_meta->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_meta->base == NULL) {
            Py_DecRef((PyObject *) wrapped_meta);
            Py_IncRef(Py_None);
            wrapped_meta = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_meta;


        return Py_result;
    }
    if(strcmp(name, "fs_info") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_fs_info = NULL;


        PyErr_Clear();

        wrapped_fs_info = (Gen_wrapper) PyObject_New(pyTSK_FS_INFO, &TSK_FS_INFO_Type);

        // Base is borrowed from another object.
        wrapped_fs_info->base = (self->base->fs_info);
        wrapped_fs_info->base_is_python_object = 0;
        wrapped_fs_info->base_is_internal = 0;
        wrapped_fs_info->python_object1 = NULL;
        wrapped_fs_info->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_fs_info->base == NULL) {
            Py_DecRef((PyObject *) wrapped_fs_info);
            Py_IncRef(Py_None);
            wrapped_fs_info = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_fs_info;


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


static int
TSK_FS_FILE_nonzero(pyTSK_FS_FILE *v)
{
        return v->base != 0;
};
static PyNumberMethods TSK_FS_FILE_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       TSK_FS_FILE_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_FS_FILE_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_FS_FILE",
    /* tp_basicsize */
    sizeof(pyTSK_FS_FILE),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_FS_FILE_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_FS_FILE_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyTSK_FS_FILE_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_FS_FILE: \n    * Generic structure used to refer to files in the file system.  A file will\n    * typically have a name and metadata.  This structure holds that type of information.\n    * When deleted files are being processed, this structure may have the name defined\n    * but not metadata because it no longer exists. Or, if you are calling meta_walk\n    * and are not processing at the name level, then the name will not be defined.  \n    * always check these to make sure they are not null before they are read. ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_FS_FILE_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_FS_FILE_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef Volume_Info_methods[] = {
    {NULL}  /* Sentinel */
};

static void Volume_Info_dealloc(pyVolume_Info *self) {
    if(self != NULL) {
        if(self->base != NULL) {
            if(self->base_is_python_object != 0) {
                Py_DecRef((PyObject*) self->base);
            } else if(self->base_is_internal != 0) {
                talloc_free(self->base);
            }
            self->base = NULL;
        }
        if(self->python_object2 != NULL) {
            Py_DecRef(self->python_object2);
            self->python_object2 = NULL;
        }
        if(self->python_object1 != NULL) {
            Py_DecRef(self->python_object1);
            self->python_object1 = NULL;
        }
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}

static void pyVolume_Info_initialize_proxies(pyVolume_Info *self, void *item) {
    Volume_Info target = (Volume_Info) item;

    // Maintain a reference to the python object in the C object extension
    ((Object) item)->extension = self;

    if(check_method_override((PyObject *) self, &Volume_Info_Type, "iternext")) {
        // Proxy the iternext method
        ((Volume_Info) target)->iternext = ProxiedVolume_Info_iternext;
    }
}

static int pyVolume_Info_init(pyVolume_Info *self, PyObject *args, PyObject *kwds)
{
    Volume_Info result_constructor = NULL;
    // DEBUG: local arg type: Wrapper
    Gen_wrapper wrapped_img UNUSED = NULL;
    Img_Info UNUSED img;
    // DEBUG: local arg type: EnumType
    int type =  TSK_VS_TYPE_DETECT;
    // DEBUG: local arg type: Integer64
int64_t  offset= 0;

    static char *kwlist[] = {"img","type","offset", NULL};

    if(!PyArg_ParseTupleAndKeywords(args, kwds, "O|iL", kwlist,&wrapped_img,&type,&offset)) {
        goto on_error;
    }
    self->python_object1 = NULL;
    self->python_object2 = NULL;
    // Initialise is used to keep a reference on the object?
    // If not called no longer valid warnings have been seen on Windows.
    self->initialise = (void *) pyVolume_Info_initialize_proxies;

    if(wrapped_img == NULL || (PyObject *)wrapped_img == Py_None) {
        img = NULL;
    } else if(!type_check((PyObject *)wrapped_img,&Img_Info_Type)) {
        PyErr_Format(PyExc_RuntimeError, "img must be derived from type Img_Info");
        goto on_error;
    } else if(wrapped_img->base == NULL) {
        PyErr_Format(PyExc_RuntimeError, "Img_Info instance is no longer valid (was it gc'ed?)");
        goto on_error;
    } else {
        img = wrapped_img->base;
        if(self->python_object1 == NULL) {
            self->python_object1 = (PyObject *) wrapped_img;
            Py_IncRef(self->python_object1);
        }
    }

// Check if the integer passed is actually a valid member of the enum
// Enum value of 0 is always allowed
if(type) { PyObject *py_type = PyLong_FromLong(type);
  PyObject *tmp = PyDict_GetItem(TSK_VS_TYPE_ENUM_rev_lookup, py_type);

  Py_DecRef(py_type);
  if(!tmp) {
    PyErr_Format(PyExc_RuntimeError, "value %lu is not valid for Enum TSK_VS_TYPE_ENUM of arg 'type'", (unsigned long)type);
    goto on_error;
  };
};
    ClearError();

    // Allocate a new instance
    self->base = (Volume_Info) alloc_Volume_Info();
    self->base_is_python_object = 0;
    self->base_is_internal = 1;
    self->object_is_proxied = 0;

    // Update the target by replacing its methods with proxies to call back into Python
    pyVolume_Info_initialize_proxies(self, self->base);

    // Now call the constructor
    Py_BEGIN_ALLOW_THREADS
    result_constructor = CONSTRUCT_INITIALIZE(Volume_Info, Volume_Info, Con, self->base, img, type, offset);
    Py_END_ALLOW_THREADS

    if(!CheckError(EZero)) {
        char *buffer = NULL;
        PyObject *exception = resolve_exception(&buffer);

        PyErr_Format(exception, "%s", buffer);
        ClearError();
        goto on_error;
    }
    if(result_constructor == NULL) {
        PyErr_Format(PyExc_IOError, "Unable to construct class Volume_Info");
        goto on_error;
    }

    return 0;

on_error:
    if(self->python_object2 != NULL) {
        Py_DecRef(self->python_object2);
        self->python_object2 = NULL;
    }
    if(self->python_object1 != NULL) {
        Py_DecRef(self->python_object1);
        self->python_object1 = NULL;
    }
    if(self->base != NULL) {
        talloc_free(self->base);
        self->base = NULL;
    }
    return -1;
}

static PyObject *pyVolume_Info_getattr(pyVolume_Info *self, PyObject *pyname) {
  char *name;
  // Try to hand it off to the python native handler first
  PyObject *result = PyObject_GenericGetAttr((PyObject*)self, pyname);

  if(result) return result;

  PyErr_Clear();
  // No - nothing interesting was found by python
  name = PyString_AsString(pyname);

  if(!self->base) {
      return PyErr_Format(PyExc_RuntimeError, "Wrapped object (Volume_Info.pyVolume_Info_getattr) no longer valid");
  }
  if(!name) {
      return NULL;
  }
    if(strcmp(name, "__members__") == 0) {
        PyObject *result = PyList_New(0);
        PyObject *tmp = NULL;
        PyMethodDef *i = NULL;

        if(result == NULL) goto on_error;

        tmp = PyString_FromString("info");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);
        tmp = PyString_FromString("current");
        PyList_Append(result, tmp);
        Py_DecRef(tmp);

        for(i=Volume_Info_methods; i->ml_name; i++) {
            tmp = PyString_FromString(i->ml_name);
            PyList_Append(result, tmp);
            Py_DecRef(tmp);
        }
        return result;
    }
    if(strcmp(name, "info") == 0) {
        PyObject *Py_result = NULL;
Gen_wrapper wrapped_info = NULL;


        PyErr_Clear();

        wrapped_info = (Gen_wrapper) PyObject_New(pyTSK_VS_INFO, &TSK_VS_INFO_Type);

        // Base is borrowed from another object.
        wrapped_info->base = (((Volume_Info) self->base)->info);
        wrapped_info->base_is_python_object = 0;
        wrapped_info->base_is_internal = 0;
        wrapped_info->python_object1 = NULL;
        wrapped_info->python_object2 = NULL;

        // A NULL object gets translated to a None
        if(wrapped_info->base == NULL) {
            Py_DecRef((PyObject *) wrapped_info);
            Py_IncRef(Py_None);
            wrapped_info = (Gen_wrapper) Py_None;
        }

Py_result = (PyObject *)wrapped_info;


        return Py_result;
    }
    if(strcmp(name, "current") == 0) {
        PyObject *Py_result = NULL;
int UNUSED current;


Py_BEGIN_ALLOW_THREADS
current = (((Volume_Info) self->base)->current);
Py_END_ALLOW_THREADS

PyErr_Clear();
Py_result = PyInt_FromLong(current);


        return Py_result;
    }


  return PyObject_GenericGetAttr((PyObject *)self, pyname);
on_error:
    return NULL;
}


/********************************************************
Autogenerated wrapper for function:
void Volume_Info.__iter__();
********************************************************/

static PyObject *pyVolume_Info___iter__(pyVolume_Info *self){
          ((Volume_Info)self->base)->__iter__((Volume_Info)self->base);
          return PyObject_SelfIter((PyObject *)self);
};
static void ProxiedVolume_Info___iter__(Volume_Info self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("__iter__");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in Volume_Info");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return;
}


/********************************************************
Autogenerated wrapper for function:
TSK_VS_PART_INFO * Volume_Info.iternext();
********************************************************/

static PyObject *pyVolume_Info_iternext(pyVolume_Info *self){
    PyObject *returned_result = NULL;
    PyObject *Py_result = NULL;
    // DEBUG: return type: PointerStructWrapper
    Gen_wrapper wrapped_func_return = NULL;
    // Make sure that we have something valid to wrap
    if(self->base == NULL) {
        return PyErr_Format(PyExc_RuntimeError, "Volume_Info object no longer valid");
    }

    // Precall preparations
    // Check the function is implemented
    {
        void *method = ((Volume_Info)self->base)->iternext;

        if(method == NULL || (void *) unimplemented == (void *) method) {
            PyErr_Format(PyExc_RuntimeError, "Volume_Info.iternext is not implemented");
            goto on_error;
        }

        // Make the call
        ClearError();

        PyErr_Clear();

        wrapped_func_return = (Gen_wrapper) PyObject_New(pyTSK_VS_PART_INFO, &TSK_VS_PART_INFO_Type);

        wrapped_func_return->base = ((Volume_Info) self->base)->iternext(((Volume_Info) self->base));
        wrapped_func_return->base_is_python_object = 0;
        wrapped_func_return->base_is_internal = 1;
        wrapped_func_return->python_object1 = NULL;
        wrapped_func_return->python_object2 = NULL;

        if(wrapped_func_return->base == NULL) {
             Py_DecRef((PyObject *) wrapped_func_return);
             return NULL;
        }
        // A NULL object gets translated to a None
        if(wrapped_func_return->base == NULL) {
            Py_DecRef((PyObject *) wrapped_func_return);
            Py_IncRef(Py_None);
            wrapped_func_return = (Gen_wrapper) Py_None;
        }
    };

    // Postcall preparations
    if(check_error()) goto on_error;

    // prepare results
Py_result = (PyObject *)wrapped_func_return;
    returned_result = Py_result;
    return returned_result;

on_error:
    return NULL;
};

static TSK_VS_PART_INFO * ProxiedVolume_Info_iternext(Volume_Info self) {
    PyGILState_STATE gstate;
    PyObject *Py_result = NULL;
    PyObject *method_name = NULL;
TSK_VS_PART_INFO * func_return = NULL;

    // Grab the GIL so we can do python stuff
    gstate = PyGILState_Ensure();

    method_name = PyString_FromString("iternext");

// Obtain python objects for all the args:
    if(((Object) self)->extension == NULL) {
        RaiseError(ERuntimeError, "No proxied object in Volume_Info");
        goto on_error;
    }

    // Now call the method
    PyErr_Clear();
    Py_result = PyObject_CallMethodObjArgs(((Object) self)->extension, method_name, NULL);

    /* Check for python errors */
    if(PyErr_Occurred()) {
        PyObject *exception_t = NULL;
        PyObject *exception = NULL;
        PyObject *tb = NULL;
        PyObject *str = NULL;
        char *str_c = NULL;
        char *error_str = NULL;
        int *error_type = (int *) aff4_get_current_error(&error_str);

        // Fetch the exception state and convert it to a string:
        PyErr_Fetch(&exception_t, &exception, &tb);

        str = PyObject_Repr(exception);
        str_c = PyString_AsString(str);

        if(str_c != NULL) {
            strncpy(error_str, str_c, BUFF_SIZE-1);
            error_str[BUFF_SIZE - 1] = 0;
            *error_type = ERuntimeError;
        }
        PyErr_Restore(exception_t, exception, tb);
        Py_DecRef(str);

        goto on_error;
    }

func_return = ((Gen_wrapper) Py_result)->base;
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return func_return;

on_error:
    if(Py_result != NULL) {
        Py_DecRef(Py_result);
    }
    Py_DecRef(method_name);

    PyGILState_Release(gstate);

    return NULL;
}


static int
Volume_Info_nonzero(pyVolume_Info *v)
{
        return v->base != 0;
};
static PyNumberMethods Volume_Info_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       Volume_Info_nonzero,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    0,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject Volume_Info_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.Volume_Info",
    /* tp_basicsize */
    sizeof(pyVolume_Info),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) Volume_Info_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &Volume_Info_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) 0,
    /* tp_getattro */
    (getattrofunc) pyVolume_Info_getattr,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "Volume_Info:  This object handles volumes.\n ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    0,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) pyVolume_Info___iter__,
    /* tp_iternext */
    (iternextfunc) pyVolume_Info_iternext,
    /* tp_methods */
    Volume_Info_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyVolume_Info_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

static PyMethodDef TSK_WALK_RET_ENUM_methods[] = {
    {NULL}  /* Sentinel */
};

static void TSK_WALK_RET_ENUM_dealloc(pyTSK_WALK_RET_ENUM *self) {
    if(self != NULL) {
        Py_DecRef(self->value);
        if(self->ob_type != NULL && self->ob_type->tp_free != NULL) {
            self->ob_type->tp_free((PyObject*) self);
        }
    }
}
static int pyTSK_WALK_RET_ENUM_init(pyTSK_WALK_RET_ENUM *self, PyObject *args, PyObject *kwds)
{
static char *kwlist[] = {"value", NULL};

if(!PyArg_ParseTupleAndKeywords(args, kwds, "O", kwlist, &self->value))
  goto on_error;

Py_IncRef(self->value);

  return 0;
on_error:
    return -1;
};

static PyObject *pyTSK_WALK_RET_ENUM___str__(pyTSK_WALK_RET_ENUM *self) {
  PyObject *result = PyDict_GetItem(TSK_WALK_RET_ENUM_rev_lookup, self->value);

  if(result) {
     Py_IncRef(result);
 } else {
     result = PyObject_Str(self->value);
 };

 return result;
};

static PyObject * TSK_WALK_RET_ENUM_eq(PyObject *me, PyObject *other, int op) {
    pyTSK_WALK_RET_ENUM *self = (pyTSK_WALK_RET_ENUM *)me;
    int other_int = PyLong_AsLong(other);
    int my_int;
    PyObject *result = Py_False;

    if(CheckError(EZero)) {
       my_int = PyLong_AsLong(self->value);
       switch(op) {
         case Py_EQ: result = my_int == other_int? Py_True: Py_False; break;
         case Py_NE: result = my_int != other_int? Py_True: Py_False; break;
         default:
            return Py_NotImplemented;
       };
    } else return NULL;

  ClearError();

  Py_IncRef(result);
  return result;
};


static PyObject *TSK_WALK_RET_ENUM_int(pyTSK_WALK_RET_ENUM *self) {
    Py_IncRef(self->value);
    return self->value;
};
static PyNumberMethods TSK_WALK_RET_ENUM_as_number = {
    (binaryfunc)    0,             /* nb_add */
    (binaryfunc)    0,             /* nb_subtract */
    (binaryfunc)    0,             /* nb_multiply */
                    0,             /* nb_divide */
                    0,             /* nb_remainder */
                    0,             /* nb_divmod */
                    0,             /* nb_power */
    (unaryfunc)     0,             /* nb_negative */
    (unaryfunc)     0,             /* tp_positive */
    (unaryfunc)     0,             /* tp_absolute */
    (inquiry)       0,   /* tp_nonzero */
    (unaryfunc)     0,             /* nb_invert */
                    0,             /* nb_lshift */
    (binaryfunc)    0,             /* nb_rshift */
                    0,             /* nb_and */
                    0,             /* nb_xor */
                    0,             /* nb_or */
                    0,             /* nb_coerce */
     (unaryfunc)    TSK_WALK_RET_ENUM_int,       /* nb_int */
                    0,             /* nb_long */
                    0,             /* nb_float */
                    0,             /* nb_oct */
                    0,             /* nb_hex */
                    0,             /* nb_inplace_add */
                    0,             /* nb_inplace_subtract */
                    0,             /* nb_inplace_multiply */
                    0,             /* nb_inplace_divide */
                    0,             /* nb_inplace_remainder */
                    0,             /* nb_inplace_power */
                    0,             /* nb_inplace_lshift */
                    0,             /* nb_inplace_rshift */
                    0,             /* nb_inplace_and */
                    0,             /* nb_inplace_xor */
                    0,             /* nb_inplace_or */
                    0,             /* nb_floor_divide */
                    0,             /* nb_true_divide */
                    0,             /* nb_inplace_floor_divide */
                    0,             /* nb_inplace_true_divide */
                    0,             /* nb_index */
};

static PyTypeObject TSK_WALK_RET_ENUM_Type = {
    PyObject_HEAD_INIT(NULL)
    /* ob_size */
    0,
    /* tp_name */
    "pytsk.TSK_WALK_RET_ENUM",
    /* tp_basicsize */
    sizeof(pyTSK_WALK_RET_ENUM),
    /* tp_itemsize */
    0,
    /* tp_dealloc */
    (destructor) TSK_WALK_RET_ENUM_dealloc,
    /* tp_print */
    0,
    /* tp_getattr */
    0,
    /* tp_setattr */
    0,
    /* tp_compare */
    0,
    /* tp_repr */
    0,
    /* tp_as_number */
    &TSK_WALK_RET_ENUM_as_number,
    /* tp_as_sequence */
    0,
    /* tp_as_mapping */
    0,
    /* tp_hash */
    0,
    /* tp_call */
    0,
    /* tp_str */
    (reprfunc) pyTSK_WALK_RET_ENUM___str__,
    /* tp_getattro */
    (getattrofunc) 0,
    /* tp_setattro */
    0,
    /* tp_as_buffer */
    0,
    /* tp_flags */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
    /* tp_doc */
    "TSK_WALK_RET_ENUM: ",
    /* tp_traverse */
    0,
    /* tp_clear */
    0,
    /* tp_richcompare */
    TSK_WALK_RET_ENUM_eq,
    /* tp_weaklistoffset */
    0,
    /* tp_iter */
    (getiterfunc) 0,
    /* tp_iternext */
    (iternextfunc) 0,
    /* tp_methods */
    TSK_WALK_RET_ENUM_methods,
    /* tp_members */
    0,
    /* tp_getset */
    0,
    /* tp_base */
    0,
    /* tp_dict */
    0,
    /* tp_descr_get */
    0,
    /* tp_descr_set */
    0,
    /* tp_dictoffset */
    0,
    /* tp_init */
    (initproc) pyTSK_WALK_RET_ENUM_init,
    /* tp_alloc */
    0,
    /* tp_new */
    0,
};

/* Retrieves the pytsk version
 * Returns a Python object if successful or NULL on error
 */
PyObject *pytsk_get_version(PyObject *self, PyObject *arguments) {
    const char *errors = NULL;
    return(PyUnicode_DecodeUTF8("20140506", (Py_ssize_t) 8, errors));
}

static PyMethodDef pytsk_methods[] = {
    { "get_version",
        (PyCFunction) pytsk_get_version,
        METH_NOARGS,
        "get_version() -> String\n"
        "\n"
        "Retrieves the version." },

    {NULL}  /* Sentinel */
};

/* Declarations for DLL import/export
 */
#ifndef PyMODINIT_FUNC
#define PyMODINIT_FUNC void
#endif

/* Initializes the pytsk module
 */
PyMODINIT_FUNC initpytsk(void) {
    PyGILState_STATE gstate;

    PyObject *m = NULL;
    PyObject *d = NULL;
    PyObject *tmp = NULL;

    /* create module */
    m = Py_InitModule3("pytsk", pytsk_methods, "pytsk module.");
    d = PyModule_GetDict(m);

    /* Make sure threads are enabled */
    PyEval_InitThreads();
    gstate = PyGILState_Ensure();

    g_module = m;

 TSK_FS_BLOCK_WALK_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_BLOCK_WALK_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_BLOCK_WALK_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_BLOCK_WALK_FLAG_ENUM", (PyObject *)&TSK_FS_BLOCK_WALK_FLAG_ENUM_Type);

 TSK_FS_FILE_READ_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_FILE_READ_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_FILE_READ_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_FILE_READ_FLAG_ENUM", (PyObject *)&TSK_FS_FILE_READ_FLAG_ENUM_Type);

 TSK_FS_BLKLS_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_BLKLS_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_BLKLS_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_BLKLS_FLAG_ENUM", (PyObject *)&TSK_FS_BLKLS_FLAG_ENUM_Type);

 TSK_RETVAL_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_RETVAL_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_RETVAL_ENUM_Type);
 PyModule_AddObject(m, "TSK_RETVAL_ENUM", (PyObject *)&TSK_RETVAL_ENUM_Type);

 TSK_FS_BLKCAT_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_BLKCAT_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_BLKCAT_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_BLKCAT_FLAG_ENUM", (PyObject *)&TSK_FS_BLKCAT_FLAG_ENUM_Type);

 Object_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&Object_Type) < 0)
     return;

 Py_IncRef((PyObject *)&Object_Type);
 PyModule_AddObject(m, "Object", (PyObject *)&Object_Type);
 Attribute_Type.tp_base = &Object_Type;
 Attribute_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&Attribute_Type) < 0)
     return;

 Py_IncRef((PyObject *)&Attribute_Type);
 PyModule_AddObject(m, "Attribute", (PyObject *)&Attribute_Type);

 TSK_FS_META_TYPE_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_META_TYPE_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_META_TYPE_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_META_TYPE_ENUM", (PyObject *)&TSK_FS_META_TYPE_ENUM_Type);

 TSK_FS_NAME_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_NAME_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_NAME_Type);
 PyModule_AddObject(m, "TSK_FS_NAME", (PyObject *)&TSK_FS_NAME_Type);

 TSK_FS_META_ATTR_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_META_ATTR_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_META_ATTR_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_META_ATTR_FLAG_ENUM", (PyObject *)&TSK_FS_META_ATTR_FLAG_ENUM_Type);

 TSK_FS_TYPE_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_TYPE_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_TYPE_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_TYPE_ENUM", (PyObject *)&TSK_FS_TYPE_ENUM_Type);

 TSK_FS_ILS_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_ILS_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_ILS_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_ILS_FLAG_ENUM", (PyObject *)&TSK_FS_ILS_FLAG_ENUM_Type);

 TSK_FS_META_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_META_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_META_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_META_FLAG_ENUM", (PyObject *)&TSK_FS_META_FLAG_ENUM_Type);

 TSK_FS_FFIND_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_FFIND_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_FFIND_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_FFIND_FLAG_ENUM", (PyObject *)&TSK_FS_FFIND_FLAG_ENUM_Type);

 TSK_FS_ATTR_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_ATTR_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_ATTR_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_ATTR_FLAG_ENUM", (PyObject *)&TSK_FS_ATTR_FLAG_ENUM_Type);

 TSK_FS_BLOCK_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_BLOCK_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_BLOCK_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_BLOCK_FLAG_ENUM", (PyObject *)&TSK_FS_BLOCK_FLAG_ENUM_Type);

 TSK_FS_ATTR_TYPE_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_ATTR_TYPE_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_ATTR_TYPE_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_ATTR_TYPE_ENUM", (PyObject *)&TSK_FS_ATTR_TYPE_ENUM_Type);

 TSK_VS_PART_INFO_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_VS_PART_INFO_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_VS_PART_INFO_Type);
 PyModule_AddObject(m, "TSK_VS_PART_INFO", (PyObject *)&TSK_VS_PART_INFO_Type);

 TSK_FS_NAME_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_NAME_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_NAME_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_NAME_FLAG_ENUM", (PyObject *)&TSK_FS_NAME_FLAG_ENUM_Type);

 TSK_FS_ATTR_RUN_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_ATTR_RUN_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_ATTR_RUN_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_ATTR_RUN_FLAG_ENUM", (PyObject *)&TSK_FS_ATTR_RUN_FLAG_ENUM_Type);

 TSK_VS_INFO_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_VS_INFO_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_VS_INFO_Type);
 PyModule_AddObject(m, "TSK_VS_INFO", (PyObject *)&TSK_VS_INFO_Type);

 Extended_TSK_IMG_INFO_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&Extended_TSK_IMG_INFO_Type) < 0)
     return;

 Py_IncRef((PyObject *)&Extended_TSK_IMG_INFO_Type);
 PyModule_AddObject(m, "Extended_TSK_IMG_INFO", (PyObject *)&Extended_TSK_IMG_INFO_Type);

 TSK_FS_META_MODE_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_META_MODE_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_META_MODE_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_META_MODE_ENUM", (PyObject *)&TSK_FS_META_MODE_ENUM_Type);

 TSK_IMG_TYPE_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_IMG_TYPE_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_IMG_TYPE_ENUM_Type);
 PyModule_AddObject(m, "TSK_IMG_TYPE_ENUM", (PyObject *)&TSK_IMG_TYPE_ENUM_Type);

 TSK_FS_META_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_META_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_META_Type);
 PyModule_AddObject(m, "TSK_FS_META", (PyObject *)&TSK_FS_META_Type);
 Img_Info_Type.tp_base = &Object_Type;
 Img_Info_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&Img_Info_Type) < 0)
     return;

 Py_IncRef((PyObject *)&Img_Info_Type);
 PyModule_AddObject(m, "Img_Info", (PyObject *)&Img_Info_Type);

 TSK_FS_DIR_WALK_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_DIR_WALK_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_DIR_WALK_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_DIR_WALK_FLAG_ENUM", (PyObject *)&TSK_FS_DIR_WALK_FLAG_ENUM_Type);

 TSK_ENDIAN_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_ENDIAN_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_ENDIAN_ENUM_Type);
 PyModule_AddObject(m, "TSK_ENDIAN_ENUM", (PyObject *)&TSK_ENDIAN_ENUM_Type);

 TSK_FS_DIR_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_DIR_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_DIR_Type);
 PyModule_AddObject(m, "TSK_FS_DIR", (PyObject *)&TSK_FS_DIR_Type);
 FS_Info_Type.tp_base = &Object_Type;
 FS_Info_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&FS_Info_Type) < 0)
     return;

 Py_IncRef((PyObject *)&FS_Info_Type);
 PyModule_AddObject(m, "FS_Info", (PyObject *)&FS_Info_Type);

 TSK_FS_BLKCALC_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_BLKCALC_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_BLKCALC_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_BLKCALC_FLAG_ENUM", (PyObject *)&TSK_FS_BLKCALC_FLAG_ENUM_Type);

 TSK_FS_NAME_TYPE_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_NAME_TYPE_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_NAME_TYPE_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_NAME_TYPE_ENUM", (PyObject *)&TSK_FS_NAME_TYPE_ENUM_Type);

 TSK_VS_TYPE_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_VS_TYPE_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_VS_TYPE_ENUM_Type);
 PyModule_AddObject(m, "TSK_VS_TYPE_ENUM", (PyObject *)&TSK_VS_TYPE_ENUM_Type);
 Directory_Type.tp_base = &Object_Type;
 Directory_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&Directory_Type) < 0)
     return;

 Py_IncRef((PyObject *)&Directory_Type);
 PyModule_AddObject(m, "Directory", (PyObject *)&Directory_Type);

 TSK_VS_PART_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_VS_PART_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_VS_PART_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_VS_PART_FLAG_ENUM", (PyObject *)&TSK_VS_PART_FLAG_ENUM_Type);

 TSK_FS_FLS_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_FLS_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_FLS_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_FLS_FLAG_ENUM", (PyObject *)&TSK_FS_FLS_FLAG_ENUM_Type);

 TSK_FS_INFO_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_INFO_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_INFO_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_INFO_FLAG_ENUM", (PyObject *)&TSK_FS_INFO_FLAG_ENUM_Type);

 TSK_FS_INFO_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_INFO_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_INFO_Type);
 PyModule_AddObject(m, "TSK_FS_INFO", (PyObject *)&TSK_FS_INFO_Type);

 TSK_FS_ATTR_RUN_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_ATTR_RUN_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_ATTR_RUN_Type);
 PyModule_AddObject(m, "TSK_FS_ATTR_RUN", (PyObject *)&TSK_FS_ATTR_RUN_Type);

 TSK_FS_IFIND_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_IFIND_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_IFIND_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_IFIND_FLAG_ENUM", (PyObject *)&TSK_FS_IFIND_FLAG_ENUM_Type);

 TSK_FS_FILE_WALK_FLAG_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_FILE_WALK_FLAG_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_FILE_WALK_FLAG_ENUM_Type);
 PyModule_AddObject(m, "TSK_FS_FILE_WALK_FLAG_ENUM", (PyObject *)&TSK_FS_FILE_WALK_FLAG_ENUM_Type);

 TSK_FS_BLOCK_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_BLOCK_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_BLOCK_Type);
 PyModule_AddObject(m, "TSK_FS_BLOCK", (PyObject *)&TSK_FS_BLOCK_Type);

 TSK_FS_ATTR_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_ATTR_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_ATTR_Type);
 PyModule_AddObject(m, "TSK_FS_ATTR", (PyObject *)&TSK_FS_ATTR_Type);
 File_Type.tp_base = &Object_Type;
 File_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&File_Type) < 0)
     return;

 Py_IncRef((PyObject *)&File_Type);
 PyModule_AddObject(m, "File", (PyObject *)&File_Type);

 TSK_FS_FILE_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_FS_FILE_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_FS_FILE_Type);
 PyModule_AddObject(m, "TSK_FS_FILE", (PyObject *)&TSK_FS_FILE_Type);
 Volume_Info_Type.tp_base = &Object_Type;
 Volume_Info_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&Volume_Info_Type) < 0)
     return;

 Py_IncRef((PyObject *)&Volume_Info_Type);
 PyModule_AddObject(m, "Volume_Info", (PyObject *)&Volume_Info_Type);

 TSK_WALK_RET_ENUM_Type.tp_new = PyType_GenericNew;
 if (PyType_Ready(&TSK_WALK_RET_ENUM_Type) < 0)
     return;

 Py_IncRef((PyObject *)&TSK_WALK_RET_ENUM_Type);
 PyModule_AddObject(m, "TSK_WALK_RET_ENUM", (PyObject *)&TSK_WALK_RET_ENUM_Type);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FLS_DOT); 

 PyDict_SetItemString(d, "TSK_FS_FLS_DOT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKCALC_DD); 

 PyDict_SetItemString(d, "TSK_FS_BLKCALC_DD", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_INFO_FLAG_HAVE_SEQ); 

 PyDict_SetItemString(d, "TSK_FS_INFO_FLAG_HAVE_SEQ", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_FFS1B); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_FFS1B", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_SOCK); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_SOCK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FLS_MAC); 

 PyDict_SetItemString(d, "TSK_FS_FLS_MAC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_AFF_AFD); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_AFF_AFD", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_LNK); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_LNK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_HFS_COMP_REC); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_HFS_COMP_REC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_BAD); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_BAD", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_UNSUPP); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_UNSUPP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_MAX); 

 PyDict_SetItemString(d, "TSK_ERR_FS_MAX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_WALK_FLAG_UNALLOC); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_WALK_FLAG_UNALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_SEC); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_SEC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUTO_NOTOPEN); 

 PyDict_SetItemString(d, "TSK_ERR_AUTO_NOTOPEN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FILE_WALK_FLAG_AONLY); 

 PyDict_SetItemString(d, "TSK_FS_FILE_WALK_FLAG_AONLY", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_FNAME); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_FNAME", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_ID_DEFAULT); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_ID_DEFAULT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_WRITE); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_WRITE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_IFIND_PAR_LONG); 

 PyDict_SetItemString(d, "TSK_FS_IFIND_PAR_LONG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_PART_INFO_TAG); 

 PyDict_SetItemString(d, "TSK_VS_PART_INFO_TAG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_UNIX_INDIR); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_UNIX_INDIR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_UNSUPP); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_UNSUPP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERROR_STRING_MAX_LENGTH); 

 PyDict_SetItemString(d, "TSK_ERROR_STRING_MAX_LENGTH", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_HFS_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_HFS_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_YAFFS2_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_YAFFS2_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_RECOVER); 

 PyDict_SetItemString(d, "TSK_ERR_FS_RECOVER", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_HFS_RSRC); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_HFS_RSRC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_UNALLOC); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_UNALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKCALC_BLKLS); 

 PyDict_SetItemString(d, "TSK_FS_BLKCALC_BLKLS", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_ATTRLIST); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_ATTRLIST", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FILE_WALK_FLAG_NONE); 

 PyDict_SetItemString(d, "TSK_FS_FILE_WALK_FLAG_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_TYPE_MAC); 

 PyDict_SetItemString(d, "TSK_VS_TYPE_MAC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_YAFFS2); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_YAFFS2", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_PART_FLAG_ALLOC); 

 PyDict_SetItemString(d, "TSK_VS_PART_FLAG_ALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_EXT_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_EXT_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_ENC); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_ENC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_TYPE_UNSUPP); 

 PyDict_SetItemString(d, "TSK_VS_TYPE_UNSUPP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_SEEK); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_SEEK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_MAGIC); 

 PyDict_SetItemString(d, "TSK_ERR_FS_MAGIC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_WRITE); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_WRITE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_WHT); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_WHT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_UNDEF); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_UNDEF", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_INFO_CACHE_NUM); 

 PyDict_SetItemString(d, "TSK_IMG_INFO_CACHE_NUM", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_FAT16); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_FAT16", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_VIRT); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_VIRT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VERSION_NUM); 

 PyDict_SetItemString(d, "TSK_VERSION_NUM", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_NONRES); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_NONRES", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_EWF_EWF); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_EWF_EWF", tmp);
 Py_DecRef(tmp);
 tmp = PyString_FromString((char *)PRIX64); 

 PyDict_SetItemString(d, "PRIX64", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_REG); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_REG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_WALK_CONT); 

 PyDict_SetItemString(d, "TSK_WALK_CONT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_MAX); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_MAX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_DIR_WALK_FLAG_ALLOC); 

 PyDict_SetItemString(d, "TSK_FS_DIR_WALK_FLAG_ALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUTO); 

 PyDict_SetItemString(d, "TSK_ERR_AUTO", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FLS_DIR); 

 PyDict_SetItemString(d, "TSK_FS_FLS_DIR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_CHR); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_CHR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUX_GENERIC); 

 PyDict_SetItemString(d, "TSK_ERR_AUX_GENERIC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKCAT_ASCII); 

 PyDict_SetItemString(d, "TSK_FS_BLKCAT_ASCII", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_FLAG_UNALLOC); 

 PyDict_SetItemString(d, "TSK_FS_META_FLAG_UNALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_SHAD); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_SHAD", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_PROC); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_PROC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_DIR_WALK_FLAG_NONE); 

 PyDict_SetItemString(d, "TSK_FS_DIR_WALK_FLAG_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_RAW); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_RAW", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS_READ); 

 PyDict_SetItemString(d, "TSK_ERR_VS_READ", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_FLAG_ORPHAN); 

 PyDict_SetItemString(d, "TSK_FS_META_FLAG_ORPHAN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_ARG); 

 PyDict_SetItemString(d, "TSK_ERR_FS_ARG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS); 

 PyDict_SetItemString(d, "TSK_ERR_VS", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_INFO_TAG); 

 PyDict_SetItemString(d, "TSK_FS_INFO_TAG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS_UNSUPTYPE); 

 PyDict_SetItemString(d, "TSK_ERR_VS_UNSUPTYPE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_FAT32); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_FAT32", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_UNDEF); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_UNDEF", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_PROP); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_PROP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUTO_UNICODE); 

 PyDict_SetItemString(d, "TSK_ERR_AUTO_UNICODE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_WALK_FLAG_ALLOC); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_WALK_FLAG_ALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_TYPE_SUN); 

 PyDict_SetItemString(d, "TSK_VS_TYPE_SUN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_ARG); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_ARG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_ARG); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_ARG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_UNSUPFUNC); 

 PyDict_SetItemString(d, "TSK_ERR_FS_UNSUPFUNC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS_UNKTYPE); 

 PyDict_SetItemString(d, "TSK_ERR_VS_UNKTYPE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FLS_HASH); 

 PyDict_SetItemString(d, "TSK_FS_FLS_HASH", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUX_MAX); 

 PyDict_SetItemString(d, "TSK_ERR_AUX_MAX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_RUN_FLAG_SPARSE); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_RUN_FLAG_SPARSE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_UNKTYPE); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_UNKTYPE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_BLK); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_BLK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_COMP); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_COMP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_READ); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_READ", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKLS_CAT); 

 PyDict_SetItemString(d, "TSK_FS_BLKLS_CAT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_INFO_FLAG_NONE); 

 PyDict_SetItemString(d, "TSK_FS_INFO_FLAG_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_DELETE); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_DELETE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_IWUSR); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_IWUSR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_WALK_ERROR); 

 PyDict_SetItemString(d, "TSK_WALK_ERROR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_AFF_ANY); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_AFF_ANY", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_IXUSR); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_IXUSR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_SHAD); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_SHAD", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_DIR_WALK_FLAG_UNALLOC); 

 PyDict_SetItemString(d, "TSK_FS_DIR_WALK_FLAG_UNALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_LOG); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_LOG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_AFF_AFM); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_AFF_AFM", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_READ_OFF); 

 PyDict_SetItemString(d, "TSK_ERR_FS_READ_OFF", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_FIFO); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_FIFO", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_SPARSE); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_SPARSE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_SOCK); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_SOCK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FFIND_ALL); 

 PyDict_SetItemString(d, "TSK_FS_FFIND_ALL", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_EXT2); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_EXT2", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_SWAP_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_SWAP_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_READ_OFF); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_READ_OFF", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TRUE); 

 PyDict_SetItemString(d, "TRUE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_UNSUPTYPE); 

 PyDict_SetItemString(d, "TSK_ERR_FS_UNSUPTYPE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_RAW_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_RAW_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_UNKTYPE); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_UNKTYPE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FILE_TAG); 

 PyDict_SetItemString(d, "TSK_FS_FILE_TAG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_PART_FLAG_ALL); 

 PyDict_SetItemString(d, "TSK_VS_PART_FLAG_ALL", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_EA); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_EA", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_DEFAULT); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_DEFAULT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NOT_FOUND); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NOT_FOUND", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_HFS_EXT_ATTR); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_HFS_EXT_ATTR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUTO_CORRUPT); 

 PyDict_SetItemString(d, "TSK_ERR_AUTO_CORRUPT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FLS_FILE); 

 PyDict_SetItemString(d, "TSK_FS_FLS_FILE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_TAG); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_TAG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS_BUF); 

 PyDict_SetItemString(d, "TSK_ERR_VS_BUF", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_CONT); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_CONT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FILE_READ_FLAG_SLACK); 

 PyDict_SetItemString(d, "TSK_FS_FILE_READ_FLAG_SLACK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_IWOTH); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_IWOTH", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_INFO_TAG); 

 PyDict_SetItemString(d, "TSK_IMG_INFO_TAG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_IXOTH); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_IXOTH", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKLS_LIST); 

 PyDict_SetItemString(d, "TSK_FS_BLKLS_LIST", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_SHA_DIGEST_LENGTH); 

 PyDict_SetItemString(d, "TSK_SHA_DIGEST_LENGTH", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_WALK_STOP); 

 PyDict_SetItemString(d, "TSK_WALK_STOP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_UNSUPTYPE); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_UNSUPTYPE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_FIFO); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_FIFO", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_WALK_FLAG_AONLY); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_WALK_FLAG_AONLY", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_SYMLNK); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_SYMLNK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS_MAX); 

 PyDict_SetItemString(d, "TSK_ERR_VS_MAX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_ALLOC); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_ALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_INODE_COR); 

 PyDict_SetItemString(d, "TSK_ERR_FS_INODE_COR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_DIR_WALK_FLAG_NOORPHAN); 

 PyDict_SetItemString(d, "TSK_FS_DIR_WALK_FLAG_NOORPHAN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_RAW_SING); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_RAW_SING", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_COMP); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_COMP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) FALSE); 

 PyDict_SetItemString(d, "FALSE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_HFS_DEFAULT); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_HFS_DEFAULT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_INFO_FS_ID_LEN); 

 PyDict_SetItemString(d, "TSK_FS_INFO_FS_ID_LEN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_RAW); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_RAW", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_UNKTYPE); 

 PyDict_SetItemString(d, "TSK_ERR_FS_UNKTYPE", tmp);
 Py_DecRef(tmp);
 tmp = PyString_FromString((char *)TSK_VERSION_STR); 

 PyDict_SetItemString(d, "TSK_VERSION_STR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_RECOVERY); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_RECOVERY", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TAG); 

 PyDict_SetItemString(d, "TSK_FS_META_TAG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_BLK_NUM); 

 PyDict_SetItemString(d, "TSK_ERR_FS_BLK_NUM", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_LIT_ENDIAN); 

 PyDict_SetItemString(d, "TSK_LIT_ENDIAN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ILS_LINK); 

 PyDict_SetItemString(d, "TSK_FS_ILS_LINK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_IROTH); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_IROTH", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_OPEN); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_OPEN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_FFS2); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_FFS2", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKLS_NONE); 

 PyDict_SetItemString(d, "TSK_FS_BLKLS_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_READDB); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_READDB", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUTO_MAX); 

 PyDict_SetItemString(d, "TSK_ERR_AUTO_MAX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_INODE_NUM); 

 PyDict_SetItemString(d, "TSK_ERR_FS_INODE_NUM", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_FLAG_ALLOC); 

 PyDict_SetItemString(d, "TSK_FS_NAME_FLAG_ALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_PART_FLAG_UNALLOC); 

 PyDict_SetItemString(d, "TSK_VS_PART_FLAG_UNALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_WHT); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_WHT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_FFS_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_FFS_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKLS_SLACK); 

 PyDict_SetItemString(d, "TSK_FS_BLKLS_SLACK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_FLAG_NONE); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_FLAG_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUX_MALLOC); 

 PyDict_SetItemString(d, "TSK_ERR_AUX_MALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_MAGIC); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_MAGIC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS); 

 PyDict_SetItemString(d, "TSK_ERR_FS", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_REG); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_REG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_PART_FLAG_META); 

 PyDict_SetItemString(d, "TSK_VS_PART_FLAG_META", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKCAT_STAT); 

 PyDict_SetItemString(d, "TSK_FS_BLKCAT_STAT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_FAT_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_FAT_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_BLK); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_BLK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_CORRUPT); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_CORRUPT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_BITMAP); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_BITMAP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ILS_MAC); 

 PyDict_SetItemString(d, "TSK_FS_ILS_MAC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_TYPE_DOS); 

 PyDict_SetItemString(d, "TSK_VS_TYPE_DOS", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_TYPE_DBFILLER); 

 PyDict_SetItemString(d, "TSK_VS_TYPE_DBFILLER", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_READ); 

 PyDict_SetItemString(d, "TSK_ERR_FS_READ", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_IDXROOT); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_IDXROOT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_DIR); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_DIR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_EXT3); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_EXT3", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG); 

 PyDict_SetItemString(d, "TSK_ERR_IMG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_OFFSET); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_OFFSET", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_IDXALLOC); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_IDXALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_NTFS); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_NTFS", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_FWALK); 

 PyDict_SetItemString(d, "TSK_ERR_FS_FWALK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_WALK_FLAG_META); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_WALK_FLAG_META", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_ISO9660_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_ISO9660_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_RUN_FLAG_NONE); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_RUN_FLAG_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_ISO9660); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_ISO9660", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ILS_UNLINK); 

 PyDict_SetItemString(d, "TSK_FS_ILS_UNLINK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_DIR_WALK_FLAG_RECURSE); 

 PyDict_SetItemString(d, "TSK_FS_DIR_WALK_FLAG_RECURSE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS_MAGIC); 

 PyDict_SetItemString(d, "TSK_ERR_VS_MAGIC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_FLAG_ALLOC); 

 PyDict_SetItemString(d, "TSK_FS_META_FLAG_ALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FLS_LONG); 

 PyDict_SetItemString(d, "TSK_FS_FLS_LONG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_BIG_ENDIAN); 

 PyDict_SetItemString(d, "TSK_BIG_ENDIAN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_ISGID); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_ISGID", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_AONLY); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_AONLY", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_REPARSE); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_REPARSE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FILE_READ_FLAG_NOID); 

 PyDict_SetItemString(d, "TSK_FS_FILE_READ_FLAG_NOID", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_RAW_SPLIT); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_RAW_SPLIT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUTO_DB); 

 PyDict_SetItemString(d, "TSK_ERR_AUTO_DB", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_FLAG_COMP); 

 PyDict_SetItemString(d, "TSK_FS_META_FLAG_COMP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FILE_WALK_FLAG_SLACK); 

 PyDict_SetItemString(d, "TSK_FS_FILE_WALK_FLAG_SLACK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_STAT); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_STAT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_FLAG_USED); 

 PyDict_SetItemString(d, "TSK_FS_META_FLAG_USED", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_PASSWD); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_PASSWD", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_EAINFO); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_EAINFO", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_INFO_TAG); 

 PyDict_SetItemString(d, "TSK_VS_INFO_TAG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_SI); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_SI", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FLS_FULL); 

 PyDict_SetItemString(d, "TSK_FS_FLS_FULL", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_VNAME); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_VNAME", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_ISUID); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_ISUID", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_UNSUPTYPE); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_UNSUPTYPE", tmp);
 Py_DecRef(tmp);
 tmp = PyString_FromString((char *)TSK_FS_ORPHAN_STR); 

 PyDict_SetItemString(d, "TSK_FS_ORPHAN_STR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FILE_WALK_FLAG_NOID); 

 PyDict_SetItemString(d, "TSK_FS_FILE_WALK_FLAG_NOID", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_CHR); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_CHR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_NOFILE); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_NOFILE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_MAX); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_MAX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_ISVTX); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_ISVTX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_IRUSR); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_IRUSR", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_TYPE_GPT); 

 PyDict_SetItemString(d, "TSK_VS_TYPE_GPT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_UNUSED); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_UNUSED", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKCAT_HTML); 

 PyDict_SetItemString(d, "TSK_FS_BLKCAT_HTML", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_FLAG_UNALLOC); 

 PyDict_SetItemString(d, "TSK_FS_NAME_FLAG_UNALLOC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_WALK_FLAG_CONT); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_WALK_FLAG_CONT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_DATA); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_DATA", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_NAME_LIST_NSIZE); 

 PyDict_SetItemString(d, "TSK_FS_META_NAME_LIST_NSIZE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_SWAP); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_SWAP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_INUSE); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_INUSE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_DETECT); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_RUN_FLAG_FILLER); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_RUN_FLAG_FILLER", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TAG); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TAG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_META); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_META", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FILE_READ_FLAG_NONE); 

 PyDict_SetItemString(d, "TSK_FS_FILE_READ_FLAG_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_CONVERT); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_CONVERT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_NTFS_DETECT); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_NTFS_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_TYPE_DETECT); 

 PyDict_SetItemString(d, "TSK_VS_TYPE_DETECT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_STR_MAX); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_STR_MAX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_IFIND_ALL); 

 PyDict_SetItemString(d, "TSK_FS_IFIND_ALL", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_CREATE); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_CREATE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_MISSING); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_MISSING", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_IXGRP); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_IXGRP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_DIR_TAG); 

 PyDict_SetItemString(d, "TSK_FS_DIR_TAG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB); 

 PyDict_SetItemString(d, "TSK_ERR_HDB", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKCAT_NONE); 

 PyDict_SetItemString(d, "TSK_FS_BLKCAT_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_IWGRP); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_IWGRP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_TYPE_AFF_AFF); 

 PyDict_SetItemString(d, "TSK_IMG_TYPE_AFF_AFF", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_HFS); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_HFS", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_MD5_DIGEST_LENGTH); 

 PyDict_SetItemString(d, "TSK_MD5_DIGEST_LENGTH", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_WRITE); 

 PyDict_SetItemString(d, "TSK_ERR_FS_WRITE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS_BLK_NUM); 

 PyDict_SetItemString(d, "TSK_ERR_VS_BLK_NUM", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_IFIND_NONE); 

 PyDict_SetItemString(d, "TSK_FS_IFIND_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ILS_OPEN); 

 PyDict_SetItemString(d, "TSK_FS_ILS_OPEN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_IMG_OPEN); 

 PyDict_SetItemString(d, "TSK_ERR_IMG_OPEN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS_ARG); 

 PyDict_SetItemString(d, "TSK_ERR_VS_ARG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_OBJID); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_OBJID", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_VIRT); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_VIRT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_VINFO); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_VINFO", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_HDB_READIDX); 

 PyDict_SetItemString(d, "TSK_ERR_HDB_READIDX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_ATTR_NOTFOUND); 

 PyDict_SetItemString(d, "TSK_ERR_FS_ATTR_NOTFOUND", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_EXT4); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_EXT4", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_LNK); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_LNK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_MASK); 

 PyDict_SetItemString(d, "TSK_ERR_MASK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKCALC_SLACK); 

 PyDict_SetItemString(d, "TSK_FS_BLKCALC_SLACK", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_NTFS_VVER); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_NTFS_VVER", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FILE_WALK_FLAG_NOSPARSE); 

 PyDict_SetItemString(d, "TSK_FS_FILE_WALK_FLAG_NOSPARSE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_RES); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_RES", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_VS_WALK_RNG); 

 PyDict_SetItemString(d, "TSK_ERR_VS_WALK_RNG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLKCAT_HEX); 

 PyDict_SetItemString(d, "TSK_FS_BLKCAT_HEX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_HFS_DATA); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_HFS_DATA", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_VS_TYPE_BSD); 

 PyDict_SetItemString(d, "TSK_VS_TYPE_BSD", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_WALK_FLAG_NONE); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_WALK_FLAG_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_IMG_INFO_CACHE_LEN); 

 PyDict_SetItemString(d, "TSK_IMG_INFO_CACHE_LEN", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_RAW); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_RAW", tmp);
 Py_DecRef(tmp);
 tmp = PyString_FromString((char *)PRIX32); 

 PyDict_SetItemString(d, "PRIX32", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_FLAG_UNUSED); 

 PyDict_SetItemString(d, "TSK_FS_META_FLAG_UNUSED", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_BLOCK_FLAG_SPARSE); 

 PyDict_SetItemString(d, "TSK_FS_BLOCK_FLAG_SPARSE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_INFO_FLAG_HAVE_NANOSEC); 

 PyDict_SetItemString(d, "TSK_FS_INFO_FLAG_HAVE_NANOSEC", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_WALK_RNG); 

 PyDict_SetItemString(d, "TSK_ERR_FS_WALK_RNG", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_TYPE_UNIX_EXTENT); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_TYPE_UNIX_EXTENT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_FLS_NONE); 

 PyDict_SetItemString(d, "TSK_FS_FLS_NONE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_FAT12); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_FAT12", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_NAME_TYPE_DIR); 

 PyDict_SetItemString(d, "TSK_FS_NAME_TYPE_DIR", tmp);
 Py_DecRef(tmp);
 tmp = PyString_FromString((char *)PRIX16); 

 PyDict_SetItemString(d, "PRIX16", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_TYPE_FFS1); 

 PyDict_SetItemString(d, "TSK_FS_TYPE_FFS1", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_UNICODE); 

 PyDict_SetItemString(d, "TSK_ERR_FS_UNICODE", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ATTR_RES); 

 PyDict_SetItemString(d, "TSK_FS_ATTR_RES", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_CORRUPT); 

 PyDict_SetItemString(d, "TSK_ERR_FS_CORRUPT", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_AUX); 

 PyDict_SetItemString(d, "TSK_ERR_AUX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_MODE_IRGRP); 

 PyDict_SetItemString(d, "TSK_FS_META_MODE_IRGRP", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_META_TYPE_STR_MAX); 

 PyDict_SetItemString(d, "TSK_FS_META_TYPE_STR_MAX", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_ERR_FS_GENFS); 

 PyDict_SetItemString(d, "TSK_ERR_FS_GENFS", tmp);
 Py_DecRef(tmp);
 tmp = PyLong_FromUnsignedLongLong((uint64_t) TSK_FS_ILS_NONE); 

 PyDict_SetItemString(d, "TSK_FS_ILS_NONE", tmp);
 Py_DecRef(tmp);
tsk_init();
talloc_set_log_fn((void (*)(const char *)) printf);
// DEBUG: talloc_enable_leak_report();
// DEBUG: talloc_enable_leak_report_full();

TSK_FS_BLOCK_WALK_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_BLOCK_WALK_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_BLOCK_WALK_FLAG_NONE);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_WALK_FLAG_NONE");
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_WALK_FLAG_ALLOC);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_WALK_FLAG_ALLOC");
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_WALK_FLAG_UNALLOC);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_WALK_FLAG_UNALLOC");
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_WALK_FLAG_CONT);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_WALK_FLAG_CONT");
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_WALK_FLAG_META);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_WALK_FLAG_META");
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_WALK_FLAG_AONLY);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_WALK_FLAG_AONLY");
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_FILE_READ_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_FILE_READ_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_FILE_READ_FLAG_NONE);
  tmp2 = PyString_FromString("TSK_FS_FILE_READ_FLAG_NONE");
  PyDict_SetItem(TSK_FS_FILE_READ_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FILE_READ_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FILE_READ_FLAG_SLACK);
  tmp2 = PyString_FromString("TSK_FS_FILE_READ_FLAG_SLACK");
  PyDict_SetItem(TSK_FS_FILE_READ_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FILE_READ_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FILE_READ_FLAG_NOID);
  tmp2 = PyString_FromString("TSK_FS_FILE_READ_FLAG_NOID");
  PyDict_SetItem(TSK_FS_FILE_READ_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FILE_READ_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_BLKLS_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_BLKLS_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_BLKLS_NONE);
  tmp2 = PyString_FromString("TSK_FS_BLKLS_NONE");
  PyDict_SetItem(TSK_FS_BLKLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLKLS_CAT);
  tmp2 = PyString_FromString("TSK_FS_BLKLS_CAT");
  PyDict_SetItem(TSK_FS_BLKLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLKLS_LIST);
  tmp2 = PyString_FromString("TSK_FS_BLKLS_LIST");
  PyDict_SetItem(TSK_FS_BLKLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLKLS_SLACK);
  tmp2 = PyString_FromString("TSK_FS_BLKLS_SLACK");
  PyDict_SetItem(TSK_FS_BLKLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_RETVAL_ENUM_Dict_lookup = PyDict_New();
TSK_RETVAL_ENUM_rev_lookup = PyDict_New();

TSK_FS_BLKCAT_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_BLKCAT_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_BLKCAT_NONE);
  tmp2 = PyString_FromString("TSK_FS_BLKCAT_NONE");
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLKCAT_HEX);
  tmp2 = PyString_FromString("TSK_FS_BLKCAT_HEX");
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLKCAT_ASCII);
  tmp2 = PyString_FromString("TSK_FS_BLKCAT_ASCII");
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLKCAT_HTML);
  tmp2 = PyString_FromString("TSK_FS_BLKCAT_HTML");
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLKCAT_STAT);
  tmp2 = PyString_FromString("TSK_FS_BLKCAT_STAT");
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKCAT_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};
python_wrappers[TOTAL_CLASSES].class_ref = (Object)&__Attribute;
python_wrappers[TOTAL_CLASSES].python_type = &Attribute_Type;
python_wrappers[TOTAL_CLASSES].initialize_proxies = (void (*)(Gen_wrapper, void *)) &pyAttribute_initialize_proxies;
TOTAL_CLASSES++;

TSK_FS_META_TYPE_ENUM_Dict_lookup = PyDict_New();
TSK_FS_META_TYPE_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_META_TYPE_UNDEF);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_UNDEF");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_REG);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_REG");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_DIR);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_DIR");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_FIFO);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_FIFO");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_CHR);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_CHR");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_BLK);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_BLK");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_LNK);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_LNK");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_SHAD);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_SHAD");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_SOCK);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_SOCK");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_WHT);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_WHT");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_TYPE_VIRT);
  tmp2 = PyString_FromString("TSK_FS_META_TYPE_VIRT");
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_META_ATTR_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_META_ATTR_FLAG_ENUM_rev_lookup = PyDict_New();

TSK_FS_TYPE_ENUM_Dict_lookup = PyDict_New();
TSK_FS_TYPE_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_TYPE_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_NTFS);
  tmp2 = PyString_FromString("TSK_FS_TYPE_NTFS");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_NTFS_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_NTFS_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_FAT12);
  tmp2 = PyString_FromString("TSK_FS_TYPE_FAT12");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_FAT16);
  tmp2 = PyString_FromString("TSK_FS_TYPE_FAT16");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_FAT32);
  tmp2 = PyString_FromString("TSK_FS_TYPE_FAT32");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_FAT_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_FAT_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_FFS1);
  tmp2 = PyString_FromString("TSK_FS_TYPE_FFS1");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_FFS1B);
  tmp2 = PyString_FromString("TSK_FS_TYPE_FFS1B");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_FFS2);
  tmp2 = PyString_FromString("TSK_FS_TYPE_FFS2");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_FFS_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_FFS_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_EXT2);
  tmp2 = PyString_FromString("TSK_FS_TYPE_EXT2");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_EXT3);
  tmp2 = PyString_FromString("TSK_FS_TYPE_EXT3");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_EXT_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_EXT_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_SWAP);
  tmp2 = PyString_FromString("TSK_FS_TYPE_SWAP");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_SWAP_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_SWAP_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_RAW);
  tmp2 = PyString_FromString("TSK_FS_TYPE_RAW");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_RAW_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_RAW_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_ISO9660);
  tmp2 = PyString_FromString("TSK_FS_TYPE_ISO9660");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_ISO9660_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_ISO9660_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_HFS);
  tmp2 = PyString_FromString("TSK_FS_TYPE_HFS");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_HFS_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_HFS_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_EXT4);
  tmp2 = PyString_FromString("TSK_FS_TYPE_EXT4");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_YAFFS2);
  tmp2 = PyString_FromString("TSK_FS_TYPE_YAFFS2");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_YAFFS2_DETECT);
  tmp2 = PyString_FromString("TSK_FS_TYPE_YAFFS2_DETECT");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_TYPE_UNSUPP);
  tmp2 = PyString_FromString("TSK_FS_TYPE_UNSUPP");
  PyDict_SetItem(TSK_FS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_ILS_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_ILS_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_ILS_NONE);
  tmp2 = PyString_FromString("TSK_FS_ILS_NONE");
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ILS_OPEN);
  tmp2 = PyString_FromString("TSK_FS_ILS_OPEN");
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ILS_MAC);
  tmp2 = PyString_FromString("TSK_FS_ILS_MAC");
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ILS_LINK);
  tmp2 = PyString_FromString("TSK_FS_ILS_LINK");
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ILS_UNLINK);
  tmp2 = PyString_FromString("TSK_FS_ILS_UNLINK");
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ILS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_META_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_META_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_META_FLAG_ALLOC);
  tmp2 = PyString_FromString("TSK_FS_META_FLAG_ALLOC");
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_FLAG_UNALLOC);
  tmp2 = PyString_FromString("TSK_FS_META_FLAG_UNALLOC");
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_FLAG_USED);
  tmp2 = PyString_FromString("TSK_FS_META_FLAG_USED");
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_FLAG_UNUSED);
  tmp2 = PyString_FromString("TSK_FS_META_FLAG_UNUSED");
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_FLAG_COMP);
  tmp2 = PyString_FromString("TSK_FS_META_FLAG_COMP");
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_FLAG_ORPHAN);
  tmp2 = PyString_FromString("TSK_FS_META_FLAG_ORPHAN");
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_FFIND_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_FFIND_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_FFIND_ALL);
  tmp2 = PyString_FromString("TSK_FS_FFIND_ALL");
  PyDict_SetItem(TSK_FS_FFIND_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FFIND_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_ATTR_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_ATTR_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_ATTR_FLAG_NONE);
  tmp2 = PyString_FromString("TSK_FS_ATTR_FLAG_NONE");
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_INUSE);
  tmp2 = PyString_FromString("TSK_FS_ATTR_INUSE");
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_NONRES);
  tmp2 = PyString_FromString("TSK_FS_ATTR_NONRES");
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_RES);
  tmp2 = PyString_FromString("TSK_FS_ATTR_RES");
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_ENC);
  tmp2 = PyString_FromString("TSK_FS_ATTR_ENC");
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_COMP);
  tmp2 = PyString_FromString("TSK_FS_ATTR_COMP");
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_SPARSE);
  tmp2 = PyString_FromString("TSK_FS_ATTR_SPARSE");
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_RECOVERY);
  tmp2 = PyString_FromString("TSK_FS_ATTR_RECOVERY");
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_BLOCK_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_UNUSED);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_UNUSED");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_ALLOC);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_ALLOC");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_UNALLOC);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_UNALLOC");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_CONT);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_CONT");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_META);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_META");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_BAD);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_BAD");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_RAW);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_RAW");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_SPARSE);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_SPARSE");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_COMP);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_COMP");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_RES);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_RES");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLOCK_FLAG_AONLY);
  tmp2 = PyString_FromString("TSK_FS_BLOCK_FLAG_AONLY");
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLOCK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_ATTR_TYPE_ENUM_Dict_lookup = PyDict_New();
TSK_FS_ATTR_TYPE_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NOT_FOUND);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NOT_FOUND");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_DEFAULT);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_DEFAULT");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_SI);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_SI");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_ATTRLIST);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_ATTRLIST");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_FNAME);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_FNAME");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_VVER);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_VVER");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_OBJID);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_OBJID");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_SEC);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_SEC");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_VNAME);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_VNAME");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_VINFO);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_VINFO");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_DATA);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_DATA");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_IDXROOT);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_IDXROOT");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_IDXALLOC);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_IDXALLOC");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_BITMAP);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_BITMAP");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_SYMLNK);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_SYMLNK");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_REPARSE);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_REPARSE");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_EAINFO);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_EAINFO");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_EA);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_EA");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_PROP);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_PROP");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_NTFS_LOG);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_NTFS_LOG");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_UNIX_INDIR);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_UNIX_INDIR");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_UNIX_EXTENT);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_UNIX_EXTENT");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_HFS_DEFAULT);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_HFS_DEFAULT");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_HFS_DATA);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_HFS_DATA");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_HFS_RSRC);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_HFS_RSRC");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_HFS_EXT_ATTR);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_HFS_EXT_ATTR");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_TYPE_HFS_COMP_REC);
  tmp2 = PyString_FromString("TSK_FS_ATTR_TYPE_HFS_COMP_REC");
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_NAME_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_NAME_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_NAME_FLAG_ALLOC);
  tmp2 = PyString_FromString("TSK_FS_NAME_FLAG_ALLOC");
  PyDict_SetItem(TSK_FS_NAME_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_FLAG_UNALLOC);
  tmp2 = PyString_FromString("TSK_FS_NAME_FLAG_UNALLOC");
  PyDict_SetItem(TSK_FS_NAME_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};
python_wrappers[TOTAL_CLASSES].class_ref = (Object)&__Object;
python_wrappers[TOTAL_CLASSES].python_type = &Object_Type;
TOTAL_CLASSES++;

TSK_FS_ATTR_RUN_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_ATTR_RUN_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_ATTR_RUN_FLAG_NONE);
  tmp2 = PyString_FromString("TSK_FS_ATTR_RUN_FLAG_NONE");
  PyDict_SetItem(TSK_FS_ATTR_RUN_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_RUN_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_RUN_FLAG_FILLER);
  tmp2 = PyString_FromString("TSK_FS_ATTR_RUN_FLAG_FILLER");
  PyDict_SetItem(TSK_FS_ATTR_RUN_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_RUN_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_ATTR_RUN_FLAG_SPARSE);
  tmp2 = PyString_FromString("TSK_FS_ATTR_RUN_FLAG_SPARSE");
  PyDict_SetItem(TSK_FS_ATTR_RUN_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_ATTR_RUN_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_META_MODE_ENUM_Dict_lookup = PyDict_New();
TSK_FS_META_MODE_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_META_MODE_ISUID);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_ISUID");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_ISGID);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_ISGID");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_ISVTX);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_ISVTX");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_IRUSR);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_IRUSR");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_IWUSR);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_IWUSR");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_IXUSR);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_IXUSR");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_IRGRP);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_IRGRP");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_IWGRP);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_IWGRP");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_IXGRP);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_IXGRP");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_IROTH);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_IROTH");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_IWOTH);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_IWOTH");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_META_MODE_IXOTH);
  tmp2 = PyString_FromString("TSK_FS_META_MODE_IXOTH");
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_META_MODE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_IMG_TYPE_ENUM_Dict_lookup = PyDict_New();
TSK_IMG_TYPE_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_IMG_TYPE_DETECT);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_DETECT");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_IMG_TYPE_RAW);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_RAW");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_IMG_TYPE_RAW_SING);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_RAW_SING");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_IMG_TYPE_RAW_SPLIT);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_RAW_SPLIT");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_IMG_TYPE_AFF_AFF);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_AFF_AFF");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_IMG_TYPE_AFF_AFD);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_AFF_AFD");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_IMG_TYPE_AFF_AFM);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_AFF_AFM");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_IMG_TYPE_AFF_ANY);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_AFF_ANY");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_IMG_TYPE_EWF_EWF);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_EWF_EWF");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_IMG_TYPE_UNSUPP);
  tmp2 = PyString_FromString("TSK_IMG_TYPE_UNSUPP");
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_IMG_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};
python_wrappers[TOTAL_CLASSES].class_ref = (Object)&__Img_Info;
python_wrappers[TOTAL_CLASSES].python_type = &Img_Info_Type;
python_wrappers[TOTAL_CLASSES].initialize_proxies = (void (*)(Gen_wrapper, void *)) &pyImg_Info_initialize_proxies;
TOTAL_CLASSES++;

TSK_FS_DIR_WALK_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_DIR_WALK_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_DIR_WALK_FLAG_NONE);
  tmp2 = PyString_FromString("TSK_FS_DIR_WALK_FLAG_NONE");
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_DIR_WALK_FLAG_ALLOC);
  tmp2 = PyString_FromString("TSK_FS_DIR_WALK_FLAG_ALLOC");
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_DIR_WALK_FLAG_UNALLOC);
  tmp2 = PyString_FromString("TSK_FS_DIR_WALK_FLAG_UNALLOC");
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_DIR_WALK_FLAG_RECURSE);
  tmp2 = PyString_FromString("TSK_FS_DIR_WALK_FLAG_RECURSE");
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_DIR_WALK_FLAG_NOORPHAN);
  tmp2 = PyString_FromString("TSK_FS_DIR_WALK_FLAG_NOORPHAN");
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_DIR_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_ENDIAN_ENUM_Dict_lookup = PyDict_New();
TSK_ENDIAN_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_LIT_ENDIAN);
  tmp2 = PyString_FromString("TSK_LIT_ENDIAN");
  PyDict_SetItem(TSK_ENDIAN_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_ENDIAN_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_BIG_ENDIAN);
  tmp2 = PyString_FromString("TSK_BIG_ENDIAN");
  PyDict_SetItem(TSK_ENDIAN_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_ENDIAN_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};
python_wrappers[TOTAL_CLASSES].class_ref = (Object)&__FS_Info;
python_wrappers[TOTAL_CLASSES].python_type = &FS_Info_Type;
python_wrappers[TOTAL_CLASSES].initialize_proxies = (void (*)(Gen_wrapper, void *)) &pyFS_Info_initialize_proxies;
TOTAL_CLASSES++;

TSK_FS_BLKCALC_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_BLKCALC_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_BLKCALC_DD);
  tmp2 = PyString_FromString("TSK_FS_BLKCALC_DD");
  PyDict_SetItem(TSK_FS_BLKCALC_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKCALC_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLKCALC_BLKLS);
  tmp2 = PyString_FromString("TSK_FS_BLKCALC_BLKLS");
  PyDict_SetItem(TSK_FS_BLKCALC_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKCALC_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_BLKCALC_SLACK);
  tmp2 = PyString_FromString("TSK_FS_BLKCALC_SLACK");
  PyDict_SetItem(TSK_FS_BLKCALC_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_BLKCALC_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_NAME_TYPE_ENUM_Dict_lookup = PyDict_New();
TSK_FS_NAME_TYPE_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_UNDEF);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_UNDEF");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_FIFO);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_FIFO");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_CHR);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_CHR");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_DIR);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_DIR");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_BLK);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_BLK");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_REG);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_REG");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_LNK);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_LNK");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_SOCK);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_SOCK");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_SHAD);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_SHAD");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_WHT);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_WHT");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_NAME_TYPE_VIRT);
  tmp2 = PyString_FromString("TSK_FS_NAME_TYPE_VIRT");
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_NAME_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_VS_TYPE_ENUM_Dict_lookup = PyDict_New();
TSK_VS_TYPE_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_VS_TYPE_DETECT);
  tmp2 = PyString_FromString("TSK_VS_TYPE_DETECT");
  PyDict_SetItem(TSK_VS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_TYPE_DOS);
  tmp2 = PyString_FromString("TSK_VS_TYPE_DOS");
  PyDict_SetItem(TSK_VS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_TYPE_BSD);
  tmp2 = PyString_FromString("TSK_VS_TYPE_BSD");
  PyDict_SetItem(TSK_VS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_TYPE_SUN);
  tmp2 = PyString_FromString("TSK_VS_TYPE_SUN");
  PyDict_SetItem(TSK_VS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_TYPE_MAC);
  tmp2 = PyString_FromString("TSK_VS_TYPE_MAC");
  PyDict_SetItem(TSK_VS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_TYPE_GPT);
  tmp2 = PyString_FromString("TSK_VS_TYPE_GPT");
  PyDict_SetItem(TSK_VS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_TYPE_DBFILLER);
  tmp2 = PyString_FromString("TSK_VS_TYPE_DBFILLER");
  PyDict_SetItem(TSK_VS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_TYPE_UNSUPP);
  tmp2 = PyString_FromString("TSK_VS_TYPE_UNSUPP");
  PyDict_SetItem(TSK_VS_TYPE_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_TYPE_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};
python_wrappers[TOTAL_CLASSES].class_ref = (Object)&__Directory;
python_wrappers[TOTAL_CLASSES].python_type = &Directory_Type;
python_wrappers[TOTAL_CLASSES].initialize_proxies = (void (*)(Gen_wrapper, void *)) &pyDirectory_initialize_proxies;
TOTAL_CLASSES++;

TSK_VS_PART_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_VS_PART_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_VS_PART_FLAG_ALLOC);
  tmp2 = PyString_FromString("TSK_VS_PART_FLAG_ALLOC");
  PyDict_SetItem(TSK_VS_PART_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_PART_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_PART_FLAG_UNALLOC);
  tmp2 = PyString_FromString("TSK_VS_PART_FLAG_UNALLOC");
  PyDict_SetItem(TSK_VS_PART_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_PART_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_PART_FLAG_META);
  tmp2 = PyString_FromString("TSK_VS_PART_FLAG_META");
  PyDict_SetItem(TSK_VS_PART_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_PART_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_VS_PART_FLAG_ALL);
  tmp2 = PyString_FromString("TSK_VS_PART_FLAG_ALL");
  PyDict_SetItem(TSK_VS_PART_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_VS_PART_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_FLS_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_FLS_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_FLS_NONE);
  tmp2 = PyString_FromString("TSK_FS_FLS_NONE");
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FLS_DOT);
  tmp2 = PyString_FromString("TSK_FS_FLS_DOT");
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FLS_LONG);
  tmp2 = PyString_FromString("TSK_FS_FLS_LONG");
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FLS_FILE);
  tmp2 = PyString_FromString("TSK_FS_FLS_FILE");
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FLS_DIR);
  tmp2 = PyString_FromString("TSK_FS_FLS_DIR");
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FLS_FULL);
  tmp2 = PyString_FromString("TSK_FS_FLS_FULL");
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FLS_MAC);
  tmp2 = PyString_FromString("TSK_FS_FLS_MAC");
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FLS_HASH);
  tmp2 = PyString_FromString("TSK_FS_FLS_HASH");
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FLS_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_INFO_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_INFO_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_INFO_FLAG_NONE);
  tmp2 = PyString_FromString("TSK_FS_INFO_FLAG_NONE");
  PyDict_SetItem(TSK_FS_INFO_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_INFO_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_INFO_FLAG_HAVE_SEQ);
  tmp2 = PyString_FromString("TSK_FS_INFO_FLAG_HAVE_SEQ");
  PyDict_SetItem(TSK_FS_INFO_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_INFO_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_INFO_FLAG_HAVE_NANOSEC);
  tmp2 = PyString_FromString("TSK_FS_INFO_FLAG_HAVE_NANOSEC");
  PyDict_SetItem(TSK_FS_INFO_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_INFO_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_IFIND_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_IFIND_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_IFIND_NONE);
  tmp2 = PyString_FromString("TSK_FS_IFIND_NONE");
  PyDict_SetItem(TSK_FS_IFIND_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_IFIND_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_IFIND_ALL);
  tmp2 = PyString_FromString("TSK_FS_IFIND_ALL");
  PyDict_SetItem(TSK_FS_IFIND_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_IFIND_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_IFIND_PAR_LONG);
  tmp2 = PyString_FromString("TSK_FS_IFIND_PAR_LONG");
  PyDict_SetItem(TSK_FS_IFIND_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_IFIND_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

TSK_FS_FILE_WALK_FLAG_ENUM_Dict_lookup = PyDict_New();
TSK_FS_FILE_WALK_FLAG_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_FS_FILE_WALK_FLAG_NONE);
  tmp2 = PyString_FromString("TSK_FS_FILE_WALK_FLAG_NONE");
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FILE_WALK_FLAG_SLACK);
  tmp2 = PyString_FromString("TSK_FS_FILE_WALK_FLAG_SLACK");
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FILE_WALK_FLAG_NOID);
  tmp2 = PyString_FromString("TSK_FS_FILE_WALK_FLAG_NOID");
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FILE_WALK_FLAG_AONLY);
  tmp2 = PyString_FromString("TSK_FS_FILE_WALK_FLAG_AONLY");
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_FS_FILE_WALK_FLAG_NOSPARSE);
  tmp2 = PyString_FromString("TSK_FS_FILE_WALK_FLAG_NOSPARSE");
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_FS_FILE_WALK_FLAG_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};
python_wrappers[TOTAL_CLASSES].class_ref = (Object)&__File;
python_wrappers[TOTAL_CLASSES].python_type = &File_Type;
python_wrappers[TOTAL_CLASSES].initialize_proxies = (void (*)(Gen_wrapper, void *)) &pyFile_initialize_proxies;
TOTAL_CLASSES++;
python_wrappers[TOTAL_CLASSES].class_ref = (Object)&__Volume_Info;
python_wrappers[TOTAL_CLASSES].python_type = &Volume_Info_Type;
python_wrappers[TOTAL_CLASSES].initialize_proxies = (void (*)(Gen_wrapper, void *)) &pyVolume_Info_initialize_proxies;
TOTAL_CLASSES++;

TSK_WALK_RET_ENUM_Dict_lookup = PyDict_New();
TSK_WALK_RET_ENUM_rev_lookup = PyDict_New();
{ PyObject *tmp, *tmp2;
 tmp = PyLong_FromLong(TSK_WALK_CONT);
  tmp2 = PyString_FromString("TSK_WALK_CONT");
  PyDict_SetItem(TSK_WALK_RET_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_WALK_RET_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_WALK_STOP);
  tmp2 = PyString_FromString("TSK_WALK_STOP");
  PyDict_SetItem(TSK_WALK_RET_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_WALK_RET_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

 tmp = PyLong_FromLong(TSK_WALK_ERROR);
  tmp2 = PyString_FromString("TSK_WALK_ERROR");
  PyDict_SetItem(TSK_WALK_RET_ENUM_Dict_lookup, tmp2, tmp);
  PyDict_SetItem(TSK_WALK_RET_ENUM_rev_lookup, tmp, tmp2);
  Py_DecRef(tmp);
  Py_DecRef(tmp2);

};

 PyGILState_Release(gstate);
};
