import unittest
import Tkinter
import ttk

import support

class StyleTest(unittest.TestCase):

    style = ttk.Style()

    def test_configure(self):
        style = self.style
        style.configure('TButton', background='yellow')
        self.failUnlessEqual(style.configure('TButton', 'background'),
            style.configure('TButton', '-background'))
        self.failUnlessEqual(style.configure('TButton', 'background'),
            'yellow')
        self.failUnless(isinstance(style.configure('TButton'), dict))


    def test_map(self):
        style = self.style
        style.map('TButton', background=[('active', 'background', 'blue')])
        self.failUnlessEqual(style.map('TButton', 'background'),
            style.map('TButton', '-background'))
        self.failUnlessEqual(style.map('TButton', 'background'),
            [('active', 'background', 'blue')])
        self.failUnless(isinstance(style.map('TButton'), dict))


    def test_lookup(self):
        style = self.style
        style.configure('TButton', background='yellow')
        style.map('TButton', background=[('active', 'background', 'blue')])

        self.failUnlessEqual(style.lookup('TButton', 'background'),
            style.lookup('TButton', '-background'))
        self.failUnlessEqual(style.lookup('TButton', 'background'), 'yellow')
        self.failUnlessEqual(style.lookup('TButton', 'background',
            ['active', 'background']), 'blue')
        self.failUnlessEqual(style.lookup('TButton', 'optionnotdefined',
            default='iknewit'), 'iknewit')


    def test_layout(self):
        style = self.style
        self.failUnlessRaises(Tkinter.TclError, style.layout, 'NotALayout')
        tv_style = style.layout('Treeview')

        # "erase" Treeview layout
        style.layout('Treeview', '')
        self.failUnlessEqual(style.layout('Treeview'),
            [('null', {'sticky': 'nswe'})]
        )

        # restore layout
        style.layout('Treeview', tv_style)
        self.failUnlessEqual(style.layout('Treeview'), tv_style)

        # should return a list
        self.failUnless(isinstance(style.layout('TButton'), list))

        # correct layout, but "option" doesn't exist as option
        self.failUnlessRaises(Tkinter.TclError, style.layout, 'Treeview',
            [('name', {'option': 'inexistant'})])


    def test_theme_use(self):
        self.failUnlessRaises(Tkinter.TclError, self.style.theme_use,
            'nonexistingname')

        curr_theme = self.style.theme_use()
        new_theme = None
        for theme in self.style.theme_names():
            if theme != curr_theme:
                new_theme = theme
                self.style.theme_use(theme)
                break
        else:
            # just one theme available, can't go on with tests
            return

        self.failIf(curr_theme == new_theme)
        self.failIf(new_theme != self.style.theme_use())

        self.style.theme_use(curr_theme)


def test_main():
    support.run(StyleTest)

if __name__ == "__main__":
    test_main()
