#
# Unit Tests for pyutilib.autotest
#
#

import os
import sys
from os.path import abspath, dirname
sys.path.insert(0, dirname(dirname(abspath(__file__)))+os.sep+".."+os.sep+"..")
currdir = dirname(abspath(__file__))+os.sep
bindir = dirname(abspath(sys.executable))+os.sep

import pyutilib.th as unittest
from pyutilib.misc import setup_redirect, reset_redirect
import pyutilib.autotest
import pyutilib.subprocess

try:
    import yaml
    yaml_available=True
except ImportError:
    yaml_available=False

def filter(str):
    return 'currdir' in str or \
           'Ran' in str

def filter_t1(str):
    return 'options' in str or \
           'Options' in str or \
           'usage' in str or \
           'Usage' in str


class Test(pyutilib.th.TestCase):

    def setUp(self):
        if not yaml_available:
            self.skipTest("Skiping tests because YAML is not available")

    def driver(self, *args):
        tmp = ['autotest']
        tmp += list(args)
        pyutilib.autotest.run(tmp)

    def test1(self):
        """run --help"""
        setup_redirect(currdir+'test1.out')
        self.driver('--help')
        reset_redirect()
        self.failUnlessFileEqualsBaseline(currdir+'test1.out', currdir+'test1.txt', filter=filter_t1)

    def test2(self):
        """run --help-suites example1.yml"""
        setup_redirect(currdir+'test2.out')
        self.driver('--help-suites',currdir+'example1.yml')
        reset_redirect()
        self.failUnlessFileEqualsBaseline(currdir+'test2.out', currdir+'test2.txt')

    def test3(self):
        """run --help-categories example1.yml"""
        setup_redirect(currdir+'test3.out')
        self.driver('--help-categories',currdir+'example1.yml')
        reset_redirect()
        self.failUnlessFileEqualsBaseline(currdir+'test3.out', currdir+'test3.txt')

    def test4(self):
        """run --help-tests suite1 example1.yml"""
        setup_redirect(currdir+'test4.out')
        self.driver('--help-tests','suite1',currdir+'example1.yml')
        reset_redirect()
        self.failUnlessFileEqualsBaseline(currdir+'test4.out', currdir+'test4.txt')

    def test5(self):
        """run example1.yml"""
        pyutilib.subprocess.run(bindir+'pyutilib_test_driver '+currdir+'example1.yml', outfile=currdir+'test5.out')
        self.failUnlessFileEqualsBaseline(currdir+'test5.out', currdir+'test5.txt', filter=filter)

    def test6(self):
        """run --cat smoke --cat suite1 example1.yml"""
        pyutilib.subprocess.run(bindir+'pyutilib_test_driver --cat smoke --cat suite1 '+currdir+'example1.yml', outfile=currdir+'test6.out')
        self.failUnlessFileEqualsBaseline(currdir+'test6.out', currdir+'test6.txt', filter=filter)

    def Xtest6(self):
        """run test1.txt"""
        pyutilib.subprocess.run(bindir+'pyutilib_test_driver '+currdir+'test1.txt', outfile=currdir+'test6.out')
        self.failUnlessFileEqualsBaseline(currdir+'test6.out', currdir+'test6.txt')

if __name__ == "__main__":
    unittest.main()
