#  _________________________________________________________________________
#
#  PyUtilib: A Python utility library.
#  Copyright (c) 2008 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  _________________________________________________________________________
#

def configure(installer):
    installer.description = """This script manages the installation of Coopr Python packages into a virtual Python installation."""
    installer.default_dirname = 'coopr'
    #
    # Add repositories
    #
    installer.add_repository('virtualenv', pypi='virtualenv' )
    installer.add_repository('nose', pypi='nose' )
    installer.add_repository('pyutilib', pyname='PyUtilib', root='https://software.sandia.gov/svn/public/pyutilib', dev=True)
    installer.add_repository('coopr', pyname='Coopr', root='https://software.sandia.gov/svn/public/coopr', dev=True)
    #
    # Add auxdirs
    #
    installer.add_auxdir('coopr', 'examples', '/examples')
    installer.add_auxdir('coopr', 'util', '/util')
    installer.add_auxdir('coopr', 'doc', '/doc/pub')
    installer.add_auxdir('coopr', 'test', '/test')
    #
    # Add cmd scripts, which need to be customized
    # for a local installation.
    #
    installer.add_dos_cmd('pyomo.cmd')
    installer.add_dos_cmd('pysos.cmd')
    #
    # Provide the contents of the README.txt file
    #
    installer.README="""
#
# Installation generated by the coopr_install script.
#
# This directory is managed with virtualenv, which creates a
# virtual Python installation.  If the 'bin' directory is put in
# user's PATH environment, then the bin/python command can be used to
# employ Coopr packges and scripts without further installation.
#
# Directories:
#   admin      Administrative data for maintaining this distribution
#   bin        Scripts and executables
#   doc        Documentation and tutorials
#   examples   Examples
#   include    Python header files
#   lib        Python libraries and installed packages
#   etc        Math programming model files used for optimization
#   src        Python packages whose source files can be
#              modified and used directly within this virtual Python
#              installation.
#   Scripts    Python bin directory (used on MS Windows)
#   test       Test directory
#   util       Utility scripts (including coopr_install)
#
""" 
    return installer

