
__all__ = ['ExecutableResource']

import resource
import os.path
import pyutilib.services

class ExecutableResource(resource.Resource):

    def __init__(self, name=None):
        resource.Resource.__init__(self)
        self.register(name)

    def register(self, name):
        self.filename=name
        if name is None:
            self.name = "Executable"+self.id
        else:
            self.name = "Executable_"+os.path.basename(name)
        pyutilib.services.register_executable(name)

    def abs_path(self):
        return pyutilib.services.registered_executable(self.filename)

    def available(self):
        return not self.path() is None

