#  _________________________________________________________________________
#
#  PyUtilib: A Python utility library.
#  Copyright (c) 2008 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  _________________________________________________________________________

__all__ = ['TaskPlugin', 'TaskFactory']

import task
from pyutilib.component.core import *


class IWorkflowTask(Interface):
    pass


TaskFactory = CreatePluginFactory(IWorkflowTask)


class TaskPlugin(Plugin, task.Task):

    implements(IWorkflowTask)

    def __init__(self, *args, **kwds):
        Plugin.__init__(self, *args, **kwds)
        task.Task.__init__(self, *args, **kwds)


class Selection_Task(TaskPlugin):

    alias('workflow.selection')

    def __init__(self, *args, **kwds):
        TaskPlugin.__init__(self, *args, **kwds)
        #
        self.inputs.declare('index')
        self.inputs.declare('data')
        #
        self.outputs.declare('selection')

    def execute(self, *args, **kwds):
        print self.inputs
        print self.outputs
        self.selection = self.data[self.index]

