
import os
import sys
from os.path import abspath, dirname
sys.path.insert(0, dirname(dirname(abspath(__file__)))+os.sep+".."+os.sep+"..")
currdir = dirname(abspath(__file__))+os.sep

import pyutilib.th as unittest
import pyutilib.workflow
from difflib import unified_diff

is_python24or25 = False
if sys.version_info[0:2] < (2, 6):
    is_python24or25 = True

class TaskA(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('x')
        self.inputs.declare('y')
        self.outputs.declare('z')

    def execute(self):
        self.z = self.x + self.y


class TaskAA1(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('x', action='append')
        self.outputs.declare('z')

    def execute(self):
        self.z = sum(self.x)


class TaskAA2(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('x', action='map')
        self.outputs.declare('z')

    def execute(self):
        self.z = sum(self.x.keys())


class TaskB(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('a')
        self.inputs.declare('i')
        self.outputs.declare('b')

    def execute(self):
        self.b = 100*self.i+2*self.a


class TaskAAA(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('a', optional=True)
        self.outputs.declare('a',self.inputs.a)

    def execute(self):
        pass


class TaskBB(TaskB):

    def __init__(self, *args, **kwds):
        TaskB.__init__(self, *args, **kwds)

    def _create_parser(self):
        pyutilib.workflow.Task._create_parser(self)
        self.parser.add_option("--a",dest="a", type='int')
        self.parser.add_option("--i",dest="i", type='int')


class TaskC(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('i')
        self.outputs.declare('o')

    def execute(self):
        self.o = 10*self.i


class TaskCC(TaskC):

    def __init__(self, *args, **kwds):
        TaskC.__init__(self, *args, **kwds)

    def _create_parser(self):
        pyutilib.workflow.Task._create_parser(self)
        self.parser.add_option("--i",dest="i", type='int')


class TaskD(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('i')
        self.outputs.declare('o')
        self.outputs.declare('z')

    def execute(self):
        self.o = 10*self.i
        self.z = -999


class TaskE(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('I')
        self.outputs.declare('O')

    def execute(self):
        self.O = self.I


class Test(unittest.TestCase):

    def test1(self):
        pyutilib.workflow.reset_id_counter()
        # Define tasks
        A = TaskA()
        B = TaskB()
        C = TaskC()
        # Establish connections
        A.inputs.x = B.outputs.b
        A.inputs.y = C.outputs.o
        # Create workflow
        w = pyutilib.workflow.Workflow()
        w.add(A)
        w.add(A)  # This is redundant, but it double-checks the logic for adding tasks
        #
        # Print workflow
        #
        ##print "..."
        self.failUnlessEqual(str(w),\
"""Workflow:
Task5 prev: [] next: [2, 3] resources: []
Task2 prev: [5] next: [1] resources: []
Task3 prev: [5] next: [1] resources: []
Task1 prev: [2, 3] next: [6] resources: []
Task6 prev: [1] next: [] resources: []""")
        self.failUnlessEqual(w(i=3, a=2), {'z':334})

    def test1c(self):
        pyutilib.workflow.reset_id_counter()
        # Define tasks
        A = TaskA()
        E1 = TaskE()
        E2 = TaskE()
        C = TaskC()
        # Establish connections
        A.inputs.x = E1.outputs.O
        A.inputs.y = E2.outputs.O
        E1.inputs.I = C.outputs.o
        E2.inputs.I = C.outputs.o
        # Create workflow
        w = pyutilib.workflow.Workflow()
        w.add(A)
        #
        # Print workflow
        #
        ##print "..."
        self.failUnlessEqual(str(w),\
"""Workflow:
Task6 prev: [] next: [4] resources: []
Task4 prev: [6] next: [2, 3] resources: []
Task2 prev: [4] next: [1] resources: []
Task3 prev: [4] next: [1] resources: []
Task1 prev: [2, 3] next: [7] resources: []
Task7 prev: [1] next: [] resources: []""")
        self.failUnlessEqual(w(i=3), {'z':60})

    def test1b(self):
        pyutilib.workflow.reset_id_counter()
        # Define tasks
        A = TaskA()
        B = TaskB()
        C = TaskC()
        # Establish connections
        A.inputs.x = B.outputs.b
        A.inputs.y = C.outputs.o
        # Create workflow
        w = pyutilib.workflow.Workflow()
        w.add(A,loadall=False)
        self.failUnlessEqual(str(w),"Workflow:\nTask5 prev: [] next: [] resources: []")

    def test1a(self):
        pyutilib.workflow.reset_id_counter()
        # Create workflow
        w = pyutilib.workflow.Workflow()
        self.failUnlessEqual(str(w),"Workflow:\nTask2 prev: [] next: [] resources: []")
        w.add(pyutilib.workflow.task.NoTask)
        self.failUnlessEqual(str(w),"Workflow:\nTask2 prev: [] next: [] resources: []")

    @unittest.skipIf( is_python24or25, "There is a slight (space) formatting difference from pformat from Python2.6.  Skipping test.")
    def test2(self):
        """ Do we really want to be testing pformat output?  I think we might
        actually want to override __cmp__ in the workflow.Task code and instead
        use that. """
        pyutilib.workflow.reset_id_counter()
        A = TaskA(name="A")
        B = TaskB()
        A.inputs.x = B.outputs.b
        base = """{ 'A_TYPE': 'Task',
  'Id': 1,
  'Inputs': { 'A_TYPE': 'Port',
              'Mode': 'inputs',
              'Name': 'A-inputs',
              'Owner': 'A prev: [2] next: [] resources: []',
              'x': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [ 'DirectConnector: from=(2) to=(1)'],
                                      'Outputs': []},
                     'Name': 'x',
                     'Optional': 'False',
                     'Task': '1',
                     'Value': 'None'},
              'y': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [], 'Outputs': []},
                     'Name': 'y',
                     'Optional': 'False',
                     'Task': '1',
                     'Value': 'None'}},
  'Name': 'A',
  'Outputs': { 'A_TYPE': 'Port',
               'Mode': 'outputs',
               'Name': 'A-outputs',
               'Owner': 'A prev: [2] next: [] resources: []',
               'z': { 'A_TYPE': 'Port',
                      'Connections': { 'Inputs': [], 'Outputs': []},
                      'Name': 'z',
                      'Optional': 'False',
                      'Task': '1',
                      'Value': 'None'}}}"""
        self.failUnlessEqual(repr(A), base)

    @unittest.skipIf( is_python24or25, "There is a slight (space) formatting difference from pformat from Python2.6.  Skipping test.")
    def test3(self):
        """ Do we really want to be testing pformat output?  I think we might
        actually want to override __cmp__ in the workflow.Task code and instead
        use that. """
        pyutilib.workflow.reset_id_counter()
        A = TaskA()
        B = TaskB()
        A.inputs.x = B.outputs.b
        inputs_base = """{ 'A_TYPE': 'Port',
  'Mode': 'inputs',
  'Name': 'Task1-inputs',
  'Owner': 'Task1 prev: [2] next: [] resources: []',
  'x': { 'A_TYPE': 'Port',
         'Connections': { 'Inputs': ['DirectConnector: from=(2) to=(1)'],
                          'Outputs': []},
         'Name': 'x',
         'Optional': 'False',
         'Task': '1',
         'Value': 'None'},
  'y': { 'A_TYPE': 'Port',
         'Connections': { 'Inputs': [], 'Outputs': []},
         'Name': 'y',
         'Optional': 'False',
         'Task': '1',
         'Value': 'None'}}"""

        outputs_base = """{ 'A_TYPE': 'Port',
  'Mode': 'outputs',
  'Name': 'Task1-outputs',
  'Owner': 'Task1 prev: [2] next: [] resources: []',
  'z': { 'A_TYPE': 'Port',
         'Connections': { 'Inputs': [], 'Outputs': []},
         'Name': 'z',
         'Optional': 'False',
         'Task': '1',
         'Value': 'None'}}"""

        self.failUnlessEqual(str(A.inputs), inputs_base)
        self.failUnlessEqual(str(A.outputs), outputs_base)


    @unittest.skipIf( is_python24or25, "There is a slight (space) formatting difference from pformat from Python2.6.  Skipping test.")
    def test4(self):
        """ Do we really want to be testing pformat output?  I think we might
        actually want to override __cmp__ in the workflow.Task code and instead
        use that. """
        pyutilib.workflow.reset_id_counter()
        A = TaskA()
        A.inputs['x'] = 2
        base = """{ 'A_TYPE': 'Task',
  'Id': 1,
  'Inputs': { 'A_TYPE': 'Port',
              'Mode': 'inputs',
              'Name': 'Task1-inputs',
              'Owner': 'Task1 prev: [] next: [] resources: []',
              'x': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [], 'Outputs': []},
                     'Name': 'x',
                     'Optional': 'False',
                     'Task': '1',
                     'Value': '2'},
              'y': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [], 'Outputs': []},
                     'Name': 'y',
                     'Optional': 'False',
                     'Task': '1',
                     'Value': 'None'}},
  'Name': 'Task1',
  'Outputs': { 'A_TYPE': 'Port',
               'Mode': 'outputs',
               'Name': 'Task1-outputs',
               'Owner': 'Task1 prev: [] next: [] resources: []',
               'z': { 'A_TYPE': 'Port',
                      'Connections': { 'Inputs': [], 'Outputs': []},
                      'Name': 'z',
                      'Optional': 'False',
                      'Task': '1',
                      'Value': 'None'}}}"""

        self.failUnlessEqual(A.inputs['x'].get_value(), 2)
        self.failUnlessEqual(repr(A), base)

    def test5(self):
        pyutilib.workflow.reset_id_counter()
        # Define tasks
        A = TaskA()
        B = TaskB()
        C = TaskC()
        # Establish connections
        A.inputs.x = B.outputs.b
        A.inputs.y = C.outputs.o
        # Create workflow
        w = pyutilib.workflow.Workflow()
        w.add(A)
        w.set_options(['--i=3','--a=2'])
        try:
            w()
            self.fail("Expected TypeError because the inputs are not defined")
        except ValueError:
            pass

    def test5a(self):
        pyutilib.workflow.reset_id_counter()
        # Define tasks
        A = TaskA()
        B = TaskBB()
        C = TaskCC()
        # Establish connections
        A.inputs.x = B.outputs.b
        A.inputs.y = C.outputs.o
        # Create workflow
        w = pyutilib.workflow.Workflow()
        w.add(A)
        w.set_options(['--i=3','--a=2'])
        self.failUnlessEqual(w(), {'z':334})
        # This doesn't work, since we can't merge options that aren't
        # in groups.  The soln is to move to argparse, but I'll save that for later
        #w.print_help()


    @unittest.skipIf( is_python24or25, "There is a slight (space) formatting difference from pformat from Python2.6.  Skipping test.")
    def test5b(self):
        """ Do we really want to be testing pformat output?  I think we might
        actually want to override __cmp__ in the workflow.Task code and instead
        use that. """
        pyutilib.workflow.reset_id_counter()
        # Define tasks
        A = TaskA()
        B = TaskBB()
        C = TaskCC()
        # Establish connections
        A.inputs.x = B.outputs.b
        A.inputs.y = C.outputs.o
        # Create workflow
        w = pyutilib.workflow.Workflow()
        w.add(A)
        w.set_options(['--i=3','--a=2'])
        w()
        self.assertEqual(repr(w),"""Workflow:
{ 'A_TYPE': 'Task',
  'Id': 5,
  'Inputs': { 'A_TYPE': 'Port',
              'Mode': 'inputs',
              'Name': 'Task5-inputs',
              'Owner': 'Task5 prev: [] next: [2, 3] resources: []'},
  'Name': 'Task5',
  'Outputs': { 'A_TYPE': 'Port',
               'Mode': 'outputs',
               'Name': 'Task5-outputs',
               'Owner': 'Task5 prev: [] next: [2, 3] resources: []',
               'a': { 'A_TYPE': 'Port',
                      'Connections': { 'Inputs': [],
                                       'Outputs': [ 'DirectConnector: from=(5) to=(2)']},
                      'Name': 'a',
                      'Optional': 'False',
                      'Task': '5',
                      'Value': 'None'},
               'i': { 'A_TYPE': 'Port',
                      'Connections': { 'Inputs': [],
                                       'Outputs': [ 'DirectConnector: from=(5) to=(3)',
                                                    'DirectConnector: from=(5) to=(2)']},
                      'Name': 'i',
                      'Optional': 'False',
                      'Task': '5',
                      'Value': 'None'},
               'x': { 'A_TYPE': 'Port',
                      'Connections': { 'Inputs': [], 'Outputs': []},
                      'Name': 'x',
                      'Optional': 'False',
                      'Task': '5',
                      'Value': 'None'},
               'y': { 'A_TYPE': 'Port',
                      'Connections': { 'Inputs': [], 'Outputs': []},
                      'Name': 'y',
                      'Optional': 'False',
                      'Task': '5',
                      'Value': 'None'}}}
{ 'A_TYPE': 'Task',
  'Id': 2,
  'Inputs': { 'A_TYPE': 'Port',
              'Mode': 'inputs',
              'Name': 'Task2-inputs',
              'Owner': 'Task2 prev: [5] next: [1] resources: []',
              'a': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [ 'DirectConnector: from=(5) to=(2)'],
                                      'Outputs': []},
                     'Name': 'a',
                     'Optional': 'False',
                     'Task': '2',
                     'Value': '2'},
              'i': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [ 'DirectConnector: from=(5) to=(2)'],
                                      'Outputs': []},
                     'Name': 'i',
                     'Optional': 'False',
                     'Task': '2',
                     'Value': '3'}},
  'Name': 'Task2',
  'Outputs': { 'A_TYPE': 'Port',
               'Mode': 'outputs',
               'Name': 'Task2-outputs',
               'Owner': 'Task2 prev: [5] next: [1] resources: []',
               'b': { 'A_TYPE': 'Port',
                      'Connections': { 'Inputs': [],
                                       'Outputs': [ 'DirectConnector: from=(2) to=(1)']},
                      'Name': 'b',
                      'Optional': 'False',
                      'Task': '2',
                      'Value': '304'}}}
{ 'A_TYPE': 'Task',
  'Id': 3,
  'Inputs': { 'A_TYPE': 'Port',
              'Mode': 'inputs',
              'Name': 'Task3-inputs',
              'Owner': 'Task3 prev: [5] next: [1] resources: []',
              'i': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [ 'DirectConnector: from=(5) to=(3)'],
                                      'Outputs': []},
                     'Name': 'i',
                     'Optional': 'False',
                     'Task': '3',
                     'Value': '3'}},
  'Name': 'Task3',
  'Outputs': { 'A_TYPE': 'Port',
               'Mode': 'outputs',
               'Name': 'Task3-outputs',
               'Owner': 'Task3 prev: [5] next: [1] resources: []',
               'o': { 'A_TYPE': 'Port',
                      'Connections': { 'Inputs': [],
                                       'Outputs': [ 'DirectConnector: from=(3) to=(1)']},
                      'Name': 'o',
                      'Optional': 'False',
                      'Task': '3',
                      'Value': '30'}}}
{ 'A_TYPE': 'Task',
  'Id': 1,
  'Inputs': { 'A_TYPE': 'Port',
              'Mode': 'inputs',
              'Name': 'Task1-inputs',
              'Owner': 'Task1 prev: [2, 3] next: [6] resources: []',
              'x': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [ 'DirectConnector: from=(2) to=(1)'],
                                      'Outputs': []},
                     'Name': 'x',
                     'Optional': 'False',
                     'Task': '1',
                     'Value': '304'},
              'y': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [ 'DirectConnector: from=(3) to=(1)'],
                                      'Outputs': []},
                     'Name': 'y',
                     'Optional': 'False',
                     'Task': '1',
                     'Value': '30'}},
  'Name': 'Task1',
  'Outputs': { 'A_TYPE': 'Port',
               'Mode': 'outputs',
               'Name': 'Task1-outputs',
               'Owner': 'Task1 prev: [2, 3] next: [6] resources: []',
               'z': { 'A_TYPE': 'Port',
                      'Connections': { 'Inputs': [],
                                       'Outputs': [ 'DirectConnector: from=(1) to=(6)']},
                      'Name': 'z',
                      'Optional': 'False',
                      'Task': '1',
                      'Value': '334'}}}
{ 'A_TYPE': 'Task',
  'Id': 6,
  'Inputs': { 'A_TYPE': 'Port',
              'Mode': 'inputs',
              'Name': 'Task6-inputs',
              'Owner': 'Task6 prev: [1] next: [] resources: []',
              'z': { 'A_TYPE': 'Port',
                     'Connections': { 'Inputs': [ 'DirectConnector: from=(1) to=(6)'],
                                      'Outputs': []},
                     'Name': 'z',
                     'Optional': 'False',
                     'Task': '6',
                     'Value': '334'}},
  'Name': 'Task6',
  'Outputs': { 'A_TYPE': 'Port',
               'Mode': 'outputs',
               'Name': 'Task6-outputs',
               'Owner': 'Task6 prev: [1] next: [] resources: []'}}""")

    def test_error1(self):
        pyutilib.workflow.reset_id_counter()
        A = TaskA()
        try:
            A.inputs['inputs'] = 2
            self.fail("Expected ValueError because we're using the reserved 'inputs' attribute name")
        except TypeError:
            pass

    def test_error2(self):
        pyutilib.workflow.reset_id_counter()
        A = TaskA()
        try:
            print A.inputs._foo
            self.fail("Should have generated error for unknown attribute _foo")
        except AttributeError:
            pass

    def test_error3(self):
        pyutilib.workflow.reset_id_counter()
        # Define tasks
        A = TaskA()
        B = TaskB()
        D = TaskD()
        # Establish connections
        A.inputs.x = B.outputs.b
        A.inputs.y = D.outputs.o
        # Create workflow
        w = pyutilib.workflow.Workflow()
        try:
            w.add(A)
            self.fail("Expected ValueError because there are multiple outputs with the same name")
        except ValueError:
            pass

    def test_error4(self):
        pyutilib.workflow.reset_id_counter()
        # Define tasks
        A = TaskAA1()
        B = TaskAAA()
        C = TaskAAA()
        # Establish connections
        A.inputs.x = B.outputs.a
        A.inputs.x = C.outputs.a
        # Create workflow
        w = pyutilib.workflow.Workflow()
        w.add(A)
        try:
            w()
            self.fail("Expected ValueError because inputs are None")
        except ValueError:
            pass


    def test_error5(self):
        pyutilib.workflow.reset_id_counter()
        # Define tasks
        A = TaskAA2()
        B = TaskAAA()
        C = TaskAAA()
        # Establish connections
        A.inputs.x = B.outputs.a
        A.inputs.x = C.outputs.a
        # Create workflow
        w = pyutilib.workflow.Workflow()
        w.add(A)
        try:
            w()
            self.fail("Expected ValueError because inputs are None")
        except ValueError:
            pass


if __name__ == "__main__":
    unittest.main()
