import pyutilib.workflow
import os.path
currdir = os.path.dirname(os.path.abspath(__file__))+os.sep

# @ex:
class TaskH(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        """Constructor."""
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('dir')
        self.outputs.declare('list')
        self.add_resource(pyutilib.workflow.ExecutableResource('ls'))

    def execute(self):
        self.resource('ls').run(self.dir, logfile=currdir+'logfile')
        self.list = []
        for line in open(currdir+'logfile','r'):
            self.list.append( line.strip() )
        self.list.sort()

H = TaskH()
w = pyutilib.workflow.Workflow()
w.add(H)
print w(dir=currdir+'dummy')
# @:ex
