import pyutilib.workflow
import random

# @class:
class TaskD(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        """Constructor."""
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('x', action='append')
        self.outputs.declare('z')

    def execute(self):
        """Compute the sum of the inputs."""
        self.z = sum(self.x)
# @:class

# @usage:
class TaskE(pyutilib.workflow.Task):

    def __init__(self, *args, **kwds):
        """Constructor."""
        pyutilib.workflow.Task.__init__(self, *args, **kwds)
        self.inputs.declare('Y')
        self.outputs.declare('Z')

    def execute(self):
        """Compute the sum of the inputs."""
        self.Z = random.randint(1,self.Y)

random.seed(123809870128)
D = TaskD()
for i in range(100):
    E = TaskE()
    D.inputs.x = E.outputs.Z

w = pyutilib.workflow.Workflow()
w.add(D)
print w(Y=100)
# @:usage
