#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Oct 28 21:10:09 2014 by generateDS.py version 2.12e.
#
# Command line options:
#   ('-o', 'schema/vchs/ondemand/metering/meteringType.py')
#
# Command line arguments:
#   schema/vchs/ondemand/metering/metering.xsd
#
# Command line:
#   ./generateDS-2.12e/generateDS.py -o "schema/vchs/ondemand/metering/meteringType.py" schema/vchs/ondemand/metering/metering.xsd
#
# Current working directory (os.getcwd()):
#   vchs-api-cli-cli
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class BilledUsageType(GeneratedsSuper):
    """5.7 Applicable for billed usage only. Returns : entity details, bill
    duration, applicable currency, metric name, usage units, usage
    amount, rate per unit consumed and calculated total cost for a
    given bill month. 5.7always The billing month for billed usage
    in 'm' format i.e. One-digit month for months below 10.
    5.7always The billing year for billed usage in 'yyyy' format
    i.e. Four-digit year format. 5.7always The start time of billing
    month in ISO 8601 UTC format, e.g. 2014-02-13T10:00:00.000Z.
    Billed usage is collected from this time onwards. 5.7always The
    end time of billing month in ISO 8601 UTC format, e.g.
    2014-02-13T11:00:00.000Z. Billed usage is collected till this
    time."""
    subclass = None
    superclass = None
    def __init__(self, endTime=None, year=None, startTime=None, month=None, Entity=None):
        self.original_tagname_ = None
        self.endTime = _cast(None, endTime)
        self.year = _cast(int, year)
        self.startTime = _cast(None, startTime)
        self.month = _cast(int, month)
        if Entity is None:
            self.Entity = []
        else:
            self.Entity = Entity
    def factory(*args_, **kwargs_):
        if BilledUsageType.subclass:
            return BilledUsageType.subclass(*args_, **kwargs_)
        else:
            return BilledUsageType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Entity(self): return self.Entity
    def set_Entity(self, Entity): self.Entity = Entity
    def add_Entity(self, value): self.Entity.append(value)
    def insert_Entity_at(self, index, value): self.Entity.insert(index, value)
    def replace_Entity_at(self, index, value): self.Entity[index] = value
    def get_endTime(self): return self.endTime
    def set_endTime(self, endTime): self.endTime = endTime
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_startTime(self): return self.startTime
    def set_startTime(self, startTime): self.startTime = startTime
    def get_month(self): return self.month
    def set_month(self, month): self.month = month
    def hasContent_(self):
        if (
            self.Entity
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BilledUsageType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BilledUsageType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BilledUsageType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BilledUsageType'):
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            outfile.write(' endTime=%s' % (self.gds_format_string(quote_attrib(self.endTime).encode(ExternalEncoding), input_name='endTime'), ))
        if self.year is not None and 'year' not in already_processed:
            already_processed.add('year')
            outfile.write(' year="%s"' % self.gds_format_integer(self.year, input_name='year'))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            outfile.write(' startTime=%s' % (self.gds_format_string(quote_attrib(self.startTime).encode(ExternalEncoding), input_name='startTime'), ))
        if self.month is not None and 'month' not in already_processed:
            already_processed.add('month')
            outfile.write(' month="%s"' % self.gds_format_integer(self.month, input_name='month'))
    def exportChildren(self, outfile, level, namespace_='', name_='BilledUsageType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Entity_ in self.Entity:
            Entity_.export(outfile, level, namespace_, name_='Entity', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BilledUsageType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            showIndent(outfile, level)
            outfile.write('endTime="%s",\n' % (self.endTime,))
        if self.year is not None and 'year' not in already_processed:
            already_processed.add('year')
            showIndent(outfile, level)
            outfile.write('year=%d,\n' % (self.year,))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            showIndent(outfile, level)
            outfile.write('startTime="%s",\n' % (self.startTime,))
        if self.month is not None and 'month' not in already_processed:
            already_processed.add('month')
            showIndent(outfile, level)
            outfile.write('month=%d,\n' % (self.month,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Entity=[\n')
        level += 1
        for Entity_ in self.Entity:
            showIndent(outfile, level)
            outfile.write('model_.EntityType(\n')
            Entity_.exportLiteral(outfile, level, name_='EntityType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('endTime', node)
        if value is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            self.endTime = value
        value = find_attr_value_('year', node)
        if value is not None and 'year' not in already_processed:
            already_processed.add('year')
            try:
                self.year = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('startTime', node)
        if value is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            self.startTime = value
        value = find_attr_value_('month', node)
        if value is not None and 'month' not in already_processed:
            already_processed.add('month')
            try:
                self.month = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Entity':
            obj_ = EntityType.factory()
            obj_.build(child_)
            self.Entity.append(obj_)
            obj_.original_tagname_ = 'Entity'
# end class BilledUsageType


class BillableUsageType(GeneratedsSuper):
    """5.7 Applicable for current/unbilled usage only. Returns : entity
    details, applicable currency, metric name, usage units, usage
    amount, rate per unit consumed and calculated total cost. for a
    given date range (optional). 5.7always Start time for
    current/unbilled usage in ISO 8601 UTC format, e.g.
    2014-02-13T10:00:00.000Z; Usage is collected from this time
    onwards. 5.7always End time for current/unbilled usage in ISO
    8601 UTC format, e.g. 2014-02-13T11:00:00.000Z; Usage is
    collected till this time."""
    subclass = None
    superclass = None
    def __init__(self, endTime=None, startTime=None, Entity=None):
        self.original_tagname_ = None
        self.endTime = _cast(None, endTime)
        self.startTime = _cast(None, startTime)
        if Entity is None:
            self.Entity = []
        else:
            self.Entity = Entity
    def factory(*args_, **kwargs_):
        if BillableUsageType.subclass:
            return BillableUsageType.subclass(*args_, **kwargs_)
        else:
            return BillableUsageType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Entity(self): return self.Entity
    def set_Entity(self, Entity): self.Entity = Entity
    def add_Entity(self, value): self.Entity.append(value)
    def insert_Entity_at(self, index, value): self.Entity.insert(index, value)
    def replace_Entity_at(self, index, value): self.Entity[index] = value
    def get_endTime(self): return self.endTime
    def set_endTime(self, endTime): self.endTime = endTime
    def get_startTime(self): return self.startTime
    def set_startTime(self, startTime): self.startTime = startTime
    def hasContent_(self):
        if (
            self.Entity
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BillableUsageType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BillableUsageType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BillableUsageType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BillableUsageType'):
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            outfile.write(' endTime=%s' % (self.gds_format_string(quote_attrib(self.endTime).encode(ExternalEncoding), input_name='endTime'), ))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            outfile.write(' startTime=%s' % (self.gds_format_string(quote_attrib(self.startTime).encode(ExternalEncoding), input_name='startTime'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='BillableUsageType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Entity_ in self.Entity:
            Entity_.export(outfile, level, namespace_, name_='Entity', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BillableUsageType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            showIndent(outfile, level)
            outfile.write('endTime="%s",\n' % (self.endTime,))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            showIndent(outfile, level)
            outfile.write('startTime="%s",\n' % (self.startTime,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Entity=[\n')
        level += 1
        for Entity_ in self.Entity:
            showIndent(outfile, level)
            outfile.write('model_.EntityType(\n')
            Entity_.exportLiteral(outfile, level, name_='EntityType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('endTime', node)
        if value is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            self.endTime = value
        value = find_attr_value_('startTime', node)
        if value is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            self.startTime = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Entity':
            obj_ = EntityType.factory()
            obj_.build(child_)
            self.Entity.append(obj_)
            obj_.original_tagname_ = 'Entity'
# end class BillableUsageType


class EntityType(GeneratedsSuper):
    """5.7always Represents the billed/unbilled entity object. 5.7none The
    id of the entity. 5.7always The name of the entity. 5.7none The
    entity type e.g. vm, vdc or serviceInstance."""
    subclass = None
    superclass = None
    def __init__(self, entityType=None, id=None, name=None, BillableList=None):
        self.original_tagname_ = None
        self.entityType = _cast(None, entityType)
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.BillableList = BillableList
    def factory(*args_, **kwargs_):
        if EntityType.subclass:
            return EntityType.subclass(*args_, **kwargs_)
        else:
            return EntityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BillableList(self): return self.BillableList
    def set_BillableList(self, BillableList): self.BillableList = BillableList
    def get_entityType(self): return self.entityType
    def set_entityType(self, entityType): self.entityType = entityType
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            self.BillableList is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityType'):
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            outfile.write(' entityType=%s' % (self.gds_format_string(quote_attrib(self.entityType).encode(ExternalEncoding), input_name='entityType'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='EntityType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.BillableList is not None:
            self.BillableList.export(outfile, level, namespace_, name_='BillableList', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            showIndent(outfile, level)
            outfile.write('entityType="%s",\n' % (self.entityType,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.BillableList is not None:
            showIndent(outfile, level)
            outfile.write('BillableList=model_.BillableListType(\n')
            self.BillableList.exportLiteral(outfile, level, name_='BillableList')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('entityType', node)
        if value is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            self.entityType = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BillableList':
            obj_ = BillableListType.factory()
            obj_.build(child_)
            self.BillableList = obj_
            obj_.original_tagname_ = 'BillableList'
# end class EntityType


class BillableListType(GeneratedsSuper):
    """5.7always Contains metering data for different metrics."""
    subclass = None
    superclass = None
    def __init__(self, Billable=None):
        self.original_tagname_ = None
        if Billable is None:
            self.Billable = []
        else:
            self.Billable = Billable
    def factory(*args_, **kwargs_):
        if BillableListType.subclass:
            return BillableListType.subclass(*args_, **kwargs_)
        else:
            return BillableListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Billable(self): return self.Billable
    def set_Billable(self, Billable): self.Billable = Billable
    def add_Billable(self, value): self.Billable.append(value)
    def insert_Billable_at(self, index, value): self.Billable.insert(index, value)
    def replace_Billable_at(self, index, value): self.Billable[index] = value
    def hasContent_(self):
        if (
            self.Billable
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BillableListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BillableListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BillableListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BillableListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BillableListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Billable_ in self.Billable:
            Billable_.export(outfile, level, namespace_, name_='Billable', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BillableListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Billable=[\n')
        level += 1
        for Billable_ in self.Billable:
            showIndent(outfile, level)
            outfile.write('model_.BillableType(\n')
            Billable_.exportLiteral(outfile, level, name_='BillableType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Billable':
            obj_ = BillableType.factory()
            obj_.build(child_)
            self.Billable.append(obj_)
            obj_.original_tagname_ = 'Billable'
# end class BillableListType


class BillableType(GeneratedsSuper):
    """5.7always Contains metering data for a given metric."""
    subclass = None
    superclass = None
    def __init__(self, Name=None, Usage=None, Unit=None, Rate=None, Cost=None, Currency=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Usage = Usage
        self.Unit = Unit
        self.Rate = Rate
        self.Cost = Cost
        self.Currency = Currency
    def factory(*args_, **kwargs_):
        if BillableType.subclass:
            return BillableType.subclass(*args_, **kwargs_)
        else:
            return BillableType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Usage(self): return self.Usage
    def set_Usage(self, Usage): self.Usage = Usage
    def get_Unit(self): return self.Unit
    def set_Unit(self, Unit): self.Unit = Unit
    def get_Rate(self): return self.Rate
    def set_Rate(self, Rate): self.Rate = Rate
    def get_Cost(self): return self.Cost
    def set_Cost(self, Cost): self.Cost = Cost
    def get_Currency(self): return self.Currency
    def set_Currency(self, Currency): self.Currency = Currency
    def hasContent_(self):
        if (
            self.Name is not None or
            self.Usage is not None or
            self.Unit is not None or
            self.Rate is not None or
            self.Cost is not None or
            self.Currency is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BillableType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BillableType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BillableType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BillableType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BillableType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespace_, self.gds_format_string(quote_xml(self.Name).encode(ExternalEncoding), input_name='Name'), namespace_, eol_))
        if self.Usage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUsage>%s</%sUsage>%s' % (namespace_, self.gds_format_float(self.Usage, input_name='Usage'), namespace_, eol_))
        if self.Unit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUnit>%s</%sUnit>%s' % (namespace_, self.gds_format_string(quote_xml(self.Unit).encode(ExternalEncoding), input_name='Unit'), namespace_, eol_))
        if self.Rate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRate>%s</%sRate>%s' % (namespace_, self.gds_format_float(self.Rate, input_name='Rate'), namespace_, eol_))
        if self.Cost is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCost>%s</%sCost>%s' % (namespace_, self.gds_format_float(self.Cost, input_name='Cost'), namespace_, eol_))
        if self.Currency is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCurrency>%s</%sCurrency>%s' % (namespace_, self.gds_format_string(quote_xml(self.Currency).encode(ExternalEncoding), input_name='Currency'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BillableType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=%s,\n' % quote_python(self.Name).encode(ExternalEncoding))
        if self.Usage is not None:
            showIndent(outfile, level)
            outfile.write('Usage=%f,\n' % self.Usage)
        if self.Unit is not None:
            showIndent(outfile, level)
            outfile.write('Unit=%s,\n' % quote_python(self.Unit).encode(ExternalEncoding))
        if self.Rate is not None:
            showIndent(outfile, level)
            outfile.write('Rate=%f,\n' % self.Rate)
        if self.Cost is not None:
            showIndent(outfile, level)
            outfile.write('Cost=%f,\n' % self.Cost)
        if self.Currency is not None:
            showIndent(outfile, level)
            outfile.write('Currency=%s,\n' % quote_python(self.Currency).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Usage':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Usage')
            self.Usage = fval_
        elif nodeName_ == 'Unit':
            Unit_ = child_.text
            Unit_ = self.gds_validate_string(Unit_, node, 'Unit')
            self.Unit = Unit_
        elif nodeName_ == 'Rate':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Rate')
            self.Rate = fval_
        elif nodeName_ == 'Cost':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Cost')
            self.Cost = fval_
        elif nodeName_ == 'Currency':
            Currency_ = child_.text
            Currency_ = self.gds_validate_string(Currency_, node, 'Currency')
            self.Currency = Currency_
# end class BillableType


class BilledCostsType(GeneratedsSuper):
    """5.7 List cost items associated with service group for a given
    billing month. Cost items are shown only for months for which
    bill is generated. The following cost items are supported -
    Support Cost and Service Credit. 5.7always The billing month for
    billed cost. 5.7always The billing year for billed cost.
    5.7always The start time of billing month. 5.7always The end
    time of billing month."""
    subclass = None
    superclass = None
    def __init__(self, endTime=None, year=None, startTime=None, month=None, Cost=None, Currency=None):
        self.original_tagname_ = None
        self.endTime = _cast(None, endTime)
        self.year = _cast(int, year)
        self.startTime = _cast(None, startTime)
        self.month = _cast(int, month)
        if Cost is None:
            self.Cost = []
        else:
            self.Cost = Cost
        self.Currency = Currency
    def factory(*args_, **kwargs_):
        if BilledCostsType.subclass:
            return BilledCostsType.subclass(*args_, **kwargs_)
        else:
            return BilledCostsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Cost(self): return self.Cost
    def set_Cost(self, Cost): self.Cost = Cost
    def add_Cost(self, value): self.Cost.append(value)
    def insert_Cost_at(self, index, value): self.Cost.insert(index, value)
    def replace_Cost_at(self, index, value): self.Cost[index] = value
    def get_Currency(self): return self.Currency
    def set_Currency(self, Currency): self.Currency = Currency
    def get_endTime(self): return self.endTime
    def set_endTime(self, endTime): self.endTime = endTime
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_startTime(self): return self.startTime
    def set_startTime(self, startTime): self.startTime = startTime
    def get_month(self): return self.month
    def set_month(self, month): self.month = month
    def hasContent_(self):
        if (
            self.Cost or
            self.Currency is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BilledCostsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BilledCostsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BilledCostsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BilledCostsType'):
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            outfile.write(' endTime=%s' % (self.gds_format_string(quote_attrib(self.endTime).encode(ExternalEncoding), input_name='endTime'), ))
        if self.year is not None and 'year' not in already_processed:
            already_processed.add('year')
            outfile.write(' year="%s"' % self.gds_format_integer(self.year, input_name='year'))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            outfile.write(' startTime=%s' % (self.gds_format_string(quote_attrib(self.startTime).encode(ExternalEncoding), input_name='startTime'), ))
        if self.month is not None and 'month' not in already_processed:
            already_processed.add('month')
            outfile.write(' month="%s"' % self.gds_format_integer(self.month, input_name='month'))
    def exportChildren(self, outfile, level, namespace_='', name_='BilledCostsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Cost_ in self.Cost:
            Cost_.export(outfile, level, namespace_, name_='Cost', pretty_print=pretty_print)
        if self.Currency is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCurrency>%s</%sCurrency>%s' % (namespace_, self.gds_format_string(quote_xml(self.Currency).encode(ExternalEncoding), input_name='Currency'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BilledCostsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            showIndent(outfile, level)
            outfile.write('endTime="%s",\n' % (self.endTime,))
        if self.year is not None and 'year' not in already_processed:
            already_processed.add('year')
            showIndent(outfile, level)
            outfile.write('year=%d,\n' % (self.year,))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            showIndent(outfile, level)
            outfile.write('startTime="%s",\n' % (self.startTime,))
        if self.month is not None and 'month' not in already_processed:
            already_processed.add('month')
            showIndent(outfile, level)
            outfile.write('month=%d,\n' % (self.month,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Cost=[\n')
        level += 1
        for Cost_ in self.Cost:
            showIndent(outfile, level)
            outfile.write('model_.CostType(\n')
            Cost_.exportLiteral(outfile, level, name_='CostType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Currency is not None:
            showIndent(outfile, level)
            outfile.write('Currency=%s,\n' % quote_python(self.Currency).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('endTime', node)
        if value is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            self.endTime = value
        value = find_attr_value_('year', node)
        if value is not None and 'year' not in already_processed:
            already_processed.add('year')
            try:
                self.year = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('startTime', node)
        if value is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            self.startTime = value
        value = find_attr_value_('month', node)
        if value is not None and 'month' not in already_processed:
            already_processed.add('month')
            try:
                self.month = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Cost':
            obj_ = CostType.factory()
            obj_.build(child_)
            self.Cost.append(obj_)
            obj_.original_tagname_ = 'Cost'
        elif nodeName_ == 'Currency':
            Currency_ = child_.text
            Currency_ = self.gds_validate_string(Currency_, node, 'Currency')
            self.Currency = Currency_
# end class BilledCostsType


class BillableCostsType(GeneratedsSuper):
    """5.7 Represents current/unbilled value of cost items associated with
    the service-group. Only those cost items are listed which are
    available after last bill cut/generation date. The following
    cost items are supported - Support Cost and Service Credit."""
    subclass = None
    superclass = None
    def __init__(self, Cost=None, Currency=None, LastUpdateTime=None):
        self.original_tagname_ = None
        if Cost is None:
            self.Cost = []
        else:
            self.Cost = Cost
        self.Currency = Currency
        self.LastUpdateTime = LastUpdateTime
    def factory(*args_, **kwargs_):
        if BillableCostsType.subclass:
            return BillableCostsType.subclass(*args_, **kwargs_)
        else:
            return BillableCostsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Cost(self): return self.Cost
    def set_Cost(self, Cost): self.Cost = Cost
    def add_Cost(self, value): self.Cost.append(value)
    def insert_Cost_at(self, index, value): self.Cost.insert(index, value)
    def replace_Cost_at(self, index, value): self.Cost[index] = value
    def get_Currency(self): return self.Currency
    def set_Currency(self, Currency): self.Currency = Currency
    def get_LastUpdateTime(self): return self.LastUpdateTime
    def set_LastUpdateTime(self, LastUpdateTime): self.LastUpdateTime = LastUpdateTime
    def hasContent_(self):
        if (
            self.Cost or
            self.Currency is not None or
            self.LastUpdateTime is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BillableCostsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BillableCostsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BillableCostsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BillableCostsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BillableCostsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Cost_ in self.Cost:
            Cost_.export(outfile, level, namespace_, name_='Cost', pretty_print=pretty_print)
        if self.Currency is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCurrency>%s</%sCurrency>%s' % (namespace_, self.gds_format_string(quote_xml(self.Currency).encode(ExternalEncoding), input_name='Currency'), namespace_, eol_))
        if self.LastUpdateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLastUpdateTime>%s</%sLastUpdateTime>%s' % (namespace_, self.gds_format_string(quote_xml(self.LastUpdateTime).encode(ExternalEncoding), input_name='LastUpdateTime'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BillableCostsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Cost=[\n')
        level += 1
        for Cost_ in self.Cost:
            showIndent(outfile, level)
            outfile.write('model_.CostType(\n')
            Cost_.exportLiteral(outfile, level, name_='CostType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Currency is not None:
            showIndent(outfile, level)
            outfile.write('Currency=%s,\n' % quote_python(self.Currency).encode(ExternalEncoding))
        if self.LastUpdateTime is not None:
            showIndent(outfile, level)
            outfile.write('LastUpdateTime=%s,\n' % quote_python(self.LastUpdateTime).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Cost':
            obj_ = CostType.factory()
            obj_.build(child_)
            self.Cost.append(obj_)
            obj_.original_tagname_ = 'Cost'
        elif nodeName_ == 'Currency':
            Currency_ = child_.text
            Currency_ = self.gds_validate_string(Currency_, node, 'Currency')
            self.Currency = Currency_
        elif nodeName_ == 'LastUpdateTime':
            LastUpdateTime_ = child_.text
            LastUpdateTime_ = self.gds_validate_string(LastUpdateTime_, node, 'LastUpdateTime')
            self.LastUpdateTime = LastUpdateTime_
# end class BillableCostsType


class CostType(GeneratedsSuper):
    """5.7always Represents the cost item."""
    subclass = None
    superclass = None
    def __init__(self, Type=None, Amount=None, Properties=None):
        self.original_tagname_ = None
        self.Type = Type
        self.Amount = Amount
        self.Properties = Properties
    def factory(*args_, **kwargs_):
        if CostType.subclass:
            return CostType.subclass(*args_, **kwargs_)
        else:
            return CostType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def get_Amount(self): return self.Amount
    def set_Amount(self, Amount): self.Amount = Amount
    def get_Properties(self): return self.Properties
    def set_Properties(self, Properties): self.Properties = Properties
    def hasContent_(self):
        if (
            self.Type is not None or
            self.Amount is not None or
            self.Properties is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CostType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CostType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CostType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CostType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CostType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Type is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sType>%s</%sType>%s' % (namespace_, self.gds_format_string(quote_xml(self.Type).encode(ExternalEncoding), input_name='Type'), namespace_, eol_))
        if self.Amount is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAmount>%s</%sAmount>%s' % (namespace_, self.gds_format_float(self.Amount, input_name='Amount'), namespace_, eol_))
        if self.Properties is not None:
            self.Properties.export(outfile, level, namespace_, name_='Properties', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CostType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Type is not None:
            showIndent(outfile, level)
            outfile.write('Type=%s,\n' % quote_python(self.Type).encode(ExternalEncoding))
        if self.Amount is not None:
            showIndent(outfile, level)
            outfile.write('Amount=%f,\n' % self.Amount)
        if self.Properties is not None:
            showIndent(outfile, level)
            outfile.write('Properties=model_.PropertiesType(\n')
            self.Properties.exportLiteral(outfile, level, name_='Properties')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            Type_ = child_.text
            Type_ = self.gds_validate_string(Type_, node, 'Type')
            self.Type = Type_
        elif nodeName_ == 'Amount':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Amount')
            self.Amount = fval_
        elif nodeName_ == 'Properties':
            obj_ = PropertiesType.factory()
            obj_.build(child_)
            self.Properties = obj_
            obj_.original_tagname_ = 'Properties'
# end class CostType


class PropertiesType(GeneratedsSuper):
    """5.7always List of properties associated with billing item."""
    subclass = None
    superclass = None
    def __init__(self, Property=None):
        self.original_tagname_ = None
        if Property is None:
            self.Property = []
        else:
            self.Property = Property
    def factory(*args_, **kwargs_):
        if PropertiesType.subclass:
            return PropertiesType.subclass(*args_, **kwargs_)
        else:
            return PropertiesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Property(self): return self.Property
    def set_Property(self, Property): self.Property = Property
    def add_Property(self, value): self.Property.append(value)
    def insert_Property_at(self, index, value): self.Property.insert(index, value)
    def replace_Property_at(self, index, value): self.Property[index] = value
    def hasContent_(self):
        if (
            self.Property
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PropertiesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PropertiesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PropertiesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PropertiesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PropertiesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Property_ in self.Property:
            Property_.export(outfile, level, namespace_, name_='Property', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PropertiesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Property=[\n')
        level += 1
        for Property_ in self.Property:
            showIndent(outfile, level)
            outfile.write('model_.PropertyType(\n')
            Property_.exportLiteral(outfile, level, name_='PropertyType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Property':
            obj_ = PropertyType.factory()
            obj_.build(child_)
            self.Property.append(obj_)
            obj_.original_tagname_ = 'Property'
# end class PropertiesType


class PropertyType(GeneratedsSuper):
    """5.7always Base type for a single property record, includes details
    like property name and value."""
    subclass = None
    superclass = None
    def __init__(self, name=None, valueOf_=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if PropertyType.subclass:
            return PropertyType.subclass(*args_, **kwargs_)
        else:
            return PropertyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PropertyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PropertyType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PropertyType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PropertyType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PropertyType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='PropertyType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class PropertyType


class ServiceGroupsType(GeneratedsSuper):
    """5.7 Lists all service-groups for a given company, includes company
    details and service group list."""
    subclass = None
    superclass = None
    def __init__(self, CompanyId=None, CompanyName=None, ServiceGroupList=None):
        self.original_tagname_ = None
        self.CompanyId = CompanyId
        self.CompanyName = CompanyName
        self.ServiceGroupList = ServiceGroupList
    def factory(*args_, **kwargs_):
        if ServiceGroupsType.subclass:
            return ServiceGroupsType.subclass(*args_, **kwargs_)
        else:
            return ServiceGroupsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CompanyId(self): return self.CompanyId
    def set_CompanyId(self, CompanyId): self.CompanyId = CompanyId
    def get_CompanyName(self): return self.CompanyName
    def set_CompanyName(self, CompanyName): self.CompanyName = CompanyName
    def get_ServiceGroupList(self): return self.ServiceGroupList
    def set_ServiceGroupList(self, ServiceGroupList): self.ServiceGroupList = ServiceGroupList
    def hasContent_(self):
        if (
            self.CompanyId is not None or
            self.CompanyName is not None or
            self.ServiceGroupList is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ServiceGroupsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceGroupsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ServiceGroupsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ServiceGroupsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ServiceGroupsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CompanyId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCompanyId>%s</%sCompanyId>%s' % (namespace_, self.gds_format_string(quote_xml(self.CompanyId).encode(ExternalEncoding), input_name='CompanyId'), namespace_, eol_))
        if self.CompanyName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCompanyName>%s</%sCompanyName>%s' % (namespace_, self.gds_format_string(quote_xml(self.CompanyName).encode(ExternalEncoding), input_name='CompanyName'), namespace_, eol_))
        if self.ServiceGroupList is not None:
            self.ServiceGroupList.export(outfile, level, namespace_, name_='ServiceGroupList', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ServiceGroupsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.CompanyId is not None:
            showIndent(outfile, level)
            outfile.write('CompanyId=%s,\n' % quote_python(self.CompanyId).encode(ExternalEncoding))
        if self.CompanyName is not None:
            showIndent(outfile, level)
            outfile.write('CompanyName=%s,\n' % quote_python(self.CompanyName).encode(ExternalEncoding))
        if self.ServiceGroupList is not None:
            showIndent(outfile, level)
            outfile.write('ServiceGroupList=model_.ServiceGroupListType(\n')
            self.ServiceGroupList.exportLiteral(outfile, level, name_='ServiceGroupList')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CompanyId':
            CompanyId_ = child_.text
            CompanyId_ = self.gds_validate_string(CompanyId_, node, 'CompanyId')
            self.CompanyId = CompanyId_
        elif nodeName_ == 'CompanyName':
            CompanyName_ = child_.text
            CompanyName_ = self.gds_validate_string(CompanyName_, node, 'CompanyName')
            self.CompanyName = CompanyName_
        elif nodeName_ == 'ServiceGroupList':
            obj_ = ServiceGroupListType.factory()
            obj_.build(child_)
            self.ServiceGroupList = obj_
            obj_.original_tagname_ = 'ServiceGroupList'
# end class ServiceGroupsType


class ServiceGroupListType(GeneratedsSuper):
    """5.7always Container for service group data."""
    subclass = None
    superclass = None
    def __init__(self, ServiceGroup=None):
        self.original_tagname_ = None
        if ServiceGroup is None:
            self.ServiceGroup = []
        else:
            self.ServiceGroup = ServiceGroup
    def factory(*args_, **kwargs_):
        if ServiceGroupListType.subclass:
            return ServiceGroupListType.subclass(*args_, **kwargs_)
        else:
            return ServiceGroupListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ServiceGroup(self): return self.ServiceGroup
    def set_ServiceGroup(self, ServiceGroup): self.ServiceGroup = ServiceGroup
    def add_ServiceGroup(self, value): self.ServiceGroup.append(value)
    def insert_ServiceGroup_at(self, index, value): self.ServiceGroup.insert(index, value)
    def replace_ServiceGroup_at(self, index, value): self.ServiceGroup[index] = value
    def hasContent_(self):
        if (
            self.ServiceGroup
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ServiceGroupListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceGroupListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ServiceGroupListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ServiceGroupListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ServiceGroupListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ServiceGroup_ in self.ServiceGroup:
            ServiceGroup_.export(outfile, level, namespace_, name_='ServiceGroup', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ServiceGroupListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('ServiceGroup=[\n')
        level += 1
        for ServiceGroup_ in self.ServiceGroup:
            showIndent(outfile, level)
            outfile.write('model_.ServiceGroupType(\n')
            ServiceGroup_.exportLiteral(outfile, level, name_='ServiceGroupType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ServiceGroup':
            obj_ = ServiceGroupType.factory()
            obj_.build(child_)
            self.ServiceGroup.append(obj_)
            obj_.original_tagname_ = 'ServiceGroup'
# end class ServiceGroupListType


class ServiceGroupType(GeneratedsSuper):
    """5.7always Represents service group data, includes details like
    service group id, service group display name, billing currency,
    billing attributes and anniversary dates."""
    subclass = None
    superclass = None
    def __init__(self, Id=None, DisplayName=None, BillingCurrency=None, BillingAttributes=None, AvailableBills=None):
        self.original_tagname_ = None
        self.Id = Id
        self.DisplayName = DisplayName
        self.BillingCurrency = BillingCurrency
        self.BillingAttributes = BillingAttributes
        self.AvailableBills = AvailableBills
    def factory(*args_, **kwargs_):
        if ServiceGroupType.subclass:
            return ServiceGroupType.subclass(*args_, **kwargs_)
        else:
            return ServiceGroupType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_DisplayName(self): return self.DisplayName
    def set_DisplayName(self, DisplayName): self.DisplayName = DisplayName
    def get_BillingCurrency(self): return self.BillingCurrency
    def set_BillingCurrency(self, BillingCurrency): self.BillingCurrency = BillingCurrency
    def get_BillingAttributes(self): return self.BillingAttributes
    def set_BillingAttributes(self, BillingAttributes): self.BillingAttributes = BillingAttributes
    def get_AvailableBills(self): return self.AvailableBills
    def set_AvailableBills(self, AvailableBills): self.AvailableBills = AvailableBills
    def hasContent_(self):
        if (
            self.Id is not None or
            self.DisplayName is not None or
            self.BillingCurrency is not None or
            self.BillingAttributes is not None or
            self.AvailableBills is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ServiceGroupType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ServiceGroupType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ServiceGroupType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ServiceGroupType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ServiceGroupType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sId>%s</%sId>%s' % (namespace_, self.gds_format_string(quote_xml(self.Id).encode(ExternalEncoding), input_name='Id'), namespace_, eol_))
        if self.DisplayName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDisplayName>%s</%sDisplayName>%s' % (namespace_, self.gds_format_string(quote_xml(self.DisplayName).encode(ExternalEncoding), input_name='DisplayName'), namespace_, eol_))
        if self.BillingCurrency is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBillingCurrency>%s</%sBillingCurrency>%s' % (namespace_, self.gds_format_string(quote_xml(self.BillingCurrency).encode(ExternalEncoding), input_name='BillingCurrency'), namespace_, eol_))
        if self.BillingAttributes is not None:
            self.BillingAttributes.export(outfile, level, namespace_, name_='BillingAttributes', pretty_print=pretty_print)
        if self.AvailableBills is not None:
            self.AvailableBills.export(outfile, level, namespace_, name_='AvailableBills', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ServiceGroupType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Id is not None:
            showIndent(outfile, level)
            outfile.write('Id=%s,\n' % quote_python(self.Id).encode(ExternalEncoding))
        if self.DisplayName is not None:
            showIndent(outfile, level)
            outfile.write('DisplayName=%s,\n' % quote_python(self.DisplayName).encode(ExternalEncoding))
        if self.BillingCurrency is not None:
            showIndent(outfile, level)
            outfile.write('BillingCurrency=%s,\n' % quote_python(self.BillingCurrency).encode(ExternalEncoding))
        if self.BillingAttributes is not None:
            showIndent(outfile, level)
            outfile.write('BillingAttributes=model_.BillingAttributesType(\n')
            self.BillingAttributes.exportLiteral(outfile, level, name_='BillingAttributes')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AvailableBills is not None:
            showIndent(outfile, level)
            outfile.write('AvailableBills=model_.AvailableBillsType(\n')
            self.AvailableBills.exportLiteral(outfile, level, name_='AvailableBills')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Id':
            Id_ = child_.text
            Id_ = self.gds_validate_string(Id_, node, 'Id')
            self.Id = Id_
        elif nodeName_ == 'DisplayName':
            DisplayName_ = child_.text
            DisplayName_ = self.gds_validate_string(DisplayName_, node, 'DisplayName')
            self.DisplayName = DisplayName_
        elif nodeName_ == 'BillingCurrency':
            BillingCurrency_ = child_.text
            BillingCurrency_ = self.gds_validate_string(BillingCurrency_, node, 'BillingCurrency')
            self.BillingCurrency = BillingCurrency_
        elif nodeName_ == 'BillingAttributes':
            obj_ = BillingAttributesType.factory()
            obj_.build(child_)
            self.BillingAttributes = obj_
            obj_.original_tagname_ = 'BillingAttributes'
        elif nodeName_ == 'AvailableBills':
            obj_ = AvailableBillsType.factory()
            obj_.build(child_)
            self.AvailableBills = obj_
            obj_.original_tagname_ = 'AvailableBills'
# end class ServiceGroupType


class BillingAttributesType(GeneratedsSuper):
    """5.7always Contains a list of billing attributes."""
    subclass = None
    superclass = None
    def __init__(self, Attribute=None):
        self.original_tagname_ = None
        if Attribute is None:
            self.Attribute = []
        else:
            self.Attribute = Attribute
    def factory(*args_, **kwargs_):
        if BillingAttributesType.subclass:
            return BillingAttributesType.subclass(*args_, **kwargs_)
        else:
            return BillingAttributesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Attribute(self): return self.Attribute
    def set_Attribute(self, Attribute): self.Attribute = Attribute
    def add_Attribute(self, value): self.Attribute.append(value)
    def insert_Attribute_at(self, index, value): self.Attribute.insert(index, value)
    def replace_Attribute_at(self, index, value): self.Attribute[index] = value
    def hasContent_(self):
        if (
            self.Attribute
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BillingAttributesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BillingAttributesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BillingAttributesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BillingAttributesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BillingAttributesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Attribute_ in self.Attribute:
            Attribute_.export(outfile, level, namespace_, name_='Attribute', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BillingAttributesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Attribute=[\n')
        level += 1
        for Attribute_ in self.Attribute:
            showIndent(outfile, level)
            outfile.write('model_.AttributeType(\n')
            Attribute_.exportLiteral(outfile, level, name_='AttributeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Attribute':
            obj_ = AttributeType.factory()
            obj_.build(child_)
            self.Attribute.append(obj_)
            obj_.original_tagname_ = 'Attribute'
# end class BillingAttributesType


class AvailableBillsType(GeneratedsSuper):
    """5.7always Contains a list of available bills."""
    subclass = None
    superclass = None
    def __init__(self, Bill=None):
        self.original_tagname_ = None
        if Bill is None:
            self.Bill = []
        else:
            self.Bill = Bill
    def factory(*args_, **kwargs_):
        if AvailableBillsType.subclass:
            return AvailableBillsType.subclass(*args_, **kwargs_)
        else:
            return AvailableBillsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Bill(self): return self.Bill
    def set_Bill(self, Bill): self.Bill = Bill
    def add_Bill(self, value): self.Bill.append(value)
    def insert_Bill_at(self, index, value): self.Bill.insert(index, value)
    def replace_Bill_at(self, index, value): self.Bill[index] = value
    def hasContent_(self):
        if (
            self.Bill
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AvailableBillsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AvailableBillsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AvailableBillsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AvailableBillsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='AvailableBillsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Bill_ in self.Bill:
            Bill_.export(outfile, level, namespace_, name_='Bill', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AvailableBillsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Bill=[\n')
        level += 1
        for Bill_ in self.Bill:
            showIndent(outfile, level)
            outfile.write('model_.BillType(\n')
            Bill_.exportLiteral(outfile, level, name_='BillType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Bill':
            obj_ = BillType.factory()
            obj_.build(child_)
            self.Bill.append(obj_)
            obj_.original_tagname_ = 'Bill'
# end class AvailableBillsType


class AttributeType(GeneratedsSuper):
    """5.7always Contain details of a given attribute. Subtypes define more
    specific elements. 5.7always The attribute name."""
    subclass = None
    superclass = None
    def __init__(self, name=None, Value=None, Properties=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.Value = Value
        self.Properties = Properties
    def factory(*args_, **kwargs_):
        if AttributeType.subclass:
            return AttributeType.subclass(*args_, **kwargs_)
        else:
            return AttributeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_Properties(self): return self.Properties
    def set_Properties(self, Properties): self.Properties = Properties
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            self.Value is not None or
            self.Properties is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AttributeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AttributeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AttributeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AttributeType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AttributeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
        if self.Properties is not None:
            self.Properties.export(outfile, level, namespace_, name_='Properties', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AttributeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
        if self.Properties is not None:
            showIndent(outfile, level)
            outfile.write('Properties=model_.PropertiesType(\n')
            self.Properties.exportLiteral(outfile, level, name_='Properties')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'Properties':
            obj_ = PropertiesType.factory()
            obj_.build(child_)
            self.Properties = obj_
            obj_.original_tagname_ = 'Properties'
# end class AttributeType


class BillType(GeneratedsSuper):
    """5.7always Represents bill meta data. Include details like generated
    bill URI, billing month and billing year."""
    subclass = None
    superclass = None
    def __init__(self, Link=None, BillingPeriod=None):
        self.original_tagname_ = None
        self.Link = Link
        self.BillingPeriod = BillingPeriod
    def factory(*args_, **kwargs_):
        if BillType.subclass:
            return BillType.subclass(*args_, **kwargs_)
        else:
            return BillType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Link(self): return self.Link
    def set_Link(self, Link): self.Link = Link
    def get_BillingPeriod(self): return self.BillingPeriod
    def set_BillingPeriod(self, BillingPeriod): self.BillingPeriod = BillingPeriod
    def hasContent_(self):
        if (
            self.Link is not None or
            self.BillingPeriod is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BillType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BillType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BillType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BillType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BillType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Link is not None:
            self.Link.export(outfile, level, namespace_, name_='Link', pretty_print=pretty_print)
        if self.BillingPeriod is not None:
            self.BillingPeriod.export(outfile, level, namespace_, name_='BillingPeriod', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BillType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Link is not None:
            showIndent(outfile, level)
            outfile.write('Link=model_.LinkType(\n')
            self.Link.exportLiteral(outfile, level, name_='Link')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.BillingPeriod is not None:
            showIndent(outfile, level)
            outfile.write('BillingPeriod=model_.BillingPeriodType(\n')
            self.BillingPeriod.exportLiteral(outfile, level, name_='BillingPeriod')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Link':
            obj_ = LinkType.factory()
            obj_.build(child_)
            self.Link = obj_
            obj_.original_tagname_ = 'Link'
        elif nodeName_ == 'BillingPeriod':
            obj_ = BillingPeriodType.factory()
            obj_.build(child_)
            self.BillingPeriod = obj_
            obj_.original_tagname_ = 'BillingPeriod'
# end class BillType


class LinkType(GeneratedsSuper):
    """5.7none A reference to an entity or operation associated with the
    object. 5.7none Defines the relationship of the link to the
    object that contains it. 5.7none Contains the URI to the entity."""
    subclass = None
    superclass = None
    def __init__(self, href=None, rel=None):
        self.original_tagname_ = None
        self.href = _cast(None, href)
        self.rel = _cast(None, rel)
    def factory(*args_, **kwargs_):
        if LinkType.subclass:
            return LinkType.subclass(*args_, **kwargs_)
        else:
            return LinkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LinkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LinkType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LinkType'):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LinkType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='LinkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel="%s",\n' % (self.rel,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class LinkType


class BillingPeriodType(GeneratedsSuper):
    """5.7always Represents billing period for a given bill."""
    subclass = None
    superclass = None
    def __init__(self, Month=None, Year=None, StartDate=None, EndDate=None):
        self.original_tagname_ = None
        self.Month = Month
        self.Year = Year
        self.StartDate = StartDate
        self.EndDate = EndDate
    def factory(*args_, **kwargs_):
        if BillingPeriodType.subclass:
            return BillingPeriodType.subclass(*args_, **kwargs_)
        else:
            return BillingPeriodType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Month(self): return self.Month
    def set_Month(self, Month): self.Month = Month
    def get_Year(self): return self.Year
    def set_Year(self, Year): self.Year = Year
    def get_StartDate(self): return self.StartDate
    def set_StartDate(self, StartDate): self.StartDate = StartDate
    def get_EndDate(self): return self.EndDate
    def set_EndDate(self, EndDate): self.EndDate = EndDate
    def hasContent_(self):
        if (
            self.Month is not None or
            self.Year is not None or
            self.StartDate is not None or
            self.EndDate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BillingPeriodType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BillingPeriodType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BillingPeriodType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BillingPeriodType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BillingPeriodType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Month is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMonth>%s</%sMonth>%s' % (namespace_, self.gds_format_integer(self.Month, input_name='Month'), namespace_, eol_))
        if self.Year is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sYear>%s</%sYear>%s' % (namespace_, self.gds_format_integer(self.Year, input_name='Year'), namespace_, eol_))
        if self.StartDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStartDate>%s</%sStartDate>%s' % (namespace_, self.gds_format_string(quote_xml(self.StartDate).encode(ExternalEncoding), input_name='StartDate'), namespace_, eol_))
        if self.EndDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEndDate>%s</%sEndDate>%s' % (namespace_, self.gds_format_string(quote_xml(self.EndDate).encode(ExternalEncoding), input_name='EndDate'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='BillingPeriodType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Month is not None:
            showIndent(outfile, level)
            outfile.write('Month=%d,\n' % self.Month)
        if self.Year is not None:
            showIndent(outfile, level)
            outfile.write('Year=%d,\n' % self.Year)
        if self.StartDate is not None:
            showIndent(outfile, level)
            outfile.write('StartDate=%s,\n' % quote_python(self.StartDate).encode(ExternalEncoding))
        if self.EndDate is not None:
            showIndent(outfile, level)
            outfile.write('EndDate=%s,\n' % quote_python(self.EndDate).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Month':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Month')
            self.Month = ival_
        elif nodeName_ == 'Year':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Year')
            self.Year = ival_
        elif nodeName_ == 'StartDate':
            StartDate_ = child_.text
            StartDate_ = self.gds_validate_string(StartDate_, node, 'StartDate')
            self.StartDate = StartDate_
        elif nodeName_ == 'EndDate':
            EndDate_ = child_.text
            EndDate_ = self.gds_validate_string(EndDate_, node, 'EndDate')
            self.EndDate = EndDate_
# end class BillingPeriodType


GDSClassesMapping = {
    'BilledCosts': BilledCostsType,
    'ServiceGroupList': ServiceGroupListType,
    'Property': PropertyType,
    'Bill': BillType,
    'Attribute': AttributeType,
    'AvailableBills': AvailableBillsType,
    'BillingPeriod': BillingPeriodType,
    'ServiceGroup': ServiceGroupType,
    'BillableCosts': BillableCostsType,
    'BillableList': BillableListType,
    'BilledUsage': BilledUsageType,
    'Cost': CostType,
    'ServiceGroups': ServiceGroupsType,
    'Properties': PropertiesType,
    'Billable': BillableType,
    'Link': LinkType,
    'BillingAttributes': BillingAttributesType,
    'Entity': EntityType,
    'BillableUsage': BillableUsageType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'BilledUsageType'
        rootClass = BilledUsageType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'BilledUsageType'
        rootClass = BilledUsageType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'BilledUsageType'
        rootClass = BilledUsageType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'BilledUsageType'
        rootClass = BilledUsageType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from meteringType import *\n\n')
        sys.stdout.write('import meteringType as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "AttributeType",
    "AvailableBillsType",
    "BillType",
    "BillableCostsType",
    "BillableListType",
    "BillableType",
    "BillableUsageType",
    "BilledCostsType",
    "BilledUsageType",
    "BillingAttributesType",
    "BillingPeriodType",
    "CostType",
    "EntityType",
    "LinkType",
    "PropertiesType",
    "PropertyType",
    "ServiceGroupListType",
    "ServiceGroupType",
    "ServiceGroupsType"
]
