# VMware vCloud Python SDK
# Copyright (c) 2014 VMware, Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Nov  4 14:07:15 2014 by generateDS.py version 2.13a.
#
# Command line options:
#   ('-o', 'schema/vcd/v1_5/schemas/vcloud/queryRecordViewType.py')
#
# Command line arguments:
#   schema/vcd/v1_5/schemas/vcloud/queryRecordView.xsd
#
# Command line:
#   ../env/bin/generateDS.py -o "schema/vcd/v1_5/schemas/vcloud/queryRecordViewType.py" schema/vcd/v1_5/schemas/vcloud/queryRecordView.xsd
#
# Current working directory (os.getcwd()):
#   src
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class QueryResultRecordType(GeneratedsSuper):
    """always Base type for a single record from query result in records
    format. Subtypes define more specific elements. always Contains
    the URI to the resource. always The resource identifier,
    expressed in URN format. The value of this attribute uniquely
    identifies the resource, persists for the life of the resource,
    and is never reused. always Contains the type of the resource."""
    subclass = None
    superclass = None
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, extensiontype_=None):
        self.original_tagname_ = None
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        if Link is None:
            self.Link = []
        else:
            self.Link = Link
        self.Metadata = Metadata
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if QueryResultRecordType.subclass:
            return QueryResultRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Link(self): return self.Link
    def set_Link(self, Link): self.Link = Link
    def add_Link(self, value): self.Link.append(value)
    def insert_Link_at(self, index, value): self.Link.insert(index, value)
    def replace_Link_at(self, index, value): self.Link[index] = value
    def get_Metadata(self): return self.Metadata
    def set_Metadata(self, Metadata): self.Metadata = Metadata
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Link or
            self.Metadata is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultRecordType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultRecordType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Link_ in self.Link:
            Link_.export(outfile, level, namespace_, name_='Link', pretty_print=pretty_print)
        if self.Metadata is not None:
            self.Metadata.export(outfile, level, namespace_, name_='Metadata', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Link=[\n')
        level += 1
        for Link_ in self.Link:
            showIndent(outfile, level)
            outfile.write('model_.LinkType(\n')
            Link_.exportLiteral(outfile, level, name_='LinkType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Metadata is not None:
            showIndent(outfile, level)
            outfile.write('Metadata=model_.MetadataType(\n')
            self.Metadata.exportLiteral(outfile, level, name_='Metadata')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Link':
            obj_ = LinkType.factory()
            obj_.build(child_)
            self.Link.append(obj_)
            obj_.original_tagname_ = 'Link'
        elif nodeName_ == 'Metadata':
            obj_ = MetadataType.factory()
            obj_.build(child_)
            self.Metadata = obj_
            obj_.original_tagname_ = 'Metadata'
# end class QueryResultRecordType


class QueryResultOrgRecordType(QueryResultRecordType):
    """1.5 Type for a single organization query result in records format.
    1.5none Organization name 1.5none True if this organization is
    read only 1.5none True if this organization is enabled 1.5none
    Deployed VM quota 1.5none Stored VM Quota 1.5none Display name
    1.5none True if users from the organization can publish catalogs
    1.5none Number of catalogs 1.5none Number of VDCs 1.5none Number
    of vApps 1.5none Number of groups 5.1none Number of disks"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, numberOfVdcs=None, displayName=None, name=None, numberOfDisks=None, isReadOnly=None, isEnabled=None, deployedVMQuota=None, storedVMQuota=None, canPublishCatalogs=None, numberOfVApps=None, numberOfCatalogs=None, numberOfGroups=None):
        self.original_tagname_ = None
        super(QueryResultOrgRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.numberOfVdcs = _cast(int, numberOfVdcs)
        self.displayName = _cast(None, displayName)
        self.name = _cast(None, name)
        self.numberOfDisks = _cast(int, numberOfDisks)
        self.isReadOnly = _cast(bool, isReadOnly)
        self.isEnabled = _cast(bool, isEnabled)
        self.deployedVMQuota = _cast(int, deployedVMQuota)
        self.storedVMQuota = _cast(int, storedVMQuota)
        self.canPublishCatalogs = _cast(bool, canPublishCatalogs)
        self.numberOfVApps = _cast(int, numberOfVApps)
        self.numberOfCatalogs = _cast(int, numberOfCatalogs)
        self.numberOfGroups = _cast(int, numberOfGroups)
    def factory(*args_, **kwargs_):
        if QueryResultOrgRecordType.subclass:
            return QueryResultOrgRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultOrgRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_numberOfVdcs(self): return self.numberOfVdcs
    def set_numberOfVdcs(self, numberOfVdcs): self.numberOfVdcs = numberOfVdcs
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_numberOfDisks(self): return self.numberOfDisks
    def set_numberOfDisks(self, numberOfDisks): self.numberOfDisks = numberOfDisks
    def get_isReadOnly(self): return self.isReadOnly
    def set_isReadOnly(self, isReadOnly): self.isReadOnly = isReadOnly
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_deployedVMQuota(self): return self.deployedVMQuota
    def set_deployedVMQuota(self, deployedVMQuota): self.deployedVMQuota = deployedVMQuota
    def get_storedVMQuota(self): return self.storedVMQuota
    def set_storedVMQuota(self, storedVMQuota): self.storedVMQuota = storedVMQuota
    def get_canPublishCatalogs(self): return self.canPublishCatalogs
    def set_canPublishCatalogs(self, canPublishCatalogs): self.canPublishCatalogs = canPublishCatalogs
    def get_numberOfVApps(self): return self.numberOfVApps
    def set_numberOfVApps(self, numberOfVApps): self.numberOfVApps = numberOfVApps
    def get_numberOfCatalogs(self): return self.numberOfCatalogs
    def set_numberOfCatalogs(self, numberOfCatalogs): self.numberOfCatalogs = numberOfCatalogs
    def get_numberOfGroups(self): return self.numberOfGroups
    def set_numberOfGroups(self, numberOfGroups): self.numberOfGroups = numberOfGroups
    def hasContent_(self):
        if (
            super(QueryResultOrgRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultOrgRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultOrgRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultOrgRecordType'):
        super(QueryResultOrgRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgRecordType')
        if self.numberOfVdcs is not None and 'numberOfVdcs' not in already_processed:
            already_processed.add('numberOfVdcs')
            outfile.write(' numberOfVdcs="%s"' % self.gds_format_integer(self.numberOfVdcs, input_name='numberOfVdcs'))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            outfile.write(' displayName=%s' % (self.gds_format_string(quote_attrib(self.displayName).encode(ExternalEncoding), input_name='displayName'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.numberOfDisks is not None and 'numberOfDisks' not in already_processed:
            already_processed.add('numberOfDisks')
            outfile.write(' numberOfDisks="%s"' % self.gds_format_integer(self.numberOfDisks, input_name='numberOfDisks'))
        if self.isReadOnly is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            outfile.write(' isReadOnly="%s"' % self.gds_format_boolean(self.isReadOnly, input_name='isReadOnly'))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.deployedVMQuota is not None and 'deployedVMQuota' not in already_processed:
            already_processed.add('deployedVMQuota')
            outfile.write(' deployedVMQuota="%s"' % self.gds_format_integer(self.deployedVMQuota, input_name='deployedVMQuota'))
        if self.storedVMQuota is not None and 'storedVMQuota' not in already_processed:
            already_processed.add('storedVMQuota')
            outfile.write(' storedVMQuota="%s"' % self.gds_format_integer(self.storedVMQuota, input_name='storedVMQuota'))
        if self.canPublishCatalogs is not None and 'canPublishCatalogs' not in already_processed:
            already_processed.add('canPublishCatalogs')
            outfile.write(' canPublishCatalogs="%s"' % self.gds_format_boolean(self.canPublishCatalogs, input_name='canPublishCatalogs'))
        if self.numberOfVApps is not None and 'numberOfVApps' not in already_processed:
            already_processed.add('numberOfVApps')
            outfile.write(' numberOfVApps="%s"' % self.gds_format_integer(self.numberOfVApps, input_name='numberOfVApps'))
        if self.numberOfCatalogs is not None and 'numberOfCatalogs' not in already_processed:
            already_processed.add('numberOfCatalogs')
            outfile.write(' numberOfCatalogs="%s"' % self.gds_format_integer(self.numberOfCatalogs, input_name='numberOfCatalogs'))
        if self.numberOfGroups is not None and 'numberOfGroups' not in already_processed:
            already_processed.add('numberOfGroups')
            outfile.write(' numberOfGroups="%s"' % self.gds_format_integer(self.numberOfGroups, input_name='numberOfGroups'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultOrgRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultOrgRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultOrgRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.numberOfVdcs is not None and 'numberOfVdcs' not in already_processed:
            already_processed.add('numberOfVdcs')
            showIndent(outfile, level)
            outfile.write('numberOfVdcs=%d,\n' % (self.numberOfVdcs,))
        if self.displayName is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            showIndent(outfile, level)
            outfile.write('displayName="%s",\n' % (self.displayName,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.numberOfDisks is not None and 'numberOfDisks' not in already_processed:
            already_processed.add('numberOfDisks')
            showIndent(outfile, level)
            outfile.write('numberOfDisks=%d,\n' % (self.numberOfDisks,))
        if self.isReadOnly is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            showIndent(outfile, level)
            outfile.write('isReadOnly=%s,\n' % (self.isReadOnly,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.deployedVMQuota is not None and 'deployedVMQuota' not in already_processed:
            already_processed.add('deployedVMQuota')
            showIndent(outfile, level)
            outfile.write('deployedVMQuota=%d,\n' % (self.deployedVMQuota,))
        if self.storedVMQuota is not None and 'storedVMQuota' not in already_processed:
            already_processed.add('storedVMQuota')
            showIndent(outfile, level)
            outfile.write('storedVMQuota=%d,\n' % (self.storedVMQuota,))
        if self.canPublishCatalogs is not None and 'canPublishCatalogs' not in already_processed:
            already_processed.add('canPublishCatalogs')
            showIndent(outfile, level)
            outfile.write('canPublishCatalogs=%s,\n' % (self.canPublishCatalogs,))
        if self.numberOfVApps is not None and 'numberOfVApps' not in already_processed:
            already_processed.add('numberOfVApps')
            showIndent(outfile, level)
            outfile.write('numberOfVApps=%d,\n' % (self.numberOfVApps,))
        if self.numberOfCatalogs is not None and 'numberOfCatalogs' not in already_processed:
            already_processed.add('numberOfCatalogs')
            showIndent(outfile, level)
            outfile.write('numberOfCatalogs=%d,\n' % (self.numberOfCatalogs,))
        if self.numberOfGroups is not None and 'numberOfGroups' not in already_processed:
            already_processed.add('numberOfGroups')
            showIndent(outfile, level)
            outfile.write('numberOfGroups=%d,\n' % (self.numberOfGroups,))
        super(QueryResultOrgRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultOrgRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('numberOfVdcs', node)
        if value is not None and 'numberOfVdcs' not in already_processed:
            already_processed.add('numberOfVdcs')
            try:
                self.numberOfVdcs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('displayName', node)
        if value is not None and 'displayName' not in already_processed:
            already_processed.add('displayName')
            self.displayName = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('numberOfDisks', node)
        if value is not None and 'numberOfDisks' not in already_processed:
            already_processed.add('numberOfDisks')
            try:
                self.numberOfDisks = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isReadOnly', node)
        if value is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            if value in ('true', '1'):
                self.isReadOnly = True
            elif value in ('false', '0'):
                self.isReadOnly = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('deployedVMQuota', node)
        if value is not None and 'deployedVMQuota' not in already_processed:
            already_processed.add('deployedVMQuota')
            try:
                self.deployedVMQuota = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storedVMQuota', node)
        if value is not None and 'storedVMQuota' not in already_processed:
            already_processed.add('storedVMQuota')
            try:
                self.storedVMQuota = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('canPublishCatalogs', node)
        if value is not None and 'canPublishCatalogs' not in already_processed:
            already_processed.add('canPublishCatalogs')
            if value in ('true', '1'):
                self.canPublishCatalogs = True
            elif value in ('false', '0'):
                self.canPublishCatalogs = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('numberOfVApps', node)
        if value is not None and 'numberOfVApps' not in already_processed:
            already_processed.add('numberOfVApps')
            try:
                self.numberOfVApps = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfCatalogs', node)
        if value is not None and 'numberOfCatalogs' not in already_processed:
            already_processed.add('numberOfCatalogs')
            try:
                self.numberOfCatalogs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfGroups', node)
        if value is not None and 'numberOfGroups' not in already_processed:
            already_processed.add('numberOfGroups')
            try:
                self.numberOfGroups = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(QueryResultOrgRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultOrgRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultOrgRecordType


class QueryResultOrgVdcRecordType(QueryResultRecordType):
    """1.5 Type for a single orgVdc query result in records format. 1.5none
    VDC name 1.5none True if this entity is enabled 1.5none CPU
    allocation in Mhz 1.5none CPU limit in Mhz 1.5none CPU used in
    Mhz 1.5none Memory allocation in MB 1.5none Memory limit in MB
    1.5none Memory used in MB 1.55.1none Storage allocation in MB
    1.5none Storage limit in MB 1.5none Storage used in MB 1.5none
    Provider VDC name 1.5none Provider VDC reference or id 1.5none
    Organization name 1.5none Number of vApps 1.5none Number of
    media 5.1none Number of disks 1.5none Number of vApp templates
    1.55.1none True if this VDC is used exclusively to support
    vShield Edge devices. 1.5none True if this entity is busy
    1.5none VDC status 1.5none Number of datastores 5.1none Number
    of storage profiles"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, numberOfStorageProfiles=None, memoryUsedMB=None, orgName=None, isSystemVdc=None, storageAllocationMB=None, numberOfVAppTemplates=None, isEnabled=None, cpuLimitMhz=None, memoryAllocationMB=None, isBusy=None, providerVdcName=None, cpuUsedMhz=None, status=None, memoryLimitMB=None, providerVdc=None, numberOfDatastores=None, numberOfVApps=None, storageUsedMB=None, name=None, numberOfDisks=None, storageLimitMB=None, numberOfMedia=None, cpuAllocationMhz=None):
        self.original_tagname_ = None
        super(QueryResultOrgVdcRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.numberOfStorageProfiles = _cast(int, numberOfStorageProfiles)
        self.memoryUsedMB = _cast(int, memoryUsedMB)
        self.orgName = _cast(None, orgName)
        self.isSystemVdc = _cast(bool, isSystemVdc)
        self.storageAllocationMB = _cast(int, storageAllocationMB)
        self.numberOfVAppTemplates = _cast(int, numberOfVAppTemplates)
        self.isEnabled = _cast(bool, isEnabled)
        self.cpuLimitMhz = _cast(int, cpuLimitMhz)
        self.memoryAllocationMB = _cast(int, memoryAllocationMB)
        self.isBusy = _cast(bool, isBusy)
        self.providerVdcName = _cast(None, providerVdcName)
        self.cpuUsedMhz = _cast(int, cpuUsedMhz)
        self.status = _cast(None, status)
        self.memoryLimitMB = _cast(int, memoryLimitMB)
        self.providerVdc = _cast(None, providerVdc)
        self.numberOfDatastores = _cast(int, numberOfDatastores)
        self.numberOfVApps = _cast(int, numberOfVApps)
        self.storageUsedMB = _cast(int, storageUsedMB)
        self.name = _cast(None, name)
        self.numberOfDisks = _cast(int, numberOfDisks)
        self.storageLimitMB = _cast(int, storageLimitMB)
        self.numberOfMedia = _cast(int, numberOfMedia)
        self.cpuAllocationMhz = _cast(int, cpuAllocationMhz)
    def factory(*args_, **kwargs_):
        if QueryResultOrgVdcRecordType.subclass:
            return QueryResultOrgVdcRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultOrgVdcRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_numberOfStorageProfiles(self): return self.numberOfStorageProfiles
    def set_numberOfStorageProfiles(self, numberOfStorageProfiles): self.numberOfStorageProfiles = numberOfStorageProfiles
    def get_memoryUsedMB(self): return self.memoryUsedMB
    def set_memoryUsedMB(self, memoryUsedMB): self.memoryUsedMB = memoryUsedMB
    def get_orgName(self): return self.orgName
    def set_orgName(self, orgName): self.orgName = orgName
    def get_isSystemVdc(self): return self.isSystemVdc
    def set_isSystemVdc(self, isSystemVdc): self.isSystemVdc = isSystemVdc
    def get_storageAllocationMB(self): return self.storageAllocationMB
    def set_storageAllocationMB(self, storageAllocationMB): self.storageAllocationMB = storageAllocationMB
    def get_numberOfVAppTemplates(self): return self.numberOfVAppTemplates
    def set_numberOfVAppTemplates(self, numberOfVAppTemplates): self.numberOfVAppTemplates = numberOfVAppTemplates
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_cpuLimitMhz(self): return self.cpuLimitMhz
    def set_cpuLimitMhz(self, cpuLimitMhz): self.cpuLimitMhz = cpuLimitMhz
    def get_memoryAllocationMB(self): return self.memoryAllocationMB
    def set_memoryAllocationMB(self, memoryAllocationMB): self.memoryAllocationMB = memoryAllocationMB
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_providerVdcName(self): return self.providerVdcName
    def set_providerVdcName(self, providerVdcName): self.providerVdcName = providerVdcName
    def get_cpuUsedMhz(self): return self.cpuUsedMhz
    def set_cpuUsedMhz(self, cpuUsedMhz): self.cpuUsedMhz = cpuUsedMhz
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_memoryLimitMB(self): return self.memoryLimitMB
    def set_memoryLimitMB(self, memoryLimitMB): self.memoryLimitMB = memoryLimitMB
    def get_providerVdc(self): return self.providerVdc
    def set_providerVdc(self, providerVdc): self.providerVdc = providerVdc
    def get_numberOfDatastores(self): return self.numberOfDatastores
    def set_numberOfDatastores(self, numberOfDatastores): self.numberOfDatastores = numberOfDatastores
    def get_numberOfVApps(self): return self.numberOfVApps
    def set_numberOfVApps(self, numberOfVApps): self.numberOfVApps = numberOfVApps
    def get_storageUsedMB(self): return self.storageUsedMB
    def set_storageUsedMB(self, storageUsedMB): self.storageUsedMB = storageUsedMB
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_numberOfDisks(self): return self.numberOfDisks
    def set_numberOfDisks(self, numberOfDisks): self.numberOfDisks = numberOfDisks
    def get_storageLimitMB(self): return self.storageLimitMB
    def set_storageLimitMB(self, storageLimitMB): self.storageLimitMB = storageLimitMB
    def get_numberOfMedia(self): return self.numberOfMedia
    def set_numberOfMedia(self, numberOfMedia): self.numberOfMedia = numberOfMedia
    def get_cpuAllocationMhz(self): return self.cpuAllocationMhz
    def set_cpuAllocationMhz(self, cpuAllocationMhz): self.cpuAllocationMhz = cpuAllocationMhz
    def hasContent_(self):
        if (
            super(QueryResultOrgVdcRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultOrgVdcRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgVdcRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultOrgVdcRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultOrgVdcRecordType'):
        super(QueryResultOrgVdcRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgVdcRecordType')
        if self.numberOfStorageProfiles is not None and 'numberOfStorageProfiles' not in already_processed:
            already_processed.add('numberOfStorageProfiles')
            outfile.write(' numberOfStorageProfiles="%s"' % self.gds_format_integer(self.numberOfStorageProfiles, input_name='numberOfStorageProfiles'))
        if self.memoryUsedMB is not None and 'memoryUsedMB' not in already_processed:
            already_processed.add('memoryUsedMB')
            outfile.write(' memoryUsedMB="%s"' % self.gds_format_integer(self.memoryUsedMB, input_name='memoryUsedMB'))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            outfile.write(' orgName=%s' % (self.gds_format_string(quote_attrib(self.orgName).encode(ExternalEncoding), input_name='orgName'), ))
        if self.isSystemVdc is not None and 'isSystemVdc' not in already_processed:
            already_processed.add('isSystemVdc')
            outfile.write(' isSystemVdc="%s"' % self.gds_format_boolean(self.isSystemVdc, input_name='isSystemVdc'))
        if self.storageAllocationMB is not None and 'storageAllocationMB' not in already_processed:
            already_processed.add('storageAllocationMB')
            outfile.write(' storageAllocationMB="%s"' % self.gds_format_integer(self.storageAllocationMB, input_name='storageAllocationMB'))
        if self.numberOfVAppTemplates is not None and 'numberOfVAppTemplates' not in already_processed:
            already_processed.add('numberOfVAppTemplates')
            outfile.write(' numberOfVAppTemplates="%s"' % self.gds_format_integer(self.numberOfVAppTemplates, input_name='numberOfVAppTemplates'))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.cpuLimitMhz is not None and 'cpuLimitMhz' not in already_processed:
            already_processed.add('cpuLimitMhz')
            outfile.write(' cpuLimitMhz="%s"' % self.gds_format_integer(self.cpuLimitMhz, input_name='cpuLimitMhz'))
        if self.memoryAllocationMB is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            outfile.write(' memoryAllocationMB="%s"' % self.gds_format_integer(self.memoryAllocationMB, input_name='memoryAllocationMB'))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.providerVdcName is not None and 'providerVdcName' not in already_processed:
            already_processed.add('providerVdcName')
            outfile.write(' providerVdcName=%s' % (self.gds_format_string(quote_attrib(self.providerVdcName).encode(ExternalEncoding), input_name='providerVdcName'), ))
        if self.cpuUsedMhz is not None and 'cpuUsedMhz' not in already_processed:
            already_processed.add('cpuUsedMhz')
            outfile.write(' cpuUsedMhz="%s"' % self.gds_format_integer(self.cpuUsedMhz, input_name='cpuUsedMhz'))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.memoryLimitMB is not None and 'memoryLimitMB' not in already_processed:
            already_processed.add('memoryLimitMB')
            outfile.write(' memoryLimitMB="%s"' % self.gds_format_integer(self.memoryLimitMB, input_name='memoryLimitMB'))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            outfile.write(' providerVdc=%s' % (self.gds_format_string(quote_attrib(self.providerVdc).encode(ExternalEncoding), input_name='providerVdc'), ))
        if self.numberOfDatastores is not None and 'numberOfDatastores' not in already_processed:
            already_processed.add('numberOfDatastores')
            outfile.write(' numberOfDatastores="%s"' % self.gds_format_integer(self.numberOfDatastores, input_name='numberOfDatastores'))
        if self.numberOfVApps is not None and 'numberOfVApps' not in already_processed:
            already_processed.add('numberOfVApps')
            outfile.write(' numberOfVApps="%s"' % self.gds_format_integer(self.numberOfVApps, input_name='numberOfVApps'))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            outfile.write(' storageUsedMB="%s"' % self.gds_format_integer(self.storageUsedMB, input_name='storageUsedMB'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.numberOfDisks is not None and 'numberOfDisks' not in already_processed:
            already_processed.add('numberOfDisks')
            outfile.write(' numberOfDisks="%s"' % self.gds_format_integer(self.numberOfDisks, input_name='numberOfDisks'))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            outfile.write(' storageLimitMB="%s"' % self.gds_format_integer(self.storageLimitMB, input_name='storageLimitMB'))
        if self.numberOfMedia is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            outfile.write(' numberOfMedia="%s"' % self.gds_format_integer(self.numberOfMedia, input_name='numberOfMedia'))
        if self.cpuAllocationMhz is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            outfile.write(' cpuAllocationMhz="%s"' % self.gds_format_integer(self.cpuAllocationMhz, input_name='cpuAllocationMhz'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultOrgVdcRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultOrgVdcRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultOrgVdcRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.numberOfStorageProfiles is not None and 'numberOfStorageProfiles' not in already_processed:
            already_processed.add('numberOfStorageProfiles')
            showIndent(outfile, level)
            outfile.write('numberOfStorageProfiles=%d,\n' % (self.numberOfStorageProfiles,))
        if self.memoryUsedMB is not None and 'memoryUsedMB' not in already_processed:
            already_processed.add('memoryUsedMB')
            showIndent(outfile, level)
            outfile.write('memoryUsedMB=%d,\n' % (self.memoryUsedMB,))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            showIndent(outfile, level)
            outfile.write('orgName="%s",\n' % (self.orgName,))
        if self.isSystemVdc is not None and 'isSystemVdc' not in already_processed:
            already_processed.add('isSystemVdc')
            showIndent(outfile, level)
            outfile.write('isSystemVdc=%s,\n' % (self.isSystemVdc,))
        if self.storageAllocationMB is not None and 'storageAllocationMB' not in already_processed:
            already_processed.add('storageAllocationMB')
            showIndent(outfile, level)
            outfile.write('storageAllocationMB=%d,\n' % (self.storageAllocationMB,))
        if self.numberOfVAppTemplates is not None and 'numberOfVAppTemplates' not in already_processed:
            already_processed.add('numberOfVAppTemplates')
            showIndent(outfile, level)
            outfile.write('numberOfVAppTemplates=%d,\n' % (self.numberOfVAppTemplates,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.cpuLimitMhz is not None and 'cpuLimitMhz' not in already_processed:
            already_processed.add('cpuLimitMhz')
            showIndent(outfile, level)
            outfile.write('cpuLimitMhz=%d,\n' % (self.cpuLimitMhz,))
        if self.memoryAllocationMB is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            showIndent(outfile, level)
            outfile.write('memoryAllocationMB=%d,\n' % (self.memoryAllocationMB,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.providerVdcName is not None and 'providerVdcName' not in already_processed:
            already_processed.add('providerVdcName')
            showIndent(outfile, level)
            outfile.write('providerVdcName="%s",\n' % (self.providerVdcName,))
        if self.cpuUsedMhz is not None and 'cpuUsedMhz' not in already_processed:
            already_processed.add('cpuUsedMhz')
            showIndent(outfile, level)
            outfile.write('cpuUsedMhz=%d,\n' % (self.cpuUsedMhz,))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.memoryLimitMB is not None and 'memoryLimitMB' not in already_processed:
            already_processed.add('memoryLimitMB')
            showIndent(outfile, level)
            outfile.write('memoryLimitMB=%d,\n' % (self.memoryLimitMB,))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            showIndent(outfile, level)
            outfile.write('providerVdc="%s",\n' % (self.providerVdc,))
        if self.numberOfDatastores is not None and 'numberOfDatastores' not in already_processed:
            already_processed.add('numberOfDatastores')
            showIndent(outfile, level)
            outfile.write('numberOfDatastores=%d,\n' % (self.numberOfDatastores,))
        if self.numberOfVApps is not None and 'numberOfVApps' not in already_processed:
            already_processed.add('numberOfVApps')
            showIndent(outfile, level)
            outfile.write('numberOfVApps=%d,\n' % (self.numberOfVApps,))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            showIndent(outfile, level)
            outfile.write('storageUsedMB=%d,\n' % (self.storageUsedMB,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.numberOfDisks is not None and 'numberOfDisks' not in already_processed:
            already_processed.add('numberOfDisks')
            showIndent(outfile, level)
            outfile.write('numberOfDisks=%d,\n' % (self.numberOfDisks,))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            showIndent(outfile, level)
            outfile.write('storageLimitMB=%d,\n' % (self.storageLimitMB,))
        if self.numberOfMedia is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            showIndent(outfile, level)
            outfile.write('numberOfMedia=%d,\n' % (self.numberOfMedia,))
        if self.cpuAllocationMhz is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            showIndent(outfile, level)
            outfile.write('cpuAllocationMhz=%d,\n' % (self.cpuAllocationMhz,))
        super(QueryResultOrgVdcRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultOrgVdcRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('numberOfStorageProfiles', node)
        if value is not None and 'numberOfStorageProfiles' not in already_processed:
            already_processed.add('numberOfStorageProfiles')
            try:
                self.numberOfStorageProfiles = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('memoryUsedMB', node)
        if value is not None and 'memoryUsedMB' not in already_processed:
            already_processed.add('memoryUsedMB')
            try:
                self.memoryUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('orgName', node)
        if value is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            self.orgName = value
        value = find_attr_value_('isSystemVdc', node)
        if value is not None and 'isSystemVdc' not in already_processed:
            already_processed.add('isSystemVdc')
            if value in ('true', '1'):
                self.isSystemVdc = True
            elif value in ('false', '0'):
                self.isSystemVdc = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('storageAllocationMB', node)
        if value is not None and 'storageAllocationMB' not in already_processed:
            already_processed.add('storageAllocationMB')
            try:
                self.storageAllocationMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfVAppTemplates', node)
        if value is not None and 'numberOfVAppTemplates' not in already_processed:
            already_processed.add('numberOfVAppTemplates')
            try:
                self.numberOfVAppTemplates = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('cpuLimitMhz', node)
        if value is not None and 'cpuLimitMhz' not in already_processed:
            already_processed.add('cpuLimitMhz')
            try:
                self.cpuLimitMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('memoryAllocationMB', node)
        if value is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            try:
                self.memoryAllocationMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('providerVdcName', node)
        if value is not None and 'providerVdcName' not in already_processed:
            already_processed.add('providerVdcName')
            self.providerVdcName = value
        value = find_attr_value_('cpuUsedMhz', node)
        if value is not None and 'cpuUsedMhz' not in already_processed:
            already_processed.add('cpuUsedMhz')
            try:
                self.cpuUsedMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('memoryLimitMB', node)
        if value is not None and 'memoryLimitMB' not in already_processed:
            already_processed.add('memoryLimitMB')
            try:
                self.memoryLimitMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('providerVdc', node)
        if value is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            self.providerVdc = value
        value = find_attr_value_('numberOfDatastores', node)
        if value is not None and 'numberOfDatastores' not in already_processed:
            already_processed.add('numberOfDatastores')
            try:
                self.numberOfDatastores = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfVApps', node)
        if value is not None and 'numberOfVApps' not in already_processed:
            already_processed.add('numberOfVApps')
            try:
                self.numberOfVApps = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storageUsedMB', node)
        if value is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            try:
                self.storageUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('numberOfDisks', node)
        if value is not None and 'numberOfDisks' not in already_processed:
            already_processed.add('numberOfDisks')
            try:
                self.numberOfDisks = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storageLimitMB', node)
        if value is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            try:
                self.storageLimitMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfMedia', node)
        if value is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            try:
                self.numberOfMedia = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('cpuAllocationMhz', node)
        if value is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            try:
                self.cpuAllocationMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(QueryResultOrgVdcRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultOrgVdcRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultOrgVdcRecordType


class QueryResultMediaRecordType(QueryResultRecordType):
    """1.5 Type for a single media query result in records format. 1.5none
    Owner name 1.5none Catalog name 1.5none True if this media file
    is in a published catalog. 1.5none Media name 1.5none VDC
    reference or id 1.5none VDC name 1.5none Organization reference
    or id 1.5none Creation date 1.5none True if this entity is busy
    1.5none Media storage in Bytes 1.5none Owner reference or id
    1.5none Catalog reference or id 1.5none Catalog item reference
    or id 1.5none Media status 5.1none Storage profile name"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, storageProfileName=None, name=None, storageB=None, isPublished=None, vdcName=None, catalog=None, vdc=None, catalogItem=None, ownerName=None, isBusy=None, owner=None, org=None, creationDate=None, catalogName=None):
        self.original_tagname_ = None
        super(QueryResultMediaRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.storageProfileName = _cast(None, storageProfileName)
        self.name = _cast(None, name)
        self.storageB = _cast(int, storageB)
        self.isPublished = _cast(bool, isPublished)
        self.vdcName = _cast(None, vdcName)
        self.catalog = _cast(None, catalog)
        self.vdc = _cast(None, vdc)
        self.catalogItem = _cast(None, catalogItem)
        self.ownerName = _cast(None, ownerName)
        self.isBusy = _cast(bool, isBusy)
        self.owner = _cast(None, owner)
        self.org = _cast(None, org)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.catalogName = _cast(None, catalogName)
    def factory(*args_, **kwargs_):
        if QueryResultMediaRecordType.subclass:
            return QueryResultMediaRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultMediaRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_storageProfileName(self): return self.storageProfileName
    def set_storageProfileName(self, storageProfileName): self.storageProfileName = storageProfileName
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_storageB(self): return self.storageB
    def set_storageB(self, storageB): self.storageB = storageB
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_catalog(self): return self.catalog
    def set_catalog(self, catalog): self.catalog = catalog
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_catalogItem(self): return self.catalogItem
    def set_catalogItem(self, catalogItem): self.catalogItem = catalogItem
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_catalogName(self): return self.catalogName
    def set_catalogName(self, catalogName): self.catalogName = catalogName
    def hasContent_(self):
        if (
            super(QueryResultMediaRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultMediaRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultMediaRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultMediaRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultMediaRecordType'):
        super(QueryResultMediaRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultMediaRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            outfile.write(' storageProfileName=%s' % (self.gds_format_string(quote_attrib(self.storageProfileName).encode(ExternalEncoding), input_name='storageProfileName'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.storageB is not None and 'storageB' not in already_processed:
            already_processed.add('storageB')
            outfile.write(' storageB="%s"' % self.gds_format_integer(self.storageB, input_name='storageB'))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            outfile.write(' catalog=%s' % (self.gds_format_string(quote_attrib(self.catalog).encode(ExternalEncoding), input_name='catalog'), ))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.catalogItem is not None and 'catalogItem' not in already_processed:
            already_processed.add('catalogItem')
            outfile.write(' catalogItem=%s' % (self.gds_format_string(quote_attrib(self.catalogItem).encode(ExternalEncoding), input_name='catalogItem'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(' owner=%s' % (self.gds_format_string(quote_attrib(self.owner).encode(ExternalEncoding), input_name='owner'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            outfile.write(' catalogName=%s' % (self.gds_format_string(quote_attrib(self.catalogName).encode(ExternalEncoding), input_name='catalogName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultMediaRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultMediaRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultMediaRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            showIndent(outfile, level)
            outfile.write('storageProfileName="%s",\n' % (self.storageProfileName,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.storageB is not None and 'storageB' not in already_processed:
            already_processed.add('storageB')
            showIndent(outfile, level)
            outfile.write('storageB=%d,\n' % (self.storageB,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            showIndent(outfile, level)
            outfile.write('catalog="%s",\n' % (self.catalog,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.catalogItem is not None and 'catalogItem' not in already_processed:
            already_processed.add('catalogItem')
            showIndent(outfile, level)
            outfile.write('catalogItem="%s",\n' % (self.catalogItem,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            showIndent(outfile, level)
            outfile.write('owner="%s",\n' % (self.owner,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            showIndent(outfile, level)
            outfile.write('catalogName="%s",\n' % (self.catalogName,))
        super(QueryResultMediaRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultMediaRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('storageProfileName', node)
        if value is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            self.storageProfileName = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('storageB', node)
        if value is not None and 'storageB' not in already_processed:
            already_processed.add('storageB')
            try:
                self.storageB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('catalog', node)
        if value is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            self.catalog = value
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('catalogItem', node)
        if value is not None and 'catalogItem' not in already_processed:
            already_processed.add('catalogItem')
            self.catalogItem = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('catalogName', node)
        if value is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            self.catalogName = value
        super(QueryResultMediaRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultMediaRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultMediaRecordType


class QueryResultVAppTemplateRecordType(QueryResultRecordType):
    """1.5 Type for a single vAppTemplate query result in records format.
    1.5none Owner name 1.5none Catalog name 1.5none True if this
    template is in a published catalog. 1.5none Vapp template name
    1.5none VDC reference or id 1.5none VDC name 1.5none
    Organization reference or id 1.5none Creation date 1.5none True
    if this entity is busy 1.5none True if this vApp template is a
    gold master. 1.5none True if the containing VDC is enabled
    1.5none Vapp template status 1.5none True if this vApp template
    is deployed 5.1none True if this vApp template is expired.
    5.1none Storage profile name"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isGoldMaster=None, status=None, isDeployed=None, name=None, storageProfileName=None, isEnabled=None, isPublished=None, vdcName=None, vdc=None, ownerName=None, isBusy=None, org=None, isExpired=None, creationDate=None, catalogName=None):
        self.original_tagname_ = None
        super(QueryResultVAppTemplateRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isGoldMaster = _cast(bool, isGoldMaster)
        self.status = _cast(None, status)
        self.isDeployed = _cast(bool, isDeployed)
        self.name = _cast(None, name)
        self.storageProfileName = _cast(None, storageProfileName)
        self.isEnabled = _cast(bool, isEnabled)
        self.isPublished = _cast(bool, isPublished)
        self.vdcName = _cast(None, vdcName)
        self.vdc = _cast(None, vdc)
        self.ownerName = _cast(None, ownerName)
        self.isBusy = _cast(bool, isBusy)
        self.org = _cast(None, org)
        self.isExpired = _cast(bool, isExpired)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.catalogName = _cast(None, catalogName)
    def factory(*args_, **kwargs_):
        if QueryResultVAppTemplateRecordType.subclass:
            return QueryResultVAppTemplateRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultVAppTemplateRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isGoldMaster(self): return self.isGoldMaster
    def set_isGoldMaster(self, isGoldMaster): self.isGoldMaster = isGoldMaster
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_isDeployed(self): return self.isDeployed
    def set_isDeployed(self, isDeployed): self.isDeployed = isDeployed
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_storageProfileName(self): return self.storageProfileName
    def set_storageProfileName(self, storageProfileName): self.storageProfileName = storageProfileName
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_isExpired(self): return self.isExpired
    def set_isExpired(self, isExpired): self.isExpired = isExpired
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_catalogName(self): return self.catalogName
    def set_catalogName(self, catalogName): self.catalogName = catalogName
    def hasContent_(self):
        if (
            super(QueryResultVAppTemplateRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultVAppTemplateRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVAppTemplateRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultVAppTemplateRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultVAppTemplateRecordType'):
        super(QueryResultVAppTemplateRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVAppTemplateRecordType')
        if self.isGoldMaster is not None and 'isGoldMaster' not in already_processed:
            already_processed.add('isGoldMaster')
            outfile.write(' isGoldMaster="%s"' % self.gds_format_boolean(self.isGoldMaster, input_name='isGoldMaster'))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            outfile.write(' isDeployed="%s"' % self.gds_format_boolean(self.isDeployed, input_name='isDeployed'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            outfile.write(' storageProfileName=%s' % (self.gds_format_string(quote_attrib(self.storageProfileName).encode(ExternalEncoding), input_name='storageProfileName'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            outfile.write(' isExpired="%s"' % self.gds_format_boolean(self.isExpired, input_name='isExpired'))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            outfile.write(' catalogName=%s' % (self.gds_format_string(quote_attrib(self.catalogName).encode(ExternalEncoding), input_name='catalogName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultVAppTemplateRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultVAppTemplateRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultVAppTemplateRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isGoldMaster is not None and 'isGoldMaster' not in already_processed:
            already_processed.add('isGoldMaster')
            showIndent(outfile, level)
            outfile.write('isGoldMaster=%s,\n' % (self.isGoldMaster,))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            showIndent(outfile, level)
            outfile.write('isDeployed=%s,\n' % (self.isDeployed,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            showIndent(outfile, level)
            outfile.write('storageProfileName="%s",\n' % (self.storageProfileName,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            showIndent(outfile, level)
            outfile.write('isExpired=%s,\n' % (self.isExpired,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            showIndent(outfile, level)
            outfile.write('catalogName="%s",\n' % (self.catalogName,))
        super(QueryResultVAppTemplateRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultVAppTemplateRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isGoldMaster', node)
        if value is not None and 'isGoldMaster' not in already_processed:
            already_processed.add('isGoldMaster')
            if value in ('true', '1'):
                self.isGoldMaster = True
            elif value in ('false', '0'):
                self.isGoldMaster = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('isDeployed', node)
        if value is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            if value in ('true', '1'):
                self.isDeployed = True
            elif value in ('false', '0'):
                self.isDeployed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('storageProfileName', node)
        if value is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            self.storageProfileName = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('isExpired', node)
        if value is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            if value in ('true', '1'):
                self.isExpired = True
            elif value in ('false', '0'):
                self.isExpired = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('catalogName', node)
        if value is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            self.catalogName = value
        super(QueryResultVAppTemplateRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultVAppTemplateRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultVAppTemplateRecordType


class QueryResultVAppRecordType(QueryResultRecordType):
    """1.5 Type for a single vApp query result in records format. 1.5none
    vApp name 1.5none VDC reference or id 1.5none VDC name 1.5none
    True if this entity is public 1.5none True if this entity is
    enabled 1.5none True if this entity is busy 1.5none Creation
    date 1.5none Status 1.5none Owner name 1.5none True if this
    entity is deployed 1.5none True if this entity is in maintenance
    mode 5.1none True if this vApp is expired."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, isDeployed=None, name=None, isEnabled=None, isPublic=None, vdcName=None, vdc=None, ownerName=None, isBusy=None, isInMaintenanceMode=None, creationDate=None, isExpired=None):
        self.original_tagname_ = None
        super(QueryResultVAppRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.isDeployed = _cast(bool, isDeployed)
        self.name = _cast(None, name)
        self.isEnabled = _cast(bool, isEnabled)
        self.isPublic = _cast(bool, isPublic)
        self.vdcName = _cast(None, vdcName)
        self.vdc = _cast(None, vdc)
        self.ownerName = _cast(None, ownerName)
        self.isBusy = _cast(bool, isBusy)
        self.isInMaintenanceMode = _cast(bool, isInMaintenanceMode)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.isExpired = _cast(bool, isExpired)
    def factory(*args_, **kwargs_):
        if QueryResultVAppRecordType.subclass:
            return QueryResultVAppRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultVAppRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_isDeployed(self): return self.isDeployed
    def set_isDeployed(self, isDeployed): self.isDeployed = isDeployed
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_isPublic(self): return self.isPublic
    def set_isPublic(self, isPublic): self.isPublic = isPublic
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_isInMaintenanceMode(self): return self.isInMaintenanceMode
    def set_isInMaintenanceMode(self, isInMaintenanceMode): self.isInMaintenanceMode = isInMaintenanceMode
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_isExpired(self): return self.isExpired
    def set_isExpired(self, isExpired): self.isExpired = isExpired
    def hasContent_(self):
        if (
            super(QueryResultVAppRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultVAppRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVAppRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultVAppRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultVAppRecordType'):
        super(QueryResultVAppRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVAppRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            outfile.write(' isDeployed="%s"' % self.gds_format_boolean(self.isDeployed, input_name='isDeployed'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.isPublic is not None and 'isPublic' not in already_processed:
            already_processed.add('isPublic')
            outfile.write(' isPublic="%s"' % self.gds_format_boolean(self.isPublic, input_name='isPublic'))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.isInMaintenanceMode is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            outfile.write(' isInMaintenanceMode="%s"' % self.gds_format_boolean(self.isInMaintenanceMode, input_name='isInMaintenanceMode'))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            outfile.write(' isExpired="%s"' % self.gds_format_boolean(self.isExpired, input_name='isExpired'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultVAppRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultVAppRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultVAppRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            showIndent(outfile, level)
            outfile.write('isDeployed=%s,\n' % (self.isDeployed,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.isPublic is not None and 'isPublic' not in already_processed:
            already_processed.add('isPublic')
            showIndent(outfile, level)
            outfile.write('isPublic=%s,\n' % (self.isPublic,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.isInMaintenanceMode is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            showIndent(outfile, level)
            outfile.write('isInMaintenanceMode=%s,\n' % (self.isInMaintenanceMode,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            showIndent(outfile, level)
            outfile.write('isExpired=%s,\n' % (self.isExpired,))
        super(QueryResultVAppRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultVAppRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('isDeployed', node)
        if value is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            if value in ('true', '1'):
                self.isDeployed = True
            elif value in ('false', '0'):
                self.isDeployed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isPublic', node)
        if value is not None and 'isPublic' not in already_processed:
            already_processed.add('isPublic')
            if value in ('true', '1'):
                self.isPublic = True
            elif value in ('false', '0'):
                self.isPublic = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isInMaintenanceMode', node)
        if value is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            if value in ('true', '1'):
                self.isInMaintenanceMode = True
            elif value in ('false', '0'):
                self.isInMaintenanceMode = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('isExpired', node)
        if value is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            if value in ('true', '1'):
                self.isExpired = True
            elif value in ('false', '0'):
                self.isExpired = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(QueryResultVAppRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultVAppRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultVAppRecordType


class QueryResultVMRecordType(QueryResultRecordType):
    """1.5 Type for a single vm query result in records format. 1.5none The
    name of the VM. 1.5none The name of the vApp or vApp template
    that contains this VM. 1.5none The ID of the vApp or vApp
    template that contains this VM. 1.5none VDC reference or id
    1.5none True if the VM belongs to a vApp template. 1.5none True
    if this entity is deleted 1.5none Guest operating system 1.5none
    Number of CPUs 1.5none Memory in MB 1.5none Status 1.5none True
    if this entity is busy 1.5none True if this entity is deployed
    1.5none True if this entity is in a published catalog 1.5none
    Catalog name 1.5none Hardware version 1.5none True if this
    entity is in maintenance mode 5.1none Storage profile name"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, containerName=None, isDeployed=None, container=None, name=None, storageProfileName=None, isPublished=None, memoryMB=None, numberOfCpus=None, vdc=None, hardwareVersion=None, isBusy=None, guestOs=None, isInMaintenanceMode=None, isVAppTemplate=None, isDeleted=None, catalogName=None):
        self.original_tagname_ = None
        super(QueryResultVMRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.containerName = _cast(None, containerName)
        self.isDeployed = _cast(bool, isDeployed)
        self.container = _cast(None, container)
        self.name = _cast(None, name)
        self.storageProfileName = _cast(None, storageProfileName)
        self.isPublished = _cast(bool, isPublished)
        self.memoryMB = _cast(int, memoryMB)
        self.numberOfCpus = _cast(int, numberOfCpus)
        self.vdc = _cast(None, vdc)
        self.hardwareVersion = _cast(int, hardwareVersion)
        self.isBusy = _cast(bool, isBusy)
        self.guestOs = _cast(None, guestOs)
        self.isInMaintenanceMode = _cast(bool, isInMaintenanceMode)
        self.isVAppTemplate = _cast(bool, isVAppTemplate)
        self.isDeleted = _cast(bool, isDeleted)
        self.catalogName = _cast(None, catalogName)
    def factory(*args_, **kwargs_):
        if QueryResultVMRecordType.subclass:
            return QueryResultVMRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultVMRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_containerName(self): return self.containerName
    def set_containerName(self, containerName): self.containerName = containerName
    def get_isDeployed(self): return self.isDeployed
    def set_isDeployed(self, isDeployed): self.isDeployed = isDeployed
    def get_container(self): return self.container
    def set_container(self, container): self.container = container
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_storageProfileName(self): return self.storageProfileName
    def set_storageProfileName(self, storageProfileName): self.storageProfileName = storageProfileName
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_memoryMB(self): return self.memoryMB
    def set_memoryMB(self, memoryMB): self.memoryMB = memoryMB
    def get_numberOfCpus(self): return self.numberOfCpus
    def set_numberOfCpus(self, numberOfCpus): self.numberOfCpus = numberOfCpus
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_hardwareVersion(self): return self.hardwareVersion
    def set_hardwareVersion(self, hardwareVersion): self.hardwareVersion = hardwareVersion
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_guestOs(self): return self.guestOs
    def set_guestOs(self, guestOs): self.guestOs = guestOs
    def get_isInMaintenanceMode(self): return self.isInMaintenanceMode
    def set_isInMaintenanceMode(self, isInMaintenanceMode): self.isInMaintenanceMode = isInMaintenanceMode
    def get_isVAppTemplate(self): return self.isVAppTemplate
    def set_isVAppTemplate(self, isVAppTemplate): self.isVAppTemplate = isVAppTemplate
    def get_isDeleted(self): return self.isDeleted
    def set_isDeleted(self, isDeleted): self.isDeleted = isDeleted
    def get_catalogName(self): return self.catalogName
    def set_catalogName(self, catalogName): self.catalogName = catalogName
    def hasContent_(self):
        if (
            super(QueryResultVMRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultVMRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVMRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultVMRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultVMRecordType'):
        super(QueryResultVMRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVMRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.containerName is not None and 'containerName' not in already_processed:
            already_processed.add('containerName')
            outfile.write(' containerName=%s' % (self.gds_format_string(quote_attrib(self.containerName).encode(ExternalEncoding), input_name='containerName'), ))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            outfile.write(' isDeployed="%s"' % self.gds_format_boolean(self.isDeployed, input_name='isDeployed'))
        if self.container is not None and 'container' not in already_processed:
            already_processed.add('container')
            outfile.write(' container=%s' % (self.gds_format_string(quote_attrib(self.container).encode(ExternalEncoding), input_name='container'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            outfile.write(' storageProfileName=%s' % (self.gds_format_string(quote_attrib(self.storageProfileName).encode(ExternalEncoding), input_name='storageProfileName'), ))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.memoryMB is not None and 'memoryMB' not in already_processed:
            already_processed.add('memoryMB')
            outfile.write(' memoryMB="%s"' % self.gds_format_integer(self.memoryMB, input_name='memoryMB'))
        if self.numberOfCpus is not None and 'numberOfCpus' not in already_processed:
            already_processed.add('numberOfCpus')
            outfile.write(' numberOfCpus="%s"' % self.gds_format_integer(self.numberOfCpus, input_name='numberOfCpus'))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.hardwareVersion is not None and 'hardwareVersion' not in already_processed:
            already_processed.add('hardwareVersion')
            outfile.write(' hardwareVersion="%s"' % self.gds_format_integer(self.hardwareVersion, input_name='hardwareVersion'))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.guestOs is not None and 'guestOs' not in already_processed:
            already_processed.add('guestOs')
            outfile.write(' guestOs=%s' % (self.gds_format_string(quote_attrib(self.guestOs).encode(ExternalEncoding), input_name='guestOs'), ))
        if self.isInMaintenanceMode is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            outfile.write(' isInMaintenanceMode="%s"' % self.gds_format_boolean(self.isInMaintenanceMode, input_name='isInMaintenanceMode'))
        if self.isVAppTemplate is not None and 'isVAppTemplate' not in already_processed:
            already_processed.add('isVAppTemplate')
            outfile.write(' isVAppTemplate="%s"' % self.gds_format_boolean(self.isVAppTemplate, input_name='isVAppTemplate'))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            outfile.write(' isDeleted="%s"' % self.gds_format_boolean(self.isDeleted, input_name='isDeleted'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            outfile.write(' catalogName=%s' % (self.gds_format_string(quote_attrib(self.catalogName).encode(ExternalEncoding), input_name='catalogName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultVMRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultVMRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultVMRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.containerName is not None and 'containerName' not in already_processed:
            already_processed.add('containerName')
            showIndent(outfile, level)
            outfile.write('containerName="%s",\n' % (self.containerName,))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            showIndent(outfile, level)
            outfile.write('isDeployed=%s,\n' % (self.isDeployed,))
        if self.container is not None and 'container' not in already_processed:
            already_processed.add('container')
            showIndent(outfile, level)
            outfile.write('container="%s",\n' % (self.container,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            showIndent(outfile, level)
            outfile.write('storageProfileName="%s",\n' % (self.storageProfileName,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.memoryMB is not None and 'memoryMB' not in already_processed:
            already_processed.add('memoryMB')
            showIndent(outfile, level)
            outfile.write('memoryMB=%d,\n' % (self.memoryMB,))
        if self.numberOfCpus is not None and 'numberOfCpus' not in already_processed:
            already_processed.add('numberOfCpus')
            showIndent(outfile, level)
            outfile.write('numberOfCpus=%d,\n' % (self.numberOfCpus,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.hardwareVersion is not None and 'hardwareVersion' not in already_processed:
            already_processed.add('hardwareVersion')
            showIndent(outfile, level)
            outfile.write('hardwareVersion=%d,\n' % (self.hardwareVersion,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.guestOs is not None and 'guestOs' not in already_processed:
            already_processed.add('guestOs')
            showIndent(outfile, level)
            outfile.write('guestOs="%s",\n' % (self.guestOs,))
        if self.isInMaintenanceMode is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            showIndent(outfile, level)
            outfile.write('isInMaintenanceMode=%s,\n' % (self.isInMaintenanceMode,))
        if self.isVAppTemplate is not None and 'isVAppTemplate' not in already_processed:
            already_processed.add('isVAppTemplate')
            showIndent(outfile, level)
            outfile.write('isVAppTemplate=%s,\n' % (self.isVAppTemplate,))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            showIndent(outfile, level)
            outfile.write('isDeleted=%s,\n' % (self.isDeleted,))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            showIndent(outfile, level)
            outfile.write('catalogName="%s",\n' % (self.catalogName,))
        super(QueryResultVMRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultVMRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('containerName', node)
        if value is not None and 'containerName' not in already_processed:
            already_processed.add('containerName')
            self.containerName = value
        value = find_attr_value_('isDeployed', node)
        if value is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            if value in ('true', '1'):
                self.isDeployed = True
            elif value in ('false', '0'):
                self.isDeployed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('container', node)
        if value is not None and 'container' not in already_processed:
            already_processed.add('container')
            self.container = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('storageProfileName', node)
        if value is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            self.storageProfileName = value
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('memoryMB', node)
        if value is not None and 'memoryMB' not in already_processed:
            already_processed.add('memoryMB')
            try:
                self.memoryMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfCpus', node)
        if value is not None and 'numberOfCpus' not in already_processed:
            already_processed.add('numberOfCpus')
            try:
                self.numberOfCpus = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('hardwareVersion', node)
        if value is not None and 'hardwareVersion' not in already_processed:
            already_processed.add('hardwareVersion')
            try:
                self.hardwareVersion = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('guestOs', node)
        if value is not None and 'guestOs' not in already_processed:
            already_processed.add('guestOs')
            self.guestOs = value
        value = find_attr_value_('isInMaintenanceMode', node)
        if value is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            if value in ('true', '1'):
                self.isInMaintenanceMode = True
            elif value in ('false', '0'):
                self.isInMaintenanceMode = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isVAppTemplate', node)
        if value is not None and 'isVAppTemplate' not in already_processed:
            already_processed.add('isVAppTemplate')
            if value in ('true', '1'):
                self.isVAppTemplate = True
            elif value in ('false', '0'):
                self.isVAppTemplate = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isDeleted', node)
        if value is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            if value in ('true', '1'):
                self.isDeleted = True
            elif value in ('false', '0'):
                self.isDeleted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('catalogName', node)
        if value is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            self.catalogName = value
        super(QueryResultVMRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultVMRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultVMRecordType


class QueryResultOrgNetworkRecordType(QueryResultRecordType):
    """1.5 Type for a single orgNetwork query result in records format.
    1.5none The name of this network. 1.5none Network pool reference
    or id 1.5none Network pool name 1.5none Organization reference
    or id 1.5none IP scope object 1.5none True if this network's IP
    scope is inherited. 1.5none Gateway 1.5none Netmask 1.5none
    Primary DNS 1.5none Secondary DNS 1.5none DNS suffix 1.5none
    True if this entity is busy"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, isBusy=None, dns2=None, dns1=None, netmask=None, isIpScopeInherited=None, networkPoolName=None, dnsSuffix=None, org=None, networkPool=None, gateway=None, ipScopeId=None):
        self.original_tagname_ = None
        super(QueryResultOrgNetworkRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.isBusy = _cast(bool, isBusy)
        self.dns2 = _cast(None, dns2)
        self.dns1 = _cast(None, dns1)
        self.netmask = _cast(None, netmask)
        self.isIpScopeInherited = _cast(bool, isIpScopeInherited)
        self.networkPoolName = _cast(None, networkPoolName)
        self.dnsSuffix = _cast(None, dnsSuffix)
        self.org = _cast(None, org)
        self.networkPool = _cast(None, networkPool)
        self.gateway = _cast(None, gateway)
        self.ipScopeId = _cast(None, ipScopeId)
    def factory(*args_, **kwargs_):
        if QueryResultOrgNetworkRecordType.subclass:
            return QueryResultOrgNetworkRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultOrgNetworkRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_dns2(self): return self.dns2
    def set_dns2(self, dns2): self.dns2 = dns2
    def get_dns1(self): return self.dns1
    def set_dns1(self, dns1): self.dns1 = dns1
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_isIpScopeInherited(self): return self.isIpScopeInherited
    def set_isIpScopeInherited(self, isIpScopeInherited): self.isIpScopeInherited = isIpScopeInherited
    def get_networkPoolName(self): return self.networkPoolName
    def set_networkPoolName(self, networkPoolName): self.networkPoolName = networkPoolName
    def get_dnsSuffix(self): return self.dnsSuffix
    def set_dnsSuffix(self, dnsSuffix): self.dnsSuffix = dnsSuffix
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_networkPool(self): return self.networkPool
    def set_networkPool(self, networkPool): self.networkPool = networkPool
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_ipScopeId(self): return self.ipScopeId
    def set_ipScopeId(self, ipScopeId): self.ipScopeId = ipScopeId
    def hasContent_(self):
        if (
            super(QueryResultOrgNetworkRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultOrgNetworkRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgNetworkRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultOrgNetworkRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultOrgNetworkRecordType'):
        super(QueryResultOrgNetworkRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgNetworkRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            outfile.write(' dns2=%s' % (self.gds_format_string(quote_attrib(self.dns2).encode(ExternalEncoding), input_name='dns2'), ))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            outfile.write(' dns1=%s' % (self.gds_format_string(quote_attrib(self.dns1).encode(ExternalEncoding), input_name='dns1'), ))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            outfile.write(' netmask=%s' % (self.gds_format_string(quote_attrib(self.netmask).encode(ExternalEncoding), input_name='netmask'), ))
        if self.isIpScopeInherited is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            outfile.write(' isIpScopeInherited="%s"' % self.gds_format_boolean(self.isIpScopeInherited, input_name='isIpScopeInherited'))
        if self.networkPoolName is not None and 'networkPoolName' not in already_processed:
            already_processed.add('networkPoolName')
            outfile.write(' networkPoolName=%s' % (self.gds_format_string(quote_attrib(self.networkPoolName).encode(ExternalEncoding), input_name='networkPoolName'), ))
        if self.dnsSuffix is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            outfile.write(' dnsSuffix=%s' % (self.gds_format_string(quote_attrib(self.dnsSuffix).encode(ExternalEncoding), input_name='dnsSuffix'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.networkPool is not None and 'networkPool' not in already_processed:
            already_processed.add('networkPool')
            outfile.write(' networkPool=%s' % (self.gds_format_string(quote_attrib(self.networkPool).encode(ExternalEncoding), input_name='networkPool'), ))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            outfile.write(' gateway=%s' % (self.gds_format_string(quote_attrib(self.gateway).encode(ExternalEncoding), input_name='gateway'), ))
        if self.ipScopeId is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            outfile.write(' ipScopeId=%s' % (self.gds_format_string(quote_attrib(self.ipScopeId).encode(ExternalEncoding), input_name='ipScopeId'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultOrgNetworkRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultOrgNetworkRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultOrgNetworkRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            showIndent(outfile, level)
            outfile.write('dns2="%s",\n' % (self.dns2,))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            showIndent(outfile, level)
            outfile.write('dns1="%s",\n' % (self.dns1,))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            showIndent(outfile, level)
            outfile.write('netmask="%s",\n' % (self.netmask,))
        if self.isIpScopeInherited is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            showIndent(outfile, level)
            outfile.write('isIpScopeInherited=%s,\n' % (self.isIpScopeInherited,))
        if self.networkPoolName is not None and 'networkPoolName' not in already_processed:
            already_processed.add('networkPoolName')
            showIndent(outfile, level)
            outfile.write('networkPoolName="%s",\n' % (self.networkPoolName,))
        if self.dnsSuffix is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            showIndent(outfile, level)
            outfile.write('dnsSuffix="%s",\n' % (self.dnsSuffix,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.networkPool is not None and 'networkPool' not in already_processed:
            already_processed.add('networkPool')
            showIndent(outfile, level)
            outfile.write('networkPool="%s",\n' % (self.networkPool,))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            showIndent(outfile, level)
            outfile.write('gateway="%s",\n' % (self.gateway,))
        if self.ipScopeId is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            showIndent(outfile, level)
            outfile.write('ipScopeId="%s",\n' % (self.ipScopeId,))
        super(QueryResultOrgNetworkRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultOrgNetworkRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('dns2', node)
        if value is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            self.dns2 = value
        value = find_attr_value_('dns1', node)
        if value is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            self.dns1 = value
        value = find_attr_value_('netmask', node)
        if value is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            self.netmask = value
        value = find_attr_value_('isIpScopeInherited', node)
        if value is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            if value in ('true', '1'):
                self.isIpScopeInherited = True
            elif value in ('false', '0'):
                self.isIpScopeInherited = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('networkPoolName', node)
        if value is not None and 'networkPoolName' not in already_processed:
            already_processed.add('networkPoolName')
            self.networkPoolName = value
        value = find_attr_value_('dnsSuffix', node)
        if value is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            self.dnsSuffix = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('networkPool', node)
        if value is not None and 'networkPool' not in already_processed:
            already_processed.add('networkPool')
            self.networkPool = value
        value = find_attr_value_('gateway', node)
        if value is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            self.gateway = value
        value = find_attr_value_('ipScopeId', node)
        if value is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            self.ipScopeId = value
        super(QueryResultOrgNetworkRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultOrgNetworkRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultOrgNetworkRecordType


class QueryResultAdminOrgNetworkRecordType(QueryResultRecordType):
    """1.55.1 Type for a single adminOrgNetwork query result in records
    format. 1.5none The name of this network. 1.5none Organization
    name 1.5none Network pool reference or id 1.5none Network pool
    name 1.5none Organization reference or id 1.5none IP scope
    object 1.5none True if this network's IP scope is inherited.
    1.5none Gateway 1.5none Netmask 1.5none Primary DNS 1.5none
    Secondary DNS 1.5none True if this entity is busy"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, orgName=None, dns2=None, dns1=None, netmask=None, isIpScopeInherited=None, networkPoolName=None, isBusy=None, org=None, networkPool=None, gateway=None, ipScopeId=None):
        self.original_tagname_ = None
        super(QueryResultAdminOrgNetworkRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.orgName = _cast(None, orgName)
        self.dns2 = _cast(None, dns2)
        self.dns1 = _cast(None, dns1)
        self.netmask = _cast(None, netmask)
        self.isIpScopeInherited = _cast(bool, isIpScopeInherited)
        self.networkPoolName = _cast(None, networkPoolName)
        self.isBusy = _cast(bool, isBusy)
        self.org = _cast(None, org)
        self.networkPool = _cast(None, networkPool)
        self.gateway = _cast(None, gateway)
        self.ipScopeId = _cast(None, ipScopeId)
    def factory(*args_, **kwargs_):
        if QueryResultAdminOrgNetworkRecordType.subclass:
            return QueryResultAdminOrgNetworkRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminOrgNetworkRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_orgName(self): return self.orgName
    def set_orgName(self, orgName): self.orgName = orgName
    def get_dns2(self): return self.dns2
    def set_dns2(self, dns2): self.dns2 = dns2
    def get_dns1(self): return self.dns1
    def set_dns1(self, dns1): self.dns1 = dns1
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_isIpScopeInherited(self): return self.isIpScopeInherited
    def set_isIpScopeInherited(self, isIpScopeInherited): self.isIpScopeInherited = isIpScopeInherited
    def get_networkPoolName(self): return self.networkPoolName
    def set_networkPoolName(self, networkPoolName): self.networkPoolName = networkPoolName
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_networkPool(self): return self.networkPool
    def set_networkPool(self, networkPool): self.networkPool = networkPool
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_ipScopeId(self): return self.ipScopeId
    def set_ipScopeId(self, ipScopeId): self.ipScopeId = ipScopeId
    def hasContent_(self):
        if (
            super(QueryResultAdminOrgNetworkRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminOrgNetworkRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminOrgNetworkRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminOrgNetworkRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminOrgNetworkRecordType'):
        super(QueryResultAdminOrgNetworkRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminOrgNetworkRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            outfile.write(' orgName=%s' % (self.gds_format_string(quote_attrib(self.orgName).encode(ExternalEncoding), input_name='orgName'), ))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            outfile.write(' dns2=%s' % (self.gds_format_string(quote_attrib(self.dns2).encode(ExternalEncoding), input_name='dns2'), ))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            outfile.write(' dns1=%s' % (self.gds_format_string(quote_attrib(self.dns1).encode(ExternalEncoding), input_name='dns1'), ))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            outfile.write(' netmask=%s' % (self.gds_format_string(quote_attrib(self.netmask).encode(ExternalEncoding), input_name='netmask'), ))
        if self.isIpScopeInherited is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            outfile.write(' isIpScopeInherited="%s"' % self.gds_format_boolean(self.isIpScopeInherited, input_name='isIpScopeInherited'))
        if self.networkPoolName is not None and 'networkPoolName' not in already_processed:
            already_processed.add('networkPoolName')
            outfile.write(' networkPoolName=%s' % (self.gds_format_string(quote_attrib(self.networkPoolName).encode(ExternalEncoding), input_name='networkPoolName'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.networkPool is not None and 'networkPool' not in already_processed:
            already_processed.add('networkPool')
            outfile.write(' networkPool=%s' % (self.gds_format_string(quote_attrib(self.networkPool).encode(ExternalEncoding), input_name='networkPool'), ))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            outfile.write(' gateway=%s' % (self.gds_format_string(quote_attrib(self.gateway).encode(ExternalEncoding), input_name='gateway'), ))
        if self.ipScopeId is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            outfile.write(' ipScopeId=%s' % (self.gds_format_string(quote_attrib(self.ipScopeId).encode(ExternalEncoding), input_name='ipScopeId'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminOrgNetworkRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminOrgNetworkRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminOrgNetworkRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            showIndent(outfile, level)
            outfile.write('orgName="%s",\n' % (self.orgName,))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            showIndent(outfile, level)
            outfile.write('dns2="%s",\n' % (self.dns2,))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            showIndent(outfile, level)
            outfile.write('dns1="%s",\n' % (self.dns1,))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            showIndent(outfile, level)
            outfile.write('netmask="%s",\n' % (self.netmask,))
        if self.isIpScopeInherited is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            showIndent(outfile, level)
            outfile.write('isIpScopeInherited=%s,\n' % (self.isIpScopeInherited,))
        if self.networkPoolName is not None and 'networkPoolName' not in already_processed:
            already_processed.add('networkPoolName')
            showIndent(outfile, level)
            outfile.write('networkPoolName="%s",\n' % (self.networkPoolName,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.networkPool is not None and 'networkPool' not in already_processed:
            already_processed.add('networkPool')
            showIndent(outfile, level)
            outfile.write('networkPool="%s",\n' % (self.networkPool,))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            showIndent(outfile, level)
            outfile.write('gateway="%s",\n' % (self.gateway,))
        if self.ipScopeId is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            showIndent(outfile, level)
            outfile.write('ipScopeId="%s",\n' % (self.ipScopeId,))
        super(QueryResultAdminOrgNetworkRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminOrgNetworkRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('orgName', node)
        if value is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            self.orgName = value
        value = find_attr_value_('dns2', node)
        if value is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            self.dns2 = value
        value = find_attr_value_('dns1', node)
        if value is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            self.dns1 = value
        value = find_attr_value_('netmask', node)
        if value is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            self.netmask = value
        value = find_attr_value_('isIpScopeInherited', node)
        if value is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            if value in ('true', '1'):
                self.isIpScopeInherited = True
            elif value in ('false', '0'):
                self.isIpScopeInherited = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('networkPoolName', node)
        if value is not None and 'networkPoolName' not in already_processed:
            already_processed.add('networkPoolName')
            self.networkPoolName = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('networkPool', node)
        if value is not None and 'networkPool' not in already_processed:
            already_processed.add('networkPool')
            self.networkPool = value
        value = find_attr_value_('gateway', node)
        if value is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            self.gateway = value
        value = find_attr_value_('ipScopeId', node)
        if value is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            self.ipScopeId = value
        super(QueryResultAdminOrgNetworkRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminOrgNetworkRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminOrgNetworkRecordType


class QueryResultVAppNetworkRecordType(QueryResultRecordType):
    """1.5 Type for a single vAppNetwork query result in records format.
    1.5none The name of this network. 1.5none IP scope object
    1.5none True if this network's IP scope is inherited. 1.5none
    Gateway 1.5none Netmask 1.5none Primary DNS 1.5none Secondary
    DNS 1.5none DNS suffix 1.5none VApp reference or id 1.5none Vapp
    name 1.5none True if this entity is busy"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, vAppName=None, dns2=None, dns1=None, isIpScopeInherited=None, netmask=None, dnsSuffix=None, isBusy=None, vApp=None, gateway=None, ipScopeId=None):
        self.original_tagname_ = None
        super(QueryResultVAppNetworkRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.vAppName = _cast(None, vAppName)
        self.dns2 = _cast(None, dns2)
        self.dns1 = _cast(None, dns1)
        self.isIpScopeInherited = _cast(bool, isIpScopeInherited)
        self.netmask = _cast(None, netmask)
        self.dnsSuffix = _cast(None, dnsSuffix)
        self.isBusy = _cast(bool, isBusy)
        self.vApp = _cast(None, vApp)
        self.gateway = _cast(None, gateway)
        self.ipScopeId = _cast(None, ipScopeId)
    def factory(*args_, **kwargs_):
        if QueryResultVAppNetworkRecordType.subclass:
            return QueryResultVAppNetworkRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultVAppNetworkRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_vAppName(self): return self.vAppName
    def set_vAppName(self, vAppName): self.vAppName = vAppName
    def get_dns2(self): return self.dns2
    def set_dns2(self, dns2): self.dns2 = dns2
    def get_dns1(self): return self.dns1
    def set_dns1(self, dns1): self.dns1 = dns1
    def get_isIpScopeInherited(self): return self.isIpScopeInherited
    def set_isIpScopeInherited(self, isIpScopeInherited): self.isIpScopeInherited = isIpScopeInherited
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_dnsSuffix(self): return self.dnsSuffix
    def set_dnsSuffix(self, dnsSuffix): self.dnsSuffix = dnsSuffix
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_vApp(self): return self.vApp
    def set_vApp(self, vApp): self.vApp = vApp
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_ipScopeId(self): return self.ipScopeId
    def set_ipScopeId(self, ipScopeId): self.ipScopeId = ipScopeId
    def hasContent_(self):
        if (
            super(QueryResultVAppNetworkRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultVAppNetworkRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVAppNetworkRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultVAppNetworkRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultVAppNetworkRecordType'):
        super(QueryResultVAppNetworkRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVAppNetworkRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.vAppName is not None and 'vAppName' not in already_processed:
            already_processed.add('vAppName')
            outfile.write(' vAppName=%s' % (self.gds_format_string(quote_attrib(self.vAppName).encode(ExternalEncoding), input_name='vAppName'), ))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            outfile.write(' dns2=%s' % (self.gds_format_string(quote_attrib(self.dns2).encode(ExternalEncoding), input_name='dns2'), ))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            outfile.write(' dns1=%s' % (self.gds_format_string(quote_attrib(self.dns1).encode(ExternalEncoding), input_name='dns1'), ))
        if self.isIpScopeInherited is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            outfile.write(' isIpScopeInherited="%s"' % self.gds_format_boolean(self.isIpScopeInherited, input_name='isIpScopeInherited'))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            outfile.write(' netmask=%s' % (self.gds_format_string(quote_attrib(self.netmask).encode(ExternalEncoding), input_name='netmask'), ))
        if self.dnsSuffix is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            outfile.write(' dnsSuffix=%s' % (self.gds_format_string(quote_attrib(self.dnsSuffix).encode(ExternalEncoding), input_name='dnsSuffix'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.vApp is not None and 'vApp' not in already_processed:
            already_processed.add('vApp')
            outfile.write(' vApp=%s' % (self.gds_format_string(quote_attrib(self.vApp).encode(ExternalEncoding), input_name='vApp'), ))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            outfile.write(' gateway=%s' % (self.gds_format_string(quote_attrib(self.gateway).encode(ExternalEncoding), input_name='gateway'), ))
        if self.ipScopeId is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            outfile.write(' ipScopeId=%s' % (self.gds_format_string(quote_attrib(self.ipScopeId).encode(ExternalEncoding), input_name='ipScopeId'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultVAppNetworkRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultVAppNetworkRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultVAppNetworkRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.vAppName is not None and 'vAppName' not in already_processed:
            already_processed.add('vAppName')
            showIndent(outfile, level)
            outfile.write('vAppName="%s",\n' % (self.vAppName,))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            showIndent(outfile, level)
            outfile.write('dns2="%s",\n' % (self.dns2,))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            showIndent(outfile, level)
            outfile.write('dns1="%s",\n' % (self.dns1,))
        if self.isIpScopeInherited is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            showIndent(outfile, level)
            outfile.write('isIpScopeInherited=%s,\n' % (self.isIpScopeInherited,))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            showIndent(outfile, level)
            outfile.write('netmask="%s",\n' % (self.netmask,))
        if self.dnsSuffix is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            showIndent(outfile, level)
            outfile.write('dnsSuffix="%s",\n' % (self.dnsSuffix,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.vApp is not None and 'vApp' not in already_processed:
            already_processed.add('vApp')
            showIndent(outfile, level)
            outfile.write('vApp="%s",\n' % (self.vApp,))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            showIndent(outfile, level)
            outfile.write('gateway="%s",\n' % (self.gateway,))
        if self.ipScopeId is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            showIndent(outfile, level)
            outfile.write('ipScopeId="%s",\n' % (self.ipScopeId,))
        super(QueryResultVAppNetworkRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultVAppNetworkRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('vAppName', node)
        if value is not None and 'vAppName' not in already_processed:
            already_processed.add('vAppName')
            self.vAppName = value
        value = find_attr_value_('dns2', node)
        if value is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            self.dns2 = value
        value = find_attr_value_('dns1', node)
        if value is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            self.dns1 = value
        value = find_attr_value_('isIpScopeInherited', node)
        if value is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            if value in ('true', '1'):
                self.isIpScopeInherited = True
            elif value in ('false', '0'):
                self.isIpScopeInherited = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('netmask', node)
        if value is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            self.netmask = value
        value = find_attr_value_('dnsSuffix', node)
        if value is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            self.dnsSuffix = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vApp', node)
        if value is not None and 'vApp' not in already_processed:
            already_processed.add('vApp')
            self.vApp = value
        value = find_attr_value_('gateway', node)
        if value is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            self.gateway = value
        value = find_attr_value_('ipScopeId', node)
        if value is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            self.ipScopeId = value
        super(QueryResultVAppNetworkRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultVAppNetworkRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultVAppNetworkRecordType


class QueryResultCatalogRecordType(QueryResultRecordType):
    """1.5 Type for a single catalog query result in records format.
    1.5none The name of this catalog. 1.5none True if this catalog
    is published. 1.5none True if this catalog is shared. 1.5none
    Creation date 1.5none Organization name 1.5none Owner name
    1.5none Number of vApp templates 1.5none Number of media 1.5none
    Owner reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, numberOfVAppTemplates=None, orgName=None, isPublished=None, ownerName=None, numberOfMedia=None, owner=None, creationDate=None, isShared=None):
        self.original_tagname_ = None
        super(QueryResultCatalogRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.numberOfVAppTemplates = _cast(int, numberOfVAppTemplates)
        self.orgName = _cast(None, orgName)
        self.isPublished = _cast(bool, isPublished)
        self.ownerName = _cast(None, ownerName)
        self.numberOfMedia = _cast(int, numberOfMedia)
        self.owner = _cast(None, owner)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.isShared = _cast(bool, isShared)
    def factory(*args_, **kwargs_):
        if QueryResultCatalogRecordType.subclass:
            return QueryResultCatalogRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultCatalogRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_numberOfVAppTemplates(self): return self.numberOfVAppTemplates
    def set_numberOfVAppTemplates(self, numberOfVAppTemplates): self.numberOfVAppTemplates = numberOfVAppTemplates
    def get_orgName(self): return self.orgName
    def set_orgName(self, orgName): self.orgName = orgName
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_numberOfMedia(self): return self.numberOfMedia
    def set_numberOfMedia(self, numberOfMedia): self.numberOfMedia = numberOfMedia
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_isShared(self): return self.isShared
    def set_isShared(self, isShared): self.isShared = isShared
    def hasContent_(self):
        if (
            super(QueryResultCatalogRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultCatalogRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultCatalogRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultCatalogRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultCatalogRecordType'):
        super(QueryResultCatalogRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultCatalogRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.numberOfVAppTemplates is not None and 'numberOfVAppTemplates' not in already_processed:
            already_processed.add('numberOfVAppTemplates')
            outfile.write(' numberOfVAppTemplates="%s"' % self.gds_format_integer(self.numberOfVAppTemplates, input_name='numberOfVAppTemplates'))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            outfile.write(' orgName=%s' % (self.gds_format_string(quote_attrib(self.orgName).encode(ExternalEncoding), input_name='orgName'), ))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.numberOfMedia is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            outfile.write(' numberOfMedia="%s"' % self.gds_format_integer(self.numberOfMedia, input_name='numberOfMedia'))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(' owner=%s' % (self.gds_format_string(quote_attrib(self.owner).encode(ExternalEncoding), input_name='owner'), ))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isShared is not None and 'isShared' not in already_processed:
            already_processed.add('isShared')
            outfile.write(' isShared="%s"' % self.gds_format_boolean(self.isShared, input_name='isShared'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultCatalogRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultCatalogRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultCatalogRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.numberOfVAppTemplates is not None and 'numberOfVAppTemplates' not in already_processed:
            already_processed.add('numberOfVAppTemplates')
            showIndent(outfile, level)
            outfile.write('numberOfVAppTemplates=%d,\n' % (self.numberOfVAppTemplates,))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            showIndent(outfile, level)
            outfile.write('orgName="%s",\n' % (self.orgName,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.numberOfMedia is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            showIndent(outfile, level)
            outfile.write('numberOfMedia=%d,\n' % (self.numberOfMedia,))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            showIndent(outfile, level)
            outfile.write('owner="%s",\n' % (self.owner,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isShared is not None and 'isShared' not in already_processed:
            already_processed.add('isShared')
            showIndent(outfile, level)
            outfile.write('isShared=%s,\n' % (self.isShared,))
        super(QueryResultCatalogRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultCatalogRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('numberOfVAppTemplates', node)
        if value is not None and 'numberOfVAppTemplates' not in already_processed:
            already_processed.add('numberOfVAppTemplates')
            try:
                self.numberOfVAppTemplates = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('orgName', node)
        if value is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            self.orgName = value
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('numberOfMedia', node)
        if value is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            try:
                self.numberOfMedia = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('isShared', node)
        if value is not None and 'isShared' not in already_processed:
            already_processed.add('isShared')
            if value in ('true', '1'):
                self.isShared = True
            elif value in ('false', '0'):
                self.isShared = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(QueryResultCatalogRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultCatalogRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultCatalogRecordType


class QueryResultAdminVdcRecordType(QueryResultRecordType):
    """1.5 Type for a single adminOrgVdc query result in records format.
    1.5none The name of this VDC. 1.5none True if this entity is
    enabled 1.5none CPU allocation in Mhz 1.5none CPU limit in Mhz
    1.5none CPU used in Mhz 1.5none Memory allocation in MB 1.5none
    Memory limit in MB 1.5none Memory used in MB 1.55.1none Storage
    allocation in MB 1.5none Storage limit in MB 1.5none Storage
    used in MB 1.5none Provider VDC name 1.5none Provider VDC
    reference or id 1.5none Organization name 1.5none Organization
    reference or id 1.5none Number of vApps 1.5none Number of media
    5.1none Number of disks 1.5none Number of vApp templates
    1.55.1none True if this VDC is used exclusively to support
    vShield Edge devices. 1.5none True if this entity is busy
    1.5none Status 1.5none Network pool reference or id 5.1none
    Number of storage profiles"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, numberOfStorageProfiles=None, memoryUsedMB=None, orgName=None, isSystemVdc=None, storageAllocationMB=None, numberOfVAppTemplates=None, isEnabled=None, cpuLimitMhz=None, memoryAllocationMB=None, isBusy=None, providerVdcName=None, cpuUsedMhz=None, networkPool=None, status=None, memoryLimitMB=None, providerVdc=None, numberOfVApps=None, org=None, storageUsedMB=None, name=None, numberOfDisks=None, storageLimitMB=None, numberOfMedia=None, cpuAllocationMhz=None):
        self.original_tagname_ = None
        super(QueryResultAdminVdcRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.numberOfStorageProfiles = _cast(int, numberOfStorageProfiles)
        self.memoryUsedMB = _cast(int, memoryUsedMB)
        self.orgName = _cast(None, orgName)
        self.isSystemVdc = _cast(bool, isSystemVdc)
        self.storageAllocationMB = _cast(int, storageAllocationMB)
        self.numberOfVAppTemplates = _cast(int, numberOfVAppTemplates)
        self.isEnabled = _cast(bool, isEnabled)
        self.cpuLimitMhz = _cast(int, cpuLimitMhz)
        self.memoryAllocationMB = _cast(int, memoryAllocationMB)
        self.isBusy = _cast(bool, isBusy)
        self.providerVdcName = _cast(None, providerVdcName)
        self.cpuUsedMhz = _cast(int, cpuUsedMhz)
        self.networkPool = _cast(None, networkPool)
        self.status = _cast(None, status)
        self.memoryLimitMB = _cast(int, memoryLimitMB)
        self.providerVdc = _cast(None, providerVdc)
        self.numberOfVApps = _cast(int, numberOfVApps)
        self.org = _cast(None, org)
        self.storageUsedMB = _cast(int, storageUsedMB)
        self.name = _cast(None, name)
        self.numberOfDisks = _cast(int, numberOfDisks)
        self.storageLimitMB = _cast(int, storageLimitMB)
        self.numberOfMedia = _cast(int, numberOfMedia)
        self.cpuAllocationMhz = _cast(int, cpuAllocationMhz)
    def factory(*args_, **kwargs_):
        if QueryResultAdminVdcRecordType.subclass:
            return QueryResultAdminVdcRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminVdcRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_numberOfStorageProfiles(self): return self.numberOfStorageProfiles
    def set_numberOfStorageProfiles(self, numberOfStorageProfiles): self.numberOfStorageProfiles = numberOfStorageProfiles
    def get_memoryUsedMB(self): return self.memoryUsedMB
    def set_memoryUsedMB(self, memoryUsedMB): self.memoryUsedMB = memoryUsedMB
    def get_orgName(self): return self.orgName
    def set_orgName(self, orgName): self.orgName = orgName
    def get_isSystemVdc(self): return self.isSystemVdc
    def set_isSystemVdc(self, isSystemVdc): self.isSystemVdc = isSystemVdc
    def get_storageAllocationMB(self): return self.storageAllocationMB
    def set_storageAllocationMB(self, storageAllocationMB): self.storageAllocationMB = storageAllocationMB
    def get_numberOfVAppTemplates(self): return self.numberOfVAppTemplates
    def set_numberOfVAppTemplates(self, numberOfVAppTemplates): self.numberOfVAppTemplates = numberOfVAppTemplates
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_cpuLimitMhz(self): return self.cpuLimitMhz
    def set_cpuLimitMhz(self, cpuLimitMhz): self.cpuLimitMhz = cpuLimitMhz
    def get_memoryAllocationMB(self): return self.memoryAllocationMB
    def set_memoryAllocationMB(self, memoryAllocationMB): self.memoryAllocationMB = memoryAllocationMB
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_providerVdcName(self): return self.providerVdcName
    def set_providerVdcName(self, providerVdcName): self.providerVdcName = providerVdcName
    def get_cpuUsedMhz(self): return self.cpuUsedMhz
    def set_cpuUsedMhz(self, cpuUsedMhz): self.cpuUsedMhz = cpuUsedMhz
    def get_networkPool(self): return self.networkPool
    def set_networkPool(self, networkPool): self.networkPool = networkPool
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_memoryLimitMB(self): return self.memoryLimitMB
    def set_memoryLimitMB(self, memoryLimitMB): self.memoryLimitMB = memoryLimitMB
    def get_providerVdc(self): return self.providerVdc
    def set_providerVdc(self, providerVdc): self.providerVdc = providerVdc
    def get_numberOfVApps(self): return self.numberOfVApps
    def set_numberOfVApps(self, numberOfVApps): self.numberOfVApps = numberOfVApps
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_storageUsedMB(self): return self.storageUsedMB
    def set_storageUsedMB(self, storageUsedMB): self.storageUsedMB = storageUsedMB
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_numberOfDisks(self): return self.numberOfDisks
    def set_numberOfDisks(self, numberOfDisks): self.numberOfDisks = numberOfDisks
    def get_storageLimitMB(self): return self.storageLimitMB
    def set_storageLimitMB(self, storageLimitMB): self.storageLimitMB = storageLimitMB
    def get_numberOfMedia(self): return self.numberOfMedia
    def set_numberOfMedia(self, numberOfMedia): self.numberOfMedia = numberOfMedia
    def get_cpuAllocationMhz(self): return self.cpuAllocationMhz
    def set_cpuAllocationMhz(self, cpuAllocationMhz): self.cpuAllocationMhz = cpuAllocationMhz
    def hasContent_(self):
        if (
            super(QueryResultAdminVdcRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminVdcRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVdcRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminVdcRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminVdcRecordType'):
        super(QueryResultAdminVdcRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVdcRecordType')
        if self.numberOfStorageProfiles is not None and 'numberOfStorageProfiles' not in already_processed:
            already_processed.add('numberOfStorageProfiles')
            outfile.write(' numberOfStorageProfiles="%s"' % self.gds_format_integer(self.numberOfStorageProfiles, input_name='numberOfStorageProfiles'))
        if self.memoryUsedMB is not None and 'memoryUsedMB' not in already_processed:
            already_processed.add('memoryUsedMB')
            outfile.write(' memoryUsedMB="%s"' % self.gds_format_integer(self.memoryUsedMB, input_name='memoryUsedMB'))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            outfile.write(' orgName=%s' % (self.gds_format_string(quote_attrib(self.orgName).encode(ExternalEncoding), input_name='orgName'), ))
        if self.isSystemVdc is not None and 'isSystemVdc' not in already_processed:
            already_processed.add('isSystemVdc')
            outfile.write(' isSystemVdc="%s"' % self.gds_format_boolean(self.isSystemVdc, input_name='isSystemVdc'))
        if self.storageAllocationMB is not None and 'storageAllocationMB' not in already_processed:
            already_processed.add('storageAllocationMB')
            outfile.write(' storageAllocationMB="%s"' % self.gds_format_integer(self.storageAllocationMB, input_name='storageAllocationMB'))
        if self.numberOfVAppTemplates is not None and 'numberOfVAppTemplates' not in already_processed:
            already_processed.add('numberOfVAppTemplates')
            outfile.write(' numberOfVAppTemplates="%s"' % self.gds_format_integer(self.numberOfVAppTemplates, input_name='numberOfVAppTemplates'))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.cpuLimitMhz is not None and 'cpuLimitMhz' not in already_processed:
            already_processed.add('cpuLimitMhz')
            outfile.write(' cpuLimitMhz="%s"' % self.gds_format_integer(self.cpuLimitMhz, input_name='cpuLimitMhz'))
        if self.memoryAllocationMB is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            outfile.write(' memoryAllocationMB="%s"' % self.gds_format_integer(self.memoryAllocationMB, input_name='memoryAllocationMB'))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.providerVdcName is not None and 'providerVdcName' not in already_processed:
            already_processed.add('providerVdcName')
            outfile.write(' providerVdcName=%s' % (self.gds_format_string(quote_attrib(self.providerVdcName).encode(ExternalEncoding), input_name='providerVdcName'), ))
        if self.cpuUsedMhz is not None and 'cpuUsedMhz' not in already_processed:
            already_processed.add('cpuUsedMhz')
            outfile.write(' cpuUsedMhz="%s"' % self.gds_format_integer(self.cpuUsedMhz, input_name='cpuUsedMhz'))
        if self.networkPool is not None and 'networkPool' not in already_processed:
            already_processed.add('networkPool')
            outfile.write(' networkPool=%s' % (self.gds_format_string(quote_attrib(self.networkPool).encode(ExternalEncoding), input_name='networkPool'), ))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.memoryLimitMB is not None and 'memoryLimitMB' not in already_processed:
            already_processed.add('memoryLimitMB')
            outfile.write(' memoryLimitMB="%s"' % self.gds_format_integer(self.memoryLimitMB, input_name='memoryLimitMB'))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            outfile.write(' providerVdc=%s' % (self.gds_format_string(quote_attrib(self.providerVdc).encode(ExternalEncoding), input_name='providerVdc'), ))
        if self.numberOfVApps is not None and 'numberOfVApps' not in already_processed:
            already_processed.add('numberOfVApps')
            outfile.write(' numberOfVApps="%s"' % self.gds_format_integer(self.numberOfVApps, input_name='numberOfVApps'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            outfile.write(' storageUsedMB="%s"' % self.gds_format_integer(self.storageUsedMB, input_name='storageUsedMB'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.numberOfDisks is not None and 'numberOfDisks' not in already_processed:
            already_processed.add('numberOfDisks')
            outfile.write(' numberOfDisks="%s"' % self.gds_format_integer(self.numberOfDisks, input_name='numberOfDisks'))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            outfile.write(' storageLimitMB="%s"' % self.gds_format_integer(self.storageLimitMB, input_name='storageLimitMB'))
        if self.numberOfMedia is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            outfile.write(' numberOfMedia="%s"' % self.gds_format_integer(self.numberOfMedia, input_name='numberOfMedia'))
        if self.cpuAllocationMhz is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            outfile.write(' cpuAllocationMhz="%s"' % self.gds_format_integer(self.cpuAllocationMhz, input_name='cpuAllocationMhz'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminVdcRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminVdcRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminVdcRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.numberOfStorageProfiles is not None and 'numberOfStorageProfiles' not in already_processed:
            already_processed.add('numberOfStorageProfiles')
            showIndent(outfile, level)
            outfile.write('numberOfStorageProfiles=%d,\n' % (self.numberOfStorageProfiles,))
        if self.memoryUsedMB is not None and 'memoryUsedMB' not in already_processed:
            already_processed.add('memoryUsedMB')
            showIndent(outfile, level)
            outfile.write('memoryUsedMB=%d,\n' % (self.memoryUsedMB,))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            showIndent(outfile, level)
            outfile.write('orgName="%s",\n' % (self.orgName,))
        if self.isSystemVdc is not None and 'isSystemVdc' not in already_processed:
            already_processed.add('isSystemVdc')
            showIndent(outfile, level)
            outfile.write('isSystemVdc=%s,\n' % (self.isSystemVdc,))
        if self.storageAllocationMB is not None and 'storageAllocationMB' not in already_processed:
            already_processed.add('storageAllocationMB')
            showIndent(outfile, level)
            outfile.write('storageAllocationMB=%d,\n' % (self.storageAllocationMB,))
        if self.numberOfVAppTemplates is not None and 'numberOfVAppTemplates' not in already_processed:
            already_processed.add('numberOfVAppTemplates')
            showIndent(outfile, level)
            outfile.write('numberOfVAppTemplates=%d,\n' % (self.numberOfVAppTemplates,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.cpuLimitMhz is not None and 'cpuLimitMhz' not in already_processed:
            already_processed.add('cpuLimitMhz')
            showIndent(outfile, level)
            outfile.write('cpuLimitMhz=%d,\n' % (self.cpuLimitMhz,))
        if self.memoryAllocationMB is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            showIndent(outfile, level)
            outfile.write('memoryAllocationMB=%d,\n' % (self.memoryAllocationMB,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.providerVdcName is not None and 'providerVdcName' not in already_processed:
            already_processed.add('providerVdcName')
            showIndent(outfile, level)
            outfile.write('providerVdcName="%s",\n' % (self.providerVdcName,))
        if self.cpuUsedMhz is not None and 'cpuUsedMhz' not in already_processed:
            already_processed.add('cpuUsedMhz')
            showIndent(outfile, level)
            outfile.write('cpuUsedMhz=%d,\n' % (self.cpuUsedMhz,))
        if self.networkPool is not None and 'networkPool' not in already_processed:
            already_processed.add('networkPool')
            showIndent(outfile, level)
            outfile.write('networkPool="%s",\n' % (self.networkPool,))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.memoryLimitMB is not None and 'memoryLimitMB' not in already_processed:
            already_processed.add('memoryLimitMB')
            showIndent(outfile, level)
            outfile.write('memoryLimitMB=%d,\n' % (self.memoryLimitMB,))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            showIndent(outfile, level)
            outfile.write('providerVdc="%s",\n' % (self.providerVdc,))
        if self.numberOfVApps is not None and 'numberOfVApps' not in already_processed:
            already_processed.add('numberOfVApps')
            showIndent(outfile, level)
            outfile.write('numberOfVApps=%d,\n' % (self.numberOfVApps,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            showIndent(outfile, level)
            outfile.write('storageUsedMB=%d,\n' % (self.storageUsedMB,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.numberOfDisks is not None and 'numberOfDisks' not in already_processed:
            already_processed.add('numberOfDisks')
            showIndent(outfile, level)
            outfile.write('numberOfDisks=%d,\n' % (self.numberOfDisks,))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            showIndent(outfile, level)
            outfile.write('storageLimitMB=%d,\n' % (self.storageLimitMB,))
        if self.numberOfMedia is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            showIndent(outfile, level)
            outfile.write('numberOfMedia=%d,\n' % (self.numberOfMedia,))
        if self.cpuAllocationMhz is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            showIndent(outfile, level)
            outfile.write('cpuAllocationMhz=%d,\n' % (self.cpuAllocationMhz,))
        super(QueryResultAdminVdcRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminVdcRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('numberOfStorageProfiles', node)
        if value is not None and 'numberOfStorageProfiles' not in already_processed:
            already_processed.add('numberOfStorageProfiles')
            try:
                self.numberOfStorageProfiles = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('memoryUsedMB', node)
        if value is not None and 'memoryUsedMB' not in already_processed:
            already_processed.add('memoryUsedMB')
            try:
                self.memoryUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('orgName', node)
        if value is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            self.orgName = value
        value = find_attr_value_('isSystemVdc', node)
        if value is not None and 'isSystemVdc' not in already_processed:
            already_processed.add('isSystemVdc')
            if value in ('true', '1'):
                self.isSystemVdc = True
            elif value in ('false', '0'):
                self.isSystemVdc = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('storageAllocationMB', node)
        if value is not None and 'storageAllocationMB' not in already_processed:
            already_processed.add('storageAllocationMB')
            try:
                self.storageAllocationMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfVAppTemplates', node)
        if value is not None and 'numberOfVAppTemplates' not in already_processed:
            already_processed.add('numberOfVAppTemplates')
            try:
                self.numberOfVAppTemplates = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('cpuLimitMhz', node)
        if value is not None and 'cpuLimitMhz' not in already_processed:
            already_processed.add('cpuLimitMhz')
            try:
                self.cpuLimitMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('memoryAllocationMB', node)
        if value is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            try:
                self.memoryAllocationMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('providerVdcName', node)
        if value is not None and 'providerVdcName' not in already_processed:
            already_processed.add('providerVdcName')
            self.providerVdcName = value
        value = find_attr_value_('cpuUsedMhz', node)
        if value is not None and 'cpuUsedMhz' not in already_processed:
            already_processed.add('cpuUsedMhz')
            try:
                self.cpuUsedMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('networkPool', node)
        if value is not None and 'networkPool' not in already_processed:
            already_processed.add('networkPool')
            self.networkPool = value
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('memoryLimitMB', node)
        if value is not None and 'memoryLimitMB' not in already_processed:
            already_processed.add('memoryLimitMB')
            try:
                self.memoryLimitMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('providerVdc', node)
        if value is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            self.providerVdc = value
        value = find_attr_value_('numberOfVApps', node)
        if value is not None and 'numberOfVApps' not in already_processed:
            already_processed.add('numberOfVApps')
            try:
                self.numberOfVApps = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('storageUsedMB', node)
        if value is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            try:
                self.storageUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('numberOfDisks', node)
        if value is not None and 'numberOfDisks' not in already_processed:
            already_processed.add('numberOfDisks')
            try:
                self.numberOfDisks = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storageLimitMB', node)
        if value is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            try:
                self.storageLimitMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfMedia', node)
        if value is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            try:
                self.numberOfMedia = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('cpuAllocationMhz', node)
        if value is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            try:
                self.cpuAllocationMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(QueryResultAdminVdcRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminVdcRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminVdcRecordType


class QueryResultVMWProviderVdcRecordType(QueryResultRecordType):
    """1.5 Type for a single providerVdc query result in records format.
    1.5none The name of this Provider VDC. 1.5none True if this
    entity is enabled 1.5none True if this entity is deleted
    1.55.5none vCpu rating in Mhz 1.5none CPU used in Mhz 1.5none
    CPU limit in Mhz 1.5none CPU allocation in Mhz 1.5none Memory
    used in MB 1.5none Memory limit in MB 1.5none Memory allocation
    in MB 1.5none Storage used in MB 1.5none Storage limit in MB
    1.5none Storage allocation in MB 1.5none Number of datastores
    1.5none Number of vDCs 1.5none True if this entity is busy
    1.5none Status 5.1none Number of storage profiles"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, numberOfVdcs=None, status=None, numberOfStorageProfiles=None, vcpuRatingMhz=None, storageUsedMB=None, name=None, memoryLimitMB=None, isEnabled=None, storageLimitMB=None, numberOfDatastores=None, cpuLimitMhz=None, memoryUsedMB=None, cpuUsedMhz=None, cpuAllocationMhz=None, memoryAllocationMB=None, isBusy=None, storageAllocationMB=None, isDeleted=None):
        self.original_tagname_ = None
        super(QueryResultVMWProviderVdcRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.numberOfVdcs = _cast(int, numberOfVdcs)
        self.status = _cast(None, status)
        self.numberOfStorageProfiles = _cast(int, numberOfStorageProfiles)
        self.vcpuRatingMhz = _cast(int, vcpuRatingMhz)
        self.storageUsedMB = _cast(int, storageUsedMB)
        self.name = _cast(None, name)
        self.memoryLimitMB = _cast(int, memoryLimitMB)
        self.isEnabled = _cast(bool, isEnabled)
        self.storageLimitMB = _cast(int, storageLimitMB)
        self.numberOfDatastores = _cast(int, numberOfDatastores)
        self.cpuLimitMhz = _cast(int, cpuLimitMhz)
        self.memoryUsedMB = _cast(int, memoryUsedMB)
        self.cpuUsedMhz = _cast(int, cpuUsedMhz)
        self.cpuAllocationMhz = _cast(int, cpuAllocationMhz)
        self.memoryAllocationMB = _cast(int, memoryAllocationMB)
        self.isBusy = _cast(bool, isBusy)
        self.storageAllocationMB = _cast(int, storageAllocationMB)
        self.isDeleted = _cast(bool, isDeleted)
    def factory(*args_, **kwargs_):
        if QueryResultVMWProviderVdcRecordType.subclass:
            return QueryResultVMWProviderVdcRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultVMWProviderVdcRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_numberOfVdcs(self): return self.numberOfVdcs
    def set_numberOfVdcs(self, numberOfVdcs): self.numberOfVdcs = numberOfVdcs
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_numberOfStorageProfiles(self): return self.numberOfStorageProfiles
    def set_numberOfStorageProfiles(self, numberOfStorageProfiles): self.numberOfStorageProfiles = numberOfStorageProfiles
    def get_vcpuRatingMhz(self): return self.vcpuRatingMhz
    def set_vcpuRatingMhz(self, vcpuRatingMhz): self.vcpuRatingMhz = vcpuRatingMhz
    def get_storageUsedMB(self): return self.storageUsedMB
    def set_storageUsedMB(self, storageUsedMB): self.storageUsedMB = storageUsedMB
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_memoryLimitMB(self): return self.memoryLimitMB
    def set_memoryLimitMB(self, memoryLimitMB): self.memoryLimitMB = memoryLimitMB
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_storageLimitMB(self): return self.storageLimitMB
    def set_storageLimitMB(self, storageLimitMB): self.storageLimitMB = storageLimitMB
    def get_numberOfDatastores(self): return self.numberOfDatastores
    def set_numberOfDatastores(self, numberOfDatastores): self.numberOfDatastores = numberOfDatastores
    def get_cpuLimitMhz(self): return self.cpuLimitMhz
    def set_cpuLimitMhz(self, cpuLimitMhz): self.cpuLimitMhz = cpuLimitMhz
    def get_memoryUsedMB(self): return self.memoryUsedMB
    def set_memoryUsedMB(self, memoryUsedMB): self.memoryUsedMB = memoryUsedMB
    def get_cpuUsedMhz(self): return self.cpuUsedMhz
    def set_cpuUsedMhz(self, cpuUsedMhz): self.cpuUsedMhz = cpuUsedMhz
    def get_cpuAllocationMhz(self): return self.cpuAllocationMhz
    def set_cpuAllocationMhz(self, cpuAllocationMhz): self.cpuAllocationMhz = cpuAllocationMhz
    def get_memoryAllocationMB(self): return self.memoryAllocationMB
    def set_memoryAllocationMB(self, memoryAllocationMB): self.memoryAllocationMB = memoryAllocationMB
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_storageAllocationMB(self): return self.storageAllocationMB
    def set_storageAllocationMB(self, storageAllocationMB): self.storageAllocationMB = storageAllocationMB
    def get_isDeleted(self): return self.isDeleted
    def set_isDeleted(self, isDeleted): self.isDeleted = isDeleted
    def hasContent_(self):
        if (
            super(QueryResultVMWProviderVdcRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultVMWProviderVdcRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVMWProviderVdcRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultVMWProviderVdcRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultVMWProviderVdcRecordType'):
        super(QueryResultVMWProviderVdcRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVMWProviderVdcRecordType')
        if self.numberOfVdcs is not None and 'numberOfVdcs' not in already_processed:
            already_processed.add('numberOfVdcs')
            outfile.write(' numberOfVdcs="%s"' % self.gds_format_integer(self.numberOfVdcs, input_name='numberOfVdcs'))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.numberOfStorageProfiles is not None and 'numberOfStorageProfiles' not in already_processed:
            already_processed.add('numberOfStorageProfiles')
            outfile.write(' numberOfStorageProfiles="%s"' % self.gds_format_integer(self.numberOfStorageProfiles, input_name='numberOfStorageProfiles'))
        if self.vcpuRatingMhz is not None and 'vcpuRatingMhz' not in already_processed:
            already_processed.add('vcpuRatingMhz')
            outfile.write(' vcpuRatingMhz="%s"' % self.gds_format_integer(self.vcpuRatingMhz, input_name='vcpuRatingMhz'))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            outfile.write(' storageUsedMB="%s"' % self.gds_format_integer(self.storageUsedMB, input_name='storageUsedMB'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.memoryLimitMB is not None and 'memoryLimitMB' not in already_processed:
            already_processed.add('memoryLimitMB')
            outfile.write(' memoryLimitMB="%s"' % self.gds_format_integer(self.memoryLimitMB, input_name='memoryLimitMB'))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            outfile.write(' storageLimitMB="%s"' % self.gds_format_integer(self.storageLimitMB, input_name='storageLimitMB'))
        if self.numberOfDatastores is not None and 'numberOfDatastores' not in already_processed:
            already_processed.add('numberOfDatastores')
            outfile.write(' numberOfDatastores="%s"' % self.gds_format_integer(self.numberOfDatastores, input_name='numberOfDatastores'))
        if self.cpuLimitMhz is not None and 'cpuLimitMhz' not in already_processed:
            already_processed.add('cpuLimitMhz')
            outfile.write(' cpuLimitMhz="%s"' % self.gds_format_integer(self.cpuLimitMhz, input_name='cpuLimitMhz'))
        if self.memoryUsedMB is not None and 'memoryUsedMB' not in already_processed:
            already_processed.add('memoryUsedMB')
            outfile.write(' memoryUsedMB="%s"' % self.gds_format_integer(self.memoryUsedMB, input_name='memoryUsedMB'))
        if self.cpuUsedMhz is not None and 'cpuUsedMhz' not in already_processed:
            already_processed.add('cpuUsedMhz')
            outfile.write(' cpuUsedMhz="%s"' % self.gds_format_integer(self.cpuUsedMhz, input_name='cpuUsedMhz'))
        if self.cpuAllocationMhz is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            outfile.write(' cpuAllocationMhz="%s"' % self.gds_format_integer(self.cpuAllocationMhz, input_name='cpuAllocationMhz'))
        if self.memoryAllocationMB is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            outfile.write(' memoryAllocationMB="%s"' % self.gds_format_integer(self.memoryAllocationMB, input_name='memoryAllocationMB'))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.storageAllocationMB is not None and 'storageAllocationMB' not in already_processed:
            already_processed.add('storageAllocationMB')
            outfile.write(' storageAllocationMB="%s"' % self.gds_format_integer(self.storageAllocationMB, input_name='storageAllocationMB'))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            outfile.write(' isDeleted="%s"' % self.gds_format_boolean(self.isDeleted, input_name='isDeleted'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultVMWProviderVdcRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultVMWProviderVdcRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultVMWProviderVdcRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.numberOfVdcs is not None and 'numberOfVdcs' not in already_processed:
            already_processed.add('numberOfVdcs')
            showIndent(outfile, level)
            outfile.write('numberOfVdcs=%d,\n' % (self.numberOfVdcs,))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.numberOfStorageProfiles is not None and 'numberOfStorageProfiles' not in already_processed:
            already_processed.add('numberOfStorageProfiles')
            showIndent(outfile, level)
            outfile.write('numberOfStorageProfiles=%d,\n' % (self.numberOfStorageProfiles,))
        if self.vcpuRatingMhz is not None and 'vcpuRatingMhz' not in already_processed:
            already_processed.add('vcpuRatingMhz')
            showIndent(outfile, level)
            outfile.write('vcpuRatingMhz=%d,\n' % (self.vcpuRatingMhz,))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            showIndent(outfile, level)
            outfile.write('storageUsedMB=%d,\n' % (self.storageUsedMB,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.memoryLimitMB is not None and 'memoryLimitMB' not in already_processed:
            already_processed.add('memoryLimitMB')
            showIndent(outfile, level)
            outfile.write('memoryLimitMB=%d,\n' % (self.memoryLimitMB,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            showIndent(outfile, level)
            outfile.write('storageLimitMB=%d,\n' % (self.storageLimitMB,))
        if self.numberOfDatastores is not None and 'numberOfDatastores' not in already_processed:
            already_processed.add('numberOfDatastores')
            showIndent(outfile, level)
            outfile.write('numberOfDatastores=%d,\n' % (self.numberOfDatastores,))
        if self.cpuLimitMhz is not None and 'cpuLimitMhz' not in already_processed:
            already_processed.add('cpuLimitMhz')
            showIndent(outfile, level)
            outfile.write('cpuLimitMhz=%d,\n' % (self.cpuLimitMhz,))
        if self.memoryUsedMB is not None and 'memoryUsedMB' not in already_processed:
            already_processed.add('memoryUsedMB')
            showIndent(outfile, level)
            outfile.write('memoryUsedMB=%d,\n' % (self.memoryUsedMB,))
        if self.cpuUsedMhz is not None and 'cpuUsedMhz' not in already_processed:
            already_processed.add('cpuUsedMhz')
            showIndent(outfile, level)
            outfile.write('cpuUsedMhz=%d,\n' % (self.cpuUsedMhz,))
        if self.cpuAllocationMhz is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            showIndent(outfile, level)
            outfile.write('cpuAllocationMhz=%d,\n' % (self.cpuAllocationMhz,))
        if self.memoryAllocationMB is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            showIndent(outfile, level)
            outfile.write('memoryAllocationMB=%d,\n' % (self.memoryAllocationMB,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.storageAllocationMB is not None and 'storageAllocationMB' not in already_processed:
            already_processed.add('storageAllocationMB')
            showIndent(outfile, level)
            outfile.write('storageAllocationMB=%d,\n' % (self.storageAllocationMB,))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            showIndent(outfile, level)
            outfile.write('isDeleted=%s,\n' % (self.isDeleted,))
        super(QueryResultVMWProviderVdcRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultVMWProviderVdcRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('numberOfVdcs', node)
        if value is not None and 'numberOfVdcs' not in already_processed:
            already_processed.add('numberOfVdcs')
            try:
                self.numberOfVdcs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('numberOfStorageProfiles', node)
        if value is not None and 'numberOfStorageProfiles' not in already_processed:
            already_processed.add('numberOfStorageProfiles')
            try:
                self.numberOfStorageProfiles = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('vcpuRatingMhz', node)
        if value is not None and 'vcpuRatingMhz' not in already_processed:
            already_processed.add('vcpuRatingMhz')
            try:
                self.vcpuRatingMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storageUsedMB', node)
        if value is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            try:
                self.storageUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('memoryLimitMB', node)
        if value is not None and 'memoryLimitMB' not in already_processed:
            already_processed.add('memoryLimitMB')
            try:
                self.memoryLimitMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('storageLimitMB', node)
        if value is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            try:
                self.storageLimitMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfDatastores', node)
        if value is not None and 'numberOfDatastores' not in already_processed:
            already_processed.add('numberOfDatastores')
            try:
                self.numberOfDatastores = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('cpuLimitMhz', node)
        if value is not None and 'cpuLimitMhz' not in already_processed:
            already_processed.add('cpuLimitMhz')
            try:
                self.cpuLimitMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('memoryUsedMB', node)
        if value is not None and 'memoryUsedMB' not in already_processed:
            already_processed.add('memoryUsedMB')
            try:
                self.memoryUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('cpuUsedMhz', node)
        if value is not None and 'cpuUsedMhz' not in already_processed:
            already_processed.add('cpuUsedMhz')
            try:
                self.cpuUsedMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('cpuAllocationMhz', node)
        if value is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            try:
                self.cpuAllocationMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('memoryAllocationMB', node)
        if value is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            try:
                self.memoryAllocationMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('storageAllocationMB', node)
        if value is not None and 'storageAllocationMB' not in already_processed:
            already_processed.add('storageAllocationMB')
            try:
                self.storageAllocationMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isDeleted', node)
        if value is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            if value in ('true', '1'):
                self.isDeleted = True
            elif value in ('false', '0'):
                self.isDeleted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(QueryResultVMWProviderVdcRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultVMWProviderVdcRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultVMWProviderVdcRecordType


class QueryResultNetworkRecordType(QueryResultRecordType):
    """1.5 Type for a single externalNetwork query result in records
    format. 1.5none The name of this network. 1.5none IP scope
    object of this network. 1.5none Gateway for the network 1.5none
    Netmask for the network 1.5none Primary DNS for the network
    1.5none Secondary DNS for the network 1.5none DNS suffix for the
    network 1.5none True if this entity is busy"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, dns2=None, dns1=None, netmask=None, dnsSuffix=None, isBusy=None, gateway=None, ipScopeId=None):
        self.original_tagname_ = None
        super(QueryResultNetworkRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.dns2 = _cast(None, dns2)
        self.dns1 = _cast(None, dns1)
        self.netmask = _cast(None, netmask)
        self.dnsSuffix = _cast(None, dnsSuffix)
        self.isBusy = _cast(bool, isBusy)
        self.gateway = _cast(None, gateway)
        self.ipScopeId = _cast(None, ipScopeId)
    def factory(*args_, **kwargs_):
        if QueryResultNetworkRecordType.subclass:
            return QueryResultNetworkRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultNetworkRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_dns2(self): return self.dns2
    def set_dns2(self, dns2): self.dns2 = dns2
    def get_dns1(self): return self.dns1
    def set_dns1(self, dns1): self.dns1 = dns1
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_dnsSuffix(self): return self.dnsSuffix
    def set_dnsSuffix(self, dnsSuffix): self.dnsSuffix = dnsSuffix
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_ipScopeId(self): return self.ipScopeId
    def set_ipScopeId(self, ipScopeId): self.ipScopeId = ipScopeId
    def hasContent_(self):
        if (
            super(QueryResultNetworkRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultNetworkRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultNetworkRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultNetworkRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultNetworkRecordType'):
        super(QueryResultNetworkRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultNetworkRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            outfile.write(' dns2=%s' % (self.gds_format_string(quote_attrib(self.dns2).encode(ExternalEncoding), input_name='dns2'), ))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            outfile.write(' dns1=%s' % (self.gds_format_string(quote_attrib(self.dns1).encode(ExternalEncoding), input_name='dns1'), ))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            outfile.write(' netmask=%s' % (self.gds_format_string(quote_attrib(self.netmask).encode(ExternalEncoding), input_name='netmask'), ))
        if self.dnsSuffix is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            outfile.write(' dnsSuffix=%s' % (self.gds_format_string(quote_attrib(self.dnsSuffix).encode(ExternalEncoding), input_name='dnsSuffix'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            outfile.write(' gateway=%s' % (self.gds_format_string(quote_attrib(self.gateway).encode(ExternalEncoding), input_name='gateway'), ))
        if self.ipScopeId is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            outfile.write(' ipScopeId=%s' % (self.gds_format_string(quote_attrib(self.ipScopeId).encode(ExternalEncoding), input_name='ipScopeId'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultNetworkRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultNetworkRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultNetworkRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            showIndent(outfile, level)
            outfile.write('dns2="%s",\n' % (self.dns2,))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            showIndent(outfile, level)
            outfile.write('dns1="%s",\n' % (self.dns1,))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            showIndent(outfile, level)
            outfile.write('netmask="%s",\n' % (self.netmask,))
        if self.dnsSuffix is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            showIndent(outfile, level)
            outfile.write('dnsSuffix="%s",\n' % (self.dnsSuffix,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            showIndent(outfile, level)
            outfile.write('gateway="%s",\n' % (self.gateway,))
        if self.ipScopeId is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            showIndent(outfile, level)
            outfile.write('ipScopeId="%s",\n' % (self.ipScopeId,))
        super(QueryResultNetworkRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultNetworkRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('dns2', node)
        if value is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            self.dns2 = value
        value = find_attr_value_('dns1', node)
        if value is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            self.dns1 = value
        value = find_attr_value_('netmask', node)
        if value is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            self.netmask = value
        value = find_attr_value_('dnsSuffix', node)
        if value is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            self.dnsSuffix = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('gateway', node)
        if value is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            self.gateway = value
        value = find_attr_value_('ipScopeId', node)
        if value is not None and 'ipScopeId' not in already_processed:
            already_processed.add('ipScopeId')
            self.ipScopeId = value
        super(QueryResultNetworkRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultNetworkRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultNetworkRecordType


class QueryResultGroupRecordType(QueryResultRecordType):
    """1.5 Type for a single group query result in records format. 1.5none
    The name of this group. 1.5none Role name 1.5none True if this
    entity is read-only. 5.1none Shows the identity provider type of
    the group"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isReadOnly=None, roleName=None, name=None, identityProviderType=None):
        self.original_tagname_ = None
        super(QueryResultGroupRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isReadOnly = _cast(bool, isReadOnly)
        self.roleName = _cast(None, roleName)
        self.name = _cast(None, name)
        self.identityProviderType = _cast(None, identityProviderType)
    def factory(*args_, **kwargs_):
        if QueryResultGroupRecordType.subclass:
            return QueryResultGroupRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultGroupRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isReadOnly(self): return self.isReadOnly
    def set_isReadOnly(self, isReadOnly): self.isReadOnly = isReadOnly
    def get_roleName(self): return self.roleName
    def set_roleName(self, roleName): self.roleName = roleName
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_identityProviderType(self): return self.identityProviderType
    def set_identityProviderType(self, identityProviderType): self.identityProviderType = identityProviderType
    def hasContent_(self):
        if (
            super(QueryResultGroupRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultGroupRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultGroupRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultGroupRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultGroupRecordType'):
        super(QueryResultGroupRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultGroupRecordType')
        if self.isReadOnly is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            outfile.write(' isReadOnly="%s"' % self.gds_format_boolean(self.isReadOnly, input_name='isReadOnly'))
        if self.roleName is not None and 'roleName' not in already_processed:
            already_processed.add('roleName')
            outfile.write(' roleName=%s' % (self.gds_format_string(quote_attrib(self.roleName).encode(ExternalEncoding), input_name='roleName'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.identityProviderType is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            outfile.write(' identityProviderType=%s' % (self.gds_format_string(quote_attrib(self.identityProviderType).encode(ExternalEncoding), input_name='identityProviderType'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultGroupRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultGroupRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultGroupRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isReadOnly is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            showIndent(outfile, level)
            outfile.write('isReadOnly=%s,\n' % (self.isReadOnly,))
        if self.roleName is not None and 'roleName' not in already_processed:
            already_processed.add('roleName')
            showIndent(outfile, level)
            outfile.write('roleName="%s",\n' % (self.roleName,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.identityProviderType is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            showIndent(outfile, level)
            outfile.write('identityProviderType="%s",\n' % (self.identityProviderType,))
        super(QueryResultGroupRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultGroupRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isReadOnly', node)
        if value is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            if value in ('true', '1'):
                self.isReadOnly = True
            elif value in ('false', '0'):
                self.isReadOnly = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('roleName', node)
        if value is not None and 'roleName' not in already_processed:
            already_processed.add('roleName')
            self.roleName = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('identityProviderType', node)
        if value is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            self.identityProviderType = value
        super(QueryResultGroupRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultGroupRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultGroupRecordType


class QueryResultUserRecordType(QueryResultRecordType):
    """1.5 Type for a single user query result in records format. 1.5none
    The name of this user. 1.5none The full name of this user.
    1.5none True if this entity is enabled 1.5none Number of
    deployed VMs 1.5none Deployed VM quota 1.5none Number of stored
    VMs 1.5none Stored VM Quota 1.5none If the identity provider
    type is INTEGRATED, true if the user was imported from LDAP
    5.1none Shows the identity provider type of the user"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isLdapUser=None, name=None, isEnabled=None, deployedVMQuota=None, storedVMQuota=None, numberOfStoredVMs=None, numberOfDeployedVMs=None, identityProviderType=None, fullName=None):
        self.original_tagname_ = None
        super(QueryResultUserRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isLdapUser = _cast(bool, isLdapUser)
        self.name = _cast(None, name)
        self.isEnabled = _cast(bool, isEnabled)
        self.deployedVMQuota = _cast(int, deployedVMQuota)
        self.storedVMQuota = _cast(int, storedVMQuota)
        self.numberOfStoredVMs = _cast(int, numberOfStoredVMs)
        self.numberOfDeployedVMs = _cast(int, numberOfDeployedVMs)
        self.identityProviderType = _cast(None, identityProviderType)
        self.fullName = _cast(None, fullName)
    def factory(*args_, **kwargs_):
        if QueryResultUserRecordType.subclass:
            return QueryResultUserRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultUserRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isLdapUser(self): return self.isLdapUser
    def set_isLdapUser(self, isLdapUser): self.isLdapUser = isLdapUser
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_deployedVMQuota(self): return self.deployedVMQuota
    def set_deployedVMQuota(self, deployedVMQuota): self.deployedVMQuota = deployedVMQuota
    def get_storedVMQuota(self): return self.storedVMQuota
    def set_storedVMQuota(self, storedVMQuota): self.storedVMQuota = storedVMQuota
    def get_numberOfStoredVMs(self): return self.numberOfStoredVMs
    def set_numberOfStoredVMs(self, numberOfStoredVMs): self.numberOfStoredVMs = numberOfStoredVMs
    def get_numberOfDeployedVMs(self): return self.numberOfDeployedVMs
    def set_numberOfDeployedVMs(self, numberOfDeployedVMs): self.numberOfDeployedVMs = numberOfDeployedVMs
    def get_identityProviderType(self): return self.identityProviderType
    def set_identityProviderType(self, identityProviderType): self.identityProviderType = identityProviderType
    def get_fullName(self): return self.fullName
    def set_fullName(self, fullName): self.fullName = fullName
    def hasContent_(self):
        if (
            super(QueryResultUserRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultUserRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultUserRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultUserRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultUserRecordType'):
        super(QueryResultUserRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultUserRecordType')
        if self.isLdapUser is not None and 'isLdapUser' not in already_processed:
            already_processed.add('isLdapUser')
            outfile.write(' isLdapUser="%s"' % self.gds_format_boolean(self.isLdapUser, input_name='isLdapUser'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.deployedVMQuota is not None and 'deployedVMQuota' not in already_processed:
            already_processed.add('deployedVMQuota')
            outfile.write(' deployedVMQuota="%s"' % self.gds_format_integer(self.deployedVMQuota, input_name='deployedVMQuota'))
        if self.storedVMQuota is not None and 'storedVMQuota' not in already_processed:
            already_processed.add('storedVMQuota')
            outfile.write(' storedVMQuota="%s"' % self.gds_format_integer(self.storedVMQuota, input_name='storedVMQuota'))
        if self.numberOfStoredVMs is not None and 'numberOfStoredVMs' not in already_processed:
            already_processed.add('numberOfStoredVMs')
            outfile.write(' numberOfStoredVMs="%s"' % self.gds_format_integer(self.numberOfStoredVMs, input_name='numberOfStoredVMs'))
        if self.numberOfDeployedVMs is not None and 'numberOfDeployedVMs' not in already_processed:
            already_processed.add('numberOfDeployedVMs')
            outfile.write(' numberOfDeployedVMs="%s"' % self.gds_format_integer(self.numberOfDeployedVMs, input_name='numberOfDeployedVMs'))
        if self.identityProviderType is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            outfile.write(' identityProviderType=%s' % (self.gds_format_string(quote_attrib(self.identityProviderType).encode(ExternalEncoding), input_name='identityProviderType'), ))
        if self.fullName is not None and 'fullName' not in already_processed:
            already_processed.add('fullName')
            outfile.write(' fullName=%s' % (self.gds_format_string(quote_attrib(self.fullName).encode(ExternalEncoding), input_name='fullName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultUserRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultUserRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultUserRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isLdapUser is not None and 'isLdapUser' not in already_processed:
            already_processed.add('isLdapUser')
            showIndent(outfile, level)
            outfile.write('isLdapUser=%s,\n' % (self.isLdapUser,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.deployedVMQuota is not None and 'deployedVMQuota' not in already_processed:
            already_processed.add('deployedVMQuota')
            showIndent(outfile, level)
            outfile.write('deployedVMQuota=%d,\n' % (self.deployedVMQuota,))
        if self.storedVMQuota is not None and 'storedVMQuota' not in already_processed:
            already_processed.add('storedVMQuota')
            showIndent(outfile, level)
            outfile.write('storedVMQuota=%d,\n' % (self.storedVMQuota,))
        if self.numberOfStoredVMs is not None and 'numberOfStoredVMs' not in already_processed:
            already_processed.add('numberOfStoredVMs')
            showIndent(outfile, level)
            outfile.write('numberOfStoredVMs=%d,\n' % (self.numberOfStoredVMs,))
        if self.numberOfDeployedVMs is not None and 'numberOfDeployedVMs' not in already_processed:
            already_processed.add('numberOfDeployedVMs')
            showIndent(outfile, level)
            outfile.write('numberOfDeployedVMs=%d,\n' % (self.numberOfDeployedVMs,))
        if self.identityProviderType is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            showIndent(outfile, level)
            outfile.write('identityProviderType="%s",\n' % (self.identityProviderType,))
        if self.fullName is not None and 'fullName' not in already_processed:
            already_processed.add('fullName')
            showIndent(outfile, level)
            outfile.write('fullName="%s",\n' % (self.fullName,))
        super(QueryResultUserRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultUserRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isLdapUser', node)
        if value is not None and 'isLdapUser' not in already_processed:
            already_processed.add('isLdapUser')
            if value in ('true', '1'):
                self.isLdapUser = True
            elif value in ('false', '0'):
                self.isLdapUser = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('deployedVMQuota', node)
        if value is not None and 'deployedVMQuota' not in already_processed:
            already_processed.add('deployedVMQuota')
            try:
                self.deployedVMQuota = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storedVMQuota', node)
        if value is not None and 'storedVMQuota' not in already_processed:
            already_processed.add('storedVMQuota')
            try:
                self.storedVMQuota = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfStoredVMs', node)
        if value is not None and 'numberOfStoredVMs' not in already_processed:
            already_processed.add('numberOfStoredVMs')
            try:
                self.numberOfStoredVMs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfDeployedVMs', node)
        if value is not None and 'numberOfDeployedVMs' not in already_processed:
            already_processed.add('numberOfDeployedVMs')
            try:
                self.numberOfDeployedVMs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('identityProviderType', node)
        if value is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            self.identityProviderType = value
        value = find_attr_value_('fullName', node)
        if value is not None and 'fullName' not in already_processed:
            already_processed.add('fullName')
            self.fullName = value
        super(QueryResultUserRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultUserRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultUserRecordType


class QueryResultStrandedUserRecordType(QueryResultRecordType):
    """1.5 Type for a single strandedUser query result in records format.
    1.5none The name of a stranded user. 1.5none The full name of
    this user. 1.5none True if this list is up to date. 1.5none
    Number of deployed VMs 1.5none Number of stored VMs 5.1none
    Organization reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, numberOfStoredVMs=None, numberOfDeployedVMs=None, isInSync=None, org=None, fullName=None):
        self.original_tagname_ = None
        super(QueryResultStrandedUserRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.numberOfStoredVMs = _cast(int, numberOfStoredVMs)
        self.numberOfDeployedVMs = _cast(int, numberOfDeployedVMs)
        self.isInSync = _cast(bool, isInSync)
        self.org = _cast(None, org)
        self.fullName = _cast(None, fullName)
    def factory(*args_, **kwargs_):
        if QueryResultStrandedUserRecordType.subclass:
            return QueryResultStrandedUserRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultStrandedUserRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_numberOfStoredVMs(self): return self.numberOfStoredVMs
    def set_numberOfStoredVMs(self, numberOfStoredVMs): self.numberOfStoredVMs = numberOfStoredVMs
    def get_numberOfDeployedVMs(self): return self.numberOfDeployedVMs
    def set_numberOfDeployedVMs(self, numberOfDeployedVMs): self.numberOfDeployedVMs = numberOfDeployedVMs
    def get_isInSync(self): return self.isInSync
    def set_isInSync(self, isInSync): self.isInSync = isInSync
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_fullName(self): return self.fullName
    def set_fullName(self, fullName): self.fullName = fullName
    def hasContent_(self):
        if (
            super(QueryResultStrandedUserRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultStrandedUserRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultStrandedUserRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultStrandedUserRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultStrandedUserRecordType'):
        super(QueryResultStrandedUserRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultStrandedUserRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.numberOfStoredVMs is not None and 'numberOfStoredVMs' not in already_processed:
            already_processed.add('numberOfStoredVMs')
            outfile.write(' numberOfStoredVMs="%s"' % self.gds_format_integer(self.numberOfStoredVMs, input_name='numberOfStoredVMs'))
        if self.numberOfDeployedVMs is not None and 'numberOfDeployedVMs' not in already_processed:
            already_processed.add('numberOfDeployedVMs')
            outfile.write(' numberOfDeployedVMs="%s"' % self.gds_format_integer(self.numberOfDeployedVMs, input_name='numberOfDeployedVMs'))
        if self.isInSync is not None and 'isInSync' not in already_processed:
            already_processed.add('isInSync')
            outfile.write(' isInSync="%s"' % self.gds_format_boolean(self.isInSync, input_name='isInSync'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.fullName is not None and 'fullName' not in already_processed:
            already_processed.add('fullName')
            outfile.write(' fullName=%s' % (self.gds_format_string(quote_attrib(self.fullName).encode(ExternalEncoding), input_name='fullName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultStrandedUserRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultStrandedUserRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultStrandedUserRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.numberOfStoredVMs is not None and 'numberOfStoredVMs' not in already_processed:
            already_processed.add('numberOfStoredVMs')
            showIndent(outfile, level)
            outfile.write('numberOfStoredVMs=%d,\n' % (self.numberOfStoredVMs,))
        if self.numberOfDeployedVMs is not None and 'numberOfDeployedVMs' not in already_processed:
            already_processed.add('numberOfDeployedVMs')
            showIndent(outfile, level)
            outfile.write('numberOfDeployedVMs=%d,\n' % (self.numberOfDeployedVMs,))
        if self.isInSync is not None and 'isInSync' not in already_processed:
            already_processed.add('isInSync')
            showIndent(outfile, level)
            outfile.write('isInSync=%s,\n' % (self.isInSync,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.fullName is not None and 'fullName' not in already_processed:
            already_processed.add('fullName')
            showIndent(outfile, level)
            outfile.write('fullName="%s",\n' % (self.fullName,))
        super(QueryResultStrandedUserRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultStrandedUserRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('numberOfStoredVMs', node)
        if value is not None and 'numberOfStoredVMs' not in already_processed:
            already_processed.add('numberOfStoredVMs')
            try:
                self.numberOfStoredVMs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfDeployedVMs', node)
        if value is not None and 'numberOfDeployedVMs' not in already_processed:
            already_processed.add('numberOfDeployedVMs')
            try:
                self.numberOfDeployedVMs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isInSync', node)
        if value is not None and 'isInSync' not in already_processed:
            already_processed.add('isInSync')
            if value in ('true', '1'):
                self.isInSync = True
            elif value in ('false', '0'):
                self.isInSync = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('fullName', node)
        if value is not None and 'fullName' not in already_processed:
            already_processed.add('fullName')
            self.fullName = value
        super(QueryResultStrandedUserRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultStrandedUserRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultStrandedUserRecordType


class QueryResultRoleRecordType(QueryResultRecordType):
    """1.5 Type for a single role query result in records format. 1.5none
    The name of this role. 1.5none True if this entity is read-only."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isReadOnly=None, name=None):
        self.original_tagname_ = None
        super(QueryResultRoleRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isReadOnly = _cast(bool, isReadOnly)
        self.name = _cast(None, name)
    def factory(*args_, **kwargs_):
        if QueryResultRoleRecordType.subclass:
            return QueryResultRoleRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultRoleRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isReadOnly(self): return self.isReadOnly
    def set_isReadOnly(self, isReadOnly): self.isReadOnly = isReadOnly
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            super(QueryResultRoleRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultRoleRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultRoleRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultRoleRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultRoleRecordType'):
        super(QueryResultRoleRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultRoleRecordType')
        if self.isReadOnly is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            outfile.write(' isReadOnly="%s"' % self.gds_format_boolean(self.isReadOnly, input_name='isReadOnly'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultRoleRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultRoleRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultRoleRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isReadOnly is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            showIndent(outfile, level)
            outfile.write('isReadOnly=%s,\n' % (self.isReadOnly,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(QueryResultRoleRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultRoleRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isReadOnly', node)
        if value is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            if value in ('true', '1'):
                self.isReadOnly = True
            elif value in ('false', '0'):
                self.isReadOnly = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(QueryResultRoleRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultRoleRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultRoleRecordType


class QueryResultAllocatedExternalAddressRecordType(QueryResultRecordType):
    """1.55.1 Type for a single allocatedExternalAddress query result in
    records format. 1.5none Network reference or id 1.5none
    Allocated IP address 1.5none Linked network reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, ipAddress=None, network=None, linkedNetwork=None):
        self.original_tagname_ = None
        super(QueryResultAllocatedExternalAddressRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.ipAddress = _cast(None, ipAddress)
        self.network = _cast(None, network)
        self.linkedNetwork = _cast(None, linkedNetwork)
    def factory(*args_, **kwargs_):
        if QueryResultAllocatedExternalAddressRecordType.subclass:
            return QueryResultAllocatedExternalAddressRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAllocatedExternalAddressRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ipAddress(self): return self.ipAddress
    def set_ipAddress(self, ipAddress): self.ipAddress = ipAddress
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_linkedNetwork(self): return self.linkedNetwork
    def set_linkedNetwork(self, linkedNetwork): self.linkedNetwork = linkedNetwork
    def hasContent_(self):
        if (
            super(QueryResultAllocatedExternalAddressRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAllocatedExternalAddressRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAllocatedExternalAddressRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAllocatedExternalAddressRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAllocatedExternalAddressRecordType'):
        super(QueryResultAllocatedExternalAddressRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAllocatedExternalAddressRecordType')
        if self.ipAddress is not None and 'ipAddress' not in already_processed:
            already_processed.add('ipAddress')
            outfile.write(' ipAddress=%s' % (self.gds_format_string(quote_attrib(self.ipAddress).encode(ExternalEncoding), input_name='ipAddress'), ))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            outfile.write(' network=%s' % (self.gds_format_string(quote_attrib(self.network).encode(ExternalEncoding), input_name='network'), ))
        if self.linkedNetwork is not None and 'linkedNetwork' not in already_processed:
            already_processed.add('linkedNetwork')
            outfile.write(' linkedNetwork=%s' % (self.gds_format_string(quote_attrib(self.linkedNetwork).encode(ExternalEncoding), input_name='linkedNetwork'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAllocatedExternalAddressRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAllocatedExternalAddressRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAllocatedExternalAddressRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ipAddress is not None and 'ipAddress' not in already_processed:
            already_processed.add('ipAddress')
            showIndent(outfile, level)
            outfile.write('ipAddress="%s",\n' % (self.ipAddress,))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            showIndent(outfile, level)
            outfile.write('network="%s",\n' % (self.network,))
        if self.linkedNetwork is not None and 'linkedNetwork' not in already_processed:
            already_processed.add('linkedNetwork')
            showIndent(outfile, level)
            outfile.write('linkedNetwork="%s",\n' % (self.linkedNetwork,))
        super(QueryResultAllocatedExternalAddressRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAllocatedExternalAddressRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ipAddress', node)
        if value is not None and 'ipAddress' not in already_processed:
            already_processed.add('ipAddress')
            self.ipAddress = value
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.add('network')
            self.network = value
        value = find_attr_value_('linkedNetwork', node)
        if value is not None and 'linkedNetwork' not in already_processed:
            already_processed.add('linkedNetwork')
            self.linkedNetwork = value
        super(QueryResultAllocatedExternalAddressRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAllocatedExternalAddressRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAllocatedExternalAddressRecordType


class QueryResultEventRecordType(QueryResultRecordType):
    """1.5 Type for a single event query result in records format. 1.5none
    Event type 1.5none Time stamp 1.5none Event status 1.5none User
    name 1.5none Organization name 1.5none Entity type 1.5none
    Entity name 5.1none Service name space 1.5none Entity reference
    or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, userName=None, orgName=None, eventType=None, entityName=None, entityType=None, entity=None, eventStatus=None, timeStamp=None, serviceNamespace=None):
        self.original_tagname_ = None
        super(QueryResultEventRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.userName = _cast(None, userName)
        self.orgName = _cast(None, orgName)
        self.eventType = _cast(None, eventType)
        self.entityName = _cast(None, entityName)
        self.entityType = _cast(None, entityType)
        self.entity = _cast(None, entity)
        self.eventStatus = _cast(int, eventStatus)
        if isinstance(timeStamp, basestring):
            initvalue_ = datetime_.datetime.strptime(timeStamp, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = timeStamp
        self.timeStamp = initvalue_
        self.serviceNamespace = _cast(None, serviceNamespace)
    def factory(*args_, **kwargs_):
        if QueryResultEventRecordType.subclass:
            return QueryResultEventRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultEventRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_userName(self): return self.userName
    def set_userName(self, userName): self.userName = userName
    def get_orgName(self): return self.orgName
    def set_orgName(self, orgName): self.orgName = orgName
    def get_eventType(self): return self.eventType
    def set_eventType(self, eventType): self.eventType = eventType
    def get_entityName(self): return self.entityName
    def set_entityName(self, entityName): self.entityName = entityName
    def get_entityType(self): return self.entityType
    def set_entityType(self, entityType): self.entityType = entityType
    def get_entity(self): return self.entity
    def set_entity(self, entity): self.entity = entity
    def get_eventStatus(self): return self.eventStatus
    def set_eventStatus(self, eventStatus): self.eventStatus = eventStatus
    def get_timeStamp(self): return self.timeStamp
    def set_timeStamp(self, timeStamp): self.timeStamp = timeStamp
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def hasContent_(self):
        if (
            super(QueryResultEventRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultEventRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultEventRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultEventRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultEventRecordType'):
        super(QueryResultEventRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultEventRecordType')
        if self.userName is not None and 'userName' not in already_processed:
            already_processed.add('userName')
            outfile.write(' userName=%s' % (self.gds_format_string(quote_attrib(self.userName).encode(ExternalEncoding), input_name='userName'), ))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            outfile.write(' orgName=%s' % (self.gds_format_string(quote_attrib(self.orgName).encode(ExternalEncoding), input_name='orgName'), ))
        if self.eventType is not None and 'eventType' not in already_processed:
            already_processed.add('eventType')
            outfile.write(' eventType=%s' % (self.gds_format_string(quote_attrib(self.eventType).encode(ExternalEncoding), input_name='eventType'), ))
        if self.entityName is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            outfile.write(' entityName=%s' % (self.gds_format_string(quote_attrib(self.entityName).encode(ExternalEncoding), input_name='entityName'), ))
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            outfile.write(' entityType=%s' % (self.gds_format_string(quote_attrib(self.entityType).encode(ExternalEncoding), input_name='entityType'), ))
        if self.entity is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            outfile.write(' entity=%s' % (self.gds_format_string(quote_attrib(self.entity).encode(ExternalEncoding), input_name='entity'), ))
        if self.eventStatus is not None and 'eventStatus' not in already_processed:
            already_processed.add('eventStatus')
            outfile.write(' eventStatus="%s"' % self.gds_format_integer(self.eventStatus, input_name='eventStatus'))
        if self.timeStamp is not None and 'timeStamp' not in already_processed:
            already_processed.add('timeStamp')
            outfile.write(' timeStamp="%s"' % self.gds_format_datetime(self.timeStamp, input_name='timeStamp'))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultEventRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultEventRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultEventRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.userName is not None and 'userName' not in already_processed:
            already_processed.add('userName')
            showIndent(outfile, level)
            outfile.write('userName="%s",\n' % (self.userName,))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            showIndent(outfile, level)
            outfile.write('orgName="%s",\n' % (self.orgName,))
        if self.eventType is not None and 'eventType' not in already_processed:
            already_processed.add('eventType')
            showIndent(outfile, level)
            outfile.write('eventType="%s",\n' % (self.eventType,))
        if self.entityName is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            showIndent(outfile, level)
            outfile.write('entityName="%s",\n' % (self.entityName,))
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            showIndent(outfile, level)
            outfile.write('entityType="%s",\n' % (self.entityType,))
        if self.entity is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            showIndent(outfile, level)
            outfile.write('entity="%s",\n' % (self.entity,))
        if self.eventStatus is not None and 'eventStatus' not in already_processed:
            already_processed.add('eventStatus')
            showIndent(outfile, level)
            outfile.write('eventStatus=%d,\n' % (self.eventStatus,))
        if self.timeStamp is not None and 'timeStamp' not in already_processed:
            already_processed.add('timeStamp')
            showIndent(outfile, level)
            outfile.write('timeStamp=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.timeStamp, input_name='timeStamp'))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        super(QueryResultEventRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultEventRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('userName', node)
        if value is not None and 'userName' not in already_processed:
            already_processed.add('userName')
            self.userName = value
        value = find_attr_value_('orgName', node)
        if value is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            self.orgName = value
        value = find_attr_value_('eventType', node)
        if value is not None and 'eventType' not in already_processed:
            already_processed.add('eventType')
            self.eventType = value
        value = find_attr_value_('entityName', node)
        if value is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            self.entityName = value
        value = find_attr_value_('entityType', node)
        if value is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            self.entityType = value
        value = find_attr_value_('entity', node)
        if value is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            self.entity = value
        value = find_attr_value_('eventStatus', node)
        if value is not None and 'eventStatus' not in already_processed:
            already_processed.add('eventStatus')
            try:
                self.eventStatus = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('timeStamp', node)
        if value is not None and 'timeStamp' not in already_processed:
            already_processed.add('timeStamp')
            try:
                self.timeStamp = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (timeStamp): %s' % exp)
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        super(QueryResultEventRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultEventRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultEventRecordType


class QueryResultResourcePoolRecordType(QueryResultRecordType):
    """1.5 Type for a single resourcePool query result in records format.
    1.5none The name of this resource pool. 1.5none Managed object
    reference 1.5none True if this entity is deleted 1.5none Virtual
    center reference or id 1.5none Vitual center name"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, moref=None, vc=None, vcName=None, name=None, isDeleted=None):
        self.original_tagname_ = None
        super(QueryResultResourcePoolRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.moref = _cast(None, moref)
        self.vc = _cast(None, vc)
        self.vcName = _cast(None, vcName)
        self.name = _cast(None, name)
        self.isDeleted = _cast(bool, isDeleted)
    def factory(*args_, **kwargs_):
        if QueryResultResourcePoolRecordType.subclass:
            return QueryResultResourcePoolRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultResourcePoolRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_moref(self): return self.moref
    def set_moref(self, moref): self.moref = moref
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_vcName(self): return self.vcName
    def set_vcName(self, vcName): self.vcName = vcName
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isDeleted(self): return self.isDeleted
    def set_isDeleted(self, isDeleted): self.isDeleted = isDeleted
    def hasContent_(self):
        if (
            super(QueryResultResourcePoolRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultResourcePoolRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultResourcePoolRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultResourcePoolRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultResourcePoolRecordType'):
        super(QueryResultResourcePoolRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultResourcePoolRecordType')
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            outfile.write(' moref=%s' % (self.gds_format_string(quote_attrib(self.moref).encode(ExternalEncoding), input_name='moref'), ))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            outfile.write(' vcName=%s' % (self.gds_format_string(quote_attrib(self.vcName).encode(ExternalEncoding), input_name='vcName'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            outfile.write(' isDeleted="%s"' % self.gds_format_boolean(self.isDeleted, input_name='isDeleted'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultResourcePoolRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultResourcePoolRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultResourcePoolRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            showIndent(outfile, level)
            outfile.write('moref="%s",\n' % (self.moref,))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            showIndent(outfile, level)
            outfile.write('vcName="%s",\n' % (self.vcName,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            showIndent(outfile, level)
            outfile.write('isDeleted=%s,\n' % (self.isDeleted,))
        super(QueryResultResourcePoolRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultResourcePoolRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('moref', node)
        if value is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            self.moref = value
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('vcName', node)
        if value is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            self.vcName = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isDeleted', node)
        if value is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            if value in ('true', '1'):
                self.isDeleted = True
            elif value in ('false', '0'):
                self.isDeleted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(QueryResultResourcePoolRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultResourcePoolRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultResourcePoolRecordType


class QueryResultDatastoreRecordType(QueryResultRecordType):
    """1.5 Type for a single datastore query result in records format.
    1.5none The name of this datastore. 1.5none Datastore type
    1.5none True if this entity is enabled 1.5none True if this
    entity is deleted 1.5none Storage used in MB 1.5none Storage in
    MB 1.5none Provisioned storage in MB 1.5none Requested storage
    in MB 1.5none Virtual center reference or id 1.5none Vitual
    center name 1.5none Managed object reference 1.5none Number of
    provider vDCs"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vc=None, storageUsedMB=None, name=None, isEnabled=None, requestedStorageMB=None, storageMB=None, moref=None, vcName=None, datastoreType=None, numberOfProviderVdcs=None, provisionedStorageMB=None, isDeleted=None):
        self.original_tagname_ = None
        super(QueryResultDatastoreRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vc = _cast(None, vc)
        self.storageUsedMB = _cast(int, storageUsedMB)
        self.name = _cast(None, name)
        self.isEnabled = _cast(bool, isEnabled)
        self.requestedStorageMB = _cast(int, requestedStorageMB)
        self.storageMB = _cast(int, storageMB)
        self.moref = _cast(None, moref)
        self.vcName = _cast(None, vcName)
        self.datastoreType = _cast(None, datastoreType)
        self.numberOfProviderVdcs = _cast(int, numberOfProviderVdcs)
        self.provisionedStorageMB = _cast(int, provisionedStorageMB)
        self.isDeleted = _cast(bool, isDeleted)
    def factory(*args_, **kwargs_):
        if QueryResultDatastoreRecordType.subclass:
            return QueryResultDatastoreRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultDatastoreRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_storageUsedMB(self): return self.storageUsedMB
    def set_storageUsedMB(self, storageUsedMB): self.storageUsedMB = storageUsedMB
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_requestedStorageMB(self): return self.requestedStorageMB
    def set_requestedStorageMB(self, requestedStorageMB): self.requestedStorageMB = requestedStorageMB
    def get_storageMB(self): return self.storageMB
    def set_storageMB(self, storageMB): self.storageMB = storageMB
    def get_moref(self): return self.moref
    def set_moref(self, moref): self.moref = moref
    def get_vcName(self): return self.vcName
    def set_vcName(self, vcName): self.vcName = vcName
    def get_datastoreType(self): return self.datastoreType
    def set_datastoreType(self, datastoreType): self.datastoreType = datastoreType
    def get_numberOfProviderVdcs(self): return self.numberOfProviderVdcs
    def set_numberOfProviderVdcs(self, numberOfProviderVdcs): self.numberOfProviderVdcs = numberOfProviderVdcs
    def get_provisionedStorageMB(self): return self.provisionedStorageMB
    def set_provisionedStorageMB(self, provisionedStorageMB): self.provisionedStorageMB = provisionedStorageMB
    def get_isDeleted(self): return self.isDeleted
    def set_isDeleted(self, isDeleted): self.isDeleted = isDeleted
    def hasContent_(self):
        if (
            super(QueryResultDatastoreRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultDatastoreRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultDatastoreRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultDatastoreRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultDatastoreRecordType'):
        super(QueryResultDatastoreRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultDatastoreRecordType')
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            outfile.write(' storageUsedMB="%s"' % self.gds_format_integer(self.storageUsedMB, input_name='storageUsedMB'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.requestedStorageMB is not None and 'requestedStorageMB' not in already_processed:
            already_processed.add('requestedStorageMB')
            outfile.write(' requestedStorageMB="%s"' % self.gds_format_integer(self.requestedStorageMB, input_name='requestedStorageMB'))
        if self.storageMB is not None and 'storageMB' not in already_processed:
            already_processed.add('storageMB')
            outfile.write(' storageMB="%s"' % self.gds_format_integer(self.storageMB, input_name='storageMB'))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            outfile.write(' moref=%s' % (self.gds_format_string(quote_attrib(self.moref).encode(ExternalEncoding), input_name='moref'), ))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            outfile.write(' vcName=%s' % (self.gds_format_string(quote_attrib(self.vcName).encode(ExternalEncoding), input_name='vcName'), ))
        if self.datastoreType is not None and 'datastoreType' not in already_processed:
            already_processed.add('datastoreType')
            outfile.write(' datastoreType=%s' % (self.gds_format_string(quote_attrib(self.datastoreType).encode(ExternalEncoding), input_name='datastoreType'), ))
        if self.numberOfProviderVdcs is not None and 'numberOfProviderVdcs' not in already_processed:
            already_processed.add('numberOfProviderVdcs')
            outfile.write(' numberOfProviderVdcs="%s"' % self.gds_format_integer(self.numberOfProviderVdcs, input_name='numberOfProviderVdcs'))
        if self.provisionedStorageMB is not None and 'provisionedStorageMB' not in already_processed:
            already_processed.add('provisionedStorageMB')
            outfile.write(' provisionedStorageMB="%s"' % self.gds_format_integer(self.provisionedStorageMB, input_name='provisionedStorageMB'))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            outfile.write(' isDeleted="%s"' % self.gds_format_boolean(self.isDeleted, input_name='isDeleted'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultDatastoreRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultDatastoreRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultDatastoreRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            showIndent(outfile, level)
            outfile.write('storageUsedMB=%d,\n' % (self.storageUsedMB,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.requestedStorageMB is not None and 'requestedStorageMB' not in already_processed:
            already_processed.add('requestedStorageMB')
            showIndent(outfile, level)
            outfile.write('requestedStorageMB=%d,\n' % (self.requestedStorageMB,))
        if self.storageMB is not None and 'storageMB' not in already_processed:
            already_processed.add('storageMB')
            showIndent(outfile, level)
            outfile.write('storageMB=%d,\n' % (self.storageMB,))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            showIndent(outfile, level)
            outfile.write('moref="%s",\n' % (self.moref,))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            showIndent(outfile, level)
            outfile.write('vcName="%s",\n' % (self.vcName,))
        if self.datastoreType is not None and 'datastoreType' not in already_processed:
            already_processed.add('datastoreType')
            showIndent(outfile, level)
            outfile.write('datastoreType="%s",\n' % (self.datastoreType,))
        if self.numberOfProviderVdcs is not None and 'numberOfProviderVdcs' not in already_processed:
            already_processed.add('numberOfProviderVdcs')
            showIndent(outfile, level)
            outfile.write('numberOfProviderVdcs=%d,\n' % (self.numberOfProviderVdcs,))
        if self.provisionedStorageMB is not None and 'provisionedStorageMB' not in already_processed:
            already_processed.add('provisionedStorageMB')
            showIndent(outfile, level)
            outfile.write('provisionedStorageMB=%d,\n' % (self.provisionedStorageMB,))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            showIndent(outfile, level)
            outfile.write('isDeleted=%s,\n' % (self.isDeleted,))
        super(QueryResultDatastoreRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultDatastoreRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('storageUsedMB', node)
        if value is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            try:
                self.storageUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('requestedStorageMB', node)
        if value is not None and 'requestedStorageMB' not in already_processed:
            already_processed.add('requestedStorageMB')
            try:
                self.requestedStorageMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storageMB', node)
        if value is not None and 'storageMB' not in already_processed:
            already_processed.add('storageMB')
            try:
                self.storageMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('moref', node)
        if value is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            self.moref = value
        value = find_attr_value_('vcName', node)
        if value is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            self.vcName = value
        value = find_attr_value_('datastoreType', node)
        if value is not None and 'datastoreType' not in already_processed:
            already_processed.add('datastoreType')
            self.datastoreType = value
        value = find_attr_value_('numberOfProviderVdcs', node)
        if value is not None and 'numberOfProviderVdcs' not in already_processed:
            already_processed.add('numberOfProviderVdcs')
            try:
                self.numberOfProviderVdcs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('provisionedStorageMB', node)
        if value is not None and 'provisionedStorageMB' not in already_processed:
            already_processed.add('provisionedStorageMB')
            try:
                self.provisionedStorageMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isDeleted', node)
        if value is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            if value in ('true', '1'):
                self.isDeleted = True
            elif value in ('false', '0'):
                self.isDeleted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(QueryResultDatastoreRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultDatastoreRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultDatastoreRecordType


class QueryResultNetworkPoolRecordType(QueryResultRecordType):
    """1.5 Type for a single networkPool query result in records format.
    1.5none Network pool name 1.5none Type of networkpool (0=Vlan
    backed network pool; 1=vNI backed network pool;2=Portgroup
    backed network pool) 1.5none True if this entity is busy"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isBusy=None, networkPoolType=None, name=None):
        self.original_tagname_ = None
        super(QueryResultNetworkPoolRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isBusy = _cast(bool, isBusy)
        self.networkPoolType = _cast(int, networkPoolType)
        self.name = _cast(None, name)
    def factory(*args_, **kwargs_):
        if QueryResultNetworkPoolRecordType.subclass:
            return QueryResultNetworkPoolRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultNetworkPoolRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_networkPoolType(self): return self.networkPoolType
    def set_networkPoolType(self, networkPoolType): self.networkPoolType = networkPoolType
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            super(QueryResultNetworkPoolRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultNetworkPoolRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultNetworkPoolRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultNetworkPoolRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultNetworkPoolRecordType'):
        super(QueryResultNetworkPoolRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultNetworkPoolRecordType')
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.networkPoolType is not None and 'networkPoolType' not in already_processed:
            already_processed.add('networkPoolType')
            outfile.write(' networkPoolType="%s"' % self.gds_format_integer(self.networkPoolType, input_name='networkPoolType'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultNetworkPoolRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultNetworkPoolRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultNetworkPoolRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.networkPoolType is not None and 'networkPoolType' not in already_processed:
            already_processed.add('networkPoolType')
            showIndent(outfile, level)
            outfile.write('networkPoolType=%d,\n' % (self.networkPoolType,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(QueryResultNetworkPoolRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultNetworkPoolRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('networkPoolType', node)
        if value is not None and 'networkPoolType' not in already_processed:
            already_processed.add('networkPoolType')
            try:
                self.networkPoolType = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(QueryResultNetworkPoolRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultNetworkPoolRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultNetworkPoolRecordType


class QueryResultPortgroupRecordType(QueryResultRecordType):
    """1.5 Type for a single portgroup query result in records format.
    1.5none Managed object reference of the portgroup 1.5none
    Portgroup name 1.5none Portgroup type 1.5none Virtual center
    reference or id 1.5none Vitual center name associated with the
    portgroup 1.5none True if the associated vCenter is enabled.
    1.5none Network reference or id 1.5none Name of the network that
    uses the portgroup 1.5none Scope of network using the
    portgroup(1=Global, 2=Organization, 3=vApp)"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, portgroupType=None, name=None, moref=None, vc=None, isVCEnabled=None, networkName=None, scopeType=None, vcName=None, network=None):
        self.original_tagname_ = None
        super(QueryResultPortgroupRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.portgroupType = _cast(None, portgroupType)
        self.name = _cast(None, name)
        self.moref = _cast(None, moref)
        self.vc = _cast(None, vc)
        self.isVCEnabled = _cast(bool, isVCEnabled)
        self.networkName = _cast(None, networkName)
        self.scopeType = _cast(int, scopeType)
        self.vcName = _cast(None, vcName)
        self.network = _cast(None, network)
    def factory(*args_, **kwargs_):
        if QueryResultPortgroupRecordType.subclass:
            return QueryResultPortgroupRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultPortgroupRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_portgroupType(self): return self.portgroupType
    def set_portgroupType(self, portgroupType): self.portgroupType = portgroupType
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_moref(self): return self.moref
    def set_moref(self, moref): self.moref = moref
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_isVCEnabled(self): return self.isVCEnabled
    def set_isVCEnabled(self, isVCEnabled): self.isVCEnabled = isVCEnabled
    def get_networkName(self): return self.networkName
    def set_networkName(self, networkName): self.networkName = networkName
    def get_scopeType(self): return self.scopeType
    def set_scopeType(self, scopeType): self.scopeType = scopeType
    def get_vcName(self): return self.vcName
    def set_vcName(self, vcName): self.vcName = vcName
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def hasContent_(self):
        if (
            super(QueryResultPortgroupRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultPortgroupRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultPortgroupRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultPortgroupRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultPortgroupRecordType'):
        super(QueryResultPortgroupRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultPortgroupRecordType')
        if self.portgroupType is not None and 'portgroupType' not in already_processed:
            already_processed.add('portgroupType')
            outfile.write(' portgroupType=%s' % (self.gds_format_string(quote_attrib(self.portgroupType).encode(ExternalEncoding), input_name='portgroupType'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            outfile.write(' moref=%s' % (self.gds_format_string(quote_attrib(self.moref).encode(ExternalEncoding), input_name='moref'), ))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.isVCEnabled is not None and 'isVCEnabled' not in already_processed:
            already_processed.add('isVCEnabled')
            outfile.write(' isVCEnabled="%s"' % self.gds_format_boolean(self.isVCEnabled, input_name='isVCEnabled'))
        if self.networkName is not None and 'networkName' not in already_processed:
            already_processed.add('networkName')
            outfile.write(' networkName=%s' % (self.gds_format_string(quote_attrib(self.networkName).encode(ExternalEncoding), input_name='networkName'), ))
        if self.scopeType is not None and 'scopeType' not in already_processed:
            already_processed.add('scopeType')
            outfile.write(' scopeType="%s"' % self.gds_format_integer(self.scopeType, input_name='scopeType'))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            outfile.write(' vcName=%s' % (self.gds_format_string(quote_attrib(self.vcName).encode(ExternalEncoding), input_name='vcName'), ))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            outfile.write(' network=%s' % (self.gds_format_string(quote_attrib(self.network).encode(ExternalEncoding), input_name='network'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultPortgroupRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultPortgroupRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultPortgroupRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.portgroupType is not None and 'portgroupType' not in already_processed:
            already_processed.add('portgroupType')
            showIndent(outfile, level)
            outfile.write('portgroupType="%s",\n' % (self.portgroupType,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            showIndent(outfile, level)
            outfile.write('moref="%s",\n' % (self.moref,))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.isVCEnabled is not None and 'isVCEnabled' not in already_processed:
            already_processed.add('isVCEnabled')
            showIndent(outfile, level)
            outfile.write('isVCEnabled=%s,\n' % (self.isVCEnabled,))
        if self.networkName is not None and 'networkName' not in already_processed:
            already_processed.add('networkName')
            showIndent(outfile, level)
            outfile.write('networkName="%s",\n' % (self.networkName,))
        if self.scopeType is not None and 'scopeType' not in already_processed:
            already_processed.add('scopeType')
            showIndent(outfile, level)
            outfile.write('scopeType=%d,\n' % (self.scopeType,))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            showIndent(outfile, level)
            outfile.write('vcName="%s",\n' % (self.vcName,))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            showIndent(outfile, level)
            outfile.write('network="%s",\n' % (self.network,))
        super(QueryResultPortgroupRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultPortgroupRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('portgroupType', node)
        if value is not None and 'portgroupType' not in already_processed:
            already_processed.add('portgroupType')
            self.portgroupType = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('moref', node)
        if value is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            self.moref = value
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('isVCEnabled', node)
        if value is not None and 'isVCEnabled' not in already_processed:
            already_processed.add('isVCEnabled')
            if value in ('true', '1'):
                self.isVCEnabled = True
            elif value in ('false', '0'):
                self.isVCEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('networkName', node)
        if value is not None and 'networkName' not in already_processed:
            already_processed.add('networkName')
            self.networkName = value
        value = find_attr_value_('scopeType', node)
        if value is not None and 'scopeType' not in already_processed:
            already_processed.add('scopeType')
            try:
                self.scopeType = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('vcName', node)
        if value is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            self.vcName = value
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.add('network')
            self.network = value
        super(QueryResultPortgroupRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultPortgroupRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultPortgroupRecordType


class QueryResultDvSwitchRecordType(QueryResultRecordType):
    """1.5 Type for a single dvSwitch query result in records format.
    1.5none Managed object reference of DV Switch 1.5none Virtual
    center name 1.5none Virtual center reference or id 1.5none
    Vitual center name 1.5none True if the associated vCenter is
    enabled."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isVCEnabled=None, moref=None, vc=None, name=None, vcName=None):
        self.original_tagname_ = None
        super(QueryResultDvSwitchRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isVCEnabled = _cast(bool, isVCEnabled)
        self.moref = _cast(None, moref)
        self.vc = _cast(None, vc)
        self.name = _cast(None, name)
        self.vcName = _cast(None, vcName)
    def factory(*args_, **kwargs_):
        if QueryResultDvSwitchRecordType.subclass:
            return QueryResultDvSwitchRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultDvSwitchRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isVCEnabled(self): return self.isVCEnabled
    def set_isVCEnabled(self, isVCEnabled): self.isVCEnabled = isVCEnabled
    def get_moref(self): return self.moref
    def set_moref(self, moref): self.moref = moref
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_vcName(self): return self.vcName
    def set_vcName(self, vcName): self.vcName = vcName
    def hasContent_(self):
        if (
            super(QueryResultDvSwitchRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultDvSwitchRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultDvSwitchRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultDvSwitchRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultDvSwitchRecordType'):
        super(QueryResultDvSwitchRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultDvSwitchRecordType')
        if self.isVCEnabled is not None and 'isVCEnabled' not in already_processed:
            already_processed.add('isVCEnabled')
            outfile.write(' isVCEnabled="%s"' % self.gds_format_boolean(self.isVCEnabled, input_name='isVCEnabled'))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            outfile.write(' moref=%s' % (self.gds_format_string(quote_attrib(self.moref).encode(ExternalEncoding), input_name='moref'), ))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            outfile.write(' vcName=%s' % (self.gds_format_string(quote_attrib(self.vcName).encode(ExternalEncoding), input_name='vcName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultDvSwitchRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultDvSwitchRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultDvSwitchRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isVCEnabled is not None and 'isVCEnabled' not in already_processed:
            already_processed.add('isVCEnabled')
            showIndent(outfile, level)
            outfile.write('isVCEnabled=%s,\n' % (self.isVCEnabled,))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            showIndent(outfile, level)
            outfile.write('moref="%s",\n' % (self.moref,))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            showIndent(outfile, level)
            outfile.write('vcName="%s",\n' % (self.vcName,))
        super(QueryResultDvSwitchRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultDvSwitchRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isVCEnabled', node)
        if value is not None and 'isVCEnabled' not in already_processed:
            already_processed.add('isVCEnabled')
            if value in ('true', '1'):
                self.isVCEnabled = True
            elif value in ('false', '0'):
                self.isVCEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('moref', node)
        if value is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            self.moref = value
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('vcName', node)
        if value is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            self.vcName = value
        super(QueryResultDvSwitchRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultDvSwitchRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultDvSwitchRecordType


class QueryResultCellRecordType(QueryResultRecordType):
    """1.5 Type for a single cell query result in records format. 1.5none
    Primary IP 1.5none The Cell name 1.5none True if the cell is
    active 1.5none True if the cell is in vCenter inventory. 1.5none
    Build date 1.5none Version"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, version=None, isVMwareVc=None, primaryIp=None, isActive=None, buildDate=None):
        self.original_tagname_ = None
        super(QueryResultCellRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.version = _cast(None, version)
        self.isVMwareVc = _cast(int, isVMwareVc)
        self.primaryIp = _cast(None, primaryIp)
        self.isActive = _cast(int, isActive)
        if isinstance(buildDate, basestring):
            initvalue_ = datetime_.datetime.strptime(buildDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = buildDate
        self.buildDate = initvalue_
    def factory(*args_, **kwargs_):
        if QueryResultCellRecordType.subclass:
            return QueryResultCellRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultCellRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_isVMwareVc(self): return self.isVMwareVc
    def set_isVMwareVc(self, isVMwareVc): self.isVMwareVc = isVMwareVc
    def get_primaryIp(self): return self.primaryIp
    def set_primaryIp(self, primaryIp): self.primaryIp = primaryIp
    def get_isActive(self): return self.isActive
    def set_isActive(self, isActive): self.isActive = isActive
    def get_buildDate(self): return self.buildDate
    def set_buildDate(self, buildDate): self.buildDate = buildDate
    def hasContent_(self):
        if (
            super(QueryResultCellRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultCellRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultCellRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultCellRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultCellRecordType'):
        super(QueryResultCellRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultCellRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), ))
        if self.isVMwareVc is not None and 'isVMwareVc' not in already_processed:
            already_processed.add('isVMwareVc')
            outfile.write(' isVMwareVc="%s"' % self.gds_format_integer(self.isVMwareVc, input_name='isVMwareVc'))
        if self.primaryIp is not None and 'primaryIp' not in already_processed:
            already_processed.add('primaryIp')
            outfile.write(' primaryIp=%s' % (self.gds_format_string(quote_attrib(self.primaryIp).encode(ExternalEncoding), input_name='primaryIp'), ))
        if self.isActive is not None and 'isActive' not in already_processed:
            already_processed.add('isActive')
            outfile.write(' isActive="%s"' % self.gds_format_integer(self.isActive, input_name='isActive'))
        if self.buildDate is not None and 'buildDate' not in already_processed:
            already_processed.add('buildDate')
            outfile.write(' buildDate="%s"' % self.gds_format_datetime(self.buildDate, input_name='buildDate'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultCellRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultCellRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultCellRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            showIndent(outfile, level)
            outfile.write('version="%s",\n' % (self.version,))
        if self.isVMwareVc is not None and 'isVMwareVc' not in already_processed:
            already_processed.add('isVMwareVc')
            showIndent(outfile, level)
            outfile.write('isVMwareVc=%d,\n' % (self.isVMwareVc,))
        if self.primaryIp is not None and 'primaryIp' not in already_processed:
            already_processed.add('primaryIp')
            showIndent(outfile, level)
            outfile.write('primaryIp="%s",\n' % (self.primaryIp,))
        if self.isActive is not None and 'isActive' not in already_processed:
            already_processed.add('isActive')
            showIndent(outfile, level)
            outfile.write('isActive=%d,\n' % (self.isActive,))
        if self.buildDate is not None and 'buildDate' not in already_processed:
            already_processed.add('buildDate')
            showIndent(outfile, level)
            outfile.write('buildDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.buildDate, input_name='buildDate'))
        super(QueryResultCellRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultCellRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        value = find_attr_value_('isVMwareVc', node)
        if value is not None and 'isVMwareVc' not in already_processed:
            already_processed.add('isVMwareVc')
            try:
                self.isVMwareVc = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('primaryIp', node)
        if value is not None and 'primaryIp' not in already_processed:
            already_processed.add('primaryIp')
            self.primaryIp = value
        value = find_attr_value_('isActive', node)
        if value is not None and 'isActive' not in already_processed:
            already_processed.add('isActive')
            try:
                self.isActive = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('buildDate', node)
        if value is not None and 'buildDate' not in already_processed:
            already_processed.add('buildDate')
            try:
                self.buildDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (buildDate): %s' % exp)
        super(QueryResultCellRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultCellRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultCellRecordType


class QueryResultVirtualCenterRecordType(QueryResultRecordType):
    """1.5 Type for a single virtualCenter query result in records format.
    1.5none The name of this vCenter. 1.5none Url 1.5none User name
    1.5none True if this entity is enabled 1.5none Virtual center
    version 1.5none Status 1.5none vShield IP address 1.5none True
    if this entity is busy 1.5none Uuid 5.1none True if this vCenter
    version is supported by this release of vCloud Director."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, userName=None, status=None, name=None, isSupported=None, url=None, isEnabled=None, vsmIP=None, vcVersion=None, isBusy=None, uuid=None):
        self.original_tagname_ = None
        super(QueryResultVirtualCenterRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.userName = _cast(None, userName)
        self.status = _cast(None, status)
        self.name = _cast(None, name)
        self.isSupported = _cast(bool, isSupported)
        self.url = _cast(None, url)
        self.isEnabled = _cast(bool, isEnabled)
        self.vsmIP = _cast(None, vsmIP)
        self.vcVersion = _cast(None, vcVersion)
        self.isBusy = _cast(bool, isBusy)
        self.uuid = _cast(None, uuid)
    def factory(*args_, **kwargs_):
        if QueryResultVirtualCenterRecordType.subclass:
            return QueryResultVirtualCenterRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultVirtualCenterRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_userName(self): return self.userName
    def set_userName(self, userName): self.userName = userName
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isSupported(self): return self.isSupported
    def set_isSupported(self, isSupported): self.isSupported = isSupported
    def get_url(self): return self.url
    def set_url(self, url): self.url = url
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_vsmIP(self): return self.vsmIP
    def set_vsmIP(self, vsmIP): self.vsmIP = vsmIP
    def get_vcVersion(self): return self.vcVersion
    def set_vcVersion(self, vcVersion): self.vcVersion = vcVersion
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_uuid(self): return self.uuid
    def set_uuid(self, uuid): self.uuid = uuid
    def hasContent_(self):
        if (
            super(QueryResultVirtualCenterRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultVirtualCenterRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVirtualCenterRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultVirtualCenterRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultVirtualCenterRecordType'):
        super(QueryResultVirtualCenterRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVirtualCenterRecordType')
        if self.userName is not None and 'userName' not in already_processed:
            already_processed.add('userName')
            outfile.write(' userName=%s' % (self.gds_format_string(quote_attrib(self.userName).encode(ExternalEncoding), input_name='userName'), ))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isSupported is not None and 'isSupported' not in already_processed:
            already_processed.add('isSupported')
            outfile.write(' isSupported="%s"' % self.gds_format_boolean(self.isSupported, input_name='isSupported'))
        if self.url is not None and 'url' not in already_processed:
            already_processed.add('url')
            outfile.write(' url=%s' % (self.gds_format_string(quote_attrib(self.url).encode(ExternalEncoding), input_name='url'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.vsmIP is not None and 'vsmIP' not in already_processed:
            already_processed.add('vsmIP')
            outfile.write(' vsmIP=%s' % (self.gds_format_string(quote_attrib(self.vsmIP).encode(ExternalEncoding), input_name='vsmIP'), ))
        if self.vcVersion is not None and 'vcVersion' not in already_processed:
            already_processed.add('vcVersion')
            outfile.write(' vcVersion=%s' % (self.gds_format_string(quote_attrib(self.vcVersion).encode(ExternalEncoding), input_name='vcVersion'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.uuid is not None and 'uuid' not in already_processed:
            already_processed.add('uuid')
            outfile.write(' uuid=%s' % (self.gds_format_string(quote_attrib(self.uuid).encode(ExternalEncoding), input_name='uuid'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultVirtualCenterRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultVirtualCenterRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultVirtualCenterRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.userName is not None and 'userName' not in already_processed:
            already_processed.add('userName')
            showIndent(outfile, level)
            outfile.write('userName="%s",\n' % (self.userName,))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isSupported is not None and 'isSupported' not in already_processed:
            already_processed.add('isSupported')
            showIndent(outfile, level)
            outfile.write('isSupported=%s,\n' % (self.isSupported,))
        if self.url is not None and 'url' not in already_processed:
            already_processed.add('url')
            showIndent(outfile, level)
            outfile.write('url="%s",\n' % (self.url,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.vsmIP is not None and 'vsmIP' not in already_processed:
            already_processed.add('vsmIP')
            showIndent(outfile, level)
            outfile.write('vsmIP="%s",\n' % (self.vsmIP,))
        if self.vcVersion is not None and 'vcVersion' not in already_processed:
            already_processed.add('vcVersion')
            showIndent(outfile, level)
            outfile.write('vcVersion="%s",\n' % (self.vcVersion,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.uuid is not None and 'uuid' not in already_processed:
            already_processed.add('uuid')
            showIndent(outfile, level)
            outfile.write('uuid="%s",\n' % (self.uuid,))
        super(QueryResultVirtualCenterRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultVirtualCenterRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('userName', node)
        if value is not None and 'userName' not in already_processed:
            already_processed.add('userName')
            self.userName = value
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isSupported', node)
        if value is not None and 'isSupported' not in already_processed:
            already_processed.add('isSupported')
            if value in ('true', '1'):
                self.isSupported = True
            elif value in ('false', '0'):
                self.isSupported = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('url', node)
        if value is not None and 'url' not in already_processed:
            already_processed.add('url')
            self.url = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vsmIP', node)
        if value is not None and 'vsmIP' not in already_processed:
            already_processed.add('vsmIP')
            self.vsmIP = value
        value = find_attr_value_('vcVersion', node)
        if value is not None and 'vcVersion' not in already_processed:
            already_processed.add('vcVersion')
            self.vcVersion = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('uuid', node)
        if value is not None and 'uuid' not in already_processed:
            already_processed.add('uuid')
            self.uuid = value
        super(QueryResultVirtualCenterRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultVirtualCenterRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultVirtualCenterRecordType


class QueryResultHostRecordType(QueryResultRecordType):
    """1.5 Type for a single host query result in records format. 1.5none
    The name of this host. 1.5none True if this entity is enabled
    1.5none True if this entity is deleted 1.5none True if this host
    has tasks in progress 1.5none True if this host is prepared
    1.5none True if this host's ESXi version is supported by this
    release of vCloud Director. 1.5none True if this host is hung.
    1.5none True if this host has an upgrade pending. 1.5none State
    1.5none Operating system version 1.5none True if this host is
    cross-host enabled. 1.5none Number of VMs 1.5none True if this
    host is in maintenance mode. 1.5none Virtual center reference or
    id 1.5none Vitual center name"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isSupported=None, isHung=None, vc=None, isInMaintenanceMode=None, name=None, isCrossHostEnabled=None, numberOfVMs=None, isEnabled=None, state=None, isPendingUpgrade=None, vcName=None, isBusy=None, osVersion=None, isDeleted=None, isPrepared=None):
        self.original_tagname_ = None
        super(QueryResultHostRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isSupported = _cast(bool, isSupported)
        self.isHung = _cast(bool, isHung)
        self.vc = _cast(None, vc)
        self.isInMaintenanceMode = _cast(bool, isInMaintenanceMode)
        self.name = _cast(None, name)
        self.isCrossHostEnabled = _cast(bool, isCrossHostEnabled)
        self.numberOfVMs = _cast(int, numberOfVMs)
        self.isEnabled = _cast(bool, isEnabled)
        self.state = _cast(int, state)
        self.isPendingUpgrade = _cast(bool, isPendingUpgrade)
        self.vcName = _cast(None, vcName)
        self.isBusy = _cast(bool, isBusy)
        self.osVersion = _cast(None, osVersion)
        self.isDeleted = _cast(bool, isDeleted)
        self.isPrepared = _cast(bool, isPrepared)
    def factory(*args_, **kwargs_):
        if QueryResultHostRecordType.subclass:
            return QueryResultHostRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultHostRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isSupported(self): return self.isSupported
    def set_isSupported(self, isSupported): self.isSupported = isSupported
    def get_isHung(self): return self.isHung
    def set_isHung(self, isHung): self.isHung = isHung
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_isInMaintenanceMode(self): return self.isInMaintenanceMode
    def set_isInMaintenanceMode(self, isInMaintenanceMode): self.isInMaintenanceMode = isInMaintenanceMode
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isCrossHostEnabled(self): return self.isCrossHostEnabled
    def set_isCrossHostEnabled(self, isCrossHostEnabled): self.isCrossHostEnabled = isCrossHostEnabled
    def get_numberOfVMs(self): return self.numberOfVMs
    def set_numberOfVMs(self, numberOfVMs): self.numberOfVMs = numberOfVMs
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def get_isPendingUpgrade(self): return self.isPendingUpgrade
    def set_isPendingUpgrade(self, isPendingUpgrade): self.isPendingUpgrade = isPendingUpgrade
    def get_vcName(self): return self.vcName
    def set_vcName(self, vcName): self.vcName = vcName
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_osVersion(self): return self.osVersion
    def set_osVersion(self, osVersion): self.osVersion = osVersion
    def get_isDeleted(self): return self.isDeleted
    def set_isDeleted(self, isDeleted): self.isDeleted = isDeleted
    def get_isPrepared(self): return self.isPrepared
    def set_isPrepared(self, isPrepared): self.isPrepared = isPrepared
    def hasContent_(self):
        if (
            super(QueryResultHostRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultHostRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultHostRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultHostRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultHostRecordType'):
        super(QueryResultHostRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultHostRecordType')
        if self.isSupported is not None and 'isSupported' not in already_processed:
            already_processed.add('isSupported')
            outfile.write(' isSupported="%s"' % self.gds_format_boolean(self.isSupported, input_name='isSupported'))
        if self.isHung is not None and 'isHung' not in already_processed:
            already_processed.add('isHung')
            outfile.write(' isHung="%s"' % self.gds_format_boolean(self.isHung, input_name='isHung'))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.isInMaintenanceMode is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            outfile.write(' isInMaintenanceMode="%s"' % self.gds_format_boolean(self.isInMaintenanceMode, input_name='isInMaintenanceMode'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isCrossHostEnabled is not None and 'isCrossHostEnabled' not in already_processed:
            already_processed.add('isCrossHostEnabled')
            outfile.write(' isCrossHostEnabled="%s"' % self.gds_format_boolean(self.isCrossHostEnabled, input_name='isCrossHostEnabled'))
        if self.numberOfVMs is not None and 'numberOfVMs' not in already_processed:
            already_processed.add('numberOfVMs')
            outfile.write(' numberOfVMs="%s"' % self.gds_format_integer(self.numberOfVMs, input_name='numberOfVMs'))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.state is not None and 'state' not in already_processed:
            already_processed.add('state')
            outfile.write(' state="%s"' % self.gds_format_integer(self.state, input_name='state'))
        if self.isPendingUpgrade is not None and 'isPendingUpgrade' not in already_processed:
            already_processed.add('isPendingUpgrade')
            outfile.write(' isPendingUpgrade="%s"' % self.gds_format_boolean(self.isPendingUpgrade, input_name='isPendingUpgrade'))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            outfile.write(' vcName=%s' % (self.gds_format_string(quote_attrib(self.vcName).encode(ExternalEncoding), input_name='vcName'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.osVersion is not None and 'osVersion' not in already_processed:
            already_processed.add('osVersion')
            outfile.write(' osVersion=%s' % (self.gds_format_string(quote_attrib(self.osVersion).encode(ExternalEncoding), input_name='osVersion'), ))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            outfile.write(' isDeleted="%s"' % self.gds_format_boolean(self.isDeleted, input_name='isDeleted'))
        if self.isPrepared is not None and 'isPrepared' not in already_processed:
            already_processed.add('isPrepared')
            outfile.write(' isPrepared="%s"' % self.gds_format_boolean(self.isPrepared, input_name='isPrepared'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultHostRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultHostRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultHostRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isSupported is not None and 'isSupported' not in already_processed:
            already_processed.add('isSupported')
            showIndent(outfile, level)
            outfile.write('isSupported=%s,\n' % (self.isSupported,))
        if self.isHung is not None and 'isHung' not in already_processed:
            already_processed.add('isHung')
            showIndent(outfile, level)
            outfile.write('isHung=%s,\n' % (self.isHung,))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.isInMaintenanceMode is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            showIndent(outfile, level)
            outfile.write('isInMaintenanceMode=%s,\n' % (self.isInMaintenanceMode,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isCrossHostEnabled is not None and 'isCrossHostEnabled' not in already_processed:
            already_processed.add('isCrossHostEnabled')
            showIndent(outfile, level)
            outfile.write('isCrossHostEnabled=%s,\n' % (self.isCrossHostEnabled,))
        if self.numberOfVMs is not None and 'numberOfVMs' not in already_processed:
            already_processed.add('numberOfVMs')
            showIndent(outfile, level)
            outfile.write('numberOfVMs=%d,\n' % (self.numberOfVMs,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.state is not None and 'state' not in already_processed:
            already_processed.add('state')
            showIndent(outfile, level)
            outfile.write('state=%d,\n' % (self.state,))
        if self.isPendingUpgrade is not None and 'isPendingUpgrade' not in already_processed:
            already_processed.add('isPendingUpgrade')
            showIndent(outfile, level)
            outfile.write('isPendingUpgrade=%s,\n' % (self.isPendingUpgrade,))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            showIndent(outfile, level)
            outfile.write('vcName="%s",\n' % (self.vcName,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.osVersion is not None and 'osVersion' not in already_processed:
            already_processed.add('osVersion')
            showIndent(outfile, level)
            outfile.write('osVersion="%s",\n' % (self.osVersion,))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            showIndent(outfile, level)
            outfile.write('isDeleted=%s,\n' % (self.isDeleted,))
        if self.isPrepared is not None and 'isPrepared' not in already_processed:
            already_processed.add('isPrepared')
            showIndent(outfile, level)
            outfile.write('isPrepared=%s,\n' % (self.isPrepared,))
        super(QueryResultHostRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultHostRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isSupported', node)
        if value is not None and 'isSupported' not in already_processed:
            already_processed.add('isSupported')
            if value in ('true', '1'):
                self.isSupported = True
            elif value in ('false', '0'):
                self.isSupported = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isHung', node)
        if value is not None and 'isHung' not in already_processed:
            already_processed.add('isHung')
            if value in ('true', '1'):
                self.isHung = True
            elif value in ('false', '0'):
                self.isHung = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('isInMaintenanceMode', node)
        if value is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            if value in ('true', '1'):
                self.isInMaintenanceMode = True
            elif value in ('false', '0'):
                self.isInMaintenanceMode = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isCrossHostEnabled', node)
        if value is not None and 'isCrossHostEnabled' not in already_processed:
            already_processed.add('isCrossHostEnabled')
            if value in ('true', '1'):
                self.isCrossHostEnabled = True
            elif value in ('false', '0'):
                self.isCrossHostEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('numberOfVMs', node)
        if value is not None and 'numberOfVMs' not in already_processed:
            already_processed.add('numberOfVMs')
            try:
                self.numberOfVMs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.add('state')
            try:
                self.state = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isPendingUpgrade', node)
        if value is not None and 'isPendingUpgrade' not in already_processed:
            already_processed.add('isPendingUpgrade')
            if value in ('true', '1'):
                self.isPendingUpgrade = True
            elif value in ('false', '0'):
                self.isPendingUpgrade = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vcName', node)
        if value is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            self.vcName = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('osVersion', node)
        if value is not None and 'osVersion' not in already_processed:
            already_processed.add('osVersion')
            self.osVersion = value
        value = find_attr_value_('isDeleted', node)
        if value is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            if value in ('true', '1'):
                self.isDeleted = True
            elif value in ('false', '0'):
                self.isDeleted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isPrepared', node)
        if value is not None and 'isPrepared' not in already_processed:
            already_processed.add('isPrepared')
            if value in ('true', '1'):
                self.isPrepared = True
            elif value in ('false', '0'):
                self.isPrepared = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(QueryResultHostRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultHostRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultHostRecordType


class QueryResultAdminVAppRecordType(QueryResultRecordType):
    """1.5 Type for a single adminVApp query result in records format.
    1.5none The name of this vApp. 1.5none Organization reference or
    id 1.5none VDC reference or id 1.5none VDC name 1.5none True if
    the containing VDC is enabled. 1.5none True if this entity is
    enabled 1.5none True if this entity is busy 1.5none Creation
    date 1.5none Status 1.5none Owner name 1.5none Storage in KB
    1.5none Number of VMs 1.55.1none CPU allocation in Mhz 1.5none
    Memory allocation in MB 1.5none True if the vApp is deployed.
    1.5none True if the vApp is in maintenance mode. 5.1none True if
    the vApp is expired."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, isDeployed=None, name=None, numberOfVMs=None, isEnabled=None, cpuAllocationMhz=None, vdcName=None, vdc=None, ownerName=None, isBusy=None, memoryAllocationMB=None, org=None, isInMaintenanceMode=None, creationDate=None, isVdcEnabled=None, isExpired=None, storageKB=None):
        self.original_tagname_ = None
        super(QueryResultAdminVAppRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.isDeployed = _cast(bool, isDeployed)
        self.name = _cast(None, name)
        self.numberOfVMs = _cast(int, numberOfVMs)
        self.isEnabled = _cast(bool, isEnabled)
        self.cpuAllocationMhz = _cast(int, cpuAllocationMhz)
        self.vdcName = _cast(None, vdcName)
        self.vdc = _cast(None, vdc)
        self.ownerName = _cast(None, ownerName)
        self.isBusy = _cast(bool, isBusy)
        self.memoryAllocationMB = _cast(int, memoryAllocationMB)
        self.org = _cast(None, org)
        self.isInMaintenanceMode = _cast(bool, isInMaintenanceMode)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.isVdcEnabled = _cast(bool, isVdcEnabled)
        self.isExpired = _cast(bool, isExpired)
        self.storageKB = _cast(int, storageKB)
    def factory(*args_, **kwargs_):
        if QueryResultAdminVAppRecordType.subclass:
            return QueryResultAdminVAppRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminVAppRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_isDeployed(self): return self.isDeployed
    def set_isDeployed(self, isDeployed): self.isDeployed = isDeployed
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_numberOfVMs(self): return self.numberOfVMs
    def set_numberOfVMs(self, numberOfVMs): self.numberOfVMs = numberOfVMs
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_cpuAllocationMhz(self): return self.cpuAllocationMhz
    def set_cpuAllocationMhz(self, cpuAllocationMhz): self.cpuAllocationMhz = cpuAllocationMhz
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_memoryAllocationMB(self): return self.memoryAllocationMB
    def set_memoryAllocationMB(self, memoryAllocationMB): self.memoryAllocationMB = memoryAllocationMB
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_isInMaintenanceMode(self): return self.isInMaintenanceMode
    def set_isInMaintenanceMode(self, isInMaintenanceMode): self.isInMaintenanceMode = isInMaintenanceMode
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_isVdcEnabled(self): return self.isVdcEnabled
    def set_isVdcEnabled(self, isVdcEnabled): self.isVdcEnabled = isVdcEnabled
    def get_isExpired(self): return self.isExpired
    def set_isExpired(self, isExpired): self.isExpired = isExpired
    def get_storageKB(self): return self.storageKB
    def set_storageKB(self, storageKB): self.storageKB = storageKB
    def hasContent_(self):
        if (
            super(QueryResultAdminVAppRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminVAppRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVAppRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminVAppRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminVAppRecordType'):
        super(QueryResultAdminVAppRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVAppRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            outfile.write(' isDeployed="%s"' % self.gds_format_boolean(self.isDeployed, input_name='isDeployed'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.numberOfVMs is not None and 'numberOfVMs' not in already_processed:
            already_processed.add('numberOfVMs')
            outfile.write(' numberOfVMs="%s"' % self.gds_format_integer(self.numberOfVMs, input_name='numberOfVMs'))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.cpuAllocationMhz is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            outfile.write(' cpuAllocationMhz="%s"' % self.gds_format_integer(self.cpuAllocationMhz, input_name='cpuAllocationMhz'))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.memoryAllocationMB is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            outfile.write(' memoryAllocationMB="%s"' % self.gds_format_integer(self.memoryAllocationMB, input_name='memoryAllocationMB'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.isInMaintenanceMode is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            outfile.write(' isInMaintenanceMode="%s"' % self.gds_format_boolean(self.isInMaintenanceMode, input_name='isInMaintenanceMode'))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            outfile.write(' isVdcEnabled="%s"' % self.gds_format_boolean(self.isVdcEnabled, input_name='isVdcEnabled'))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            outfile.write(' isExpired="%s"' % self.gds_format_boolean(self.isExpired, input_name='isExpired'))
        if self.storageKB is not None and 'storageKB' not in already_processed:
            already_processed.add('storageKB')
            outfile.write(' storageKB="%s"' % self.gds_format_integer(self.storageKB, input_name='storageKB'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminVAppRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminVAppRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminVAppRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            showIndent(outfile, level)
            outfile.write('isDeployed=%s,\n' % (self.isDeployed,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.numberOfVMs is not None and 'numberOfVMs' not in already_processed:
            already_processed.add('numberOfVMs')
            showIndent(outfile, level)
            outfile.write('numberOfVMs=%d,\n' % (self.numberOfVMs,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.cpuAllocationMhz is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            showIndent(outfile, level)
            outfile.write('cpuAllocationMhz=%d,\n' % (self.cpuAllocationMhz,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.memoryAllocationMB is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            showIndent(outfile, level)
            outfile.write('memoryAllocationMB=%d,\n' % (self.memoryAllocationMB,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.isInMaintenanceMode is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            showIndent(outfile, level)
            outfile.write('isInMaintenanceMode=%s,\n' % (self.isInMaintenanceMode,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            showIndent(outfile, level)
            outfile.write('isVdcEnabled=%s,\n' % (self.isVdcEnabled,))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            showIndent(outfile, level)
            outfile.write('isExpired=%s,\n' % (self.isExpired,))
        if self.storageKB is not None and 'storageKB' not in already_processed:
            already_processed.add('storageKB')
            showIndent(outfile, level)
            outfile.write('storageKB=%d,\n' % (self.storageKB,))
        super(QueryResultAdminVAppRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminVAppRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('isDeployed', node)
        if value is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            if value in ('true', '1'):
                self.isDeployed = True
            elif value in ('false', '0'):
                self.isDeployed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('numberOfVMs', node)
        if value is not None and 'numberOfVMs' not in already_processed:
            already_processed.add('numberOfVMs')
            try:
                self.numberOfVMs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('cpuAllocationMhz', node)
        if value is not None and 'cpuAllocationMhz' not in already_processed:
            already_processed.add('cpuAllocationMhz')
            try:
                self.cpuAllocationMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('memoryAllocationMB', node)
        if value is not None and 'memoryAllocationMB' not in already_processed:
            already_processed.add('memoryAllocationMB')
            try:
                self.memoryAllocationMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('isInMaintenanceMode', node)
        if value is not None and 'isInMaintenanceMode' not in already_processed:
            already_processed.add('isInMaintenanceMode')
            if value in ('true', '1'):
                self.isInMaintenanceMode = True
            elif value in ('false', '0'):
                self.isInMaintenanceMode = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('isVdcEnabled', node)
        if value is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            if value in ('true', '1'):
                self.isVdcEnabled = True
            elif value in ('false', '0'):
                self.isVdcEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isExpired', node)
        if value is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            if value in ('true', '1'):
                self.isExpired = True
            elif value in ('false', '0'):
                self.isExpired = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('storageKB', node)
        if value is not None and 'storageKB' not in already_processed:
            already_processed.add('storageKB')
            try:
                self.storageKB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(QueryResultAdminVAppRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminVAppRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminVAppRecordType


class QueryResultRightRecordType(QueryResultRecordType):
    """1.5 Type for a single right query result in records format. 1.5none
    The name of this right. 1.5none Category"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, category=None, name=None):
        self.original_tagname_ = None
        super(QueryResultRightRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.category = _cast(None, category)
        self.name = _cast(None, name)
    def factory(*args_, **kwargs_):
        if QueryResultRightRecordType.subclass:
            return QueryResultRightRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultRightRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            super(QueryResultRightRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultRightRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultRightRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultRightRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultRightRecordType'):
        super(QueryResultRightRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultRightRecordType')
        if self.category is not None and 'category' not in already_processed:
            already_processed.add('category')
            outfile.write(' category=%s' % (self.gds_format_string(quote_attrib(self.category).encode(ExternalEncoding), input_name='category'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultRightRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultRightRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultRightRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.category is not None and 'category' not in already_processed:
            already_processed.add('category')
            showIndent(outfile, level)
            outfile.write('category="%s",\n' % (self.category,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(QueryResultRightRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultRightRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('category', node)
        if value is not None and 'category' not in already_processed:
            already_processed.add('category')
            self.category = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(QueryResultRightRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultRightRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultRightRecordType


class QueryResultAdminVMRecordType(QueryResultRecordType):
    """1.5 Type for a single adminVM query result in records format.
    1.5none The name of this VM. 1.5none The name of the containing
    vApp or vApp template. 1.5none Vapp or Vapp template 1.5none
    Status 1.5none VDC reference or id 1.5none ESXi host for this VM
    1.5none True if the VM belongs to a vApp template. 1.5none True
    if this entity is deleted 1.5none Guest operating system 1.5none
    Number of CPUs 1.5none Memory in MB 1.5none Network name 1.5none
    True if this entity is deployed 1.5none True if this entity is
    in a published catalog 1.5none Catalog name 1.5none True if the
    containing VDC is enabled 1.5none Hardware version 1.5none VM
    tools version 1.5none Datastore name 1.5none Virtual center
    reference or id 1.5none Managed object reference 1.5none
    Organization reference or id 5.1none Storage profile name"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vc=None, vmToolsVersion=None, datastoreName=None, memoryMB=None, moref=None, hardwareVersion=None, org=None, isVAppTemplate=None, isDeleted=None, catalogName=None, isDeployed=None, guestOs=None, isVdcEnabled=None, status=None, storageProfileName=None, hostName=None, container=None, networkName=None, containerName=None, name=None, isPublished=None, numberOfCpus=None, vdc=None):
        self.original_tagname_ = None
        super(QueryResultAdminVMRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vc = _cast(None, vc)
        self.vmToolsVersion = _cast(int, vmToolsVersion)
        self.datastoreName = _cast(None, datastoreName)
        self.memoryMB = _cast(int, memoryMB)
        self.moref = _cast(None, moref)
        self.hardwareVersion = _cast(int, hardwareVersion)
        self.org = _cast(None, org)
        self.isVAppTemplate = _cast(bool, isVAppTemplate)
        self.isDeleted = _cast(bool, isDeleted)
        self.catalogName = _cast(None, catalogName)
        self.isDeployed = _cast(bool, isDeployed)
        self.guestOs = _cast(None, guestOs)
        self.isVdcEnabled = _cast(bool, isVdcEnabled)
        self.status = _cast(None, status)
        self.storageProfileName = _cast(None, storageProfileName)
        self.hostName = _cast(None, hostName)
        self.container = _cast(None, container)
        self.networkName = _cast(None, networkName)
        self.containerName = _cast(None, containerName)
        self.name = _cast(None, name)
        self.isPublished = _cast(bool, isPublished)
        self.numberOfCpus = _cast(int, numberOfCpus)
        self.vdc = _cast(None, vdc)
    def factory(*args_, **kwargs_):
        if QueryResultAdminVMRecordType.subclass:
            return QueryResultAdminVMRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminVMRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_vmToolsVersion(self): return self.vmToolsVersion
    def set_vmToolsVersion(self, vmToolsVersion): self.vmToolsVersion = vmToolsVersion
    def get_datastoreName(self): return self.datastoreName
    def set_datastoreName(self, datastoreName): self.datastoreName = datastoreName
    def get_memoryMB(self): return self.memoryMB
    def set_memoryMB(self, memoryMB): self.memoryMB = memoryMB
    def get_moref(self): return self.moref
    def set_moref(self, moref): self.moref = moref
    def get_hardwareVersion(self): return self.hardwareVersion
    def set_hardwareVersion(self, hardwareVersion): self.hardwareVersion = hardwareVersion
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_isVAppTemplate(self): return self.isVAppTemplate
    def set_isVAppTemplate(self, isVAppTemplate): self.isVAppTemplate = isVAppTemplate
    def get_isDeleted(self): return self.isDeleted
    def set_isDeleted(self, isDeleted): self.isDeleted = isDeleted
    def get_catalogName(self): return self.catalogName
    def set_catalogName(self, catalogName): self.catalogName = catalogName
    def get_isDeployed(self): return self.isDeployed
    def set_isDeployed(self, isDeployed): self.isDeployed = isDeployed
    def get_guestOs(self): return self.guestOs
    def set_guestOs(self, guestOs): self.guestOs = guestOs
    def get_isVdcEnabled(self): return self.isVdcEnabled
    def set_isVdcEnabled(self, isVdcEnabled): self.isVdcEnabled = isVdcEnabled
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_storageProfileName(self): return self.storageProfileName
    def set_storageProfileName(self, storageProfileName): self.storageProfileName = storageProfileName
    def get_hostName(self): return self.hostName
    def set_hostName(self, hostName): self.hostName = hostName
    def get_container(self): return self.container
    def set_container(self, container): self.container = container
    def get_networkName(self): return self.networkName
    def set_networkName(self, networkName): self.networkName = networkName
    def get_containerName(self): return self.containerName
    def set_containerName(self, containerName): self.containerName = containerName
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_numberOfCpus(self): return self.numberOfCpus
    def set_numberOfCpus(self, numberOfCpus): self.numberOfCpus = numberOfCpus
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def hasContent_(self):
        if (
            super(QueryResultAdminVMRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminVMRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVMRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminVMRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminVMRecordType'):
        super(QueryResultAdminVMRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVMRecordType')
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.vmToolsVersion is not None and 'vmToolsVersion' not in already_processed:
            already_processed.add('vmToolsVersion')
            outfile.write(' vmToolsVersion="%s"' % self.gds_format_integer(self.vmToolsVersion, input_name='vmToolsVersion'))
        if self.datastoreName is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            outfile.write(' datastoreName=%s' % (self.gds_format_string(quote_attrib(self.datastoreName).encode(ExternalEncoding), input_name='datastoreName'), ))
        if self.memoryMB is not None and 'memoryMB' not in already_processed:
            already_processed.add('memoryMB')
            outfile.write(' memoryMB="%s"' % self.gds_format_integer(self.memoryMB, input_name='memoryMB'))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            outfile.write(' moref=%s' % (self.gds_format_string(quote_attrib(self.moref).encode(ExternalEncoding), input_name='moref'), ))
        if self.hardwareVersion is not None and 'hardwareVersion' not in already_processed:
            already_processed.add('hardwareVersion')
            outfile.write(' hardwareVersion="%s"' % self.gds_format_integer(self.hardwareVersion, input_name='hardwareVersion'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.isVAppTemplate is not None and 'isVAppTemplate' not in already_processed:
            already_processed.add('isVAppTemplate')
            outfile.write(' isVAppTemplate="%s"' % self.gds_format_boolean(self.isVAppTemplate, input_name='isVAppTemplate'))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            outfile.write(' isDeleted="%s"' % self.gds_format_boolean(self.isDeleted, input_name='isDeleted'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            outfile.write(' catalogName=%s' % (self.gds_format_string(quote_attrib(self.catalogName).encode(ExternalEncoding), input_name='catalogName'), ))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            outfile.write(' isDeployed="%s"' % self.gds_format_boolean(self.isDeployed, input_name='isDeployed'))
        if self.guestOs is not None and 'guestOs' not in already_processed:
            already_processed.add('guestOs')
            outfile.write(' guestOs=%s' % (self.gds_format_string(quote_attrib(self.guestOs).encode(ExternalEncoding), input_name='guestOs'), ))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            outfile.write(' isVdcEnabled="%s"' % self.gds_format_boolean(self.isVdcEnabled, input_name='isVdcEnabled'))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            outfile.write(' storageProfileName=%s' % (self.gds_format_string(quote_attrib(self.storageProfileName).encode(ExternalEncoding), input_name='storageProfileName'), ))
        if self.hostName is not None and 'hostName' not in already_processed:
            already_processed.add('hostName')
            outfile.write(' hostName=%s' % (self.gds_format_string(quote_attrib(self.hostName).encode(ExternalEncoding), input_name='hostName'), ))
        if self.container is not None and 'container' not in already_processed:
            already_processed.add('container')
            outfile.write(' container=%s' % (self.gds_format_string(quote_attrib(self.container).encode(ExternalEncoding), input_name='container'), ))
        if self.networkName is not None and 'networkName' not in already_processed:
            already_processed.add('networkName')
            outfile.write(' networkName=%s' % (self.gds_format_string(quote_attrib(self.networkName).encode(ExternalEncoding), input_name='networkName'), ))
        if self.containerName is not None and 'containerName' not in already_processed:
            already_processed.add('containerName')
            outfile.write(' containerName=%s' % (self.gds_format_string(quote_attrib(self.containerName).encode(ExternalEncoding), input_name='containerName'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.numberOfCpus is not None and 'numberOfCpus' not in already_processed:
            already_processed.add('numberOfCpus')
            outfile.write(' numberOfCpus="%s"' % self.gds_format_integer(self.numberOfCpus, input_name='numberOfCpus'))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminVMRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminVMRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminVMRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.vmToolsVersion is not None and 'vmToolsVersion' not in already_processed:
            already_processed.add('vmToolsVersion')
            showIndent(outfile, level)
            outfile.write('vmToolsVersion=%d,\n' % (self.vmToolsVersion,))
        if self.datastoreName is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            showIndent(outfile, level)
            outfile.write('datastoreName="%s",\n' % (self.datastoreName,))
        if self.memoryMB is not None and 'memoryMB' not in already_processed:
            already_processed.add('memoryMB')
            showIndent(outfile, level)
            outfile.write('memoryMB=%d,\n' % (self.memoryMB,))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            showIndent(outfile, level)
            outfile.write('moref="%s",\n' % (self.moref,))
        if self.hardwareVersion is not None and 'hardwareVersion' not in already_processed:
            already_processed.add('hardwareVersion')
            showIndent(outfile, level)
            outfile.write('hardwareVersion=%d,\n' % (self.hardwareVersion,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.isVAppTemplate is not None and 'isVAppTemplate' not in already_processed:
            already_processed.add('isVAppTemplate')
            showIndent(outfile, level)
            outfile.write('isVAppTemplate=%s,\n' % (self.isVAppTemplate,))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            showIndent(outfile, level)
            outfile.write('isDeleted=%s,\n' % (self.isDeleted,))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            showIndent(outfile, level)
            outfile.write('catalogName="%s",\n' % (self.catalogName,))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            showIndent(outfile, level)
            outfile.write('isDeployed=%s,\n' % (self.isDeployed,))
        if self.guestOs is not None and 'guestOs' not in already_processed:
            already_processed.add('guestOs')
            showIndent(outfile, level)
            outfile.write('guestOs="%s",\n' % (self.guestOs,))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            showIndent(outfile, level)
            outfile.write('isVdcEnabled=%s,\n' % (self.isVdcEnabled,))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            showIndent(outfile, level)
            outfile.write('storageProfileName="%s",\n' % (self.storageProfileName,))
        if self.hostName is not None and 'hostName' not in already_processed:
            already_processed.add('hostName')
            showIndent(outfile, level)
            outfile.write('hostName="%s",\n' % (self.hostName,))
        if self.container is not None and 'container' not in already_processed:
            already_processed.add('container')
            showIndent(outfile, level)
            outfile.write('container="%s",\n' % (self.container,))
        if self.networkName is not None and 'networkName' not in already_processed:
            already_processed.add('networkName')
            showIndent(outfile, level)
            outfile.write('networkName="%s",\n' % (self.networkName,))
        if self.containerName is not None and 'containerName' not in already_processed:
            already_processed.add('containerName')
            showIndent(outfile, level)
            outfile.write('containerName="%s",\n' % (self.containerName,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.numberOfCpus is not None and 'numberOfCpus' not in already_processed:
            already_processed.add('numberOfCpus')
            showIndent(outfile, level)
            outfile.write('numberOfCpus=%d,\n' % (self.numberOfCpus,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        super(QueryResultAdminVMRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminVMRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('vmToolsVersion', node)
        if value is not None and 'vmToolsVersion' not in already_processed:
            already_processed.add('vmToolsVersion')
            try:
                self.vmToolsVersion = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('datastoreName', node)
        if value is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            self.datastoreName = value
        value = find_attr_value_('memoryMB', node)
        if value is not None and 'memoryMB' not in already_processed:
            already_processed.add('memoryMB')
            try:
                self.memoryMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('moref', node)
        if value is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            self.moref = value
        value = find_attr_value_('hardwareVersion', node)
        if value is not None and 'hardwareVersion' not in already_processed:
            already_processed.add('hardwareVersion')
            try:
                self.hardwareVersion = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('isVAppTemplate', node)
        if value is not None and 'isVAppTemplate' not in already_processed:
            already_processed.add('isVAppTemplate')
            if value in ('true', '1'):
                self.isVAppTemplate = True
            elif value in ('false', '0'):
                self.isVAppTemplate = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isDeleted', node)
        if value is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            if value in ('true', '1'):
                self.isDeleted = True
            elif value in ('false', '0'):
                self.isDeleted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('catalogName', node)
        if value is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            self.catalogName = value
        value = find_attr_value_('isDeployed', node)
        if value is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            if value in ('true', '1'):
                self.isDeployed = True
            elif value in ('false', '0'):
                self.isDeployed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('guestOs', node)
        if value is not None and 'guestOs' not in already_processed:
            already_processed.add('guestOs')
            self.guestOs = value
        value = find_attr_value_('isVdcEnabled', node)
        if value is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            if value in ('true', '1'):
                self.isVdcEnabled = True
            elif value in ('false', '0'):
                self.isVdcEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('storageProfileName', node)
        if value is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            self.storageProfileName = value
        value = find_attr_value_('hostName', node)
        if value is not None and 'hostName' not in already_processed:
            already_processed.add('hostName')
            self.hostName = value
        value = find_attr_value_('container', node)
        if value is not None and 'container' not in already_processed:
            already_processed.add('container')
            self.container = value
        value = find_attr_value_('networkName', node)
        if value is not None and 'networkName' not in already_processed:
            already_processed.add('networkName')
            self.networkName = value
        value = find_attr_value_('containerName', node)
        if value is not None and 'containerName' not in already_processed:
            already_processed.add('containerName')
            self.containerName = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('numberOfCpus', node)
        if value is not None and 'numberOfCpus' not in already_processed:
            already_processed.add('numberOfCpus')
            try:
                self.numberOfCpus = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        super(QueryResultAdminVMRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminVMRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminVMRecordType


class QueryResultAdminAllocatedExternalAddressRecordType(QueryResultRecordType):
    """1.55.1 Type for a single adminAllocatedExternalAddress query result
    in records format. 1.5none Network reference or id 1.5none
    Allocated IP address 1.5none Linked network reference or id
    1.5none Organization reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, org=None, ipAddress=None, network=None, linkedNetwork=None):
        self.original_tagname_ = None
        super(QueryResultAdminAllocatedExternalAddressRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.org = _cast(None, org)
        self.ipAddress = _cast(None, ipAddress)
        self.network = _cast(None, network)
        self.linkedNetwork = _cast(None, linkedNetwork)
    def factory(*args_, **kwargs_):
        if QueryResultAdminAllocatedExternalAddressRecordType.subclass:
            return QueryResultAdminAllocatedExternalAddressRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminAllocatedExternalAddressRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_ipAddress(self): return self.ipAddress
    def set_ipAddress(self, ipAddress): self.ipAddress = ipAddress
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_linkedNetwork(self): return self.linkedNetwork
    def set_linkedNetwork(self, linkedNetwork): self.linkedNetwork = linkedNetwork
    def hasContent_(self):
        if (
            super(QueryResultAdminAllocatedExternalAddressRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminAllocatedExternalAddressRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminAllocatedExternalAddressRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminAllocatedExternalAddressRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminAllocatedExternalAddressRecordType'):
        super(QueryResultAdminAllocatedExternalAddressRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminAllocatedExternalAddressRecordType')
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.ipAddress is not None and 'ipAddress' not in already_processed:
            already_processed.add('ipAddress')
            outfile.write(' ipAddress=%s' % (self.gds_format_string(quote_attrib(self.ipAddress).encode(ExternalEncoding), input_name='ipAddress'), ))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            outfile.write(' network=%s' % (self.gds_format_string(quote_attrib(self.network).encode(ExternalEncoding), input_name='network'), ))
        if self.linkedNetwork is not None and 'linkedNetwork' not in already_processed:
            already_processed.add('linkedNetwork')
            outfile.write(' linkedNetwork=%s' % (self.gds_format_string(quote_attrib(self.linkedNetwork).encode(ExternalEncoding), input_name='linkedNetwork'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminAllocatedExternalAddressRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminAllocatedExternalAddressRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminAllocatedExternalAddressRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.ipAddress is not None and 'ipAddress' not in already_processed:
            already_processed.add('ipAddress')
            showIndent(outfile, level)
            outfile.write('ipAddress="%s",\n' % (self.ipAddress,))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            showIndent(outfile, level)
            outfile.write('network="%s",\n' % (self.network,))
        if self.linkedNetwork is not None and 'linkedNetwork' not in already_processed:
            already_processed.add('linkedNetwork')
            showIndent(outfile, level)
            outfile.write('linkedNetwork="%s",\n' % (self.linkedNetwork,))
        super(QueryResultAdminAllocatedExternalAddressRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminAllocatedExternalAddressRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('ipAddress', node)
        if value is not None and 'ipAddress' not in already_processed:
            already_processed.add('ipAddress')
            self.ipAddress = value
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.add('network')
            self.network = value
        value = find_attr_value_('linkedNetwork', node)
        if value is not None and 'linkedNetwork' not in already_processed:
            already_processed.add('linkedNetwork')
            self.linkedNetwork = value
        super(QueryResultAdminAllocatedExternalAddressRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminAllocatedExternalAddressRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminAllocatedExternalAddressRecordType


class QueryResultVAppOrgNetworkRelationRecordType(QueryResultRecordType):
    """1.55.1 Type for a single vAppOrgNetworkRelation query result in
    records format. 1.5none Entity name 1.5none Organization
    reference or id 1.5none Network reference or id 1.5none Network
    name 1.5none Configuration Type 1.5none Status 1.5none Owner
    name"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, orgNetworkName=None, name=None, orgNetwork=None, ownerName=None, configurationType=None, org=None):
        self.original_tagname_ = None
        super(QueryResultVAppOrgNetworkRelationRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.orgNetworkName = _cast(None, orgNetworkName)
        self.name = _cast(None, name)
        self.orgNetwork = _cast(None, orgNetwork)
        self.ownerName = _cast(None, ownerName)
        self.configurationType = _cast(None, configurationType)
        self.org = _cast(None, org)
    def factory(*args_, **kwargs_):
        if QueryResultVAppOrgNetworkRelationRecordType.subclass:
            return QueryResultVAppOrgNetworkRelationRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultVAppOrgNetworkRelationRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_orgNetworkName(self): return self.orgNetworkName
    def set_orgNetworkName(self, orgNetworkName): self.orgNetworkName = orgNetworkName
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_orgNetwork(self): return self.orgNetwork
    def set_orgNetwork(self, orgNetwork): self.orgNetwork = orgNetwork
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_configurationType(self): return self.configurationType
    def set_configurationType(self, configurationType): self.configurationType = configurationType
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def hasContent_(self):
        if (
            super(QueryResultVAppOrgNetworkRelationRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultVAppOrgNetworkRelationRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVAppOrgNetworkRelationRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultVAppOrgNetworkRelationRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultVAppOrgNetworkRelationRecordType'):
        super(QueryResultVAppOrgNetworkRelationRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVAppOrgNetworkRelationRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.orgNetworkName is not None and 'orgNetworkName' not in already_processed:
            already_processed.add('orgNetworkName')
            outfile.write(' orgNetworkName=%s' % (self.gds_format_string(quote_attrib(self.orgNetworkName).encode(ExternalEncoding), input_name='orgNetworkName'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.orgNetwork is not None and 'orgNetwork' not in already_processed:
            already_processed.add('orgNetwork')
            outfile.write(' orgNetwork=%s' % (self.gds_format_string(quote_attrib(self.orgNetwork).encode(ExternalEncoding), input_name='orgNetwork'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.configurationType is not None and 'configurationType' not in already_processed:
            already_processed.add('configurationType')
            outfile.write(' configurationType=%s' % (self.gds_format_string(quote_attrib(self.configurationType).encode(ExternalEncoding), input_name='configurationType'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultVAppOrgNetworkRelationRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultVAppOrgNetworkRelationRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultVAppOrgNetworkRelationRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.orgNetworkName is not None and 'orgNetworkName' not in already_processed:
            already_processed.add('orgNetworkName')
            showIndent(outfile, level)
            outfile.write('orgNetworkName="%s",\n' % (self.orgNetworkName,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.orgNetwork is not None and 'orgNetwork' not in already_processed:
            already_processed.add('orgNetwork')
            showIndent(outfile, level)
            outfile.write('orgNetwork="%s",\n' % (self.orgNetwork,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.configurationType is not None and 'configurationType' not in already_processed:
            already_processed.add('configurationType')
            showIndent(outfile, level)
            outfile.write('configurationType="%s",\n' % (self.configurationType,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        super(QueryResultVAppOrgNetworkRelationRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultVAppOrgNetworkRelationRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('orgNetworkName', node)
        if value is not None and 'orgNetworkName' not in already_processed:
            already_processed.add('orgNetworkName')
            self.orgNetworkName = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('orgNetwork', node)
        if value is not None and 'orgNetwork' not in already_processed:
            already_processed.add('orgNetwork')
            self.orgNetwork = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('configurationType', node)
        if value is not None and 'configurationType' not in already_processed:
            already_processed.add('configurationType')
            self.configurationType = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        super(QueryResultVAppOrgNetworkRelationRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultVAppOrgNetworkRelationRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultVAppOrgNetworkRelationRecordType


class QueryResultOrgVdcResourcePoolRelationRecordType(QueryResultRecordType):
    """1.5 Type for a single orgVdcResourcePoolRelation query result in
    records format. 1.5none VDC reference or id 1.5none Virtual
    center reference or id 1.5none Resource pool managed object
    reference"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vdc=None, vc=None, resourcePoolMoref=None):
        self.original_tagname_ = None
        super(QueryResultOrgVdcResourcePoolRelationRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vdc = _cast(None, vdc)
        self.vc = _cast(None, vc)
        self.resourcePoolMoref = _cast(None, resourcePoolMoref)
    def factory(*args_, **kwargs_):
        if QueryResultOrgVdcResourcePoolRelationRecordType.subclass:
            return QueryResultOrgVdcResourcePoolRelationRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultOrgVdcResourcePoolRelationRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_resourcePoolMoref(self): return self.resourcePoolMoref
    def set_resourcePoolMoref(self, resourcePoolMoref): self.resourcePoolMoref = resourcePoolMoref
    def hasContent_(self):
        if (
            super(QueryResultOrgVdcResourcePoolRelationRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultOrgVdcResourcePoolRelationRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgVdcResourcePoolRelationRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultOrgVdcResourcePoolRelationRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultOrgVdcResourcePoolRelationRecordType'):
        super(QueryResultOrgVdcResourcePoolRelationRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgVdcResourcePoolRelationRecordType')
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.resourcePoolMoref is not None and 'resourcePoolMoref' not in already_processed:
            already_processed.add('resourcePoolMoref')
            outfile.write(' resourcePoolMoref=%s' % (self.gds_format_string(quote_attrib(self.resourcePoolMoref).encode(ExternalEncoding), input_name='resourcePoolMoref'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultOrgVdcResourcePoolRelationRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultOrgVdcResourcePoolRelationRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultOrgVdcResourcePoolRelationRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.resourcePoolMoref is not None and 'resourcePoolMoref' not in already_processed:
            already_processed.add('resourcePoolMoref')
            showIndent(outfile, level)
            outfile.write('resourcePoolMoref="%s",\n' % (self.resourcePoolMoref,))
        super(QueryResultOrgVdcResourcePoolRelationRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultOrgVdcResourcePoolRelationRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('resourcePoolMoref', node)
        if value is not None and 'resourcePoolMoref' not in already_processed:
            already_processed.add('resourcePoolMoref')
            self.resourcePoolMoref = value
        super(QueryResultOrgVdcResourcePoolRelationRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultOrgVdcResourcePoolRelationRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultOrgVdcResourcePoolRelationRecordType


class QueryResultProviderVdcResourcePoolRelationRecordType(QueryResultRecordType):
    """1.5 Type for a single providerVdcResourcePoolRelation query result
    in records format. 1.5none The name of this resource pool.
    1.5none Resource pool managed object reference 1.5none CPU
    reservation limit in Mhz 1.5none CPU reservation allocation in
    Mhz 1.5none True if this entity is enabled 1.5none Memory
    reservation limit in MB 1.5none Memory reservation allocation in
    MB 1.5none True if this is the primary resource pool for this
    Provider VDC. 1.5none Provider VDC reference or id 1.5none
    Virtual center reference or id 1.5none Vitual center name
    1.5none Number of VMs"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vc=None, resourcePoolMoref=None, name=None, cpuReservationLimitMhz=None, providerVdc=None, numberOfVMs=None, isEnabled=None, cpuReservationAllocationMhz=None, memoryReservationLimitMB=None, memoryReservationAllocationMB=None, isPrimary=None, vcName=None):
        self.original_tagname_ = None
        super(QueryResultProviderVdcResourcePoolRelationRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vc = _cast(None, vc)
        self.resourcePoolMoref = _cast(None, resourcePoolMoref)
        self.name = _cast(None, name)
        self.cpuReservationLimitMhz = _cast(int, cpuReservationLimitMhz)
        self.providerVdc = _cast(None, providerVdc)
        self.numberOfVMs = _cast(int, numberOfVMs)
        self.isEnabled = _cast(bool, isEnabled)
        self.cpuReservationAllocationMhz = _cast(int, cpuReservationAllocationMhz)
        self.memoryReservationLimitMB = _cast(int, memoryReservationLimitMB)
        self.memoryReservationAllocationMB = _cast(int, memoryReservationAllocationMB)
        self.isPrimary = _cast(bool, isPrimary)
        self.vcName = _cast(None, vcName)
    def factory(*args_, **kwargs_):
        if QueryResultProviderVdcResourcePoolRelationRecordType.subclass:
            return QueryResultProviderVdcResourcePoolRelationRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultProviderVdcResourcePoolRelationRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_resourcePoolMoref(self): return self.resourcePoolMoref
    def set_resourcePoolMoref(self, resourcePoolMoref): self.resourcePoolMoref = resourcePoolMoref
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_cpuReservationLimitMhz(self): return self.cpuReservationLimitMhz
    def set_cpuReservationLimitMhz(self, cpuReservationLimitMhz): self.cpuReservationLimitMhz = cpuReservationLimitMhz
    def get_providerVdc(self): return self.providerVdc
    def set_providerVdc(self, providerVdc): self.providerVdc = providerVdc
    def get_numberOfVMs(self): return self.numberOfVMs
    def set_numberOfVMs(self, numberOfVMs): self.numberOfVMs = numberOfVMs
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_cpuReservationAllocationMhz(self): return self.cpuReservationAllocationMhz
    def set_cpuReservationAllocationMhz(self, cpuReservationAllocationMhz): self.cpuReservationAllocationMhz = cpuReservationAllocationMhz
    def get_memoryReservationLimitMB(self): return self.memoryReservationLimitMB
    def set_memoryReservationLimitMB(self, memoryReservationLimitMB): self.memoryReservationLimitMB = memoryReservationLimitMB
    def get_memoryReservationAllocationMB(self): return self.memoryReservationAllocationMB
    def set_memoryReservationAllocationMB(self, memoryReservationAllocationMB): self.memoryReservationAllocationMB = memoryReservationAllocationMB
    def get_isPrimary(self): return self.isPrimary
    def set_isPrimary(self, isPrimary): self.isPrimary = isPrimary
    def get_vcName(self): return self.vcName
    def set_vcName(self, vcName): self.vcName = vcName
    def hasContent_(self):
        if (
            super(QueryResultProviderVdcResourcePoolRelationRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultProviderVdcResourcePoolRelationRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultProviderVdcResourcePoolRelationRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultProviderVdcResourcePoolRelationRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultProviderVdcResourcePoolRelationRecordType'):
        super(QueryResultProviderVdcResourcePoolRelationRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultProviderVdcResourcePoolRelationRecordType')
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.resourcePoolMoref is not None and 'resourcePoolMoref' not in already_processed:
            already_processed.add('resourcePoolMoref')
            outfile.write(' resourcePoolMoref=%s' % (self.gds_format_string(quote_attrib(self.resourcePoolMoref).encode(ExternalEncoding), input_name='resourcePoolMoref'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.cpuReservationLimitMhz is not None and 'cpuReservationLimitMhz' not in already_processed:
            already_processed.add('cpuReservationLimitMhz')
            outfile.write(' cpuReservationLimitMhz="%s"' % self.gds_format_integer(self.cpuReservationLimitMhz, input_name='cpuReservationLimitMhz'))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            outfile.write(' providerVdc=%s' % (self.gds_format_string(quote_attrib(self.providerVdc).encode(ExternalEncoding), input_name='providerVdc'), ))
        if self.numberOfVMs is not None and 'numberOfVMs' not in already_processed:
            already_processed.add('numberOfVMs')
            outfile.write(' numberOfVMs="%s"' % self.gds_format_integer(self.numberOfVMs, input_name='numberOfVMs'))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.cpuReservationAllocationMhz is not None and 'cpuReservationAllocationMhz' not in already_processed:
            already_processed.add('cpuReservationAllocationMhz')
            outfile.write(' cpuReservationAllocationMhz="%s"' % self.gds_format_integer(self.cpuReservationAllocationMhz, input_name='cpuReservationAllocationMhz'))
        if self.memoryReservationLimitMB is not None and 'memoryReservationLimitMB' not in already_processed:
            already_processed.add('memoryReservationLimitMB')
            outfile.write(' memoryReservationLimitMB="%s"' % self.gds_format_integer(self.memoryReservationLimitMB, input_name='memoryReservationLimitMB'))
        if self.memoryReservationAllocationMB is not None and 'memoryReservationAllocationMB' not in already_processed:
            already_processed.add('memoryReservationAllocationMB')
            outfile.write(' memoryReservationAllocationMB="%s"' % self.gds_format_integer(self.memoryReservationAllocationMB, input_name='memoryReservationAllocationMB'))
        if self.isPrimary is not None and 'isPrimary' not in already_processed:
            already_processed.add('isPrimary')
            outfile.write(' isPrimary="%s"' % self.gds_format_boolean(self.isPrimary, input_name='isPrimary'))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            outfile.write(' vcName=%s' % (self.gds_format_string(quote_attrib(self.vcName).encode(ExternalEncoding), input_name='vcName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultProviderVdcResourcePoolRelationRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultProviderVdcResourcePoolRelationRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultProviderVdcResourcePoolRelationRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.resourcePoolMoref is not None and 'resourcePoolMoref' not in already_processed:
            already_processed.add('resourcePoolMoref')
            showIndent(outfile, level)
            outfile.write('resourcePoolMoref="%s",\n' % (self.resourcePoolMoref,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.cpuReservationLimitMhz is not None and 'cpuReservationLimitMhz' not in already_processed:
            already_processed.add('cpuReservationLimitMhz')
            showIndent(outfile, level)
            outfile.write('cpuReservationLimitMhz=%d,\n' % (self.cpuReservationLimitMhz,))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            showIndent(outfile, level)
            outfile.write('providerVdc="%s",\n' % (self.providerVdc,))
        if self.numberOfVMs is not None and 'numberOfVMs' not in already_processed:
            already_processed.add('numberOfVMs')
            showIndent(outfile, level)
            outfile.write('numberOfVMs=%d,\n' % (self.numberOfVMs,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.cpuReservationAllocationMhz is not None and 'cpuReservationAllocationMhz' not in already_processed:
            already_processed.add('cpuReservationAllocationMhz')
            showIndent(outfile, level)
            outfile.write('cpuReservationAllocationMhz=%d,\n' % (self.cpuReservationAllocationMhz,))
        if self.memoryReservationLimitMB is not None and 'memoryReservationLimitMB' not in already_processed:
            already_processed.add('memoryReservationLimitMB')
            showIndent(outfile, level)
            outfile.write('memoryReservationLimitMB=%d,\n' % (self.memoryReservationLimitMB,))
        if self.memoryReservationAllocationMB is not None and 'memoryReservationAllocationMB' not in already_processed:
            already_processed.add('memoryReservationAllocationMB')
            showIndent(outfile, level)
            outfile.write('memoryReservationAllocationMB=%d,\n' % (self.memoryReservationAllocationMB,))
        if self.isPrimary is not None and 'isPrimary' not in already_processed:
            already_processed.add('isPrimary')
            showIndent(outfile, level)
            outfile.write('isPrimary=%s,\n' % (self.isPrimary,))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            showIndent(outfile, level)
            outfile.write('vcName="%s",\n' % (self.vcName,))
        super(QueryResultProviderVdcResourcePoolRelationRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultProviderVdcResourcePoolRelationRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('resourcePoolMoref', node)
        if value is not None and 'resourcePoolMoref' not in already_processed:
            already_processed.add('resourcePoolMoref')
            self.resourcePoolMoref = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('cpuReservationLimitMhz', node)
        if value is not None and 'cpuReservationLimitMhz' not in already_processed:
            already_processed.add('cpuReservationLimitMhz')
            try:
                self.cpuReservationLimitMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('providerVdc', node)
        if value is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            self.providerVdc = value
        value = find_attr_value_('numberOfVMs', node)
        if value is not None and 'numberOfVMs' not in already_processed:
            already_processed.add('numberOfVMs')
            try:
                self.numberOfVMs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('cpuReservationAllocationMhz', node)
        if value is not None and 'cpuReservationAllocationMhz' not in already_processed:
            already_processed.add('cpuReservationAllocationMhz')
            try:
                self.cpuReservationAllocationMhz = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('memoryReservationLimitMB', node)
        if value is not None and 'memoryReservationLimitMB' not in already_processed:
            already_processed.add('memoryReservationLimitMB')
            try:
                self.memoryReservationLimitMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('memoryReservationAllocationMB', node)
        if value is not None and 'memoryReservationAllocationMB' not in already_processed:
            already_processed.add('memoryReservationAllocationMB')
            try:
                self.memoryReservationAllocationMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isPrimary', node)
        if value is not None and 'isPrimary' not in already_processed:
            already_processed.add('isPrimary')
            if value in ('true', '1'):
                self.isPrimary = True
            elif value in ('false', '0'):
                self.isPrimary = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vcName', node)
        if value is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            self.vcName = value
        super(QueryResultProviderVdcResourcePoolRelationRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultProviderVdcResourcePoolRelationRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultProviderVdcResourcePoolRelationRecordType


class QueryResultDatastoreProviderVdcRelationRecordType(QueryResultRecordType):
    """1.5 Type for a single datastoreProviderVdcRelation query result in
    records format. 1.5none The name of this datastore. 1.5none
    Datastore type 1.5none True if this entity is enabled 1.5none
    True if this entity is deleted 1.5none Storage used in MB
    1.5none Storage in MB 1.5none Provisioned storage in MB 1.5none
    Requested storage in MB 1.5none Virtual center reference or id
    1.5none Vitual center name 1.5none Managed object reference
    1.5none Provider VDC reference or id 1.5none Datastore reference
    or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vc=None, storageUsedMB=None, name=None, providerVdc=None, isEnabled=None, requestedStorageMB=None, storageMB=None, moref=None, vcName=None, datastoreType=None, provisionedStorageMB=None, datastore=None, isDeleted=None):
        self.original_tagname_ = None
        super(QueryResultDatastoreProviderVdcRelationRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vc = _cast(None, vc)
        self.storageUsedMB = _cast(float, storageUsedMB)
        self.name = _cast(None, name)
        self.providerVdc = _cast(None, providerVdc)
        self.isEnabled = _cast(bool, isEnabled)
        self.requestedStorageMB = _cast(float, requestedStorageMB)
        self.storageMB = _cast(float, storageMB)
        self.moref = _cast(None, moref)
        self.vcName = _cast(None, vcName)
        self.datastoreType = _cast(None, datastoreType)
        self.provisionedStorageMB = _cast(float, provisionedStorageMB)
        self.datastore = _cast(None, datastore)
        self.isDeleted = _cast(bool, isDeleted)
    def factory(*args_, **kwargs_):
        if QueryResultDatastoreProviderVdcRelationRecordType.subclass:
            return QueryResultDatastoreProviderVdcRelationRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultDatastoreProviderVdcRelationRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_storageUsedMB(self): return self.storageUsedMB
    def set_storageUsedMB(self, storageUsedMB): self.storageUsedMB = storageUsedMB
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_providerVdc(self): return self.providerVdc
    def set_providerVdc(self, providerVdc): self.providerVdc = providerVdc
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_requestedStorageMB(self): return self.requestedStorageMB
    def set_requestedStorageMB(self, requestedStorageMB): self.requestedStorageMB = requestedStorageMB
    def get_storageMB(self): return self.storageMB
    def set_storageMB(self, storageMB): self.storageMB = storageMB
    def get_moref(self): return self.moref
    def set_moref(self, moref): self.moref = moref
    def get_vcName(self): return self.vcName
    def set_vcName(self, vcName): self.vcName = vcName
    def get_datastoreType(self): return self.datastoreType
    def set_datastoreType(self, datastoreType): self.datastoreType = datastoreType
    def get_provisionedStorageMB(self): return self.provisionedStorageMB
    def set_provisionedStorageMB(self, provisionedStorageMB): self.provisionedStorageMB = provisionedStorageMB
    def get_datastore(self): return self.datastore
    def set_datastore(self, datastore): self.datastore = datastore
    def get_isDeleted(self): return self.isDeleted
    def set_isDeleted(self, isDeleted): self.isDeleted = isDeleted
    def hasContent_(self):
        if (
            super(QueryResultDatastoreProviderVdcRelationRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultDatastoreProviderVdcRelationRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultDatastoreProviderVdcRelationRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultDatastoreProviderVdcRelationRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultDatastoreProviderVdcRelationRecordType'):
        super(QueryResultDatastoreProviderVdcRelationRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultDatastoreProviderVdcRelationRecordType')
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            outfile.write(' storageUsedMB="%s"' % self.gds_format_float(self.storageUsedMB, input_name='storageUsedMB'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            outfile.write(' providerVdc=%s' % (self.gds_format_string(quote_attrib(self.providerVdc).encode(ExternalEncoding), input_name='providerVdc'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.requestedStorageMB is not None and 'requestedStorageMB' not in already_processed:
            already_processed.add('requestedStorageMB')
            outfile.write(' requestedStorageMB="%s"' % self.gds_format_float(self.requestedStorageMB, input_name='requestedStorageMB'))
        if self.storageMB is not None and 'storageMB' not in already_processed:
            already_processed.add('storageMB')
            outfile.write(' storageMB="%s"' % self.gds_format_float(self.storageMB, input_name='storageMB'))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            outfile.write(' moref=%s' % (self.gds_format_string(quote_attrib(self.moref).encode(ExternalEncoding), input_name='moref'), ))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            outfile.write(' vcName=%s' % (self.gds_format_string(quote_attrib(self.vcName).encode(ExternalEncoding), input_name='vcName'), ))
        if self.datastoreType is not None and 'datastoreType' not in already_processed:
            already_processed.add('datastoreType')
            outfile.write(' datastoreType=%s' % (self.gds_format_string(quote_attrib(self.datastoreType).encode(ExternalEncoding), input_name='datastoreType'), ))
        if self.provisionedStorageMB is not None and 'provisionedStorageMB' not in already_processed:
            already_processed.add('provisionedStorageMB')
            outfile.write(' provisionedStorageMB="%s"' % self.gds_format_float(self.provisionedStorageMB, input_name='provisionedStorageMB'))
        if self.datastore is not None and 'datastore' not in already_processed:
            already_processed.add('datastore')
            outfile.write(' datastore=%s' % (self.gds_format_string(quote_attrib(self.datastore).encode(ExternalEncoding), input_name='datastore'), ))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            outfile.write(' isDeleted="%s"' % self.gds_format_boolean(self.isDeleted, input_name='isDeleted'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultDatastoreProviderVdcRelationRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultDatastoreProviderVdcRelationRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultDatastoreProviderVdcRelationRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            showIndent(outfile, level)
            outfile.write('storageUsedMB=%f,\n' % (self.storageUsedMB,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            showIndent(outfile, level)
            outfile.write('providerVdc="%s",\n' % (self.providerVdc,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.requestedStorageMB is not None and 'requestedStorageMB' not in already_processed:
            already_processed.add('requestedStorageMB')
            showIndent(outfile, level)
            outfile.write('requestedStorageMB=%f,\n' % (self.requestedStorageMB,))
        if self.storageMB is not None and 'storageMB' not in already_processed:
            already_processed.add('storageMB')
            showIndent(outfile, level)
            outfile.write('storageMB=%f,\n' % (self.storageMB,))
        if self.moref is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            showIndent(outfile, level)
            outfile.write('moref="%s",\n' % (self.moref,))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            showIndent(outfile, level)
            outfile.write('vcName="%s",\n' % (self.vcName,))
        if self.datastoreType is not None and 'datastoreType' not in already_processed:
            already_processed.add('datastoreType')
            showIndent(outfile, level)
            outfile.write('datastoreType="%s",\n' % (self.datastoreType,))
        if self.provisionedStorageMB is not None and 'provisionedStorageMB' not in already_processed:
            already_processed.add('provisionedStorageMB')
            showIndent(outfile, level)
            outfile.write('provisionedStorageMB=%f,\n' % (self.provisionedStorageMB,))
        if self.datastore is not None and 'datastore' not in already_processed:
            already_processed.add('datastore')
            showIndent(outfile, level)
            outfile.write('datastore="%s",\n' % (self.datastore,))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            showIndent(outfile, level)
            outfile.write('isDeleted=%s,\n' % (self.isDeleted,))
        super(QueryResultDatastoreProviderVdcRelationRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultDatastoreProviderVdcRelationRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('storageUsedMB', node)
        if value is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            try:
                self.storageUsedMB = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (storageUsedMB): %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('providerVdc', node)
        if value is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            self.providerVdc = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('requestedStorageMB', node)
        if value is not None and 'requestedStorageMB' not in already_processed:
            already_processed.add('requestedStorageMB')
            try:
                self.requestedStorageMB = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (requestedStorageMB): %s' % exp)
        value = find_attr_value_('storageMB', node)
        if value is not None and 'storageMB' not in already_processed:
            already_processed.add('storageMB')
            try:
                self.storageMB = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (storageMB): %s' % exp)
        value = find_attr_value_('moref', node)
        if value is not None and 'moref' not in already_processed:
            already_processed.add('moref')
            self.moref = value
        value = find_attr_value_('vcName', node)
        if value is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            self.vcName = value
        value = find_attr_value_('datastoreType', node)
        if value is not None and 'datastoreType' not in already_processed:
            already_processed.add('datastoreType')
            self.datastoreType = value
        value = find_attr_value_('provisionedStorageMB', node)
        if value is not None and 'provisionedStorageMB' not in already_processed:
            already_processed.add('provisionedStorageMB')
            try:
                self.provisionedStorageMB = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (provisionedStorageMB): %s' % exp)
        value = find_attr_value_('datastore', node)
        if value is not None and 'datastore' not in already_processed:
            already_processed.add('datastore')
            self.datastore = value
        value = find_attr_value_('isDeleted', node)
        if value is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            if value in ('true', '1'):
                self.isDeleted = True
            elif value in ('false', '0'):
                self.isDeleted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(QueryResultDatastoreProviderVdcRelationRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultDatastoreProviderVdcRelationRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultDatastoreProviderVdcRelationRecordType


class QueryResultAdminUserRecordType(QueryResultRecordType):
    """1.5 Type for a single adminUser query result in records format.
    1.5none The name of this user. 1.5none Organization reference or
    id 1.5none The full name of this user. 1.5none True if this
    entity is enabled 1.5none Number of deployed VMs 1.5none
    Deployed VM quota 1.5none Number of stored VMs 1.5none Stored VM
    Quota 1.5none If the identity provider type is INTEGRATED, shows
    whether the user was imported from LDAP 1.5none Deployed VM
    quota rank 1.5none Stored VM Quota rank 5.1none Shows the
    identity provider type of the user"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isLdapUser=None, deployedVMQuotaRank=None, name=None, isEnabled=None, deployedVMQuota=None, identityProviderType=None, storedVMQuota=None, numberOfStoredVMs=None, storedVMQuotaRank=None, numberOfDeployedVMs=None, org=None, fullName=None):
        self.original_tagname_ = None
        super(QueryResultAdminUserRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isLdapUser = _cast(bool, isLdapUser)
        self.deployedVMQuotaRank = _cast(int, deployedVMQuotaRank)
        self.name = _cast(None, name)
        self.isEnabled = _cast(bool, isEnabled)
        self.deployedVMQuota = _cast(int, deployedVMQuota)
        self.identityProviderType = _cast(None, identityProviderType)
        self.storedVMQuota = _cast(int, storedVMQuota)
        self.numberOfStoredVMs = _cast(int, numberOfStoredVMs)
        self.storedVMQuotaRank = _cast(int, storedVMQuotaRank)
        self.numberOfDeployedVMs = _cast(int, numberOfDeployedVMs)
        self.org = _cast(None, org)
        self.fullName = _cast(None, fullName)
    def factory(*args_, **kwargs_):
        if QueryResultAdminUserRecordType.subclass:
            return QueryResultAdminUserRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminUserRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isLdapUser(self): return self.isLdapUser
    def set_isLdapUser(self, isLdapUser): self.isLdapUser = isLdapUser
    def get_deployedVMQuotaRank(self): return self.deployedVMQuotaRank
    def set_deployedVMQuotaRank(self, deployedVMQuotaRank): self.deployedVMQuotaRank = deployedVMQuotaRank
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_deployedVMQuota(self): return self.deployedVMQuota
    def set_deployedVMQuota(self, deployedVMQuota): self.deployedVMQuota = deployedVMQuota
    def get_identityProviderType(self): return self.identityProviderType
    def set_identityProviderType(self, identityProviderType): self.identityProviderType = identityProviderType
    def get_storedVMQuota(self): return self.storedVMQuota
    def set_storedVMQuota(self, storedVMQuota): self.storedVMQuota = storedVMQuota
    def get_numberOfStoredVMs(self): return self.numberOfStoredVMs
    def set_numberOfStoredVMs(self, numberOfStoredVMs): self.numberOfStoredVMs = numberOfStoredVMs
    def get_storedVMQuotaRank(self): return self.storedVMQuotaRank
    def set_storedVMQuotaRank(self, storedVMQuotaRank): self.storedVMQuotaRank = storedVMQuotaRank
    def get_numberOfDeployedVMs(self): return self.numberOfDeployedVMs
    def set_numberOfDeployedVMs(self, numberOfDeployedVMs): self.numberOfDeployedVMs = numberOfDeployedVMs
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_fullName(self): return self.fullName
    def set_fullName(self, fullName): self.fullName = fullName
    def hasContent_(self):
        if (
            super(QueryResultAdminUserRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminUserRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminUserRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminUserRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminUserRecordType'):
        super(QueryResultAdminUserRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminUserRecordType')
        if self.isLdapUser is not None and 'isLdapUser' not in already_processed:
            already_processed.add('isLdapUser')
            outfile.write(' isLdapUser="%s"' % self.gds_format_boolean(self.isLdapUser, input_name='isLdapUser'))
        if self.deployedVMQuotaRank is not None and 'deployedVMQuotaRank' not in already_processed:
            already_processed.add('deployedVMQuotaRank')
            outfile.write(' deployedVMQuotaRank="%s"' % self.gds_format_integer(self.deployedVMQuotaRank, input_name='deployedVMQuotaRank'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.deployedVMQuota is not None and 'deployedVMQuota' not in already_processed:
            already_processed.add('deployedVMQuota')
            outfile.write(' deployedVMQuota="%s"' % self.gds_format_integer(self.deployedVMQuota, input_name='deployedVMQuota'))
        if self.identityProviderType is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            outfile.write(' identityProviderType=%s' % (self.gds_format_string(quote_attrib(self.identityProviderType).encode(ExternalEncoding), input_name='identityProviderType'), ))
        if self.storedVMQuota is not None and 'storedVMQuota' not in already_processed:
            already_processed.add('storedVMQuota')
            outfile.write(' storedVMQuota="%s"' % self.gds_format_integer(self.storedVMQuota, input_name='storedVMQuota'))
        if self.numberOfStoredVMs is not None and 'numberOfStoredVMs' not in already_processed:
            already_processed.add('numberOfStoredVMs')
            outfile.write(' numberOfStoredVMs="%s"' % self.gds_format_integer(self.numberOfStoredVMs, input_name='numberOfStoredVMs'))
        if self.storedVMQuotaRank is not None and 'storedVMQuotaRank' not in already_processed:
            already_processed.add('storedVMQuotaRank')
            outfile.write(' storedVMQuotaRank="%s"' % self.gds_format_integer(self.storedVMQuotaRank, input_name='storedVMQuotaRank'))
        if self.numberOfDeployedVMs is not None and 'numberOfDeployedVMs' not in already_processed:
            already_processed.add('numberOfDeployedVMs')
            outfile.write(' numberOfDeployedVMs="%s"' % self.gds_format_integer(self.numberOfDeployedVMs, input_name='numberOfDeployedVMs'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.fullName is not None and 'fullName' not in already_processed:
            already_processed.add('fullName')
            outfile.write(' fullName=%s' % (self.gds_format_string(quote_attrib(self.fullName).encode(ExternalEncoding), input_name='fullName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminUserRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminUserRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminUserRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isLdapUser is not None and 'isLdapUser' not in already_processed:
            already_processed.add('isLdapUser')
            showIndent(outfile, level)
            outfile.write('isLdapUser=%s,\n' % (self.isLdapUser,))
        if self.deployedVMQuotaRank is not None and 'deployedVMQuotaRank' not in already_processed:
            already_processed.add('deployedVMQuotaRank')
            showIndent(outfile, level)
            outfile.write('deployedVMQuotaRank=%d,\n' % (self.deployedVMQuotaRank,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.deployedVMQuota is not None and 'deployedVMQuota' not in already_processed:
            already_processed.add('deployedVMQuota')
            showIndent(outfile, level)
            outfile.write('deployedVMQuota=%d,\n' % (self.deployedVMQuota,))
        if self.identityProviderType is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            showIndent(outfile, level)
            outfile.write('identityProviderType="%s",\n' % (self.identityProviderType,))
        if self.storedVMQuota is not None and 'storedVMQuota' not in already_processed:
            already_processed.add('storedVMQuota')
            showIndent(outfile, level)
            outfile.write('storedVMQuota=%d,\n' % (self.storedVMQuota,))
        if self.numberOfStoredVMs is not None and 'numberOfStoredVMs' not in already_processed:
            already_processed.add('numberOfStoredVMs')
            showIndent(outfile, level)
            outfile.write('numberOfStoredVMs=%d,\n' % (self.numberOfStoredVMs,))
        if self.storedVMQuotaRank is not None and 'storedVMQuotaRank' not in already_processed:
            already_processed.add('storedVMQuotaRank')
            showIndent(outfile, level)
            outfile.write('storedVMQuotaRank=%d,\n' % (self.storedVMQuotaRank,))
        if self.numberOfDeployedVMs is not None and 'numberOfDeployedVMs' not in already_processed:
            already_processed.add('numberOfDeployedVMs')
            showIndent(outfile, level)
            outfile.write('numberOfDeployedVMs=%d,\n' % (self.numberOfDeployedVMs,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.fullName is not None and 'fullName' not in already_processed:
            already_processed.add('fullName')
            showIndent(outfile, level)
            outfile.write('fullName="%s",\n' % (self.fullName,))
        super(QueryResultAdminUserRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminUserRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isLdapUser', node)
        if value is not None and 'isLdapUser' not in already_processed:
            already_processed.add('isLdapUser')
            if value in ('true', '1'):
                self.isLdapUser = True
            elif value in ('false', '0'):
                self.isLdapUser = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('deployedVMQuotaRank', node)
        if value is not None and 'deployedVMQuotaRank' not in already_processed:
            already_processed.add('deployedVMQuotaRank')
            try:
                self.deployedVMQuotaRank = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('deployedVMQuota', node)
        if value is not None and 'deployedVMQuota' not in already_processed:
            already_processed.add('deployedVMQuota')
            try:
                self.deployedVMQuota = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('identityProviderType', node)
        if value is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            self.identityProviderType = value
        value = find_attr_value_('storedVMQuota', node)
        if value is not None and 'storedVMQuota' not in already_processed:
            already_processed.add('storedVMQuota')
            try:
                self.storedVMQuota = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfStoredVMs', node)
        if value is not None and 'numberOfStoredVMs' not in already_processed:
            already_processed.add('numberOfStoredVMs')
            try:
                self.numberOfStoredVMs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storedVMQuotaRank', node)
        if value is not None and 'storedVMQuotaRank' not in already_processed:
            already_processed.add('storedVMQuotaRank')
            try:
                self.storedVMQuotaRank = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfDeployedVMs', node)
        if value is not None and 'numberOfDeployedVMs' not in already_processed:
            already_processed.add('numberOfDeployedVMs')
            try:
                self.numberOfDeployedVMs = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('fullName', node)
        if value is not None and 'fullName' not in already_processed:
            already_processed.add('fullName')
            self.fullName = value
        super(QueryResultAdminUserRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminUserRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminUserRecordType


class QueryResultAdminGroupRecordType(QueryResultRecordType):
    """1.5 Type for a single adminGroup query result in records format.
    1.5none The name of this group. 1.5none Organization reference
    or id 1.5none Role name 1.5none True if this entity is read-only
    5.1none Shows the identity provider type of the group"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isReadOnly=None, org=None, identityProviderType=None, name=None, roleName=None):
        self.original_tagname_ = None
        super(QueryResultAdminGroupRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isReadOnly = _cast(bool, isReadOnly)
        self.org = _cast(None, org)
        self.identityProviderType = _cast(None, identityProviderType)
        self.name = _cast(None, name)
        self.roleName = _cast(None, roleName)
    def factory(*args_, **kwargs_):
        if QueryResultAdminGroupRecordType.subclass:
            return QueryResultAdminGroupRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminGroupRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isReadOnly(self): return self.isReadOnly
    def set_isReadOnly(self, isReadOnly): self.isReadOnly = isReadOnly
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_identityProviderType(self): return self.identityProviderType
    def set_identityProviderType(self, identityProviderType): self.identityProviderType = identityProviderType
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_roleName(self): return self.roleName
    def set_roleName(self, roleName): self.roleName = roleName
    def hasContent_(self):
        if (
            super(QueryResultAdminGroupRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminGroupRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminGroupRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminGroupRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminGroupRecordType'):
        super(QueryResultAdminGroupRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminGroupRecordType')
        if self.isReadOnly is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            outfile.write(' isReadOnly="%s"' % self.gds_format_boolean(self.isReadOnly, input_name='isReadOnly'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.identityProviderType is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            outfile.write(' identityProviderType=%s' % (self.gds_format_string(quote_attrib(self.identityProviderType).encode(ExternalEncoding), input_name='identityProviderType'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.roleName is not None and 'roleName' not in already_processed:
            already_processed.add('roleName')
            outfile.write(' roleName=%s' % (self.gds_format_string(quote_attrib(self.roleName).encode(ExternalEncoding), input_name='roleName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminGroupRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminGroupRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminGroupRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isReadOnly is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            showIndent(outfile, level)
            outfile.write('isReadOnly=%s,\n' % (self.isReadOnly,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.identityProviderType is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            showIndent(outfile, level)
            outfile.write('identityProviderType="%s",\n' % (self.identityProviderType,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.roleName is not None and 'roleName' not in already_processed:
            already_processed.add('roleName')
            showIndent(outfile, level)
            outfile.write('roleName="%s",\n' % (self.roleName,))
        super(QueryResultAdminGroupRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminGroupRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isReadOnly', node)
        if value is not None and 'isReadOnly' not in already_processed:
            already_processed.add('isReadOnly')
            if value in ('true', '1'):
                self.isReadOnly = True
            elif value in ('false', '0'):
                self.isReadOnly = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('identityProviderType', node)
        if value is not None and 'identityProviderType' not in already_processed:
            already_processed.add('identityProviderType')
            self.identityProviderType = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('roleName', node)
        if value is not None and 'roleName' not in already_processed:
            already_processed.add('roleName')
            self.roleName = value
        super(QueryResultAdminGroupRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminGroupRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminGroupRecordType


class QueryResultAdminVAppNetworkRecordType(QueryResultRecordType):
    """1.5 Type for a single adminVAppNetwork query result in records
    format. 1.5none The name of this network. 1.5none Organization
    reference or id 1.5none True if this network's IP scope is
    inherited. 1.5none Gateway 1.5none Netmask 1.5none Primary DNS
    1.5none Secondary DNS 1.5none DNS suffix 1.5none VApp reference
    or id 1.5none Vapp name 1.5none True if this entity is busy"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, vappName=None, isBusy=None, dns2=None, dns1=None, isIpScopeInherited=None, netmask=None, dnsSuffix=None, org=None, gateway=None, vApp=None):
        self.original_tagname_ = None
        super(QueryResultAdminVAppNetworkRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.vappName = _cast(None, vappName)
        self.isBusy = _cast(bool, isBusy)
        self.dns2 = _cast(None, dns2)
        self.dns1 = _cast(None, dns1)
        self.isIpScopeInherited = _cast(bool, isIpScopeInherited)
        self.netmask = _cast(None, netmask)
        self.dnsSuffix = _cast(None, dnsSuffix)
        self.org = _cast(None, org)
        self.gateway = _cast(None, gateway)
        self.vApp = _cast(None, vApp)
    def factory(*args_, **kwargs_):
        if QueryResultAdminVAppNetworkRecordType.subclass:
            return QueryResultAdminVAppNetworkRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminVAppNetworkRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_vappName(self): return self.vappName
    def set_vappName(self, vappName): self.vappName = vappName
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_dns2(self): return self.dns2
    def set_dns2(self, dns2): self.dns2 = dns2
    def get_dns1(self): return self.dns1
    def set_dns1(self, dns1): self.dns1 = dns1
    def get_isIpScopeInherited(self): return self.isIpScopeInherited
    def set_isIpScopeInherited(self, isIpScopeInherited): self.isIpScopeInherited = isIpScopeInherited
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_dnsSuffix(self): return self.dnsSuffix
    def set_dnsSuffix(self, dnsSuffix): self.dnsSuffix = dnsSuffix
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_vApp(self): return self.vApp
    def set_vApp(self, vApp): self.vApp = vApp
    def hasContent_(self):
        if (
            super(QueryResultAdminVAppNetworkRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminVAppNetworkRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVAppNetworkRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminVAppNetworkRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminVAppNetworkRecordType'):
        super(QueryResultAdminVAppNetworkRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVAppNetworkRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.vappName is not None and 'vappName' not in already_processed:
            already_processed.add('vappName')
            outfile.write(' vappName=%s' % (self.gds_format_string(quote_attrib(self.vappName).encode(ExternalEncoding), input_name='vappName'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            outfile.write(' dns2=%s' % (self.gds_format_string(quote_attrib(self.dns2).encode(ExternalEncoding), input_name='dns2'), ))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            outfile.write(' dns1=%s' % (self.gds_format_string(quote_attrib(self.dns1).encode(ExternalEncoding), input_name='dns1'), ))
        if self.isIpScopeInherited is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            outfile.write(' isIpScopeInherited="%s"' % self.gds_format_boolean(self.isIpScopeInherited, input_name='isIpScopeInherited'))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            outfile.write(' netmask=%s' % (self.gds_format_string(quote_attrib(self.netmask).encode(ExternalEncoding), input_name='netmask'), ))
        if self.dnsSuffix is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            outfile.write(' dnsSuffix=%s' % (self.gds_format_string(quote_attrib(self.dnsSuffix).encode(ExternalEncoding), input_name='dnsSuffix'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            outfile.write(' gateway=%s' % (self.gds_format_string(quote_attrib(self.gateway).encode(ExternalEncoding), input_name='gateway'), ))
        if self.vApp is not None and 'vApp' not in already_processed:
            already_processed.add('vApp')
            outfile.write(' vApp=%s' % (self.gds_format_string(quote_attrib(self.vApp).encode(ExternalEncoding), input_name='vApp'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminVAppNetworkRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminVAppNetworkRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminVAppNetworkRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.vappName is not None and 'vappName' not in already_processed:
            already_processed.add('vappName')
            showIndent(outfile, level)
            outfile.write('vappName="%s",\n' % (self.vappName,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.dns2 is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            showIndent(outfile, level)
            outfile.write('dns2="%s",\n' % (self.dns2,))
        if self.dns1 is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            showIndent(outfile, level)
            outfile.write('dns1="%s",\n' % (self.dns1,))
        if self.isIpScopeInherited is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            showIndent(outfile, level)
            outfile.write('isIpScopeInherited=%s,\n' % (self.isIpScopeInherited,))
        if self.netmask is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            showIndent(outfile, level)
            outfile.write('netmask="%s",\n' % (self.netmask,))
        if self.dnsSuffix is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            showIndent(outfile, level)
            outfile.write('dnsSuffix="%s",\n' % (self.dnsSuffix,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.gateway is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            showIndent(outfile, level)
            outfile.write('gateway="%s",\n' % (self.gateway,))
        if self.vApp is not None and 'vApp' not in already_processed:
            already_processed.add('vApp')
            showIndent(outfile, level)
            outfile.write('vApp="%s",\n' % (self.vApp,))
        super(QueryResultAdminVAppNetworkRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminVAppNetworkRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('vappName', node)
        if value is not None and 'vappName' not in already_processed:
            already_processed.add('vappName')
            self.vappName = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('dns2', node)
        if value is not None and 'dns2' not in already_processed:
            already_processed.add('dns2')
            self.dns2 = value
        value = find_attr_value_('dns1', node)
        if value is not None and 'dns1' not in already_processed:
            already_processed.add('dns1')
            self.dns1 = value
        value = find_attr_value_('isIpScopeInherited', node)
        if value is not None and 'isIpScopeInherited' not in already_processed:
            already_processed.add('isIpScopeInherited')
            if value in ('true', '1'):
                self.isIpScopeInherited = True
            elif value in ('false', '0'):
                self.isIpScopeInherited = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('netmask', node)
        if value is not None and 'netmask' not in already_processed:
            already_processed.add('netmask')
            self.netmask = value
        value = find_attr_value_('dnsSuffix', node)
        if value is not None and 'dnsSuffix' not in already_processed:
            already_processed.add('dnsSuffix')
            self.dnsSuffix = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('gateway', node)
        if value is not None and 'gateway' not in already_processed:
            already_processed.add('gateway')
            self.gateway = value
        value = find_attr_value_('vApp', node)
        if value is not None and 'vApp' not in already_processed:
            already_processed.add('vApp')
            self.vApp = value
        super(QueryResultAdminVAppNetworkRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminVAppNetworkRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminVAppNetworkRecordType


class QueryResultAdminCatalogRecordType(QueryResultRecordType):
    """1.5 Type for a single adminCatalog query result in records format.
    1.5none Organization reference or id 1.5none The name of this
    catalog. 1.5none True if this entity is in a published catalog
    1.5none True if this entity is shared 1.5none Creation date
    1.5none Organization name 1.5none Owner name 1.5none Number of
    vApp templates 1.5none Number of media 1.5none Owner reference
    or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, orgName=None, isPublished=None, ownerName=None, numberOfMedia=None, owner=None, org=None, creationDate=None, numberOfTemplates=None, isShared=None):
        self.original_tagname_ = None
        super(QueryResultAdminCatalogRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.orgName = _cast(None, orgName)
        self.isPublished = _cast(bool, isPublished)
        self.ownerName = _cast(None, ownerName)
        self.numberOfMedia = _cast(int, numberOfMedia)
        self.owner = _cast(None, owner)
        self.org = _cast(None, org)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.numberOfTemplates = _cast(int, numberOfTemplates)
        self.isShared = _cast(bool, isShared)
    def factory(*args_, **kwargs_):
        if QueryResultAdminCatalogRecordType.subclass:
            return QueryResultAdminCatalogRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminCatalogRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_orgName(self): return self.orgName
    def set_orgName(self, orgName): self.orgName = orgName
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_numberOfMedia(self): return self.numberOfMedia
    def set_numberOfMedia(self, numberOfMedia): self.numberOfMedia = numberOfMedia
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_numberOfTemplates(self): return self.numberOfTemplates
    def set_numberOfTemplates(self, numberOfTemplates): self.numberOfTemplates = numberOfTemplates
    def get_isShared(self): return self.isShared
    def set_isShared(self, isShared): self.isShared = isShared
    def hasContent_(self):
        if (
            super(QueryResultAdminCatalogRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminCatalogRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminCatalogRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminCatalogRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminCatalogRecordType'):
        super(QueryResultAdminCatalogRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminCatalogRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            outfile.write(' orgName=%s' % (self.gds_format_string(quote_attrib(self.orgName).encode(ExternalEncoding), input_name='orgName'), ))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.numberOfMedia is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            outfile.write(' numberOfMedia="%s"' % self.gds_format_integer(self.numberOfMedia, input_name='numberOfMedia'))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(' owner=%s' % (self.gds_format_string(quote_attrib(self.owner).encode(ExternalEncoding), input_name='owner'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.numberOfTemplates is not None and 'numberOfTemplates' not in already_processed:
            already_processed.add('numberOfTemplates')
            outfile.write(' numberOfTemplates="%s"' % self.gds_format_integer(self.numberOfTemplates, input_name='numberOfTemplates'))
        if self.isShared is not None and 'isShared' not in already_processed:
            already_processed.add('isShared')
            outfile.write(' isShared="%s"' % self.gds_format_boolean(self.isShared, input_name='isShared'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminCatalogRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminCatalogRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminCatalogRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            showIndent(outfile, level)
            outfile.write('orgName="%s",\n' % (self.orgName,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.numberOfMedia is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            showIndent(outfile, level)
            outfile.write('numberOfMedia=%d,\n' % (self.numberOfMedia,))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            showIndent(outfile, level)
            outfile.write('owner="%s",\n' % (self.owner,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.numberOfTemplates is not None and 'numberOfTemplates' not in already_processed:
            already_processed.add('numberOfTemplates')
            showIndent(outfile, level)
            outfile.write('numberOfTemplates=%d,\n' % (self.numberOfTemplates,))
        if self.isShared is not None and 'isShared' not in already_processed:
            already_processed.add('isShared')
            showIndent(outfile, level)
            outfile.write('isShared=%s,\n' % (self.isShared,))
        super(QueryResultAdminCatalogRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminCatalogRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('orgName', node)
        if value is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            self.orgName = value
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('numberOfMedia', node)
        if value is not None and 'numberOfMedia' not in already_processed:
            already_processed.add('numberOfMedia')
            try:
                self.numberOfMedia = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('numberOfTemplates', node)
        if value is not None and 'numberOfTemplates' not in already_processed:
            already_processed.add('numberOfTemplates')
            try:
                self.numberOfTemplates = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isShared', node)
        if value is not None and 'isShared' not in already_processed:
            already_processed.add('isShared')
            if value in ('true', '1'):
                self.isShared = True
            elif value in ('false', '0'):
                self.isShared = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(QueryResultAdminCatalogRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminCatalogRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminCatalogRecordType


class QueryResultAdminCatalogItemRecordType(QueryResultRecordType):
    """1.5 Type for a single adminCatalogItem query result in records
    format. 1.5none Entity reference or id 1.5none Entity name
    1.5none Entity type 1.5none Catalog reference or id 1.5none
    Catalog name 1.5none Owner name 1.5none Owner reference or id
    1.5none True if this entity is in a published catalog 1.5none
    VDC reference or id 1.5none VDC name 1.5none True if the
    containing VDC is enabled. 1.5none Organization reference or id
    1.5none Creation date 1.5none True if this entity is expired
    1.5none Status 1.5none The name of this catalog item."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, vdcName=None, creationDate=None, name=None, entityName=None, entityType=None, isPublished=None, entity=None, catalog=None, ownerName=None, owner=None, org=None, isExpired=None, vdc=None, isVdcEnabled=None, catalogName=None):
        self.original_tagname_ = None
        super(QueryResultAdminCatalogItemRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.vdcName = _cast(None, vdcName)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.name = _cast(None, name)
        self.entityName = _cast(None, entityName)
        self.entityType = _cast(None, entityType)
        self.isPublished = _cast(bool, isPublished)
        self.entity = _cast(None, entity)
        self.catalog = _cast(None, catalog)
        self.ownerName = _cast(None, ownerName)
        self.owner = _cast(None, owner)
        self.org = _cast(None, org)
        self.isExpired = _cast(bool, isExpired)
        self.vdc = _cast(None, vdc)
        self.isVdcEnabled = _cast(bool, isVdcEnabled)
        self.catalogName = _cast(None, catalogName)
    def factory(*args_, **kwargs_):
        if QueryResultAdminCatalogItemRecordType.subclass:
            return QueryResultAdminCatalogItemRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminCatalogItemRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_entityName(self): return self.entityName
    def set_entityName(self, entityName): self.entityName = entityName
    def get_entityType(self): return self.entityType
    def set_entityType(self, entityType): self.entityType = entityType
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_entity(self): return self.entity
    def set_entity(self, entity): self.entity = entity
    def get_catalog(self): return self.catalog
    def set_catalog(self, catalog): self.catalog = catalog
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_isExpired(self): return self.isExpired
    def set_isExpired(self, isExpired): self.isExpired = isExpired
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_isVdcEnabled(self): return self.isVdcEnabled
    def set_isVdcEnabled(self, isVdcEnabled): self.isVdcEnabled = isVdcEnabled
    def get_catalogName(self): return self.catalogName
    def set_catalogName(self, catalogName): self.catalogName = catalogName
    def hasContent_(self):
        if (
            super(QueryResultAdminCatalogItemRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminCatalogItemRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminCatalogItemRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminCatalogItemRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminCatalogItemRecordType'):
        super(QueryResultAdminCatalogItemRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminCatalogItemRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.entityName is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            outfile.write(' entityName=%s' % (self.gds_format_string(quote_attrib(self.entityName).encode(ExternalEncoding), input_name='entityName'), ))
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            outfile.write(' entityType=%s' % (self.gds_format_string(quote_attrib(self.entityType).encode(ExternalEncoding), input_name='entityType'), ))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.entity is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            outfile.write(' entity=%s' % (self.gds_format_string(quote_attrib(self.entity).encode(ExternalEncoding), input_name='entity'), ))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            outfile.write(' catalog=%s' % (self.gds_format_string(quote_attrib(self.catalog).encode(ExternalEncoding), input_name='catalog'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(' owner=%s' % (self.gds_format_string(quote_attrib(self.owner).encode(ExternalEncoding), input_name='owner'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            outfile.write(' isExpired="%s"' % self.gds_format_boolean(self.isExpired, input_name='isExpired'))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            outfile.write(' isVdcEnabled="%s"' % self.gds_format_boolean(self.isVdcEnabled, input_name='isVdcEnabled'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            outfile.write(' catalogName=%s' % (self.gds_format_string(quote_attrib(self.catalogName).encode(ExternalEncoding), input_name='catalogName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminCatalogItemRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminCatalogItemRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminCatalogItemRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.entityName is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            showIndent(outfile, level)
            outfile.write('entityName="%s",\n' % (self.entityName,))
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            showIndent(outfile, level)
            outfile.write('entityType="%s",\n' % (self.entityType,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.entity is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            showIndent(outfile, level)
            outfile.write('entity="%s",\n' % (self.entity,))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            showIndent(outfile, level)
            outfile.write('catalog="%s",\n' % (self.catalog,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            showIndent(outfile, level)
            outfile.write('owner="%s",\n' % (self.owner,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            showIndent(outfile, level)
            outfile.write('isExpired=%s,\n' % (self.isExpired,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            showIndent(outfile, level)
            outfile.write('isVdcEnabled=%s,\n' % (self.isVdcEnabled,))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            showIndent(outfile, level)
            outfile.write('catalogName="%s",\n' % (self.catalogName,))
        super(QueryResultAdminCatalogItemRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminCatalogItemRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('entityName', node)
        if value is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            self.entityName = value
        value = find_attr_value_('entityType', node)
        if value is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            self.entityType = value
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('entity', node)
        if value is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            self.entity = value
        value = find_attr_value_('catalog', node)
        if value is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            self.catalog = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('isExpired', node)
        if value is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            if value in ('true', '1'):
                self.isExpired = True
            elif value in ('false', '0'):
                self.isExpired = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('isVdcEnabled', node)
        if value is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            if value in ('true', '1'):
                self.isVdcEnabled = True
            elif value in ('false', '0'):
                self.isVdcEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('catalogName', node)
        if value is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            self.catalogName = value
        super(QueryResultAdminCatalogItemRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminCatalogItemRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminCatalogItemRecordType


class QueryResultCatalogItemRecordType(QueryResultRecordType):
    """1.5 Type for a single catalogItem query result in records format.
    1.5none Entity reference or id 1.5none Entity name 1.5none
    Entity type 1.5none Catalog reference or id 1.5none Catalog name
    1.5none Owner name 1.5none Owner reference or id 1.5none True if
    this entity is in a published catalog 1.5none VDC reference or
    id 1.5none VDC name 1.5none True if the containing VDC is
    enabled. 1.5none Creation date 1.5none True if this entity is
    expired 1.5none Status 1.5none The name of this catalog item."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, vdcName=None, creationDate=None, name=None, entityName=None, entityType=None, isPublished=None, entity=None, catalog=None, ownerName=None, owner=None, isExpired=None, vdc=None, isVdcEnabled=None, catalogName=None):
        self.original_tagname_ = None
        super(QueryResultCatalogItemRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.vdcName = _cast(None, vdcName)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.name = _cast(None, name)
        self.entityName = _cast(None, entityName)
        self.entityType = _cast(None, entityType)
        self.isPublished = _cast(bool, isPublished)
        self.entity = _cast(None, entity)
        self.catalog = _cast(None, catalog)
        self.ownerName = _cast(None, ownerName)
        self.owner = _cast(None, owner)
        self.isExpired = _cast(bool, isExpired)
        self.vdc = _cast(None, vdc)
        self.isVdcEnabled = _cast(bool, isVdcEnabled)
        self.catalogName = _cast(None, catalogName)
    def factory(*args_, **kwargs_):
        if QueryResultCatalogItemRecordType.subclass:
            return QueryResultCatalogItemRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultCatalogItemRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_entityName(self): return self.entityName
    def set_entityName(self, entityName): self.entityName = entityName
    def get_entityType(self): return self.entityType
    def set_entityType(self, entityType): self.entityType = entityType
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_entity(self): return self.entity
    def set_entity(self, entity): self.entity = entity
    def get_catalog(self): return self.catalog
    def set_catalog(self, catalog): self.catalog = catalog
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_isExpired(self): return self.isExpired
    def set_isExpired(self, isExpired): self.isExpired = isExpired
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_isVdcEnabled(self): return self.isVdcEnabled
    def set_isVdcEnabled(self, isVdcEnabled): self.isVdcEnabled = isVdcEnabled
    def get_catalogName(self): return self.catalogName
    def set_catalogName(self, catalogName): self.catalogName = catalogName
    def hasContent_(self):
        if (
            super(QueryResultCatalogItemRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultCatalogItemRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultCatalogItemRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultCatalogItemRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultCatalogItemRecordType'):
        super(QueryResultCatalogItemRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultCatalogItemRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.entityName is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            outfile.write(' entityName=%s' % (self.gds_format_string(quote_attrib(self.entityName).encode(ExternalEncoding), input_name='entityName'), ))
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            outfile.write(' entityType=%s' % (self.gds_format_string(quote_attrib(self.entityType).encode(ExternalEncoding), input_name='entityType'), ))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.entity is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            outfile.write(' entity=%s' % (self.gds_format_string(quote_attrib(self.entity).encode(ExternalEncoding), input_name='entity'), ))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            outfile.write(' catalog=%s' % (self.gds_format_string(quote_attrib(self.catalog).encode(ExternalEncoding), input_name='catalog'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(' owner=%s' % (self.gds_format_string(quote_attrib(self.owner).encode(ExternalEncoding), input_name='owner'), ))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            outfile.write(' isExpired="%s"' % self.gds_format_boolean(self.isExpired, input_name='isExpired'))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            outfile.write(' isVdcEnabled="%s"' % self.gds_format_boolean(self.isVdcEnabled, input_name='isVdcEnabled'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            outfile.write(' catalogName=%s' % (self.gds_format_string(quote_attrib(self.catalogName).encode(ExternalEncoding), input_name='catalogName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultCatalogItemRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultCatalogItemRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultCatalogItemRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.entityName is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            showIndent(outfile, level)
            outfile.write('entityName="%s",\n' % (self.entityName,))
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            showIndent(outfile, level)
            outfile.write('entityType="%s",\n' % (self.entityType,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.entity is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            showIndent(outfile, level)
            outfile.write('entity="%s",\n' % (self.entity,))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            showIndent(outfile, level)
            outfile.write('catalog="%s",\n' % (self.catalog,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            showIndent(outfile, level)
            outfile.write('owner="%s",\n' % (self.owner,))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            showIndent(outfile, level)
            outfile.write('isExpired=%s,\n' % (self.isExpired,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            showIndent(outfile, level)
            outfile.write('isVdcEnabled=%s,\n' % (self.isVdcEnabled,))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            showIndent(outfile, level)
            outfile.write('catalogName="%s",\n' % (self.catalogName,))
        super(QueryResultCatalogItemRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultCatalogItemRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('entityName', node)
        if value is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            self.entityName = value
        value = find_attr_value_('entityType', node)
        if value is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            self.entityType = value
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('entity', node)
        if value is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            self.entity = value
        value = find_attr_value_('catalog', node)
        if value is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            self.catalog = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('isExpired', node)
        if value is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            if value in ('true', '1'):
                self.isExpired = True
            elif value in ('false', '0'):
                self.isExpired = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('isVdcEnabled', node)
        if value is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            if value in ('true', '1'):
                self.isVdcEnabled = True
            elif value in ('false', '0'):
                self.isVdcEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('catalogName', node)
        if value is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            self.catalogName = value
        super(QueryResultCatalogItemRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultCatalogItemRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultCatalogItemRecordType


class QueryResultAdminMediaRecordType(QueryResultRecordType):
    """1.5 Type for a single adminMedia query result in records format.
    1.5none Organization reference or id 1.5none Owner name 1.5none
    Owner reference or id 1.5none True if this entity is in a
    published catalog 1.5none The name of this media object. 1.5none
    Storage in Bytes 1.5none VDC reference or id 1.5none VDC name
    1.5none True if the containing VDC is enabled. 1.5none Catalog
    reference or id 1.5none Catalog name 1.5none Catalog item
    reference or id 1.5none Creation date 1.5none True if this
    entity is busy 1.5none Status 5.1none Storage profile name"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, storageProfileName=None, name=None, storageB=None, isPublished=None, vdcName=None, catalog=None, vdc=None, catalogItem=None, ownerName=None, isBusy=None, owner=None, org=None, creationDate=None, isVdcEnabled=None, catalogName=None):
        self.original_tagname_ = None
        super(QueryResultAdminMediaRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.storageProfileName = _cast(None, storageProfileName)
        self.name = _cast(None, name)
        self.storageB = _cast(int, storageB)
        self.isPublished = _cast(bool, isPublished)
        self.vdcName = _cast(None, vdcName)
        self.catalog = _cast(None, catalog)
        self.vdc = _cast(None, vdc)
        self.catalogItem = _cast(None, catalogItem)
        self.ownerName = _cast(None, ownerName)
        self.isBusy = _cast(bool, isBusy)
        self.owner = _cast(None, owner)
        self.org = _cast(None, org)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.isVdcEnabled = _cast(bool, isVdcEnabled)
        self.catalogName = _cast(None, catalogName)
    def factory(*args_, **kwargs_):
        if QueryResultAdminMediaRecordType.subclass:
            return QueryResultAdminMediaRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminMediaRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_storageProfileName(self): return self.storageProfileName
    def set_storageProfileName(self, storageProfileName): self.storageProfileName = storageProfileName
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_storageB(self): return self.storageB
    def set_storageB(self, storageB): self.storageB = storageB
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_catalog(self): return self.catalog
    def set_catalog(self, catalog): self.catalog = catalog
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_catalogItem(self): return self.catalogItem
    def set_catalogItem(self, catalogItem): self.catalogItem = catalogItem
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_isVdcEnabled(self): return self.isVdcEnabled
    def set_isVdcEnabled(self, isVdcEnabled): self.isVdcEnabled = isVdcEnabled
    def get_catalogName(self): return self.catalogName
    def set_catalogName(self, catalogName): self.catalogName = catalogName
    def hasContent_(self):
        if (
            super(QueryResultAdminMediaRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminMediaRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminMediaRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminMediaRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminMediaRecordType'):
        super(QueryResultAdminMediaRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminMediaRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            outfile.write(' storageProfileName=%s' % (self.gds_format_string(quote_attrib(self.storageProfileName).encode(ExternalEncoding), input_name='storageProfileName'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.storageB is not None and 'storageB' not in already_processed:
            already_processed.add('storageB')
            outfile.write(' storageB="%s"' % self.gds_format_integer(self.storageB, input_name='storageB'))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            outfile.write(' catalog=%s' % (self.gds_format_string(quote_attrib(self.catalog).encode(ExternalEncoding), input_name='catalog'), ))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.catalogItem is not None and 'catalogItem' not in already_processed:
            already_processed.add('catalogItem')
            outfile.write(' catalogItem=%s' % (self.gds_format_string(quote_attrib(self.catalogItem).encode(ExternalEncoding), input_name='catalogItem'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(' owner=%s' % (self.gds_format_string(quote_attrib(self.owner).encode(ExternalEncoding), input_name='owner'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            outfile.write(' isVdcEnabled="%s"' % self.gds_format_boolean(self.isVdcEnabled, input_name='isVdcEnabled'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            outfile.write(' catalogName=%s' % (self.gds_format_string(quote_attrib(self.catalogName).encode(ExternalEncoding), input_name='catalogName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminMediaRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminMediaRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminMediaRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            showIndent(outfile, level)
            outfile.write('storageProfileName="%s",\n' % (self.storageProfileName,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.storageB is not None and 'storageB' not in already_processed:
            already_processed.add('storageB')
            showIndent(outfile, level)
            outfile.write('storageB=%d,\n' % (self.storageB,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            showIndent(outfile, level)
            outfile.write('catalog="%s",\n' % (self.catalog,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.catalogItem is not None and 'catalogItem' not in already_processed:
            already_processed.add('catalogItem')
            showIndent(outfile, level)
            outfile.write('catalogItem="%s",\n' % (self.catalogItem,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            showIndent(outfile, level)
            outfile.write('owner="%s",\n' % (self.owner,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            showIndent(outfile, level)
            outfile.write('isVdcEnabled=%s,\n' % (self.isVdcEnabled,))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            showIndent(outfile, level)
            outfile.write('catalogName="%s",\n' % (self.catalogName,))
        super(QueryResultAdminMediaRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminMediaRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('storageProfileName', node)
        if value is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            self.storageProfileName = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('storageB', node)
        if value is not None and 'storageB' not in already_processed:
            already_processed.add('storageB')
            try:
                self.storageB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('catalog', node)
        if value is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            self.catalog = value
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('catalogItem', node)
        if value is not None and 'catalogItem' not in already_processed:
            already_processed.add('catalogItem')
            self.catalogItem = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('isVdcEnabled', node)
        if value is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            if value in ('true', '1'):
                self.isVdcEnabled = True
            elif value in ('false', '0'):
                self.isVdcEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('catalogName', node)
        if value is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            self.catalogName = value
        super(QueryResultAdminMediaRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminMediaRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminMediaRecordType


class QueryResultAdminVAppTemplateRecordType(QueryResultRecordType):
    """1.5 Type for a single adminVAppTemplate query result in records
    format. 1.5none Organization reference or id 1.5none Owner name
    1.5none Owner reference or id 1.5none True if this entity is in
    a published catalog. 1.5none The name of this vApp template.
    1.5none VDC reference or id 1.5none VDC name 1.5none True if the
    containing VDC is enabled. 1.5none Catalog reference or id
    1.5none Catalog name 1.5none Catalog item reference or id
    1.5none Creation date 1.5none True if this entity is busy
    1.5none True if this template is marked as a gold master 1.5none
    True if this entity is enabled 1.5none True if this entity is
    expired 1.5none True if this entity is deployed 1.5none Status
    5.1none Storage profile name"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isGoldMaster=None, status=None, isDeployed=None, name=None, storageProfileName=None, isEnabled=None, isPublished=None, vdcName=None, catalog=None, vdc=None, catalogItem=None, ownerName=None, isBusy=None, owner=None, org=None, isExpired=None, creationDate=None, isVdcEnabled=None, catalogName=None):
        self.original_tagname_ = None
        super(QueryResultAdminVAppTemplateRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isGoldMaster = _cast(bool, isGoldMaster)
        self.status = _cast(None, status)
        self.isDeployed = _cast(bool, isDeployed)
        self.name = _cast(None, name)
        self.storageProfileName = _cast(None, storageProfileName)
        self.isEnabled = _cast(bool, isEnabled)
        self.isPublished = _cast(bool, isPublished)
        self.vdcName = _cast(None, vdcName)
        self.catalog = _cast(None, catalog)
        self.vdc = _cast(None, vdc)
        self.catalogItem = _cast(None, catalogItem)
        self.ownerName = _cast(None, ownerName)
        self.isBusy = _cast(bool, isBusy)
        self.owner = _cast(None, owner)
        self.org = _cast(None, org)
        self.isExpired = _cast(bool, isExpired)
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
        self.isVdcEnabled = _cast(bool, isVdcEnabled)
        self.catalogName = _cast(None, catalogName)
    def factory(*args_, **kwargs_):
        if QueryResultAdminVAppTemplateRecordType.subclass:
            return QueryResultAdminVAppTemplateRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminVAppTemplateRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isGoldMaster(self): return self.isGoldMaster
    def set_isGoldMaster(self, isGoldMaster): self.isGoldMaster = isGoldMaster
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_isDeployed(self): return self.isDeployed
    def set_isDeployed(self, isDeployed): self.isDeployed = isDeployed
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_storageProfileName(self): return self.storageProfileName
    def set_storageProfileName(self, storageProfileName): self.storageProfileName = storageProfileName
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_catalog(self): return self.catalog
    def set_catalog(self, catalog): self.catalog = catalog
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_catalogItem(self): return self.catalogItem
    def set_catalogItem(self, catalogItem): self.catalogItem = catalogItem
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_isExpired(self): return self.isExpired
    def set_isExpired(self, isExpired): self.isExpired = isExpired
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def get_isVdcEnabled(self): return self.isVdcEnabled
    def set_isVdcEnabled(self, isVdcEnabled): self.isVdcEnabled = isVdcEnabled
    def get_catalogName(self): return self.catalogName
    def set_catalogName(self, catalogName): self.catalogName = catalogName
    def hasContent_(self):
        if (
            super(QueryResultAdminVAppTemplateRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminVAppTemplateRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVAppTemplateRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminVAppTemplateRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminVAppTemplateRecordType'):
        super(QueryResultAdminVAppTemplateRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVAppTemplateRecordType')
        if self.isGoldMaster is not None and 'isGoldMaster' not in already_processed:
            already_processed.add('isGoldMaster')
            outfile.write(' isGoldMaster="%s"' % self.gds_format_boolean(self.isGoldMaster, input_name='isGoldMaster'))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            outfile.write(' isDeployed="%s"' % self.gds_format_boolean(self.isDeployed, input_name='isDeployed'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            outfile.write(' storageProfileName=%s' % (self.gds_format_string(quote_attrib(self.storageProfileName).encode(ExternalEncoding), input_name='storageProfileName'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            outfile.write(' catalog=%s' % (self.gds_format_string(quote_attrib(self.catalog).encode(ExternalEncoding), input_name='catalog'), ))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.catalogItem is not None and 'catalogItem' not in already_processed:
            already_processed.add('catalogItem')
            outfile.write(' catalogItem=%s' % (self.gds_format_string(quote_attrib(self.catalogItem).encode(ExternalEncoding), input_name='catalogItem'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(' owner=%s' % (self.gds_format_string(quote_attrib(self.owner).encode(ExternalEncoding), input_name='owner'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            outfile.write(' isExpired="%s"' % self.gds_format_boolean(self.isExpired, input_name='isExpired'))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            outfile.write(' isVdcEnabled="%s"' % self.gds_format_boolean(self.isVdcEnabled, input_name='isVdcEnabled'))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            outfile.write(' catalogName=%s' % (self.gds_format_string(quote_attrib(self.catalogName).encode(ExternalEncoding), input_name='catalogName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminVAppTemplateRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminVAppTemplateRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminVAppTemplateRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isGoldMaster is not None and 'isGoldMaster' not in already_processed:
            already_processed.add('isGoldMaster')
            showIndent(outfile, level)
            outfile.write('isGoldMaster=%s,\n' % (self.isGoldMaster,))
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.isDeployed is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            showIndent(outfile, level)
            outfile.write('isDeployed=%s,\n' % (self.isDeployed,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            showIndent(outfile, level)
            outfile.write('storageProfileName="%s",\n' % (self.storageProfileName,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.catalog is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            showIndent(outfile, level)
            outfile.write('catalog="%s",\n' % (self.catalog,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.catalogItem is not None and 'catalogItem' not in already_processed:
            already_processed.add('catalogItem')
            showIndent(outfile, level)
            outfile.write('catalogItem="%s",\n' % (self.catalogItem,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            showIndent(outfile, level)
            outfile.write('owner="%s",\n' % (self.owner,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.isExpired is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            showIndent(outfile, level)
            outfile.write('isExpired=%s,\n' % (self.isExpired,))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        if self.isVdcEnabled is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            showIndent(outfile, level)
            outfile.write('isVdcEnabled=%s,\n' % (self.isVdcEnabled,))
        if self.catalogName is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            showIndent(outfile, level)
            outfile.write('catalogName="%s",\n' % (self.catalogName,))
        super(QueryResultAdminVAppTemplateRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminVAppTemplateRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isGoldMaster', node)
        if value is not None and 'isGoldMaster' not in already_processed:
            already_processed.add('isGoldMaster')
            if value in ('true', '1'):
                self.isGoldMaster = True
            elif value in ('false', '0'):
                self.isGoldMaster = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('isDeployed', node)
        if value is not None and 'isDeployed' not in already_processed:
            already_processed.add('isDeployed')
            if value in ('true', '1'):
                self.isDeployed = True
            elif value in ('false', '0'):
                self.isDeployed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('storageProfileName', node)
        if value is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            self.storageProfileName = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('catalog', node)
        if value is not None and 'catalog' not in already_processed:
            already_processed.add('catalog')
            self.catalog = value
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('catalogItem', node)
        if value is not None and 'catalogItem' not in already_processed:
            already_processed.add('catalogItem')
            self.catalogItem = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('isExpired', node)
        if value is not None and 'isExpired' not in already_processed:
            already_processed.add('isExpired')
            if value in ('true', '1'):
                self.isExpired = True
            elif value in ('false', '0'):
                self.isExpired = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        value = find_attr_value_('isVdcEnabled', node)
        if value is not None and 'isVdcEnabled' not in already_processed:
            already_processed.add('isVdcEnabled')
            if value in ('true', '1'):
                self.isVdcEnabled = True
            elif value in ('false', '0'):
                self.isVdcEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('catalogName', node)
        if value is not None and 'catalogName' not in already_processed:
            already_processed.add('catalogName')
            self.catalogName = value
        super(QueryResultAdminVAppTemplateRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminVAppTemplateRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminVAppTemplateRecordType


class QueryResultAdminShadowVMRecordType(QueryResultRecordType):
    """1.5 Type for a single adminShadowVM query result in records format.
    1.5none True if this entity is in a published catalog 1.5none
    Entity name 1.5none Primary VM name 1.55.1none Shadow vApp
    reference or id 1.5none Primary vApp template reference or id
    1.5none Primary vApp name 1.5none Datastore name 1.5none Vitual
    center name 1.5none True if this entity is deleted 1.5none
    Status 1.5none True if this entity is busy 1.5none Primary VM
    owner reference or id 1.5none Primary VM refernce or id 1.5none
    Primary VM catalog reference or id 1.5none Organization
    reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, primaryVMOwner=None, name=None, isDeleted=None, datastoreName=None, org=None, isPublished=None, isBusy=None, shadowVApp=None, primaryVMCatalog=None, primaryVAppName=None, primaryVAppTemplate=None, primaryVmName=None, primaryVM=None, vcName=None):
        self.original_tagname_ = None
        super(QueryResultAdminShadowVMRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.primaryVMOwner = _cast(None, primaryVMOwner)
        self.name = _cast(None, name)
        self.isDeleted = _cast(bool, isDeleted)
        self.datastoreName = _cast(None, datastoreName)
        self.org = _cast(None, org)
        self.isPublished = _cast(bool, isPublished)
        self.isBusy = _cast(bool, isBusy)
        self.shadowVApp = _cast(None, shadowVApp)
        self.primaryVMCatalog = _cast(None, primaryVMCatalog)
        self.primaryVAppName = _cast(None, primaryVAppName)
        self.primaryVAppTemplate = _cast(None, primaryVAppTemplate)
        self.primaryVmName = _cast(None, primaryVmName)
        self.primaryVM = _cast(None, primaryVM)
        self.vcName = _cast(None, vcName)
    def factory(*args_, **kwargs_):
        if QueryResultAdminShadowVMRecordType.subclass:
            return QueryResultAdminShadowVMRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminShadowVMRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_primaryVMOwner(self): return self.primaryVMOwner
    def set_primaryVMOwner(self, primaryVMOwner): self.primaryVMOwner = primaryVMOwner
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isDeleted(self): return self.isDeleted
    def set_isDeleted(self, isDeleted): self.isDeleted = isDeleted
    def get_datastoreName(self): return self.datastoreName
    def set_datastoreName(self, datastoreName): self.datastoreName = datastoreName
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_isPublished(self): return self.isPublished
    def set_isPublished(self, isPublished): self.isPublished = isPublished
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def get_shadowVApp(self): return self.shadowVApp
    def set_shadowVApp(self, shadowVApp): self.shadowVApp = shadowVApp
    def get_primaryVMCatalog(self): return self.primaryVMCatalog
    def set_primaryVMCatalog(self, primaryVMCatalog): self.primaryVMCatalog = primaryVMCatalog
    def get_primaryVAppName(self): return self.primaryVAppName
    def set_primaryVAppName(self, primaryVAppName): self.primaryVAppName = primaryVAppName
    def get_primaryVAppTemplate(self): return self.primaryVAppTemplate
    def set_primaryVAppTemplate(self, primaryVAppTemplate): self.primaryVAppTemplate = primaryVAppTemplate
    def get_primaryVmName(self): return self.primaryVmName
    def set_primaryVmName(self, primaryVmName): self.primaryVmName = primaryVmName
    def get_primaryVM(self): return self.primaryVM
    def set_primaryVM(self, primaryVM): self.primaryVM = primaryVM
    def get_vcName(self): return self.vcName
    def set_vcName(self, vcName): self.vcName = vcName
    def hasContent_(self):
        if (
            super(QueryResultAdminShadowVMRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminShadowVMRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminShadowVMRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminShadowVMRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminShadowVMRecordType'):
        super(QueryResultAdminShadowVMRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminShadowVMRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.primaryVMOwner is not None and 'primaryVMOwner' not in already_processed:
            already_processed.add('primaryVMOwner')
            outfile.write(' primaryVMOwner=%s' % (self.gds_format_string(quote_attrib(self.primaryVMOwner).encode(ExternalEncoding), input_name='primaryVMOwner'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            outfile.write(' isDeleted="%s"' % self.gds_format_boolean(self.isDeleted, input_name='isDeleted'))
        if self.datastoreName is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            outfile.write(' datastoreName=%s' % (self.gds_format_string(quote_attrib(self.datastoreName).encode(ExternalEncoding), input_name='datastoreName'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            outfile.write(' isPublished="%s"' % self.gds_format_boolean(self.isPublished, input_name='isPublished'))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            outfile.write(' isBusy="%s"' % self.gds_format_boolean(self.isBusy, input_name='isBusy'))
        if self.shadowVApp is not None and 'shadowVApp' not in already_processed:
            already_processed.add('shadowVApp')
            outfile.write(' shadowVApp=%s' % (self.gds_format_string(quote_attrib(self.shadowVApp).encode(ExternalEncoding), input_name='shadowVApp'), ))
        if self.primaryVMCatalog is not None and 'primaryVMCatalog' not in already_processed:
            already_processed.add('primaryVMCatalog')
            outfile.write(' primaryVMCatalog=%s' % (self.gds_format_string(quote_attrib(self.primaryVMCatalog).encode(ExternalEncoding), input_name='primaryVMCatalog'), ))
        if self.primaryVAppName is not None and 'primaryVAppName' not in already_processed:
            already_processed.add('primaryVAppName')
            outfile.write(' primaryVAppName=%s' % (self.gds_format_string(quote_attrib(self.primaryVAppName).encode(ExternalEncoding), input_name='primaryVAppName'), ))
        if self.primaryVAppTemplate is not None and 'primaryVAppTemplate' not in already_processed:
            already_processed.add('primaryVAppTemplate')
            outfile.write(' primaryVAppTemplate=%s' % (self.gds_format_string(quote_attrib(self.primaryVAppTemplate).encode(ExternalEncoding), input_name='primaryVAppTemplate'), ))
        if self.primaryVmName is not None and 'primaryVmName' not in already_processed:
            already_processed.add('primaryVmName')
            outfile.write(' primaryVmName=%s' % (self.gds_format_string(quote_attrib(self.primaryVmName).encode(ExternalEncoding), input_name='primaryVmName'), ))
        if self.primaryVM is not None and 'primaryVM' not in already_processed:
            already_processed.add('primaryVM')
            outfile.write(' primaryVM=%s' % (self.gds_format_string(quote_attrib(self.primaryVM).encode(ExternalEncoding), input_name='primaryVM'), ))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            outfile.write(' vcName=%s' % (self.gds_format_string(quote_attrib(self.vcName).encode(ExternalEncoding), input_name='vcName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminShadowVMRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminShadowVMRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminShadowVMRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.primaryVMOwner is not None and 'primaryVMOwner' not in already_processed:
            already_processed.add('primaryVMOwner')
            showIndent(outfile, level)
            outfile.write('primaryVMOwner="%s",\n' % (self.primaryVMOwner,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isDeleted is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            showIndent(outfile, level)
            outfile.write('isDeleted=%s,\n' % (self.isDeleted,))
        if self.datastoreName is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            showIndent(outfile, level)
            outfile.write('datastoreName="%s",\n' % (self.datastoreName,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.isPublished is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            showIndent(outfile, level)
            outfile.write('isPublished=%s,\n' % (self.isPublished,))
        if self.isBusy is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            showIndent(outfile, level)
            outfile.write('isBusy=%s,\n' % (self.isBusy,))
        if self.shadowVApp is not None and 'shadowVApp' not in already_processed:
            already_processed.add('shadowVApp')
            showIndent(outfile, level)
            outfile.write('shadowVApp="%s",\n' % (self.shadowVApp,))
        if self.primaryVMCatalog is not None and 'primaryVMCatalog' not in already_processed:
            already_processed.add('primaryVMCatalog')
            showIndent(outfile, level)
            outfile.write('primaryVMCatalog="%s",\n' % (self.primaryVMCatalog,))
        if self.primaryVAppName is not None and 'primaryVAppName' not in already_processed:
            already_processed.add('primaryVAppName')
            showIndent(outfile, level)
            outfile.write('primaryVAppName="%s",\n' % (self.primaryVAppName,))
        if self.primaryVAppTemplate is not None and 'primaryVAppTemplate' not in already_processed:
            already_processed.add('primaryVAppTemplate')
            showIndent(outfile, level)
            outfile.write('primaryVAppTemplate="%s",\n' % (self.primaryVAppTemplate,))
        if self.primaryVmName is not None and 'primaryVmName' not in already_processed:
            already_processed.add('primaryVmName')
            showIndent(outfile, level)
            outfile.write('primaryVmName="%s",\n' % (self.primaryVmName,))
        if self.primaryVM is not None and 'primaryVM' not in already_processed:
            already_processed.add('primaryVM')
            showIndent(outfile, level)
            outfile.write('primaryVM="%s",\n' % (self.primaryVM,))
        if self.vcName is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            showIndent(outfile, level)
            outfile.write('vcName="%s",\n' % (self.vcName,))
        super(QueryResultAdminShadowVMRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminShadowVMRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('primaryVMOwner', node)
        if value is not None and 'primaryVMOwner' not in already_processed:
            already_processed.add('primaryVMOwner')
            self.primaryVMOwner = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isDeleted', node)
        if value is not None and 'isDeleted' not in already_processed:
            already_processed.add('isDeleted')
            if value in ('true', '1'):
                self.isDeleted = True
            elif value in ('false', '0'):
                self.isDeleted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('datastoreName', node)
        if value is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            self.datastoreName = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('isPublished', node)
        if value is not None and 'isPublished' not in already_processed:
            already_processed.add('isPublished')
            if value in ('true', '1'):
                self.isPublished = True
            elif value in ('false', '0'):
                self.isPublished = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('isBusy', node)
        if value is not None and 'isBusy' not in already_processed:
            already_processed.add('isBusy')
            if value in ('true', '1'):
                self.isBusy = True
            elif value in ('false', '0'):
                self.isBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('shadowVApp', node)
        if value is not None and 'shadowVApp' not in already_processed:
            already_processed.add('shadowVApp')
            self.shadowVApp = value
        value = find_attr_value_('primaryVMCatalog', node)
        if value is not None and 'primaryVMCatalog' not in already_processed:
            already_processed.add('primaryVMCatalog')
            self.primaryVMCatalog = value
        value = find_attr_value_('primaryVAppName', node)
        if value is not None and 'primaryVAppName' not in already_processed:
            already_processed.add('primaryVAppName')
            self.primaryVAppName = value
        value = find_attr_value_('primaryVAppTemplate', node)
        if value is not None and 'primaryVAppTemplate' not in already_processed:
            already_processed.add('primaryVAppTemplate')
            self.primaryVAppTemplate = value
        value = find_attr_value_('primaryVmName', node)
        if value is not None and 'primaryVmName' not in already_processed:
            already_processed.add('primaryVmName')
            self.primaryVmName = value
        value = find_attr_value_('primaryVM', node)
        if value is not None and 'primaryVM' not in already_processed:
            already_processed.add('primaryVM')
            self.primaryVM = value
        value = find_attr_value_('vcName', node)
        if value is not None and 'vcName' not in already_processed:
            already_processed.add('vcName')
            self.vcName = value
        super(QueryResultAdminShadowVMRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminShadowVMRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminShadowVMRecordType


class QueryResultTaskRecordType(QueryResultRecordType):
    """1.5 Type for a single task query result in records format. 1.5none
    Organization reference or id 1.5none Organization name 1.5none
    The name of this task. 1.5none Start date 1.5none End date
    1.5none Status 1.5none Owner name 1.5none Object 1.5none Object
    type 1.5none Object name 5.1none Service name space"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, startDate=None, endDate=None, name=None, objectName=None, orgName=None, object=None, ownerName=None, org=None, serviceNamespace=None, objectType=None):
        self.original_tagname_ = None
        super(QueryResultTaskRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        if isinstance(startDate, basestring):
            initvalue_ = datetime_.datetime.strptime(startDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = startDate
        self.startDate = initvalue_
        if isinstance(endDate, basestring):
            initvalue_ = datetime_.datetime.strptime(endDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = endDate
        self.endDate = initvalue_
        self.name = _cast(None, name)
        self.objectName = _cast(None, objectName)
        self.orgName = _cast(None, orgName)
        self.object = _cast(None, object)
        self.ownerName = _cast(None, ownerName)
        self.org = _cast(None, org)
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.objectType = _cast(None, objectType)
    def factory(*args_, **kwargs_):
        if QueryResultTaskRecordType.subclass:
            return QueryResultTaskRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultTaskRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_startDate(self): return self.startDate
    def set_startDate(self, startDate): self.startDate = startDate
    def get_endDate(self): return self.endDate
    def set_endDate(self, endDate): self.endDate = endDate
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_objectName(self): return self.objectName
    def set_objectName(self, objectName): self.objectName = objectName
    def get_orgName(self): return self.orgName
    def set_orgName(self, orgName): self.orgName = orgName
    def get_object(self): return self.object
    def set_object(self, object): self.object = object
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def get_objectType(self): return self.objectType
    def set_objectType(self, objectType): self.objectType = objectType
    def hasContent_(self):
        if (
            super(QueryResultTaskRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultTaskRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultTaskRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultTaskRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultTaskRecordType'):
        super(QueryResultTaskRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultTaskRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.startDate is not None and 'startDate' not in already_processed:
            already_processed.add('startDate')
            outfile.write(' startDate="%s"' % self.gds_format_datetime(self.startDate, input_name='startDate'))
        if self.endDate is not None and 'endDate' not in already_processed:
            already_processed.add('endDate')
            outfile.write(' endDate="%s"' % self.gds_format_datetime(self.endDate, input_name='endDate'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.objectName is not None and 'objectName' not in already_processed:
            already_processed.add('objectName')
            outfile.write(' objectName=%s' % (self.gds_format_string(quote_attrib(self.objectName).encode(ExternalEncoding), input_name='objectName'), ))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            outfile.write(' orgName=%s' % (self.gds_format_string(quote_attrib(self.orgName).encode(ExternalEncoding), input_name='orgName'), ))
        if self.object is not None and 'object' not in already_processed:
            already_processed.add('object')
            outfile.write(' object=%s' % (self.gds_format_string(quote_attrib(self.object).encode(ExternalEncoding), input_name='object'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
        if self.objectType is not None and 'objectType' not in already_processed:
            already_processed.add('objectType')
            outfile.write(' objectType=%s' % (self.gds_format_string(quote_attrib(self.objectType).encode(ExternalEncoding), input_name='objectType'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultTaskRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultTaskRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultTaskRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.startDate is not None and 'startDate' not in already_processed:
            already_processed.add('startDate')
            showIndent(outfile, level)
            outfile.write('startDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.startDate, input_name='startDate'))
        if self.endDate is not None and 'endDate' not in already_processed:
            already_processed.add('endDate')
            showIndent(outfile, level)
            outfile.write('endDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.endDate, input_name='endDate'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.objectName is not None and 'objectName' not in already_processed:
            already_processed.add('objectName')
            showIndent(outfile, level)
            outfile.write('objectName="%s",\n' % (self.objectName,))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            showIndent(outfile, level)
            outfile.write('orgName="%s",\n' % (self.orgName,))
        if self.object is not None and 'object' not in already_processed:
            already_processed.add('object')
            showIndent(outfile, level)
            outfile.write('object="%s",\n' % (self.object,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        if self.objectType is not None and 'objectType' not in already_processed:
            already_processed.add('objectType')
            showIndent(outfile, level)
            outfile.write('objectType="%s",\n' % (self.objectType,))
        super(QueryResultTaskRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultTaskRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('startDate', node)
        if value is not None and 'startDate' not in already_processed:
            already_processed.add('startDate')
            try:
                self.startDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (startDate): %s' % exp)
        value = find_attr_value_('endDate', node)
        if value is not None and 'endDate' not in already_processed:
            already_processed.add('endDate')
            try:
                self.endDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (endDate): %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('objectName', node)
        if value is not None and 'objectName' not in already_processed:
            already_processed.add('objectName')
            self.objectName = value
        value = find_attr_value_('orgName', node)
        if value is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            self.orgName = value
        value = find_attr_value_('object', node)
        if value is not None and 'object' not in already_processed:
            already_processed.add('object')
            self.object = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        value = find_attr_value_('objectType', node)
        if value is not None and 'objectType' not in already_processed:
            already_processed.add('objectType')
            self.objectType = value
        super(QueryResultTaskRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultTaskRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultTaskRecordType


class QueryResultAdminTaskRecordType(QueryResultRecordType):
    """1.5 Type for a single adminTask query result in records format.
    1.5none Organization reference or id 1.5none Organization name
    1.5none The name of this task. 1.5none Start date 1.5none End
    date 1.5none Status 1.5none Owner reference or id 1.5none Owner
    name 1.5none Object 1.5none Object type 1.5none Object name
    1.5none Cell name 5.1none Service name space 5.1none True if
    this task has an owner."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, startDate=None, endDate=None, name=None, objectName=None, orgName=None, cellName=None, object=None, hasOwner=None, ownerName=None, owner=None, org=None, serviceNamespace=None, objectType=None):
        self.original_tagname_ = None
        super(QueryResultAdminTaskRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        if isinstance(startDate, basestring):
            initvalue_ = datetime_.datetime.strptime(startDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = startDate
        self.startDate = initvalue_
        if isinstance(endDate, basestring):
            initvalue_ = datetime_.datetime.strptime(endDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = endDate
        self.endDate = initvalue_
        self.name = _cast(None, name)
        self.objectName = _cast(None, objectName)
        self.orgName = _cast(None, orgName)
        self.cellName = _cast(None, cellName)
        self.object = _cast(None, object)
        self.hasOwner = _cast(bool, hasOwner)
        self.ownerName = _cast(None, ownerName)
        self.owner = _cast(None, owner)
        self.org = _cast(None, org)
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.objectType = _cast(None, objectType)
    def factory(*args_, **kwargs_):
        if QueryResultAdminTaskRecordType.subclass:
            return QueryResultAdminTaskRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminTaskRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_startDate(self): return self.startDate
    def set_startDate(self, startDate): self.startDate = startDate
    def get_endDate(self): return self.endDate
    def set_endDate(self, endDate): self.endDate = endDate
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_objectName(self): return self.objectName
    def set_objectName(self, objectName): self.objectName = objectName
    def get_orgName(self): return self.orgName
    def set_orgName(self, orgName): self.orgName = orgName
    def get_cellName(self): return self.cellName
    def set_cellName(self, cellName): self.cellName = cellName
    def get_object(self): return self.object
    def set_object(self, object): self.object = object
    def get_hasOwner(self): return self.hasOwner
    def set_hasOwner(self, hasOwner): self.hasOwner = hasOwner
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def get_objectType(self): return self.objectType
    def set_objectType(self, objectType): self.objectType = objectType
    def hasContent_(self):
        if (
            super(QueryResultAdminTaskRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminTaskRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminTaskRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminTaskRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminTaskRecordType'):
        super(QueryResultAdminTaskRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminTaskRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.startDate is not None and 'startDate' not in already_processed:
            already_processed.add('startDate')
            outfile.write(' startDate="%s"' % self.gds_format_datetime(self.startDate, input_name='startDate'))
        if self.endDate is not None and 'endDate' not in already_processed:
            already_processed.add('endDate')
            outfile.write(' endDate="%s"' % self.gds_format_datetime(self.endDate, input_name='endDate'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.objectName is not None and 'objectName' not in already_processed:
            already_processed.add('objectName')
            outfile.write(' objectName=%s' % (self.gds_format_string(quote_attrib(self.objectName).encode(ExternalEncoding), input_name='objectName'), ))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            outfile.write(' orgName=%s' % (self.gds_format_string(quote_attrib(self.orgName).encode(ExternalEncoding), input_name='orgName'), ))
        if self.cellName is not None and 'cellName' not in already_processed:
            already_processed.add('cellName')
            outfile.write(' cellName=%s' % (self.gds_format_string(quote_attrib(self.cellName).encode(ExternalEncoding), input_name='cellName'), ))
        if self.object is not None and 'object' not in already_processed:
            already_processed.add('object')
            outfile.write(' object=%s' % (self.gds_format_string(quote_attrib(self.object).encode(ExternalEncoding), input_name='object'), ))
        if self.hasOwner is not None and 'hasOwner' not in already_processed:
            already_processed.add('hasOwner')
            outfile.write(' hasOwner="%s"' % self.gds_format_boolean(self.hasOwner, input_name='hasOwner'))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(' owner=%s' % (self.gds_format_string(quote_attrib(self.owner).encode(ExternalEncoding), input_name='owner'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
        if self.objectType is not None and 'objectType' not in already_processed:
            already_processed.add('objectType')
            outfile.write(' objectType=%s' % (self.gds_format_string(quote_attrib(self.objectType).encode(ExternalEncoding), input_name='objectType'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminTaskRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminTaskRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminTaskRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.startDate is not None and 'startDate' not in already_processed:
            already_processed.add('startDate')
            showIndent(outfile, level)
            outfile.write('startDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.startDate, input_name='startDate'))
        if self.endDate is not None and 'endDate' not in already_processed:
            already_processed.add('endDate')
            showIndent(outfile, level)
            outfile.write('endDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.endDate, input_name='endDate'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.objectName is not None and 'objectName' not in already_processed:
            already_processed.add('objectName')
            showIndent(outfile, level)
            outfile.write('objectName="%s",\n' % (self.objectName,))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            showIndent(outfile, level)
            outfile.write('orgName="%s",\n' % (self.orgName,))
        if self.cellName is not None and 'cellName' not in already_processed:
            already_processed.add('cellName')
            showIndent(outfile, level)
            outfile.write('cellName="%s",\n' % (self.cellName,))
        if self.object is not None and 'object' not in already_processed:
            already_processed.add('object')
            showIndent(outfile, level)
            outfile.write('object="%s",\n' % (self.object,))
        if self.hasOwner is not None and 'hasOwner' not in already_processed:
            already_processed.add('hasOwner')
            showIndent(outfile, level)
            outfile.write('hasOwner=%s,\n' % (self.hasOwner,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            showIndent(outfile, level)
            outfile.write('owner="%s",\n' % (self.owner,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        if self.objectType is not None and 'objectType' not in already_processed:
            already_processed.add('objectType')
            showIndent(outfile, level)
            outfile.write('objectType="%s",\n' % (self.objectType,))
        super(QueryResultAdminTaskRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminTaskRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('startDate', node)
        if value is not None and 'startDate' not in already_processed:
            already_processed.add('startDate')
            try:
                self.startDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (startDate): %s' % exp)
        value = find_attr_value_('endDate', node)
        if value is not None and 'endDate' not in already_processed:
            already_processed.add('endDate')
            try:
                self.endDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (endDate): %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('objectName', node)
        if value is not None and 'objectName' not in already_processed:
            already_processed.add('objectName')
            self.objectName = value
        value = find_attr_value_('orgName', node)
        if value is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            self.orgName = value
        value = find_attr_value_('cellName', node)
        if value is not None and 'cellName' not in already_processed:
            already_processed.add('cellName')
            self.cellName = value
        value = find_attr_value_('object', node)
        if value is not None and 'object' not in already_processed:
            already_processed.add('object')
            self.object = value
        value = find_attr_value_('hasOwner', node)
        if value is not None and 'hasOwner' not in already_processed:
            already_processed.add('hasOwner')
            if value in ('true', '1'):
                self.hasOwner = True
            elif value in ('false', '0'):
                self.hasOwner = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        value = find_attr_value_('objectType', node)
        if value is not None and 'objectType' not in already_processed:
            already_processed.add('objectType')
            self.objectType = value
        super(QueryResultAdminTaskRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminTaskRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminTaskRecordType


class QueryResultBlockingTaskRecordType(QueryResultRecordType):
    """1.5 Type for a single blockingTask query result in records format.
    1.5none Status 1.5none Operation name 1.5none Owner reference or
    id 1.5none Owner name 1.5none Originating organization name
    1.5none Organization reference or id 1.5none Creation date
    1.5none Expiration time 1.5none Time action 1.5none task
    reference or id 1.5none Job status 5.1none True if this blocking
    task has an owner."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, originatingOrg=None, task=None, timeoutAction=None, originatingOrgName=None, operationName=None, hasOwner=None, jobStatus=None, ownerName=None, owner=None, expirationTime=None, creationDate=None):
        self.original_tagname_ = None
        super(QueryResultBlockingTaskRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.originatingOrg = _cast(None, originatingOrg)
        self.task = _cast(None, task)
        self.timeoutAction = _cast(None, timeoutAction)
        self.originatingOrgName = _cast(None, originatingOrgName)
        self.operationName = _cast(None, operationName)
        self.hasOwner = _cast(bool, hasOwner)
        self.jobStatus = _cast(None, jobStatus)
        self.ownerName = _cast(None, ownerName)
        self.owner = _cast(None, owner)
        if isinstance(expirationTime, basestring):
            initvalue_ = datetime_.datetime.strptime(expirationTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = expirationTime
        self.expirationTime = initvalue_
        if isinstance(creationDate, basestring):
            initvalue_ = datetime_.datetime.strptime(creationDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationDate
        self.creationDate = initvalue_
    def factory(*args_, **kwargs_):
        if QueryResultBlockingTaskRecordType.subclass:
            return QueryResultBlockingTaskRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultBlockingTaskRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_originatingOrg(self): return self.originatingOrg
    def set_originatingOrg(self, originatingOrg): self.originatingOrg = originatingOrg
    def get_task(self): return self.task
    def set_task(self, task): self.task = task
    def get_timeoutAction(self): return self.timeoutAction
    def set_timeoutAction(self, timeoutAction): self.timeoutAction = timeoutAction
    def get_originatingOrgName(self): return self.originatingOrgName
    def set_originatingOrgName(self, originatingOrgName): self.originatingOrgName = originatingOrgName
    def get_operationName(self): return self.operationName
    def set_operationName(self, operationName): self.operationName = operationName
    def get_hasOwner(self): return self.hasOwner
    def set_hasOwner(self, hasOwner): self.hasOwner = hasOwner
    def get_jobStatus(self): return self.jobStatus
    def set_jobStatus(self, jobStatus): self.jobStatus = jobStatus
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_expirationTime(self): return self.expirationTime
    def set_expirationTime(self, expirationTime): self.expirationTime = expirationTime
    def get_creationDate(self): return self.creationDate
    def set_creationDate(self, creationDate): self.creationDate = creationDate
    def hasContent_(self):
        if (
            super(QueryResultBlockingTaskRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultBlockingTaskRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultBlockingTaskRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultBlockingTaskRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultBlockingTaskRecordType'):
        super(QueryResultBlockingTaskRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultBlockingTaskRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.originatingOrg is not None and 'originatingOrg' not in already_processed:
            already_processed.add('originatingOrg')
            outfile.write(' originatingOrg=%s' % (self.gds_format_string(quote_attrib(self.originatingOrg).encode(ExternalEncoding), input_name='originatingOrg'), ))
        if self.task is not None and 'task' not in already_processed:
            already_processed.add('task')
            outfile.write(' task=%s' % (self.gds_format_string(quote_attrib(self.task).encode(ExternalEncoding), input_name='task'), ))
        if self.timeoutAction is not None and 'timeoutAction' not in already_processed:
            already_processed.add('timeoutAction')
            outfile.write(' timeoutAction=%s' % (self.gds_format_string(quote_attrib(self.timeoutAction).encode(ExternalEncoding), input_name='timeoutAction'), ))
        if self.originatingOrgName is not None and 'originatingOrgName' not in already_processed:
            already_processed.add('originatingOrgName')
            outfile.write(' originatingOrgName=%s' % (self.gds_format_string(quote_attrib(self.originatingOrgName).encode(ExternalEncoding), input_name='originatingOrgName'), ))
        if self.operationName is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            outfile.write(' operationName=%s' % (self.gds_format_string(quote_attrib(self.operationName).encode(ExternalEncoding), input_name='operationName'), ))
        if self.hasOwner is not None and 'hasOwner' not in already_processed:
            already_processed.add('hasOwner')
            outfile.write(' hasOwner="%s"' % self.gds_format_boolean(self.hasOwner, input_name='hasOwner'))
        if self.jobStatus is not None and 'jobStatus' not in already_processed:
            already_processed.add('jobStatus')
            outfile.write(' jobStatus=%s' % (self.gds_format_string(quote_attrib(self.jobStatus).encode(ExternalEncoding), input_name='jobStatus'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(' owner=%s' % (self.gds_format_string(quote_attrib(self.owner).encode(ExternalEncoding), input_name='owner'), ))
        if self.expirationTime is not None and 'expirationTime' not in already_processed:
            already_processed.add('expirationTime')
            outfile.write(' expirationTime="%s"' % self.gds_format_datetime(self.expirationTime, input_name='expirationTime'))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            outfile.write(' creationDate="%s"' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultBlockingTaskRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultBlockingTaskRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultBlockingTaskRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.originatingOrg is not None and 'originatingOrg' not in already_processed:
            already_processed.add('originatingOrg')
            showIndent(outfile, level)
            outfile.write('originatingOrg="%s",\n' % (self.originatingOrg,))
        if self.task is not None and 'task' not in already_processed:
            already_processed.add('task')
            showIndent(outfile, level)
            outfile.write('task="%s",\n' % (self.task,))
        if self.timeoutAction is not None and 'timeoutAction' not in already_processed:
            already_processed.add('timeoutAction')
            showIndent(outfile, level)
            outfile.write('timeoutAction="%s",\n' % (self.timeoutAction,))
        if self.originatingOrgName is not None and 'originatingOrgName' not in already_processed:
            already_processed.add('originatingOrgName')
            showIndent(outfile, level)
            outfile.write('originatingOrgName="%s",\n' % (self.originatingOrgName,))
        if self.operationName is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            showIndent(outfile, level)
            outfile.write('operationName="%s",\n' % (self.operationName,))
        if self.hasOwner is not None and 'hasOwner' not in already_processed:
            already_processed.add('hasOwner')
            showIndent(outfile, level)
            outfile.write('hasOwner=%s,\n' % (self.hasOwner,))
        if self.jobStatus is not None and 'jobStatus' not in already_processed:
            already_processed.add('jobStatus')
            showIndent(outfile, level)
            outfile.write('jobStatus="%s",\n' % (self.jobStatus,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            showIndent(outfile, level)
            outfile.write('owner="%s",\n' % (self.owner,))
        if self.expirationTime is not None and 'expirationTime' not in already_processed:
            already_processed.add('expirationTime')
            showIndent(outfile, level)
            outfile.write('expirationTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.expirationTime, input_name='expirationTime'))
        if self.creationDate is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            showIndent(outfile, level)
            outfile.write('creationDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.creationDate, input_name='creationDate'))
        super(QueryResultBlockingTaskRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultBlockingTaskRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('originatingOrg', node)
        if value is not None and 'originatingOrg' not in already_processed:
            already_processed.add('originatingOrg')
            self.originatingOrg = value
        value = find_attr_value_('task', node)
        if value is not None and 'task' not in already_processed:
            already_processed.add('task')
            self.task = value
        value = find_attr_value_('timeoutAction', node)
        if value is not None and 'timeoutAction' not in already_processed:
            already_processed.add('timeoutAction')
            self.timeoutAction = value
        value = find_attr_value_('originatingOrgName', node)
        if value is not None and 'originatingOrgName' not in already_processed:
            already_processed.add('originatingOrgName')
            self.originatingOrgName = value
        value = find_attr_value_('operationName', node)
        if value is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            self.operationName = value
        value = find_attr_value_('hasOwner', node)
        if value is not None and 'hasOwner' not in already_processed:
            already_processed.add('hasOwner')
            if value in ('true', '1'):
                self.hasOwner = True
            elif value in ('false', '0'):
                self.hasOwner = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('jobStatus', node)
        if value is not None and 'jobStatus' not in already_processed:
            already_processed.add('jobStatus')
            self.jobStatus = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('expirationTime', node)
        if value is not None and 'expirationTime' not in already_processed:
            already_processed.add('expirationTime')
            try:
                self.expirationTime = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (expirationTime): %s' % exp)
        value = find_attr_value_('creationDate', node)
        if value is not None and 'creationDate' not in already_processed:
            already_processed.add('creationDate')
            try:
                self.creationDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (creationDate): %s' % exp)
        super(QueryResultBlockingTaskRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultBlockingTaskRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultBlockingTaskRecordType


class QueryResultDiskRecordType(QueryResultRecordType):
    """5.1 Type for a single disk query result in records format. 5.1none
    Disk name 5.1none VDC reference or id 5.1none Size of the disk
    in bytes 5.1none Datastore reference or id 5.1none Datastore
    name 5.1none Owner name 5.1none VDC name 5.1none In-progress
    task reference or id 5.1none Storage profile reference or id
    5.1none Storage profile name 5.1none Disk status 5.1none Disk
    controller type 5.1none Disk controller type description 5.1none
    Disk controller subtype 5.1none True if the disk is already
    attached."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, storageProfileName=None, task=None, name=None, storageProfile=None, datastoreName=None, busType=None, vdcName=None, vdc=None, busSubType=None, ownerName=None, sizeB=None, isAttached=None, datastore=None, busTypeDesc=None):
        self.original_tagname_ = None
        super(QueryResultDiskRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.storageProfileName = _cast(None, storageProfileName)
        self.task = _cast(None, task)
        self.name = _cast(None, name)
        self.storageProfile = _cast(None, storageProfile)
        self.datastoreName = _cast(None, datastoreName)
        self.busType = _cast(None, busType)
        self.vdcName = _cast(None, vdcName)
        self.vdc = _cast(None, vdc)
        self.busSubType = _cast(None, busSubType)
        self.ownerName = _cast(None, ownerName)
        self.sizeB = _cast(int, sizeB)
        self.isAttached = _cast(bool, isAttached)
        self.datastore = _cast(None, datastore)
        self.busTypeDesc = _cast(None, busTypeDesc)
    def factory(*args_, **kwargs_):
        if QueryResultDiskRecordType.subclass:
            return QueryResultDiskRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultDiskRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_storageProfileName(self): return self.storageProfileName
    def set_storageProfileName(self, storageProfileName): self.storageProfileName = storageProfileName
    def get_task(self): return self.task
    def set_task(self, task): self.task = task
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_storageProfile(self): return self.storageProfile
    def set_storageProfile(self, storageProfile): self.storageProfile = storageProfile
    def get_datastoreName(self): return self.datastoreName
    def set_datastoreName(self, datastoreName): self.datastoreName = datastoreName
    def get_busType(self): return self.busType
    def set_busType(self, busType): self.busType = busType
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_busSubType(self): return self.busSubType
    def set_busSubType(self, busSubType): self.busSubType = busSubType
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_sizeB(self): return self.sizeB
    def set_sizeB(self, sizeB): self.sizeB = sizeB
    def get_isAttached(self): return self.isAttached
    def set_isAttached(self, isAttached): self.isAttached = isAttached
    def get_datastore(self): return self.datastore
    def set_datastore(self, datastore): self.datastore = datastore
    def get_busTypeDesc(self): return self.busTypeDesc
    def set_busTypeDesc(self, busTypeDesc): self.busTypeDesc = busTypeDesc
    def hasContent_(self):
        if (
            super(QueryResultDiskRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultDiskRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultDiskRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultDiskRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultDiskRecordType'):
        super(QueryResultDiskRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultDiskRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            outfile.write(' storageProfileName=%s' % (self.gds_format_string(quote_attrib(self.storageProfileName).encode(ExternalEncoding), input_name='storageProfileName'), ))
        if self.task is not None and 'task' not in already_processed:
            already_processed.add('task')
            outfile.write(' task=%s' % (self.gds_format_string(quote_attrib(self.task).encode(ExternalEncoding), input_name='task'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.storageProfile is not None and 'storageProfile' not in already_processed:
            already_processed.add('storageProfile')
            outfile.write(' storageProfile=%s' % (self.gds_format_string(quote_attrib(self.storageProfile).encode(ExternalEncoding), input_name='storageProfile'), ))
        if self.datastoreName is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            outfile.write(' datastoreName=%s' % (self.gds_format_string(quote_attrib(self.datastoreName).encode(ExternalEncoding), input_name='datastoreName'), ))
        if self.busType is not None and 'busType' not in already_processed:
            already_processed.add('busType')
            outfile.write(' busType=%s' % (self.gds_format_string(quote_attrib(self.busType).encode(ExternalEncoding), input_name='busType'), ))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.busSubType is not None and 'busSubType' not in already_processed:
            already_processed.add('busSubType')
            outfile.write(' busSubType=%s' % (self.gds_format_string(quote_attrib(self.busSubType).encode(ExternalEncoding), input_name='busSubType'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.sizeB is not None and 'sizeB' not in already_processed:
            already_processed.add('sizeB')
            outfile.write(' sizeB="%s"' % self.gds_format_integer(self.sizeB, input_name='sizeB'))
        if self.isAttached is not None and 'isAttached' not in already_processed:
            already_processed.add('isAttached')
            outfile.write(' isAttached="%s"' % self.gds_format_boolean(self.isAttached, input_name='isAttached'))
        if self.datastore is not None and 'datastore' not in already_processed:
            already_processed.add('datastore')
            outfile.write(' datastore=%s' % (self.gds_format_string(quote_attrib(self.datastore).encode(ExternalEncoding), input_name='datastore'), ))
        if self.busTypeDesc is not None and 'busTypeDesc' not in already_processed:
            already_processed.add('busTypeDesc')
            outfile.write(' busTypeDesc=%s' % (self.gds_format_string(quote_attrib(self.busTypeDesc).encode(ExternalEncoding), input_name='busTypeDesc'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultDiskRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultDiskRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultDiskRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            showIndent(outfile, level)
            outfile.write('storageProfileName="%s",\n' % (self.storageProfileName,))
        if self.task is not None and 'task' not in already_processed:
            already_processed.add('task')
            showIndent(outfile, level)
            outfile.write('task="%s",\n' % (self.task,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.storageProfile is not None and 'storageProfile' not in already_processed:
            already_processed.add('storageProfile')
            showIndent(outfile, level)
            outfile.write('storageProfile="%s",\n' % (self.storageProfile,))
        if self.datastoreName is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            showIndent(outfile, level)
            outfile.write('datastoreName="%s",\n' % (self.datastoreName,))
        if self.busType is not None and 'busType' not in already_processed:
            already_processed.add('busType')
            showIndent(outfile, level)
            outfile.write('busType="%s",\n' % (self.busType,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.busSubType is not None and 'busSubType' not in already_processed:
            already_processed.add('busSubType')
            showIndent(outfile, level)
            outfile.write('busSubType="%s",\n' % (self.busSubType,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.sizeB is not None and 'sizeB' not in already_processed:
            already_processed.add('sizeB')
            showIndent(outfile, level)
            outfile.write('sizeB=%d,\n' % (self.sizeB,))
        if self.isAttached is not None and 'isAttached' not in already_processed:
            already_processed.add('isAttached')
            showIndent(outfile, level)
            outfile.write('isAttached=%s,\n' % (self.isAttached,))
        if self.datastore is not None and 'datastore' not in already_processed:
            already_processed.add('datastore')
            showIndent(outfile, level)
            outfile.write('datastore="%s",\n' % (self.datastore,))
        if self.busTypeDesc is not None and 'busTypeDesc' not in already_processed:
            already_processed.add('busTypeDesc')
            showIndent(outfile, level)
            outfile.write('busTypeDesc="%s",\n' % (self.busTypeDesc,))
        super(QueryResultDiskRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultDiskRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('storageProfileName', node)
        if value is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            self.storageProfileName = value
        value = find_attr_value_('task', node)
        if value is not None and 'task' not in already_processed:
            already_processed.add('task')
            self.task = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('storageProfile', node)
        if value is not None and 'storageProfile' not in already_processed:
            already_processed.add('storageProfile')
            self.storageProfile = value
        value = find_attr_value_('datastoreName', node)
        if value is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            self.datastoreName = value
        value = find_attr_value_('busType', node)
        if value is not None and 'busType' not in already_processed:
            already_processed.add('busType')
            self.busType = value
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('busSubType', node)
        if value is not None and 'busSubType' not in already_processed:
            already_processed.add('busSubType')
            self.busSubType = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('sizeB', node)
        if value is not None and 'sizeB' not in already_processed:
            already_processed.add('sizeB')
            try:
                self.sizeB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isAttached', node)
        if value is not None and 'isAttached' not in already_processed:
            already_processed.add('isAttached')
            if value in ('true', '1'):
                self.isAttached = True
            elif value in ('false', '0'):
                self.isAttached = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('datastore', node)
        if value is not None and 'datastore' not in already_processed:
            already_processed.add('datastore')
            self.datastore = value
        value = find_attr_value_('busTypeDesc', node)
        if value is not None and 'busTypeDesc' not in already_processed:
            already_processed.add('busTypeDesc')
            self.busTypeDesc = value
        super(QueryResultDiskRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultDiskRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultDiskRecordType


class QueryResultVmDiskRelationRecordType(QueryResultRecordType):
    """5.1 Type for a single vmDiskRelation query result in records format.
    5.1none vDc reference or id 5.1none Disk reference or id 5.1none
    Virtual machine reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vdc=None, disk=None, vm=None):
        self.original_tagname_ = None
        super(QueryResultVmDiskRelationRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vdc = _cast(None, vdc)
        self.disk = _cast(None, disk)
        self.vm = _cast(None, vm)
    def factory(*args_, **kwargs_):
        if QueryResultVmDiskRelationRecordType.subclass:
            return QueryResultVmDiskRelationRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultVmDiskRelationRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_disk(self): return self.disk
    def set_disk(self, disk): self.disk = disk
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def hasContent_(self):
        if (
            super(QueryResultVmDiskRelationRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultVmDiskRelationRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVmDiskRelationRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultVmDiskRelationRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultVmDiskRelationRecordType'):
        super(QueryResultVmDiskRelationRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultVmDiskRelationRecordType')
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.disk is not None and 'disk' not in already_processed:
            already_processed.add('disk')
            outfile.write(' disk=%s' % (self.gds_format_string(quote_attrib(self.disk).encode(ExternalEncoding), input_name='disk'), ))
        if self.vm is not None and 'vm' not in already_processed:
            already_processed.add('vm')
            outfile.write(' vm=%s' % (self.gds_format_string(quote_attrib(self.vm).encode(ExternalEncoding), input_name='vm'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultVmDiskRelationRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultVmDiskRelationRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultVmDiskRelationRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.disk is not None and 'disk' not in already_processed:
            already_processed.add('disk')
            showIndent(outfile, level)
            outfile.write('disk="%s",\n' % (self.disk,))
        if self.vm is not None and 'vm' not in already_processed:
            already_processed.add('vm')
            showIndent(outfile, level)
            outfile.write('vm="%s",\n' % (self.vm,))
        super(QueryResultVmDiskRelationRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultVmDiskRelationRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('disk', node)
        if value is not None and 'disk' not in already_processed:
            already_processed.add('disk')
            self.disk = value
        value = find_attr_value_('vm', node)
        if value is not None and 'vm' not in already_processed:
            already_processed.add('vm')
            self.vm = value
        super(QueryResultVmDiskRelationRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultVmDiskRelationRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultVmDiskRelationRecordType


class QueryResultAdminDiskRecordType(QueryResultRecordType):
    """5.1 Type for a single adminDisk query result in records format.
    5.1none 5.1none VDC reference or id 5.1none Size of disk in
    bytes 5.1none Virtual center reference or id 5.1none Datastore
    reference or id 5.1none Datastore name 5.1none Owner name
    5.1none VDC name 5.1none Organization reference or id 5.1none
    In-progress task reference or id 5.1none Storage profile
    reference or id 5.1none Storage profile reference or id 5.1none
    Disk status 5.1none Disk controller type 5.1none Disk controller
    type description 5.1none Disk controller subtype 5.1none True if
    the disk is already attached."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, status=None, storageProfileName=None, vc=None, name=None, storageProfile=None, datastoreName=None, busType=None, vdcName=None, vdc=None, task=None, ownerName=None, sizeB=None, isAttached=None, org=None, datastore=None, busSubType=None, busTypeDesc=None):
        self.original_tagname_ = None
        super(QueryResultAdminDiskRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.status = _cast(None, status)
        self.storageProfileName = _cast(None, storageProfileName)
        self.vc = _cast(None, vc)
        self.name = _cast(None, name)
        self.storageProfile = _cast(None, storageProfile)
        self.datastoreName = _cast(None, datastoreName)
        self.busType = _cast(None, busType)
        self.vdcName = _cast(None, vdcName)
        self.vdc = _cast(None, vdc)
        self.task = _cast(None, task)
        self.ownerName = _cast(None, ownerName)
        self.sizeB = _cast(int, sizeB)
        self.isAttached = _cast(bool, isAttached)
        self.org = _cast(None, org)
        self.datastore = _cast(None, datastore)
        self.busSubType = _cast(None, busSubType)
        self.busTypeDesc = _cast(None, busTypeDesc)
    def factory(*args_, **kwargs_):
        if QueryResultAdminDiskRecordType.subclass:
            return QueryResultAdminDiskRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminDiskRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_storageProfileName(self): return self.storageProfileName
    def set_storageProfileName(self, storageProfileName): self.storageProfileName = storageProfileName
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_storageProfile(self): return self.storageProfile
    def set_storageProfile(self, storageProfile): self.storageProfile = storageProfile
    def get_datastoreName(self): return self.datastoreName
    def set_datastoreName(self, datastoreName): self.datastoreName = datastoreName
    def get_busType(self): return self.busType
    def set_busType(self, busType): self.busType = busType
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_task(self): return self.task
    def set_task(self, task): self.task = task
    def get_ownerName(self): return self.ownerName
    def set_ownerName(self, ownerName): self.ownerName = ownerName
    def get_sizeB(self): return self.sizeB
    def set_sizeB(self, sizeB): self.sizeB = sizeB
    def get_isAttached(self): return self.isAttached
    def set_isAttached(self, isAttached): self.isAttached = isAttached
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_datastore(self): return self.datastore
    def set_datastore(self, datastore): self.datastore = datastore
    def get_busSubType(self): return self.busSubType
    def set_busSubType(self, busSubType): self.busSubType = busSubType
    def get_busTypeDesc(self): return self.busTypeDesc
    def set_busTypeDesc(self, busTypeDesc): self.busTypeDesc = busTypeDesc
    def hasContent_(self):
        if (
            super(QueryResultAdminDiskRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminDiskRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminDiskRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminDiskRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminDiskRecordType'):
        super(QueryResultAdminDiskRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminDiskRecordType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            outfile.write(' storageProfileName=%s' % (self.gds_format_string(quote_attrib(self.storageProfileName).encode(ExternalEncoding), input_name='storageProfileName'), ))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.storageProfile is not None and 'storageProfile' not in already_processed:
            already_processed.add('storageProfile')
            outfile.write(' storageProfile=%s' % (self.gds_format_string(quote_attrib(self.storageProfile).encode(ExternalEncoding), input_name='storageProfile'), ))
        if self.datastoreName is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            outfile.write(' datastoreName=%s' % (self.gds_format_string(quote_attrib(self.datastoreName).encode(ExternalEncoding), input_name='datastoreName'), ))
        if self.busType is not None and 'busType' not in already_processed:
            already_processed.add('busType')
            outfile.write(' busType=%s' % (self.gds_format_string(quote_attrib(self.busType).encode(ExternalEncoding), input_name='busType'), ))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.task is not None and 'task' not in already_processed:
            already_processed.add('task')
            outfile.write(' task=%s' % (self.gds_format_string(quote_attrib(self.task).encode(ExternalEncoding), input_name='task'), ))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            outfile.write(' ownerName=%s' % (self.gds_format_string(quote_attrib(self.ownerName).encode(ExternalEncoding), input_name='ownerName'), ))
        if self.sizeB is not None and 'sizeB' not in already_processed:
            already_processed.add('sizeB')
            outfile.write(' sizeB="%s"' % self.gds_format_integer(self.sizeB, input_name='sizeB'))
        if self.isAttached is not None and 'isAttached' not in already_processed:
            already_processed.add('isAttached')
            outfile.write(' isAttached="%s"' % self.gds_format_boolean(self.isAttached, input_name='isAttached'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.datastore is not None and 'datastore' not in already_processed:
            already_processed.add('datastore')
            outfile.write(' datastore=%s' % (self.gds_format_string(quote_attrib(self.datastore).encode(ExternalEncoding), input_name='datastore'), ))
        if self.busSubType is not None and 'busSubType' not in already_processed:
            already_processed.add('busSubType')
            outfile.write(' busSubType=%s' % (self.gds_format_string(quote_attrib(self.busSubType).encode(ExternalEncoding), input_name='busSubType'), ))
        if self.busTypeDesc is not None and 'busTypeDesc' not in already_processed:
            already_processed.add('busTypeDesc')
            outfile.write(' busTypeDesc=%s' % (self.gds_format_string(quote_attrib(self.busTypeDesc).encode(ExternalEncoding), input_name='busTypeDesc'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminDiskRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminDiskRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminDiskRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.storageProfileName is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            showIndent(outfile, level)
            outfile.write('storageProfileName="%s",\n' % (self.storageProfileName,))
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.storageProfile is not None and 'storageProfile' not in already_processed:
            already_processed.add('storageProfile')
            showIndent(outfile, level)
            outfile.write('storageProfile="%s",\n' % (self.storageProfile,))
        if self.datastoreName is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            showIndent(outfile, level)
            outfile.write('datastoreName="%s",\n' % (self.datastoreName,))
        if self.busType is not None and 'busType' not in already_processed:
            already_processed.add('busType')
            showIndent(outfile, level)
            outfile.write('busType="%s",\n' % (self.busType,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.task is not None and 'task' not in already_processed:
            already_processed.add('task')
            showIndent(outfile, level)
            outfile.write('task="%s",\n' % (self.task,))
        if self.ownerName is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            showIndent(outfile, level)
            outfile.write('ownerName="%s",\n' % (self.ownerName,))
        if self.sizeB is not None and 'sizeB' not in already_processed:
            already_processed.add('sizeB')
            showIndent(outfile, level)
            outfile.write('sizeB=%d,\n' % (self.sizeB,))
        if self.isAttached is not None and 'isAttached' not in already_processed:
            already_processed.add('isAttached')
            showIndent(outfile, level)
            outfile.write('isAttached=%s,\n' % (self.isAttached,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.datastore is not None and 'datastore' not in already_processed:
            already_processed.add('datastore')
            showIndent(outfile, level)
            outfile.write('datastore="%s",\n' % (self.datastore,))
        if self.busSubType is not None and 'busSubType' not in already_processed:
            already_processed.add('busSubType')
            showIndent(outfile, level)
            outfile.write('busSubType="%s",\n' % (self.busSubType,))
        if self.busTypeDesc is not None and 'busTypeDesc' not in already_processed:
            already_processed.add('busTypeDesc')
            showIndent(outfile, level)
            outfile.write('busTypeDesc="%s",\n' % (self.busTypeDesc,))
        super(QueryResultAdminDiskRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminDiskRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('storageProfileName', node)
        if value is not None and 'storageProfileName' not in already_processed:
            already_processed.add('storageProfileName')
            self.storageProfileName = value
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('storageProfile', node)
        if value is not None and 'storageProfile' not in already_processed:
            already_processed.add('storageProfile')
            self.storageProfile = value
        value = find_attr_value_('datastoreName', node)
        if value is not None and 'datastoreName' not in already_processed:
            already_processed.add('datastoreName')
            self.datastoreName = value
        value = find_attr_value_('busType', node)
        if value is not None and 'busType' not in already_processed:
            already_processed.add('busType')
            self.busType = value
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('task', node)
        if value is not None and 'task' not in already_processed:
            already_processed.add('task')
            self.task = value
        value = find_attr_value_('ownerName', node)
        if value is not None and 'ownerName' not in already_processed:
            already_processed.add('ownerName')
            self.ownerName = value
        value = find_attr_value_('sizeB', node)
        if value is not None and 'sizeB' not in already_processed:
            already_processed.add('sizeB')
            try:
                self.sizeB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isAttached', node)
        if value is not None and 'isAttached' not in already_processed:
            already_processed.add('isAttached')
            if value in ('true', '1'):
                self.isAttached = True
            elif value in ('false', '0'):
                self.isAttached = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('datastore', node)
        if value is not None and 'datastore' not in already_processed:
            already_processed.add('datastore')
            self.datastore = value
        value = find_attr_value_('busSubType', node)
        if value is not None and 'busSubType' not in already_processed:
            already_processed.add('busSubType')
            self.busSubType = value
        value = find_attr_value_('busTypeDesc', node)
        if value is not None and 'busTypeDesc' not in already_processed:
            already_processed.add('busTypeDesc')
            self.busTypeDesc = value
        super(QueryResultAdminDiskRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminDiskRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminDiskRecordType


class QueryResultAdminVmDiskRelationRecordType(QueryResultRecordType):
    """5.1 Type for a single adminVMDiskRelation query result in records
    format. 5.1none VDC reference or id 5.1none Disk reference or id
    5.1none Virtual machine reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vdc=None, disk=None, vm=None):
        self.original_tagname_ = None
        super(QueryResultAdminVmDiskRelationRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vdc = _cast(None, vdc)
        self.disk = _cast(None, disk)
        self.vm = _cast(None, vm)
    def factory(*args_, **kwargs_):
        if QueryResultAdminVmDiskRelationRecordType.subclass:
            return QueryResultAdminVmDiskRelationRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminVmDiskRelationRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_disk(self): return self.disk
    def set_disk(self, disk): self.disk = disk
    def get_vm(self): return self.vm
    def set_vm(self, vm): self.vm = vm
    def hasContent_(self):
        if (
            super(QueryResultAdminVmDiskRelationRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminVmDiskRelationRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVmDiskRelationRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminVmDiskRelationRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminVmDiskRelationRecordType'):
        super(QueryResultAdminVmDiskRelationRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminVmDiskRelationRecordType')
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.disk is not None and 'disk' not in already_processed:
            already_processed.add('disk')
            outfile.write(' disk=%s' % (self.gds_format_string(quote_attrib(self.disk).encode(ExternalEncoding), input_name='disk'), ))
        if self.vm is not None and 'vm' not in already_processed:
            already_processed.add('vm')
            outfile.write(' vm=%s' % (self.gds_format_string(quote_attrib(self.vm).encode(ExternalEncoding), input_name='vm'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminVmDiskRelationRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminVmDiskRelationRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminVmDiskRelationRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.disk is not None and 'disk' not in already_processed:
            already_processed.add('disk')
            showIndent(outfile, level)
            outfile.write('disk="%s",\n' % (self.disk,))
        if self.vm is not None and 'vm' not in already_processed:
            already_processed.add('vm')
            showIndent(outfile, level)
            outfile.write('vm="%s",\n' % (self.vm,))
        super(QueryResultAdminVmDiskRelationRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminVmDiskRelationRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('disk', node)
        if value is not None and 'disk' not in already_processed:
            already_processed.add('disk')
            self.disk = value
        value = find_attr_value_('vm', node)
        if value is not None and 'vm' not in already_processed:
            already_processed.add('vm')
            self.vm = value
        super(QueryResultAdminVmDiskRelationRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminVmDiskRelationRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminVmDiskRelationRecordType


class QueryResultConditionRecordType(QueryResultRecordType):
    """5.1 Type for a single condition query result in records format.
    5.1none Reference to the entity 5.1none The type of the object.
    5.1none The severity of the condition. One of RED:the integrity
    of the object has been compromised and the object may be
    inaccessible or inoperable. ORANGE: the integrity of the object
    has been compromised. YELLOW: the condition should be
    investigated when convenient. BLUE: object is in consistent
    state. 5.1none A summary of the condition. 5.1none Details of
    the condition. 5.1none Date and time when the condition
    occurred."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, severity=None, object=None, occurenceDate=None, summary=None, details=None, objectType=None):
        self.original_tagname_ = None
        super(QueryResultConditionRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.severity = _cast(None, severity)
        self.object = _cast(None, object)
        if isinstance(occurenceDate, basestring):
            initvalue_ = datetime_.datetime.strptime(occurenceDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = occurenceDate
        self.occurenceDate = initvalue_
        self.summary = _cast(None, summary)
        self.details = _cast(None, details)
        self.objectType = _cast(None, objectType)
    def factory(*args_, **kwargs_):
        if QueryResultConditionRecordType.subclass:
            return QueryResultConditionRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultConditionRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_severity(self): return self.severity
    def set_severity(self, severity): self.severity = severity
    def get_object(self): return self.object
    def set_object(self, object): self.object = object
    def get_occurenceDate(self): return self.occurenceDate
    def set_occurenceDate(self, occurenceDate): self.occurenceDate = occurenceDate
    def get_summary(self): return self.summary
    def set_summary(self, summary): self.summary = summary
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_objectType(self): return self.objectType
    def set_objectType(self, objectType): self.objectType = objectType
    def hasContent_(self):
        if (
            super(QueryResultConditionRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultConditionRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultConditionRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultConditionRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultConditionRecordType'):
        super(QueryResultConditionRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultConditionRecordType')
        if self.severity is not None and 'severity' not in already_processed:
            already_processed.add('severity')
            outfile.write(' severity=%s' % (self.gds_format_string(quote_attrib(self.severity).encode(ExternalEncoding), input_name='severity'), ))
        if self.object is not None and 'object' not in already_processed:
            already_processed.add('object')
            outfile.write(' object=%s' % (self.gds_format_string(quote_attrib(self.object).encode(ExternalEncoding), input_name='object'), ))
        if self.occurenceDate is not None and 'occurenceDate' not in already_processed:
            already_processed.add('occurenceDate')
            outfile.write(' occurenceDate="%s"' % self.gds_format_datetime(self.occurenceDate, input_name='occurenceDate'))
        if self.summary is not None and 'summary' not in already_processed:
            already_processed.add('summary')
            outfile.write(' summary=%s' % (self.gds_format_string(quote_attrib(self.summary).encode(ExternalEncoding), input_name='summary'), ))
        if self.details is not None and 'details' not in already_processed:
            already_processed.add('details')
            outfile.write(' details=%s' % (self.gds_format_string(quote_attrib(self.details).encode(ExternalEncoding), input_name='details'), ))
        if self.objectType is not None and 'objectType' not in already_processed:
            already_processed.add('objectType')
            outfile.write(' objectType=%s' % (self.gds_format_string(quote_attrib(self.objectType).encode(ExternalEncoding), input_name='objectType'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultConditionRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultConditionRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultConditionRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.severity is not None and 'severity' not in already_processed:
            already_processed.add('severity')
            showIndent(outfile, level)
            outfile.write('severity="%s",\n' % (self.severity,))
        if self.object is not None and 'object' not in already_processed:
            already_processed.add('object')
            showIndent(outfile, level)
            outfile.write('object="%s",\n' % (self.object,))
        if self.occurenceDate is not None and 'occurenceDate' not in already_processed:
            already_processed.add('occurenceDate')
            showIndent(outfile, level)
            outfile.write('occurenceDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.occurenceDate, input_name='occurenceDate'))
        if self.summary is not None and 'summary' not in already_processed:
            already_processed.add('summary')
            showIndent(outfile, level)
            outfile.write('summary="%s",\n' % (self.summary,))
        if self.details is not None and 'details' not in already_processed:
            already_processed.add('details')
            showIndent(outfile, level)
            outfile.write('details="%s",\n' % (self.details,))
        if self.objectType is not None and 'objectType' not in already_processed:
            already_processed.add('objectType')
            showIndent(outfile, level)
            outfile.write('objectType="%s",\n' % (self.objectType,))
        super(QueryResultConditionRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultConditionRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('severity', node)
        if value is not None and 'severity' not in already_processed:
            already_processed.add('severity')
            self.severity = value
        value = find_attr_value_('object', node)
        if value is not None and 'object' not in already_processed:
            already_processed.add('object')
            self.object = value
        value = find_attr_value_('occurenceDate', node)
        if value is not None and 'occurenceDate' not in already_processed:
            already_processed.add('occurenceDate')
            try:
                self.occurenceDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (occurenceDate): %s' % exp)
        value = find_attr_value_('summary', node)
        if value is not None and 'summary' not in already_processed:
            already_processed.add('summary')
            self.summary = value
        value = find_attr_value_('details', node)
        if value is not None and 'details' not in already_processed:
            already_processed.add('details')
            self.details = value
        value = find_attr_value_('objectType', node)
        if value is not None and 'objectType' not in already_processed:
            already_processed.add('objectType')
            self.objectType = value
        super(QueryResultConditionRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultConditionRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultConditionRecordType


class QueryResultAdminEventRecordType(QueryResultRecordType):
    """5.1 Type for a single adminEvent query result in records format.
    5.1none Event ID. 5.1none Event type 5.1none Time stamp 5.1none
    Event status 5.1none User name 5.1none Organization name 5.1none
    Entity type 5.1none Entity name 5.1none Service namespace
    5.1none Version of the product 5.1none Entity reference or id
    5.1none Organization reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, eventId=None, userName=None, orgName=None, eventType=None, entityName=None, entityType=None, entity=None, eventStatus=None, timeStamp=None, org=None, serviceNamespace=None, productVersion=None):
        self.original_tagname_ = None
        super(QueryResultAdminEventRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.eventId = _cast(None, eventId)
        self.userName = _cast(None, userName)
        self.orgName = _cast(None, orgName)
        self.eventType = _cast(None, eventType)
        self.entityName = _cast(None, entityName)
        self.entityType = _cast(None, entityType)
        self.entity = _cast(None, entity)
        self.eventStatus = _cast(int, eventStatus)
        if isinstance(timeStamp, basestring):
            initvalue_ = datetime_.datetime.strptime(timeStamp, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = timeStamp
        self.timeStamp = initvalue_
        self.org = _cast(None, org)
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.productVersion = _cast(None, productVersion)
    def factory(*args_, **kwargs_):
        if QueryResultAdminEventRecordType.subclass:
            return QueryResultAdminEventRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminEventRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_eventId(self): return self.eventId
    def set_eventId(self, eventId): self.eventId = eventId
    def get_userName(self): return self.userName
    def set_userName(self, userName): self.userName = userName
    def get_orgName(self): return self.orgName
    def set_orgName(self, orgName): self.orgName = orgName
    def get_eventType(self): return self.eventType
    def set_eventType(self, eventType): self.eventType = eventType
    def get_entityName(self): return self.entityName
    def set_entityName(self, entityName): self.entityName = entityName
    def get_entityType(self): return self.entityType
    def set_entityType(self, entityType): self.entityType = entityType
    def get_entity(self): return self.entity
    def set_entity(self, entity): self.entity = entity
    def get_eventStatus(self): return self.eventStatus
    def set_eventStatus(self, eventStatus): self.eventStatus = eventStatus
    def get_timeStamp(self): return self.timeStamp
    def set_timeStamp(self, timeStamp): self.timeStamp = timeStamp
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def get_productVersion(self): return self.productVersion
    def set_productVersion(self, productVersion): self.productVersion = productVersion
    def hasContent_(self):
        if (
            super(QueryResultAdminEventRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminEventRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminEventRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminEventRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminEventRecordType'):
        super(QueryResultAdminEventRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminEventRecordType')
        if self.eventId is not None and 'eventId' not in already_processed:
            already_processed.add('eventId')
            outfile.write(' eventId=%s' % (self.gds_format_string(quote_attrib(self.eventId).encode(ExternalEncoding), input_name='eventId'), ))
        if self.userName is not None and 'userName' not in already_processed:
            already_processed.add('userName')
            outfile.write(' userName=%s' % (self.gds_format_string(quote_attrib(self.userName).encode(ExternalEncoding), input_name='userName'), ))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            outfile.write(' orgName=%s' % (self.gds_format_string(quote_attrib(self.orgName).encode(ExternalEncoding), input_name='orgName'), ))
        if self.eventType is not None and 'eventType' not in already_processed:
            already_processed.add('eventType')
            outfile.write(' eventType=%s' % (self.gds_format_string(quote_attrib(self.eventType).encode(ExternalEncoding), input_name='eventType'), ))
        if self.entityName is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            outfile.write(' entityName=%s' % (self.gds_format_string(quote_attrib(self.entityName).encode(ExternalEncoding), input_name='entityName'), ))
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            outfile.write(' entityType=%s' % (self.gds_format_string(quote_attrib(self.entityType).encode(ExternalEncoding), input_name='entityType'), ))
        if self.entity is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            outfile.write(' entity=%s' % (self.gds_format_string(quote_attrib(self.entity).encode(ExternalEncoding), input_name='entity'), ))
        if self.eventStatus is not None and 'eventStatus' not in already_processed:
            already_processed.add('eventStatus')
            outfile.write(' eventStatus="%s"' % self.gds_format_integer(self.eventStatus, input_name='eventStatus'))
        if self.timeStamp is not None and 'timeStamp' not in already_processed:
            already_processed.add('timeStamp')
            outfile.write(' timeStamp="%s"' % self.gds_format_datetime(self.timeStamp, input_name='timeStamp'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
        if self.productVersion is not None and 'productVersion' not in already_processed:
            already_processed.add('productVersion')
            outfile.write(' productVersion=%s' % (self.gds_format_string(quote_attrib(self.productVersion).encode(ExternalEncoding), input_name='productVersion'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminEventRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminEventRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminEventRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.eventId is not None and 'eventId' not in already_processed:
            already_processed.add('eventId')
            showIndent(outfile, level)
            outfile.write('eventId="%s",\n' % (self.eventId,))
        if self.userName is not None and 'userName' not in already_processed:
            already_processed.add('userName')
            showIndent(outfile, level)
            outfile.write('userName="%s",\n' % (self.userName,))
        if self.orgName is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            showIndent(outfile, level)
            outfile.write('orgName="%s",\n' % (self.orgName,))
        if self.eventType is not None and 'eventType' not in already_processed:
            already_processed.add('eventType')
            showIndent(outfile, level)
            outfile.write('eventType="%s",\n' % (self.eventType,))
        if self.entityName is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            showIndent(outfile, level)
            outfile.write('entityName="%s",\n' % (self.entityName,))
        if self.entityType is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            showIndent(outfile, level)
            outfile.write('entityType="%s",\n' % (self.entityType,))
        if self.entity is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            showIndent(outfile, level)
            outfile.write('entity="%s",\n' % (self.entity,))
        if self.eventStatus is not None and 'eventStatus' not in already_processed:
            already_processed.add('eventStatus')
            showIndent(outfile, level)
            outfile.write('eventStatus=%d,\n' % (self.eventStatus,))
        if self.timeStamp is not None and 'timeStamp' not in already_processed:
            already_processed.add('timeStamp')
            showIndent(outfile, level)
            outfile.write('timeStamp=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.timeStamp, input_name='timeStamp'))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        if self.productVersion is not None and 'productVersion' not in already_processed:
            already_processed.add('productVersion')
            showIndent(outfile, level)
            outfile.write('productVersion="%s",\n' % (self.productVersion,))
        super(QueryResultAdminEventRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminEventRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('eventId', node)
        if value is not None and 'eventId' not in already_processed:
            already_processed.add('eventId')
            self.eventId = value
        value = find_attr_value_('userName', node)
        if value is not None and 'userName' not in already_processed:
            already_processed.add('userName')
            self.userName = value
        value = find_attr_value_('orgName', node)
        if value is not None and 'orgName' not in already_processed:
            already_processed.add('orgName')
            self.orgName = value
        value = find_attr_value_('eventType', node)
        if value is not None and 'eventType' not in already_processed:
            already_processed.add('eventType')
            self.eventType = value
        value = find_attr_value_('entityName', node)
        if value is not None and 'entityName' not in already_processed:
            already_processed.add('entityName')
            self.entityName = value
        value = find_attr_value_('entityType', node)
        if value is not None and 'entityType' not in already_processed:
            already_processed.add('entityType')
            self.entityType = value
        value = find_attr_value_('entity', node)
        if value is not None and 'entity' not in already_processed:
            already_processed.add('entity')
            self.entity = value
        value = find_attr_value_('eventStatus', node)
        if value is not None and 'eventStatus' not in already_processed:
            already_processed.add('eventStatus')
            try:
                self.eventStatus = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('timeStamp', node)
        if value is not None and 'timeStamp' not in already_processed:
            already_processed.add('timeStamp')
            try:
                self.timeStamp = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (timeStamp): %s' % exp)
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        value = find_attr_value_('productVersion', node)
        if value is not None and 'productVersion' not in already_processed:
            already_processed.add('productVersion')
            self.productVersion = value
        super(QueryResultAdminEventRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminEventRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminEventRecordType


class QueryResultStrandedItemRecordType(QueryResultRecordType):
    """5.1 Type for a single strandedItem query result in records format.
    5.1none The name of this stranded item. 5.1none Vim object type
    5.1none The name of the parent of the stranded item 5.1none Date
    when the vCD object is deleted 5.1none The href of the parent of
    the stranded item 5.1none Shows if purging of the item from a
    vCenter has failed"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, deletionDate=None, vimObjectType=None, name=None, parent=None, parentName=None, numberOfPurgeAttempts=None):
        self.original_tagname_ = None
        super(QueryResultStrandedItemRecordType, self).__init__(href, type_, id, Link, Metadata, )
        if isinstance(deletionDate, basestring):
            initvalue_ = datetime_.datetime.strptime(deletionDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = deletionDate
        self.deletionDate = initvalue_
        self.vimObjectType = _cast(None, vimObjectType)
        self.name = _cast(None, name)
        self.parent = _cast(None, parent)
        self.parentName = _cast(None, parentName)
        self.numberOfPurgeAttempts = _cast(int, numberOfPurgeAttempts)
    def factory(*args_, **kwargs_):
        if QueryResultStrandedItemRecordType.subclass:
            return QueryResultStrandedItemRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultStrandedItemRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_deletionDate(self): return self.deletionDate
    def set_deletionDate(self, deletionDate): self.deletionDate = deletionDate
    def get_vimObjectType(self): return self.vimObjectType
    def set_vimObjectType(self, vimObjectType): self.vimObjectType = vimObjectType
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_parent(self): return self.parent
    def set_parent(self, parent): self.parent = parent
    def get_parentName(self): return self.parentName
    def set_parentName(self, parentName): self.parentName = parentName
    def get_numberOfPurgeAttempts(self): return self.numberOfPurgeAttempts
    def set_numberOfPurgeAttempts(self, numberOfPurgeAttempts): self.numberOfPurgeAttempts = numberOfPurgeAttempts
    def hasContent_(self):
        if (
            super(QueryResultStrandedItemRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultStrandedItemRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultStrandedItemRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultStrandedItemRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultStrandedItemRecordType'):
        super(QueryResultStrandedItemRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultStrandedItemRecordType')
        if self.deletionDate is not None and 'deletionDate' not in already_processed:
            already_processed.add('deletionDate')
            outfile.write(' deletionDate="%s"' % self.gds_format_datetime(self.deletionDate, input_name='deletionDate'))
        if self.vimObjectType is not None and 'vimObjectType' not in already_processed:
            already_processed.add('vimObjectType')
            outfile.write(' vimObjectType=%s' % (self.gds_format_string(quote_attrib(self.vimObjectType).encode(ExternalEncoding), input_name='vimObjectType'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.parent is not None and 'parent' not in already_processed:
            already_processed.add('parent')
            outfile.write(' parent=%s' % (self.gds_format_string(quote_attrib(self.parent).encode(ExternalEncoding), input_name='parent'), ))
        if self.parentName is not None and 'parentName' not in already_processed:
            already_processed.add('parentName')
            outfile.write(' parentName=%s' % (self.gds_format_string(quote_attrib(self.parentName).encode(ExternalEncoding), input_name='parentName'), ))
        if self.numberOfPurgeAttempts is not None and 'numberOfPurgeAttempts' not in already_processed:
            already_processed.add('numberOfPurgeAttempts')
            outfile.write(' numberOfPurgeAttempts="%s"' % self.gds_format_integer(self.numberOfPurgeAttempts, input_name='numberOfPurgeAttempts'))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultStrandedItemRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultStrandedItemRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultStrandedItemRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.deletionDate is not None and 'deletionDate' not in already_processed:
            already_processed.add('deletionDate')
            showIndent(outfile, level)
            outfile.write('deletionDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.deletionDate, input_name='deletionDate'))
        if self.vimObjectType is not None and 'vimObjectType' not in already_processed:
            already_processed.add('vimObjectType')
            showIndent(outfile, level)
            outfile.write('vimObjectType="%s",\n' % (self.vimObjectType,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.parent is not None and 'parent' not in already_processed:
            already_processed.add('parent')
            showIndent(outfile, level)
            outfile.write('parent="%s",\n' % (self.parent,))
        if self.parentName is not None and 'parentName' not in already_processed:
            already_processed.add('parentName')
            showIndent(outfile, level)
            outfile.write('parentName="%s",\n' % (self.parentName,))
        if self.numberOfPurgeAttempts is not None and 'numberOfPurgeAttempts' not in already_processed:
            already_processed.add('numberOfPurgeAttempts')
            showIndent(outfile, level)
            outfile.write('numberOfPurgeAttempts=%d,\n' % (self.numberOfPurgeAttempts,))
        super(QueryResultStrandedItemRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultStrandedItemRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('deletionDate', node)
        if value is not None and 'deletionDate' not in already_processed:
            already_processed.add('deletionDate')
            try:
                self.deletionDate = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (deletionDate): %s' % exp)
        value = find_attr_value_('vimObjectType', node)
        if value is not None and 'vimObjectType' not in already_processed:
            already_processed.add('vimObjectType')
            self.vimObjectType = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('parent', node)
        if value is not None and 'parent' not in already_processed:
            already_processed.add('parent')
            self.parent = value
        value = find_attr_value_('parentName', node)
        if value is not None and 'parentName' not in already_processed:
            already_processed.add('parentName')
            self.parentName = value
        value = find_attr_value_('numberOfPurgeAttempts', node)
        if value is not None and 'numberOfPurgeAttempts' not in already_processed:
            already_processed.add('numberOfPurgeAttempts')
            try:
                self.numberOfPurgeAttempts = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(QueryResultStrandedItemRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultStrandedItemRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultStrandedItemRecordType


class QueryResultAdminServiceRecordType(QueryResultRecordType):
    """5.1 Type for a single adminService query result in records format.
    5.1none Name of the external service. 5.1none True if service is
    enabled. 5.1none The service exchange. 5.1none Service priority.
    5.1none The service routing key. 5.1none Service vendor. 5.1none
    Service namespace. 5.1none True if authorization is enabled."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vendor=None, routingKey=None, exchange=None, namespace=None, enabled=None, priority=None, isAuthorizationEnabled=None, name=None):
        self.original_tagname_ = None
        super(QueryResultAdminServiceRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vendor = _cast(None, vendor)
        self.routingKey = _cast(None, routingKey)
        self.exchange = _cast(None, exchange)
        self.namespace = _cast(None, namespace)
        self.enabled = _cast(bool, enabled)
        self.priority = _cast(int, priority)
        self.isAuthorizationEnabled = _cast(bool, isAuthorizationEnabled)
        self.name = _cast(None, name)
    def factory(*args_, **kwargs_):
        if QueryResultAdminServiceRecordType.subclass:
            return QueryResultAdminServiceRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminServiceRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vendor(self): return self.vendor
    def set_vendor(self, vendor): self.vendor = vendor
    def get_routingKey(self): return self.routingKey
    def set_routingKey(self, routingKey): self.routingKey = routingKey
    def get_exchange(self): return self.exchange
    def set_exchange(self, exchange): self.exchange = exchange
    def get_namespace(self): return self.namespace
    def set_namespace(self, namespace): self.namespace = namespace
    def get_enabled(self): return self.enabled
    def set_enabled(self, enabled): self.enabled = enabled
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_isAuthorizationEnabled(self): return self.isAuthorizationEnabled
    def set_isAuthorizationEnabled(self, isAuthorizationEnabled): self.isAuthorizationEnabled = isAuthorizationEnabled
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            super(QueryResultAdminServiceRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminServiceRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminServiceRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminServiceRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminServiceRecordType'):
        super(QueryResultAdminServiceRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminServiceRecordType')
        if self.vendor is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            outfile.write(' vendor=%s' % (self.gds_format_string(quote_attrib(self.vendor).encode(ExternalEncoding), input_name='vendor'), ))
        if self.routingKey is not None and 'routingKey' not in already_processed:
            already_processed.add('routingKey')
            outfile.write(' routingKey=%s' % (self.gds_format_string(quote_attrib(self.routingKey).encode(ExternalEncoding), input_name='routingKey'), ))
        if self.exchange is not None and 'exchange' not in already_processed:
            already_processed.add('exchange')
            outfile.write(' exchange=%s' % (self.gds_format_string(quote_attrib(self.exchange).encode(ExternalEncoding), input_name='exchange'), ))
        if self.namespace is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            outfile.write(' namespace=%s' % (self.gds_format_string(quote_attrib(self.namespace).encode(ExternalEncoding), input_name='namespace'), ))
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            outfile.write(' enabled="%s"' % self.gds_format_boolean(self.enabled, input_name='enabled'))
        if self.priority is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            outfile.write(' priority="%s"' % self.gds_format_integer(self.priority, input_name='priority'))
        if self.isAuthorizationEnabled is not None and 'isAuthorizationEnabled' not in already_processed:
            already_processed.add('isAuthorizationEnabled')
            outfile.write(' isAuthorizationEnabled="%s"' % self.gds_format_boolean(self.isAuthorizationEnabled, input_name='isAuthorizationEnabled'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminServiceRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminServiceRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminServiceRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vendor is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            showIndent(outfile, level)
            outfile.write('vendor="%s",\n' % (self.vendor,))
        if self.routingKey is not None and 'routingKey' not in already_processed:
            already_processed.add('routingKey')
            showIndent(outfile, level)
            outfile.write('routingKey="%s",\n' % (self.routingKey,))
        if self.exchange is not None and 'exchange' not in already_processed:
            already_processed.add('exchange')
            showIndent(outfile, level)
            outfile.write('exchange="%s",\n' % (self.exchange,))
        if self.namespace is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            showIndent(outfile, level)
            outfile.write('namespace="%s",\n' % (self.namespace,))
        if self.enabled is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            showIndent(outfile, level)
            outfile.write('enabled=%s,\n' % (self.enabled,))
        if self.priority is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            showIndent(outfile, level)
            outfile.write('priority=%d,\n' % (self.priority,))
        if self.isAuthorizationEnabled is not None and 'isAuthorizationEnabled' not in already_processed:
            already_processed.add('isAuthorizationEnabled')
            showIndent(outfile, level)
            outfile.write('isAuthorizationEnabled=%s,\n' % (self.isAuthorizationEnabled,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(QueryResultAdminServiceRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminServiceRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vendor', node)
        if value is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            self.vendor = value
        value = find_attr_value_('routingKey', node)
        if value is not None and 'routingKey' not in already_processed:
            already_processed.add('routingKey')
            self.routingKey = value
        value = find_attr_value_('exchange', node)
        if value is not None and 'exchange' not in already_processed:
            already_processed.add('exchange')
            self.exchange = value
        value = find_attr_value_('namespace', node)
        if value is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            self.namespace = value
        value = find_attr_value_('enabled', node)
        if value is not None and 'enabled' not in already_processed:
            already_processed.add('enabled')
            if value in ('true', '1'):
                self.enabled = True
            elif value in ('false', '0'):
                self.enabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('priority', node)
        if value is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            try:
                self.priority = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isAuthorizationEnabled', node)
        if value is not None and 'isAuthorizationEnabled' not in already_processed:
            already_processed.add('isAuthorizationEnabled')
            if value in ('true', '1'):
                self.isAuthorizationEnabled = True
            elif value in ('false', '0'):
                self.isAuthorizationEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(QueryResultAdminServiceRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminServiceRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminServiceRecordType


class QueryResultServiceRecordType(QueryResultRecordType):
    """5.1 Type for a single service query result in records format.
    5.1none Name of the external service. 5.1none External service
    vendor. 5.1none Service namespace."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, namespace=None, vendor=None, name=None):
        self.original_tagname_ = None
        super(QueryResultServiceRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.namespace = _cast(None, namespace)
        self.vendor = _cast(None, vendor)
        self.name = _cast(None, name)
    def factory(*args_, **kwargs_):
        if QueryResultServiceRecordType.subclass:
            return QueryResultServiceRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultServiceRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_namespace(self): return self.namespace
    def set_namespace(self, namespace): self.namespace = namespace
    def get_vendor(self): return self.vendor
    def set_vendor(self, vendor): self.vendor = vendor
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            super(QueryResultServiceRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultServiceRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultServiceRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultServiceRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultServiceRecordType'):
        super(QueryResultServiceRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultServiceRecordType')
        if self.namespace is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            outfile.write(' namespace=%s' % (self.gds_format_string(quote_attrib(self.namespace).encode(ExternalEncoding), input_name='namespace'), ))
        if self.vendor is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            outfile.write(' vendor=%s' % (self.gds_format_string(quote_attrib(self.vendor).encode(ExternalEncoding), input_name='vendor'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultServiceRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultServiceRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultServiceRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.namespace is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            showIndent(outfile, level)
            outfile.write('namespace="%s",\n' % (self.namespace,))
        if self.vendor is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            showIndent(outfile, level)
            outfile.write('vendor="%s",\n' % (self.vendor,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(QueryResultServiceRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultServiceRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('namespace', node)
        if value is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            self.namespace = value
        value = find_attr_value_('vendor', node)
        if value is not None and 'vendor' not in already_processed:
            already_processed.add('vendor')
            self.vendor = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(QueryResultServiceRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultServiceRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultServiceRecordType


class QueryResultServiceLinkRecordType(QueryResultRecordType):
    """5.1 Type for a single serviceLink query result in records format.
    5.1none Relation for the link. 5.1none Href for the link.
    5.1none Link's mime type. 5.1none Resource type the link is
    registered for. 5.1none Service reference or id 5.1none Resource
    id the link is registered for."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, mimeType=None, service=None, resourceType=None, resourceId=None, linkHref=None, rel=None):
        self.original_tagname_ = None
        super(QueryResultServiceLinkRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.mimeType = _cast(None, mimeType)
        self.service = _cast(None, service)
        self.resourceType = _cast(None, resourceType)
        self.resourceId = _cast(None, resourceId)
        self.linkHref = _cast(None, linkHref)
        self.rel = _cast(None, rel)
    def factory(*args_, **kwargs_):
        if QueryResultServiceLinkRecordType.subclass:
            return QueryResultServiceLinkRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultServiceLinkRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_mimeType(self): return self.mimeType
    def set_mimeType(self, mimeType): self.mimeType = mimeType
    def get_service(self): return self.service
    def set_service(self, service): self.service = service
    def get_resourceType(self): return self.resourceType
    def set_resourceType(self, resourceType): self.resourceType = resourceType
    def get_resourceId(self): return self.resourceId
    def set_resourceId(self, resourceId): self.resourceId = resourceId
    def get_linkHref(self): return self.linkHref
    def set_linkHref(self, linkHref): self.linkHref = linkHref
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def hasContent_(self):
        if (
            super(QueryResultServiceLinkRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultServiceLinkRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultServiceLinkRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultServiceLinkRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultServiceLinkRecordType'):
        super(QueryResultServiceLinkRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultServiceLinkRecordType')
        if self.mimeType is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            outfile.write(' mimeType=%s' % (self.gds_format_string(quote_attrib(self.mimeType).encode(ExternalEncoding), input_name='mimeType'), ))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            outfile.write(' service=%s' % (self.gds_format_string(quote_attrib(self.service).encode(ExternalEncoding), input_name='service'), ))
        if self.resourceType is not None and 'resourceType' not in already_processed:
            already_processed.add('resourceType')
            outfile.write(' resourceType=%s' % (self.gds_format_string(quote_attrib(self.resourceType).encode(ExternalEncoding), input_name='resourceType'), ))
        if self.resourceId is not None and 'resourceId' not in already_processed:
            already_processed.add('resourceId')
            outfile.write(' resourceId=%s' % (self.gds_format_string(quote_attrib(self.resourceId).encode(ExternalEncoding), input_name='resourceId'), ))
        if self.linkHref is not None and 'linkHref' not in already_processed:
            already_processed.add('linkHref')
            outfile.write(' linkHref=%s' % (self.gds_format_string(quote_attrib(self.linkHref).encode(ExternalEncoding), input_name='linkHref'), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultServiceLinkRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultServiceLinkRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultServiceLinkRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.mimeType is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            showIndent(outfile, level)
            outfile.write('mimeType="%s",\n' % (self.mimeType,))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            showIndent(outfile, level)
            outfile.write('service="%s",\n' % (self.service,))
        if self.resourceType is not None and 'resourceType' not in already_processed:
            already_processed.add('resourceType')
            showIndent(outfile, level)
            outfile.write('resourceType="%s",\n' % (self.resourceType,))
        if self.resourceId is not None and 'resourceId' not in already_processed:
            already_processed.add('resourceId')
            showIndent(outfile, level)
            outfile.write('resourceId="%s",\n' % (self.resourceId,))
        if self.linkHref is not None and 'linkHref' not in already_processed:
            already_processed.add('linkHref')
            showIndent(outfile, level)
            outfile.write('linkHref="%s",\n' % (self.linkHref,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel="%s",\n' % (self.rel,))
        super(QueryResultServiceLinkRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultServiceLinkRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('mimeType', node)
        if value is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            self.mimeType = value
        value = find_attr_value_('service', node)
        if value is not None and 'service' not in already_processed:
            already_processed.add('service')
            self.service = value
        value = find_attr_value_('resourceType', node)
        if value is not None and 'resourceType' not in already_processed:
            already_processed.add('resourceType')
            self.resourceType = value
        value = find_attr_value_('resourceId', node)
        if value is not None and 'resourceId' not in already_processed:
            already_processed.add('resourceId')
            self.resourceId = value
        value = find_attr_value_('linkHref', node)
        if value is not None and 'linkHref' not in already_processed:
            already_processed.add('linkHref')
            self.linkHref = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        super(QueryResultServiceLinkRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultServiceLinkRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultServiceLinkRecordType


class QueryResultOrgVdcStorageProfileRecordType(QueryResultRecordType):
    """5.1 Type for a single orgVdcStorageProfile query result in records
    format. 5.1none Name of the storage profile 5.1none True if this
    entity is enabled 5.1none True if this is the default storage
    profile. 5.1none Storage used in MB 5.1none Storage limit in MB
    5.1none Number of conditions on the storage profile 5.1none VDC
    reference or id 5.1none VDC name 5.1none True if the associated
    VDC is busy."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, isVdcBusy=None, storageUsedMB=None, name=None, isEnabled=None, storageLimitMB=None, isDefaultStorageProfile=None, vdcName=None, numberOfConditions=None, vdc=None):
        self.original_tagname_ = None
        super(QueryResultOrgVdcStorageProfileRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.isVdcBusy = _cast(bool, isVdcBusy)
        self.storageUsedMB = _cast(int, storageUsedMB)
        self.name = _cast(None, name)
        self.isEnabled = _cast(bool, isEnabled)
        self.storageLimitMB = _cast(int, storageLimitMB)
        self.isDefaultStorageProfile = _cast(bool, isDefaultStorageProfile)
        self.vdcName = _cast(None, vdcName)
        self.numberOfConditions = _cast(int, numberOfConditions)
        self.vdc = _cast(None, vdc)
    def factory(*args_, **kwargs_):
        if QueryResultOrgVdcStorageProfileRecordType.subclass:
            return QueryResultOrgVdcStorageProfileRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultOrgVdcStorageProfileRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_isVdcBusy(self): return self.isVdcBusy
    def set_isVdcBusy(self, isVdcBusy): self.isVdcBusy = isVdcBusy
    def get_storageUsedMB(self): return self.storageUsedMB
    def set_storageUsedMB(self, storageUsedMB): self.storageUsedMB = storageUsedMB
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_storageLimitMB(self): return self.storageLimitMB
    def set_storageLimitMB(self, storageLimitMB): self.storageLimitMB = storageLimitMB
    def get_isDefaultStorageProfile(self): return self.isDefaultStorageProfile
    def set_isDefaultStorageProfile(self, isDefaultStorageProfile): self.isDefaultStorageProfile = isDefaultStorageProfile
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_numberOfConditions(self): return self.numberOfConditions
    def set_numberOfConditions(self, numberOfConditions): self.numberOfConditions = numberOfConditions
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def hasContent_(self):
        if (
            super(QueryResultOrgVdcStorageProfileRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultOrgVdcStorageProfileRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgVdcStorageProfileRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultOrgVdcStorageProfileRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultOrgVdcStorageProfileRecordType'):
        super(QueryResultOrgVdcStorageProfileRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultOrgVdcStorageProfileRecordType')
        if self.isVdcBusy is not None and 'isVdcBusy' not in already_processed:
            already_processed.add('isVdcBusy')
            outfile.write(' isVdcBusy="%s"' % self.gds_format_boolean(self.isVdcBusy, input_name='isVdcBusy'))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            outfile.write(' storageUsedMB="%s"' % self.gds_format_integer(self.storageUsedMB, input_name='storageUsedMB'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            outfile.write(' storageLimitMB="%s"' % self.gds_format_integer(self.storageLimitMB, input_name='storageLimitMB'))
        if self.isDefaultStorageProfile is not None and 'isDefaultStorageProfile' not in already_processed:
            already_processed.add('isDefaultStorageProfile')
            outfile.write(' isDefaultStorageProfile="%s"' % self.gds_format_boolean(self.isDefaultStorageProfile, input_name='isDefaultStorageProfile'))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.numberOfConditions is not None and 'numberOfConditions' not in already_processed:
            already_processed.add('numberOfConditions')
            outfile.write(' numberOfConditions="%s"' % self.gds_format_integer(self.numberOfConditions, input_name='numberOfConditions'))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultOrgVdcStorageProfileRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultOrgVdcStorageProfileRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultOrgVdcStorageProfileRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.isVdcBusy is not None and 'isVdcBusy' not in already_processed:
            already_processed.add('isVdcBusy')
            showIndent(outfile, level)
            outfile.write('isVdcBusy=%s,\n' % (self.isVdcBusy,))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            showIndent(outfile, level)
            outfile.write('storageUsedMB=%d,\n' % (self.storageUsedMB,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            showIndent(outfile, level)
            outfile.write('storageLimitMB=%d,\n' % (self.storageLimitMB,))
        if self.isDefaultStorageProfile is not None and 'isDefaultStorageProfile' not in already_processed:
            already_processed.add('isDefaultStorageProfile')
            showIndent(outfile, level)
            outfile.write('isDefaultStorageProfile=%s,\n' % (self.isDefaultStorageProfile,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.numberOfConditions is not None and 'numberOfConditions' not in already_processed:
            already_processed.add('numberOfConditions')
            showIndent(outfile, level)
            outfile.write('numberOfConditions=%d,\n' % (self.numberOfConditions,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        super(QueryResultOrgVdcStorageProfileRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultOrgVdcStorageProfileRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isVdcBusy', node)
        if value is not None and 'isVdcBusy' not in already_processed:
            already_processed.add('isVdcBusy')
            if value in ('true', '1'):
                self.isVdcBusy = True
            elif value in ('false', '0'):
                self.isVdcBusy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('storageUsedMB', node)
        if value is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            try:
                self.storageUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('storageLimitMB', node)
        if value is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            try:
                self.storageLimitMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isDefaultStorageProfile', node)
        if value is not None and 'isDefaultStorageProfile' not in already_processed:
            already_processed.add('isDefaultStorageProfile')
            if value in ('true', '1'):
                self.isDefaultStorageProfile = True
            elif value in ('false', '0'):
                self.isDefaultStorageProfile = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('numberOfConditions', node)
        if value is not None and 'numberOfConditions' not in already_processed:
            already_processed.add('numberOfConditions')
            try:
                self.numberOfConditions = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        super(QueryResultOrgVdcStorageProfileRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultOrgVdcStorageProfileRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultOrgVdcStorageProfileRecordType


class QueryResultAdminOrgVdcStorageProfileRecordType(QueryResultRecordType):
    """5.1 Type for a single adminOrgVdcStorageProfile query result in
    records format. 5.1none Name of the storage profile 5.1none True
    if this entity is enabled 5.1none True if this is the default
    storage profile for a VDC. 5.1none Storage used in MB 5.1none
    Storage limit in MB 5.1none Number of conditions on the storage
    profile 5.1none VDC reference or id 5.1none VDC name 5.1none
    Organization reference or id 5.1none Virtual center reference or
    id 5.1none Managed object reference of the storage profile"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vc=None, storageUsedMB=None, name=None, isEnabled=None, storageLimitMB=None, isDefaultStorageProfile=None, vdcName=None, numberOfConditions=None, vdc=None, storageProfileMoref=None, org=None):
        self.original_tagname_ = None
        super(QueryResultAdminOrgVdcStorageProfileRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vc = _cast(None, vc)
        self.storageUsedMB = _cast(int, storageUsedMB)
        self.name = _cast(None, name)
        self.isEnabled = _cast(bool, isEnabled)
        self.storageLimitMB = _cast(int, storageLimitMB)
        self.isDefaultStorageProfile = _cast(bool, isDefaultStorageProfile)
        self.vdcName = _cast(None, vdcName)
        self.numberOfConditions = _cast(int, numberOfConditions)
        self.vdc = _cast(None, vdc)
        self.storageProfileMoref = _cast(None, storageProfileMoref)
        self.org = _cast(None, org)
    def factory(*args_, **kwargs_):
        if QueryResultAdminOrgVdcStorageProfileRecordType.subclass:
            return QueryResultAdminOrgVdcStorageProfileRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminOrgVdcStorageProfileRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_storageUsedMB(self): return self.storageUsedMB
    def set_storageUsedMB(self, storageUsedMB): self.storageUsedMB = storageUsedMB
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_storageLimitMB(self): return self.storageLimitMB
    def set_storageLimitMB(self, storageLimitMB): self.storageLimitMB = storageLimitMB
    def get_isDefaultStorageProfile(self): return self.isDefaultStorageProfile
    def set_isDefaultStorageProfile(self, isDefaultStorageProfile): self.isDefaultStorageProfile = isDefaultStorageProfile
    def get_vdcName(self): return self.vdcName
    def set_vdcName(self, vdcName): self.vdcName = vdcName
    def get_numberOfConditions(self): return self.numberOfConditions
    def set_numberOfConditions(self, numberOfConditions): self.numberOfConditions = numberOfConditions
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_storageProfileMoref(self): return self.storageProfileMoref
    def set_storageProfileMoref(self, storageProfileMoref): self.storageProfileMoref = storageProfileMoref
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def hasContent_(self):
        if (
            super(QueryResultAdminOrgVdcStorageProfileRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminOrgVdcStorageProfileRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminOrgVdcStorageProfileRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminOrgVdcStorageProfileRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminOrgVdcStorageProfileRecordType'):
        super(QueryResultAdminOrgVdcStorageProfileRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminOrgVdcStorageProfileRecordType')
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            outfile.write(' storageUsedMB="%s"' % self.gds_format_integer(self.storageUsedMB, input_name='storageUsedMB'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            outfile.write(' storageLimitMB="%s"' % self.gds_format_integer(self.storageLimitMB, input_name='storageLimitMB'))
        if self.isDefaultStorageProfile is not None and 'isDefaultStorageProfile' not in already_processed:
            already_processed.add('isDefaultStorageProfile')
            outfile.write(' isDefaultStorageProfile="%s"' % self.gds_format_boolean(self.isDefaultStorageProfile, input_name='isDefaultStorageProfile'))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            outfile.write(' vdcName=%s' % (self.gds_format_string(quote_attrib(self.vdcName).encode(ExternalEncoding), input_name='vdcName'), ))
        if self.numberOfConditions is not None and 'numberOfConditions' not in already_processed:
            already_processed.add('numberOfConditions')
            outfile.write(' numberOfConditions="%s"' % self.gds_format_integer(self.numberOfConditions, input_name='numberOfConditions'))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            outfile.write(' vdc=%s' % (self.gds_format_string(quote_attrib(self.vdc).encode(ExternalEncoding), input_name='vdc'), ))
        if self.storageProfileMoref is not None and 'storageProfileMoref' not in already_processed:
            already_processed.add('storageProfileMoref')
            outfile.write(' storageProfileMoref=%s' % (self.gds_format_string(quote_attrib(self.storageProfileMoref).encode(ExternalEncoding), input_name='storageProfileMoref'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminOrgVdcStorageProfileRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminOrgVdcStorageProfileRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminOrgVdcStorageProfileRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            showIndent(outfile, level)
            outfile.write('storageUsedMB=%d,\n' % (self.storageUsedMB,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.storageLimitMB is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            showIndent(outfile, level)
            outfile.write('storageLimitMB=%d,\n' % (self.storageLimitMB,))
        if self.isDefaultStorageProfile is not None and 'isDefaultStorageProfile' not in already_processed:
            already_processed.add('isDefaultStorageProfile')
            showIndent(outfile, level)
            outfile.write('isDefaultStorageProfile=%s,\n' % (self.isDefaultStorageProfile,))
        if self.vdcName is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            showIndent(outfile, level)
            outfile.write('vdcName="%s",\n' % (self.vdcName,))
        if self.numberOfConditions is not None and 'numberOfConditions' not in already_processed:
            already_processed.add('numberOfConditions')
            showIndent(outfile, level)
            outfile.write('numberOfConditions=%d,\n' % (self.numberOfConditions,))
        if self.vdc is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            showIndent(outfile, level)
            outfile.write('vdc="%s",\n' % (self.vdc,))
        if self.storageProfileMoref is not None and 'storageProfileMoref' not in already_processed:
            already_processed.add('storageProfileMoref')
            showIndent(outfile, level)
            outfile.write('storageProfileMoref="%s",\n' % (self.storageProfileMoref,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        super(QueryResultAdminOrgVdcStorageProfileRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminOrgVdcStorageProfileRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('storageUsedMB', node)
        if value is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            try:
                self.storageUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('storageLimitMB', node)
        if value is not None and 'storageLimitMB' not in already_processed:
            already_processed.add('storageLimitMB')
            try:
                self.storageLimitMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isDefaultStorageProfile', node)
        if value is not None and 'isDefaultStorageProfile' not in already_processed:
            already_processed.add('isDefaultStorageProfile')
            if value in ('true', '1'):
                self.isDefaultStorageProfile = True
            elif value in ('false', '0'):
                self.isDefaultStorageProfile = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vdcName', node)
        if value is not None and 'vdcName' not in already_processed:
            already_processed.add('vdcName')
            self.vdcName = value
        value = find_attr_value_('numberOfConditions', node)
        if value is not None and 'numberOfConditions' not in already_processed:
            already_processed.add('numberOfConditions')
            try:
                self.numberOfConditions = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('vdc', node)
        if value is not None and 'vdc' not in already_processed:
            already_processed.add('vdc')
            self.vdc = value
        value = find_attr_value_('storageProfileMoref', node)
        if value is not None and 'storageProfileMoref' not in already_processed:
            already_processed.add('storageProfileMoref')
            self.storageProfileMoref = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        super(QueryResultAdminOrgVdcStorageProfileRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminOrgVdcStorageProfileRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminOrgVdcStorageProfileRecordType


class QueryResultProviderVdcStorageProfileRecordType(QueryResultRecordType):
    """5.1 Type for a single providerVdcStorageProfile query result in
    records format. 5.1none True if this entity is enabled 5.1none
    Name of the Provider VDC storage profile 5.1none Total storage
    in MB 5.1none 5.1none 5.1none 5.1none Number of conditions on
    the provider storage profile 5.1none Provider VDC reference or
    id 5.1none Virtual center reference or id 5.1none Managed object
    reference of the storage profile"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, vc=None, storageUsedMB=None, name=None, providerVdc=None, storageTotalMB=None, isEnabled=None, storageProvisionedMB=None, numberOfConditions=None, storageRequestedMB=None, storageProfileMoref=None):
        self.original_tagname_ = None
        super(QueryResultProviderVdcStorageProfileRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.vc = _cast(None, vc)
        self.storageUsedMB = _cast(int, storageUsedMB)
        self.name = _cast(None, name)
        self.providerVdc = _cast(None, providerVdc)
        self.storageTotalMB = _cast(int, storageTotalMB)
        self.isEnabled = _cast(bool, isEnabled)
        self.storageProvisionedMB = _cast(int, storageProvisionedMB)
        self.numberOfConditions = _cast(int, numberOfConditions)
        self.storageRequestedMB = _cast(int, storageRequestedMB)
        self.storageProfileMoref = _cast(None, storageProfileMoref)
    def factory(*args_, **kwargs_):
        if QueryResultProviderVdcStorageProfileRecordType.subclass:
            return QueryResultProviderVdcStorageProfileRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultProviderVdcStorageProfileRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vc(self): return self.vc
    def set_vc(self, vc): self.vc = vc
    def get_storageUsedMB(self): return self.storageUsedMB
    def set_storageUsedMB(self, storageUsedMB): self.storageUsedMB = storageUsedMB
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_providerVdc(self): return self.providerVdc
    def set_providerVdc(self, providerVdc): self.providerVdc = providerVdc
    def get_storageTotalMB(self): return self.storageTotalMB
    def set_storageTotalMB(self, storageTotalMB): self.storageTotalMB = storageTotalMB
    def get_isEnabled(self): return self.isEnabled
    def set_isEnabled(self, isEnabled): self.isEnabled = isEnabled
    def get_storageProvisionedMB(self): return self.storageProvisionedMB
    def set_storageProvisionedMB(self, storageProvisionedMB): self.storageProvisionedMB = storageProvisionedMB
    def get_numberOfConditions(self): return self.numberOfConditions
    def set_numberOfConditions(self, numberOfConditions): self.numberOfConditions = numberOfConditions
    def get_storageRequestedMB(self): return self.storageRequestedMB
    def set_storageRequestedMB(self, storageRequestedMB): self.storageRequestedMB = storageRequestedMB
    def get_storageProfileMoref(self): return self.storageProfileMoref
    def set_storageProfileMoref(self, storageProfileMoref): self.storageProfileMoref = storageProfileMoref
    def hasContent_(self):
        if (
            super(QueryResultProviderVdcStorageProfileRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultProviderVdcStorageProfileRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultProviderVdcStorageProfileRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultProviderVdcStorageProfileRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultProviderVdcStorageProfileRecordType'):
        super(QueryResultProviderVdcStorageProfileRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultProviderVdcStorageProfileRecordType')
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            outfile.write(' vc=%s' % (self.gds_format_string(quote_attrib(self.vc).encode(ExternalEncoding), input_name='vc'), ))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            outfile.write(' storageUsedMB="%s"' % self.gds_format_integer(self.storageUsedMB, input_name='storageUsedMB'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            outfile.write(' providerVdc=%s' % (self.gds_format_string(quote_attrib(self.providerVdc).encode(ExternalEncoding), input_name='providerVdc'), ))
        if self.storageTotalMB is not None and 'storageTotalMB' not in already_processed:
            already_processed.add('storageTotalMB')
            outfile.write(' storageTotalMB="%s"' % self.gds_format_integer(self.storageTotalMB, input_name='storageTotalMB'))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            outfile.write(' isEnabled="%s"' % self.gds_format_boolean(self.isEnabled, input_name='isEnabled'))
        if self.storageProvisionedMB is not None and 'storageProvisionedMB' not in already_processed:
            already_processed.add('storageProvisionedMB')
            outfile.write(' storageProvisionedMB="%s"' % self.gds_format_integer(self.storageProvisionedMB, input_name='storageProvisionedMB'))
        if self.numberOfConditions is not None and 'numberOfConditions' not in already_processed:
            already_processed.add('numberOfConditions')
            outfile.write(' numberOfConditions="%s"' % self.gds_format_integer(self.numberOfConditions, input_name='numberOfConditions'))
        if self.storageRequestedMB is not None and 'storageRequestedMB' not in already_processed:
            already_processed.add('storageRequestedMB')
            outfile.write(' storageRequestedMB="%s"' % self.gds_format_integer(self.storageRequestedMB, input_name='storageRequestedMB'))
        if self.storageProfileMoref is not None and 'storageProfileMoref' not in already_processed:
            already_processed.add('storageProfileMoref')
            outfile.write(' storageProfileMoref=%s' % (self.gds_format_string(quote_attrib(self.storageProfileMoref).encode(ExternalEncoding), input_name='storageProfileMoref'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultProviderVdcStorageProfileRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultProviderVdcStorageProfileRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultProviderVdcStorageProfileRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vc is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            showIndent(outfile, level)
            outfile.write('vc="%s",\n' % (self.vc,))
        if self.storageUsedMB is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            showIndent(outfile, level)
            outfile.write('storageUsedMB=%d,\n' % (self.storageUsedMB,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.providerVdc is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            showIndent(outfile, level)
            outfile.write('providerVdc="%s",\n' % (self.providerVdc,))
        if self.storageTotalMB is not None and 'storageTotalMB' not in already_processed:
            already_processed.add('storageTotalMB')
            showIndent(outfile, level)
            outfile.write('storageTotalMB=%d,\n' % (self.storageTotalMB,))
        if self.isEnabled is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            showIndent(outfile, level)
            outfile.write('isEnabled=%s,\n' % (self.isEnabled,))
        if self.storageProvisionedMB is not None and 'storageProvisionedMB' not in already_processed:
            already_processed.add('storageProvisionedMB')
            showIndent(outfile, level)
            outfile.write('storageProvisionedMB=%d,\n' % (self.storageProvisionedMB,))
        if self.numberOfConditions is not None and 'numberOfConditions' not in already_processed:
            already_processed.add('numberOfConditions')
            showIndent(outfile, level)
            outfile.write('numberOfConditions=%d,\n' % (self.numberOfConditions,))
        if self.storageRequestedMB is not None and 'storageRequestedMB' not in already_processed:
            already_processed.add('storageRequestedMB')
            showIndent(outfile, level)
            outfile.write('storageRequestedMB=%d,\n' % (self.storageRequestedMB,))
        if self.storageProfileMoref is not None and 'storageProfileMoref' not in already_processed:
            already_processed.add('storageProfileMoref')
            showIndent(outfile, level)
            outfile.write('storageProfileMoref="%s",\n' % (self.storageProfileMoref,))
        super(QueryResultProviderVdcStorageProfileRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultProviderVdcStorageProfileRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vc', node)
        if value is not None and 'vc' not in already_processed:
            already_processed.add('vc')
            self.vc = value
        value = find_attr_value_('storageUsedMB', node)
        if value is not None and 'storageUsedMB' not in already_processed:
            already_processed.add('storageUsedMB')
            try:
                self.storageUsedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('providerVdc', node)
        if value is not None and 'providerVdc' not in already_processed:
            already_processed.add('providerVdc')
            self.providerVdc = value
        value = find_attr_value_('storageTotalMB', node)
        if value is not None and 'storageTotalMB' not in already_processed:
            already_processed.add('storageTotalMB')
            try:
                self.storageTotalMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('isEnabled', node)
        if value is not None and 'isEnabled' not in already_processed:
            already_processed.add('isEnabled')
            if value in ('true', '1'):
                self.isEnabled = True
            elif value in ('false', '0'):
                self.isEnabled = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('storageProvisionedMB', node)
        if value is not None and 'storageProvisionedMB' not in already_processed:
            already_processed.add('storageProvisionedMB')
            try:
                self.storageProvisionedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('numberOfConditions', node)
        if value is not None and 'numberOfConditions' not in already_processed:
            already_processed.add('numberOfConditions')
            try:
                self.numberOfConditions = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storageRequestedMB', node)
        if value is not None and 'storageRequestedMB' not in already_processed:
            already_processed.add('storageRequestedMB')
            try:
                self.storageRequestedMB = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('storageProfileMoref', node)
        if value is not None and 'storageProfileMoref' not in already_processed:
            already_processed.add('storageProfileMoref')
            self.storageProfileMoref = value
        super(QueryResultProviderVdcStorageProfileRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultProviderVdcStorageProfileRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultProviderVdcStorageProfileRecordType


class QueryResultApiFilterRecordType(QueryResultRecordType):
    """5.1 Type for a single apiFilter query result in records format.
    5.1none Url pattern on which the extension service is bind.
    5.1none Service reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, urlPattern=None, service=None):
        self.original_tagname_ = None
        super(QueryResultApiFilterRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.urlPattern = _cast(None, urlPattern)
        self.service = _cast(None, service)
    def factory(*args_, **kwargs_):
        if QueryResultApiFilterRecordType.subclass:
            return QueryResultApiFilterRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultApiFilterRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_urlPattern(self): return self.urlPattern
    def set_urlPattern(self, urlPattern): self.urlPattern = urlPattern
    def get_service(self): return self.service
    def set_service(self, service): self.service = service
    def hasContent_(self):
        if (
            super(QueryResultApiFilterRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultApiFilterRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultApiFilterRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultApiFilterRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultApiFilterRecordType'):
        super(QueryResultApiFilterRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultApiFilterRecordType')
        if self.urlPattern is not None and 'urlPattern' not in already_processed:
            already_processed.add('urlPattern')
            outfile.write(' urlPattern=%s' % (self.gds_format_string(quote_attrib(self.urlPattern).encode(ExternalEncoding), input_name='urlPattern'), ))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            outfile.write(' service=%s' % (self.gds_format_string(quote_attrib(self.service).encode(ExternalEncoding), input_name='service'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultApiFilterRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultApiFilterRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultApiFilterRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.urlPattern is not None and 'urlPattern' not in already_processed:
            already_processed.add('urlPattern')
            showIndent(outfile, level)
            outfile.write('urlPattern="%s",\n' % (self.urlPattern,))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            showIndent(outfile, level)
            outfile.write('service="%s",\n' % (self.service,))
        super(QueryResultApiFilterRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultApiFilterRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('urlPattern', node)
        if value is not None and 'urlPattern' not in already_processed:
            already_processed.add('urlPattern')
            self.urlPattern = value
        value = find_attr_value_('service', node)
        if value is not None and 'service' not in already_processed:
            already_processed.add('service')
            self.service = value
        super(QueryResultApiFilterRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultApiFilterRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultApiFilterRecordType


class QueryResultAdminApiDefinitionRecordType(QueryResultRecordType):
    """5.1 Type for a single adminApiDefinition query result in records
    format. 5.1none API definition name 5.1none API definition entry
    point 5.1none Service reference or id 5.1none API definition
    namespace. 5.1none API definition vendor. 5.1none Service name
    5.1none Service namespace 5.1none Service vendor"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, service=None, namespace=None, serviceName=None, entryPoint=None, serviceVendor=None, serviceNamespace=None, apiVendor=None):
        self.original_tagname_ = None
        super(QueryResultAdminApiDefinitionRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.service = _cast(None, service)
        self.namespace = _cast(None, namespace)
        self.serviceName = _cast(None, serviceName)
        self.entryPoint = _cast(None, entryPoint)
        self.serviceVendor = _cast(None, serviceVendor)
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.apiVendor = _cast(None, apiVendor)
    def factory(*args_, **kwargs_):
        if QueryResultAdminApiDefinitionRecordType.subclass:
            return QueryResultAdminApiDefinitionRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminApiDefinitionRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_service(self): return self.service
    def set_service(self, service): self.service = service
    def get_namespace(self): return self.namespace
    def set_namespace(self, namespace): self.namespace = namespace
    def get_serviceName(self): return self.serviceName
    def set_serviceName(self, serviceName): self.serviceName = serviceName
    def get_entryPoint(self): return self.entryPoint
    def set_entryPoint(self, entryPoint): self.entryPoint = entryPoint
    def get_serviceVendor(self): return self.serviceVendor
    def set_serviceVendor(self, serviceVendor): self.serviceVendor = serviceVendor
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def get_apiVendor(self): return self.apiVendor
    def set_apiVendor(self, apiVendor): self.apiVendor = apiVendor
    def hasContent_(self):
        if (
            super(QueryResultAdminApiDefinitionRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminApiDefinitionRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminApiDefinitionRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminApiDefinitionRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminApiDefinitionRecordType'):
        super(QueryResultAdminApiDefinitionRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminApiDefinitionRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            outfile.write(' service=%s' % (self.gds_format_string(quote_attrib(self.service).encode(ExternalEncoding), input_name='service'), ))
        if self.namespace is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            outfile.write(' namespace=%s' % (self.gds_format_string(quote_attrib(self.namespace).encode(ExternalEncoding), input_name='namespace'), ))
        if self.serviceName is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            outfile.write(' serviceName=%s' % (self.gds_format_string(quote_attrib(self.serviceName).encode(ExternalEncoding), input_name='serviceName'), ))
        if self.entryPoint is not None and 'entryPoint' not in already_processed:
            already_processed.add('entryPoint')
            outfile.write(' entryPoint=%s' % (self.gds_format_string(quote_attrib(self.entryPoint).encode(ExternalEncoding), input_name='entryPoint'), ))
        if self.serviceVendor is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            outfile.write(' serviceVendor=%s' % (self.gds_format_string(quote_attrib(self.serviceVendor).encode(ExternalEncoding), input_name='serviceVendor'), ))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
        if self.apiVendor is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            outfile.write(' apiVendor=%s' % (self.gds_format_string(quote_attrib(self.apiVendor).encode(ExternalEncoding), input_name='apiVendor'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminApiDefinitionRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminApiDefinitionRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminApiDefinitionRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            showIndent(outfile, level)
            outfile.write('service="%s",\n' % (self.service,))
        if self.namespace is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            showIndent(outfile, level)
            outfile.write('namespace="%s",\n' % (self.namespace,))
        if self.serviceName is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            showIndent(outfile, level)
            outfile.write('serviceName="%s",\n' % (self.serviceName,))
        if self.entryPoint is not None and 'entryPoint' not in already_processed:
            already_processed.add('entryPoint')
            showIndent(outfile, level)
            outfile.write('entryPoint="%s",\n' % (self.entryPoint,))
        if self.serviceVendor is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            showIndent(outfile, level)
            outfile.write('serviceVendor="%s",\n' % (self.serviceVendor,))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        if self.apiVendor is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            showIndent(outfile, level)
            outfile.write('apiVendor="%s",\n' % (self.apiVendor,))
        super(QueryResultAdminApiDefinitionRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminApiDefinitionRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('service', node)
        if value is not None and 'service' not in already_processed:
            already_processed.add('service')
            self.service = value
        value = find_attr_value_('namespace', node)
        if value is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            self.namespace = value
        value = find_attr_value_('serviceName', node)
        if value is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            self.serviceName = value
        value = find_attr_value_('entryPoint', node)
        if value is not None and 'entryPoint' not in already_processed:
            already_processed.add('entryPoint')
            self.entryPoint = value
        value = find_attr_value_('serviceVendor', node)
        if value is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            self.serviceVendor = value
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        value = find_attr_value_('apiVendor', node)
        if value is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            self.apiVendor = value
        super(QueryResultAdminApiDefinitionRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminApiDefinitionRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminApiDefinitionRecordType


class QueryResultApiDefinitionRecordType(QueryResultRecordType):
    """5.1 Type for a single apiDefinition query result in records format.
    5.1none API definition name 5.1none API definition entry point
    5.1none Service reference or id 5.1none API definition
    namespace. 5.1none API definition vendor. 5.1none Service name
    5.1none Service namespace 5.1none Service vendor"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, service=None, namespace=None, serviceName=None, entryPoint=None, serviceVendor=None, serviceNamespace=None, apiVendor=None):
        self.original_tagname_ = None
        super(QueryResultApiDefinitionRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.service = _cast(None, service)
        self.namespace = _cast(None, namespace)
        self.serviceName = _cast(None, serviceName)
        self.entryPoint = _cast(None, entryPoint)
        self.serviceVendor = _cast(None, serviceVendor)
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.apiVendor = _cast(None, apiVendor)
    def factory(*args_, **kwargs_):
        if QueryResultApiDefinitionRecordType.subclass:
            return QueryResultApiDefinitionRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultApiDefinitionRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_service(self): return self.service
    def set_service(self, service): self.service = service
    def get_namespace(self): return self.namespace
    def set_namespace(self, namespace): self.namespace = namespace
    def get_serviceName(self): return self.serviceName
    def set_serviceName(self, serviceName): self.serviceName = serviceName
    def get_entryPoint(self): return self.entryPoint
    def set_entryPoint(self, entryPoint): self.entryPoint = entryPoint
    def get_serviceVendor(self): return self.serviceVendor
    def set_serviceVendor(self, serviceVendor): self.serviceVendor = serviceVendor
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def get_apiVendor(self): return self.apiVendor
    def set_apiVendor(self, apiVendor): self.apiVendor = apiVendor
    def hasContent_(self):
        if (
            super(QueryResultApiDefinitionRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultApiDefinitionRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultApiDefinitionRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultApiDefinitionRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultApiDefinitionRecordType'):
        super(QueryResultApiDefinitionRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultApiDefinitionRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            outfile.write(' service=%s' % (self.gds_format_string(quote_attrib(self.service).encode(ExternalEncoding), input_name='service'), ))
        if self.namespace is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            outfile.write(' namespace=%s' % (self.gds_format_string(quote_attrib(self.namespace).encode(ExternalEncoding), input_name='namespace'), ))
        if self.serviceName is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            outfile.write(' serviceName=%s' % (self.gds_format_string(quote_attrib(self.serviceName).encode(ExternalEncoding), input_name='serviceName'), ))
        if self.entryPoint is not None and 'entryPoint' not in already_processed:
            already_processed.add('entryPoint')
            outfile.write(' entryPoint=%s' % (self.gds_format_string(quote_attrib(self.entryPoint).encode(ExternalEncoding), input_name='entryPoint'), ))
        if self.serviceVendor is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            outfile.write(' serviceVendor=%s' % (self.gds_format_string(quote_attrib(self.serviceVendor).encode(ExternalEncoding), input_name='serviceVendor'), ))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
        if self.apiVendor is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            outfile.write(' apiVendor=%s' % (self.gds_format_string(quote_attrib(self.apiVendor).encode(ExternalEncoding), input_name='apiVendor'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultApiDefinitionRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultApiDefinitionRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultApiDefinitionRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            showIndent(outfile, level)
            outfile.write('service="%s",\n' % (self.service,))
        if self.namespace is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            showIndent(outfile, level)
            outfile.write('namespace="%s",\n' % (self.namespace,))
        if self.serviceName is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            showIndent(outfile, level)
            outfile.write('serviceName="%s",\n' % (self.serviceName,))
        if self.entryPoint is not None and 'entryPoint' not in already_processed:
            already_processed.add('entryPoint')
            showIndent(outfile, level)
            outfile.write('entryPoint="%s",\n' % (self.entryPoint,))
        if self.serviceVendor is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            showIndent(outfile, level)
            outfile.write('serviceVendor="%s",\n' % (self.serviceVendor,))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        if self.apiVendor is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            showIndent(outfile, level)
            outfile.write('apiVendor="%s",\n' % (self.apiVendor,))
        super(QueryResultApiDefinitionRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultApiDefinitionRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('service', node)
        if value is not None and 'service' not in already_processed:
            already_processed.add('service')
            self.service = value
        value = find_attr_value_('namespace', node)
        if value is not None and 'namespace' not in already_processed:
            already_processed.add('namespace')
            self.namespace = value
        value = find_attr_value_('serviceName', node)
        if value is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            self.serviceName = value
        value = find_attr_value_('entryPoint', node)
        if value is not None and 'entryPoint' not in already_processed:
            already_processed.add('entryPoint')
            self.entryPoint = value
        value = find_attr_value_('serviceVendor', node)
        if value is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            self.serviceVendor = value
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        value = find_attr_value_('apiVendor', node)
        if value is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            self.apiVendor = value
        super(QueryResultApiDefinitionRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultApiDefinitionRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultApiDefinitionRecordType


class QueryResultAdminFileDescriptorRecordType(QueryResultRecordType):
    """5.1 Type for a single adminFileDescriptor query result in records
    format. 5.1none File URL. 5.1none Reference to the API
    definition owner of the file descriptor 5.1none File mime type.
    5.1none File name. 5.1none API definition name 5.1none API
    definition namespace 5.1none API definition vendor 5.1none File
    descriptor owner service name 5.1none File descriptor owner
    service namespace 5.1none File descriptor owner service vendor
    5.1none Service reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, service=None, apiDefinition=None, fileMimeType=None, serviceName=None, serviceVendor=None, apiName=None, apiNamespace=None, fileUrl=None, apiVendor=None, serviceNamespace=None, name=None):
        self.original_tagname_ = None
        super(QueryResultAdminFileDescriptorRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.service = _cast(None, service)
        self.apiDefinition = _cast(None, apiDefinition)
        self.fileMimeType = _cast(None, fileMimeType)
        self.serviceName = _cast(None, serviceName)
        self.serviceVendor = _cast(None, serviceVendor)
        self.apiName = _cast(None, apiName)
        self.apiNamespace = _cast(None, apiNamespace)
        self.fileUrl = _cast(None, fileUrl)
        self.apiVendor = _cast(None, apiVendor)
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.name = _cast(None, name)
    def factory(*args_, **kwargs_):
        if QueryResultAdminFileDescriptorRecordType.subclass:
            return QueryResultAdminFileDescriptorRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAdminFileDescriptorRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_service(self): return self.service
    def set_service(self, service): self.service = service
    def get_apiDefinition(self): return self.apiDefinition
    def set_apiDefinition(self, apiDefinition): self.apiDefinition = apiDefinition
    def get_fileMimeType(self): return self.fileMimeType
    def set_fileMimeType(self, fileMimeType): self.fileMimeType = fileMimeType
    def get_serviceName(self): return self.serviceName
    def set_serviceName(self, serviceName): self.serviceName = serviceName
    def get_serviceVendor(self): return self.serviceVendor
    def set_serviceVendor(self, serviceVendor): self.serviceVendor = serviceVendor
    def get_apiName(self): return self.apiName
    def set_apiName(self, apiName): self.apiName = apiName
    def get_apiNamespace(self): return self.apiNamespace
    def set_apiNamespace(self, apiNamespace): self.apiNamespace = apiNamespace
    def get_fileUrl(self): return self.fileUrl
    def set_fileUrl(self, fileUrl): self.fileUrl = fileUrl
    def get_apiVendor(self): return self.apiVendor
    def set_apiVendor(self, apiVendor): self.apiVendor = apiVendor
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            super(QueryResultAdminFileDescriptorRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAdminFileDescriptorRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminFileDescriptorRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAdminFileDescriptorRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAdminFileDescriptorRecordType'):
        super(QueryResultAdminFileDescriptorRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAdminFileDescriptorRecordType')
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            outfile.write(' service=%s' % (self.gds_format_string(quote_attrib(self.service).encode(ExternalEncoding), input_name='service'), ))
        if self.apiDefinition is not None and 'apiDefinition' not in already_processed:
            already_processed.add('apiDefinition')
            outfile.write(' apiDefinition=%s' % (self.gds_format_string(quote_attrib(self.apiDefinition).encode(ExternalEncoding), input_name='apiDefinition'), ))
        if self.fileMimeType is not None and 'fileMimeType' not in already_processed:
            already_processed.add('fileMimeType')
            outfile.write(' fileMimeType=%s' % (self.gds_format_string(quote_attrib(self.fileMimeType).encode(ExternalEncoding), input_name='fileMimeType'), ))
        if self.serviceName is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            outfile.write(' serviceName=%s' % (self.gds_format_string(quote_attrib(self.serviceName).encode(ExternalEncoding), input_name='serviceName'), ))
        if self.serviceVendor is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            outfile.write(' serviceVendor=%s' % (self.gds_format_string(quote_attrib(self.serviceVendor).encode(ExternalEncoding), input_name='serviceVendor'), ))
        if self.apiName is not None and 'apiName' not in already_processed:
            already_processed.add('apiName')
            outfile.write(' apiName=%s' % (self.gds_format_string(quote_attrib(self.apiName).encode(ExternalEncoding), input_name='apiName'), ))
        if self.apiNamespace is not None and 'apiNamespace' not in already_processed:
            already_processed.add('apiNamespace')
            outfile.write(' apiNamespace=%s' % (self.gds_format_string(quote_attrib(self.apiNamespace).encode(ExternalEncoding), input_name='apiNamespace'), ))
        if self.fileUrl is not None and 'fileUrl' not in already_processed:
            already_processed.add('fileUrl')
            outfile.write(' fileUrl=%s' % (self.gds_format_string(quote_attrib(self.fileUrl).encode(ExternalEncoding), input_name='fileUrl'), ))
        if self.apiVendor is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            outfile.write(' apiVendor=%s' % (self.gds_format_string(quote_attrib(self.apiVendor).encode(ExternalEncoding), input_name='apiVendor'), ))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAdminFileDescriptorRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAdminFileDescriptorRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAdminFileDescriptorRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            showIndent(outfile, level)
            outfile.write('service="%s",\n' % (self.service,))
        if self.apiDefinition is not None and 'apiDefinition' not in already_processed:
            already_processed.add('apiDefinition')
            showIndent(outfile, level)
            outfile.write('apiDefinition="%s",\n' % (self.apiDefinition,))
        if self.fileMimeType is not None and 'fileMimeType' not in already_processed:
            already_processed.add('fileMimeType')
            showIndent(outfile, level)
            outfile.write('fileMimeType="%s",\n' % (self.fileMimeType,))
        if self.serviceName is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            showIndent(outfile, level)
            outfile.write('serviceName="%s",\n' % (self.serviceName,))
        if self.serviceVendor is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            showIndent(outfile, level)
            outfile.write('serviceVendor="%s",\n' % (self.serviceVendor,))
        if self.apiName is not None and 'apiName' not in already_processed:
            already_processed.add('apiName')
            showIndent(outfile, level)
            outfile.write('apiName="%s",\n' % (self.apiName,))
        if self.apiNamespace is not None and 'apiNamespace' not in already_processed:
            already_processed.add('apiNamespace')
            showIndent(outfile, level)
            outfile.write('apiNamespace="%s",\n' % (self.apiNamespace,))
        if self.fileUrl is not None and 'fileUrl' not in already_processed:
            already_processed.add('fileUrl')
            showIndent(outfile, level)
            outfile.write('fileUrl="%s",\n' % (self.fileUrl,))
        if self.apiVendor is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            showIndent(outfile, level)
            outfile.write('apiVendor="%s",\n' % (self.apiVendor,))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(QueryResultAdminFileDescriptorRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAdminFileDescriptorRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('service', node)
        if value is not None and 'service' not in already_processed:
            already_processed.add('service')
            self.service = value
        value = find_attr_value_('apiDefinition', node)
        if value is not None and 'apiDefinition' not in already_processed:
            already_processed.add('apiDefinition')
            self.apiDefinition = value
        value = find_attr_value_('fileMimeType', node)
        if value is not None and 'fileMimeType' not in already_processed:
            already_processed.add('fileMimeType')
            self.fileMimeType = value
        value = find_attr_value_('serviceName', node)
        if value is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            self.serviceName = value
        value = find_attr_value_('serviceVendor', node)
        if value is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            self.serviceVendor = value
        value = find_attr_value_('apiName', node)
        if value is not None and 'apiName' not in already_processed:
            already_processed.add('apiName')
            self.apiName = value
        value = find_attr_value_('apiNamespace', node)
        if value is not None and 'apiNamespace' not in already_processed:
            already_processed.add('apiNamespace')
            self.apiNamespace = value
        value = find_attr_value_('fileUrl', node)
        if value is not None and 'fileUrl' not in already_processed:
            already_processed.add('fileUrl')
            self.fileUrl = value
        value = find_attr_value_('apiVendor', node)
        if value is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            self.apiVendor = value
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(QueryResultAdminFileDescriptorRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAdminFileDescriptorRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAdminFileDescriptorRecordType


class QueryResultFileDescriptorRecordType(QueryResultRecordType):
    """5.1 Type for a single fileDescriptor query result in records format.
    5.1none File URL. 5.1none Reference to the API definition owner
    of the file descriptor 5.1none File mime type. 5.1none File
    name. 5.1none API definition name 5.1none API definition
    namespace 5.1none API definition vendor 5.1none File descriptor
    owner service name 5.1none File descriptor owner service
    namespace 5.1none File descriptor owner service vendor 5.1none
    Service reference or id"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, service=None, apiDefinition=None, fileMimeType=None, serviceName=None, serviceVendor=None, apiName=None, apiNamespace=None, fileUrl=None, apiVendor=None, serviceNamespace=None, name=None):
        self.original_tagname_ = None
        super(QueryResultFileDescriptorRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.service = _cast(None, service)
        self.apiDefinition = _cast(None, apiDefinition)
        self.fileMimeType = _cast(None, fileMimeType)
        self.serviceName = _cast(None, serviceName)
        self.serviceVendor = _cast(None, serviceVendor)
        self.apiName = _cast(None, apiName)
        self.apiNamespace = _cast(None, apiNamespace)
        self.fileUrl = _cast(None, fileUrl)
        self.apiVendor = _cast(None, apiVendor)
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.name = _cast(None, name)
    def factory(*args_, **kwargs_):
        if QueryResultFileDescriptorRecordType.subclass:
            return QueryResultFileDescriptorRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultFileDescriptorRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_service(self): return self.service
    def set_service(self, service): self.service = service
    def get_apiDefinition(self): return self.apiDefinition
    def set_apiDefinition(self, apiDefinition): self.apiDefinition = apiDefinition
    def get_fileMimeType(self): return self.fileMimeType
    def set_fileMimeType(self, fileMimeType): self.fileMimeType = fileMimeType
    def get_serviceName(self): return self.serviceName
    def set_serviceName(self, serviceName): self.serviceName = serviceName
    def get_serviceVendor(self): return self.serviceVendor
    def set_serviceVendor(self, serviceVendor): self.serviceVendor = serviceVendor
    def get_apiName(self): return self.apiName
    def set_apiName(self, apiName): self.apiName = apiName
    def get_apiNamespace(self): return self.apiNamespace
    def set_apiNamespace(self, apiNamespace): self.apiNamespace = apiNamespace
    def get_fileUrl(self): return self.fileUrl
    def set_fileUrl(self, fileUrl): self.fileUrl = fileUrl
    def get_apiVendor(self): return self.apiVendor
    def set_apiVendor(self, apiVendor): self.apiVendor = apiVendor
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            super(QueryResultFileDescriptorRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultFileDescriptorRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultFileDescriptorRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultFileDescriptorRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultFileDescriptorRecordType'):
        super(QueryResultFileDescriptorRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultFileDescriptorRecordType')
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            outfile.write(' service=%s' % (self.gds_format_string(quote_attrib(self.service).encode(ExternalEncoding), input_name='service'), ))
        if self.apiDefinition is not None and 'apiDefinition' not in already_processed:
            already_processed.add('apiDefinition')
            outfile.write(' apiDefinition=%s' % (self.gds_format_string(quote_attrib(self.apiDefinition).encode(ExternalEncoding), input_name='apiDefinition'), ))
        if self.fileMimeType is not None and 'fileMimeType' not in already_processed:
            already_processed.add('fileMimeType')
            outfile.write(' fileMimeType=%s' % (self.gds_format_string(quote_attrib(self.fileMimeType).encode(ExternalEncoding), input_name='fileMimeType'), ))
        if self.serviceName is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            outfile.write(' serviceName=%s' % (self.gds_format_string(quote_attrib(self.serviceName).encode(ExternalEncoding), input_name='serviceName'), ))
        if self.serviceVendor is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            outfile.write(' serviceVendor=%s' % (self.gds_format_string(quote_attrib(self.serviceVendor).encode(ExternalEncoding), input_name='serviceVendor'), ))
        if self.apiName is not None and 'apiName' not in already_processed:
            already_processed.add('apiName')
            outfile.write(' apiName=%s' % (self.gds_format_string(quote_attrib(self.apiName).encode(ExternalEncoding), input_name='apiName'), ))
        if self.apiNamespace is not None and 'apiNamespace' not in already_processed:
            already_processed.add('apiNamespace')
            outfile.write(' apiNamespace=%s' % (self.gds_format_string(quote_attrib(self.apiNamespace).encode(ExternalEncoding), input_name='apiNamespace'), ))
        if self.fileUrl is not None and 'fileUrl' not in already_processed:
            already_processed.add('fileUrl')
            outfile.write(' fileUrl=%s' % (self.gds_format_string(quote_attrib(self.fileUrl).encode(ExternalEncoding), input_name='fileUrl'), ))
        if self.apiVendor is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            outfile.write(' apiVendor=%s' % (self.gds_format_string(quote_attrib(self.apiVendor).encode(ExternalEncoding), input_name='apiVendor'), ))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultFileDescriptorRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultFileDescriptorRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultFileDescriptorRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            showIndent(outfile, level)
            outfile.write('service="%s",\n' % (self.service,))
        if self.apiDefinition is not None and 'apiDefinition' not in already_processed:
            already_processed.add('apiDefinition')
            showIndent(outfile, level)
            outfile.write('apiDefinition="%s",\n' % (self.apiDefinition,))
        if self.fileMimeType is not None and 'fileMimeType' not in already_processed:
            already_processed.add('fileMimeType')
            showIndent(outfile, level)
            outfile.write('fileMimeType="%s",\n' % (self.fileMimeType,))
        if self.serviceName is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            showIndent(outfile, level)
            outfile.write('serviceName="%s",\n' % (self.serviceName,))
        if self.serviceVendor is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            showIndent(outfile, level)
            outfile.write('serviceVendor="%s",\n' % (self.serviceVendor,))
        if self.apiName is not None and 'apiName' not in already_processed:
            already_processed.add('apiName')
            showIndent(outfile, level)
            outfile.write('apiName="%s",\n' % (self.apiName,))
        if self.apiNamespace is not None and 'apiNamespace' not in already_processed:
            already_processed.add('apiNamespace')
            showIndent(outfile, level)
            outfile.write('apiNamespace="%s",\n' % (self.apiNamespace,))
        if self.fileUrl is not None and 'fileUrl' not in already_processed:
            already_processed.add('fileUrl')
            showIndent(outfile, level)
            outfile.write('fileUrl="%s",\n' % (self.fileUrl,))
        if self.apiVendor is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            showIndent(outfile, level)
            outfile.write('apiVendor="%s",\n' % (self.apiVendor,))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(QueryResultFileDescriptorRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultFileDescriptorRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('service', node)
        if value is not None and 'service' not in already_processed:
            already_processed.add('service')
            self.service = value
        value = find_attr_value_('apiDefinition', node)
        if value is not None and 'apiDefinition' not in already_processed:
            already_processed.add('apiDefinition')
            self.apiDefinition = value
        value = find_attr_value_('fileMimeType', node)
        if value is not None and 'fileMimeType' not in already_processed:
            already_processed.add('fileMimeType')
            self.fileMimeType = value
        value = find_attr_value_('serviceName', node)
        if value is not None and 'serviceName' not in already_processed:
            already_processed.add('serviceName')
            self.serviceName = value
        value = find_attr_value_('serviceVendor', node)
        if value is not None and 'serviceVendor' not in already_processed:
            already_processed.add('serviceVendor')
            self.serviceVendor = value
        value = find_attr_value_('apiName', node)
        if value is not None and 'apiName' not in already_processed:
            already_processed.add('apiName')
            self.apiName = value
        value = find_attr_value_('apiNamespace', node)
        if value is not None and 'apiNamespace' not in already_processed:
            already_processed.add('apiNamespace')
            self.apiNamespace = value
        value = find_attr_value_('fileUrl', node)
        if value is not None and 'fileUrl' not in already_processed:
            already_processed.add('fileUrl')
            self.fileUrl = value
        value = find_attr_value_('apiVendor', node)
        if value is not None and 'apiVendor' not in already_processed:
            already_processed.add('apiVendor')
            self.apiVendor = value
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(QueryResultFileDescriptorRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultFileDescriptorRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultFileDescriptorRecordType


class QueryResultResourceClassActionRecordType(QueryResultRecordType):
    """5.1 Type for a single resourceClassAction query result in records
    format. 5.1none The name of the action. 5.1none HTTP request
    method. One of GET, POST, PUT, DELETE. 5.1none HTTP URL regular
    expression pattern. 5.1none Reference to resource class."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, httpMethod=None, resourceClass=None, name=None, urlPattern=None):
        self.original_tagname_ = None
        super(QueryResultResourceClassActionRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.httpMethod = _cast(None, httpMethod)
        self.resourceClass = _cast(None, resourceClass)
        self.name = _cast(None, name)
        self.urlPattern = _cast(None, urlPattern)
    def factory(*args_, **kwargs_):
        if QueryResultResourceClassActionRecordType.subclass:
            return QueryResultResourceClassActionRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultResourceClassActionRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_httpMethod(self): return self.httpMethod
    def set_httpMethod(self, httpMethod): self.httpMethod = httpMethod
    def get_resourceClass(self): return self.resourceClass
    def set_resourceClass(self, resourceClass): self.resourceClass = resourceClass
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_urlPattern(self): return self.urlPattern
    def set_urlPattern(self, urlPattern): self.urlPattern = urlPattern
    def hasContent_(self):
        if (
            super(QueryResultResourceClassActionRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultResourceClassActionRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultResourceClassActionRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultResourceClassActionRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultResourceClassActionRecordType'):
        super(QueryResultResourceClassActionRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultResourceClassActionRecordType')
        if self.httpMethod is not None and 'httpMethod' not in already_processed:
            already_processed.add('httpMethod')
            outfile.write(' httpMethod=%s' % (self.gds_format_string(quote_attrib(self.httpMethod).encode(ExternalEncoding), input_name='httpMethod'), ))
        if self.resourceClass is not None and 'resourceClass' not in already_processed:
            already_processed.add('resourceClass')
            outfile.write(' resourceClass=%s' % (self.gds_format_string(quote_attrib(self.resourceClass).encode(ExternalEncoding), input_name='resourceClass'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.urlPattern is not None and 'urlPattern' not in already_processed:
            already_processed.add('urlPattern')
            outfile.write(' urlPattern=%s' % (self.gds_format_string(quote_attrib(self.urlPattern).encode(ExternalEncoding), input_name='urlPattern'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultResourceClassActionRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultResourceClassActionRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultResourceClassActionRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.httpMethod is not None and 'httpMethod' not in already_processed:
            already_processed.add('httpMethod')
            showIndent(outfile, level)
            outfile.write('httpMethod="%s",\n' % (self.httpMethod,))
        if self.resourceClass is not None and 'resourceClass' not in already_processed:
            already_processed.add('resourceClass')
            showIndent(outfile, level)
            outfile.write('resourceClass="%s",\n' % (self.resourceClass,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.urlPattern is not None and 'urlPattern' not in already_processed:
            already_processed.add('urlPattern')
            showIndent(outfile, level)
            outfile.write('urlPattern="%s",\n' % (self.urlPattern,))
        super(QueryResultResourceClassActionRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultResourceClassActionRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('httpMethod', node)
        if value is not None and 'httpMethod' not in already_processed:
            already_processed.add('httpMethod')
            self.httpMethod = value
        value = find_attr_value_('resourceClass', node)
        if value is not None and 'resourceClass' not in already_processed:
            already_processed.add('resourceClass')
            self.resourceClass = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('urlPattern', node)
        if value is not None and 'urlPattern' not in already_processed:
            already_processed.add('urlPattern')
            self.urlPattern = value
        super(QueryResultResourceClassActionRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultResourceClassActionRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultResourceClassActionRecordType


class QueryResultAclRuleRecordType(QueryResultRecordType):
    """5.1 Type for a single aclRule query result in records format.
    5.1none Organization reference or id. 5.1none Principal
    reference. 5.1none The name of the ACL rule. 5.1none
    ServiceResource reference or id. 5.1none Principal type - user
    or right. 5.1none Resource class action reference or id. 5.1none
    Organization Access - Entity, Shared or Published. 5.1none
    Service Resource Access - Entity or Shared . 5.1none Principal
    Access - Entity or Shared."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, orgAccess=None, name=None, resourceClassAction=None, serviceResourceAccess=None, principalType=None, principalAccess=None, org=None, serviceResource=None, principal=None):
        self.original_tagname_ = None
        super(QueryResultAclRuleRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.orgAccess = _cast(None, orgAccess)
        self.name = _cast(None, name)
        self.resourceClassAction = _cast(None, resourceClassAction)
        self.serviceResourceAccess = _cast(None, serviceResourceAccess)
        self.principalType = _cast(None, principalType)
        self.principalAccess = _cast(None, principalAccess)
        self.org = _cast(None, org)
        self.serviceResource = _cast(None, serviceResource)
        self.principal = _cast(None, principal)
    def factory(*args_, **kwargs_):
        if QueryResultAclRuleRecordType.subclass:
            return QueryResultAclRuleRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultAclRuleRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_orgAccess(self): return self.orgAccess
    def set_orgAccess(self, orgAccess): self.orgAccess = orgAccess
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_resourceClassAction(self): return self.resourceClassAction
    def set_resourceClassAction(self, resourceClassAction): self.resourceClassAction = resourceClassAction
    def get_serviceResourceAccess(self): return self.serviceResourceAccess
    def set_serviceResourceAccess(self, serviceResourceAccess): self.serviceResourceAccess = serviceResourceAccess
    def get_principalType(self): return self.principalType
    def set_principalType(self, principalType): self.principalType = principalType
    def get_principalAccess(self): return self.principalAccess
    def set_principalAccess(self, principalAccess): self.principalAccess = principalAccess
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_serviceResource(self): return self.serviceResource
    def set_serviceResource(self, serviceResource): self.serviceResource = serviceResource
    def get_principal(self): return self.principal
    def set_principal(self, principal): self.principal = principal
    def hasContent_(self):
        if (
            super(QueryResultAclRuleRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultAclRuleRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAclRuleRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultAclRuleRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultAclRuleRecordType'):
        super(QueryResultAclRuleRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultAclRuleRecordType')
        if self.orgAccess is not None and 'orgAccess' not in already_processed:
            already_processed.add('orgAccess')
            outfile.write(' orgAccess=%s' % (self.gds_format_string(quote_attrib(self.orgAccess).encode(ExternalEncoding), input_name='orgAccess'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.resourceClassAction is not None and 'resourceClassAction' not in already_processed:
            already_processed.add('resourceClassAction')
            outfile.write(' resourceClassAction=%s' % (self.gds_format_string(quote_attrib(self.resourceClassAction).encode(ExternalEncoding), input_name='resourceClassAction'), ))
        if self.serviceResourceAccess is not None and 'serviceResourceAccess' not in already_processed:
            already_processed.add('serviceResourceAccess')
            outfile.write(' serviceResourceAccess=%s' % (self.gds_format_string(quote_attrib(self.serviceResourceAccess).encode(ExternalEncoding), input_name='serviceResourceAccess'), ))
        if self.principalType is not None and 'principalType' not in already_processed:
            already_processed.add('principalType')
            outfile.write(' principalType=%s' % (self.gds_format_string(quote_attrib(self.principalType).encode(ExternalEncoding), input_name='principalType'), ))
        if self.principalAccess is not None and 'principalAccess' not in already_processed:
            already_processed.add('principalAccess')
            outfile.write(' principalAccess=%s' % (self.gds_format_string(quote_attrib(self.principalAccess).encode(ExternalEncoding), input_name='principalAccess'), ))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.serviceResource is not None and 'serviceResource' not in already_processed:
            already_processed.add('serviceResource')
            outfile.write(' serviceResource=%s' % (self.gds_format_string(quote_attrib(self.serviceResource).encode(ExternalEncoding), input_name='serviceResource'), ))
        if self.principal is not None and 'principal' not in already_processed:
            already_processed.add('principal')
            outfile.write(' principal=%s' % (self.gds_format_string(quote_attrib(self.principal).encode(ExternalEncoding), input_name='principal'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultAclRuleRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultAclRuleRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultAclRuleRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.orgAccess is not None and 'orgAccess' not in already_processed:
            already_processed.add('orgAccess')
            showIndent(outfile, level)
            outfile.write('orgAccess="%s",\n' % (self.orgAccess,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.resourceClassAction is not None and 'resourceClassAction' not in already_processed:
            already_processed.add('resourceClassAction')
            showIndent(outfile, level)
            outfile.write('resourceClassAction="%s",\n' % (self.resourceClassAction,))
        if self.serviceResourceAccess is not None and 'serviceResourceAccess' not in already_processed:
            already_processed.add('serviceResourceAccess')
            showIndent(outfile, level)
            outfile.write('serviceResourceAccess="%s",\n' % (self.serviceResourceAccess,))
        if self.principalType is not None and 'principalType' not in already_processed:
            already_processed.add('principalType')
            showIndent(outfile, level)
            outfile.write('principalType="%s",\n' % (self.principalType,))
        if self.principalAccess is not None and 'principalAccess' not in already_processed:
            already_processed.add('principalAccess')
            showIndent(outfile, level)
            outfile.write('principalAccess="%s",\n' % (self.principalAccess,))
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.serviceResource is not None and 'serviceResource' not in already_processed:
            already_processed.add('serviceResource')
            showIndent(outfile, level)
            outfile.write('serviceResource="%s",\n' % (self.serviceResource,))
        if self.principal is not None and 'principal' not in already_processed:
            already_processed.add('principal')
            showIndent(outfile, level)
            outfile.write('principal="%s",\n' % (self.principal,))
        super(QueryResultAclRuleRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultAclRuleRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('orgAccess', node)
        if value is not None and 'orgAccess' not in already_processed:
            already_processed.add('orgAccess')
            self.orgAccess = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('resourceClassAction', node)
        if value is not None and 'resourceClassAction' not in already_processed:
            already_processed.add('resourceClassAction')
            self.resourceClassAction = value
        value = find_attr_value_('serviceResourceAccess', node)
        if value is not None and 'serviceResourceAccess' not in already_processed:
            already_processed.add('serviceResourceAccess')
            self.serviceResourceAccess = value
        value = find_attr_value_('principalType', node)
        if value is not None and 'principalType' not in already_processed:
            already_processed.add('principalType')
            self.principalType = value
        value = find_attr_value_('principalAccess', node)
        if value is not None and 'principalAccess' not in already_processed:
            already_processed.add('principalAccess')
            self.principalAccess = value
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('serviceResource', node)
        if value is not None and 'serviceResource' not in already_processed:
            already_processed.add('serviceResource')
            self.serviceResource = value
        value = find_attr_value_('principal', node)
        if value is not None and 'principal' not in already_processed:
            already_processed.add('principal')
            self.principal = value
        super(QueryResultAclRuleRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultAclRuleRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultAclRuleRecordType


class QueryResultResourceClassRecordType(QueryResultRecordType):
    """5.1 Type for a single resourceClass query result in records format.
    5.1none The name of the resource class. 5.1none Service
    reference or id 5.1none The MIME type of this resource class.
    5.1none Object's url template 5.1none NID part of a urn which in
    the resolving process will have link based on the url template
    5.1none String template that should match the NSS part of a urn"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, mimeType=None, name=None, service=None, urnPattern=None, nid=None, urlTemplate=None):
        self.original_tagname_ = None
        super(QueryResultResourceClassRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.mimeType = _cast(None, mimeType)
        self.name = _cast(None, name)
        self.service = _cast(None, service)
        self.urnPattern = _cast(None, urnPattern)
        self.nid = _cast(None, nid)
        self.urlTemplate = _cast(None, urlTemplate)
    def factory(*args_, **kwargs_):
        if QueryResultResourceClassRecordType.subclass:
            return QueryResultResourceClassRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultResourceClassRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_mimeType(self): return self.mimeType
    def set_mimeType(self, mimeType): self.mimeType = mimeType
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_service(self): return self.service
    def set_service(self, service): self.service = service
    def get_urnPattern(self): return self.urnPattern
    def set_urnPattern(self, urnPattern): self.urnPattern = urnPattern
    def get_nid(self): return self.nid
    def set_nid(self, nid): self.nid = nid
    def get_urlTemplate(self): return self.urlTemplate
    def set_urlTemplate(self, urlTemplate): self.urlTemplate = urlTemplate
    def hasContent_(self):
        if (
            super(QueryResultResourceClassRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultResourceClassRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultResourceClassRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultResourceClassRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultResourceClassRecordType'):
        super(QueryResultResourceClassRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultResourceClassRecordType')
        if self.mimeType is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            outfile.write(' mimeType=%s' % (self.gds_format_string(quote_attrib(self.mimeType).encode(ExternalEncoding), input_name='mimeType'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            outfile.write(' service=%s' % (self.gds_format_string(quote_attrib(self.service).encode(ExternalEncoding), input_name='service'), ))
        if self.urnPattern is not None and 'urnPattern' not in already_processed:
            already_processed.add('urnPattern')
            outfile.write(' urnPattern=%s' % (self.gds_format_string(quote_attrib(self.urnPattern).encode(ExternalEncoding), input_name='urnPattern'), ))
        if self.nid is not None and 'nid' not in already_processed:
            already_processed.add('nid')
            outfile.write(' nid=%s' % (self.gds_format_string(quote_attrib(self.nid).encode(ExternalEncoding), input_name='nid'), ))
        if self.urlTemplate is not None and 'urlTemplate' not in already_processed:
            already_processed.add('urlTemplate')
            outfile.write(' urlTemplate=%s' % (self.gds_format_string(quote_attrib(self.urlTemplate).encode(ExternalEncoding), input_name='urlTemplate'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultResourceClassRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultResourceClassRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultResourceClassRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.mimeType is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            showIndent(outfile, level)
            outfile.write('mimeType="%s",\n' % (self.mimeType,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.service is not None and 'service' not in already_processed:
            already_processed.add('service')
            showIndent(outfile, level)
            outfile.write('service="%s",\n' % (self.service,))
        if self.urnPattern is not None and 'urnPattern' not in already_processed:
            already_processed.add('urnPattern')
            showIndent(outfile, level)
            outfile.write('urnPattern="%s",\n' % (self.urnPattern,))
        if self.nid is not None and 'nid' not in already_processed:
            already_processed.add('nid')
            showIndent(outfile, level)
            outfile.write('nid="%s",\n' % (self.nid,))
        if self.urlTemplate is not None and 'urlTemplate' not in already_processed:
            already_processed.add('urlTemplate')
            showIndent(outfile, level)
            outfile.write('urlTemplate="%s",\n' % (self.urlTemplate,))
        super(QueryResultResourceClassRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultResourceClassRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('mimeType', node)
        if value is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            self.mimeType = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('service', node)
        if value is not None and 'service' not in already_processed:
            already_processed.add('service')
            self.service = value
        value = find_attr_value_('urnPattern', node)
        if value is not None and 'urnPattern' not in already_processed:
            already_processed.add('urnPattern')
            self.urnPattern = value
        value = find_attr_value_('nid', node)
        if value is not None and 'nid' not in already_processed:
            already_processed.add('nid')
            self.nid = value
        value = find_attr_value_('urlTemplate', node)
        if value is not None and 'urlTemplate' not in already_processed:
            already_processed.add('urlTemplate')
            self.urlTemplate = value
        super(QueryResultResourceClassRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultResourceClassRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultResourceClassRecordType


class QueryResultServiceResourceRecordType(QueryResultRecordType):
    """5.1 Type for a single serviceResource query result in records
    format. 5.1none The name of the service resource. 5.1none
    Reference to organization or id. 5.1none Reference to resource
    class. 5.1none The id of the external object."""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, org=None, externalObjectId=None, name=None, resourceClass=None):
        self.original_tagname_ = None
        super(QueryResultServiceResourceRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.org = _cast(None, org)
        self.externalObjectId = _cast(None, externalObjectId)
        self.name = _cast(None, name)
        self.resourceClass = _cast(None, resourceClass)
    def factory(*args_, **kwargs_):
        if QueryResultServiceResourceRecordType.subclass:
            return QueryResultServiceResourceRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultServiceResourceRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_org(self): return self.org
    def set_org(self, org): self.org = org
    def get_externalObjectId(self): return self.externalObjectId
    def set_externalObjectId(self, externalObjectId): self.externalObjectId = externalObjectId
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_resourceClass(self): return self.resourceClass
    def set_resourceClass(self, resourceClass): self.resourceClass = resourceClass
    def hasContent_(self):
        if (
            super(QueryResultServiceResourceRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultServiceResourceRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultServiceResourceRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultServiceResourceRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultServiceResourceRecordType'):
        super(QueryResultServiceResourceRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultServiceResourceRecordType')
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            outfile.write(' org=%s' % (self.gds_format_string(quote_attrib(self.org).encode(ExternalEncoding), input_name='org'), ))
        if self.externalObjectId is not None and 'externalObjectId' not in already_processed:
            already_processed.add('externalObjectId')
            outfile.write(' externalObjectId=%s' % (self.gds_format_string(quote_attrib(self.externalObjectId).encode(ExternalEncoding), input_name='externalObjectId'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.resourceClass is not None and 'resourceClass' not in already_processed:
            already_processed.add('resourceClass')
            outfile.write(' resourceClass=%s' % (self.gds_format_string(quote_attrib(self.resourceClass).encode(ExternalEncoding), input_name='resourceClass'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QueryResultServiceResourceRecordType', fromsubclass_=False, pretty_print=True):
        super(QueryResultServiceResourceRecordType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QueryResultServiceResourceRecordType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.org is not None and 'org' not in already_processed:
            already_processed.add('org')
            showIndent(outfile, level)
            outfile.write('org="%s",\n' % (self.org,))
        if self.externalObjectId is not None and 'externalObjectId' not in already_processed:
            already_processed.add('externalObjectId')
            showIndent(outfile, level)
            outfile.write('externalObjectId="%s",\n' % (self.externalObjectId,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.resourceClass is not None and 'resourceClass' not in already_processed:
            already_processed.add('resourceClass')
            showIndent(outfile, level)
            outfile.write('resourceClass="%s",\n' % (self.resourceClass,))
        super(QueryResultServiceResourceRecordType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryResultServiceResourceRecordType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('org', node)
        if value is not None and 'org' not in already_processed:
            already_processed.add('org')
            self.org = value
        value = find_attr_value_('externalObjectId', node)
        if value is not None and 'externalObjectId' not in already_processed:
            already_processed.add('externalObjectId')
            self.externalObjectId = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('resourceClass', node)
        if value is not None and 'resourceClass' not in already_processed:
            already_processed.add('resourceClass')
            self.resourceClass = value
        super(QueryResultServiceResourceRecordType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryResultServiceResourceRecordType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryResultServiceResourceRecordType


class QueryResultEdgeGatewayRecordType(QueryResultRecordType):
    """5.1 Type for a single edgeGateway query result in records format.
    5.1none EdgeGateway name. 5.1none VDC Reference or ID 5.1none
    Number of external networks connected to the edgeGateway.
    5.1none Number of org VDC networks connected to the edgeGateway
    5.1none True if this Edge Gateway is busy. 5.1none 5.1none High
    Availability Status of the edgeGateway"""
    subclass = None
    superclass = QueryResultRecordType
    def __init__(self, href=None, type_=None, id=None, Link=None, Metadata=None, name=None, haStatus=None, gatewayStatus=None, vdc=None, numberOfExtNetworks=None, numberOfOrgNetworks=None, isBusy=None):
        self.original_tagname_ = None
        super(QueryResultEdgeGatewayRecordType, self).__init__(href, type_, id, Link, Metadata, )
        self.name = _cast(None, name)
        self.haStatus = _cast(None, haStatus)
        self.gatewayStatus = _cast(None, gatewayStatus)
        self.vdc = _cast(None, vdc)
        self.numberOfExtNetworks = _cast(int, numberOfExtNetworks)
        self.numberOfOrgNetworks = _cast(int, numberOfOrgNetworks)
        self.isBusy = _cast(bool, isBusy)
    def factory(*args_, **kwargs_):
        if QueryResultEdgeGatewayRecordType.subclass:
            return QueryResultEdgeGatewayRecordType.subclass(*args_, **kwargs_)
        else:
            return QueryResultEdgeGatewayRecordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_haStatus(self): return self.haStatus
    def set_haStatus(self, haStatus): self.haStatus = haStatus
    def get_gatewayStatus(self): return self.gatewayStatus
    def set_gatewayStatus(self, gatewayStatus): self.gatewayStatus = gatewayStatus
    def get_vdc(self): return self.vdc
    def set_vdc(self, vdc): self.vdc = vdc
    def get_numberOfExtNetworks(self): return self.numberOfExtNetworks
    def set_numberOfExtNetworks(self, numberOfExtNetworks): self.numberOfExtNetworks = numberOfExtNetworks
    def get_numberOfOrgNetworks(self): return self.numberOfOrgNetworks
    def set_numberOfOrgNetworks(self, numberOfOrgNetworks): self.numberOfOrgNetworks = numberOfOrgNetworks
    def get_isBusy(self): return self.isBusy
    def set_isBusy(self, isBusy): self.isBusy = isBusy
    def hasContent_(self):
        if (
            super(QueryResultEdgeGatewayRecordType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryResultEdgeGatewayRecordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultEdgeGatewayRecordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryResultEdgeGatewayRecordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryResultEdgeGatewayRecordType'):
        super(QueryResultEdgeGatewayRecordType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryResultEdgeGatewayRecordType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.haStatus is not None and 'haStatus' not in already_processed:
            already_processed.add('haStatus')
            outfile.write(' haStatus=%s' % (self.gds_format_string(quote_attrib(self.haStatus).encode(ExternalEncoding), input_name='haStatus'), ))
        if self.gatewayStatus is not None and 'gatewayStatus' not in already_processed:
            already_processed.add('gatewayStatus')
            outfile.write(' gatewayStatus=%s' % (self.gds_format_string(quote_attrib(self.gatewayStatus).encode(E