#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Oct 28 21:10:09 2014 by generateDS.py version 2.12e.
#
# Command line options:
#   ('-o', 'schema/vchs/ondemand/iam/user/UserType.py')
#
# Command line arguments:
#   schema/vchs/ondemand/iam/user/User.xsd
#
# Command line:
#   ./generateDS-2.12e/generateDS.py -o "schema/vchs/ondemand/iam/user/UserType.py" schema/vchs/ondemand/iam/user/User.xsd
#
# Current working directory (os.getcwd()):
#   vchs-api-cli-cli
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class roles(GeneratedsSuper):
    """5.7 Type that encapsulates the list of role elements."""
    subclass = None
    superclass = None
    def __init__(self, role=None):
        self.original_tagname_ = None
        if role is None:
            self.role = []
        else:
            self.role = role
    def factory(*args_, **kwargs_):
        if roles.subclass:
            return roles.subclass(*args_, **kwargs_)
        else:
            return roles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def add_role(self, value): self.role.append(value)
    def insert_role_at(self, index, value): self.role.insert(index, value)
    def replace_role_at(self, index, value): self.role[index] = value
    def hasContent_(self):
        if (
            self.role
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='roles', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='roles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='roles', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='roles'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='roles', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for role_ in self.role:
            role_.export(outfile, level, namespace_='tns:', name_='role', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='roles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('role=[\n')
        level += 1
        for role_ in self.role:
            showIndent(outfile, level)
            outfile.write('model_.role(\n')
            role_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'role':
            obj_ = role.factory()
            obj_.build(child_)
            self.role.append(obj_)
            obj_.original_tagname_ = 'role'
# end class roles


class role(GeneratedsSuper):
    """5.7 Element that encapsulates individual role details. contains:
    description : Contains brief description about the role. name :
    Name of the role. Following are the list of supported role name.
    Account Administrator, Virtual Infrastructure Administrator,
    Network Administrator, Read-Only Administrator, Subscription
    Administrator, End User. rights : list of rights associated with
    role. Typically a right would control access to API. For example
    PUT:User would indicate whether the role has right to update a
    user. 5.7 Unique id of the role.id varies from 1 to 6 which
    correspond to the individual role. Following are the id
    corresponding to supported roles. 1 -> Account Administrator, 2
    -> Virtual Infrastructure Administrator, 3 -> Network
    Administrator, 4 -> Read-Only Administrator, 5 -> Subscription
    Administrator, 6 -> End User."""
    subclass = None
    superclass = None
    def __init__(self, id=None, description=None, name=None, rights=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.description = description
        self.name = name
        if rights is None:
            self.rights = []
        else:
            self.rights = rights
    def factory(*args_, **kwargs_):
        if role.subclass:
            return role.subclass(*args_, **kwargs_)
        else:
            return role(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_rights(self): return self.rights
    def set_rights(self, rights): self.rights = rights
    def add_rights(self, value): self.rights.append(value)
    def insert_rights_at(self, index, value): self.rights.insert(index, value)
    def replace_rights_at(self, index, value): self.rights[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.description is not None or
            self.name is not None or
            self.rights
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='role', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='role')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='role', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='role'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='role', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        for rights_ in self.rights:
            rights_.export(outfile, level, namespace_, name_='rights', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='role'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('rights=[\n')
        level += 1
        for rights_ in self.rights:
            showIndent(outfile, level)
            outfile.write('model_.right(\n')
            rights_.exportLiteral(outfile, level, name_='right')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'rights':
            obj_ = right.factory()
            obj_.build(child_)
            self.rights.append(obj_)
            obj_.original_tagname_ = 'rights'
# end class role


class right(GeneratedsSuper):
    """5.7 Indiviudal right information , rights typically correspond to
    action. Example : PUT:User right would correspond to update user
    action. contains: id, name."""
    subclass = None
    superclass = None
    def __init__(self, id=None, name=None):
        self.original_tagname_ = None
        self.id = id
        self.name = name
    def factory(*args_, **kwargs_):
        if right.subclass:
            return right.subclass(*args_, **kwargs_)
        else:
            return right(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            self.id is not None or
            self.name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='right', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0" xmlns:meta="http://www.vmware.com/vchs/iam/MetaTypes/v2.0" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='right')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='right', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='right'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='right', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % ('meta:', self.gds_format_string(quote_xml(self.id).encode(ExternalEncoding), input_name='id'), 'meta:', eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % ('meta:', self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), 'meta:', eol_))
    def exportLiteral(self, outfile, level, name_='right'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id=%s,\n' % quote_python(self.id).encode(ExternalEncoding))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            id_ = child_.text
            id_ = self.gds_validate_string(id_, node, 'id')
            self.id = id_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
# end class right


class scimCore(GeneratedsSuper):
    """5.7 Base type for User , Company etc. This encapsulates common
    information listed below which are extended by User , Company
    etc types. Contains: meta : Meta element encapsulates creation
    and modification details of any given resource. schemas: The
    schemas attribute is an array of Strings which allows
    introspection of the supported schema version for a SCIM
    representation as well any schema extensions supported by that
    representation. state: Indicates the current state of the
    resource. Supported values : {ACTIVE , INACTIVE} 5.7 id
    attribute signfies the id of type extending the ScimCore type.
    Example for User this would correspond to userId , for company
    this would correspond to companyId."""
    subclass = None
    superclass = None
    def __init__(self, id=None, meta=None, schemas=None, state=None, extensiontype_=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.meta = meta
        if schemas is None:
            self.schemas = []
        else:
            self.schemas = schemas
        self.state = state
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if scimCore.subclass:
            return scimCore.subclass(*args_, **kwargs_)
        else:
            return scimCore(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def get_schemas(self): return self.schemas
    def set_schemas(self, schemas): self.schemas = schemas
    def add_schemas(self, value): self.schemas.append(value)
    def insert_schemas_at(self, index, value): self.schemas.insert(index, value)
    def replace_schemas_at(self, index, value): self.schemas[index] = value
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.meta is not None or
            self.schemas or
            self.state is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='scimCore', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0" xmlns:meta="http://www.vmware.com/vchs/iam/MetaTypes/v2.0" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='scimCore')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='scimCore', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='scimCore'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='tns:', name_='scimCore', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.meta is not None:
            self.meta.export(outfile, level, namespace_, name_='meta', pretty_print=pretty_print)
        for schemas_ in self.schemas:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sschemas>%s</%sschemas>%s' % (namespace_, self.gds_format_string(quote_xml(schemas_).encode(ExternalEncoding), input_name='schemas'), namespace_, eol_))
        if self.state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstate>%s</%sstate>%s' % (namespace_, self.gds_format_string(quote_xml(self.state).encode(ExternalEncoding), input_name='state'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='scimCore'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.meta is not None:
            showIndent(outfile, level)
            outfile.write('meta=model_.metainfo(\n')
            self.meta.exportLiteral(outfile, level, name_='meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('schemas=[\n')
        level += 1
        for schemas_ in self.schemas:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(schemas_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('state=%s,\n' % quote_python(self.state).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            obj_ = metainfo.factory()
            obj_.build(child_)
            self.meta = obj_
            obj_.original_tagname_ = 'meta'
        elif nodeName_ == 'schemas':
            schemas_ = child_.text
            schemas_ = self.gds_validate_string(schemas_, node, 'schemas')
            self.schemas.append(schemas_)
        elif nodeName_ == 'state':
            state_ = child_.text
            state_ = self.gds_validate_string(state_, node, 'state')
            self.state = state_
# end class scimCore


class company(scimCore):
    """5.7 Encapsulates the information about the company. contains:
    accountNumber : Account number of this company, description :
    Brief description about this company, name : Name of this
    company. 5.7 Base type for User , Company etc. This encapsulates
    common information listed below which are extended by User ,
    Company etc types. Contains: meta : Meta element encapsulates
    creation and modification details of any given resource.
    schemas: The schemas attribute is an array of Strings which
    allows introspection of the supported schema version for a SCIM
    representation as well any schema extensions supported by that
    representation. state: Indicates the current state of the
    resource. Supported values : {ACTIVE , INACTIVE} id: id of the
    extending resource , eg : would correspond to userid for User."""
    subclass = None
    superclass = scimCore
    def __init__(self, id=None, meta=None, schemas=None, state=None, accountNumber=None, description=None, name=None):
        self.original_tagname_ = None
        super(company, self).__init__(id, meta, schemas, state, )
        self.accountNumber = accountNumber
        self.description = description
        self.name = name
    def factory(*args_, **kwargs_):
        if company.subclass:
            return company.subclass(*args_, **kwargs_)
        else:
            return company(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_accountNumber(self): return self.accountNumber
    def set_accountNumber(self, accountNumber): self.accountNumber = accountNumber
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            self.accountNumber is not None or
            self.description is not None or
            self.name is not None or
            super(company, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='company', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='company')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='company', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='company'):
        super(company, self).exportAttributes(outfile, level, already_processed, namespace_, name_='company')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='company', fromsubclass_=False, pretty_print=True):
        super(company, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.accountNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccountNumber>%s</%saccountNumber>%s' % (namespace_, self.gds_format_string(quote_xml(self.accountNumber).encode(ExternalEncoding), input_name='accountNumber'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='company'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(company, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(company, self).exportLiteralChildren(outfile, level, name_)
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('accountNumber=%s,\n' % quote_python(self.accountNumber).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(company, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'accountNumber':
            accountNumber_ = child_.text
            accountNumber_ = self.gds_validate_string(accountNumber_, node, 'accountNumber')
            self.accountNumber = accountNumber_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        super(company, self).buildChildren(child_, node, nodeName_, True)
# end class company


class serviceGroups(GeneratedsSuper):
    """5.7 serviceGroup element list contains list serviceGroup details."""
    subclass = None
    superclass = None
    def __init__(self, serviceGroup=None):
        self.original_tagname_ = None
        if serviceGroup is None:
            self.serviceGroup = []
        else:
            self.serviceGroup = serviceGroup
    def factory(*args_, **kwargs_):
        if serviceGroups.subclass:
            return serviceGroups.subclass(*args_, **kwargs_)
        else:
            return serviceGroups(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_serviceGroup(self): return self.serviceGroup
    def set_serviceGroup(self, serviceGroup): self.serviceGroup = serviceGroup
    def add_serviceGroup(self, value): self.serviceGroup.append(value)
    def insert_serviceGroup_at(self, index, value): self.serviceGroup.insert(index, value)
    def replace_serviceGroup_at(self, index, value): self.serviceGroup[index] = value
    def hasContent_(self):
        if (
            self.serviceGroup
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='serviceGroups', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='serviceGroups')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='serviceGroups', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='serviceGroups'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='serviceGroups', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for serviceGroup_ in self.serviceGroup:
            serviceGroup_.export(outfile, level, namespace_='tns:', name_='serviceGroup', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='serviceGroups'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('serviceGroup=[\n')
        level += 1
        for serviceGroup_ in self.serviceGroup:
            showIndent(outfile, level)
            outfile.write('model_.serviceGroup(\n')
            serviceGroup_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'serviceGroup':
            obj_ = serviceGroup.factory()
            obj_.build(child_)
            self.serviceGroup.append(obj_)
            obj_.original_tagname_ = 'serviceGroup'
# end class serviceGroups


class serviceGroup(GeneratedsSuper):
    """5.7 Type that encapsulates serviceGroup. contains serviceGroupId,
    displayName."""
    subclass = None
    superclass = None
    def __init__(self, serviceGroupId=None, displayName=None):
        self.original_tagname_ = None
        self.serviceGroupId = serviceGroupId
        self.displayName = displayName
    def factory(*args_, **kwargs_):
        if serviceGroup.subclass:
            return serviceGroup.subclass(*args_, **kwargs_)
        else:
            return serviceGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_serviceGroupId(self): return self.serviceGroupId
    def set_serviceGroupId(self, serviceGroupId): self.serviceGroupId = serviceGroupId
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def hasContent_(self):
        if (
            self.serviceGroupId is not None or
            self.displayName is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='serviceGroup', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='serviceGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='serviceGroup', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='serviceGroup'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='serviceGroup', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.serviceGroupId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserviceGroupId>%s</%sserviceGroupId>%s' % (namespace_, self.gds_format_string(quote_xml(self.serviceGroupId).encode(ExternalEncoding), input_name='serviceGroupId'), namespace_, eol_))
        if self.displayName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespace_, self.gds_format_string(quote_xml(self.displayName).encode(ExternalEncoding), input_name='displayName'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='serviceGroup'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.serviceGroupId is not None:
            showIndent(outfile, level)
            outfile.write('serviceGroupId=%s,\n' % quote_python(self.serviceGroupId).encode(ExternalEncoding))
        if self.displayName is not None:
            showIndent(outfile, level)
            outfile.write('displayName=%s,\n' % quote_python(self.displayName).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'serviceGroupId':
            serviceGroupId_ = child_.text
            serviceGroupId_ = self.gds_validate_string(serviceGroupId_, node, 'serviceGroupId')
            self.serviceGroupId = serviceGroupId_
        elif nodeName_ == 'displayName':
            displayName_ = child_.text
            displayName_ = self.gds_validate_string(displayName_, node, 'displayName')
            self.displayName = displayName_
# end class serviceGroup


class userList(GeneratedsSuper):
    """5.7 Encapsulates a list of user elements."""
    subclass = None
    superclass = None
    def __init__(self, User=None):
        self.original_tagname_ = None
        if User is None:
            self.User = []
        else:
            self.User = User
    def factory(*args_, **kwargs_):
        if userList.subclass:
            return userList.subclass(*args_, **kwargs_)
        else:
            return userList(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def add_User(self, value): self.User.append(value)
    def insert_User_at(self, index, value): self.User.insert(index, value)
    def replace_User_at(self, index, value): self.User[index] = value
    def hasContent_(self):
        if (
            self.User
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='userList', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='userList')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='userList', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='userList'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='userList', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for User_ in self.User:
            User_.export(outfile, level, namespace_='tns:', name_='User', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='userList'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('User=[\n')
        level += 1
        for User_ in self.User:
            showIndent(outfile, level)
            outfile.write('model_.user(\n')
            User_.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'User':
            obj_ = user.factory()
            obj_.build(child_)
            self.User.append(obj_)
            obj_.original_tagname_ = 'User'
# end class userList


class user(scimCore):
    """5.7 user type contains : companyId, customerNumber, email,
    familyName, givenName, roles, serviceGroups, tosAcceptDate,
    tosAccepted, userName."""
    subclass = None
    superclass = scimCore
    def __init__(self, id=None, meta=None, schemas=None, state=None, companyId=None, customerNumber=None, email=None, familyName=None, givenName=None, roles=None, serviceGroups=None, tosAcceptDate=None, tosAccepted=None, userName=None):
        self.original_tagname_ = None
        super(user, self).__init__(id, meta, schemas, state, )
        self.companyId = companyId
        self.customerNumber = customerNumber
        self.email = email
        self.familyName = familyName
        self.givenName = givenName
        self.roles = roles
        self.serviceGroups = serviceGroups
        if isinstance(tosAcceptDate, basestring):
            initvalue_ = datetime_.datetime.strptime(tosAcceptDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = tosAcceptDate
        self.tosAcceptDate = initvalue_
        self.tosAccepted = tosAccepted
        self.userName = userName
    def factory(*args_, **kwargs_):
        if user.subclass:
            return user.subclass(*args_, **kwargs_)
        else:
            return user(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_companyId(self): return self.companyId
    def set_companyId(self, companyId): self.companyId = companyId
    def get_customerNumber(self): return self.customerNumber
    def set_customerNumber(self, customerNumber): self.customerNumber = customerNumber
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_familyName(self): return self.familyName
    def set_familyName(self, familyName): self.familyName = familyName
    def get_givenName(self): return self.givenName
    def set_givenName(self, givenName): self.givenName = givenName
    def get_roles(self): return self.roles
    def set_roles(self, roles): self.roles = roles
    def get_serviceGroups(self): return self.serviceGroups
    def set_serviceGroups(self, serviceGroups): self.serviceGroups = serviceGroups
    def get_tosAcceptDate(self): return self.tosAcceptDate
    def set_tosAcceptDate(self, tosAcceptDate): self.tosAcceptDate = tosAcceptDate
    def get_tosAccepted(self): return self.tosAccepted
    def set_tosAccepted(self, tosAccepted): self.tosAccepted = tosAccepted
    def get_userName(self): return self.userName
    def set_userName(self, userName): self.userName = userName
    def hasContent_(self):
        if (
            self.companyId is not None or
            self.customerNumber is not None or
            self.email is not None or
            self.familyName is not None or
            self.givenName is not None or
            self.roles is not None or
            self.serviceGroups is not None or
            self.tosAcceptDate is not None or
            self.tosAccepted is not None or
            self.userName is not None or
            super(user, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='user', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='user')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='user', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='user'):
        super(user, self).exportAttributes(outfile, level, already_processed, namespace_, name_='user')
    def exportChildren(self, outfile, level, namespace_='tns:', name_='user', fromsubclass_=False, pretty_print=True):
        super(user, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.companyId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scompanyId>%s</%scompanyId>%s' % (namespace_, self.gds_format_string(quote_xml(self.companyId).encode(ExternalEncoding), input_name='companyId'), namespace_, eol_))
        if self.customerNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scustomerNumber>%s</%scustomerNumber>%s' % (namespace_, self.gds_format_string(quote_xml(self.customerNumber).encode(ExternalEncoding), input_name='customerNumber'), namespace_, eol_))
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespace_, self.gds_format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_, eol_))
        if self.familyName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfamilyName>%s</%sfamilyName>%s' % (namespace_, self.gds_format_string(quote_xml(self.familyName).encode(ExternalEncoding), input_name='familyName'), namespace_, eol_))
        if self.givenName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgivenName>%s</%sgivenName>%s' % (namespace_, self.gds_format_string(quote_xml(self.givenName).encode(ExternalEncoding), input_name='givenName'), namespace_, eol_))
        if self.roles is not None:
            self.roles.export(outfile, level, namespace_='tns:', name_='roles', pretty_print=pretty_print)
        if self.serviceGroups is not None:
            self.serviceGroups.export(outfile, level, namespace_='tns:', name_='serviceGroups', pretty_print=pretty_print)
        if self.tosAcceptDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stosAcceptDate>%s</%stosAcceptDate>%s' % (namespace_, self.gds_format_datetime(self.tosAcceptDate, input_name='tosAcceptDate'), namespace_, eol_))
        if self.tosAccepted is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stosAccepted>%s</%stosAccepted>%s' % (namespace_, self.gds_format_boolean(self.tosAccepted, input_name='tosAccepted'), namespace_, eol_))
        if self.userName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suserName>%s</%suserName>%s' % (namespace_, self.gds_format_string(quote_xml(self.userName).encode(ExternalEncoding), input_name='userName'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='user'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(user, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(user, self).exportLiteralChildren(outfile, level, name_)
        if self.companyId is not None:
            showIndent(outfile, level)
            outfile.write('companyId=%s,\n' % quote_python(self.companyId).encode(ExternalEncoding))
        if self.customerNumber is not None:
            showIndent(outfile, level)
            outfile.write('customerNumber=%s,\n' % quote_python(self.customerNumber).encode(ExternalEncoding))
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % quote_python(self.email).encode(ExternalEncoding))
        if self.familyName is not None:
            showIndent(outfile, level)
            outfile.write('familyName=%s,\n' % quote_python(self.familyName).encode(ExternalEncoding))
        if self.givenName is not None:
            showIndent(outfile, level)
            outfile.write('givenName=%s,\n' % quote_python(self.givenName).encode(ExternalEncoding))
        if self.roles is not None:
            showIndent(outfile, level)
            outfile.write('roles=model_.roles(\n')
            self.roles.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.serviceGroups is not None:
            showIndent(outfile, level)
            outfile.write('serviceGroups=model_.serviceGroups(\n')
            self.serviceGroups.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.tosAcceptDate is not None:
            showIndent(outfile, level)
            outfile.write('tosAcceptDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.tosAcceptDate, input_name='tosAcceptDate'))
        if self.tosAccepted is not None:
            showIndent(outfile, level)
            outfile.write('tosAccepted=%s,\n' % self.tosAccepted)
        if self.userName is not None:
            showIndent(outfile, level)
            outfile.write('userName=%s,\n' % quote_python(self.userName).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(user, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'companyId':
            companyId_ = child_.text
            companyId_ = self.gds_validate_string(companyId_, node, 'companyId')
            self.companyId = companyId_
        elif nodeName_ == 'customerNumber':
            customerNumber_ = child_.text
            customerNumber_ = self.gds_validate_string(customerNumber_, node, 'customerNumber')
            self.customerNumber = customerNumber_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'familyName':
            familyName_ = child_.text
            familyName_ = self.gds_validate_string(familyName_, node, 'familyName')
            self.familyName = familyName_
        elif nodeName_ == 'givenName':
            givenName_ = child_.text
            givenName_ = self.gds_validate_string(givenName_, node, 'givenName')
            self.givenName = givenName_
        elif nodeName_ == 'roles':
            obj_ = roles.factory()
            obj_.build(child_)
            self.roles = obj_
            obj_.original_tagname_ = 'roles'
        elif nodeName_ == 'serviceGroups':
            obj_ = serviceGroups.factory()
            obj_.build(child_)
            self.serviceGroups = obj_
            obj_.original_tagname_ = 'serviceGroups'
        elif nodeName_ == 'tosAcceptDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.tosAcceptDate = dval_
        elif nodeName_ == 'tosAccepted':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'tosAccepted')
            self.tosAccepted = ival_
        elif nodeName_ == 'userName':
            userName_ = child_.text
            userName_ = self.gds_validate_string(userName_, node, 'userName')
            self.userName = userName_
        super(user, self).buildChildren(child_, node, nodeName_, True)
# end class user


class membersInfo(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, member=None):
        self.original_tagname_ = None
        if member is None:
            self.member = []
        else:
            self.member = member
    def factory(*args_, **kwargs_):
        if membersInfo.subclass:
            return membersInfo.subclass(*args_, **kwargs_)
        else:
            return membersInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member_at(self, index, value): self.member.insert(index, value)
    def replace_member_at(self, index, value): self.member[index] = value
    def hasContent_(self):
        if (
            self.member
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='membersInfo', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='membersInfo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='membersInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='membersInfo'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='membersInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for member_ in self.member:
            member_.export(outfile, level, namespace_='tns:', name_='member', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='membersInfo'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.member(\n')
            member_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            class_obj_ = self.get_class_obj_(child_, memberinfo)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.member.append(obj_)
            obj_.original_tagname_ = 'member'
# end class membersInfo


class memberinfo(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, value=None, display=None, operation=None, extensiontype_=None):
        self.original_tagname_ = None
        self.value = value
        self.display = display
        self.operation = operation
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if memberinfo.subclass:
            return memberinfo.subclass(*args_, **kwargs_)
        else:
            return memberinfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_display(self): return self.display
    def set_display(self, display): self.display = display
    def get_operation(self): return self.operation
    def set_operation(self, operation): self.operation = operation
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.value is not None or
            self.display is not None or
            self.operation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='memberinfo', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='memberinfo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='memberinfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='memberinfo'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='memberinfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % ('tns:', self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), 'tns:', eol_))
        if self.display is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplay>%s</%sdisplay>%s' % (namespace_, self.gds_format_string(quote_xml(self.display).encode(ExternalEncoding), input_name='display'), namespace_, eol_))
        if self.operation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soperation>%s</%soperation>%s' % (namespace_, self.gds_format_string(quote_xml(self.operation).encode(ExternalEncoding), input_name='operation'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='memberinfo'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
        if self.display is not None:
            showIndent(outfile, level)
            outfile.write('display=%s,\n' % quote_python(self.display).encode(ExternalEncoding))
        if self.operation is not None:
            showIndent(outfile, level)
            outfile.write('operation=%s,\n' % quote_python(self.operation).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        elif nodeName_ == 'display':
            display_ = child_.text
            display_ = self.gds_validate_string(display_, node, 'display')
            self.display = display_
        elif nodeName_ == 'operation':
            operation_ = child_.text
            operation_ = self.gds_validate_string(operation_, node, 'operation')
            self.operation = operation_
# end class memberinfo


class metainfo(GeneratedsSuper):
    """5.7 Meta type that encapsulates the following information: created :
    Create time of the resource. modified : Last modified time of
    resource."""
    subclass = None
    superclass = None
    def __init__(self, created=None, modified=None):
        self.original_tagname_ = None
        if isinstance(created, basestring):
            initvalue_ = datetime_.datetime.strptime(created, '%Y-%m-%d').date()
        else:
            initvalue_ = created
        self.created = initvalue_
        if isinstance(modified, basestring):
            initvalue_ = datetime_.datetime.strptime(modified, '%Y-%m-%d').date()
        else:
            initvalue_ = modified
        self.modified = initvalue_
    def factory(*args_, **kwargs_):
        if metainfo.subclass:
            return metainfo.subclass(*args_, **kwargs_)
        else:
            return metainfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_created(self): return self.created
    def set_created(self, created): self.created = created
    def get_modified(self): return self.modified
    def set_modified(self, modified): self.modified = modified
    def hasContent_(self):
        if (
            self.created is not None or
            self.modified is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='metainfo', namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='metainfo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='metainfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='metainfo'):
        pass
    def exportChildren(self, outfile, level, namespace_='tns:', name_='metainfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.created is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screated>%s</%screated>%s' % (namespace_, self.gds_format_date(self.created, input_name='created'), namespace_, eol_))
        if self.modified is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodified>%s</%smodified>%s' % (namespace_, self.gds_format_date(self.modified, input_name='modified'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='metainfo'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.created is not None:
            showIndent(outfile, level)
            outfile.write('created=model_.GeneratedsSuper.gds_parse_date("%s"),\n' % self.gds_format_date(self.created, input_name='created'))
        if self.modified is not None:
            showIndent(outfile, level)
            outfile.write('modified=model_.GeneratedsSuper.gds_parse_date("%s"),\n' % self.gds_format_date(self.modified, input_name='modified'))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'created':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.created = dval_
        elif nodeName_ == 'modified':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.modified = dval_
# end class metainfo


class member(memberinfo):
    subclass = None
    superclass = memberinfo
    def __init__(self, value=None, display=None, operation=None, href=None):
        self.original_tagname_ = None
        super(member, self).__init__(value, display, operation, )
        self.href = _cast(None, href)
    def factory(*args_, **kwargs_):
        if member.subclass:
            return member.subclass(*args_, **kwargs_)
        else:
            return member(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def hasContent_(self):
        if (
            super(member, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='tns:', name_='member', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='member')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='tns:', name_='member', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='tns:', name_='member'):
        super(member, self).exportAttributes(outfile, level, already_processed, namespace_, name_='member')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
    def exportChildren(self, outfile, level, namespace_='tns:', name_='member', fromsubclass_=False, pretty_print=True):
        super(member, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='member'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        super(member, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(member, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        super(member, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(member, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class member


GDSClassesMapping = {
    'Users': userList,
    'rights': right,
    'member': memberinfo,
    'meta': metainfo,
    'User': user,
    'members': membersInfo,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'user'
        rootClass = user
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'user'
        rootClass = user
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'user'
        rootClass = user
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:tns="http://www.vmware.com/vchs/iam/v2.0"')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'user'
        rootClass = user
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from UserType import *\n\n')
        sys.stdout.write('import UserType as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "company",
    "member",
    "memberinfo",
    "membersInfo",
    "metainfo",
    "right",
    "role",
    "roles",
    "scimCore",
    "serviceGroup",
    "serviceGroups",
    "user",
    "userList"
]
