from setuptools import setup, find_packages  # Always prefer setuptools over distutils
from codecs import open  # To use a consistent encoding
from os import path
from version import Version

here = path.abspath(path.dirname(__file__))

# Get the long description from the relevant file
with open(path.join(here, 'README.rst'), encoding='utf-8') as f:
    long_description = f.read()

setup(
    name='pyversion',
    version=Version('pyversion'),
    description='Python package versioning made simple',
    long_description=long_description,
    url='https://github.com/rocktavious/pyversion',
    author='Kyle Rockman',
    author_email='kyle.rockman@mac.com',
    license='MIT',
    keywords='pyversion version versioning packaging',
    packages=find_packages(exclude=['contrib', 'docs', 'pyversion-tests']),
    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        #'Programming Language :: Python :: 3',
        #'Programming Language :: Python :: 3.2',
        #'Programming Language :: Python :: 3.3',
        #'Programming Language :: Python :: 3.4',
    ],
    entry_points={
        'distutils.commands': [
            'tag=version.tag_command:tag',
        ],
    },
)
