!    -*- F90 -*-
!
! AUTHOR  : ZHENFEI YUAN, TAIZHONG HU
! EMAIL   : ZFYUAN@MAIL.USTC.EDU.CN; THU@USTC.EDU.CN
! URL     : TAIZHONGLAB.USTC.EDU.CN/SOFTWARE/PYVINE.html
! DATE    : DEC 3, 2012
! LICENCE : GPL-V3
!
!
! THIS FILE CONSISTS OF ROUTINE FOR RANDOM SEED INITIALIZATION.
!
! LIST OF ROUTINE:
!
!   INIT_RANDOM_SEED



SUBROUTINE INIT_RANDOM_SEED()
  ! INITIAL RANDOM SEED FOR THE GFORTRAN INTRINSIC SUBROUTINE
  ! RANDOM_SEED.
  INTEGER::I,N,CLOCK
  INTEGER,DIMENSION(:),ALLOCATABLE::SEED

  CALL RANDOM_SEED(SIZE=N)
  ALLOCATE(SEED(N))

  CALL SYSTEM_CLOCK(COUNT=CLOCK)
  SEED=CLOCK+37*(/(I-1,I=1,N)/)
  CALL RANDOM_SEED(PUT=SEED)
  DEALLOCATE(SEED)

END SUBROUTINE INIT_RANDOM_SEED
