var LIVE_COOKIE_REGEX = /pywb.timestamp=([\d]{1,14})/;

var curr_state = {};


function make_outer_url(url, ts)
{
    if (ts) {
        return wbinfo.prefix + ts + "/" + url;
    } else {
        return wbinfo.prefix + url;
    }
}

function make_inner_url(url, ts)
{
    if (ts) {
        return wbinfo.prefix + ts + "mp_/" + url;
    } else {
        return wbinfo.prefix + "mp_/" + url;
    }
}

function push_state(url, timestamp, capture_str, is_live) {
    if (window.frames[0].WB_wombat_location) {
        curr_href = window.frames[0].WB_wombat_location.href;
        
        // If not current url, don't update    
        if (url != curr_href) {
            return;
        }
    }

    var state = {}
    state.timestamp = timestamp;
    state.outer_url = make_outer_url(url, state.timestamp);
    state.inner_url = make_inner_url(url, state.timestamp);
    state.url = url;
    state.capture_str = capture_str;
    state.is_live = is_live;
    
    window.history.replaceState(state, "", state.outer_url);

    set_state(state);
}

function pop_state(state) {
    set_state(state);
    
    window.frames[0].src = state.inner_url;
}

function extract_ts(url)
{
    var inx = url.indexOf("mp_");
    if (inx < 0) {
        return "";
    }
    url = url.substring(0, inx);
    inx = url.lastIndexOf("/");
    if (inx <= 0) {
        return "";
    }
    return url.substring(inx + 1);
}

function extract_replay_url(url) {
    var inx = url.indexOf("/http:");
    if (inx < 0) {
        inx = url.indexOf("/https:");
        if (inx < 0) {
            return "";
        }
    }
    return url.substring(inx + 1);
}

function set_state(state) {
    var capture_info = document.getElementById("_wb_capture_info");
    if (capture_info) {
        capture_info.innerHTML = state.capture_str;
    }

    var label = document.getElementById("_wb_label");
    if (label) {
        if (state.is_live) {
            label.innerHTML = _wb_js.labels.LIVE_MSG;
        } else {
            label.innerHTML = _wb_js.labels.REPLAY_MSG;
        }
    }

    curr_state = state;
}

window.onpopstate = function(event) {
    var state = event.state;
    
    if (state) {
        pop_state(state);
    }
}

function extract_ts_cookie(value) {
    var result = value.match(LIVE_COOKIE_REGEX);
    if (result) {
        return result[1];
    } else {
        return "";
    }
}

function iframe_loaded(event) {
    var url;
    var ts;
    var capture_str;
    var is_live = false;
    var iframe = window.frames[0];

    if (iframe.WB_wombat_location) {
        url = iframe.WB_wombat_location.href;
    } else {
        url = extract_replay_url(iframe.location.href);
    }

    if (iframe.wbinfo) {
        ts = iframe.wbinfo.timestamp;
        is_live = iframe.wbinfo.is_live;
    } else {
        ts = extract_ts_cookie(iframe.document.cookie);
        if (ts) {
            is_live = true;
        } else {
            ts = extract_ts(iframe.location.href);
        }
    }

    update_wb_url(url, ts, is_live);
}

function update_wb_url(url, ts, is_live) {
    if (curr_state.url == url && curr_state.timestamp == ts) {
        return;
    }

    capture_str = _wb_js.ts_to_date(ts, true);

    push_state(url, ts, capture_str, is_live);
}
