// Generated by CoffeeScript 1.6.2
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  define(['jquery', 'knockout', 'app/message'], function($, ko, Message) {
    var Node;

    return Node = (function() {
      function Node(ws, name) {
        this.ws = ws;
        this.name = name;
        this.follow_uptime = __bind(this.follow_uptime, this);
        this.provision = __bind(this.provision, this);
        this.execCmd = __bind(this.execCmd, this);
        this.is_online = ko.observable();
        this.last_seen = 0;
        this.highlighted = ko.observable();
        this.messages = ko.observableArray([]);
        this.follow_uptime();
      }

      Node.prototype.write_line = function(data) {
        var len, maxLen;

        len = this.messages().length;
        maxLen = 1000;
        if (len > maxLen) {
          this.messages().splice(0, len - maxLen);
        }
        this.messages.push(new Message(data));
        $('.messages').each(function() {
          return $(this).scrollTop($(this).find('ul').height());
        });
        return this.blink();
      };

      Node.prototype.blink = function() {
        var _this = this;

        this.highlighted(true);
        return setTimeout((function() {
          return _this.highlighted(false);
        }), 70);
      };

      Node.prototype.on_ws_message = function(data) {
        var cmd;

        cmd = data['cmd'];
        data = data['data'];
        if (cmd === 'up') {
          self.last_seen = new Date().getTime();
        } else if (cmd === 'log') {
          this.write_line(data);
        } else if (cmd === 'continue') {
          if (this.messages.length > 0) {
            this.messages[this.messages.length - 1].text += data;
          } else {
            this.write_line(data);
          }
        } else {
          this.write_line('Unknown command from server: ' + cmd);
        }
        this.last_seen = new Date().getTime();
        return this.is_online(true);
      };

      Node.prototype.send_msg = function(data) {
        return this.ws.send(JSON.stringify({
          host: this.name,
          msg: data
        }));
      };

      Node.prototype.execCmd = function(formElement) {
        var cmd, input;

        input = $(formElement).find('[name=text]');
        cmd = input.val();
        input.val('');
        if (cmd === 'cls') {
          this.messages.removeAll();
        } else {
          this.send_msg({
            'cmd': cmd
          });
        }
        return false;
      };

      Node.prototype.provision = function() {
        this.messages.removeAll();
        return this.send_msg({
          'cmd': 'date'
        });
      };

      Node.prototype.follow_uptime = function() {
        var time;

        if (this.ws.readyState !== WebSocket.OPEN) {
          $('#server-down-msg').show();
          this.is_online(false);
          this.last_seen = 0;
        }
        time = new Date().getTime();
        if (this.last_seen < (time - 3000)) {
          this.is_online(false);
        } else {
          this.last_seen = time;
          this.is_online(true);
        }
        return setTimeout(this.follow_uptime, 2000);
      };

      return Node;

    })();
  });

}).call(this);

/*
//@ sourceMappingURL=node.map
*/
