// Generated by CoffeeScript 1.6.2
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  define(['app/tab', 'app/node_', 'sammy', 'knockout'], function(Tab, Node, Sammy, ko) {
    var MessagesViewModel;

    return MessagesViewModel = (function() {
      function MessagesViewModel(ws, initial_nodes) {
        var node_name, tab, view, _i, _len;

        this.ws = ws;
        this.provision_all = __bind(this.provision_all, this);
        this.select_tab = __bind(this.select_tab, this);
        this.nodes = ko.observableArray([]);
        this.tabs = ko.observableArray([]);
        this.node_index = {};
        tab = new Tab('overview', 'Overview', null);
        tab.is_selected(true);
        this.tabs.push(tab);
        for (_i = 0, _len = initial_nodes.length; _i < _len; _i++) {
          node_name = initial_nodes[_i];
          this.register_node(node_name);
        }
        view = this;
        Sammy(function() {
          this.get('#:tab_id', function() {
            return view.switch_tab(this.params.tab_id);
          });
          return this.get('', function() {
            return this.app.runRoute('get', '#overview');
          });
        }).run();
      }

      MessagesViewModel.prototype.switch_tab = function(tab_id) {
        var tab, _i, _len, _ref, _results;

        _ref = this.tabs();
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          tab = _ref[_i];
          _results.push(tab.is_selected(tab.id === tab_id));
        }
        return _results;
      };

      MessagesViewModel.prototype.select_tab = function(selected_tab) {
        return location.hash = '#' + selected_tab.id;
      };

      MessagesViewModel.prototype.register_node = function(node_name) {
        var new_node;

        if (node_name in this.node_index) {
          return this.node_index[node_name];
        }
        new_node = new Node(this.ws, node_name);
        this.node_index[node_name] = new_node;
        this.nodes.push(new_node);
        this.tabs.push(new Tab(new_node.name, new_node.name, new_node));
        return new_node;
      };

      MessagesViewModel.prototype.provision_all = function() {
        var node, _i, _len, _ref, _results;

        _ref = this.nodes();
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          node = _ref[_i];
          _results.push(node.provision());
        }
        return _results;
      };

      MessagesViewModel.prototype.get_node = function(node_name) {
        if (!(node_name in this.node_index)) {
          return this.register_node(node_name);
        }
        return this.node_index[node_name];
      };

      return MessagesViewModel;

    })();
  });

}).call(this);

/*
//@ sourceMappingURL=view_model.map
*/
