/*
 * Decompiled with CFR 0.152.
 */
package org.odk.validate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilderFactory;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.utils.IPreloadHandler;
import org.javarosa.core.services.PrototypeManager;
import org.javarosa.form.api.FormEntryModel;
import org.javarosa.form.api.FormEntryPrompt;
import org.javarosa.model.xform.XFormsModule;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xform.util.XFormUtils;

public class FormValidator
implements ActionListener {
    public static final String[] SERIALIABLE_CLASSES = new String[]{"org.javarosa.core.services.locale.ResourceFileDataSource", "org.javarosa.core.services.locale.TableLocaleSource", "org.javarosa.core.model.FormDef", "org.javarosa.core.model.SubmissionProfile", "org.javarosa.core.model.QuestionDef", "org.javarosa.core.model.GroupDef", "org.javarosa.core.model.instance.FormInstance", "org.javarosa.core.model.data.BooleanData", "org.javarosa.core.model.data.DateData", "org.javarosa.core.model.data.DateTimeData", "org.javarosa.core.model.data.DecimalData", "org.javarosa.core.model.data.GeoPointData", "org.javarosa.core.model.data.IntegerData", "org.javarosa.core.model.data.LongData", "org.javarosa.core.model.data.MultiPointerAnswerData", "org.javarosa.core.model.data.PointerAnswerData", "org.javarosa.core.model.data.SelectMultiData", "org.javarosa.core.model.data.SelectOneData", "org.javarosa.core.model.data.StringData", "org.javarosa.core.model.data.TimeData", "org.javarosa.core.model.data.UncastData", "org.javarosa.core.model.data.helper.BasicDataPointer"};
    private final JFrame validatorFrame;
    private JTextField formPath;
    private JTextArea validatorOutput;
    private JButton chooseFileButton;
    private JButton validateButton;
    private JFileChooser fileChooser;
    private boolean inError = false;

    public static void main(String[] args) {
        if (args.length == 1) {
            String path = args[0];
            new FormValidator(path);
        } else {
            new FormValidator();
        }
    }

    public FormValidator(String path) {
        this.validatorFrame = null;
        this.formPath = null;
        this.chooseFileButton = null;
        this.validateButton = null;
        this.fileChooser = null;
        try {
            this.validate(path);
        }
        catch (Exception e) {
            System.err.println("\nException: " + e.toString());
            this.setError(true);
        }
        if (this.inError) {
            System.err.println("\nResult: Invalid");
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    private void setError(boolean outcome) {
        this.inError = outcome;
    }

    public FormValidator() {
        this.validatorFrame = new JFrame("ODK Validate 1.4 for ODK Collect v1.4 thru v1.2");
        JPanel validatorPanel = new JPanel();
        this.validatorFrame.setResizable(false);
        this.addWidgets(validatorPanel);
        System.setOut(new PrintStream(new JTextAreaOutputStream(this.validatorOutput)));
        System.setErr(new PrintStream(new JTextAreaOutputStream(this.validatorOutput)));
        this.validatorFrame.getContentPane().add((Component)validatorPanel, "Center");
        this.validatorFrame.setDefaultCloseOperation(3);
        this.validatorFrame.pack();
        this.validatorFrame.setVisible(true);
    }

    private void addWidgets(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.formPath = new JTextField(40);
        this.fileChooser = new JFileChooser();
        this.chooseFileButton = new JButton("Choose File...");
        this.chooseFileButton.addActionListener(this);
        this.validatorOutput = new JTextArea();
        this.validatorOutput.setEditable(false);
        this.validatorOutput.setLineWrap(true);
        this.validatorOutput.setFont(new Font("Monospaced", 0, 14));
        this.validatorOutput.setForeground(Color.BLACK);
        JScrollPane validatorOutputScrollPane = new JScrollPane(this.validatorOutput);
        validatorOutputScrollPane.setPreferredSize(new Dimension(800, 600));
        this.validateButton = new JButton("Validate Again");
        this.validateButton.addActionListener(this);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 7, 0, 0);
        panel.add((Component)this.formPath, c);
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(10, 0, 10, 7);
        panel.add((Component)this.chooseFileButton, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.insets = new Insets(0, 10, 10, 10);
        panel.add((Component)validatorOutputScrollPane, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        panel.add((Component)this.validateButton, c);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.validateButton) {
            this.setError(false);
            this.validatorOutput.setText("");
            this.validatorOutput.setForeground(Color.BLUE);
            this.validate(this.formPath.getText());
            this.validatorOutput.setForeground(this.inError ? Color.red : Color.BLUE);
        }
        if (e.getSource() == this.chooseFileButton) {
            int returnVal = this.fileChooser.showOpenDialog(this.validatorFrame);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.formPath.setText(file.getPath());
            }
            this.setError(false);
            this.validatorOutput.setText("");
            this.validatorOutput.setForeground(Color.BLUE);
            this.validate(this.formPath.getText());
            this.validatorOutput.setForeground(this.inError ? Color.red : Color.BLUE);
        }
    }

    boolean stepThroughEntireForm(FormEntryModel model) throws InvalidReferenceException {
        int event;
        boolean outcome = false;
        HashSet<String> loops = new HashSet<String>();
        FormIndex idx = FormIndex.createBeginningOfFormIndex();
        while ((event = model.getEvent(idx = model.incrementIndex(idx))) != 1) {
            FormEntryPrompt prompt;
            String elementPath;
            if (event == 2) {
                String elementPath2 = idx.getReference().toString().replaceAll("\\[\\d+\\]", "");
                if (loops.contains(elementPath2)) continue;
                loops.add(elementPath2);
                model.getForm().createNewRepeat(idx);
                idx = model.getFormIndex();
                continue;
            }
            if (event == 8) {
                GroupDef gd = (GroupDef)model.getForm().getChild(idx);
                if (gd.getChildren() != null && gd.getChildren().size() != 0) continue;
                outcome = true;
                this.setError(true);
                elementPath = idx.getReference().toString().replaceAll("\\[\\d+\\]", "");
                System.err.println("Group has no children! Group: " + elementPath + ". The XML is invalid.\n");
                continue;
            }
            if (event != 4 || (prompt = model.getQuestionPrompt(idx)).getControlType() != 3 && prompt.getControlType() != 2) continue;
            elementPath = idx.getReference().toString().replaceAll("\\[\\d+\\]", "");
            Vector items = prompt.getSelectChoices();
            int i = 0;
            while (i < items.size()) {
                SelectChoice s = (SelectChoice)items.get(i);
                String text = prompt.getSelectChoiceText(s);
                String image = prompt.getSpecialFormSelectChoiceText(s, "image");
                if (!(text != null && text.trim().length() != 0 || image != null && image.trim().length() != 0)) {
                    System.err.println("Selection choice label text and image uri are both missing for: " + elementPath + " choice: " + (i + 1) + ".\n");
                }
                if (s.getValue() == null || s.getValue().trim().length() == 0) {
                    outcome = true;
                    this.setError(true);
                    System.err.println("Selection value is missing for: " + elementPath + " choice: " + (i + 1) + ". The XML is invalid.\n");
                }
                ++i;
            }
        }
        return outcome;
    }

    void validate(String path) {
        FileInputStream fis;
        File src = new File(path);
        if (!src.exists()) {
            this.setError(true);
            System.err.println("File: " + src.getAbsolutePath() + " does not exist.");
            return;
        }
        try {
            fis = new FileInputStream(src);
        }
        catch (FileNotFoundException e) {
            this.setError(true);
            System.err.println("Please choose a file before attempting to validate.");
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            factory.newDocumentBuilder().parse(new File(path));
        }
        catch (Exception e) {
            this.setError(true);
            System.err.println("\n\n\n>> XML is invalid. See above for the errors.");
            return;
        }
        PrototypeManager.registerPrototypes((String[])SERIALIABLE_CLASSES);
        new XFormsModule().registerModule();
        try {
            FormDef fd = XFormUtils.getFormFromInputStream((InputStream)fis);
            if (fd == null) {
                this.setError(true);
                System.err.println("\n\n\n>> Something broke the parser. Try again.");
                return;
            }
            fd.getPreloader().addPreloadHandler((IPreloadHandler)new FakePreloadHandler("property"));
            fd.setEvaluationContext(new EvaluationContext(null));
            fd.initialize(true);
            System.out.println("\n\n>> Xform parsing completed! See above for any warnings.\n");
            FormEntryModel fem = new FormEntryModel(fd);
            if (this.stepThroughEntireForm(fem)) {
                this.setError(true);
                System.err.println("\n\n>> Xform is invalid! See above for errors and warnings.");
            } else {
                System.out.println("\n\n>> Xform is valid! See above for any warnings.");
            }
        }
        catch (XFormParseException e) {
            this.setError(true);
            System.err.println(e.toString());
            e.printStackTrace();
            System.err.println("\n\n>> XForm is invalid. See above for the errors.");
        }
        catch (Exception e) {
            this.setError(true);
            System.err.println(e.toString());
            e.printStackTrace();
            System.err.println("\n\n>> Something broke the parser. See above for a hint.");
        }
    }

    private class FakePreloadHandler
    implements IPreloadHandler {
        String preloadHandled;

        public FakePreloadHandler(String preloadHandled) {
            this.preloadHandled = preloadHandled;
        }

        public boolean handlePostProcess(TreeElement arg0, String arg1) {
            return false;
        }

        public IAnswerData handlePreload(String arg0) {
            return null;
        }

        public String preloadHandled() {
            return this.preloadHandled;
        }
    }

    class JTextAreaOutputStream
    extends OutputStream {
        private final JTextArea textArea;

        public JTextAreaOutputStream(JTextArea textArea) {
            this.textArea = textArea;
        }

        public void write(int b) {
            this.textArea.append(new String(new byte[]{(byte)(b % 256)}, 0, 1));
        }
    }
}

