/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.log;

import org.javarosa.core.log.FatalException;

public class WrappedException
extends RuntimeException {
    String message;
    Exception child;

    public WrappedException(String string) {
        this(string, null);
    }

    public WrappedException(Exception exception) {
        this(null, exception);
    }

    public WrappedException(String string, Exception exception) {
        super(WrappedException.constructMessage(string, exception));
        this.message = string;
        this.child = exception;
    }

    public static String constructMessage(String string, Exception exception) {
        String string2 = "";
        if (string != null) {
            string2 = string2 + string;
        }
        if (exception != null) {
            string2 = string2 + (string != null ? " => " : "") + WrappedException.printException(exception);
        }
        if (string2.equals("")) {
            string2 = "[exception]";
        }
        return string2;
    }

    public static String printException(Exception exception) {
        if (exception instanceof WrappedException) {
            return (exception instanceof FatalException ? "FATAL: " : "") + exception.getMessage();
        }
        return exception.getClass().getName() + "[" + exception.getMessage() + "]";
    }
}

