/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.javarosa.core.log.WrappedException;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.SubmissionProfile;
import org.javarosa.core.model.condition.Condition;
import org.javarosa.core.model.condition.Constraint;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.IFunctionHandler;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.SelectMultiData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.model.utils.QuestionPreloader;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.services.storage.IMetaData;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.model.xform.XPathReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDef
implements IFormElement,
Localizable,
Persistable,
IMetaData {
    public static final String STORAGE_KEY = "FORMDEF";
    public static final int TEMPLATING_RECURSION_LIMIT = 10;
    private Vector children;
    private int id;
    private String title;
    private String name;
    private Localizer localizer;
    public Vector triggerables;
    private boolean triggerablesInOrder;
    private FormInstance instance;
    private Vector outputFragments;
    public Hashtable triggerIndex;
    private Hashtable conditionRepeatTargetIndex;
    public EvaluationContext exprEvalContext;
    private QuestionPreloader preloader = new QuestionPreloader();
    private static String DEFAULT_SUBMISSION_PROFILE = "1";
    private Hashtable<String, SubmissionProfile> submissionProfiles;

    public FormDef() {
        this.setID(-1);
        this.setChildren(null);
        this.triggerables = new Vector();
        this.triggerablesInOrder = true;
        this.triggerIndex = new Hashtable();
        this.setEvaluationContext(new EvaluationContext());
        this.outputFragments = new Vector();
        this.submissionProfiles = new Hashtable();
    }

    @Override
    public void addChild(IFormElement iFormElement) {
        this.children.addElement(iFormElement);
    }

    @Override
    public IFormElement getChild(int n) {
        if (n < this.children.size()) {
            return (IFormElement)this.children.elementAt(n);
        }
        throw new ArrayIndexOutOfBoundsException("FormDef: invalid child index: " + n + " only " + this.children.size() + " children");
    }

    public IFormElement getChild(FormIndex formIndex) {
        IFormElement iFormElement = this;
        while (formIndex != null && formIndex.isInForm()) {
            iFormElement = iFormElement.getChild(formIndex.getLocalIndex());
            formIndex = formIndex.getNextLevel();
        }
        return iFormElement;
    }

    public Vector explodeIndex(FormIndex formIndex) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        this.collapseIndex(formIndex, vector, vector2, vector3);
        return vector3;
    }

    public TreeReference getChildInstanceRef(FormIndex formIndex) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        this.collapseIndex(formIndex, vector, vector2, vector3);
        return this.getChildInstanceRef(vector3, vector2);
    }

    public TreeReference getChildInstanceRef(Vector vector, Vector vector2) {
        int n;
        if (vector.size() == 0) {
            return null;
        }
        TreeReference treeReference = FormInstance.unpackReference(((IFormElement)vector.lastElement()).getBind()).clone();
        for (n = 0; n < treeReference.size(); ++n) {
            if (treeReference.getMultiplicity(n) == -4) continue;
            treeReference.setMultiplicity(n, 0);
        }
        for (n = 0; n < vector.size(); ++n) {
            IFormElement iFormElement = (IFormElement)vector.elementAt(n);
            if (!(iFormElement instanceof GroupDef) || !((GroupDef)iFormElement).getRepeat()) continue;
            TreeReference treeReference2 = FormInstance.unpackReference(iFormElement.getBind());
            if (treeReference2.isParentOf(treeReference, false)) {
                int n2 = (Integer)vector2.elementAt(n);
                treeReference.setMultiplicity(treeReference2.size() - 1, n2);
                continue;
            }
            return null;
        }
        return treeReference;
    }

    public void setLocalizer(Localizer localizer) {
        if (this.localizer != null) {
            this.localizer.unregisterLocalizable(this);
        }
        this.localizer = localizer;
        if (this.localizer != null) {
            this.localizer.registerLocalizable(this);
        }
    }

    @Override
    public IDataReference getBind() {
        throw new RuntimeException("method not implemented");
    }

    public void setValue(IAnswerData iAnswerData, TreeReference treeReference) {
        this.setValue(iAnswerData, treeReference, this.instance.resolveReference(treeReference));
    }

    public void setValue(IAnswerData iAnswerData, TreeReference treeReference, TreeElement treeElement) {
        this.setAnswer(iAnswerData, treeElement);
        this.triggerTriggerables(treeReference);
    }

    public void setAnswer(IAnswerData iAnswerData, TreeReference treeReference) {
        this.setAnswer(iAnswerData, this.instance.resolveReference(treeReference));
    }

    public void setAnswer(IAnswerData iAnswerData, TreeElement treeElement) {
        treeElement.setAnswer(iAnswerData);
    }

    public FormIndex deleteRepeat(FormIndex formIndex) {
        Externalizable externalizable;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        this.collapseIndex(formIndex, vector, vector2, vector3);
        for (int i = vector3.size() - 1; !(i < 0 || (externalizable = (IFormElement)vector3.elementAt(i)) instanceof GroupDef && ((GroupDef)externalizable).getRepeat()); --i) {
            vector.removeElementAt(i);
            vector2.removeElementAt(i);
            vector3.removeElementAt(i);
        }
        FormIndex formIndex2 = this.buildIndex(vector, vector2, vector3);
        externalizable = this.getChildInstanceRef(formIndex2);
        TreeElement treeElement = this.instance.resolveReference((TreeReference)externalizable);
        TreeReference treeReference = ((TreeReference)externalizable).getParentRef();
        TreeElement treeElement2 = this.instance.resolveReference(treeReference);
        int n = treeElement.getMult();
        treeElement2.removeChild(treeElement);
        for (int i = 0; i < treeElement2.getNumChildren(); ++i) {
            TreeElement treeElement3 = treeElement2.getChildAt(i);
            if (treeElement3.getMult() <= n) continue;
            treeElement3.setMult(treeElement3.getMult() - 1);
        }
        this.triggerTriggerables((TreeReference)externalizable);
        return formIndex2;
    }

    public void createNewRepeat(FormIndex formIndex) throws InvalidReferenceException {
        TreeReference treeReference = this.getChildInstanceRef(formIndex);
        TreeElement treeElement = this.instance.getTemplate(treeReference);
        this.instance.copyNode(treeElement, treeReference);
        this.preloadInstance(this.instance.resolveReference(treeReference));
        this.triggerTriggerables(treeReference);
        this.initializeTriggerables(treeReference);
    }

    public boolean isRepeatRelevant(TreeReference treeReference) {
        boolean bl = true;
        Condition condition = (Condition)this.conditionRepeatTargetIndex.get(treeReference.genericize());
        if (condition != null) {
            bl = condition.evalBool(this.instance, new EvaluationContext(this.exprEvalContext, treeReference));
        }
        if (bl) {
            TreeElement treeElement = this.instance.getTemplate(treeReference);
            TreeReference treeReference2 = treeElement.getParent().getRef().genericize();
            TreeElement treeElement2 = this.instance.resolveReference(treeReference2.contextualize(treeReference));
            bl = treeElement2.isRelevant();
        }
        return bl;
    }

    public boolean canCreateRepeat(TreeReference treeReference) {
        return true;
    }

    public void copyItemsetAnswer(QuestionDef questionDef, TreeElement treeElement, IAnswerData iAnswerData) throws InvalidReferenceException {
        Object object;
        Externalizable externalizable;
        int n;
        ItemsetBinding itemsetBinding = questionDef.getDynamicChoices();
        TreeReference treeReference = treeElement.getRef();
        TreeReference treeReference2 = itemsetBinding.getDestRef().contextualize(treeReference);
        Vector<Selection> vector = null;
        Vector<String> vector2 = new Vector<String>();
        if (iAnswerData instanceof SelectMultiData) {
            vector = (Vector<Selection>)iAnswerData.getValue();
        } else if (iAnswerData instanceof SelectOneData) {
            vector = new Vector<Selection>();
            vector.addElement((Selection)iAnswerData.getValue());
        }
        if (itemsetBinding.valueRef != null) {
            for (int i = 0; i < vector.size(); ++i) {
                vector2.addElement(((Selection)vector.elementAt((int)i)).choice.getValue());
            }
        }
        Hashtable<Object, Externalizable> hashtable = new Hashtable<Object, Externalizable>();
        Vector vector3 = this.getInstance().expandReference(treeReference2);
        for (n = 0; n < vector3.size(); ++n) {
            externalizable = this.getInstance().resolveReference((TreeReference)vector3.elementAt(n));
            if (itemsetBinding.valueRef != null && vector2.contains(object = itemsetBinding.getRelativeValue().evalReadable(this.getInstance(), new EvaluationContext(this.exprEvalContext, ((TreeElement)externalizable).getRef())))) {
                hashtable.put(object, externalizable);
            }
            treeElement.removeChild((TreeElement)externalizable);
        }
        for (n = 0; n < vector.size(); ++n) {
            String string;
            externalizable = (Selection)vector.elementAt(n);
            object = ((Selection)externalizable).choice;
            TreeElement treeElement2 = null;
            if (itemsetBinding.valueRef != null && hashtable.containsKey(string = ((SelectChoice)object).getValue())) {
                treeElement2 = (TreeElement)hashtable.get(string);
            }
            if (treeElement2 != null) {
                treeElement2.setMult(n);
                treeElement.addChild(treeElement2);
                continue;
            }
            this.getInstance().copyItemsetNode(((SelectChoice)object).copyNode, treeReference2, this);
        }
        this.triggerTriggerables(treeReference2);
        this.initializeTriggerables(treeReference2);
    }

    public Triggerable addTriggerable(Triggerable triggerable) {
        int n = this.triggerables.indexOf(triggerable);
        if (n >= 0) {
            return (Triggerable)this.triggerables.elementAt(n);
        }
        this.triggerables.addElement(triggerable);
        this.triggerablesInOrder = false;
        Vector vector = triggerable.getTriggers();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2;
            TreeReference treeReference = (TreeReference)vector.elementAt(i);
            if (!this.triggerIndex.containsKey(treeReference)) {
                this.triggerIndex.put(treeReference, new Vector());
            }
            if ((vector2 = (Vector)this.triggerIndex.get(treeReference)).contains(triggerable)) continue;
            vector2.addElement(triggerable);
        }
        return triggerable;
    }

    public void finalizeTriggerables() {
        Object object;
        Vector<Triggerable[]> vector = new Vector<Triggerable[]>();
        for (int i = 0; i < this.triggerables.size(); ++i) {
            Externalizable externalizable;
            int n;
            Triggerable triggerable = (Triggerable)this.triggerables.elementAt(i);
            Vector<Triggerable> vector2 = new Vector<Triggerable>();
            if (triggerable.canCascade()) {
                for (n = 0; n < triggerable.getTargets().size(); ++n) {
                    externalizable = (TreeReference)triggerable.getTargets().elementAt(n);
                    object = (Triggerable[])this.triggerIndex.get(externalizable);
                    if (object == null) continue;
                    for (int j = 0; j < object.size(); ++j) {
                        Triggerable triggerable2 = (Triggerable)object.elementAt(j);
                        if (vector2.contains(triggerable2)) continue;
                        vector2.addElement(triggerable2);
                    }
                }
            }
            for (n = 0; n < vector2.size(); ++n) {
                externalizable = (Triggerable)vector2.elementAt(n);
                object = new Triggerable[]{triggerable, externalizable};
                vector.addElement((Triggerable[])object);
            }
        }
        Vector vector3 = new Vector();
        for (int i = 0; i < this.triggerables.size(); ++i) {
            vector3.addElement(this.triggerables.elementAt(i));
        }
        this.triggerables.removeAllElements();
        while (vector3.size() > 0) {
            Object object2;
            int n;
            Vector vector4 = new Vector();
            for (n = 0; n < vector3.size(); ++n) {
                vector4.addElement(vector3.elementAt(n));
            }
            for (n = 0; n < vector.size(); ++n) {
                object2 = (Triggerable[])vector.elementAt(n);
                vector4.removeElement(object2[1]);
            }
            if (vector4.size() == 0) {
                throw new RuntimeException("Cannot create partial ordering of triggerables due to dependency cycle. Why wasn't this caught during parsing?");
            }
            for (n = 0; n < vector4.size(); ++n) {
                object2 = (Triggerable)vector4.elementAt(n);
                this.triggerables.addElement(object2);
                vector3.removeElement(object2);
            }
            for (n = vector.size() - 1; n >= 0; --n) {
                object2 = (Triggerable[])vector.elementAt(n);
                if (!vector4.contains(object2[0])) continue;
                vector.removeElementAt(n);
            }
        }
        this.triggerablesInOrder = true;
        this.conditionRepeatTargetIndex = new Hashtable();
        for (int i = 0; i < this.triggerables.size(); ++i) {
            Triggerable triggerable = (Triggerable)this.triggerables.elementAt(i);
            if (!(triggerable instanceof Condition)) continue;
            Vector vector5 = triggerable.getTargets();
            for (int j = 0; j < vector5.size(); ++j) {
                object = (TreeReference)vector5.elementAt(j);
                if (this.instance.getTemplate((TreeReference)object) == null) continue;
                this.conditionRepeatTargetIndex.put(object, (Condition)triggerable);
            }
        }
    }

    public void initializeTriggerables() {
        this.initializeTriggerables(TreeReference.rootRef());
    }

    private void initializeTriggerables(TreeReference treeReference) {
        TreeReference treeReference2 = treeReference.genericize();
        Vector<Triggerable> vector = new Vector<Triggerable>();
        block0: for (int i = 0; i < this.triggerables.size(); ++i) {
            Triggerable triggerable = (Triggerable)this.triggerables.elementAt(i);
            for (int j = 0; j < triggerable.getTargets().size(); ++j) {
                TreeReference treeReference3 = (TreeReference)triggerable.getTargets().elementAt(j);
                if (!treeReference2.isParentOf(treeReference3, false)) continue;
                vector.addElement(triggerable);
                continue block0;
            }
        }
        this.evaluateTriggerables(vector, treeReference);
    }

    public void triggerTriggerables(TreeReference treeReference) {
        TreeReference treeReference2 = treeReference.genericize();
        Vector vector = (Vector)this.triggerIndex.get(treeReference2);
        if (vector == null) {
            return;
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(vector.elementAt(i));
        }
        this.evaluateTriggerables(vector2, treeReference);
    }

    private void evaluateTriggerables(Vector vector, TreeReference treeReference) {
        Triggerable triggerable;
        int n;
        for (n = 0; n < vector.size(); ++n) {
            triggerable = (Triggerable)vector.elementAt(n);
            if (!triggerable.canCascade()) continue;
            for (int i = 0; i < triggerable.getTargets().size(); ++i) {
                TreeReference treeReference2 = (TreeReference)triggerable.getTargets().elementAt(i);
                Vector vector2 = (Vector)this.triggerIndex.get(treeReference2);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    Triggerable triggerable2 = (Triggerable)vector2.elementAt(j);
                    if (vector.contains(triggerable2)) continue;
                    vector.addElement(triggerable2);
                }
            }
        }
        for (n = 0; n < this.triggerables.size(); ++n) {
            triggerable = (Triggerable)this.triggerables.elementAt(n);
            if (!vector.contains(triggerable)) continue;
            this.evaluateTriggerable(triggerable, treeReference);
        }
    }

    private void evaluateTriggerable(Triggerable triggerable, TreeReference treeReference) {
        TreeReference treeReference2 = triggerable.contextRef.contextualize(treeReference);
        Vector vector = this.instance.expandReference(treeReference2);
        for (int i = 0; i < vector.size(); ++i) {
            EvaluationContext evaluationContext = new EvaluationContext(this.exprEvalContext, (TreeReference)vector.elementAt(i));
            triggerable.apply(this.instance, evaluationContext, this);
        }
    }

    public boolean evaluateConstraint(TreeReference treeReference, IAnswerData iAnswerData) {
        if (iAnswerData == null) {
            return true;
        }
        TreeElement treeElement = this.instance.resolveReference(treeReference);
        Constraint constraint = treeElement.getConstraint();
        if (constraint == null) {
            return true;
        }
        EvaluationContext evaluationContext = new EvaluationContext(this.exprEvalContext, treeReference);
        evaluationContext.isConstraint = true;
        evaluationContext.candidateValue = iAnswerData;
        return constraint.constraint.eval(this.instance, evaluationContext);
    }

    public void setEvaluationContext(EvaluationContext evaluationContext) {
        this.initEvalContext(evaluationContext);
        this.exprEvalContext = evaluationContext;
    }

    private void initEvalContext(EvaluationContext evaluationContext) {
        FormDef formDef;
        if (!evaluationContext.getFunctionHandlers().containsKey("jr:itext")) {
            formDef = this;
            evaluationContext.addFunctionHandler(new IFunctionHandler(){

                public String getName() {
                    return "jr:itext";
                }

                public Object eval(Object[] objectArray) {
                    String string = (String)objectArray[0];
                    try {
                        String string2 = formDef.getLocalizer().getText(string);
                        return string2 == null ? "[itext:" + string + "]" : string2;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        return "[nolocale]";
                    }
                }

                public Vector getPrototypes() {
                    Class[] classArray = new Class[]{String.class};
                    Vector<Class[]> vector = new Vector<Class[]>();
                    vector.addElement(classArray);
                    return vector;
                }

                public boolean rawArgs() {
                    return false;
                }

                public boolean realTime() {
                    return false;
                }
            });
        }
        if (!evaluationContext.getFunctionHandlers().containsKey("jr:choice-name")) {
            formDef = this;
            evaluationContext.addFunctionHandler(new IFunctionHandler(){

                public String getName() {
                    return "jr:choice-name";
                }

                public Object eval(Object[] objectArray) {
                    try {
                        String string = (String)objectArray[0];
                        String string2 = (String)objectArray[1];
                        TreeReference treeReference = RestoreUtils.xfFact.ref(string2);
                        QuestionDef questionDef = FormDef.findQuestionByRef(treeReference, formDef);
                        if (questionDef == null || questionDef.getControlType() != 2 && questionDef.getControlType() != 3) {
                            return "";
                        }
                        System.out.println("here!!");
                        Vector<SelectChoice> vector = questionDef.getChoices();
                        for (SelectChoice selectChoice : vector) {
                            if (!selectChoice.getValue().equals(string)) continue;
                            String string3 = selectChoice.getTextID();
                            if (string3 != null) {
                                return formDef.getLocalizer().getText(string3);
                            }
                            return selectChoice.getLabelInnerText();
                        }
                        return "";
                    }
                    catch (Exception exception) {
                        throw new WrappedException("error in evaluation of xpath function [choice-name]", exception);
                    }
                }

                public Vector getPrototypes() {
                    Class[] classArray = new Class[]{String.class, String.class};
                    Vector<Class[]> vector = new Vector<Class[]>();
                    vector.addElement(classArray);
                    return vector;
                }

                public boolean rawArgs() {
                    return false;
                }

                public boolean realTime() {
                    return false;
                }
            });
        }
    }

    public String fillTemplateString(String string, TreeReference treeReference) {
        return this.fillTemplateString(string, treeReference, new Hashtable());
    }

    public String fillTemplateString(String string, TreeReference treeReference, Hashtable<String, ?> hashtable) {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        int n = 0;
        Vector vector = Localizer.getArgs(string);
        while (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                if (hashtable2.containsKey(string2)) continue;
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Warning: expect arguments to be numeric [" + string2 + "]");
                }
                if (n2 < 0 || n2 >= this.outputFragments.size()) continue;
                IConditionExpr iConditionExpr = (IConditionExpr)this.outputFragments.elementAt(n2);
                EvaluationContext evaluationContext = new EvaluationContext(this.exprEvalContext, treeReference);
                evaluationContext.setVariables(hashtable);
                String string3 = iConditionExpr.evalReadable(this.getInstance(), evaluationContext);
                hashtable2.put(string2, string3);
            }
            string = Localizer.processArguments(string, hashtable2);
            vector = Localizer.getArgs(string);
            if (++n < 10) continue;
            throw new RuntimeException("Dependency cycle in <output>s; recursion limit exceeded!!");
        }
        return string;
    }

    public void populateDynamicChoices(ItemsetBinding itemsetBinding, TreeReference treeReference) {
        Vector<SelectChoice> vector = new Vector<SelectChoice>();
        Vector vector2 = itemsetBinding.nodesetExpr.evalNodeset(this.getInstance(), new EvaluationContext(this.exprEvalContext, itemsetBinding.contextRef.contextualize(treeReference)));
        for (int i = 0; i < vector2.size(); ++i) {
            TreeReference treeReference2 = (TreeReference)vector2.elementAt(i);
            String string = itemsetBinding.labelExpr.evalReadable(this.getInstance(), new EvaluationContext(this.exprEvalContext, treeReference2));
            String string2 = null;
            TreeElement treeElement = null;
            if (itemsetBinding.copyMode) {
                treeElement = this.getInstance().resolveReference(itemsetBinding.copyRef.contextualize(treeReference2));
            }
            if (itemsetBinding.valueRef != null) {
                string2 = itemsetBinding.valueExpr.evalReadable(this.getInstance(), new EvaluationContext(this.exprEvalContext, treeReference2));
            }
            SelectChoice selectChoice = new SelectChoice(string, string2 != null ? string2 : "dynamic:" + i, itemsetBinding.labelIsItext);
            selectChoice.setIndex(i);
            if (itemsetBinding.copyMode) {
                selectChoice.copyNode = treeElement;
            }
            vector.addElement(selectChoice);
        }
        if (vector.size() == 0) {
            throw new RuntimeException("dynamic select question has no choices! [" + itemsetBinding.nodesetRef + "]");
        }
        itemsetBinding.setChoices(vector, this.getLocalizer());
    }

    public QuestionPreloader getPreloader() {
        return this.preloader;
    }

    public void setPreloader(QuestionPreloader questionPreloader) {
        this.preloader = questionPreloader;
    }

    @Override
    public void localeChanged(String string, Localizer localizer) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ((IFormElement)enumeration.nextElement()).localeChanged(string, localizer);
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public void preloadInstance(TreeElement treeElement) {
        IAnswerData iAnswerData = null;
        if (treeElement.getPreloadHandler() != null) {
            iAnswerData = this.preloader.getQuestionPreload(treeElement.getPreloadHandler(), treeElement.getPreloadParams());
        }
        if (iAnswerData != null) {
            treeElement.setAnswer(iAnswerData);
        }
        if (!treeElement.isLeaf()) {
            for (int i = 0; i < treeElement.getNumChildren(); ++i) {
                TreeElement treeElement2 = treeElement.getChildAt(i);
                if (treeElement2.getMult() == -2) continue;
                this.preloadInstance(treeElement2);
            }
        }
    }

    public boolean postProcessInstance() {
        return this.postProcessInstance(this.instance.getRoot());
    }

    private boolean postProcessInstance(TreeElement treeElement) {
        if (treeElement.isLeaf()) {
            if (treeElement.getPreloadHandler() != null) {
                return this.preloader.questionPostProcess(treeElement, treeElement.getPreloadHandler(), treeElement.getPreloadParams());
            }
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < treeElement.getNumChildren(); ++i) {
            TreeElement treeElement2 = treeElement.getChildAt(i);
            if (treeElement2.getMult() == -2) continue;
            bl |= this.postProcessInstance(treeElement2);
        }
        return bl;
    }

    @Override
    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.setID(ExtUtil.readInt(dataInputStream));
        this.setName(ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream)));
        this.setTitle((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        this.setChildren((Vector)ExtUtil.read(dataInputStream, new ExtWrapListPoly(), prototypeFactory));
        this.setInstance((FormInstance)ExtUtil.read(dataInputStream, FormInstance.class, prototypeFactory));
        this.setLocalizer((Localizer)ExtUtil.read(dataInputStream, new ExtWrapNullable(Localizer.class), prototypeFactory));
        Vector vector = (Vector)ExtUtil.read(dataInputStream, new ExtWrapList(Condition.class), prototypeFactory);
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            this.addTriggerable((Condition)object.nextElement());
        }
        object = (Vector)ExtUtil.read(dataInputStream, new ExtWrapList(Recalculate.class), prototypeFactory);
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            this.addTriggerable((Recalculate)enumeration.nextElement());
        }
        this.finalizeTriggerables();
        this.outputFragments = (Vector)ExtUtil.read(dataInputStream, new ExtWrapListPoly(), prototypeFactory);
        this.submissionProfiles = (Hashtable)ExtUtil.read(dataInputStream, new ExtWrapMap(String.class, SubmissionProfile.class));
    }

    public void initialize(boolean bl) {
        if (bl) {
            this.preloadInstance(this.instance.getRoot());
        }
        this.initializeTriggerables();
        if (this.getLocalizer() != null && this.getLocalizer().getLocale() == null) {
            this.getLocalizer().setToDefault();
        }
    }

    @Override
    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.getID());
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.getName()));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.getTitle()));
        ExtUtil.write(dataOutputStream, new ExtWrapListPoly(this.getChildren()));
        ExtUtil.write(dataOutputStream, this.instance);
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.localizer));
        Vector<Triggerable> vector = new Vector<Triggerable>();
        Vector<Triggerable> vector2 = new Vector<Triggerable>();
        for (int i = 0; i < this.triggerables.size(); ++i) {
            Triggerable triggerable = (Triggerable)this.triggerables.elementAt(i);
            if (triggerable instanceof Condition) {
                vector.addElement(triggerable);
                continue;
            }
            if (!(triggerable instanceof Recalculate)) continue;
            vector2.addElement(triggerable);
        }
        ExtUtil.write(dataOutputStream, new ExtWrapList(vector));
        ExtUtil.write(dataOutputStream, new ExtWrapList(vector2));
        ExtUtil.write(dataOutputStream, new ExtWrapListPoly(this.outputFragments));
        ExtUtil.write(dataOutputStream, new ExtWrapMap(this.submissionProfiles));
    }

    public void collapseIndex(FormIndex formIndex, Vector vector, Vector vector2, Vector vector3) {
        if (!formIndex.isInForm()) {
            return;
        }
        IFormElement iFormElement = this;
        while (formIndex != null) {
            int n = formIndex.getLocalIndex();
            iFormElement = iFormElement.getChild(n);
            vector.addElement(new Integer(n));
            vector2.addElement(new Integer(formIndex.getInstanceIndex() == -1 ? 0 : formIndex.getInstanceIndex()));
            vector3.addElement(iFormElement);
            formIndex = formIndex.getNextLevel();
        }
    }

    public FormIndex buildIndex(Vector vector, Vector vector2, Vector vector3) {
        int n;
        FormIndex formIndex = null;
        Vector vector4 = new Vector();
        for (int i = 0; i < vector2.size(); ++i) {
            vector4.addElement(vector2.elementAt(i));
        }
        Vector vector5 = new Vector();
        for (n = 0; n < vector3.size(); ++n) {
            vector5.addElement(vector3.elementAt(n));
        }
        for (n = vector.size() - 1; n >= 0; --n) {
            int n2 = (Integer)vector.elementAt(n);
            int n3 = (Integer)vector2.elementAt(n);
            TreeReference treeReference = (TreeReference)((XPathReference)((IFormElement)vector3.elementAt(n)).getBind()).getReference();
            if (!(vector3.elementAt(n) instanceof GroupDef) || !((GroupDef)vector3.elementAt(n)).getRepeat()) {
                n3 = -1;
            }
            formIndex = new FormIndex(formIndex, n2, n3, this.getChildInstanceRef(vector5, vector4));
            vector4.removeElementAt(vector4.size() - 1);
            vector5.removeElementAt(vector5.size() - 1);
        }
        return formIndex;
    }

    public int getNumRepetitions(FormIndex formIndex) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        if (!formIndex.isInForm()) {
            throw new RuntimeException("not an in-form index");
        }
        this.collapseIndex(formIndex, vector, vector2, vector3);
        if (!(vector3.lastElement() instanceof GroupDef) || !((GroupDef)vector3.lastElement()).getRepeat()) {
            throw new RuntimeException("current element not a repeat");
        }
        TreeElement treeElement = this.instance.getTemplate(formIndex.getReference());
        TreeReference treeReference = treeElement.getParent().getRef().genericize();
        TreeElement treeElement2 = this.instance.resolveReference(treeReference.contextualize(formIndex.getReference()));
        return treeElement2.getChildMultiplicity(treeElement.getName());
    }

    public FormIndex descendIntoRepeat(FormIndex formIndex, int n) {
        int n2 = this.getNumRepetitions(formIndex);
        Vector vector = new Vector();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector vector3 = new Vector();
        this.collapseIndex(formIndex, vector, vector2, vector3);
        if (n == -1) {
            n = n2;
        } else if (n < 0 || n >= n2) {
            throw new RuntimeException("selection exceeds current number of repetitions");
        }
        vector2.setElementAt(new Integer(n), vector2.size() - 1);
        return this.buildIndex(vector, vector2, vector3);
    }

    @Override
    public int getDeepChildCount() {
        int n = 0;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            n += ((IFormElement)enumeration.nextElement()).getDeepChildCount();
        }
        return n;
    }

    @Override
    public void registerStateObserver(FormElementStateListener formElementStateListener) {
    }

    @Override
    public void unregisterStateObserver(FormElementStateListener formElementStateListener) {
    }

    @Override
    public Vector getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Vector vector) {
        this.children = vector == null ? new Vector() : vector;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int n) {
        this.id = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Localizer getLocalizer() {
        return this.localizer;
    }

    public FormInstance getInstance() {
        return this.instance;
    }

    public void setInstance(FormInstance formInstance) {
        if (formInstance.getFormId() != -1 && this.getID() != formInstance.getFormId()) {
            System.err.println("Warning: assigning incompatible instance (type " + formInstance.getFormId() + ") to a formdef (type " + this.getID() + ")");
        }
        formInstance.setFormId(this.getID());
        this.instance = formInstance;
        this.attachControlsToInstanceData();
    }

    public Vector getOutputFragments() {
        return this.outputFragments;
    }

    public void setOutputFragments(Vector vector) {
        this.outputFragments = vector;
    }

    @Override
    public Hashtable getMetaData() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String[] stringArray = this.getMetaDataFields();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                hashtable.put(stringArray[i], this.getMetaData(stringArray[i]));
                continue;
            }
            catch (NullPointerException nullPointerException) {
                if (this.getMetaData(stringArray[i]) != null) continue;
                System.out.println("ERROR! XFORM MUST HAVE A NAME!");
                nullPointerException.printStackTrace();
            }
        }
        return hashtable;
    }

    @Override
    public Object getMetaData(String string) {
        if (string.equals("DESCRIPTOR")) {
            return this.name;
        }
        if (string.equals("XMLNS")) {
            return ExtUtil.emptyIfNull(this.instance.schema);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String[] getMetaDataFields() {
        return new String[]{"DESCRIPTOR", "XMLNS"};
    }

    public void attachControlsToInstanceData() {
        this.attachControlsToInstanceData(this.instance.getRoot());
    }

    private void attachControlsToInstanceData(TreeElement treeElement) {
        for (int i = 0; i < treeElement.getNumChildren(); ++i) {
            this.attachControlsToInstanceData(treeElement.getChildAt(i));
        }
        IAnswerData iAnswerData = treeElement.getValue();
        Vector vector = null;
        if (iAnswerData instanceof SelectOneData) {
            vector = new Vector();
            vector.addElement(iAnswerData.getValue());
        } else if (iAnswerData instanceof SelectMultiData) {
            vector = (Vector)iAnswerData.getValue();
        }
        if (vector != null) {
            QuestionDef questionDef = FormDef.findQuestionByRef(treeElement.getRef(), this);
            if (questionDef == null) {
                throw new RuntimeException("FormDef.attachControlsToInstanceData: can't find question to link");
            }
            if (questionDef.getDynamicChoices() != null) {
                // empty if block
            }
            for (int i = 0; i < vector.size(); ++i) {
                Selection selection = (Selection)vector.elementAt(i);
                selection.attachChoice(questionDef);
            }
        }
    }

    public static QuestionDef findQuestionByRef(TreeReference treeReference, IFormElement iFormElement) {
        if (iFormElement instanceof FormDef) {
            treeReference = treeReference.genericize();
        }
        if (iFormElement instanceof QuestionDef) {
            QuestionDef questionDef = (QuestionDef)iFormElement;
            TreeReference treeReference2 = FormInstance.unpackReference(questionDef.getBind());
            return treeReference.equals(treeReference2) ? questionDef : null;
        }
        for (int i = 0; i < iFormElement.getChildren().size(); ++i) {
            QuestionDef questionDef = FormDef.findQuestionByRef(treeReference, iFormElement.getChild(i));
            if (questionDef == null) continue;
            return questionDef;
        }
        return null;
    }

    @Override
    public String getAppearanceAttr() {
        throw new RuntimeException("This method call is not relevant for FormDefs getAppearanceAttr ()");
    }

    @Override
    public void setAppearanceAttr(String string) {
        throw new RuntimeException("This method call is not relevant for FormDefs setAppearanceAttr()");
    }

    @Override
    public String getLabelInnerText() {
        return null;
    }

    @Override
    public String getTextID() {
        return null;
    }

    @Override
    public void setTextID(String string) {
        throw new RuntimeException("This method call is not relevant for FormDefs [setTextID()]");
    }

    public void setDefaultSubmission(SubmissionProfile submissionProfile) {
        this.submissionProfiles.put(DEFAULT_SUBMISSION_PROFILE, submissionProfile);
    }

    public void addSubmissionProfile(String string, SubmissionProfile submissionProfile) {
        this.submissionProfiles.put(string, submissionProfile);
    }

    public SubmissionProfile getSubmissionProfile() {
        return this.submissionProfiles.get(DEFAULT_SUBMISSION_PROFILE);
    }
}

