/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xform.parse.XFormParseException;

public class SelectChoice
implements Externalizable,
Localizable {
    private String labelInnerText;
    private String textID;
    private boolean isLocalizable;
    private String value;
    private int index = -1;
    public TreeElement copyNode;

    public SelectChoice() {
    }

    public SelectChoice(String string, String string2) {
        this(string, null, string2, true);
    }

    public SelectChoice(String string, String string2, String string3, boolean bl) {
        this.isLocalizable = bl;
        this.textID = string;
        this.labelInnerText = string2;
        if (string3 == null) {
            throw new XFormParseException("SelectChoice{id,innerText}:{" + string + "," + string2 + "}, has null Value!");
        }
        this.value = string3;
    }

    public SelectChoice(String string, String string2, boolean bl) {
        this(bl ? string : null, bl ? null : string, string2, bl);
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public String getLabelInnerText() {
        return this.labelInnerText;
    }

    public String getValue() {
        return this.value;
    }

    public int getIndex() {
        if (this.index == -1) {
            throw new RuntimeException("trying to access choice index before it has been set!");
        }
        return this.index;
    }

    public void localeChanged(String string, Localizer localizer) {
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.isLocalizable = ExtUtil.readBool(dataInputStream);
        this.setLabelInnerText(ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream)));
        this.setTextID(ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream)));
        this.value = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeBool(dataOutputStream, this.isLocalizable);
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.labelInnerText));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.textID));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.value));
    }

    private void setLabelInnerText(String string) {
        this.labelInnerText = string;
    }

    public Selection selection() {
        return new Selection(this);
    }

    public boolean isLocalizable() {
        return this.isLocalizable;
    }

    public void setLocalizable(boolean bl) {
        this.isLocalizable = bl;
    }

    public String toString() {
        return (this.textID != null && this.textID != "" ? "{" + this.textID + "}" : "") + (this.labelInnerText != null ? this.labelInnerText : "") + " => " + this.value;
    }

    public String getTextID() {
        return this.textID;
    }

    public void setTextID(String string) {
        this.textID = string;
    }
}

