/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.util.Date;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;

public class Recalculate
extends Triggerable {
    public Recalculate() {
    }

    public Recalculate(IConditionExpr iConditionExpr, TreeReference treeReference) {
        super(iConditionExpr, treeReference);
    }

    public Recalculate(IConditionExpr iConditionExpr, TreeReference treeReference, TreeReference treeReference2) {
        super(iConditionExpr, treeReference2);
        this.addTarget(treeReference);
    }

    public Object eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        return this.expr.evalRaw(formInstance, evaluationContext);
    }

    public void apply(TreeReference treeReference, Object object, FormInstance formInstance, FormDef formDef) {
        int n = formDef.getInstance().resolveReference((TreeReference)treeReference).dataType;
        formDef.setAnswer(Recalculate.wrapData(object, n), treeReference);
    }

    public boolean canCascade() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof Recalculate) {
            Recalculate recalculate = (Recalculate)object;
            if (this == recalculate) {
                return true;
            }
            return super.equals(recalculate);
        }
        return false;
    }

    private static IAnswerData wrapData(Object object, int n) {
        if (object instanceof String && ((String)object).length() == 0 || object instanceof Double && ((Double)object).isNaN()) {
            return null;
        }
        if (9 == n || object instanceof Boolean) {
            boolean bl;
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            } else if (object instanceof Double) {
                Double d = (Double)object;
                bl = Math.abs(d) > 1.0E-12 && !Double.isNaN(d);
            } else if (object instanceof String) {
                String string = (String)object;
                bl = string.length() > 0;
            } else {
                throw new RuntimeException("unrecognized data representation while trying to convert to BOOLEAN");
            }
            return new BooleanData(bl);
        }
        if (object instanceof Double) {
            boolean bl;
            double d = (Double)object;
            boolean bl2 = bl = Math.abs(d - (double)((int)d)) < 1.0E-9;
            if (2 == n || bl) {
                return new IntegerData((int)d);
            }
            return new DecimalData(d);
        }
        if (object instanceof String) {
            return new StringData((String)object);
        }
        if (object instanceof Date) {
            return n == 6 ? new DateTimeData((Date)object) : new DateData((Date)object);
        }
        throw new RuntimeException("unrecognized data type in 'calculate' expression: " + object.getClass().getName());
    }
}

