/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public abstract class Triggerable
implements Externalizable {
    public IConditionExpr expr;
    public Vector targets;
    public TreeReference contextRef;

    public Triggerable() {
    }

    public Triggerable(IConditionExpr iConditionExpr, TreeReference treeReference) {
        this.expr = iConditionExpr;
        this.contextRef = treeReference;
        this.targets = new Vector();
    }

    protected abstract Object eval(FormInstance var1, EvaluationContext var2);

    protected abstract void apply(TreeReference var1, Object var2, FormInstance var3, FormDef var4);

    public abstract boolean canCascade();

    public void apply(FormInstance formInstance, EvaluationContext evaluationContext, FormDef formDef) {
        Object object = this.eval(formInstance, evaluationContext);
        for (int i = 0; i < this.targets.size(); ++i) {
            TreeReference treeReference = ((TreeReference)this.targets.elementAt(i)).contextualize(evaluationContext.getContextRef());
            Vector vector = formInstance.expandReference(treeReference);
            for (int j = 0; j < vector.size(); ++j) {
                TreeReference treeReference2 = (TreeReference)vector.elementAt(j);
                this.apply(treeReference2, object, formInstance, formDef);
            }
        }
    }

    public void addTarget(TreeReference treeReference) {
        if (this.targets.indexOf(treeReference) == -1) {
            this.targets.addElement(treeReference);
        }
    }

    public Vector getTargets() {
        return this.targets;
    }

    public Vector getTriggers() {
        Vector vector = this.expr.getTriggers();
        Vector<TreeReference> vector2 = new Vector<TreeReference>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(((TreeReference)vector.elementAt(i)).anchor(this.contextRef));
        }
        return vector2;
    }

    public boolean equals(Object object) {
        if (object instanceof Triggerable) {
            Triggerable triggerable = (Triggerable)object;
            if (this == triggerable) {
                return true;
            }
            if (this.expr.equals(triggerable.expr)) {
                Vector vector = this.getTriggers();
                Vector vector2 = triggerable.getTriggers();
                for (int i = 0; i < 2; ++i) {
                    Vector vector3 = i == 0 ? vector : vector2;
                    Vector vector4 = i == 0 ? vector2 : vector;
                    for (int j = 0; j < vector3.size(); ++j) {
                        if (vector4.indexOf(vector3.elementAt(j)) != -1) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.expr = (IConditionExpr)ExtUtil.read(dataInputStream, new ExtWrapTagged(), prototypeFactory);
        this.contextRef = (TreeReference)ExtUtil.read(dataInputStream, TreeReference.class, prototypeFactory);
        this.targets = (Vector)ExtUtil.read(dataInputStream, new ExtWrapList(TreeReference.class), prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.write(dataOutputStream, new ExtWrapTagged(this.expr));
        ExtUtil.write(dataOutputStream, this.contextRef);
        ExtUtil.write(dataOutputStream, new ExtWrapList(this.targets));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.targets.size(); ++i) {
            stringBuffer.append(((TreeReference)this.targets.elementAt(i)).toString());
            if (i >= this.targets.size() - 1) continue;
            stringBuffer.append(",");
        }
        return "trig[expr:" + this.expr.toString() + ";targets[" + stringBuffer.toString() + "]]";
    }
}

