/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class BooleanData
implements IAnswerData {
    boolean data;

    public BooleanData() {
    }

    public BooleanData(boolean bl) {
        this.data = bl;
    }

    public IAnswerData clone() {
        return new BooleanData(this.data);
    }

    public String getDisplayText() {
        if (this.data) {
            return "True";
        }
        return "False";
    }

    public Object getValue() {
        return new Boolean(this.data);
    }

    public void setValue(Object object) {
        this.data = (Boolean)object;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.data = dataInputStream.readBoolean();
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(this.data);
    }

    public UncastData uncast() {
        return new UncastData(this.data ? "1" : "0");
    }

    public BooleanData cast(UncastData uncastData) throws IllegalArgumentException {
        if ("1".equals(uncastData)) {
            return new BooleanData(true);
        }
        if ("0".equals(uncastData)) {
            return new BooleanData(false);
        }
        throw new IllegalArgumentException("Invalid cast of data [" + uncastData.value + "] to type Boolean");
    }
}

