/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class DateTimeData
implements IAnswerData {
    Date d;

    public DateTimeData() {
    }

    public DateTimeData(Date date) {
        this.setValue(date);
    }

    public IAnswerData clone() {
        return new DateTimeData(new Date(this.d.getTime()));
    }

    public void setValue(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.d = new Date(((Date)object).getTime());
    }

    public Object getValue() {
        return new Date(this.d.getTime());
    }

    public String getDisplayText() {
        return DateUtils.formatDateTime(this.d, 2);
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.setValue(ExtUtil.readDate(dataInputStream));
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeDate(dataOutputStream, this.d);
    }

    public UncastData uncast() {
        return new UncastData(DateUtils.formatDateTime(this.d, 1));
    }

    public DateTimeData cast(UncastData uncastData) throws IllegalArgumentException {
        Date date = DateUtils.parseDateTime(uncastData.value);
        if (date != null) {
            return new DateTimeData(date);
        }
        throw new IllegalArgumentException("Invalid cast of data [" + uncastData.value + "] to type DateTime");
    }
}

