/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class DecimalData
implements IAnswerData {
    double d;

    public DecimalData() {
    }

    public DecimalData(double d) {
        this.d = d;
    }

    public DecimalData(Double d) {
        this.setValue(d);
    }

    public IAnswerData clone() {
        return new DecimalData(this.d);
    }

    public String getDisplayText() {
        return String.valueOf(this.d);
    }

    public Object getValue() {
        return new Double(this.d);
    }

    public void setValue(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.d = (Double)object;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.d = ExtUtil.readDecimal(dataInputStream);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeDecimal(dataOutputStream, this.d);
    }

    public UncastData uncast() {
        return new UncastData(((Double)this.getValue()).toString());
    }

    public DecimalData cast(UncastData uncastData) throws IllegalArgumentException {
        try {
            return new DecimalData(Double.parseDouble(uncastData.value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid cast of data [" + uncastData.value + "] to type Decimal");
        }
    }
}

