/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class IntegerData
implements IAnswerData {
    int n;

    public IntegerData() {
    }

    public IntegerData(int n) {
        this.n = n;
    }

    public IntegerData(Integer n) {
        this.setValue(n);
    }

    public IAnswerData clone() {
        return new IntegerData(this.n);
    }

    public String getDisplayText() {
        return String.valueOf(this.n);
    }

    public Object getValue() {
        return new Integer(this.n);
    }

    public void setValue(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.n = (Integer)object;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.n = ExtUtil.readInt(dataInputStream);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.n);
    }

    public UncastData uncast() {
        return new UncastData(new Integer(this.n).toString());
    }

    public IntegerData cast(UncastData uncastData) throws IllegalArgumentException {
        try {
            return new IntegerData(Integer.parseInt(uncastData.value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid cast of data [" + uncastData.value + "] to type Decimal");
        }
    }
}

