/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class SelectMultiData
implements IAnswerData {
    Vector vs;

    public SelectMultiData() {
    }

    public SelectMultiData(Vector vector) {
        this.setValue(vector);
    }

    public IAnswerData clone() {
        Vector<Selection> vector = new Vector<Selection>();
        for (int i = 0; i < this.vs.size(); ++i) {
            vector.addElement(((Selection)this.vs.elementAt(i)).clone());
        }
        return new SelectMultiData(vector);
    }

    public void setValue(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.vs = this.vectorCopy((Vector)object);
    }

    public Object getValue() {
        return this.vectorCopy(this.vs);
    }

    private Vector vectorCopy(Vector vector) {
        Vector<Selection> vector2 = new Vector<Selection>();
        for (int i = 0; i < vector.size(); ++i) {
            Selection selection = (Selection)vector.elementAt(i);
            vector2.addElement(selection);
        }
        return vector2;
    }

    public String getDisplayText() {
        String string = "";
        for (int i = 0; i < this.vs.size(); ++i) {
            Selection selection = (Selection)this.vs.elementAt(i);
            string = string + selection.getValue();
            if (i >= this.vs.size() - 1) continue;
            string = string + ", ";
        }
        return string;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.vs = (Vector)ExtUtil.read(dataInputStream, new ExtWrapList(Selection.class), prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.write(dataOutputStream, new ExtWrapList(this.vs));
    }

    public UncastData uncast() {
        Enumeration enumeration = this.vs.elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Selection selection = (Selection)enumeration.nextElement();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(selection.getValue());
        }
        return new UncastData(stringBuffer.toString());
    }

    public SelectMultiData cast(UncastData uncastData) throws IllegalArgumentException {
        Vector<Selection> vector = new Vector<Selection>();
        Vector vector2 = DateUtils.split(uncastData.value, " ", true);
        for (String string : vector2) {
            vector.addElement(new Selection(string));
        }
        return new SelectMultiData(vector);
    }
}

