/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data.helper;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class Selection
implements Externalizable {
    public String xmlValue = null;
    public int index = -1;
    public SelectChoice choice;

    public Selection() {
    }

    public Selection(SelectChoice selectChoice) {
        this.attachChoice(selectChoice);
    }

    public Selection(String string) {
        this.xmlValue = string;
    }

    public Selection(int n) {
        this.index = n;
    }

    public Selection clone() {
        Selection selection = new Selection();
        selection.choice = this.choice;
        selection.xmlValue = this.xmlValue;
        selection.index = this.index;
        return selection;
    }

    public void attachChoice(SelectChoice selectChoice) {
        this.choice = selectChoice;
        this.xmlValue = selectChoice.getValue();
        this.index = selectChoice.getIndex();
    }

    public void attachChoice(QuestionDef questionDef) {
        if (questionDef.getDynamicChoices() != null) {
            return;
        }
        SelectChoice selectChoice = null;
        if (this.index != -1 && this.index < questionDef.getNumChoices()) {
            selectChoice = questionDef.getChoice(this.index);
        } else if (this.xmlValue != null && this.xmlValue.length() > 0) {
            selectChoice = questionDef.getChoiceForValue(this.xmlValue);
        }
        if (selectChoice == null) {
            throw new RuntimeException("insufficient data in selection to reconstruct");
        }
        this.attachChoice(selectChoice);
    }

    public String getValue() {
        if (this.xmlValue != null && this.xmlValue.length() > 0) {
            return this.xmlValue;
        }
        throw new RuntimeException("don't know xml value! perhaps selection was stored as index only and has not yet been linked up to a formdef?");
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.xmlValue = ExtUtil.readString(dataInputStream);
        this.index = ExtUtil.readInt(dataInputStream);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeString(dataOutputStream, this.getValue());
        ExtUtil.writeNumeric(dataOutputStream, this.index);
    }
}

